/*
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "GroupObject.hh"
#include "ObjectVisitor.hh"
#include "ScopedHandler.hh"
#include "ObjectTypes.hh"


using namespace peekabot;


HandlerInformer GroupObject::ms_handler_informer(
    "group",
    &GroupObject::start_handler);


GroupObject::GroupObject() throw()
    : SceneObject("group")
{
}


GroupObject::GroupObject(ScopedHandler* handler) throw()
    : SceneObject("group", handler)
{
}



void GroupObject::accept(ObjectVisitor* visitor) throw()
{
    visitor->visit(this);
}


ObjectType GroupObject::get_object_type() const
{
    return GROUP_OBJECT;
}


void GroupObject::start_handler(
    const std::string & name,
    ScopedHandler::AttributeMap &attributes,
    ScopedHandler *handler) throw()
{
    // Creating a scene object by passing a ScopedHandler will cause it to
    // enter a new scope with all registered tag start handlers plus any
    // specific handlers for SceneObject properties which are registered
    // by the parent constructor.
    SceneObject* tmp = new GroupObject(handler);

    // Set the new object as the current object
    ScopedMap & variables = handler->get_variables();
    variables.push_variable("current_object", tmp);
}
