/*
 * Copyright Staffan Gimåker 2006-2010.
 *
 * ---
 *
 * Distributed under the Boost Software License, Version 1.0.
 * (See accompanying file LICENSE_1_0.txt or copy at
 * http://www.boost.org/LICENSE_1_0.txt)
 */

/**
 * \file Contains definitions for global constants.
 */

#include <boost/cstdint.hpp>

#include "Protocol.hh"
#include "Types.hh"

using namespace peekabot;


// -------------- Protocol.hh --------------


/**
 * \brief The peekabot network transport protocol version.
 */
const boost::uint32_t peekabot::protocol::PROTOCOL_VERSION = 4;


/**
 * \brief The unique ID sent at the beginning of authentication requests.
 */
const boost::uint32_t peekabot::protocol::UNIQUE_ID = 0x7065656B;

/**
 * \brief Authentication timeout length in milliseconds.
 */
const unsigned int peekabot::protocol::AUTHENTICATION_TIMEOUT = 10000;


// ------------- Types.hh --------------


/**
 *\brief Constant setting the number of visibility layers supported.
 */
const boost::uint32_t peekabot::NUMBER_OF_LAYERS = 10;
