/*
 * Copyright Staffan Gimåker 2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PEEKABOT_ACTION_SOURCE_HH_INCLUDED
#define PEEKABOT_ACTION_SOURCE_HH_INCLUDED


#include "Types.hh"

#include <list>
#include <boost/bimap.hpp>
#include <boost/shared_ptr.hpp>
#include <boost/filesystem/path.hpp>


namespace peekabot
{
    class Path;
    class UploadCache;
    class Config;
    class Action;

    class ActionSource
    {
    public:
        void add_pseudonym(ObjectID pseudo_id, ObjectID real_id);

        void remove_pseudonym(ObjectID pseudo_id);

        ObjectID pseudonym_to_real(ObjectID pseudo_id);

        ObjectID real_to_pseudonym(ObjectID real_id);

        boost::shared_ptr<UploadCache> get_upload_cache();

        void append_search_dir(const boost::filesystem::path &dir);

        void prepend_search_dir(const boost::filesystem::path &dir);

        const std::list<boost::filesystem::path> &get_search_dirs() const;

        Path make_data_path(const std::string &path) const;

        virtual void send_response(const boost::shared_ptr<Action> &action) = 0;

    protected:
        ActionSource(const Config &config);

    private:
        typedef boost::bimap<ObjectID, ObjectID> PseudonymBimap;
        PseudonymBimap m_pseudonyms;

        boost::shared_ptr<UploadCache> m_upload_cache;

        std::list<boost::filesystem::path> m_search_dirs;
    };
}


#endif // PEEKABOT_ACTION_SOURCE_HH_INCLUDED
