/*
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

namespace peekabot {

/**

\page manual_primitives Object overview

\section manual_primitives_basic Spheres, cylinders, cubes, circles, polygons and polylines

\image html basic_primitives.png
\image latex basic_primitives.eps

General purpose visualization primitives that can be used for a variety of 
visualization tasks.

The radius of spheres, cylinders and circles is 1 m, unless scaled otherwise. 
The height of cylinders and the sides of cubes are also 1 m by default.

Spheres, cylinders and circles are equipped with automatic level-of-detail (LOD)
handling to yield better performance without lost aesthetics.

Currently, polygons are always filled and circles always non-filled. If you
need an unfilled polygon, use a polyline.

\par Client API:
  \ref peekabot::client::SphereProxy "SphereProxy",
  \ref peekabot::client::CylinderProxy "CylinderProxy",
  \ref peekabot::client::CubeProxy "CubeProxy",
  \ref peekabot::client::CircleProxy "CircleProxy",
  \ref peekabot::client::PolygonProxy "PolygonProxy"
  \ref peekabot::client::PolylineProxy "PolylineProxy"

\par Definition file syntax:
  \ref manual_scenedef_primitives1 and \ref manual_scenedef_primitives2


\section manual_primitives_clouds Point and line clouds

\image html clouds.png
\image latex clouds.eps

Point and line clouds are used to represent one or more points or lines 
respectively. All points/lines contained in the cloud share the common 
properties such as color, opacity and in which coordinate system they 
are specifiecd.

A typical usage scenario is to use point/line clouds to visualize particle 
fitlers or sensor measurements.

The cloud primitives are very efficient at representing large sets, but to
achieve the best performance, clusters that are very disjoint in space should
be represented by separate clouds. 
For example, if you have 100 robots doing localization using particle filters 
in a huge environment you'd benefit from visualizing their particles using 
one point cloud per robot, rather than just one.

\par Client API:
  \ref peekabot::client::PointCloudProxy "PointCloudProxy",
  \ref peekabot::client::LineCloudProxy "LineCloudProxy"

\par Definition file syntax:
  \ref manual_scenedef_primitives2



\section manual_primitives_tri_mesh Tri-meshes

\image html tri_mesh.png
\image latex tri_mesh.eps

Tri-meshes are triangle analogue to the point and line clouds. Tri-meshes
are useful for efficient visualization of complex shapes or many small objects,
e.g. all the walls extracted from a SLAM filter.

The tri-meshes is represented by a sequence of vertices and a sequence of
index triplets specifying which vertices form triangles.

Currently, there is no support for per-vertex coloring or texturing of
tri-meshes. The opacity is shared by all triangles in the tri-mesh.

\par Client API:
  \ref peekabot::client::TriMeshProxy "TriMeshProxy",
  \ref peekabot::client::TriMeshProxy "TriMeshProxy"

\par Definition file syntax:
  \ref manual_scenedef_tri_mesh



\section manual_primitives_grid Grids

\image html grid_types.png
\image latex grid_types.eps

There are three different kind of grids: regular, radial and angular grids, 
all depicted above. Although there are three types of grids, there's only one 
grid primitive, which has a setting for configuring the type.

For radial and regular grids, the size of the segments in the grid is 
determined by the object's scale.

\par Client API:
  \ref peekabot::client::GridProxy "GridProxy"

\par Definition file syntax:
  \ref manual_scenedef_grid




\section manual_primitives_camera Cameras

\image html camera.png
\image latex camera.eps

Every view in the peekabot server is rendered through a camera object, and 
different views can use different cameras. Having cameras as first class objects
allows cameras to be attached to e.g. robots and move around with them as they
are moved.

The FOV of the camera is depicted by the pyramid, and the focus point of the 
camera is shown by the dashed line.

\par Client API:
  \ref peekabot::client::CameraProxy "CameraProxy"

\par Definition file syntax:
  \ref manual_scenedef_camera



\section manual_primitives_model Models

\image html models.png
\image latex models.eps

Models provide a way to show complex objects that aren't easy to represent
using any other type of primitive. Models are currently the only primitive that
can be textured.

\par Client API:
  \ref peekabot::client::ModelProxy "ModelProxy"

\par Definition file syntax:
  \ref manual_scenedef_model

See the section on \ref manual_model_conversion for documentation on which
file formats are supported and how to convert your models into a suitable
format.





\section manual_primitives_occupancy_grid Occupancy grids

\image html 2d_occupancy_grid.png
\image latex 2d_occupancy_grid.eps

The occupancy grid primitive provides a convinient and efficient way for 
visualizing 2D occupancy grids. The storage is sparse: unused cells require no 
memory and adjacent cells with the same occupancy value are merged and stored 
as big cells.

Cells about which nothing is known are drawn transparent. The color used to
draw other cells is linearly interpolated between a per instance configurable
unoccupied and occupied color.

\par Client API:
  \ref peekabot::client::OccupancyGrid2DProxy "OccupancyGrid2D"

\par Definition file syntax:
  Occupancy grids cannot currently be specified in scene or robot definition 
  files.



\section manual_primitives_joints Hinges and sliders

If your robot is equipped with a manipulator or similar device, peekabot's
joint constructs provide a nice interface for updating its degrees of 
freedoms (DOFs).
Translating and rotating the manipulator's parts manually is normally both 
harder and more error prone than delegating the task to peekabot.

A joint object affects all of its children according to its set joint value,
either by rotating (hinge) or translating (slider) them.

\par Client API:
  \ref peekabot::client::JointProxy "JointProxy",
  \ref peekabot::client::JointProxy "HingeProxy",
  \ref peekabot::client::JointProxy "SliderProxy"

\par Definition file syntax:
  \ref manual_scenedef_joints,
  \ref manual_scenedef_hinge,
  \ref manual_scenedef_slider


\section manual_primitives_label Text labels

\image html label.png
\image latex label.eps

Text labels provide orientable, scalable text annotations. Useful for 
annotating maps etc.

Currently only one font is supported, a serif font.

\par Client API:
  \ref peekabot::client::LabelProxy "LabelProxy"

\par Definition file syntax:
  \ref manual_scenedef_label


*/


}

