/*
 * Copyright Staffan Gimåker 2007-2010.
 *
 * ---
 *
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

namespace peekabot {

/**
 * \page manual_installation Installation
 *
 * \note <em>The manual covers only installation from source.</em>
 *
 * peekabot is divided into two distinct parts: the server and the client API.
 * Both are built by default but you can disable building of either by
 * configuring with \c --disable-server and \c --disable-client-lib
 * respectively. Building only the client requires fewer dependencies.
 *
 * Before starting the installation, make sure your system has all the
 * dependencies listed below installed:
 *
 * <ul>
 *   <li>A decently recent version of <a href="http://gcc.gnu.org">GCC</a></li>
 *   <li><a href="http://www.boost.org/">Boost 1.39 or later</a>
 *     <ul>
 *       <li>Boost.Thread</li>
 *       <li>Boost.DateTime</li>
 *       <li>Boost.Filesystem*</li>
 *       <li>Boost.ProgramOptions*</li>
 *       <li>(Boost.Test**)</li>
 *     </ul>
 *   </li>
 *   <li><a href="http://xerces.apache.org/xerces-c/">Xerces-C++ 2.7.0* or later</a></li>
 *   <li><a href="http://www.gtkmm.org/">gtkmm</a>*</li>
 *   <li><a href="http://projects.gnome.org/gtkglext/">gtkglextmm</a>*</li>
 *   <li>OpenGL and GLU development files*</li>
 *   <li><a href="http://www.freetype.org/">FreeType</a>*</li>
 *   <li>pkg-config</li>
 * </ul>
 *
 * \par
 * * Not required when building only the client API.
 * ** Only needed if building the unit tests (disabled by default).
 *
 * All set and ready to continue? Good.
 * 
 * peekabot leverages GNU Autoconf and friends for building - if you've ever 
 * used open source software on a unix you're probably already familiar with 
 * them. The usual \c ./configure, \c make, <tt>make install</tt>-ritual usually
 * does the trick:
 *
 * \verbatim
$ tar xvzpf peekabot-x.y.z.tar.gz 
$ cd peekabot-x.y.z
$ ./configure
$ make
$ make install (as root!) \endverbatim
 *
 * If everything went according to plan, you should be able to start the 
 * peekabot server by typing \c peekabot in your terminal.
 *
 * \note If you want to build the included examples, configure with the 
 * \c --enable-examples flag.
 *
 * \note If configuring fails, <tt>./configure --help</tt> lists options
 * that you might be able to use to solve your problem.
 *
 * \ref manual_tutorial "Continue to the tutorial..."
 */

}
