/*
 * This file is part of peekabot.
 *
 * peekabot is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * peekabot is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

namespace peekabot {

/**

\page manual_configuration Configuration options

Configuration of the peekabot server is done using the file
\c ~/.peekabot/peekabot.conf (again, on Windows, the \c .peekabot directory is
located in your Application Data directory).


The configuration uses INI-like syntax, as illustrated below. Versions prior
to 0.6.0 used an XML-formatted configuration file, \c config.xml.

\code
[section-name]

# A comment
option-name = option-value

[other-section]

; Alternate comment syntax
a-multi-value-option = separate, multiple, values, with, commas

# Booleans accept a few different, equivalent values
bool1 = 0
bool2 = false
bool3 = on
bool4 = enable

# Colors are defined as a comma separated RGB triplets, with components
# in the 0-1 range.
color1 = 1,1,1   # White
color2 = 1, 0, 0 # Red
\endcode

Below, the option's type is shown in parentheses after the option name.


\section manual_configuration_resources [resources]


\par share_path (path)
The directory where peekabot essential resources can be found - icons,
schemas, etc.
\par
<em>Default:</em> \c $pkgdatadir

\par data_paths (paths)
The directories in which peekabot looks for scenes, models and textures in
addition to the global (/usr/share/peekabot/data/ or similar)
and user local paths (~/.peekabot/data/). User local paths have the highest
priority, and global paths the least. Paths added with this option fall in
between.
\par
<em>Default:</em> Empty

\par snapshot_path (path)
The directory where peekabot saves snapshots and snapshot sequences.
\par
<em>Default:</em> \c ~/.peekabot/snapshots/


\section manual_configuration_gui [gui]

\par max_fps (float)
The maximum number of times per second the scene frames are redrawn.
\par
<em>Default:</em> 40

\par update_freq (float)
The maximum frequency in which the GUI is updated in, e.g. how often the
properties in the side bar are updated.
\par
<em>Default:</em> 10

\par background_color (color)
The background color of scene frames.
\par
<em>Default:</em> 1, 1, 1

\par selected_color (color)
The color used to draw the outlines for selected objects.
\par
<em>Default:</em> 0, 0.3, 1

\par ancestor_selected_color (color)
The color used to draw the outlines for objects which have a selected
ancestor but are not selected themselves.
\par
<em>Default:</em> 0.5, 0.75, 1


\section manual_configuration_network [network]

\par listen_port (int)
The port on which peekabot, by default, listens for incoming client 
connections.
\par
<em>Default:</em> 5050


\section manual_configuration_renderer [renderer]

\par disable_vbos (bool)
Forcefully disable the use of Vertex Buffer Objects (VBOs).
VBOs can cause problems with certain hardware and drivers.
\par
<em>Default:</em> \c false


\section manual_configuration_debug [debug]

\par debug_log (bool)
If true, debug messages will be written to \c ~/.peekabot/debug.log.
\par
<em>Default:</em> \c false

*/

}
