<?php
/*
Shows a basic example of parsing an XML data set of the type generated by
phpMyAdmin into an HTML table
*/
# require_once 'XML/SaxFilters.php'; // This is the normal way to do it

# Done to help development
if ( !@include_once 'XML/SaxFilters.php' ) {
    define('XML_SAXFILTERS', '../../');
    include_once XML_SAXFILTERS . 'SaxFilters.php';
}

//----------------------------------------------------------------------------
/**
 * Filter for converting an XML data set to HTML
 * @access public
 */
class DataSetFilter extends XML_SaxFilters_AbstractFilter
/* implements XML_SaxFilters_FilterInterface */
{
    /**
    * Name for output file
    */
    var $outfile;
    
    /**
     * Switch to determine if we're in a dataset row
     * @var boolean
     */
    var $inRow = false;

    /**
     * The current column name
     * @var string
     */
    var $column = '';

    /**
     * Array of data from a row
     * @var array
     */
    var $row;
    
    function DataSetFilter($outfile) {
        $this->outfile = $outfile;
    }
    
    /**
    * Start of parsing
    */
    function startDoc() {
        // Include the writer output class
        require_once(XML_SAXFILTERS.'SaxFilters/IO/FileWriter.php');    
        
        // Instantiate the FileWriter
        $writer = & new XML_SaxFilters_IO_FileWriter($this->outfile);
        
        // Set the writer that the filter will use
        $this->setWriter($writer);
        
        // Write some data
        $writer->write("<table>\n");
        $writer->write("  <caption>The Found Fathers</caption>\n");
        $writer->write("  <tr>\n");
        $writer->write("    <th>First Name</th>\n    <th>Last Name</th>\n");
        $writer->write("  </tr>\n");    
    }

    /**
     * Start Element Handler
     */
    function open(& $name,& $attribs)
    {
        if ( $name == 'founding_fathers' )
        {
            $this->inRow = true;
            $this->writer->write("  <tr>\n");
        }
        else if ( $this->inRow )
        {
            $this->column = $name;
        }
    }

    /**
     * End Element Handler
     */
    function close(& $name)
    {
        if ( $name == 'founding_fathers' )
        {
            $this->inRow = false;
            $this->writer->write("  </tr>\n");
        }
        else if ( $this->inRow )
        {
            $this->column = '';
        }
    }

    /**
     * Character Data Handler
     */
    function data(& $data)
    {
        if ( $this->inRow )
        {
            switch ( $this->column ) {
                case 'first':
                case 'last':
                    $this->writer->write("    <td>".$data."</td>\n");
                break;
            }
        }
    }
    
    /**
    * End of parsing
    */
    function endDoc() {
        // Finish writing
        $this->writer->write("</table>\n");
        $this->writer->close();
    }
}
//----------------------------------------------------------------------------

// Create ExpatParser, telling it to use a File stream on founding_fathers.xml
$parser = & XML_SaxFilters_createParser('Expat','File','founding_fathers.xml');

// Assign the DataSetFilter to the parser
$parser->setChild(new DataSetFilter('founding_fathers.html'));

// Parse the XML document
$parser->parse();

// Display the written file
readfile('founding_fathers.html');
?>