<?php
/**
 * FIT Example Music
 * 
 * $Id: Music.php 6 2007-06-06 07:37:36Z gerd $
 * 
 * @author gERD Schaufelberger <gerd@php-tools.net>
 * @package FIT
 * @subpackage Fixture
 * @license LGPL http://www.gnu.org/copyleft/lesser.html
 */

/**
 * FIT Example Music
 * 
 * Simple entry of music
 * 
 * @version 0.1.0
 * @package FIT
 * @subpackage example
 */
class Music 
{
   /**
    * current status
    * @var string
    */
    public static $status   = 'ready';

   /**
    * track title
    * @var string
    */
    public $title;
    
   /**
    * track's artist
    * @var string
    */
    public $artist;
    
   /**
    * album name
    * @var string
    */
    public $album;
    
   /**
    * track's genre
    * @var string
    */
    public $genre;
    
   /**
    * track's size
    * @var string
    */
    public $size;
    
   /**
    * track's length in seconds
    * @var string
    */
    public $seconds;
    
   /**
    * track no
    * @var string
    */
    public $trackNumber;
    
   /**
    * total no of tracks
    * @var string
    */
    public $trackCount;
    
   /**
    * track's release date (year)
    * @var string
    */
    public $year;
    
   /**
    * track's release data
    * @var string
    */
    public $date;
    
   /**
    * tells whether this track is selected or not
    * @var bool
    */
    public $selected = false;

   /**
    * receive track number as shown on display
    * 
    * e.g. "5 of 10"
    * 
    * @return string 
    */
    public function track() 
    {
        return $this->trackNumber . ' of ' . $this->trackCount;
    }

   /**
    * plaing time
    * 
    * @return float
    */
    public function time() 
    {
        return round( $this->seconds / 0.6 ) / 100.0;
    }


   /**
    * Convert raw, string data to internal structure
    *` 
    * Actually, explode a TAB-separated string of well-known format and return 
    * the so parsed record.
    *
    * @param string $line tab separated list hodling one set of data
    * @return music object
    */    
    public static function parse( $line )
    {
        $t = split( "\t", $line );
        return self::map( $t );
    }
    
   /**
    * Convert index data to internal structure
    *` 
    * The given list will be transformed to public member variables
    *
    * @param array $list
    * @return music object
    */    
	public static function map( $list ) 
    {
		$m  =   new Music();        
		
		$m->title       = $t[0];
		$m->artist      = $t[1];
		$m->album       = $t[2];
		$m->genre       = $t[3];
		$m->size        = $t[4];
		$m->seconds     = $t[5];
		$m->trackNumber = $t[6];
		$m->trackCount  = $t[7];
		$m->year        = $t[8];
		$m->date        = $t[9];
		
		return $m;		 	
	}
}
?>
