<?php
/**
 * FIT Fixture
 * 
 * $Id: Browser.php 12 2007-08-12 18:34:25Z gerd $
 * 
 * @author gERD Schaufelberger <gerd@php-tools.net>
 * @package FIT
 * @subpackage example
 * @license LGPL http://www.gnu.org/copyleft/lesser.html
 */
 
/**
 * MusicLibrary is required
 */ 
require_once dirname( __FILE__ ) . '/MusicLibrary.php';

/**
 * FIT Fixture
 *
 * Music browser  
 * 
 * @version 0.1.0
 * @package FIT
 * @subpackage example
 */
class Music_Browser extends Testing_FIT_Fixture 
{

   /**
    * type dictionary
    * @var array
    */
    protected $_typeDictionary = array(
                                'totalSongs()'  => 'integer',
                                'title()'       => 'string',
                                'artist()'      => 'string',
                                'album()'       => 'string',  
                                'year()'        => 'string',   
                                'time()'        => 'float',   
                                'track()'       => 'string'
                            );


   /**
    * load the library
    * 
	* @param string path
    * @return bool true on success   
	*/
	public function library( $path ) 
    {
		MusicLibrary::load( $path );
        return true;      
	}

   /**
    * how many songs are in the library
    * 
    * @return int number of songs
    */
	public function totalSongs() 
    {
		return MusicLibrary::count();
	}


   /**
    * select a song
    * 
    * @param int $pos
    * @param bool true on success
    */
	public function select( $pos ) 
    {
        return MusicLibrary::select( $pos );
	}

   /**
    * receive current title
    * 
    * @param string song's title
    */
	public function title() 
    {
		return MusicLibrary::title();
	}
	
   /**
    * receive current sont's artist
    * 
    * @param string song's artist
    */
	public function artist() 
    {
		return MusicLibrary::artist();
	}
	
   /**
    * receive current song's album
    * 
    * @param string song's album
    */
	public function album() 
    {
		return MusicLibrary::album();
	}
	
   /**
    * receive current song's genre
    * 
    * @param string song's genre
    */
    public function genre() 
    {
        return MusicLibrary::genre();
    }
    
   /**
    * receive current song's file size
    * 
    * @param string song's file size
    */
    public function size() 
    {
        return MusicLibrary::size();
    }
    
   /**
    * receive current song's release year
    * 
    * @param int 
    */
	public function year() 
    {
		return MusicLibrary::year();
	}

   /**
    * receive current song's playing time
    * 
    * @param float
    */
	public function time() 
    {
		return MusicLibrary::time();
	}
    	
   /**
    * receive current track no
    * 
    * @param int
    */
	public function track() 
    {
		return MusicLibrary::track();
	}
}
?>