<?php
/**
 * FIT Examples
 * 
 * $Id: ArithmeticFixture.php 12 2007-08-12 18:34:25Z gerd $
 * 
 * These examples are derived from http://fit.c2.com/ 
 * 
 * @author gERD Schaufelberger <gerd@php-tools.net>
 * @package FIT
 * @subpackage Example
 * @license LGPL http://www.gnu.org/copyleft/lesser.html
 */

/**
 * Load basic fixture: Column and HelloWorld 
 */
Testing_FIT_Loader::loadClass( 
            'Testing_FIT_Fixture'
            , 'Testing_FIT_Fixture_Primitive'
            );

/**
 * FIT Examples
 * 
 * @version 0.1.1
 * @package FIT
 * @subpackage Example
 */
class Math_ArithmeticFixture extends Testing_FIT_Fixture_Primitive 
{
	private $x = 0;
	private $y = 0;
    
   /**
    * iterate through rows but skip the first one
    * 
    * @param Parse $rows
    * @see doRow()
    * @return boolean true on success
    */
    public function doRows( Testing_FIT_Node $node ) 
    {
        // start at second - the first simply contains the fixture with parameter
        $node->next();
        return parent::doRows( $node );
    }   

   /**
    * process a single cell
    *
    * As this is a primitve fixture, it knows exactly what to do
    * 
    * @param object $cell A parse object 
    * @return boolean true on success
    */
    public function doCell( Testing_FIT_Node $node  ) {
    
        switch( $node->key() ) {
            case 0:
                $this->x = intval( $node->cData );
                break;
            case 1:
                $this->y = intval( $node->cData );
                break;
            case 2:
                $this->_checkCell( $node, $this->x + $this->y ); break;
                break;
            case 3:
                $this->_checkCell( $node, $this->x - $this->y ); break;
                break;
            case 4:
                $this->_checkCell( $node, $this->x * $this->y ); break;
                break;
            case 5:
                if( $this->y == 0 ) {
                    throw new Exception( 'ArithmeticException: / by zero' );
                }               
                $this->_checkCell( $node, $this->x / $this->y ); break;
                break;
                
            default:
                break;
        }
        
        return true;
    }

}

?>
