<?php
/**
 * Services_Yahoo Test Suite
 *
 * Copyright 2005-2006 Martin Jansen
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @package    Services_Yahoo
 * @author     Martin Jansen <mj@php.net>
 * @copyright  2005-2006 Martin Jansen
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License, Version 2.0
 * @version    CVS: $Id: All.php,v 1.2 2006/10/04 16:34:05 mj Exp $
 * @link       http://pear.php.net/package/Services_Yahoo
 */

if (!defined("PHPUnit_MAIN_METHOD")) {
    define("PHPUnit_MAIN_NETHOD", "Services_Yahoo_Tests_All::main");
}

require_once "PHPUnit/Framework/TestSuite.php";
require_once "PHPUnit/TextUI/TestRunner.php";

require_once "Services/Yahoo/Tests/Search.php";
require_once "Services/Yahoo/Tests/Exception.php";

/**
 * @category   Services
 * @package    Services_Yahoo
 * @author     Martin Jansen <mj@php.net>
 * @copyright  2005-2006 Martin Jansen
 * @license    http://www.apache.org/licenses/LICENSE-2.0  Apache License, Version 2.0
 * @version    CVS: $Id: All.php,v 1.2 2006/10/04 16:34:05 mj Exp $
 */
class Services_Yahoo_Tests_All {
    public static function main()
    {
        PHPUnit_TextUI_TestRunner::run(self::suite());
    }

    public static function suite()
    {
        $suite = new PHPUnit_Framework_testSuite("Services_Yahoo");

        $suite->addTestSuite("Services_Yahoo_Tests_Search");
        $suite->addTestSuite("Services_Yahoo_Tests_Exception");

        return $suite;
    }
}

if (PHPUnit_MAIN_METHOD == "Services_Yahoo_Tests_All::main") {
    Services_Yahoo_Tests_All::main();
}
