<?php
/**
* Example for Services_SharedBook usage
*
* PHP version 5
*
* @category Services
* @package  Services_SharedBook
* @author   Alex Lavrov <sharedbook.php@gmail.com>
* @license  http://www.php.net/license/3_0.txt  PHP License 3.0
* @link     not yet
*
*/

require_once 'Services/SharedBook.php'; 

/**
* Example for Services_SharedBook usage
*
* PHP version 5
*
* @category Services
* @package  Services_SharedBook
* @author   Alex Lavrov <sharedbook.php@gmail.com>
* @license  http://www.php.net/license/3_0.txt  PHP License 3.0
* @link     not yet
*
*/

// Please register at http://www.sharedbook.com/biz/dev/mydevaccount.html
$my_book = new Services_SharedBook('<Your API>', 
                                   '<Your secred word>');

try
{     
    // Login into the service                     
    $my_book->authLogin();
    
    // Create book making space with only one article
    // $my_book->bmsCreateInit('Crossing the ocean', 
    //                         'Chapters of the book', 
    //                         'Chapters text comes here');
    
    
    // Create array of articles for the multiple articles book making space
    
    $articles = array(array('chapterTitle' => 'Title for the first Chapter',
                            'chapterText' => 'Bla bla bla, hello, bla bla',
                            'postCommentLink' => 'http://www.google.com',
                            'postPhotoLink' => 'http://www.google.com',
                            'chapterGroup' => 'Title of the first group'),
                                
                      array('chapterTitle' => 'Title for the second Chapter',
                            'chapterText' => 'La la la',
                           'chapterGroup' => 'Second group'),
                                
                      array('chapterTitle' => 'Title for the third Chapter',
                            'chapterText' => 'Lo lo lo',
                            'chapterGroup' => 'Title of the first group'));                                                                
        
        // Article groups for the book                                             
    $groups = array(array('groupTitle' => 'Title of the first group',
                          'groupPhotoUrl' => 'http://www.bigfoto.com/fruits-picture.jpg'),
                                
                    array('groupTitle' => 'Second group',
                          'groupPhotoUrl' => 'http://www.bigfoto.com/sites/main/churfirsten_switzerland-xxx.JPG'));                                                                     
    
    // Create book making space with multiple articles                             
    $my_book->bmsCreateInitMultipleArticles('Crossing the ocean', 
                                            $articles,
                                            "sb.theme.vanilla", 
                                            $groups);   
    
    // Publish book making space creation                               
    $my_book->bmsCreatePublish();
    
    // Add comment to the first article
    $my_book->bmsAddComment('JohnDoe', 
                            'Nice book!', 
                            'Love the book.', 2);
    
    // Add comment to the third article
    $my_book->bmsAddComment('Superman', 
                            'Great pictures', 
                            'Where did you buy the cam?', 3);

    echo "Uploading photo\n";
    $url = $my_book->photoUpload('photo1.jpg'); 
        
    echo "Url is $url \n";

    // Add photos
    $my_book->bmsAddPhoto('photo1.jpg', 'Alex'); 
    $my_book->bmsAddPhoto('photo2.jpg', 'Alex'); 
    
    // Set front and back covers
    $my_book->bmsSetFrontCoverPhoto('photo3.jpg', 'Alex');
    $my_book->bmsSetBackCoverPhoto('photo4.jpg', 'Alex');  
    
    // Publish book making space
    $my_book->bmsPublish();  
    
    // Create a book
    $my_book->bookCreateInit();                        
                    
    // Set dedication      
    $my_book->bookCreateSetDedication('This book is dedicated to PHP API');
    
    // Set subtitle      
    $my_book->bookCreateSetSubtitle('By Alex Lavrov');
    
    // Publish book creation
    $my_book->bookCreatePublish();
    
    // Get url to the book
    echo 'URL: '.$my_book->bookPreview();
}
catch (Services_SharedBook_Exception $e)
{
    // Print error messages
    echo $e->getCode().' - '.$e->getMessage();
}
?>