<?php

/**
 * ShortURL endpoint driver
 *
 * PHP version 5.1.0+
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license/3_0.txt.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category    Services
 * @package     Services_Digg
 * @author      Joe Stump <joe@joestump.net> 
 * @copyright   1997-2007 The PHP Group
 * @license     http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version     CVS: $Id:$
 * @link        http://pear.php.net/package/Services_Digg
 */

require_once 'Validate.php';

/**
 * Services_Digg_ShortURL
 *  
 * @category    Services
 * @package     Services_Digg
 * @author      Joe Stump <joe@joestump.net> 
 */
class Services_Digg_ShortURL extends Services_Digg_Common
{
    /**
     * Get all topics
     *
     * @access      public
     * @param       array       $params     Digg API arguments
     * @throws      Services_Digg_Exception
     */
    public function getAll(array $params = array()) 
    {
        return $this->sendRequest('/topics', $params);
    }

    /**
     * Shorten a URL using Digg's URL shortener API
     *
     * @param string $url A valid URL to shorten
     *
     * @throws {@link Services_Digg_Exception} on invalid URL
     * @return string The shortened version of the URL
     */
    public function create($url) 
    {
        $options = array(
            'allowed_schemes' => array('http', 'https')
        );

        if (!Validate::uri($url, $options)) {
            throw new Services_Digg_Exception(
                'Cannot shorten invalid URL'
            );
        }

        $res = $this->sendRequest('/url/short/create/' . $url);
        return $res->shorturls[0]->short_url;
    }

    /**
     * Get info about a given short URL
     *
     * @param string $url_or_id Either a short URL or the ID of a URL
     *
     * @return object Instance of {@link DiggAPIShortURLs}
     */
    public function getInfo($url_or_id) 
    {
        $m = array();
        $regExp = '#http://digg.com/(?P<id>[du][0-9][a-zA-Z0-9]{1,6})?#';
        if (preg_match($regExp, $url_or_id, $m)) {
            $url_or_id = $m['id'];
        }

        return $this->sendRequest('/url/short/' . $url_or_id);
    }
}

?>
