<?php
// Call QA_Peardoc_Coverage_ClassListTest::main() if this source file is executed directly.
if (!defined("PHPUnit_MAIN_METHOD")) {
    define("PHPUnit_MAIN_METHOD", "QA_Peardoc_Coverage_ClassListTest::main");
}

require_once "PHPUnit/Framework/TestCase.php";
require_once "PHPUnit/Framework/TestSuite.php";

//make cvs testing work
chdir(dirname(__FILE__) . '/../');
require_once "QA/Peardoc/Coverage/ClassList.php";
require_once dirname(__FILE__) . '/config.php';

/**
 * Test class for QA_Peardoc_Coverage_ClassList.
 * Generated by PHPUnit_Util_Skeleton on 2006-10-18 at 12:28:36.
 */
class QA_Peardoc_Coverage_ClassListTest extends PHPUnit_Framework_TestCase {
    /**
     * Runs the test methods of this class.
     *
     * @access public
     * @static
     */
    public static function main() {
        require_once "PHPUnit/TextUI/TestRunner.php";

        $suite  = new PHPUnit_Framework_TestSuite("QA_Peardoc_Coverage_ClassListTest");
        $result = PHPUnit_TextUI_TestRunner::run($suite);
    }

    /**
     * Sets up the fixture, for example, open a network connection.
     * This method is called before a test is executed.
     *
     * @access protected
     */
    protected function setUp() {
        $this->strPearDir = $GLOBALS['testConfig']['PearDir'];
        $this->assertTrue(file_exists($this->strPearDir));
        $this->assertTrue(is_dir($this->strPearDir));
    }

    /**
     * Tears down the fixture, for example, close a network connection.
     * This method is called after a test is executed.
     *
     * @access protected
     */
    protected function tearDown() {
    }



    public function testAuth()
    {
        $strAuthDir = $this->strPearDir . '/Auth';
        $this->assertTrue(file_exists($strAuthDir));
        $ar = QA_Peardoc_Coverage_ClassList::getFileList($strAuthDir, false);

        $this->assertNotEquals(0, count($ar));
        $this->assertTrue(in_array('Auth.php', $ar));
        $this->assertTrue(in_array('Auth/Auth.php', $ar));
        $this->assertTrue(in_array('Container/Array.php', $ar));
        $this->assertFalse(in_array('tests/DBContainer.php', $ar));

        $ar2 = QA_Peardoc_Coverage_ClassList::getClassnamesFromFilename($strAuthDir . '/Auth.php');
        $this->assertEquals(1, count($ar2));
        $this->assertTrue(in_array('Auth', $ar2));
        $ar2 = QA_Peardoc_Coverage_ClassList::getClassnamesFromFilename($strAuthDir . '/Container/Array.php');
        $this->assertEquals(1, count($ar2));
        $this->assertTrue(in_array('Auth_Container_Array', $ar2));
    }//public function testAuth()



    public function testMDB2()
    {
        $strMdb2Dir = $this->strPearDir . '/MDB2';
        $this->assertTrue(file_exists($strMdb2Dir));
        $ar = QA_Peardoc_Coverage_ClassList::getFileList($strMdb2Dir, false);

        $this->assertNotEquals(0, count($ar));
        $this->assertTrue(in_array('MDB2.php', $ar));

        $ar2 = QA_Peardoc_Coverage_ClassList::getClassnamesFromFilename($strMdb2Dir. '/MDB2.php');
        $this->assertNotEquals(1, count($ar2));
        $this->assertTrue(in_array('MDB2'                   , $ar2));
        $this->assertTrue(in_array('MDB2_Error'             , $ar2));
        $this->assertTrue(in_array('MDB2_Driver_Common'     , $ar2));
        $this->assertTrue(in_array('MDB2_Result'            , $ar2));
        $this->assertTrue(in_array('MDB2_Result_Common'     , $ar2));
        $this->assertTrue(in_array('MDB2_Row'               , $ar2));
        $this->assertTrue(in_array('MDB2_Statement_Common'  , $ar2));
        $this->assertTrue(in_array('MDB2_Module_Common'     , $ar2));
    }//public function testMDB2()



    public function testNetWifi()
    {
        $strNetWifiDir = $this->strPearDir . '/Net_Wifi';
        $this->assertTrue(file_exists($strNetWifiDir));
        $ar = QA_Peardoc_Coverage_ClassList::getFileList($strNetWifiDir, false);

        $this->assertNotEquals(0, count($ar));
        $this->assertTrue(in_array('Net/Wifi.php', $ar));
        $this->assertTrue(in_array('Net/Wifi/Cell.php', $ar));
        $this->assertTrue(in_array('Net/Wifi/Config.php', $ar));
    }//public function testNetWifi()
}

// Call QA_Peardoc_Coverage_ClassListTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == "QA_Peardoc_Coverage_ClassListTest::main") {
    QA_Peardoc_Coverage_ClassListTest::main();
}
?>