<?php
/**
 * run php trace.php to generate the trace
 * open trace.txt to analyse the function calls trace
 */

/**
 * adds the path of the package if this is a raw install
 * includes the package (example) to debug and the tracer package
 */
file_exists("../../../../PHP/") and set_include_path('../../../..' . PATH_SEPARATOR . get_include_path());
require_once 'PHP/FunctionCallTracer.php';

/**
 * the function to debug
 * one of the parameters is passed by reference
 *
 * due to PHP Bug 42058: "debug_backtrace messes up with references"
 * the function arguments must be explicitly passed to traceArguments()
 */
function foo($a, &$b)
{
    class_exists('PHP_FunctionCallTracer', false) and
    PHP_FunctionCallTracer::traceArguments($a, $b);

    $b = strtoupper($a);

    class_exists('PHP_FunctionCallTracer', false) and
    PHP_FunctionCallTracer::traceReturn($b);
}

/**
 * calls the function
 * writes the trace in a file
 */
foo('foo', $b);

$file = dirname(__FILE__) . '/trace.txt';
PHP_FunctionCallTracer::putTrace($file, false);

?>