<?php
/**
 * run php trace.php to generate the trace
 * open trace.txt to analyse the function calls trace
 */

/**
 * adds the path of the package if this is a raw install
 * includes the package (example) to debug and the tracer package
 */
file_exists("../../../../PHP/") and set_include_path('../../../..' . PATH_SEPARATOR . get_include_path());
require_once 'package.php';
require_once 'PHP/FunctionCallTracer.php';

/**
 * adds a user function to process variables as needed
 * floats will be rounded
 */
PHP_FunctionCallTracer::setUserFunctions('round');

/**
 * creates an instance of the class to debug and calls a few methods
 * writes the trace in a file
 */
$geometry = new geometry;
$c = $geometry->circle(2);
$d = $geometry->disk(3);

$file = dirname(__FILE__) . '/trace.txt';
PHP_FunctionCallTracer::putTrace($file, false);

?>