<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4 foldmethod=marker */
// $Id: thumbnail.php,v 1.1 2008/05/26 03:03:26 firman Exp $

/**
 * Image_Tools
 */
require_once 'Image/Tools.php';

// creates an instance of Thumbnail tool object
$thumb = Image_Tools::factory('thumbnail');
if (PEAR::isError($thumb)) {
    echo $thumb->toString();
    exit;
}

// sets the image
$thumb->set('image', dirname(__FILE__) . '/images/3dgirl.jpg');

// set the dimension
if (isset($_GET['percent'])) {
    $thumb->set('percent', 50);
} else {
    $thumb->set('width', 100);
    $thumb->set('height', 80);
}

// sets the method
if (isset($_GET['method'])) {
    switch ($_GET['method']) {
        case 'scale_min':
            $thumb->set('method', IMAGE_TOOLS_THUMBNAIL_METHOD_SCALE_MIN);
            break;
        case 'crop':
            $thumb->set('method', IMAGE_TOOLS_THUMBNAIL_METHOD_CROP);
            break;
    }
}

// sets the horizontal alignment
if (isset($_GET['halign'])) {
    switch($_GET['halign']) {
        case 'left':
            $thumb->set('halign', IMAGE_TOOLS_THUMBNAIL_ALIGN_LEFT);
            break;
        case 'right':
            $thumb->set('halign', IMAGE_TOOLS_THUMBNAIL_ALIGN_RIGHT);
            break;
    }
}

// sets the vertical alignment
if (isset($_GET['valign'])) {
    switch($_GET['valign']) {
        case 'top':
            $thumb->set('valign', IMAGE_TOOLS_THUMBNAIL_ALIGN_TOP);
            break;
        case 'bottom':
            $thumb->set('valign', IMAGE_TOOLS_THUMBNAIL_ALIGN_BOTTOM);
            break;
    }
}

// display the image result
$err = $thumb->display(IMAGETYPE_JPEG);
if (PEAR::isError($err)) {
    echo $err->toString();
    exit;
}
