<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4 foldmethod=marker */
// $Id: border.php,v 1.1 2008/05/26 03:03:26 firman Exp $

/**
 * Image_Tools
 */
require_once 'Image/Tools.php';

// creates an instance of Border tool object
$border = Image_Tools::factory('border');
if (PEAR::isError($border)) {
    echo $border->toString();
    exit;
}

// sets the image
$border->set('image', dirname(__FILE__) . '/images/3dgirl.jpg');

if (!isset($_GET['style'])) {
    exit;
}

switch ($_GET['style']) {
    case 'rounded':
        $border->set('style', 'rounded');
        $border->set('params', array(16, '#ffffff', 0));
        break;
    case 'bevel':
        $border->set('style', 'bevel');
        $border->set('params', array(16, '#ffffff', '#000000'));
        break;
    case 'line':
        $border->set('style', 'line');
        $border->set('params', array(4, '#ff0000', -4));
        break;
}


// Apply border to the image and send it to browser
$err = $border->display(IMAGETYPE_JPEG);
if (PEAR::isError($err)) {
    echo $err->toString();
    exit;
}
