<?php
// Call Gtk2_IndexedComboBoxTest::main() if this source file is executed directly.
if (!defined("PHPUnit_MAIN_METHOD")) {
    define("PHPUnit_MAIN_METHOD", "Gtk2_IndexedComboBox_ModelTest::main");
}

require_once "PHPUnit/Framework/TestCase.php";
require_once "PHPUnit/Framework/TestSuite.php";

require_once "Gtk2/IndexedComboBox/Model.php";

/**
 * Test class for Gtk2_IndexedComboBox_Model.
 * Generated by PHPUnit2_Util_Skeleton on 2006-04-05 at 08:27:56.
 */
class Gtk2_IndexedComboBox_ModelTest extends PHPUnit_Framework_TestCase {
    protected $model = null;

    /**
     * Runs the test methods of this class.
     *
     * @access public
     * @static
     */
    public static function main() {
        require_once "PHPUnit/TextUI/TestRunner.php";

        $suite  = new PHPUnit_Framework_TestSuite("Gtk2_IndexedComboBox_ModelTest");
        $result = PHPUnit_TextUI_TestRunner::run($suite);
    }

    /**
     * Sets up the fixture, for example, open a network connection.
     * This method is called before a test is executed.
     *
     * @access protected
     */
    protected function setUp() {
        $this->model = new Gtk2_IndexedComboBox_Model();
    }

    /**
     * Tears down the fixture, for example, close a network connection.
     * This method is called after a test is executed.
     *
     * @access protected
     */
    protected function tearDown() {
    }

    /**
     */
    public function testAppend() {
        $this->assertEquals(0, count($this->model->get_array()));

        $this->model->append(1, 'one');
        $this->assertEquals(1, count($this->model->get_array()));

        $this->model->append(2, 'two');
        $this->assertEquals(2, count($this->model->get_array()));

        $this->model->append(null, 'two');
        $this->assertEquals(3, count($this->model->get_array()));
    }

    /**
     */
    public function testAppend_array() {
        $this->assertEquals(0, count($this->model->get_array()));

        $this->model->append_array(array(1 => 'one'));
        $this->assertEquals(1, count($this->model->get_array()));


        $this->model->append_array(array(2 => 'two'));
        $this->assertEquals(2, count($this->model->get_array()));


        $this->model->append_array(array(3 => 'three', 4 => 'four'));
        $this->assertEquals(4, count($this->model->get_array()));
    }


    /**
     */
    public function testGet_array() {
        $this->assertEquals(0, count($this->model->get_array()));

        $this->assertEquals(array(), $this->model->get_array());

        $this->model->append_array(array(1 => 'one', 2 => 'two'));
        $this->assertEquals(array(1 => 'one', 2 => 'two'), $this->model->get_array());
    }

    /**
     */
    public function testInsert() {
        $this->assertEquals(0, count($this->model->get_array()));

        $this->model->insert(0, 1, 'one');
        $this->assertEquals(1, count($this->model->get_array()));

        $this->model->insert(1, 2, 'two');
        $this->assertEquals(2, count($this->model->get_array()));
    }

    /**
     */
    public function testInsert_array() {
        $this->assertEquals(0, count($this->model->get_array()));

        $this->model->insert_array(0, array(1 => 'one'));
        $this->assertEquals(1, count($this->model->get_array()));

        $this->model->insert_array(1, array(2 => 'two'));
        $this->assertEquals(2, count($this->model->get_array()));

        $this->model->insert_array(2, array(3 => 'three', 4 => 'four'));
        $this->assertEquals(4, count($this->model->get_array()));
    }

    /**
     */
    public function testPrepend() {
        $this->assertEquals(0, count($this->model->get_array()));

        $this->model->prepend(1, 'one');
        $this->assertEquals(1, count($this->model->get_array()));

        $this->model->prepend(2, 'two');
        $this->assertEquals(2, count($this->model->get_array()));
    }

    /**
     */
    public function testPrepend_array() {
        $this->assertEquals(0, count($this->model->get_array()));

        $this->model->prepend_array(array(1 => 'one', 2 => 'two'));
        $this->assertEquals(2, count($this->model->get_array()));
    }

    /**
     */
    public function testRemove_key() {
        $this->assertEquals(0, count($this->model->get_array()));

        $this->assertFalse($this->model->remove_key(1));

        $this->model->append(1, 'one');
        $this->assertTrue($this->model->remove_key(1));
        $this->assertEquals(0, count($this->model->get_array()));


        $this->model->append(1, 'one');
        $this->model->append(2, 'two');
        $this->assertEquals(2, count($this->model->get_array()));

        $this->assertTrue($this->model->remove_key(1));
        $this->assertEquals(1, count($this->model->get_array()));
        $this->assertTrue($this->model->remove_key(2));
        $this->assertEquals(0, count($this->model->get_array()));
    }

    /**
     */
    public function testSet_array() {
        $this->assertEquals(0, count($this->model->get_array()));

        $this->model->append_array(array(1 => 'one', 2 => 'two'));
        $this->assertEquals(2, count($this->model->get_array()));

        $this->model->set_array(array(3 => 'three', 4 => 'four'));
        $this->assertEquals(2, count($this->model->get_array()));
    }

    /**
     */
    public function testAppendArray() {
        //just an alias method
    }

    /**
     */
    public function testInsertArray() {
        //just an alias method
    }

    /**
     */
    public function testPrependArray() {
        //just an alias method
    }

    /**
     */
    public function testRemoveKey() {
        //just an alias method
    }

    /**
     */
    public function testSetArray() {
        //just an alias method
    }
}

// Call Gtk2_IndexedComboBoxTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == "Gtk2_IndexedComboBox_ModelTest::main") {
    Gtk2_IndexedComboBox_ModelTest::main();
}
?>
