<?php
/**
* Indexed Gtk2 combo box similar to the HTML select box.
*
* PHP Versions 5
*
* @category Gtk2
* @package  Gtk2_IndexedComboBox
* @author   Christian Weiske <cweiske@php.net>
* @license  http://www.gnu.org/copyleft/lesser.html LGPL License 2.1
* @version  CVS: $Id: Model.php,v 1.2 2007/11/01 21:39:33 cweiske Exp $
* @link     http://pear.php.net/package/Gtk2_IndexedComboBox
*/

/**
* Indexed Gtk2 combo box model. Can be used stand-alone
* e.g. as model for a GtkComboBox from a glade file.
*
* Both key and values can be strings or integers.
*
* @category Gtk2
* @package  Gtk2_IndexedComboBox
* @author   Christian Weiske <cweiske@php.net>
* @license  http://www.gnu.org/copyleft/lesser.html LGPL License 2.1
* @link     http://pear.php.net/package/Gtk2_IndexedComboBox
*/
class Gtk2_IndexedComboBox_Model extends GtkListStore
{
    /**
    * Constructor.
    *
    * @param array $arData If wished, you can set the initial data here.
    */
    public function __construct($arData = null)
    {
        parent::__construct(Gobject::TYPE_STRING, Gobject::TYPE_STRING);
        if ($arData !== null) {
            $this->set_array($arData);
        }
    }//public function __construct($arData = null)



    /**
    * Appends a single key/value pair to the list.
    *
    * @param mixed  $strId    (string) id to append, or an array to append
    * @param string $strValue The value to append
    *
    * @return void
    */
    public function append($strId, $strValue = null)
    {
        if (is_array($strId)) {
            parent::append($strId);
        } else {
            parent::append(array($strId, $strValue));
        }
    }//public function append_array($strId, $strValue = null)



    /**
    * Appends an array (key and value) as data to the store.
    *
    * @param array $arData The array to append
    *
    * @return void
    */
    public function append_array($arData)
    {
        foreach ($arData as $strId => &$strValue) {
            parent::append(array($strId, $strValue));
        }
    }//public function append_array($arData)



    /**
    * Returns the key/id of the given iter.
    * If $iter is NULL, this method returns NULL.
    *
    * @param GtkTreeIter $iter Iterator whose key shall be gotten.
    *
    * @return string The id/key of the selected entry
    */
    public function get_key($iter)
    {
        if ($iter === null) {
            return null;
        }
        return $this->get_value($iter, 0);
    }//public function get_key($iter)



    /**
    * Returns the string of the given iter.
    * If $iter is NULL, this method returns NULL.
    *
    * @param GtkTreeIter $iter Iterator whose string shall be gotten.
    *
    * @return string The string value of the selected entry
    */
    public function get_text($iter)
    {
        if ($iter === null) {
            return null;
        }
        return $this->get_value($iter, 1);
    }//public function get_key($iter)



    /**
    * Returns an array with all key/value pairs.
    *
    * @return array Array with key/value pairs in the model
    */
    public function get_array()
    {
        $ar = array();

        $iter = $this->get_iter_first();
        if ($iter !== null) {
            do {
                $ar[$this->get_value($iter, 0)] = $this->get_value($iter, 1);
            } while (($iter = $this->iter_next($iter)) !== null);
        }

        return $ar;
    }//public function get_array()



    /**
    * Inserts a single key/value pair (or an array) at
    * a certain position into the list.
    *
    * @param int    $nPosition The position to insert the values at
    * @param mixed  $strId     (string) id to append, or array to append
    * @param string $strValue  The value to append
    *
    * @return void
    */
    public function insert($nPosition, $strId, $strValue = null)
    {
        if (is_array($strId)) {
            parent::insert($nPosition, $strId);
        } else {
            parent::insert($nPosition, array($strId, $strValue));
        }
    }//public function insert($nPosition, $strId, $strValue = null)



    /**
    * Inserts an array (key and value) at a certain position into the list.
    *
    * @param int   $nPosition The position to insert the array at
    * @param array $arData    The array to append
    *
    * @return void
    */
    public function insert_array($nPosition, $arData)
    {
        foreach ($arData as $strId => &$strValue) {
            parent::insert($nPosition++, array($strId, $strValue));
        }
    }//public function insert_array($nPosition, $arData)



    /**
    * Prepends a single key/value pair to the list.
    *
    * @param mixed  $strId    (string) id to prepend, or array to prepend
    * @param string $strValue The value to append
    *
    * @return void
    */
    public function prepend($strId, $strValue = null)
    {
        if (is_array($strId)) {
            parent::prepend($strId);
        } else {
            parent::prepend(array($strId, $strValue));
        }
    }//public function prepend($strId, $strValue = null)



    /**
    * Prepends an array (key and value) at the beginning of the store
    *
    * @param array $arData The array to append
    *
    * @return void
    */
    public function prepend_array($arData)
    {
        $nPosition = 0;
        foreach ($arData as $strId => &$strValue) {
            parent::insert($nPosition++, array($strId, $strValue));
        }
    }//public function prepend_array($arData)



    /**
    * Removes the first entry with the given key from the list.
    *
    * @param string $strId The key of the entry to remove
    *
    * @return boolean True if an entry has been deleted
    */
    public function remove_key($strId)
    {
        $iter = $this->get_iter_first();
        if ($iter !== null) {
            do {
                if ($this->get_value($iter, 0) == $strId) {
                    break;
                }
            } while (($iter = $this->iter_next($iter)) !== null);

            if ($iter !== null) {
                $this->remove($iter);
                return true;
            }
        }
        return false;
    }//public function remove_key($strId)



    /**
    * Sets an array (key and value) as data into the store.
    * Clears any previous entries.
    *
    * @param array $arData The array to set
    *
    * @return void
    */
    public function set_array($arData)
    {
        $this->clear();
        return $this->append_array($arData);
    }//public function set_array($arData)



    /*
    *   PEAR-style camelCaseNamed method aliases
    */



    /**
    * Appends an array (key and value) as data to the store.
    *
    * Alias of @see append_array().
    *
    * @param array $arData The array to append
    *
    * @return void
    */
    public function appendArray($arData)
    {
        return $this->append_array($arData);
    }



    /**
    * Returns an array with all key/value pairs.
    *
    * Alias of @see get_array().
    *
    * @return array Array with key/value pairs in the model
    */
    public function getArray()
    {
        return $this->get_array();
    }



    /**
    * Inserts an array (key and value) at a certain position into the list.
    *
    * Alias of @see insert_array().
    *
    * @param int   $nPosition The position to insert the array at
    * @param array $arData    The array to append
    *
    * @return void
    */
    public function insertArray($nPosition, $arData)
    {
        return $this->insert_array($nPosition, $arData);
    }



    /**
    * Prepends an array (key and value) at the beginning of the store
    *
    * Alias of @see prepend_array().
    *
    * @param array $arData The array to append
    *
    * @return void
    */
    public function prependArray($arData)
    {
        return $this->prepend_array($arData);
    }



    /**
    * Removes the first entry with the given key from the list.
    *
    * Alias of @see remove_key().
    *
    * @param string $strId The key of the entry to remove
    *
    * @return boolean True if an entry has been deleted
    */
    public function removeKey($strId)
    {
        return $this->remove_key($strId);
    }



    /**
    * Sets an array (key and value) as data into the store.
    * Clears any previous entries.
    *
    * Alias of @see set_array().
    *
    * @param array $arData The array to set
    *
    * @return void
    */
    public function setArray($arData)
    {
        return $this->set_array($arData);
    }

}//class Gtk2_IndexedComboBox_Model extends GtkListStore
?>
