<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Contains the DB_QueryTool class
 *
 * PHP versions 4 and 5
 *
 * LICENSE: Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE FREEBSD PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * @category  Database
 * @package   DB_QueryTool
 * @author    Wolfram Kriesing <wk@visionp.de>
 * @author    Paolo Panto <wk@visionp.de>
 * @copyright 2003-2007 Wolfram Kriesing, Paolo Panto
 * @license   http://www.debian.org/misc/bsd.license  BSD License (3 Clause)
 * @version   CVS: $Id: QueryTool.php,v 1.6 2007/11/16 20:33:33 quipo Exp $
 * @link      http://pear.php.net/package/DB_QueryTool
 */

/**
 * require the DB_QueryTool_EasyJoin class
 */
require_once 'DB/QueryTool/EasyJoin.php';

/**
 * MDB_QueryTool class
 *
 * This class should be extended; it's here to make it easy using the base
 * class of the package by its package name.
 * Since I tried to seperate the functionality a bit inside the
 * really working classes i decided to have this class here just to
 * provide the name, since the functionality inside the other
 * classes might be restructured a bit but this name always stays.
 *
 * @category  Database
 * @package   DB_QueryTool
 * @author    Wolfram Kriesing <wk@visionp.de>
 * @copyright 2003-2007 Wolfram Kriesing
 * @license   http://www.debian.org/misc/bsd.license  BSD License (3 Clause)
 * @link      http://pear.php.net/package/DB_QueryTool
 */
class DB_QueryTool extends DB_QueryTool_EasyJoin
{
    // {{{ DB_QueryTool()

    /**
     * Call parent constructor
     *
     * @param mixed $dsn     DSN string, DSN array or DB object
     * @param array $options database options
     */
    function DB_QueryTool($dsn=false, $options=array())
    {
        parent::__construct($dsn, $options);
    }

    // }}}
}
?>