<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4 foldmethod=marker: */

// {{{ Header

/**
 * File contains Ms Outlook CSV address book English header.
 *
 * PHP versions 4 and 5
 *
 * LICENSE:
 *
 * BSD License
 *
 * Copyright (c) 2005 Firman Wandayandi
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 * 3. Neither the name of Firman Wandayandi nor the names of
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @category File Formats
 * @package AddressBook
 * @subpackage CSV
 * @author Firman Wandayandi <firman@php.net>
 * @copyright Copyright (c) 2005 Firman Wandayandi
 * @license http://www.opensource.org/licenses/bsd-license.php
 *          BSD License
 * @version CVS: $Id: en.php 200239 2005-11-08 17:54:11Z firman $
 * @since File available since Release 0.4.0alpha1
 */

// }}}

/**
 * Microsoft Outlook CSV address book English header.
 *
 * @global array $GLOBALS['_Contact_AddressBook_CSV_header']
 * @name $_Contact_AddressBook_CSV_header
 */
$GLOBALS['_Contact_AddressBook_CSV_header'] = array(
    'Title',
    'First Name',
    'Middle Name',
    'Last Name',
    'Suffix',
    'Company',
    'Department',
    'Job Title',
    'Business Street',
    'Business Street 2',
    'Business Street 3',
    'Business City',
    'Business State',
    'Business Postal Code',
    'Business Country',
    'Home Street',
    'Home Street 2',
    'Home Street 3',
    'Home City',
    'Home State',
    'Home Postal Code',
    'Home Country',
    'Other Street',
    'Other Street 2',
    'Other Street 3',
    'Other City',
    'Other State',
    'Other Postal Code',
    'Other Country',
    'Assistant\'s Phone',
    'Business Fax',
    'Business Phone',
    'Business Phone 2',
    'Callback',
    'Car Phone',
    'Company Main Phone',
    'Home Fax',
    'Home Phone',
    'Home Phone 2',
    'ISDN',
    'Mobile Phone',
    'Other Fax',
    'Other Phone',
    'Pager',
    'Primary Phone',
    'Radio Phone',
    'TTY/TDD Phone',
    'Telex',
    'Account',
    'Anniversary',
    'Assistant\'s Name',
    'Billing Information',
    'Birthday',
    'Business Address PO Box',
    'Categories',
    'Children',
    'Directory Server',
    'E-mail Address',
    'E-mail Type',
    'E-mail Display Name',
    'E-mail 2 Address',
    'E-mail 2 Type',
    'E-mail 2 Display Name',
    'E-mail 3 Address',
    'E-mail 3 Type',
    'E-mail 3 Display Name',
    'Gender',
    'Government ID Number',
    'Hobby',
    'Home Address PO Box',
    'Initials',
    'Internet Free Busy',
    'Keywords',
    'Language',
    'Location',
    'Manager\'s Name',
    'Mileage',
    'Notes',
    'Office Location',
    'Organizational ID Number',
    'Other Address PO Box',
    'Priority',
    'Private',
    'Profession',
    'Referred By',
    'Sensitivity',
    'Spouse',
    'User 1',
    'User 2',
    'User 3',
    'User 4',
    'Web Page'
);

/*
 * Local variables:
 * mode: php
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>
