/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.metrics;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;
import java.util.Stack;

public final class BooleanExpressionComplexityCheck
extends Check {
    private static final int DEFAULT_MAX = 3;
    private final Stack mContextStack = new Stack();
    private int mMax;
    private Context mContext;

    public BooleanExpressionComplexityCheck() {
        this.setMax(3);
    }

    public int[] getDefaultTokens() {
        return new int[]{8, 9, 28, 111, 114, 110, 112, 113};
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public int getMax() {
        return this.mMax;
    }

    public void setMax(int aMax) {
        this.mMax = aMax;
    }

    public void visitToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 8: 
            case 9: {
                this.visitMethodDef(aAST);
                break;
            }
            case 28: {
                this.visitExpr();
                break;
            }
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: {
                this.mContext.visitBooleanOperator();
                break;
            }
            default: {
                throw new IllegalStateException(aAST.toString());
            }
        }
    }

    public void leaveToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 8: 
            case 9: {
                this.leaveMethodDef();
                break;
            }
            case 28: {
                this.leaveExpr(aAST);
                break;
            }
        }
    }

    private void visitMethodDef(DetailAST aAST) {
        this.mContextStack.push(this.mContext);
        this.mContext = new Context(!CheckUtils.isEqualsMethod(aAST));
    }

    private void leaveMethodDef() {
        this.mContext = (Context)this.mContextStack.pop();
    }

    private void visitExpr() {
        this.mContextStack.push(this.mContext);
        this.mContext = new Context(this.mContext == null || this.mContext.isChecking());
    }

    private void leaveExpr(DetailAST aAST) {
        this.mContext.checkCount(aAST);
        this.mContext = (Context)this.mContextStack.pop();
    }

    private class Context {
        private final boolean mChecking;
        private int mCount;

        public Context(boolean aChecking) {
            this.mChecking = aChecking;
            this.mCount = 0;
        }

        public boolean isChecking() {
            return this.mChecking;
        }

        public void visitBooleanOperator() {
            ++this.mCount;
        }

        public void checkCount(DetailAST aAST) {
            if (this.mChecking && this.mCount > BooleanExpressionComplexityCheck.this.getMax()) {
                DetailAST parentAST = aAST.getParent();
                BooleanExpressionComplexityCheck.this.log(parentAST.getLineNo(), parentAST.getColumnNo(), "booleanExpressionComplexity", new Integer(this.mCount), new Integer(BooleanExpressionComplexityCheck.this.getMax()));
            }
        }
    }
}

