/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.MessageDispatcher;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PackageHtmlCheck
extends AbstractFileSetCheck {
    public PackageHtmlCheck() {
        this.setFileExtensions(new String[]{"java"});
    }

    public void process(File[] aFiles) {
        File[] javaFiles = this.filter(aFiles);
        Set directories = this.getParentDirs(javaFiles);
        Iterator it = directories.iterator();
        while (it.hasNext()) {
            File dir = (File)it.next();
            File packageHtml = new File(dir, "package.html");
            MessageDispatcher dispatcher = this.getMessageDispatcher();
            String path = packageHtml.getPath();
            dispatcher.fireFileStarted(path);
            if (!packageHtml.exists()) {
                this.log(0, "javadoc.packageHtml");
                this.fireErrors(path);
            }
            dispatcher.fireFileFinished(path);
        }
    }

    protected final Set getParentDirs(File[] aFiles) {
        HashSet<File> directories = new HashSet<File>();
        for (int i = 0; i < aFiles.length; ++i) {
            File f = aFiles[i].getAbsoluteFile();
            if (!f.getName().endsWith(".java")) continue;
            File dir = f.getParentFile();
            directories.add(dir);
        }
        return directories;
    }
}

