/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.font;

import java.io.IOException;
import org.pdfbox.pdmodel.common.PDRectangle;

public abstract class PDFontDescriptor {
    private static final int FLAG_FIXED_PITCH = 1;
    private static final int FLAG_SERIF = 2;
    private static final int FLAG_SYMBOLIC = 3;
    private static final int FLAG_SCRIPT = 4;
    private static final int FLAG_NON_SYMBOLIC = 6;
    private static final int FLAG_ITALIC = 7;
    private static final int FLAG_ALL_CAP = 17;
    private static final int FLAG_SMALL_CAP = 18;
    private static final int FLAG_FORCE_BOLD = 19;

    public abstract String getFontName();

    public abstract void setFontName(String var1);

    public abstract String getFontFamily();

    public abstract void setFontFamily(String var1);

    public abstract String getFontStretch();

    public abstract void setFontStretch(String var1);

    public abstract float getFontWeight();

    public abstract void setFontWeight(float var1);

    public abstract int getFlags();

    public abstract void setFlags(int var1);

    public boolean isFixedPitch() {
        return this.isFlagBitOn(1);
    }

    public void setFixedPitch(boolean flag) {
        this.setFlagBit(1, flag);
    }

    public boolean isSerif() {
        return this.isFlagBitOn(2);
    }

    public void setSerif(boolean flag) {
        this.setFlagBit(2, flag);
    }

    public boolean isSymbolic() {
        return this.isFlagBitOn(3);
    }

    public void setSymbolic(boolean flag) {
        this.setFlagBit(3, flag);
    }

    public boolean isScript() {
        return this.isFlagBitOn(4);
    }

    public void setScript(boolean flag) {
        this.setFlagBit(4, flag);
    }

    public boolean isNonSymbolic() {
        return this.isFlagBitOn(6);
    }

    public void setNonSymbolic(boolean flag) {
        this.setFlagBit(6, flag);
    }

    public boolean isItalic() {
        return this.isFlagBitOn(7);
    }

    public void setItalic(boolean flag) {
        this.setFlagBit(7, flag);
    }

    public boolean isAllCap() {
        return this.isFlagBitOn(17);
    }

    public void setAllCap(boolean flag) {
        this.setFlagBit(17, flag);
    }

    public boolean isSmallCap() {
        return this.isFlagBitOn(18);
    }

    public void setSmallCap(boolean flag) {
        this.setFlagBit(18, flag);
    }

    public boolean isForceBold() {
        return this.isFlagBitOn(19);
    }

    public void setForceBold(boolean flag) {
        this.setFlagBit(19, flag);
    }

    private boolean isFlagBitOn(int bit) {
        return (this.getFlags() & 1 << bit - 1) != 0;
    }

    private void setFlagBit(int bit, boolean value) {
        int flags = this.getFlags();
        flags = value ? (flags |= 1 << bit - 1) : (flags &= 0xFFFFFFFF ^ 1 << bit - 1);
        this.setFlags(flags);
    }

    public abstract PDRectangle getFontBoundingBox();

    public abstract void setFontBoundingBox(PDRectangle var1);

    public abstract float getItalicAngle();

    public abstract void setItalicAngle(float var1);

    public abstract float getAscent();

    public abstract void setAscent(float var1);

    public abstract float getDescent();

    public abstract void setDescent(float var1);

    public abstract float getLeading();

    public abstract void setLeading(float var1);

    public abstract float getCapHeight();

    public abstract void setCapHeight(float var1);

    public abstract float getXHeight();

    public abstract void setXHeight(float var1);

    public abstract float getStemV();

    public abstract void setStemV(float var1);

    public abstract float getStemH();

    public abstract void setStemH(float var1);

    public abstract float getAverageWidth() throws IOException;

    public abstract void setAverageWidth(float var1);

    public abstract float getMaxWidth();

    public abstract void setMaxWidth(float var1);

    public abstract String getCharSet();

    public abstract void setCharacterSet(String var1);
}

