/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.common;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSStream;
import org.pdfbox.cos.ICOSVisitor;
import org.pdfbox.exceptions.COSVisitorException;
import org.pdfbox.io.RandomAccess;
import org.pdfbox.pdfparser.PDFStreamParser;

public class COSStreamArray
extends COSStream {
    private COSArray streams;
    private COSStream firstStream;

    public COSStreamArray(COSArray array) {
        super(new COSDictionary(), null);
        this.streams = array;
        if (array.size() > 0) {
            this.firstStream = (COSStream)array.getObject(0);
        }
    }

    public RandomAccess getScratchFile() {
        return this.firstStream.getScratchFile();
    }

    public COSBase getItem(COSName key) {
        return this.firstStream.getItem(key);
    }

    public COSBase getDictionaryObject(COSName key) {
        return this.firstStream.getDictionaryObject(key);
    }

    public String toString() {
        String result = "COSStream{}";
        return result;
    }

    public List getStreamTokens() throws IOException {
        List retval = null;
        if (this.streams.size() > 0) {
            PDFStreamParser parser = new PDFStreamParser(this);
            parser.parse();
            retval = parser.getTokens();
        } else {
            retval = new ArrayList();
        }
        return retval;
    }

    public COSDictionary getDictionary() {
        return this.firstStream;
    }

    public InputStream getFilteredStream() throws IOException {
        throw new IOException("Error: Not allowed to get filtered stream from array of streams.");
    }

    public InputStream getUnfilteredStream() throws IOException {
        Vector<InputStream> inputStreams = new Vector<InputStream>();
        byte[] inbetweenStreamBytes = "\n".getBytes();
        for (int i = 0; i < this.streams.size(); ++i) {
            COSStream stream = (COSStream)this.streams.getObject(i);
            inputStreams.add(stream.getUnfilteredStream());
            inputStreams.add(new ByteArrayInputStream(inbetweenStreamBytes));
        }
        return new SequenceInputStream(inputStreams.elements());
    }

    public Object accept(ICOSVisitor visitor) throws COSVisitorException {
        return this.streams.accept(visitor);
    }

    public COSBase getFilters() {
        return this.firstStream.getFilters();
    }

    public OutputStream createFilteredStream() throws IOException {
        return this.firstStream.createFilteredStream();
    }

    public OutputStream createFilteredStream(COSBase expectedLength) throws IOException {
        return this.firstStream.createFilteredStream(expectedLength);
    }

    public void setFilters(COSBase filters) throws IOException {
        this.firstStream.setFilters(filters);
    }

    public OutputStream createUnfilteredStream() throws IOException {
        return this.firstStream.createUnfilteredStream();
    }

    public void appendStream(COSStream streamToAppend) {
        this.streams.add(streamToAppend);
    }
}

