/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.examples.pdmodel;

import java.util.List;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageFitWidthDestination;
import org.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;

public class CreateBookmarks {
    private CreateBookmarks() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            CreateBookmarks.usage();
        } else {
            PDDocument document = null;
            try {
                document = PDDocument.load(args[0]);
                if (document.isEncrypted()) {
                    System.err.println("Error: Cannot add bookmarks to encrypted document.");
                    System.exit(1);
                }
                PDDocumentOutline outline = new PDDocumentOutline();
                document.getDocumentCatalog().setDocumentOutline(outline);
                PDOutlineItem pagesOutline = new PDOutlineItem();
                pagesOutline.setTitle("All Pages");
                outline.appendChild(pagesOutline);
                List pages = document.getDocumentCatalog().getAllPages();
                for (int i = 0; i < pages.size(); ++i) {
                    PDPage page = (PDPage)pages.get(i);
                    PDPageFitWidthDestination dest = new PDPageFitWidthDestination();
                    dest.setPage(page);
                    PDOutlineItem bookmark = new PDOutlineItem();
                    bookmark.setDestination(dest);
                    bookmark.setTitle("Page " + (i + 1));
                    pagesOutline.appendChild(bookmark);
                }
                pagesOutline.openNode();
                outline.openNode();
                document.save(args[1]);
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java org.pdfbox.examples.pdmodel.CreateBookmarks <input-pdf> <output-pdf>");
    }
}

