/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.util.DOMElementWriter;
import org.apache.tools.ant.util.StringUtils;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlLogger
implements BuildLogger {
    private int msgOutputLevel = 4;
    private PrintStream outStream;
    private static DocumentBuilder builder = XmlLogger.getDocumentBuilder();
    private static final String BUILD_TAG = "build";
    private static final String TARGET_TAG = "target";
    private static final String TASK_TAG = "task";
    private static final String MESSAGE_TAG = "message";
    private static final String NAME_ATTR = "name";
    private static final String TIME_ATTR = "time";
    private static final String PRIORITY_ATTR = "priority";
    private static final String LOCATION_ATTR = "location";
    private static final String ERROR_ATTR = "error";
    private static final String STACKTRACE_TAG = "stacktrace";
    private Document doc = builder.newDocument();
    private Hashtable tasks = new Hashtable();
    private Hashtable targets = new Hashtable();
    private Hashtable threadStacks = new Hashtable();
    private TimedElement buildElement = null;

    private static DocumentBuilder getDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exc) {
            throw new ExceptionInInitializerError(exc);
        }
    }

    public void buildStarted(BuildEvent event) {
        this.buildElement = new TimedElement();
        this.buildElement.startTime = System.currentTimeMillis();
        this.buildElement.element = this.doc.createElement(BUILD_TAG);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void buildFinished(BuildEvent event) {
        block12: {
            String xslUri;
            String outFilename;
            long totalTime = System.currentTimeMillis() - this.buildElement.startTime;
            this.buildElement.element.setAttribute(TIME_ATTR, DefaultLogger.formatTime(totalTime));
            if (event.getException() != null) {
                this.buildElement.element.setAttribute(ERROR_ATTR, event.getException().toString());
                Throwable t = event.getException();
                CDATASection errText = this.doc.createCDATASection(StringUtils.getStackTrace(t));
                Element stacktrace = this.doc.createElement(STACKTRACE_TAG);
                stacktrace.appendChild(errText);
                this.buildElement.element.appendChild(stacktrace);
            }
            if ((outFilename = event.getProject().getProperty("XmlLogger.file")) == null) {
                outFilename = "log.xml";
            }
            if ((xslUri = event.getProject().getProperty("ant.XmlLogger.stylesheet.uri")) == null) {
                xslUri = "log.xsl";
            }
            Writer out = null;
            try {
                try {
                    void var7_8;
                    PrintStream printStream = this.outStream;
                    if (printStream == null) {
                        FileOutputStream fileOutputStream = new FileOutputStream(outFilename);
                    }
                    out = new OutputStreamWriter((OutputStream)var7_8, "UTF8");
                    out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                    if (xslUri.length() > 0) {
                        out.write("<?xml-stylesheet type=\"text/xsl\" href=\"" + xslUri + "\"?>\n\n");
                    }
                    new DOMElementWriter().write(this.buildElement.element, out, 0, "\t");
                    out.flush();
                }
                catch (IOException iOException) {
                    throw new BuildException("Unable to write log file", iOException);
                }
                Object var9_10 = null;
                if (out == null) break block12;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (out == null) throw throwable;
                try {
                    out.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e) {}
            out.close();
        }
        this.buildElement = null;
    }

    private Stack getStack() {
        Stack threadStack = (Stack)this.threadStacks.get(Thread.currentThread());
        if (threadStack == null) {
            threadStack = new Stack();
            this.threadStacks.put(Thread.currentThread(), threadStack);
        }
        return threadStack;
    }

    public void targetStarted(BuildEvent event) {
        Target target = event.getTarget();
        TimedElement targetElement = new TimedElement();
        targetElement.startTime = System.currentTimeMillis();
        targetElement.element = this.doc.createElement(TARGET_TAG);
        targetElement.element.setAttribute(NAME_ATTR, target.getName());
        this.targets.put(target, targetElement);
        this.getStack().push(targetElement);
    }

    public void targetFinished(BuildEvent event) {
        Target target = event.getTarget();
        TimedElement targetElement = (TimedElement)this.targets.get(target);
        if (targetElement != null) {
            long totalTime = System.currentTimeMillis() - targetElement.startTime;
            targetElement.element.setAttribute(TIME_ATTR, DefaultLogger.formatTime(totalTime));
            TimedElement parentElement = null;
            Stack threadStack = this.getStack();
            if (!threadStack.empty()) {
                TimedElement poppedStack = (TimedElement)threadStack.pop();
                if (poppedStack != targetElement) {
                    throw new RuntimeException("Mismatch - popped element = " + poppedStack + " finished target element = " + targetElement);
                }
                if (!threadStack.empty()) {
                    parentElement = (TimedElement)threadStack.peek();
                }
            }
            if (parentElement == null) {
                this.buildElement.element.appendChild(targetElement.element);
            } else {
                parentElement.element.appendChild(targetElement.element);
            }
        }
        this.targets.remove(target);
    }

    public void taskStarted(BuildEvent event) {
        TimedElement taskElement = new TimedElement();
        taskElement.startTime = System.currentTimeMillis();
        taskElement.element = this.doc.createElement(TASK_TAG);
        Task task = event.getTask();
        String name = event.getTask().getTaskName();
        taskElement.element.setAttribute(NAME_ATTR, name);
        taskElement.element.setAttribute(LOCATION_ATTR, event.getTask().getLocation().toString());
        this.tasks.put(task, taskElement);
        this.getStack().push(taskElement);
    }

    public void taskFinished(BuildEvent event) {
        Task task = event.getTask();
        TimedElement taskElement = (TimedElement)this.tasks.get(task);
        if (taskElement != null) {
            TimedElement poppedStack;
            long totalTime = System.currentTimeMillis() - taskElement.startTime;
            taskElement.element.setAttribute(TIME_ATTR, DefaultLogger.formatTime(totalTime));
            Target target = task.getOwningTarget();
            TimedElement targetElement = null;
            if (target != null) {
                targetElement = (TimedElement)this.targets.get(target);
            }
            if (targetElement == null) {
                this.buildElement.element.appendChild(taskElement.element);
            } else {
                targetElement.element.appendChild(taskElement.element);
            }
            Stack threadStack = this.getStack();
            if (!threadStack.empty() && (poppedStack = (TimedElement)threadStack.pop()) != taskElement) {
                throw new RuntimeException("Mismatch - popped element = " + poppedStack + " finished task element = " + taskElement);
            }
        } else {
            throw new RuntimeException("Unknown task " + task + " not in " + this.tasks);
        }
        this.tasks.remove(task);
    }

    private TimedElement getTaskElement(Task task) {
        TimedElement element = (TimedElement)this.tasks.get(task);
        if (element != null) {
            return element;
        }
        Enumeration e = this.tasks.keys();
        while (e.hasMoreElements()) {
            Task key = (Task)e.nextElement();
            if (!(key instanceof UnknownElement) || ((UnknownElement)key).getTask() != task) continue;
            return (TimedElement)this.tasks.get(key);
        }
        return null;
    }

    public void messageLogged(BuildEvent event) {
        int priority = event.getPriority();
        if (priority > this.msgOutputLevel) {
            return;
        }
        Element messageElement = this.doc.createElement(MESSAGE_TAG);
        String name = "debug";
        switch (event.getPriority()) {
            case 0: {
                name = ERROR_ATTR;
                break;
            }
            case 1: {
                name = "warn";
                break;
            }
            case 2: {
                name = "info";
                break;
            }
            default: {
                name = "debug";
            }
        }
        messageElement.setAttribute(PRIORITY_ATTR, name);
        CDATASection messageText = this.doc.createCDATASection(event.getMessage());
        messageElement.appendChild(messageText);
        TimedElement parentElement = null;
        Task task = event.getTask();
        Target target = event.getTarget();
        if (task != null) {
            parentElement = this.getTaskElement(task);
        }
        if (parentElement == null && target != null) {
            parentElement = (TimedElement)this.targets.get(target);
        }
        if (parentElement != null) {
            parentElement.element.appendChild(messageElement);
        } else {
            this.buildElement.element.appendChild(messageElement);
        }
    }

    public void setMessageOutputLevel(int level) {
        this.msgOutputLevel = level;
    }

    public void setOutputPrintStream(PrintStream output) {
        this.outStream = new PrintStream(output, true);
    }

    public void setEmacsMode(boolean emacsMode) {
    }

    public void setErrorPrintStream(PrintStream err) {
    }

    private static class TimedElement {
        private long startTime;
        private Element element;

        private TimedElement() {
        }

        public String toString() {
            return this.element.getTagName() + ":" + this.element.getAttribute(XmlLogger.NAME_ATTR);
        }
    }
}

