/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.Serializable;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Hits;

public class Hit
implements Serializable {
    private Document doc = null;
    private boolean resolved = false;
    private Hits hits = null;
    private int hitNumber;

    Hit(Hits hits, int hitNumber) {
        this.hits = hits;
        this.hitNumber = hitNumber;
    }

    public Document getDocument() throws IOException {
        if (!this.resolved) {
            this.fetchTheHit();
        }
        return this.doc;
    }

    public float getScore() throws IOException {
        return this.hits.score(this.hitNumber);
    }

    public int getId() throws IOException {
        return this.hits.id(this.hitNumber);
    }

    private void fetchTheHit() throws IOException {
        this.doc = this.hits.doc(this.hitNumber);
        this.resolved = true;
    }

    public float getBoost() throws IOException {
        return this.getDocument().getBoost();
    }

    public String get(String name) throws IOException {
        return this.getDocument().get(name);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Hit<");
        buffer.append(this.hits.toString());
        buffer.append(" [");
        buffer.append(this.hitNumber);
        buffer.append("] ");
        if (this.resolved) {
            buffer.append("resolved");
        } else {
            buffer.append("unresolved");
        }
        buffer.append(">");
        return buffer.toString();
    }
}

