/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.jmol.util.LimitedLineReader;
import org.jmol.util.Parser;

public class SurfaceFileTyper {
    public static final String PMESH_BINARY_MAGIC_NUMBER = "PM\u0001\u0000";

    public static String determineSurfaceFileType(InputStream inputStream) {
        BufferedReader bufferedReader;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(inputStream, 8192), "ISO-8859-1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        return SurfaceFileTyper.determineSurfaceFileType(bufferedReader);
    }

    public static String determineSurfaceFileType(BufferedReader bufferedReader) {
        LimitedLineReader limitedLineReader = new LimitedLineReader(bufferedReader, 16000);
        String string = limitedLineReader.info();
        if (string.length() == 0) {
            return null;
        }
        if (string.indexOf("Here is your gzipped map") >= 0) {
            return "UPPSALA" + string;
        }
        if (string.indexOf("<jvxl") >= 0 && string.indexOf("<?xml") >= 0) {
            return "JvxlXML";
        }
        if (string.indexOf("#JVXL+") >= 0) {
            return "Jvxl+";
        }
        if (string.indexOf("#JVXL") >= 0) {
            return "Jvxl";
        }
        if (string.indexOf("&plot") == 0) {
            return "Jaguar";
        }
        if (string.indexOf("<efvet ") >= 0) {
            return "Efvet";
        }
        if ("\n\r".indexOf(string.charAt(0)) >= 0 && string.indexOf("ZYX") >= 0) {
            return "Xplor";
        }
        int n = string.indexOf(0);
        if (n >= 0) {
            if (string.indexOf(PMESH_BINARY_MAGIC_NUMBER) == 0) {
                return "Pmesh";
            }
            if (string.indexOf("MAP ") == 208) {
                return "MRC";
            }
            if (string.length() > 37 && (string.charAt(36) == '\u0000' && string.charAt(37) == 'd' || string.charAt(36) == '\u0000' && string.charAt(37) == 'd')) {
                return "DSN6";
            }
        }
        if ((string = limitedLineReader.readNonCommentLine()).indexOf("object 1 class gridpositions counts") == 0) {
            return "Apbs";
        }
        String[] stringArray = Parser.getTokens(string);
        string = limitedLineReader.readNonCommentLine();
        if (stringArray.length == 2 && Parser.parseInt(stringArray[0]) == 3 && Parser.parseInt(stringArray[1]) != Integer.MIN_VALUE && (stringArray = Parser.getTokens(string)).length == 3 && Parser.parseInt(stringArray[0]) != Integer.MIN_VALUE && Parser.parseInt(stringArray[1]) != Integer.MIN_VALUE && Parser.parseInt(stringArray[2]) != Integer.MIN_VALUE) {
            return "PltFormatted";
        }
        string = limitedLineReader.readNonCommentLine();
        int n2 = Parser.parseInt(string);
        if (n2 == Integer.MIN_VALUE) {
            return string.indexOf("+") == 0 ? "Jvxl+" : null;
        }
        if (n2 >= 0) {
            return "Cube";
        }
        n2 = -n2;
        int n3 = 4 + n2;
        while (--n3 >= 0) {
            string = limitedLineReader.readNonCommentLine();
            if (string != null) continue;
            return null;
        }
        n3 = Parser.parseInt(string);
        if (n3 == Integer.MIN_VALUE) {
            return null;
        }
        return n3 < 0 ? "Jvxl" : "Cube";
    }
}

