/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import java.awt.Image;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolNode;
import org.jmol.api.MinimizerInterface;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.RadiusData;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.i18n.GT;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomCollection;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BoxInfo;
import org.jmol.modelset.Group;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.MeasurementData;
import org.jmol.modelset.ModelCollection;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.TickInfo;
import org.jmol.script.ContextToken;
import org.jmol.script.ParallelProcessor;
import org.jmol.script.ScriptCompiler;
import org.jmol.script.ScriptContext;
import org.jmol.script.ScriptFunction;
import org.jmol.script.ScriptMathProcessor;
import org.jmol.script.ScriptVariable;
import org.jmol.script.Token;
import org.jmol.shape.Object2d;
import org.jmol.util.BitSetUtil;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.Parser;
import org.jmol.util.Point3fi;
import org.jmol.util.Quaternion;
import org.jmol.util.SurfaceFileTyper;
import org.jmol.util.TextFormat;
import org.jmol.viewer.ActionManager;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.PropertyManager;
import org.jmol.viewer.ShapeManager;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptEvaluator {
    public static final String SCRIPT_COMPLETED = "Script completed";
    private boolean tQuiet;
    protected boolean isSyntaxCheck;
    private boolean isCmdLine_C_Option;
    protected boolean isCmdLine_c_or_C_Option;
    private boolean historyDisabled;
    protected boolean logMessages;
    private boolean debugScript;
    private boolean interruptExecution;
    private boolean executionPaused;
    private boolean executionStepping;
    private boolean isExecuting;
    private long timeBeginExecution;
    private long timeEndExecution;
    private static final String EXPRESSION_KEY = "e_x_p_r_e_s_s_i_o_n";
    ShapeManager shapeManager;
    private static final int scriptLevelMax = 20;
    private Thread currentThread;
    protected Viewer viewer;
    protected ScriptCompiler compiler;
    private Map<String, Object> definedAtomSets;
    private StringBuffer outputBuffer;
    private String contextPath = "";
    private String filename;
    private String functionName;
    private boolean isStateScript;
    int scriptLevel;
    private int scriptReportingLevel = 0;
    private int commandHistoryLevelMax = 0;
    private Token[][] aatoken;
    private short[] lineNumbers;
    private int[][] lineIndices;
    private Map<String, ScriptVariable> contextVariables;
    private String script;
    protected int pc;
    private String thisCommand;
    private String fullCommand;
    private Token[] statement;
    private int statementLength;
    private int iToken;
    private int lineEnd;
    private int pcEnd;
    private String scriptExtensions;
    private ParallelProcessor parallelProcessor;
    private ScriptContext thisContext = null;
    private boolean error;
    private String errorMessage;
    protected String errorMessageUntranslated;
    protected String errorType;
    protected int iCommandError;
    private boolean ignoreError;
    static final int ERROR_axisExpected = 0;
    static final int ERROR_backgroundModelError = 1;
    static final int ERROR_badArgumentCount = 2;
    static final int ERROR_badMillerIndices = 3;
    static final int ERROR_badRGBColor = 4;
    static final int ERROR_booleanExpected = 5;
    static final int ERROR_booleanOrNumberExpected = 6;
    static final int ERROR_booleanOrWhateverExpected = 7;
    static final int ERROR_colorExpected = 8;
    static final int ERROR_colorOrPaletteRequired = 9;
    static final int ERROR_commandExpected = 10;
    static final int ERROR_coordinateOrNameOrExpressionRequired = 11;
    static final int ERROR_drawObjectNotDefined = 12;
    static final int ERROR_endOfStatementUnexpected = 13;
    static final int ERROR_expressionExpected = 14;
    static final int ERROR_expressionOrIntegerExpected = 15;
    static final int ERROR_filenameExpected = 16;
    static final int ERROR_fileNotFoundException = 17;
    static final int ERROR_incompatibleArguments = 18;
    static final int ERROR_insufficientArguments = 19;
    static final int ERROR_integerExpected = 20;
    static final int ERROR_integerOutOfRange = 21;
    static final int ERROR_invalidArgument = 22;
    static final int ERROR_invalidParameterOrder = 23;
    static final int ERROR_keywordExpected = 24;
    static final int ERROR_moCoefficients = 25;
    static final int ERROR_moIndex = 26;
    static final int ERROR_moModelError = 27;
    static final int ERROR_moOccupancy = 28;
    static final int ERROR_moOnlyOne = 29;
    static final int ERROR_multipleModelsDisplayedNotOK = 30;
    static final int ERROR_noData = 31;
    static final int ERROR_noPartialCharges = 32;
    static final int ERROR_noUnitCell = 33;
    static final int ERROR_numberExpected = 34;
    static final int ERROR_numberMustBe = 35;
    static final int ERROR_numberOutOfRange = 36;
    static final int ERROR_objectNameExpected = 37;
    static final int ERROR_planeExpected = 38;
    static final int ERROR_propertyNameExpected = 39;
    static final int ERROR_spaceGroupNotFound = 40;
    static final int ERROR_stringExpected = 41;
    static final int ERROR_stringOrIdentifierExpected = 42;
    static final int ERROR_tooManyPoints = 43;
    static final int ERROR_tooManyScriptLevels = 44;
    static final int ERROR_unrecognizedAtomProperty = 45;
    static final int ERROR_unrecognizedBondProperty = 46;
    static final int ERROR_unrecognizedCommand = 47;
    static final int ERROR_unrecognizedExpression = 48;
    static final int ERROR_unrecognizedObject = 49;
    static final int ERROR_unrecognizedParameter = 50;
    static final int ERROR_unrecognizedParameterWarning = 51;
    static final int ERROR_unrecognizedShowParameter = 52;
    static final int ERROR_what = 53;
    static final int ERROR_writeWhat = 54;
    static final int ERROR_multipleModelsNotOK = 55;
    private Token[] tempStatement;
    private boolean isBondSet;
    private Object expressionResult;
    private int theTok;
    private Token theToken;
    private boolean coordinatesAreFractional;
    private List<Token[]> vProcess;
    static int iProcess;
    private Object[] data;
    private static Object testData;
    private static Object testData2;

    public ScriptEvaluator(Viewer viewer) {
        this.viewer = viewer;
        this.compiler = viewer.compiler;
        this.definedAtomSets = viewer.definedAtomSets;
    }

    public boolean compileScriptString(String string, boolean bl) {
        this.clearState(bl);
        this.contextPath = "[script]";
        return this.compileScript(null, string, this.debugScript);
    }

    public boolean compileScriptFile(String string, boolean bl) {
        this.clearState(bl);
        this.contextPath = string;
        return this.compileScriptFileInternal(string, null, null, null);
    }

    public void evaluateCompiledScript(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        boolean bl5 = this.isCmdLine_C_Option;
        this.isCmdLine_C_Option = bl2;
        this.viewer.pushHoldRepaint("runEval");
        this.executionPaused = false;
        this.interruptExecution = false;
        this.executionStepping = false;
        this.isExecuting = true;
        this.currentThread = Thread.currentThread();
        this.isSyntaxCheck = this.isCmdLine_c_or_C_Option = bl;
        this.timeBeginExecution = System.currentTimeMillis();
        this.historyDisabled = bl3;
        this.setErrorMessage(null);
        try {
            try {
                this.setScriptExtensions();
                this.instructionDispatchLoop(bl4);
                String string = this.viewer.getInterruptScript();
                if (string != "") {
                    this.runScript(string, null);
                }
            }
            catch (Error error) {
                this.viewer.handleError(error, false);
                this.setErrorMessage("" + error + " " + this.viewer.getShapeErrorState());
                this.errorMessageUntranslated = "" + error;
                this.scriptStatusOrBuffer(this.errorMessage);
            }
        }
        catch (ScriptException scriptException) {
            this.setErrorMessage(scriptException.toString());
            this.errorMessageUntranslated = scriptException.getErrorMessageUntranslated();
            this.scriptStatusOrBuffer(this.errorMessage);
            this.viewer.notifyError(this.errorMessage != null && this.errorMessage.indexOf("java.lang.OutOfMemoryError") >= 0 ? "Error" : "ScriptException", this.errorMessage, this.errorMessageUntranslated);
        }
        this.timeEndExecution = System.currentTimeMillis();
        this.isCmdLine_C_Option = bl5;
        if (this.errorMessage == null && this.interruptExecution) {
            this.setErrorMessage("execution interrupted");
        } else if (!this.tQuiet && !this.isSyntaxCheck) {
            this.viewer.scriptStatus(SCRIPT_COMPLETED);
        }
        bl3 = false;
        bl = false;
        this.isSyntaxCheck = false;
        this.isExecuting = false;
        this.viewer.setTainted(true);
        this.viewer.popHoldRepaint("runEval");
    }

    public void runScript(String string, StringBuffer stringBuffer) throws ScriptException {
        this.pushContext(null);
        this.contextPath = this.contextPath + " >> script() ";
        this.outputBuffer = stringBuffer;
        if (this.compileScript(null, string + "\u0001## EDITOR_IGNORE ##", false)) {
            this.instructionDispatchLoop(false);
        }
        this.popContext(false, false);
    }

    public ScriptContext checkScriptSilent(String string) {
        ScriptContext scriptContext = this.compiler.compile(null, string, false, true, false, true);
        if (scriptContext.errorType != null) {
            return scriptContext;
        }
        this.restoreScriptContext(scriptContext, false, false, false);
        this.isSyntaxCheck = true;
        this.isCmdLine_C_Option = false;
        this.isCmdLine_c_or_C_Option = false;
        this.pc = 0;
        try {
            this.instructionDispatchLoop(false);
        }
        catch (ScriptException scriptException) {
            this.setErrorMessage(scriptException.toString());
            scriptContext = this.getScriptContext();
        }
        this.isSyntaxCheck = false;
        return scriptContext;
    }

    public void setDebugging() {
        this.debugScript = this.viewer.getDebugScript();
        this.logMessages = this.debugScript && Logger.debugging;
    }

    public int getExecutionWalltime() {
        return (int)(this.timeEndExecution - this.timeBeginExecution);
    }

    public void haltExecution() {
        this.resumePausedExecution();
        this.interruptExecution = true;
    }

    public void pauseExecution(boolean bl) {
        if (this.isSyntaxCheck) {
            return;
        }
        if (bl) {
            this.delay(-100L);
        }
        this.viewer.popHoldRepaint("pauseExecution");
        this.executionStepping = false;
        this.executionPaused = true;
    }

    public void stepPausedExecution() {
        this.executionStepping = true;
        this.executionPaused = false;
    }

    public void resumePausedExecution() {
        this.executionPaused = false;
        this.executionStepping = false;
    }

    public boolean isScriptExecuting() {
        return this.isExecuting && !this.interruptExecution;
    }

    public boolean isExecutionPaused() {
        return this.executionPaused;
    }

    public boolean isExecutionStepping() {
        return this.executionStepping;
    }

    public String getNextStatement() {
        return this.pc < this.aatoken.length ? ScriptEvaluator.setErrorLineMessage(this.functionName, this.filename, this.getLinenumber(null), this.pc, ScriptEvaluator.statementAsString(this.aatoken[this.pc], -9999, this.logMessages)) : "";
    }

    private String getCommand(int n, boolean bl, boolean bl2) {
        if (n >= this.lineIndices.length) {
            return "";
        }
        if (bl) {
            int n2 = -1;
            int n3 = this.script.length();
            for (int i = 0; i < this.lineNumbers.length; ++i) {
                if (this.lineNumbers[i] == this.lineNumbers[n]) {
                    if (n2 < 0) {
                        n2 = this.lineIndices[i][0];
                    }
                    n3 = this.lineIndices[i][1];
                    continue;
                }
                if (this.lineNumbers[i] == 0 || this.lineNumbers[i] > this.lineNumbers[n]) break;
            }
            if (n3 == this.script.length() - 1 && this.script.endsWith("}")) {
                ++n3;
            }
            return n2 == this.script.length() || n3 < n2 ? "" : this.script.substring(Math.max(n2, 0), Math.min(this.script.length(), n3));
        }
        int n4 = this.lineIndices[n][0];
        int n5 = this.lineIndices[n][1];
        String string = "";
        if (n4 < 0 || n5 <= n4 || n5 > this.script.length()) {
            return "";
        }
        try {
            string = this.script.substring(n4, n5);
            if (string.indexOf("\\\n") >= 0) {
                string = TextFormat.simpleReplace(string, "\\\n", "  ");
            }
            if (string.indexOf("\\\r") >= 0) {
                string = TextFormat.simpleReplace(string, "\\\r", "  ");
            }
            if (string.length() > 0 && !string.endsWith(";")) {
                string = string + ";";
            }
        }
        catch (Exception exception) {
            Logger.error("darn problem in Eval getCommand: ichBegin=" + n4 + " ichEnd=" + n5 + " len = " + this.script.length() + "\n" + exception);
        }
        return string;
    }

    private void logDebugScript(int n) {
        if (this.logMessages) {
            if (this.statement.length > 0) {
                Logger.debug(this.statement[0].toString());
            }
            for (int i = 1; i < this.statementLength; ++i) {
                Logger.debug(this.statement[i].toString());
            }
        }
        this.iToken = -9999;
        if (this.logMessages) {
            StringBuffer stringBuffer = new StringBuffer(80);
            String string = n > 0 ? "                          ".substring(0, n * 2) : "";
            stringBuffer.append(string).append(ScriptEvaluator.statementAsString(this.statement, this.iToken, this.logMessages));
            this.viewer.scriptStatus(stringBuffer.toString());
        } else {
            String string = this.getCommand(this.pc, false, false);
            if (string != "") {
                this.viewer.scriptStatus(string);
            }
        }
    }

    public static Object evaluateExpression(Viewer viewer, Object object) {
        ScriptEvaluator scriptEvaluator = new ScriptEvaluator(viewer);
        try {
            if (object instanceof String) {
                if (scriptEvaluator.compileScript(null, "e_x_p_r_e_s_s_i_o_n = " + object, false)) {
                    scriptEvaluator.contextVariables = viewer.getContextVariables();
                    scriptEvaluator.setStatement(0);
                    return scriptEvaluator.parameterExpressionString(2, 0);
                }
            } else if (object instanceof Token[]) {
                scriptEvaluator.contextVariables = viewer.getContextVariables();
                return scriptEvaluator.atomExpression((Token[])object, 0, 0, true, false, true, false);
            }
        }
        catch (Exception exception) {
            Logger.error("Error evaluating: " + object + "\n" + exception);
        }
        return "ERROR";
    }

    public static boolean evaluateContext(Viewer viewer, ScriptContext scriptContext, ShapeManager shapeManager) {
        ScriptEvaluator scriptEvaluator = new ScriptEvaluator(viewer);
        scriptEvaluator.compiler = new ScriptCompiler(scriptEvaluator.compiler);
        scriptEvaluator.shapeManager = shapeManager;
        try {
            scriptEvaluator.restoreScriptContext(scriptContext, true, false, false);
            scriptEvaluator.instructionDispatchLoop(false);
        }
        catch (Exception exception) {
            viewer.setStringProperty("_errormessage", "" + exception);
            Logger.error("Error evaluating context");
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public static BitSet getAtomBitSet(ScriptEvaluator scriptEvaluator, Object object) {
        if (object instanceof BitSet) {
            return (BitSet)object;
        }
        BitSet bitSet = new BitSet();
        try {
            scriptEvaluator.pushContext(null);
            String string = "select (" + object + ")";
            string = TextFormat.replaceAllCharacters(string, "\n\r", "),(");
            string = TextFormat.simpleReplace(string, "()", "(none)");
            if (scriptEvaluator.compileScript(null, string, false)) {
                scriptEvaluator.statement = scriptEvaluator.aatoken[0];
                bitSet = scriptEvaluator.atomExpression(scriptEvaluator.statement, 1, 0, false, false, true, true);
            }
            scriptEvaluator.popContext(false, false);
        }
        catch (Exception exception) {
            Logger.error("getAtomBitSet " + object + "\n" + exception);
        }
        return bitSet;
    }

    public static List<Integer> getAtomBitSetVector(ScriptEvaluator scriptEvaluator, int n, Object object) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        BitSet bitSet = ScriptEvaluator.getAtomBitSet(scriptEvaluator, object);
        int n2 = bitSet.nextSetBit(0);
        while (n2 >= 0) {
            arrayList.add(n2);
            n2 = bitSet.nextSetBit(n2 + 1);
        }
        return arrayList;
    }

    private List<ScriptVariable> parameterExpressionList(int n, int n2) throws ScriptException {
        return (List)this.parameterExpression(n, n2, null, true, true, -1, false, null, null);
    }

    private String parameterExpressionString(int n, int n2) throws ScriptException {
        return (String)this.parameterExpression(n, n2, "", true, false, -1, false, null, null);
    }

    private boolean parameterExpressionBoolean(int n, int n2) throws ScriptException {
        return (Boolean)this.parameterExpression(n, n2, null, true, false, -1, false, null, null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private Object parameterExpression(int n, int n2, String string, boolean bl, boolean bl2, int n3, boolean bl3, Map hashtable, String string2) throws ScriptException {
        ScriptVariable scriptVariable;
        boolean bl4 = string2 != null;
        boolean bl5 = n < 0;
        boolean bl6 = !bl2 && string == null;
        boolean bl7 = !bl2 && string != null && string.length() == 0;
        int n4 = 0;
        if (bl5) {
            n = -n;
        }
        int n5 = 0;
        ScriptMathProcessor scriptMathProcessor = new ScriptMathProcessor(this, bl3, bl2, false);
        if (n == 0 && n2 == 0) {
            n = 2;
        }
        if (n2 < n) {
            n2 = this.statementLength;
        }
        block31: for (int i = n; i < n2; ++i) {
            void var10_19;
            Object var10_20 = null;
            int n6 = this.getToken((int)i).tok;
            if (bl4 && this.tokAt(i + 1) != 0x100008) {
                ScriptVariable scriptVariable2;
                ScriptVariable scriptVariable3 = scriptVariable2 = hashtable != null && hashtable.containsKey(this.theToken.value) ? null : this.getBitsetPropertySelector(i, false);
                if (scriptVariable2 != null) {
                    scriptMathProcessor.addX((ScriptVariable)hashtable.get(string2));
                    if (!scriptMathProcessor.addOp(scriptVariable2)) {
                        this.error(22);
                    }
                    if ((scriptVariable2.intValue == 135368713 || scriptVariable2.intValue == 102436) && this.tokAt(this.iToken + 1) != 0x10100010) {
                        scriptMathProcessor.addOp(Token.tokenLeftParen);
                        scriptMathProcessor.addOp(Token.tokenRightParen);
                    }
                    i = this.iToken;
                    continue;
                }
            }
            block0 : switch (n6) {
                case 135369225: {
                    if (this.getToken((int)(++i)).tok != 0x10100010) {
                        this.error(22);
                    }
                    if (hashtable == null) {
                        hashtable = new Hashtable();
                    }
                    Object object3 = this.parameterExpression(++i, -1, null, bl, false, -1, false, hashtable, string2);
                    boolean bl8 = (Boolean)object3;
                    int n7 = this.iToken;
                    if (this.getToken((int)n7++).tok != 0x10000F) {
                        this.error(22);
                    }
                    this.parameterExpressionBoolean(n7, -1);
                    int n8 = this.iToken;
                    if (this.tokAt(n8++) != 0x10000F) {
                        this.error(22);
                    }
                    this.parameterExpression(-n8, -1, null, bl, false, 1, false, hashtable, string2);
                    int n9 = this.iToken;
                    if (this.tokAt(n9) != 0x10100011) {
                        this.error(22);
                    }
                    Object object2 = this.parameterExpression(bl8 ? n7 : n8, bl8 ? n8 : n9, "XXX", bl, false, 1, false, hashtable, string2);
                    i = n9;
                    break;
                }
                case 135280131: 
                case 135369224: {
                    int n10;
                    int n11;
                    Object object;
                    String string3;
                    boolean bl9;
                    Object object3;
                    boolean bl10 = n > 0;
                    boolean bl11 = bl9 = bl10 && n6 == 135369224;
                    if (bl10) {
                        if (this.getToken((int)(++i)).tok != 0x10100010 || !Token.tokAttr(this.getToken((int)(++i)).tok, 0x40000000)) {
                            this.error(22);
                        }
                        string3 = this.parameterAsString(i);
                        if (this.getToken((int)(++i)).tok != 0x10000F) {
                            this.error(22);
                        }
                    } else {
                        string3 = "_x";
                    }
                    if (!((object = this.tokenSetting((int)(-(++i))).value) instanceof BitSet)) {
                        this.error(22);
                    }
                    BitSet bitSet = (BitSet)object;
                    i = this.iToken;
                    if (bl10 && this.getToken((int)i++).tok != 0x10000F) {
                        this.error(22);
                    }
                    BitSet bitSet2 = new BitSet();
                    BitSet bitSet3 = new BitSet();
                    String[] stringArray = bl9 ? new String[BitSetUtil.cardinalityOf(bitSet)] : null;
                    ScriptVariable scriptVariable4 = null;
                    if (hashtable == null) {
                        hashtable = new Hashtable();
                    }
                    bitSet3.set(0);
                    scriptVariable4 = ScriptVariable.getVariableSelected(0, bitSet3).setName(string3);
                    hashtable.put(string3, scriptVariable4);
                    int n12 = -1;
                    if (bl10) {
                        n12 = i - 1;
                        n11 = 0;
                        while (n11 >= 0 && ++n12 < n2) {
                            n10 = this.tokAt(n12);
                            if (n10 == 0x10100011) {
                                --n11;
                                continue;
                            }
                            if (n10 != 0x10100010) continue;
                            ++n11;
                        }
                    }
                    n11 = 0;
                    n10 = 0;
                    int n13 = bitSet.nextSetBit(0);
                    if (n13 < 0) {
                        this.iToken = n12 - 1;
                    } else if (!this.isSyntaxCheck) {
                        while (n13 >= 0) {
                            if (n10 >= 0) {
                                bitSet3.clear(n10);
                            }
                            n10 = n13;
                            bitSet3.set(n13);
                            scriptVariable4.index = n13;
                            object3 = this.parameterExpression(i, n12, bl9 ? "XXX" : null, bl, bl9, n13, false, hashtable, bl10 ? null : string3);
                            if (bl9) {
                                if (object3 == null || ((List)object3).size() == 0) {
                                    this.error(22);
                                }
                                stringArray[n11++] = ScriptVariable.sValue((ScriptVariable)((List)object3).get(0));
                            } else if (((Boolean)object3).booleanValue()) {
                                bitSet2.set(n13);
                            }
                            n13 = bitSet.nextSetBit(n13 + 1);
                        }
                    }
                    if (bl9) {
                        String[] stringArray2 = stringArray;
                    } else {
                        if (!bl10) return this.bitsetVariableVector(bitSet2);
                        BitSet bitSet4 = bitSet2;
                    }
                    i = this.iToken + 1;
                    break;
                }
                case 0x10000F: {
                    break block31;
                }
                case 3: {
                    scriptMathProcessor.addXNum(ScriptVariable.getVariable(this.theToken.value));
                    break;
                }
                case 2: 
                case 1048614: {
                    scriptMathProcessor.addXNum(ScriptVariable.intVariable(this.theToken.intValue));
                    break;
                }
                case 135266319: {
                    if (this.tokAt(this.iToken + 1) == 0x10100010) {
                        if (scriptMathProcessor.addOp(this.theToken, true)) break;
                        this.error(22);
                        break;
                    }
                    scriptMathProcessor.addX(new ScriptVariable(this.theToken));
                    break;
                }
                case 4: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 0x100004: 
                case 0x100006: 
                case 0x10000C: 
                case 0x10000D: 
                case 135267335: 
                case 135267336: 
                case 0x40D00004: 
                case 1087373318: 
                case 1087373320: 
                case 1087375361: 
                case 1087375362: 
                case 1087375365: 
                case 1095761934: 
                case 1095761938: 
                case 1095766028: 
                case 1641025539: 
                case 1679429641: {
                    scriptMathProcessor.addX(new ScriptVariable(this.theToken));
                    break;
                }
                case 0x100007: {
                    scriptMathProcessor.addX(new ScriptVariable(8, this.centerParameter(i)));
                    i = this.iToken;
                    break;
                }
                case 0x10000A: {
                    if (this.tokAt(i + 1) == 4) {
                        Map<String, Object> map = this.getHash(i);
                    } else {
                        Object object = this.getPointOrPlane(i, false, true, true, false, 3, 4);
                    }
                    i = this.iToken;
                    break;
                }
                case 0x100001: {
                    if (this.tokAt(i + 1) == 0x100002) {
                        BitSet bitSet = new BitSet();
                        ++i;
                        break;
                    }
                    if (this.tokAt(i + 1) == 0x100003 && this.tokAt(i + 2) == 0x100002) {
                        n6 = 0x100003;
                        this.iToken += 2;
                    }
                }
                case 0x100003: {
                    void var10_32;
                    if (n6 == 0x100003) {
                        BitSet bitSet = this.viewer.getModelUndeletedAtomsBitSet(-1);
                    } else {
                        BitSet bitSet = this.atomExpression(this.statement, i, 0, true, true, true, true);
                    }
                    i = this.iToken++;
                    if (n5 != 0 || !bl5) break;
                    return this.bitsetVariableVector(var10_32);
                }
                case 0x100002: {
                    ++i;
                    break block31;
                }
                case 0x10000E: {
                    if (!bl && n5 == 0 && n4 == 0) break block31;
                    this.error(22);
                    break;
                }
                case 0x10100030: {
                    if (!bl && n5 == 0 && n4 == 0) break block31;
                    if (scriptMathProcessor.addOp(this.theToken)) break;
                    this.error(22);
                    break;
                }
                case 0x100008: {
                    ScriptVariable scriptVariable5 = this.getBitsetPropertySelector(i + 1, false);
                    if (scriptVariable5 == null) {
                        this.error(22);
                    }
                    boolean bl12 = scriptVariable5.intValue == 135368713;
                    boolean bl13 = true;
                    int n14 = this.tokAt(this.iToken + 2);
                    if (this.tokAt(this.iToken + 1) == 0x100008) {
                        switch (n14) {
                            case 0x100003: {
                                n14 = 480;
                                if (this.tokAt(this.iToken + 3) == 0x100008 && this.tokAt(this.iToken + 4) == 1276118529) {
                                    n14 = 224;
                                }
                            }
                            case 32: 
                            case 64: 
                            case 96: 
                            case 128: 
                            case 160: 
                            case 192: {
                                bl13 = bl12 || n14 == 480 || n14 == 224;
                                scriptVariable5.intValue |= n14;
                                this.getToken(this.iToken + 2);
                                break;
                            }
                        }
                    }
                    if (!scriptMathProcessor.addOp(scriptVariable5, bl13 &= this.tokAt(this.iToken + 1) == 0x10100010 || bl12)) {
                        this.error(22);
                    }
                    i = this.iToken;
                    if (scriptVariable5.intValue != 135368713 || this.tokAt(i + 1) == 0x10100010) break;
                    scriptMathProcessor.addOp(Token.tokenLeftParen);
                    scriptMathProcessor.addOp(Token.tokenRightParen);
                    break;
                }
                default: {
                    ScriptVariable scriptVariable6;
                    Object v;
                    if (Token.tokAttr(this.theTok, 0x10100000) || Token.tokAttr(this.theTok, 0x8100000) && this.tokAt(this.iToken + 1) == 0x10100010) {
                        if (!scriptMathProcessor.addOp(this.theToken)) {
                            if (n3 >= 0) break block31;
                            this.error(22);
                        }
                        switch (this.theTok) {
                            case 0x10100010: {
                                ++n5;
                                break block0;
                            }
                            case 0x10100011: {
                                if (--n5 != 0 || !bl5) break;
                                ++this.iToken;
                                break block31;
                            }
                            case 0x10100040: {
                                ++n4;
                                break block0;
                            }
                            case 0x10100041: {
                                --n4;
                            }
                        }
                        break;
                    }
                    if (Token.tokAttr(this.theTok, 0x40000000) && this.viewer.isFunction((String)this.theToken.value)) {
                        if (!scriptMathProcessor.addOp(new ScriptVariable(135368713, this.theToken.value))) {
                            this.error(22);
                        }
                        if (this.tokAt(i + 1) == 0x10100010) break;
                        scriptMathProcessor.addOp(Token.tokenLeftParen);
                        scriptMathProcessor.addOp(Token.tokenRightParen);
                        break;
                    }
                    String string4 = this.parameterAsString(i).toLowerCase();
                    if (this.isSyntaxCheck) {
                        String string5 = string4;
                        break;
                    }
                    if (hashtable != null && (v = hashtable.get(string4)) != null || (scriptVariable6 = this.getContextVariableAsVariable(string4)) != null) break;
                    scriptMathProcessor.addX(this.viewer.getOrSetNewVariable(string4, false));
                    break;
                }
            }
            if (var10_19 == null) continue;
            if (var10_19 instanceof BitSet) {
                scriptMathProcessor.addX((BitSet)var10_19);
                continue;
            }
            scriptMathProcessor.addX(var10_19);
        }
        if ((scriptVariable = scriptMathProcessor.getResult(false)) == null) {
            if (!this.isSyntaxCheck) {
                scriptMathProcessor.dumpStacks("null result");
            }
            this.error(13);
        }
        if (scriptVariable.tok == 135233) {
            return scriptVariable.value;
        }
        if (bl6) {
            return ScriptVariable.bValue(scriptVariable);
        }
        if (bl7) {
            if (scriptVariable.tok != 4) return ScriptVariable.sValue(scriptVariable);
            scriptVariable.intValue = Integer.MAX_VALUE;
            return ScriptVariable.sValue(scriptVariable);
        }
        switch (scriptVariable.tok) {
            case 0x10000C: 
            case 0x10000D: {
                boolean bl14;
                if (scriptVariable.intValue == 1) {
                    bl14 = true;
                    return bl14;
                }
                bl14 = false;
                return bl14;
            }
            case 2: {
                return scriptVariable.intValue;
            }
        }
        return scriptVariable.value;
    }

    private Map<String, Object> getHash(int n) throws ScriptException {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        ++n;
        while (n < this.statementLength && this.tokAt(n) != 0x10000E) {
            String string = this.stringParameter(n++);
            if (this.tokAt(n++) != 0x10100022) {
                this.error(22);
            }
            List list = (List)this.parameterExpression(n, 0, null, false, true, -1, false, null, null);
            hashtable.put(string, list.get(0));
            n = this.iToken;
            if (this.tokAt(n) != 0x10100030) break;
            ++n;
        }
        this.iToken = n;
        if (this.tokAt(n) != 0x10000E) {
            this.error(22);
        }
        return hashtable;
    }

    List<ScriptVariable> bitsetVariableVector(Object object) {
        ArrayList<ScriptVariable> arrayList = new ArrayList<ScriptVariable>();
        if (object instanceof BitSet) {
            arrayList.add(new ScriptVariable(10, object));
        }
        return arrayList;
    }

    Object getBitsetIdent(BitSet bitSet, String stringArray, Object object, boolean bl, int n, boolean bl2) {
        int n2;
        Map<String, Object> map;
        int[] nArray;
        boolean bl3;
        boolean bl4;
        boolean bl5 = bl4 = !(object instanceof Bond.BondSet);
        if (bl4) {
            if (stringArray == null) {
                stringArray = this.viewer.getStandardLabelFormat();
            } else if (stringArray.length() == 0) {
                stringArray = "%[label]";
            }
        }
        int n3 = stringArray == null ? -1 : stringArray.indexOf("%");
        boolean bl6 = bl3 = n != Integer.MAX_VALUE;
        if (bitSet == null || this.isSyntaxCheck || bl4 && n3 < 0) {
            String[] stringArray2;
            if (stringArray == null) {
                stringArray = "";
            }
            if (bl2) {
                String[] stringArray3 = new String[1];
                stringArray2 = stringArray3;
                stringArray3[0] = stringArray;
            } else {
                stringArray2 = stringArray;
            }
            return stringArray2;
        }
        ModelSet modelSet = this.viewer.getModelSet();
        int n4 = 0;
        int[] nArray2 = nArray = bl4 || !bl ? null : ((Bond.BondSet)object).getAssociatedAtoms();
        if (nArray == null && stringArray != null && stringArray.indexOf("%D") > 0) {
            nArray = this.viewer.getAtomIndices(bitSet);
        }
        boolean bl7 = stringArray == null || stringArray.length() == 0;
        Map<String, Object> map2 = map = bl4 || bl7 ? null : LabelToken.getBondLabelValues();
        LabelToken[] labelTokenArray = bl7 ? null : (bl4 ? LabelToken.compile(this.viewer, (String)stringArray, '\u0000', null) : LabelToken.compile(this.viewer, (String)stringArray, '\u0001', map));
        int n5 = bl3 ? 1 : BitSetUtil.cardinalityOf(bitSet);
        String[] stringArray4 = new String[n5];
        int n6 = n2 = bl3 ? n : bitSet.nextSetBit(0);
        while (n2 >= 0) {
            String string;
            if (bl4) {
                string = bl7 ? modelSet.atoms[n2].getInfo() : LabelToken.formatLabel(this.viewer, modelSet.atoms[n2], null, labelTokenArray, '\u0000', nArray);
            } else {
                Bond bond = modelSet.getBondAt(n2);
                string = bl7 ? bond.getIdentity() : LabelToken.formatLabel(this.viewer, bond, labelTokenArray, map, nArray);
            }
            string = TextFormat.formatString(string, "#", n4 + 1);
            stringArray4[n4++] = string;
            if (bl3) break;
            n2 = bitSet.nextSetBit(n2 + 1);
        }
        return n5 == 1 && !bl2 ? stringArray4[0] : stringArray4;
    }

    private ScriptVariable getBitsetPropertySelector(int n, boolean bl) throws ScriptException {
        int n2 = this.getToken((int)n).tok;
        String string = null;
        switch (n2) {
            case 32: 
            case 64: 
            case 96: 
            case 128: 
            case 160: 
            case 192: 
            case 1716520972: {
                break;
            }
            default: {
                if (Token.tokAttrOr(n2, 0x40500000, 0x44100000)) break;
                if (!Token.tokAttr(n2, 0x40000000)) {
                    return null;
                }
                String string2 = this.parameterAsString(n);
                if (!bl && this.viewer.isFunction(string2)) {
                    n2 = 135368713;
                    break;
                }
                return null;
            }
        }
        if (bl && !Token.tokAttr(n2, 2048)) {
            return null;
        }
        if (string == null) {
            string = this.parameterAsString(n).toLowerCase();
        }
        return new ScriptVariable(0x101000D1, n2, string);
    }

    private float[] getBitsetPropertyFloat(BitSet bitSet, int n, float f, float f2) throws ScriptException {
        int n2;
        float[] fArray = (float[])this.getBitsetProperty(bitSet, n, null, null, null, null, false, Integer.MAX_VALUE, false);
        if (!Float.isNaN(f)) {
            for (n2 = 0; n2 < fArray.length; ++n2) {
                if (!(fArray[n2] < f)) continue;
                fArray[n2] = Float.NaN;
            }
        }
        if (!Float.isNaN(f2)) {
            for (n2 = 0; n2 < fArray.length; ++n2) {
                if (!(fArray[n2] > f2)) continue;
                fArray[n2] = Float.NaN;
            }
        }
        return fArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Object getBitsetProperty(BitSet bitSet, int n, Point3f point3f, Point4f point4f, Object object, Object object2, boolean bl, int n2, boolean bl2) throws ScriptException {
        int n3;
        int n4;
        ArrayList<Object> arrayList;
        block143: {
            int n5;
            int n6;
            Point3f point3f2;
            float[] fArray;
            block142: {
                double d;
                double d2;
                float f;
                int n7;
                int n8;
                Point3f point3f3;
                boolean bl3;
                boolean bl4;
                int n9;
                block141: {
                    boolean bl5;
                    boolean bl6;
                    boolean bl7;
                    block138: {
                        int n10;
                        ModelSet modelSet;
                        Point3f point3f4;
                        block140: {
                            int n11;
                            float[] fArray2;
                            ScriptVariable scriptVariable;
                            BitSet bitSet2;
                            List list;
                            String string;
                            int n12;
                            boolean bl8;
                            block139: {
                                bl8 = n2 != Integer.MAX_VALUE;
                                boolean bl9 = bl8 || !(object instanceof Bond.BondSet);
                                n9 = n & 0x1E0;
                                bl7 = n9 == 224;
                                n12 = this.viewer.getAtomCount();
                                fArray = n9 == 256 ? new float[n12] : null;
                                boolean bl10 = bl6 = n9 == 480 || bl7;
                                if ((n &= 0xFFFFFE1F) == 0) {
                                    n = bl9 ? 0x44100001 : 1678770178;
                                }
                                bl4 = false;
                                bl3 = false;
                                bl5 = false;
                                switch (n) {
                                    case 1146093581: 
                                    case 1146095626: 
                                    case 1146095627: 
                                    case 1146095628: 
                                    case 1146095630: 
                                    case 1766856708: {
                                        bl4 = true;
                                        break;
                                    }
                                    case 135368713: 
                                    case 1276118018: {
                                        break;
                                    }
                                    default: {
                                        bl3 = Token.tokAttr(n, 1095761920) && !Token.tokAttr(n, 1112539136);
                                        bl5 = !bl3 && Token.tokAttr(n, 0x40D00000);
                                    }
                                }
                                point3f2 = n9 == 256 ? new Point3f() : null;
                                Point3f point3f5 = point3f3 = bl4 || !bl9 ? new Point3f() : null;
                                if (bl6 || bl5 && n9 != 256) {
                                    n9 = 0x100003;
                                }
                                arrayList = n9 == 0x100003 ? new ArrayList<Object>() : null;
                                BitSet bitSet3 = null;
                                string = null;
                                list = null;
                                bitSet2 = null;
                                scriptVariable = null;
                                point3f4 = null;
                                fArray2 = null;
                                switch (n) {
                                    case 0x44100001: 
                                    case 1678770178: {
                                        int n13;
                                        if (this.isSyntaxCheck) {
                                            return bitSet;
                                        }
                                        bitSet3 = n == 0x44100001 ? (bl9 ? bitSet : this.viewer.getAtomBits(1678770178, bitSet)) : (bl9 ? new Bond.BondSet(this.viewer.getBondsForSelectedAtoms(bitSet)) : bitSet);
                                        switch (n9) {
                                            case 32: {
                                                n13 = bitSet3.nextSetBit(0);
                                                break;
                                            }
                                            case 64: {
                                                n13 = bitSet3.length() - 1;
                                                break;
                                            }
                                            case 128: 
                                            case 160: 
                                            case 192: {
                                                return new Float(Float.NaN);
                                            }
                                            default: {
                                                return bitSet3;
                                            }
                                        }
                                        bitSet3.clear();
                                        if (n13 < 0) return bitSet3;
                                        bitSet3.set(n13);
                                        return bitSet3;
                                    }
                                    case 1087373321: {
                                        switch (n9) {
                                            case 0: 
                                            case 0x100003: {
                                                return this.getBitsetIdent(bitSet, null, object, bl, n2, bl6);
                                            }
                                        }
                                        return "";
                                    }
                                    case 135368713: {
                                        string = (String)((Object[])object2)[0];
                                        list = (List)((Object[])object2)[1];
                                        bitSet2 = new BitSet(n12);
                                        scriptVariable = new ScriptVariable(10, bitSet2);
                                        break;
                                    }
                                    case 1112539144: 
                                    case 1112539145: {
                                        this.viewer.autoCalculate(n);
                                        break;
                                    }
                                    case 1276118018: {
                                        if (point3f != null || point4f != null) break;
                                        return new Point3f();
                                    }
                                    case 1766856708: {
                                        point3f4 = new Point3f();
                                        break;
                                    }
                                    case 1716520972: {
                                        fArray2 = this.viewer.getDataFloat((String)object2);
                                        break;
                                    }
                                }
                                n8 = 0;
                                n11 = 0;
                                n7 = 0;
                                f = 0.0f;
                                d2 = 0.0;
                                d = 0.0;
                                switch (n9) {
                                    case 32: {
                                        n7 = Integer.MAX_VALUE;
                                        f = Float.MAX_VALUE;
                                        break;
                                    }
                                    case 64: {
                                        n7 = Integer.MIN_VALUE;
                                        f = -3.4028235E38f;
                                        break;
                                    }
                                }
                                modelSet = this.viewer.getModelSet();
                                int n14 = bl4 ? 3 : (bl5 ? 2 : (n6 = bl3 ? 1 : 0));
                                if (bl9) break block139;
                                n4 = bitSet == null ? 1 : 0;
                                n5 = n4 != 0 ? 0 : bitSet.nextSetBit(0);
                                n3 = this.viewer.getBondCount();
                                n10 = n5;
                                break block140;
                            }
                            n4 = bitSet != null ? 1 : 0;
                            n5 = -1;
                            if (bl8) {
                                n3 = n2;
                                n10 = n2 + 1;
                            } else if (n4 != 0) {
                                n3 = bitSet.nextSetBit(0);
                                n10 = Math.min(n12, bitSet.length());
                            } else {
                                n3 = 0;
                                n10 = n12;
                            }
                            if (this.isSyntaxCheck) {
                                n10 = 0;
                            }
                            int n15 = n3;
                            while (n15 >= 0 && n15 < n10) {
                                block137: {
                                    ++n8;
                                    Atom atom = modelSet.atoms[n15];
                                    block25 : switch (n6) {
                                        case 0: {
                                            float f2 = Float.MAX_VALUE;
                                            switch (n) {
                                                case 135368713: {
                                                    bitSet2.set(n15);
                                                    f2 = ScriptVariable.fValue(this.runFunction(null, string, list, scriptVariable, true));
                                                    bitSet2.clear(n15);
                                                    break;
                                                }
                                                case 1716520972: {
                                                    f2 = fArray2 == null ? 0.0f : fArray2[n15];
                                                    break;
                                                }
                                                case 1276118018: {
                                                    if (point4f != null) {
                                                        f2 = Measure.distanceToPlane(point4f, atom);
                                                        break;
                                                    }
                                                    f2 = atom.distance(point3f);
                                                    break;
                                                }
                                                default: {
                                                    f2 = Atom.atomPropertyFloat(this.viewer, atom, n);
                                                }
                                            }
                                            if (f2 == Float.MAX_VALUE || Float.isNaN(f2) && n9 != 0x100003) {
                                                --n8;
                                                break block137;
                                            } else {
                                                switch (n9) {
                                                    case 32: {
                                                        if (!(f2 < f)) break;
                                                        f = f2;
                                                        break;
                                                    }
                                                    case 64: {
                                                        if (!(f2 > f)) break;
                                                        f = f2;
                                                        break;
                                                    }
                                                    case 256: {
                                                        fArray[n15] = f2;
                                                        break;
                                                    }
                                                    case 0x100003: {
                                                        arrayList.add(Float.valueOf(f2));
                                                        break;
                                                    }
                                                    case 160: 
                                                    case 192: {
                                                        d += (double)f2 * (double)f2;
                                                    }
                                                    default: {
                                                        d2 += (double)f2;
                                                        break;
                                                    }
                                                }
                                                break;
                                            }
                                        }
                                        case 1: {
                                            Object object3;
                                            int n16 = 0;
                                            switch (n) {
                                                case 1297090050: {
                                                    if (atom.getModelIndex() != n5) {
                                                        n5 = atom.getModelIndex();
                                                    }
                                                    object3 = atom.getAtomSymmetry();
                                                    int n17 = 0;
                                                    switch (n9) {
                                                        case 32: {
                                                            n11 = Integer.MAX_VALUE;
                                                            break;
                                                        }
                                                        case 64: {
                                                            n11 = Integer.MIN_VALUE;
                                                            break;
                                                        }
                                                    }
                                                    int n18 = ((BitSet)object3).nextSetBit(0);
                                                    while (n18 >= 0) {
                                                        n16 += n18 + 1;
                                                        switch (n9) {
                                                            case 32: {
                                                                n11 = Math.min(n11, n18 + 1);
                                                                break;
                                                            }
                                                            case 64: {
                                                                n11 = Math.max(n11, n18 + 1);
                                                                break;
                                                            }
                                                        }
                                                        ++n17;
                                                        n18 = ((BitSet)object3).nextSetBit(n18 + 1);
                                                    }
                                                    switch (n9) {
                                                        case 32: 
                                                        case 64: {
                                                            n16 = n11;
                                                            break;
                                                        }
                                                    }
                                                    n8 += n17 - 1;
                                                    break;
                                                }
                                                case 1095761925: 
                                                case 1095766022: {
                                                    this.error(45, Token.nameOf(n));
                                                }
                                                default: {
                                                    n16 = Atom.atomPropertyInt(atom, n);
                                                }
                                            }
                                            switch (n9) {
                                                case 32: {
                                                    if (n16 >= n7) break;
                                                    n7 = n16;
                                                    break;
                                                }
                                                case 64: {
                                                    if (n16 <= n7) break;
                                                    n7 = n16;
                                                    break;
                                                }
                                                case 256: {
                                                    fArray[n15] = n16;
                                                    break;
                                                }
                                                case 0x100003: {
                                                    arrayList.add(n16);
                                                    break;
                                                }
                                                case 160: 
                                                case 192: {
                                                    d += (double)n16 * (double)n16;
                                                }
                                                default: {
                                                    d2 += (double)n16;
                                                    break;
                                                }
                                            }
                                            break;
                                        }
                                        case 2: {
                                            Object object3 = Atom.atomPropertyString(this.viewer, atom, n);
                                            switch (n9) {
                                                case 256: {
                                                    fArray[n15] = Parser.parseFloat((String)object3);
                                                    break block25;
                                                }
                                            }
                                            arrayList.add(object3);
                                            break;
                                        }
                                        case 3: {
                                            Tuple3f tuple3f = Atom.atomPropertyTuple(atom, n);
                                            if (tuple3f == null) {
                                                this.error(45, Token.nameOf(n));
                                            }
                                            switch (n9) {
                                                case 256: {
                                                    fArray[n15] = (float)Math.sqrt(tuple3f.x * tuple3f.x + tuple3f.y * tuple3f.y + tuple3f.z * tuple3f.z);
                                                    break block25;
                                                }
                                                case 0x100003: {
                                                    arrayList.add(new Point3f(tuple3f));
                                                    break block25;
                                                }
                                            }
                                            point3f3.add(tuple3f);
                                        }
                                    }
                                    if (bl8) break block138;
                                }
                                n15 = n4 != 0 ? bitSet.nextSetBit(n15 + 1) : n15 + 1;
                            }
                            break block138;
                        }
                        while (n10 >= 0 && n10 < n3) {
                            ++n8;
                            Bond bond = modelSet.getBondAt(n10);
                            block72 : switch (n) {
                                case 1141899267: {
                                    float f3 = bond.getAtom1().distance(bond.getAtom2());
                                    switch (n9) {
                                        case 32: {
                                            if (!(f3 < f)) break;
                                            f = f3;
                                            break;
                                        }
                                        case 64: {
                                            if (!(f3 > f)) break;
                                            f = f3;
                                            break;
                                        }
                                        case 0x100003: {
                                            arrayList.add(Float.valueOf(f3));
                                            break;
                                        }
                                        case 160: 
                                        case 192: {
                                            d += (double)f3 * (double)f3;
                                        }
                                        default: {
                                            d2 += (double)f3;
                                            break;
                                        }
                                    }
                                    break;
                                }
                                case 1146095626: {
                                    switch (n9) {
                                        case 0x100003: {
                                            point3f3.set(bond.getAtom1());
                                            point3f3.add(bond.getAtom2());
                                            point3f3.scale(0.5f);
                                            arrayList.add(new Point3f(point3f3));
                                            break block72;
                                        }
                                    }
                                    point3f3.add(bond.getAtom1());
                                    point3f3.add(bond.getAtom2());
                                    ++n8;
                                    break;
                                }
                                case 1766856708: {
                                    Graphics3D.colorPointFromInt(this.viewer.getColorArgbOrGray(bond.getColix()), point3f4);
                                    switch (n9) {
                                        case 0x100003: {
                                            arrayList.add(new Point3f(point3f4));
                                            break block72;
                                        }
                                    }
                                    point3f3.add(point3f4);
                                    break;
                                }
                                default: {
                                    this.error(46, Token.nameOf(n));
                                }
                            }
                            n10 = n4 != 0 ? n10 + 1 : bitSet.nextSetBit(n10 + 1);
                        }
                    }
                    if (n9 == 256) {
                        return fArray;
                    }
                    if (n9 != 0x100003) break block141;
                    if (bl2) {
                        return arrayList;
                    }
                    n4 = arrayList.size();
                    if (bl5 && !bl6 && n4 == 1) {
                        return arrayList.get(0);
                    }
                    if (bl7) break block142;
                    if (n == 1087373320) {
                        StringBuffer stringBuffer = new StringBuffer();
                        n3 = 0;
                        while (n3 < n4) {
                            stringBuffer.append((String)arrayList.get(n3));
                            ++n3;
                        }
                        return stringBuffer.toString();
                    }
                    break block143;
                }
                if (bl4) {
                    Point3f point3f6;
                    if (n8 == 0) {
                        point3f6 = point3f3;
                        return point3f6;
                    }
                    point3f6 = new Point3f(point3f3.x / (float)n8, point3f3.y / (float)n8, point3f3.z / (float)n8);
                    return point3f6;
                }
                if (n8 == 0) return new Float(Float.NaN);
                if (n8 == 1 && n9 == 192) {
                    return new Float(Float.NaN);
                }
                if (bl3) {
                    switch (n9) {
                        case 32: 
                        case 64: {
                            return n7;
                        }
                        case 160: 
                        case 192: {
                            break;
                        }
                        case 96: {
                            if (d2 / (double)n8 == (double)((int)(d2 / (double)n8))) {
                                return (int)(d2 / (double)n8);
                            }
                        }
                        default: {
                            if (d2 != (double)((int)d2)) break;
                            return (int)d2;
                        }
                    }
                }
                switch (n9) {
                    case 32: 
                    case 64: {
                        d2 = f;
                        return Float.valueOf((float)d2);
                    }
                    case 128: {
                        return Float.valueOf((float)d2);
                    }
                    case 160: {
                        d2 = d;
                        return Float.valueOf((float)d2);
                    }
                    case 192: {
                        d2 = Math.sqrt((d - d2 * d2 / (double)n8) / (double)(n8 - 1));
                        return Float.valueOf((float)d2);
                    }
                }
                d2 /= (double)n8;
                return Float.valueOf((float)d2);
            }
            fArray = new float[n4];
            n5 = n4;
            block110: while (--n5 >= 0) {
                Object e = arrayList.get(n5);
                switch (n6) {
                    case 0: {
                        fArray[n5] = ((Float)e).floatValue();
                        break;
                    }
                    case 1: {
                        fArray[n5] = ((Integer)e).floatValue();
                        break;
                    }
                    case 2: {
                        fArray[n5] = Parser.parseFloat((String)e);
                        break;
                    }
                    case 3: {
                        fArray[n5] = ((Point3f)e).distance(point3f2);
                        continue block110;
                    }
                }
            }
            return fArray;
        }
        String[] stringArray = new String[n4];
        n3 = n4;
        while (--n3 >= 0) {
            Object e = arrayList.get(n3);
            if (e instanceof Point3f) {
                stringArray[n3] = Escape.escape((Point3f)e);
                continue;
            }
            stringArray[n3] = "" + arrayList.get(n3);
        }
        return stringArray;
    }

    private void setBitsetProperty(BitSet bitSet, int n, int n2, float f, Token token) throws ScriptException {
        if (this.isSyntaxCheck || BitSetUtil.cardinalityOf(bitSet) == 0) {
            return;
        }
        String[] stringArray = null;
        String string = null;
        float[] fArray = null;
        switch (n) {
            case 1146095626: 
            case 1146095627: 
            case 1146095628: 
            case 1146095630: {
                if (token.tok == 8) {
                    this.viewer.setAtomCoord(bitSet, n, token.value);
                } else if (token.tok == 7) {
                    stringArray = (String[])token.value;
                    int n3 = stringArray.length;
                    if (n3 == 0) {
                        return;
                    }
                    Point3f[] point3fArray = new Point3f[n3];
                    int n4 = n3;
                    while (--n4 >= 0) {
                        Object object = Escape.unescapePoint(stringArray[n4]);
                        if (!(object instanceof Point3f)) {
                            this.error(50, "ARRAY", stringArray[n4]);
                        }
                        point3fArray[n4] = (Point3f)object;
                    }
                    this.viewer.setAtomCoord(bitSet, n, point3fArray);
                }
                return;
            }
            case 1766856708: {
                if (token.tok == 8) {
                    n2 = Graphics3D.colorPtToInt((Point3f)token.value);
                } else if (token.tok == 7) {
                    stringArray = (String[])token.value;
                    int n5 = stringArray.length;
                    if (n5 == 0) {
                        return;
                    }
                    int[] nArray = new int[n5];
                    int n6 = n5;
                    while (--n6 >= 0) {
                        Object object = Escape.unescapePoint(stringArray[n6]);
                        nArray[n6] = object instanceof Point3f ? Graphics3D.colorPtToInt((Point3f)object) : Graphics3D.getArgbFromString(stringArray[n6]);
                        if (nArray[n6] != 0 || (nArray[n6] = Parser.parseInt(stringArray[n6])) != Integer.MIN_VALUE) continue;
                        this.error(50, "ARRAY", stringArray[n6]);
                    }
                    this.setShapeProperty(0, "colorValues", nArray, bitSet);
                    return;
                }
                this.setShapeProperty(0, "color", token.tok == 4 ? token.value : Integer.valueOf(n2), bitSet);
                return;
            }
            case 1288701960: 
            case 1826248716: {
                if (token.tok == 7) {
                    stringArray = (String[])token.value;
                } else {
                    string = ScriptVariable.sValue(token);
                }
                this.viewer.setAtomProperty(bitSet, n, n2, f, string, fArray, stringArray);
                return;
            }
            case 1087375365: 
            case 1095763976: {
                this.clearDefinedVariableAtomSets();
            }
        }
        if (token.tok == 7 || token.tok == 4) {
            stringArray = token.tok == 7 ? (String[])token.value : Parser.getTokens(ScriptVariable.sValue(token));
            int n7 = stringArray.length;
            if (n7 == 0) {
                return;
            }
            fArray = new float[n7];
            int n8 = n7;
            while (--n8 >= 0) {
                fArray[n8] = n == 1087375365 ? (float)Elements.elementNumberFromSymbol(stringArray[n8], false) : Parser.parseFloat(stringArray[n8]);
            }
            if (token.tok == 4 && n7 == 1) {
                f = fArray[0];
                n2 = (int)f;
                string = stringArray[0];
                stringArray = null;
                fArray = null;
            }
        }
        this.viewer.setAtomProperty(bitSet, n, n2, f, string, fArray, stringArray);
    }

    public Map<String, ScriptVariable> getContextVariables() {
        return this.contextVariables;
    }

    public String getScript() {
        return this.script;
    }

    private boolean compileScript(String string, String string2, boolean bl) {
        this.filename = string;
        string2 = this.fixScriptPath(string2, string);
        this.restoreScriptContext(this.compiler.compile(string, string2, false, false, bl, false), false, false, false);
        this.isStateScript = this.script.indexOf("# Jmol state version ") >= 0;
        String string3 = this.script;
        this.pc = this.setScriptExtensions();
        if (!this.isSyntaxCheck && this.viewer.isScriptEditorVisible() && string2.indexOf("\u0001## EDITOR_IGNORE ##") < 0) {
            this.viewer.scriptStatus("");
        }
        this.script = string3;
        return !this.error;
    }

    private String fixScriptPath(String string, String string2) {
        if (string2 != null && string.indexOf("$SCRIPT_PATH$") >= 0) {
            String string3 = string2;
            int n = Math.max(string2.lastIndexOf("|"), string2.lastIndexOf("/"));
            string3 = string3.substring(0, n + 1);
            string = TextFormat.simpleReplace(string, "$SCRIPT_PATH$/", string3);
            string = TextFormat.simpleReplace(string, "$SCRIPT_PATH$", string3);
        }
        return string;
    }

    private int setScriptExtensions() {
        String string = this.scriptExtensions;
        if (string == null) {
            return 0;
        }
        int n = string.indexOf("##SCRIPT_STEP");
        if (n >= 0) {
            this.executionStepping = true;
        }
        if ((n = string.indexOf("##SCRIPT_START=")) < 0) {
            return 0;
        }
        if ((n = Parser.parseInt(string.substring(n + 15))) == Integer.MIN_VALUE) {
            return 0;
        }
        this.pc = 0;
        while (this.pc < this.lineIndices.length && this.lineIndices[this.pc][0] <= n && this.lineIndices[this.pc][1] < n) {
            ++this.pc;
        }
        if (this.pc > 0 && this.pc < this.lineIndices.length && this.lineIndices[this.pc][0] > n) {
            --this.pc;
        }
        return this.pc;
    }

    private void runScript(String string) throws ScriptException {
        if (!this.viewer.isPreviewOnly()) {
            this.runScript(string, this.outputBuffer);
        }
    }

    private boolean compileScriptFileInternal(String string, String string2, String string3, String string4) {
        if (string.toLowerCase().indexOf("javascript:") == 0) {
            return this.compileScript(string, this.viewer.jsEval(string.substring(11)), this.debugScript);
        }
        String[] stringArray = new String[2];
        stringArray[0] = string;
        if (!this.viewer.getFileAsString(stringArray, Integer.MAX_VALUE, false)) {
            this.setErrorMessage("io error reading " + stringArray[0] + ": " + stringArray[1]);
            return false;
        }
        this.filename = string;
        stringArray[1] = ScriptCompiler.getEmbeddedScript(stringArray[1]);
        String string5 = this.fixScriptPath(stringArray[1], stringArray[0]);
        if (string4 == null) {
            string4 = this.viewer.getFilePath(string, false);
            string4 = string4.substring(0, string4.lastIndexOf("/"));
        }
        string5 = FileManager.setScriptFileReferences(string5, string2, string3, string4);
        return this.compileScript(string, string5, this.debugScript);
    }

    private Object getParameter(String string, boolean bl) {
        Object object = this.getContextVariableAsVariable(string);
        if (object == null) {
            object = this.viewer.getParameter(string);
        }
        if (bl) {
            return object instanceof ScriptVariable ? (ScriptVariable)object : ScriptVariable.getVariable(object);
        }
        return object instanceof ScriptVariable ? ScriptVariable.oValue((ScriptVariable)object) : object;
    }

    private String getParameterEscaped(String string) {
        ScriptVariable scriptVariable = this.getContextVariableAsVariable(string);
        return scriptVariable == null ? "" + this.viewer.getParameterEscaped(string) : Escape.escape(scriptVariable.value);
    }

    private String getStringParameter(String string, boolean bl) {
        ScriptVariable scriptVariable = this.getContextVariableAsVariable(string);
        if (scriptVariable != null) {
            return ScriptVariable.sValue(scriptVariable);
        }
        String string2 = "" + this.viewer.getParameter(string);
        return string2.length() == 0 && bl ? string : string2;
    }

    private Object getNumericParameter(String string) {
        if (string.equalsIgnoreCase("_modelNumber")) {
            int n = this.viewer.getCurrentModelIndex();
            return n < 0 ? 0 : this.viewer.getModelFileNumber(n);
        }
        ScriptVariable scriptVariable = this.getContextVariableAsVariable(string);
        if (scriptVariable == null) {
            Object object = this.viewer.getParameter(string);
            if (!(object instanceof String)) {
                return object;
            }
            scriptVariable = new ScriptVariable(4, object);
        }
        return ScriptVariable.nValue(scriptVariable);
    }

    private ScriptVariable getContextVariableAsVariable(String string) {
        if (string.equals("expressionBegin")) {
            return null;
        }
        string = string.toLowerCase();
        if (this.contextVariables != null && this.contextVariables.containsKey(string)) {
            return this.contextVariables.get(string);
        }
        ScriptContext scriptContext = this.thisContext;
        while (scriptContext != null) {
            if (scriptContext.contextVariables != null && scriptContext.contextVariables.containsKey(string)) {
                return scriptContext.contextVariables.get(string);
            }
            scriptContext = scriptContext.parentContext;
        }
        return null;
    }

    private Object getStringObjectAsVariable(String string, String string2) {
        if (string == null || string.length() == 0) {
            return string;
        }
        Object object = ScriptVariable.unescapePointOrBitsetAsVariable(string);
        if (object instanceof String && string2 != null) {
            object = this.viewer.setUserVariable(string2, new ScriptVariable(4, object));
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ScriptVariable runFunction(ScriptFunction scriptFunction, String string, List<ScriptVariable> list, ScriptVariable scriptVariable, boolean bl) throws ScriptException {
        ScriptFunction scriptFunction2;
        this.pushContext(null);
        if (scriptFunction == null) {
            scriptFunction = this.viewer.getFunction(string);
            this.contextPath = this.contextPath + " >> function " + string;
        } else {
            this.contextPath = this.contextPath + " >> " + string;
        }
        if (scriptFunction == null) {
            return null;
        }
        this.functionName = string;
        if (scriptFunction instanceof ParallelProcessor) {
            scriptFunction2 = scriptFunction;
            synchronized (scriptFunction2) {
                this.parallelProcessor = (ParallelProcessor)scriptFunction;
                this.vProcess = null;
                this.runFunction(scriptFunction, list, scriptVariable);
                boolean bl2 = scriptFunction.tok == 364558;
                ScriptContext scriptContext = this.getScriptContext();
                if (bl2) {
                    this.contextVariables.put("_breakval", ScriptVariable.intVariable(Integer.MAX_VALUE));
                    this.contextVariables.put("_errorval", ScriptVariable.getVariable(""));
                    this.viewer.resetError();
                    this.parallelProcessor.addProcess("try", scriptContext);
                }
                ((ParallelProcessor)scriptFunction).runAllProcesses(this.viewer, !bl2);
                if (bl2) {
                    String string2 = (String)this.viewer.getParameter("_errormessage");
                    if (string2.length() > 0) {
                        this.contextVariables.put("_errorval", ScriptVariable.getVariable(string2));
                        this.viewer.resetError();
                    }
                    this.contextVariables.put("_tryret", this.contextVariables.get("_retval"));
                    this.contextVariables.put("_retval", new ScriptVariable(0, this.contextVariables));
                }
            }
        } else {
            this.runFunction(scriptFunction, list, scriptVariable);
        }
        scriptFunction2 = bl ? this.getContextVariableAsVariable("_retval") : null;
        this.popContext(false, false);
        return scriptFunction2;
    }

    private void runFunction(ScriptFunction scriptFunction, List<ScriptVariable> list, ScriptVariable scriptVariable) throws ScriptException {
        this.aatoken = scriptFunction.aatoken;
        this.lineNumbers = scriptFunction.lineNumbers;
        this.lineIndices = scriptFunction.lineIndices;
        this.script = scriptFunction.script;
        this.pc = 0;
        if (scriptFunction.names != null) {
            this.contextVariables = new Hashtable<String, ScriptVariable>();
            scriptFunction.setVariables(this.contextVariables, list);
        }
        if (scriptVariable != null) {
            this.contextVariables.put("_x", scriptVariable);
        }
        if (scriptFunction.tok != 364558) {
            this.instructionDispatchLoop(false);
        }
    }

    private void clearDefinedVariableAtomSets() {
        this.definedAtomSets.remove("# variable");
    }

    private void defineSets() {
        String string;
        int n;
        if (!this.definedAtomSets.containsKey("# static")) {
            for (n = 0; n < JmolConstants.predefinedStatic.length; ++n) {
                this.defineAtomSet(JmolConstants.predefinedStatic[n]);
            }
            this.defineAtomSet("# static");
        }
        if (this.definedAtomSets.containsKey("# variable")) {
            return;
        }
        for (n = 0; n < JmolConstants.predefinedVariable.length; ++n) {
            this.defineAtomSet(JmolConstants.predefinedVariable[n]);
        }
        n = 4;
        int n2 = Elements.elementNumberMax;
        while (--n2 >= 0) {
            string = "@" + Elements.elementNameFromNumber(n2) + " _e=" + n2;
            this.defineAtomSet(string);
        }
        n2 = Elements.elementNumberMax;
        while (--n2 >= 0) {
            string = "@_" + Elements.elementSymbolFromNumber(n2) + " " + Elements.elementNameFromNumber(n2);
            this.defineAtomSet(string);
        }
        n2 = n;
        while (--n2 >= 0) {
            string = "@" + Elements.altElementNameFromIndex(n2) + " _e=" + Elements.altElementNumberFromIndex(n2);
            this.defineAtomSet(string);
        }
        n2 = Elements.altElementMax;
        while (--n2 >= n) {
            string = " element=" + Elements.altElementNumberFromIndex(n2);
            String string2 = "@_" + Elements.altElementSymbolFromIndex(n2);
            this.defineAtomSet(string2 + string);
            string2 = "@_" + Elements.altIsotopeSymbolFromIndex(n2);
            this.defineAtomSet(string2 + string);
            string2 = "@" + Elements.altElementNameFromIndex(n2);
            if (string2.length() <= 1) continue;
            this.defineAtomSet(string2 + string);
        }
        this.defineAtomSet("# variable");
    }

    private void defineAtomSet(String string) {
        if (string.indexOf("#") == 0) {
            this.definedAtomSets.put(string, Boolean.TRUE);
            return;
        }
        ScriptContext scriptContext = this.compiler.compile("#predefine", string, true, false, false, false);
        if (scriptContext.errorType != null) {
            this.viewer.scriptStatus("JmolConstants.java ERROR: predefined set compile error:" + string + "\ncompile error:" + scriptContext.errorMessageUntranslated);
            return;
        }
        if (scriptContext.aatoken.length != 1) {
            this.viewer.scriptStatus("JmolConstants.java ERROR: predefinition does not have exactly 1 command:" + string);
            return;
        }
        Token[] tokenArray = scriptContext.aatoken[0];
        if (tokenArray.length <= 2) {
            this.viewer.scriptStatus("JmolConstants.java ERROR: bad predefinition length:" + string);
            return;
        }
        int n = tokenArray[1].tok;
        if (!Token.tokAttr(n, 0x40000000) && !Token.tokAttr(n, 0x300000)) {
            this.viewer.scriptStatus("JmolConstants.java ERROR: invalid variable name:" + string);
            return;
        }
        String string2 = ((String)tokenArray[1].value).toLowerCase();
        if (string2.startsWith("dynamic_")) {
            string2 = "!" + string2.substring(8);
        }
        this.definedAtomSets.put(string2, tokenArray);
    }

    private BitSet lookupIdentifierValue(String string) throws ScriptException {
        BitSet bitSet = this.lookupValue(string, false);
        if (bitSet != null) {
            return BitSetUtil.copy(bitSet);
        }
        bitSet = this.getAtomBits(0x40000000, string);
        return bitSet == null ? new BitSet() : bitSet;
    }

    private BitSet lookupValue(String string, boolean bl) throws ScriptException {
        if (this.isSyntaxCheck) {
            return new BitSet();
        }
        this.defineSets();
        Object object = this.definedAtomSets.get(string);
        boolean bl2 = false;
        if (object == null) {
            object = this.definedAtomSets.get("!" + string);
            boolean bl3 = bl2 = object != null;
        }
        if (object instanceof BitSet) {
            return (BitSet)object;
        }
        if (object instanceof Token[]) {
            this.pushContext(null);
            BitSet bitSet = this.atomExpression((Token[])object, -2, 0, true, false, true, true);
            this.popContext(false, false);
            if (!bl2) {
                this.definedAtomSets.put(string, bitSet);
            }
            return bitSet;
        }
        if (bl) {
            return null;
        }
        int n = string.length();
        if (n < 5) {
            return null;
        }
        if (string.charAt(n - 1) != 's') {
            return null;
        }
        string = string.endsWith("ies") ? string.substring(0, n - 3) + 'y' : string.substring(0, n - 1);
        return this.lookupValue(string, true);
    }

    public void deleteAtomsInVariables(BitSet bitSet) {
        for (Map.Entry<String, Object> entry : this.definedAtomSets.entrySet()) {
            Object object = entry.getValue();
            if (!(object instanceof BitSet)) continue;
            BitSetUtil.deleteBits((BitSet)object, bitSet);
        }
    }

    private boolean setStatement(int n) throws ScriptException {
        int n2;
        this.statement = this.aatoken[n];
        this.statementLength = this.statement.length;
        if (this.statementLength == 0) {
            return true;
        }
        for (n2 = 1; n2 < this.statementLength; ++n2) {
            if (this.statement[n2] == null) {
                this.statementLength = n2;
                return true;
            }
            if (this.statement[n2].tok == 1060866) break;
        }
        if (n2 == this.statementLength) {
            return n2 == this.statementLength;
        }
        Token[] tokenArray = new Token[this.statementLength];
        tokenArray[0] = this.statement[0];
        boolean bl = false;
        int n3 = 1;
        for (n2 = 1; n2 < this.statementLength; ++n2) {
            if (this.statement[n2] == null) continue;
            int n4 = this.getToken((int)n2).tok;
            switch (n4) {
                case 1060866: {
                    Object object;
                    Object object2;
                    Object object3;
                    boolean bl2;
                    boolean bl3 = this.theToken.intValue == 4;
                    String string = this.parameterAsString(++n2);
                    boolean bl4 = bl2 = this.tokAt(n2) == 0x100001;
                    if (bl2) {
                        if ((object3 = this.parameterExpressionList(++n2, 0)) == null || object3.size() == 0) {
                            this.error(22);
                        }
                        n2 = this.iToken;
                        object2 = object3.get(0);
                        object = ((ScriptVariable)object2).tok == 7 ? object2 : ScriptVariable.oValue((ScriptVariable)object2);
                    } else {
                        object = this.getParameter(string, false);
                    }
                    n4 = this.tokAt(0);
                    bl3 |= Token.tokAttr(n4, 20480) || n4 == 135271429;
                    if (object instanceof ScriptVariable) {
                        tokenArray[n3] = (Token)object;
                        if (bl && tokenArray[n3].tok == 7) {
                            object3 = ScriptVariable.getBitSet((ScriptVariable)object, true);
                            tokenArray[n3] = new ScriptVariable(10, object3 == null ? ScriptEvaluator.getAtomBitSet(this, ScriptVariable.sValue(tokenArray[n3])) : object3);
                        }
                    } else if (object instanceof Boolean) {
                        tokenArray[n3] = (Boolean)object != false ? Token.tokenOn : Token.tokenOff;
                    } else if (object instanceof Integer) {
                        tokenArray[n3] = new Token(2, (Integer)object, object);
                    } else if (object instanceof Float) {
                        tokenArray[n3] = new Token(3, JmolConstants.modelValue("" + object), object);
                    } else if (object instanceof String) {
                        if (!bl3) {
                            object = this.getStringObjectAsVariable((String)object, null);
                        }
                        if (object instanceof ScriptVariable) {
                            tokenArray[n3] = (Token)object;
                        } else {
                            String string2 = (String)object;
                            if (bl && !bl3) {
                                tokenArray[n3] = new Token(10, ScriptEvaluator.getAtomBitSet(this, string2));
                            } else {
                                n4 = bl2 || bl3 || string2.indexOf(".") >= 0 || string2.indexOf(" ") >= 0 || string2.indexOf("=") >= 0 || string2.indexOf(";") >= 0 || string2.indexOf("[") >= 0 || string2.indexOf("{") >= 0 ? 4 : 0x40000000;
                                tokenArray[n3] = new Token(n4, object);
                            }
                        }
                    } else if (object instanceof BitSet) {
                        tokenArray[n3] = new Token(10, object);
                    } else if (object instanceof Point3f) {
                        tokenArray[n3] = new Token(8, object);
                    } else if (object instanceof Point4f) {
                        tokenArray[n3] = new Token(9, object);
                    } else if (object instanceof Matrix3f) {
                        tokenArray[n3] = new Token(11, object);
                    } else if (object instanceof Matrix4f) {
                        tokenArray[n3] = new Token(12, object);
                    } else if (object instanceof Map) {
                        tokenArray[n3] = new Token(6, object);
                    } else if (object instanceof String[]) {
                        object3 = (String[])object;
                        tokenArray[n3] = ((String[])object3).length > 0 && object3[0].startsWith("{") && !(Escape.unescapePoint(object3[0]) instanceof String) ? new Token(7, object3) : ((object2 = Escape.unEscapeBitSetArray(object3, true)) == null ? new Token(4, Escape.escape(object3, true)) : new Token(10, object2));
                    } else {
                        object3 = this.getObjectCenter(string, Integer.MIN_VALUE, Integer.MIN_VALUE);
                        if (object3 == null) {
                            this.error(22);
                        }
                        tokenArray[n3] = new Token(8, object3);
                    }
                    if (n3 != 1 || this.statement[0].tok != 1085443 || tokenArray[n3].tok == 0x40000000) break;
                    this.error(22);
                    break;
                }
                case 0x100001: 
                case 0x100002: {
                    bl = n4 == 0x100001;
                    tokenArray[n3] = this.statement[n2];
                    break;
                }
                default: {
                    tokenArray[n3] = this.statement[n2];
                }
            }
            ++n3;
        }
        this.statement = tokenArray;
        for (n2 = n3; n2 < this.statement.length; ++n2) {
            this.statement[n2] = null;
        }
        this.statementLength = n3;
        return true;
    }

    private void clearState(boolean bl) {
        this.thisContext = null;
        this.scriptLevel = 0;
        this.setErrorMessage(null);
        this.contextPath = "";
        this.tQuiet = bl;
    }

    private void pushContext(ContextToken contextToken) throws ScriptException {
        if (this.scriptLevel == 20) {
            this.error(44);
        }
        ++this.scriptLevel;
        this.thisContext = this.getScriptContext();
        this.thisContext.token = contextToken;
        if (contextToken != null) {
            this.contextVariables = contextToken.contextVariables;
        }
        if (Logger.debugging || this.isCmdLine_c_or_C_Option) {
            Logger.info("-->>-------------".substring(0, this.scriptLevel + 5) + this.scriptLevel + " " + this.filename + " " + contextToken + " " + this.thisContext);
        }
    }

    public ScriptContext getScriptContext() {
        ScriptContext scriptContext = new ScriptContext();
        scriptContext.scriptLevel = this.scriptLevel;
        scriptContext.parentContext = this.thisContext;
        scriptContext.contextPath = this.contextPath;
        scriptContext.filename = this.filename;
        scriptContext.parallelProcessor = this.parallelProcessor;
        scriptContext.functionName = this.functionName;
        scriptContext.script = this.script;
        scriptContext.lineNumbers = this.lineNumbers;
        scriptContext.lineIndices = this.lineIndices;
        scriptContext.aatoken = this.aatoken;
        scriptContext.statement = this.statement;
        scriptContext.statementLength = this.statementLength;
        scriptContext.pc = this.pc;
        scriptContext.lineEnd = this.lineEnd;
        scriptContext.pcEnd = this.pcEnd;
        scriptContext.iToken = this.iToken;
        scriptContext.outputBuffer = this.outputBuffer;
        scriptContext.contextVariables = this.contextVariables;
        scriptContext.isStateScript = this.isStateScript;
        scriptContext.errorMessage = this.errorMessage;
        scriptContext.errorType = this.errorType;
        scriptContext.iCommandError = this.iCommandError;
        scriptContext.isSyntaxCheck = this.isSyntaxCheck;
        scriptContext.executionStepping = this.executionStepping;
        scriptContext.executionPaused = this.executionPaused;
        scriptContext.scriptExtensions = this.scriptExtensions;
        return scriptContext;
    }

    void popContext(boolean bl, boolean bl2) {
        if (this.scriptLevel == 0) {
            return;
        }
        --this.scriptLevel;
        if (this.thisContext == null) {
            return;
        }
        ScriptContext scriptContext = bl ? this.getScriptContext() : null;
        this.restoreScriptContext(this.thisContext, true, bl, bl2);
        this.restoreScriptContext(scriptContext, true, false, true);
        if (Logger.debugging || this.isCmdLine_c_or_C_Option) {
            Logger.info("--<<-------------".substring(0, this.scriptLevel + 5) + this.scriptLevel + " " + this.filename + " " + (this.thisContext == null ? "" : "" + this.thisContext.token) + " " + this.thisContext);
        }
    }

    private void restoreScriptContext(ScriptContext scriptContext, boolean bl, boolean bl2, boolean bl3) {
        if (scriptContext == null) {
            return;
        }
        if (!bl2) {
            this.statement = scriptContext.statement;
            this.statementLength = scriptContext.statementLength;
            this.pc = scriptContext.pc;
            this.lineEnd = scriptContext.lineEnd;
            this.pcEnd = scriptContext.pcEnd;
            if (bl3) {
                return;
            }
        }
        this.script = scriptContext.script;
        this.lineNumbers = scriptContext.lineNumbers;
        this.lineIndices = scriptContext.lineIndices;
        this.aatoken = scriptContext.aatoken;
        this.contextVariables = scriptContext.contextVariables;
        this.scriptExtensions = scriptContext.scriptExtensions;
        if (bl) {
            this.contextPath = scriptContext.contextPath;
            this.filename = scriptContext.filename;
            this.parallelProcessor = scriptContext.parallelProcessor;
            this.functionName = scriptContext.functionName;
            this.iToken = scriptContext.iToken;
            this.outputBuffer = scriptContext.outputBuffer;
            this.isStateScript = scriptContext.isStateScript;
            this.thisContext = scriptContext.parentContext;
        } else {
            this.error = scriptContext.errorType != null;
            this.errorMessage = scriptContext.errorMessage;
            this.errorMessageUntranslated = scriptContext.errorMessageUntranslated;
            this.iCommandError = scriptContext.iCommandError;
            this.errorType = scriptContext.errorType;
        }
    }

    private String getContext(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        ScriptContext scriptContext = this.thisContext;
        while (scriptContext != null) {
            if (bl) {
                if (scriptContext.contextVariables != null) {
                    stringBuffer.append(this.getScriptID(scriptContext));
                    stringBuffer.append(StateManager.getVariableList(scriptContext.contextVariables, 80, true));
                }
            } else {
                stringBuffer.append(ScriptEvaluator.setErrorLineMessage(scriptContext.functionName, scriptContext.filename, this.getLinenumber(scriptContext), scriptContext.pc, ScriptEvaluator.statementAsString(scriptContext.statement, -9999, this.logMessages)));
            }
            scriptContext = scriptContext.parentContext;
        }
        if (bl) {
            if (this.contextVariables != null) {
                stringBuffer.append(this.getScriptID(null));
                stringBuffer.append(StateManager.getVariableList(this.contextVariables, 80, true));
            }
        } else {
            stringBuffer.append(ScriptEvaluator.setErrorLineMessage(this.functionName, this.filename, this.getLinenumber(null), this.pc, ScriptEvaluator.statementAsString(this.statement, -9999, this.logMessages)));
        }
        return stringBuffer.toString();
    }

    private int getLinenumber(ScriptContext scriptContext) {
        return scriptContext == null ? this.lineNumbers[this.pc] : scriptContext.lineNumbers[scriptContext.pc];
    }

    private String getScriptID(ScriptContext scriptContext) {
        String string = scriptContext == null ? this.functionName : "function " + scriptContext.functionName;
        String string2 = scriptContext == null ? this.filename : scriptContext.filename;
        return "\n# " + string + " (file " + string2 + ")\n";
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorMessageUntranslated() {
        return this.errorMessageUntranslated == null ? this.errorMessage : this.errorMessageUntranslated;
    }

    private void setErrorMessage(String string) {
        this.errorMessageUntranslated = null;
        if (string == null) {
            this.error = false;
            this.errorType = null;
            this.errorMessage = null;
            this.iCommandError = -1;
            return;
        }
        this.error = true;
        if (this.errorMessage == null) {
            this.errorMessage = GT._("script ERROR: ");
        }
        this.errorMessage = this.errorMessage + string;
    }

    private void planeExpected() throws ScriptException {
        this.error(38, "{a b c d}", "\"xy\" \"xz\" \"yz\" \"x=...\" \"y=...\" \"z=...\"", "$xxxxx");
    }

    private void integerOutOfRange(int n, int n2) throws ScriptException {
        this.error(21, "" + n, "" + n2);
    }

    private void numberOutOfRange(float f, float f2) throws ScriptException {
        this.error(36, "" + f, "" + f2);
    }

    void error(int n, int n2) throws ScriptException {
        this.iToken = n2;
        this.error(n, null, null, null, false);
    }

    void error(int n) throws ScriptException {
        this.error(n, null, null, null, false);
    }

    void error(int n, String string) throws ScriptException {
        this.error(n, string, null, null, false);
    }

    void error(int n, String string, String string2) throws ScriptException {
        this.error(n, string, string2, null, false);
    }

    void error(int n, String string, String string2, String string3) throws ScriptException {
        this.error(n, string, string2, string3, false);
    }

    private void warning(int n, String string, String string2) throws ScriptException {
        this.error(n, string, string2, null, true);
    }

    void error(int n, String string, String string2, String string3, boolean bl) throws ScriptException {
        String string4;
        String string5 = this.ignoreError ? null : ScriptEvaluator.errorString(n, string, string2, string3, true);
        String string6 = string4 = !this.ignoreError && GT.getDoTranslate() ? ScriptEvaluator.errorString(n, string, string2, string3, false) : null;
        if (!bl) {
            this.evalError(string5, string4);
        }
        this.showString(string5);
    }

    void evalError(String string, String string2) throws ScriptException {
        if (this.ignoreError) {
            throw new NullPointerException();
        }
        if (!this.isSyntaxCheck) {
            this.setCursorWait(false);
            this.viewer.setBooleanProperty("refreshing", true);
            this.viewer.setStringProperty("_errormessage", string2);
        }
        throw new ScriptException(string, string2);
    }

    static String errorString(int n, String string, String string2, String string3, boolean bl) {
        String string4;
        boolean bl2 = false;
        if (!bl && (bl2 = GT.getDoTranslate())) {
            GT.setDoTranslate(false);
        }
        switch (n) {
            default: {
                string4 = "Unknown error message number: " + n;
                break;
            }
            case 0: {
                string4 = GT._("x y z axis expected");
                break;
            }
            case 1: {
                string4 = GT._("{0} not allowed with background model displayed");
                break;
            }
            case 2: {
                string4 = GT._("bad argument count");
                break;
            }
            case 3: {
                string4 = GT._("Miller indices cannot all be zero.");
                break;
            }
            case 4: {
                string4 = GT._("bad [R,G,B] color");
                break;
            }
            case 5: {
                string4 = GT._("boolean expected");
                break;
            }
            case 6: {
                string4 = GT._("boolean or number expected");
                break;
            }
            case 7: {
                string4 = GT._("boolean, number, or {0} expected");
                break;
            }
            case 8: {
                string4 = GT._("color expected");
                break;
            }
            case 9: {
                string4 = GT._("a color or palette name (Jmol, Rasmol) is required");
                break;
            }
            case 10: {
                string4 = GT._("command expected");
                break;
            }
            case 11: {
                string4 = GT._("{x y z} or $name or (atom expression) required");
                break;
            }
            case 12: {
                string4 = GT._("draw object not defined");
                break;
            }
            case 13: {
                string4 = GT._("unexpected end of script command");
                break;
            }
            case 14: {
                string4 = GT._("valid (atom expression) expected");
                break;
            }
            case 15: {
                string4 = GT._("(atom expression) or integer expected");
                break;
            }
            case 16: {
                string4 = GT._("filename expected");
                break;
            }
            case 17: {
                string4 = GT._("file not found");
                break;
            }
            case 18: {
                string4 = GT._("incompatible arguments");
                break;
            }
            case 19: {
                string4 = GT._("insufficient arguments");
                break;
            }
            case 20: {
                string4 = GT._("integer expected");
                break;
            }
            case 21: {
                string4 = GT._("integer out of range ({0} - {1})");
                break;
            }
            case 22: {
                string4 = GT._("invalid argument");
                break;
            }
            case 23: {
                string4 = GT._("invalid parameter order");
                break;
            }
            case 24: {
                string4 = GT._("keyword expected");
                break;
            }
            case 25: {
                string4 = GT._("no MO coefficient data available");
                break;
            }
            case 26: {
                string4 = GT._("An MO index from 1 to {0} is required");
                break;
            }
            case 27: {
                string4 = GT._("no MO basis/coefficient data available for this frame");
                break;
            }
            case 28: {
                string4 = GT._("no MO occupancy data available");
                break;
            }
            case 29: {
                string4 = GT._("Only one molecular orbital is available in this file");
                break;
            }
            case 30: {
                string4 = GT._("{0} require that only one model be displayed");
                break;
            }
            case 55: {
                string4 = GT._("{0} requires that only one model be loaded");
                break;
            }
            case 31: {
                string4 = GT._("No data available");
                break;
            }
            case 32: {
                string4 = GT._("No partial charges were read from the file; Jmol needs these to render the MEP data.");
                break;
            }
            case 33: {
                string4 = GT._("No unit cell");
                break;
            }
            case 34: {
                string4 = GT._("number expected");
                break;
            }
            case 35: {
                string4 = GT._("number must be ({0} or {1})");
                break;
            }
            case 36: {
                string4 = GT._("decimal number out of range ({0} - {1})");
                break;
            }
            case 37: {
                string4 = GT._("object name expected after '$'");
                break;
            }
            case 38: {
                string4 = GT._("plane expected -- either three points or atom expressions or {0} or {1} or {2}");
                break;
            }
            case 39: {
                string4 = GT._("property name expected");
                break;
            }
            case 40: {
                string4 = GT._("space group {0} was not found.");
                break;
            }
            case 41: {
                string4 = GT._("quoted string expected");
                break;
            }
            case 42: {
                string4 = GT._("quoted string or identifier expected");
                break;
            }
            case 43: {
                string4 = GT._("too many rotation points were specified");
                break;
            }
            case 44: {
                string4 = GT._("too many script levels");
                break;
            }
            case 45: {
                string4 = GT._("unrecognized atom property");
                break;
            }
            case 46: {
                string4 = GT._("unrecognized bond property");
                break;
            }
            case 47: {
                string4 = GT._("unrecognized command");
                break;
            }
            case 48: {
                string4 = GT._("runtime unrecognized expression");
                break;
            }
            case 49: {
                string4 = GT._("unrecognized object");
                break;
            }
            case 50: {
                string4 = GT._("unrecognized {0} parameter");
                break;
            }
            case 51: {
                string4 = GT._("unrecognized {0} parameter in Jmol state script (set anyway)");
                break;
            }
            case 52: {
                string4 = GT._("unrecognized SHOW parameter --  use {0}");
                break;
            }
            case 53: {
                string4 = "{0}";
                break;
            }
            case 54: {
                string4 = GT._("write what? {0} or {1} \"filename\"");
            }
        }
        if (string4.indexOf("{0}") < 0) {
            if (string != null) {
                string4 = string4 + ": " + string;
            }
        } else {
            if ((string4 = TextFormat.simpleReplace(string4, "{0}", string)).indexOf("{1}") >= 0) {
                string4 = TextFormat.simpleReplace(string4, "{1}", string2);
            } else if (string2 != null) {
                string4 = string4 + ": " + string2;
            }
            if (string4.indexOf("{2}") >= 0) {
                string4 = TextFormat.simpleReplace(string4, "{2}", string2);
            }
        }
        if (bl2) {
            GT.setDoTranslate(true);
        }
        return string4;
    }

    static String setErrorLineMessage(String string, String string2, int n, int n2, String string3) {
        String string4 = "\n----";
        if (string2 != null || string != null) {
            string4 = string4 + "line " + n + " command " + (n2 + 1) + " of " + (string == null ? string2 : (string.equals("try") ? "try" : "function " + string)) + ":";
        }
        string4 = string4 + "\n         " + string3;
        return string4;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Eval\n pc:");
        stringBuffer.append(this.pc);
        stringBuffer.append("\n");
        stringBuffer.append(this.aatoken.length);
        stringBuffer.append(" statements\n");
        for (int i = 0; i < this.aatoken.length; ++i) {
            stringBuffer.append("----\n");
            Token[] tokenArray = this.aatoken[i];
            for (int j = 0; j < tokenArray.length; ++j) {
                stringBuffer.append(tokenArray[j]);
                stringBuffer.append('\n');
            }
            stringBuffer.append('\n');
        }
        stringBuffer.append("END\n");
        return stringBuffer.toString();
    }

    static String statementAsString(Token[] tokenArray, int n, boolean bl) {
        if (tokenArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = tokenArray[0].tok;
        switch (n2) {
            case 0: {
                String string = (String)tokenArray[0].value;
                return (string.startsWith("/") ? "/" : "#") + string;
            }
            case 0x119009: {
                if (tokenArray.length != 2 || tokenArray[1].tok != 135368713 && tokenArray[1].tok != 102436) break;
                return ((ScriptFunction)tokenArray[1].value).toString();
            }
        }
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = tokenArray.length > 1 && n2 == 1085443 && tokenArray[0].value.equals("") && tokenArray[0].intValue == 61 && tokenArray[1].tok != 0x100001;
        int n3 = tokenArray.length;
        block31: for (int i = 0; i < n3; ++i) {
            Token token = tokenArray[i];
            if (token == null) {
                n3 = i;
                break;
            }
            if (n == i - 1) {
                stringBuffer.append(" <<");
            }
            if (i != 0) {
                stringBuffer.append(' ');
            }
            if (i == 2 && bl5) {
                bl5 = false;
                if (token.tok != 269484436) {
                    stringBuffer.append("= ");
                }
            }
            if (n == i && token.tok != 0x100002) {
                stringBuffer.append(">> ");
            }
            switch (token.tok) {
                case 0x100001: {
                    if (!bl2) continue block31;
                    stringBuffer.append("{");
                    continue block31;
                }
                case 0x100002: {
                    if (bl4 && i == tokenArray.length - 1) {
                        bl2 = false;
                    }
                    if (!bl2) continue block31;
                    stringBuffer.append("}");
                    continue block31;
                }
                case 0x10100040: 
                case 0x10100041: {
                    break;
                }
                case 0x10000A: 
                case 0x10000E: {
                    bl3 = token.tok == 0x10000A;
                    break;
                }
                case 1060866: {
                    if (i <= 0 || !((String)token.value).equals("define")) break;
                    stringBuffer.append("@");
                    if (i + 1 >= tokenArray.length || tokenArray[i + 1].tok != 0x100001) continue block31;
                    if (!bl2) {
                        bl4 = true;
                    }
                    bl2 = true;
                    continue block31;
                }
                case 0x10000D: {
                    stringBuffer.append("true");
                    continue block31;
                }
                case 0x10000C: {
                    stringBuffer.append("false");
                    continue block31;
                }
                case 135280131: {
                    break;
                }
                case 2: {
                    stringBuffer.append(token.intValue);
                    continue block31;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    stringBuffer.append(ScriptVariable.sValue(token));
                    continue block31;
                }
                case 5: {
                    stringBuffer.append('^');
                    continue block31;
                }
                case 1048615: {
                    if (token.intValue != Integer.MAX_VALUE) {
                        stringBuffer.append(token.intValue);
                    } else {
                        stringBuffer.append(Group.getSeqcodeString(ScriptEvaluator.getSeqCode(token)));
                    }
                    token = tokenArray[++i];
                    stringBuffer.append(' ');
                    stringBuffer.append(bl3 ? "-" : "- ");
                }
                case 1048614: {
                    if (token.intValue != Integer.MAX_VALUE) {
                        stringBuffer.append(token.intValue);
                        continue block31;
                    }
                    stringBuffer.append(Group.getSeqcodeString(ScriptEvaluator.getSeqCode(token)));
                    continue block31;
                }
                case 0x100021: {
                    stringBuffer.append("*:");
                    stringBuffer.append((char)token.intValue);
                    continue block31;
                }
                case 0x10001F: {
                    stringBuffer.append("*%");
                    if (token.value == null) continue block31;
                    stringBuffer.append(token.value.toString());
                    continue block31;
                }
                case 0x100022: {
                    stringBuffer.append("*/");
                }
                case 3: 
                case 1048611: {
                    if (token.intValue < Integer.MAX_VALUE) {
                        stringBuffer.append(Escape.escapeModelFileNumber(token.intValue));
                        continue block31;
                    }
                    stringBuffer.append("" + token.value);
                    continue block31;
                }
                case 1048613: {
                    stringBuffer.append('[');
                    stringBuffer.append(Group.getGroup3((short)token.intValue));
                    stringBuffer.append(']');
                    continue block31;
                }
                case 1048612: {
                    stringBuffer.append('[');
                    stringBuffer.append(token.value);
                    stringBuffer.append(']');
                    continue block31;
                }
                case 0x100020: {
                    stringBuffer.append("*.");
                    break;
                }
                case 1095761925: {
                    if (!(token.value instanceof Point3f)) break;
                    Point3f point3f = (Point3f)token.value;
                    stringBuffer.append("cell=").append(Escape.escape(point3f));
                    continue block31;
                }
                case 4: {
                    stringBuffer.append("\"").append(token.value).append("\"");
                    continue block31;
                }
                case 0x10100190: 
                case 0x10100191: 
                case 269484434: 
                case 269484435: 
                case 269484436: 
                case 269484437: {
                    if (token.intValue == 1716520972) {
                        stringBuffer.append((String)tokenArray[++i].value).append(" ");
                        break;
                    }
                    if (token.intValue == Integer.MAX_VALUE) break;
                    stringBuffer.append(Token.nameOf(token.intValue)).append(" ");
                    break;
                }
                case 364558: {
                    continue block31;
                }
                case 0x119009: {
                    stringBuffer.append("try");
                    continue block31;
                }
                default: {
                    if (Token.tokAttr(token.tok, 0x40000000) || !bl) break;
                    stringBuffer.append('\n').append(token.toString()).append('\n');
                    continue block31;
                }
            }
            if (token.value == null) continue;
            stringBuffer.append(token.value.toString());
        }
        if (n >= n3 - 1 && n != 9999) {
            stringBuffer.append(" <<");
        }
        return stringBuffer.toString();
    }

    private Object getShapeProperty(int n, String string) {
        return this.shapeManager.getShapeProperty(n, string, Integer.MIN_VALUE);
    }

    private boolean getShapeProperty(int n, String string, Object[] objectArray) {
        return this.shapeManager.getShapeProperty(n, string, objectArray);
    }

    private Object getShapeProperty(int n, String string, int n2) {
        return this.shapeManager.getShapeProperty(n, string, n2);
    }

    private void addShapeProperty(List<Object[]> list, String string, Object object) {
        if (this.isSyntaxCheck) {
            return;
        }
        list.add(new Object[]{string, object});
    }

    private void setObjectMad(int n, String string, int n2) {
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.setObjectMad(n, string, n2);
    }

    private void setObjectArgb(String string, int n) {
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.setObjectArgb(string, n);
    }

    private void setShapeProperty(int n, String string, Object object) {
        if (this.isSyntaxCheck) {
            return;
        }
        this.shapeManager.setShapeProperty(n, string, object, null);
    }

    private void setShapeProperty(int n, String string, Object object, BitSet bitSet) {
        if (this.isSyntaxCheck) {
            return;
        }
        this.shapeManager.setShapeProperty(n, string, object, bitSet);
    }

    private void setShapeSize(int n, int n2, BitSet bitSet) {
        if (this.isSyntaxCheck) {
            return;
        }
        this.shapeManager.setShapeSize(n, n2, null, bitSet);
    }

    private void setShapeSize(int n, RadiusData radiusData) {
        if (this.isSyntaxCheck) {
            return;
        }
        this.shapeManager.setShapeSize(n, 0, radiusData, null);
    }

    private void setBooleanProperty(String string, boolean bl) {
        if (!this.isSyntaxCheck) {
            this.viewer.setBooleanProperty(string, bl);
        }
    }

    private boolean setIntProperty(String string, int n) {
        if (!this.isSyntaxCheck) {
            this.viewer.setIntProperty(string, n);
        }
        return true;
    }

    private boolean setFloatProperty(String string, float f) {
        if (!this.isSyntaxCheck) {
            this.viewer.setFloatProperty(string, f);
        }
        return true;
    }

    private void setStringProperty(String string, String string2) {
        if (!this.isSyntaxCheck) {
            this.viewer.setStringProperty(string, string2);
        }
    }

    private void showString(String string) {
        this.showString(string, false);
    }

    private void showString(String string, boolean bl) {
        if (this.isSyntaxCheck) {
            return;
        }
        if (this.outputBuffer != null) {
            this.outputBuffer.append(string).append('\n');
        } else {
            this.viewer.showString(string, bl);
        }
    }

    private void scriptStatusOrBuffer(String string) {
        if (this.isSyntaxCheck) {
            return;
        }
        if (this.outputBuffer != null) {
            this.outputBuffer.append(string).append('\n');
            return;
        }
        this.viewer.scriptStatus(string);
    }

    private BitSet atomExpression(int n) throws ScriptException {
        if (!this.checkToken(n)) {
            this.error(2, n);
        }
        return this.atomExpression(this.statement, n, 0, true, false, true, true);
    }

    private BitSet atomExpression(Token[] tokenArray, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws ScriptException {
        this.isBondSet = false;
        if (tokenArray != this.statement) {
            this.tempStatement = this.statement;
            this.statement = tokenArray;
        }
        ScriptMathProcessor scriptMathProcessor = new ScriptMathProcessor(this, false, false, bl3);
        int n3 = Integer.MAX_VALUE;
        boolean bl5 = false;
        this.iToken = 1000;
        boolean bl6 = n < 0;
        boolean bl7 = false;
        int n4 = 0;
        int n5 = this.viewer.getAtomCount();
        if (bl6) {
            n = -n;
        }
        bl6 |= this.isSyntaxCheck;
        if (n2 == 0 && tokenArray.length > n) {
            n2 = n + 1;
        }
        block36: for (int i = n; i < n2; ++i) {
            this.iToken = i;
            Token token = tokenArray[i];
            if (token == null) break;
            Object object = token.value;
            switch (token.tok) {
                case 0x100001: {
                    n = i;
                    n2 = tokenArray.length;
                    ++n4;
                    continue block36;
                }
                case 0x100002: {
                    if (--n4 <= 0) break block36;
                    continue block36;
                }
                case 0x10000A: {
                    Object object2;
                    if (!this.isPoint3f(i) || (object2 = this.getPoint3f(i, true)) == null) continue block36;
                    scriptMathProcessor.addX((Point3f)object2);
                    i = this.iToken;
                    continue block36;
                }
                case 0x10000E: {
                    if (i <= 0 || tokenArray[i - 1].tok != 0x10000A) continue block36;
                    scriptMathProcessor.addX(new BitSet());
                    continue block36;
                }
                case 0x10100040: {
                    bl7 = true;
                    scriptMathProcessor.addOp(token);
                    continue block36;
                }
                case 0x10100041: {
                    bl7 = false;
                    scriptMathProcessor.addOp(token);
                    continue block36;
                }
                case 1060866: {
                    scriptMathProcessor.addX(ScriptEvaluator.getAtomBitSet(this, object));
                    continue block36;
                }
                case 135267841: {
                    scriptMathProcessor.addX(new ScriptVariable(token));
                    scriptMathProcessor.addX(new ScriptVariable(9, this.hklParameter(i + 2)));
                    i = this.iToken;
                    continue block36;
                }
                case 135266319: {
                    scriptMathProcessor.addX(new ScriptVariable(token));
                    scriptMathProcessor.addX(new ScriptVariable(9, this.planeParameter(i + 2)));
                    i = this.iToken;
                    continue block36;
                }
                case 0x100006: {
                    scriptMathProcessor.addX(new ScriptVariable(token));
                    scriptMathProcessor.addX(this.getPoint3f(i + 2, true));
                    i = this.iToken;
                    continue block36;
                }
                case 4: {
                    BitSet bitSet;
                    Object object2 = (String)object;
                    if (((String)object2).indexOf("({") == 0 && (bitSet = Escape.unescapeBitset((String)object2)) != null) {
                        scriptMathProcessor.addX(bitSet);
                        continue block36;
                    }
                    scriptMathProcessor.addX(new ScriptVariable(token));
                    if (!((String)object2).equals("hkl")) continue block36;
                    scriptMathProcessor.addX(new ScriptVariable(9, this.hklParameter(i + 2)));
                    i = this.iToken;
                    continue block36;
                }
                case 135266310: 
                case 135266322: 
                case 135267334: 
                case 135267335: 
                case 135267336: 
                case 0x10100030: {
                    scriptMathProcessor.addOp(token);
                    continue block36;
                }
                case 0x100003: {
                    scriptMathProcessor.addX(this.viewer.getModelUndeletedAtomsBitSet(-1));
                    continue block36;
                }
                case 0x10000B: {
                    scriptMathProcessor.addX(new BitSet());
                    continue block36;
                }
                case 0x10000C: 
                case 0x10000D: {
                    scriptMathProcessor.addX(new ScriptVariable(token));
                    continue block36;
                }
                case 1114638349: {
                    scriptMathProcessor.addX(BitSetUtil.copy(this.viewer.getSelectionSet(false)));
                    continue block36;
                }
                case 0x303008: {
                    BitSet bitSet = this.viewer.getSelectionSubset();
                    scriptMathProcessor.addX(bitSet == null ? this.viewer.getModelUndeletedAtomsBitSet(-1) : BitSetUtil.copy(bitSet));
                    continue block36;
                }
                case 3145752: {
                    scriptMathProcessor.addX(BitSetUtil.copy(this.viewer.getHiddenSet()));
                    continue block36;
                }
                case 1060869: {
                    scriptMathProcessor.addX(BitSetUtil.copy(this.viewer.getMotionFixedAtoms()));
                    continue block36;
                }
                case 3145751: {
                    scriptMathProcessor.addX(BitSetUtil.copyInvert(this.viewer.getHiddenSet(), n5));
                    continue block36;
                }
                case 3145755: {
                    if (!this.isSyntaxCheck && !bl5) {
                        this.viewer.setModelVisibility();
                    }
                    bl5 = true;
                    scriptMathProcessor.addX(this.viewer.getVisibleSet());
                    continue block36;
                }
                case 3145750: {
                    if (!this.isSyntaxCheck && bl) {
                        this.refresh();
                    }
                    scriptMathProcessor.addX(this.viewer.getClickableSet());
                    continue block36;
                }
                case 0x100020: {
                    int n6 = token.intValue;
                    if (n6 > 0) {
                        scriptMathProcessor.addX(this.compareInt(1095761922, 269484436, n6));
                        continue block36;
                    }
                    scriptMathProcessor.addX(this.getAtomBits(token.tok, object));
                    continue block36;
                }
                case 0x100009: 
                case 0x10001F: 
                case 1048612: 
                case 0x300002: 
                case 0x300005: 
                case 0x300006: 
                case 0x300007: 
                case 0x300008: 
                case 0x300009: 
                case 3145749: 
                case 3145753: 
                case 1089470478: 
                case 0x60300003: 
                case 1614417984: {
                    scriptMathProcessor.addX(this.getAtomBits(token.tok, object));
                    continue block36;
                }
                case 0x100022: 
                case 1048611: {
                    int n7 = token.intValue;
                    if (n7 == Integer.MAX_VALUE && object instanceof Integer) {
                        n7 = (Integer)object;
                        if (!this.viewer.haveFileSet()) {
                            scriptMathProcessor.addX(this.getAtomBits(0x100022, n7));
                            continue block36;
                        }
                        n7 = n7 < 1000 ? (n7 *= 1000000) : n7 / 1000 * 1000000 + n7 % 1000;
                    }
                    scriptMathProcessor.addX(this.bitSetForModelFileNumber(n7));
                    continue block36;
                }
                case 0x100021: 
                case 1048613: {
                    scriptMathProcessor.addX(this.getAtomBits(token.tok, new Integer(token.intValue)));
                    continue block36;
                }
                case 1048614: {
                    if (bl7) {
                        scriptMathProcessor.addXNum(ScriptVariable.intVariable(token.intValue));
                        continue block36;
                    }
                    scriptMathProcessor.addX(this.getAtomBits(1048614, new Integer(ScriptEvaluator.getSeqCode(token))));
                    continue block36;
                }
                case 1048615: {
                    if (bl7) {
                        scriptMathProcessor.addXNum(ScriptVariable.intVariable(token.intValue));
                        scriptMathProcessor.addX(Token.tokenMinus);
                        scriptMathProcessor.addXNum(ScriptVariable.intVariable(tokenArray[++i].intValue));
                        continue block36;
                    }
                    int n8 = i + 3 < tokenArray.length && tokenArray[i + 2].tok == 0x10100080 && tokenArray[i + 3].tok == 0x100021 ? tokenArray[i + 3].intValue : 9;
                    scriptMathProcessor.addX(this.getAtomBits(1048615, new int[]{ScriptEvaluator.getSeqCode(token), ScriptEvaluator.getSeqCode(tokenArray[++i]), n8}));
                    if (n8 == 9) continue block36;
                    i += 2;
                    continue block36;
                }
                case 1095761925: {
                    Point3f point3f = (Point3f)object;
                    scriptMathProcessor.addX(this.getAtomBits(1095761925, new int[]{(int)(point3f.x * 1000.0f), (int)(point3f.y * 1000.0f), (int)(point3f.z * 1000.0f)}));
                    continue block36;
                }
                case 0x30000E: {
                    scriptMathProcessor.addX(this.viewer.getModelUndeletedAtomsBitSet(this.viewer.getCurrentModelIndex()));
                    continue block36;
                }
                case 0x300001: 
                case 0x30000C: 
                case 0x30000D: 
                case 137363467: 
                case 1115297793: 
                case 1613758468: 
                case 1613758475: {
                    scriptMathProcessor.addX(this.lookupIdentifierValue((String)object));
                    continue block36;
                }
                case 0x10100190: 
                case 0x10100191: 
                case 269484434: 
                case 269484435: 
                case 269484436: 
                case 269484437: {
                    float[] fArray;
                    boolean bl8;
                    String string;
                    if (i + 1 == tokenArray.length) {
                        this.error(22);
                    }
                    Object object3 = tokenArray[++i].value;
                    int n9 = token.tok;
                    int n10 = token.intValue;
                    String string2 = string = n10 == 1716520972 ? (String)object3 : null;
                    if (string != null) {
                        if (i + 1 == tokenArray.length) {
                            this.error(22);
                        }
                        object3 = tokenArray[++i].value;
                    }
                    if (n10 == 1095766022 && n9 != 269484436) {
                        this.error(22);
                    }
                    if (this.isSyntaxCheck) {
                        scriptMathProcessor.addX(new BitSet());
                        continue block36;
                    }
                    boolean bl9 = n10 == 1095766028;
                    boolean bl10 = Token.tokAttr(n10, 1095761920);
                    boolean bl11 = Token.tokAttr(n10, 1112539136);
                    boolean bl12 = bl10 && bl11;
                    boolean bl13 = bl8 = !bl10 && Token.tokAttr(n10, 0x40D00000);
                    if (n10 == 1087375365) {
                        bl8 = false;
                        bl10 = !false;
                    }
                    int n11 = tokenArray[i].tok;
                    n3 = tokenArray[i].intValue;
                    float f = Float.NaN;
                    if (object3 instanceof Point3f) {
                        if (n10 == 1766856708) {
                            n3 = Graphics3D.colorPtToInt((Point3f)object3);
                            n11 = 2;
                            bl10 = true;
                        }
                    } else if (object3 instanceof String) {
                        if (n10 == 1766856708) {
                            n3 = Graphics3D.getArgbFromString((String)object3);
                            if (n3 == 0 && Token.tokAttr(n11, 0x40000000)) {
                                n3 = ((String)(object3 = this.getStringParameter((String)object3, true))).startsWith("{") ? ((object3 = Escape.unescapePoint((String)object3)) instanceof Point3f ? Graphics3D.colorPtToInt((Point3f)object3) : 0) : Graphics3D.getArgbFromString((String)object3);
                            }
                            n11 = 2;
                            bl10 = true;
                        } else if (bl8) {
                            if (Token.tokAttr(n11, 0x40000000)) {
                                object3 = this.getStringParameter((String)object3, true);
                            }
                        } else {
                            if (Token.tokAttr(n11, 0x40000000)) {
                                object3 = this.getNumericParameter((String)object3);
                            }
                            if (object3 instanceof String) {
                                if (n10 == 1641025539 || n10 == 1087375365) {
                                    bl10 = n3 != Integer.MAX_VALUE;
                                    bl8 = !bl10;
                                } else {
                                    object3 = ScriptVariable.nValue(tokenArray[i]);
                                }
                            }
                            if (object3 instanceof Integer) {
                                n3 = (Integer)object3;
                                f = n3;
                            } else if (object3 instanceof Float && bl9) {
                                n3 = ModelCollection.modelFileNumberFromFloat(((Float)object3).floatValue());
                            }
                        }
                    }
                    if (bl8 && !(object3 instanceof String)) {
                        object3 = "" + object3;
                    }
                    if (object3 instanceof Integer || n11 == 2) {
                        if (bl9) {
                            if (n3 >= 1000000) {
                                n10 = -1095766028;
                            }
                        } else if (bl12) {
                            bl11 = false;
                        } else if (bl11) {
                            f = n3;
                        }
                    } else if (object3 instanceof Float) {
                        if (bl9) {
                            n10 = -1095766028;
                        } else {
                            f = ((Float)object3).floatValue();
                            if (bl12) {
                                bl10 = false;
                            } else if (bl10) {
                                n3 = (int)f;
                            }
                        }
                    } else if (!bl8) {
                        ++this.iToken;
                        this.error(22);
                    }
                    if (bl9 && n3 >= 1000000 && n3 % 1000000 == 0) {
                        n3 /= 1000000;
                        n10 = 1229984263;
                        bl9 = false;
                    }
                    if (n10 == -1095766028 && n9 == 269484436) {
                        scriptMathProcessor.addX(this.bitSetForModelFileNumber(n3));
                        continue block36;
                    }
                    if (object != null && ((String)object).indexOf("-") >= 0) {
                        if (bl10) {
                            n3 = -n3;
                        } else if (!Float.isNaN(f)) {
                            f = -f;
                        }
                    }
                    float[] fArray2 = fArray = n10 == 1716520972 ? this.viewer.getDataFloat(string) : null;
                    scriptMathProcessor.addX(bl10 ? this.compareInt(n10, n9, n3) : (bl8 ? this.compareString(n10, n9, (String)object3) : this.compareFloat(n10, fArray, n9, f)));
                    continue block36;
                }
                case 2: 
                case 3: {
                    scriptMathProcessor.addXNum(new ScriptVariable(token));
                    continue block36;
                }
                case 8: 
                case 10: {
                    scriptMathProcessor.addX(object);
                    continue block36;
                }
                default: {
                    if (Token.tokAttr(token.tok, 0x10100000)) {
                        scriptMathProcessor.addOp(token);
                        continue block36;
                    }
                    if (!(object instanceof String)) {
                        scriptMathProcessor.addX(object);
                        continue block36;
                    }
                    Object object3 = this.getParameter((String)object, false);
                    if (bl7) {
                        scriptMathProcessor.addX(object3);
                        continue block36;
                    }
                    if (object3 instanceof String) {
                        object3 = this.getStringObjectAsVariable((String)object3, null);
                    }
                    if (object3 instanceof String[]) {
                        BitSet bitSet = Escape.unEscapeBitSetArray((String[])object3, true);
                        if (bitSet != null) {
                            object3 = bitSet;
                        }
                    } else if (object3 instanceof String || object3 instanceof String[]) {
                        object3 = this.lookupIdentifierValue((String)object);
                    }
                    scriptMathProcessor.addX(object3);
                }
            }
        }
        this.expressionResult = scriptMathProcessor.getResult(bl2);
        if (this.expressionResult == null) {
            if (bl2) {
                return null;
            }
            if (!this.isSyntaxCheck) {
                scriptMathProcessor.dumpStacks("after getResult");
            }
            this.error(13);
        }
        this.expressionResult = ((ScriptVariable)this.expressionResult).value;
        if (this.expressionResult instanceof String && (bl3 || ((String)this.expressionResult).startsWith("({"))) {
            Object object = this.expressionResult = this.isSyntaxCheck ? new BitSet() : ScriptEvaluator.getAtomBitSet(this, this.expressionResult);
        }
        if (!bl3 && !(this.expressionResult instanceof BitSet)) {
            return null;
        }
        BitSet bitSet = this.expressionResult instanceof BitSet ? (BitSet)this.expressionResult : new BitSet();
        this.isBondSet = this.expressionResult instanceof Bond.BondSet;
        if (!this.isBondSet) {
            this.viewer.excludeAtoms(bitSet, bl6);
        }
        if (this.tempStatement != null) {
            this.statement = this.tempStatement;
            this.tempStatement = null;
        }
        return bitSet;
    }

    private BitSet compareFloat(int n, float[] fArray, int n2, float f) {
        BitSet bitSet = new BitSet();
        int n3 = this.viewer.getAtomCount();
        ModelSet modelSet = this.viewer.getModelSet();
        Atom[] atomArray = modelSet.atoms;
        float f2 = 0.0f;
        this.viewer.autoCalculate(n);
        int n4 = n3;
        block3: while (--n4 >= 0) {
            boolean bl = false;
            Atom atom = atomArray[n4];
            switch (n) {
                default: {
                    f2 = Atom.atomPropertyFloat(this.viewer, atom, n);
                    break;
                }
                case 1716520972: {
                    if (fArray == null || fArray.length <= n4) continue block3;
                    f2 = fArray[n4];
                }
            }
            if (!(bl = ScriptEvaluator.compareFloat(n2, f2, f))) continue;
            bitSet.set(n4);
        }
        return bitSet;
    }

    private BitSet compareString(int n, int n2, String string) throws ScriptException {
        boolean bl;
        BitSet bitSet = new BitSet();
        Atom[] atomArray = this.viewer.getModelSet().atoms;
        int n3 = this.viewer.getAtomCount();
        boolean bl2 = bl = n == 0x40D00004 && this.viewer.getChainCaseSensitive();
        if (!bl) {
            string = string.toLowerCase();
        }
        int n4 = n3;
        while (--n4 >= 0) {
            String string2 = Atom.atomPropertyString(this.viewer, atomArray[n4], n);
            if (!bl) {
                string2 = string2.toLowerCase();
            }
            if (!this.compareString(n2, string2, string)) continue;
            bitSet.set(n4);
        }
        return bitSet;
    }

    protected BitSet compareInt(int n, int n2, int n3) {
        int n4 = Integer.MAX_VALUE;
        BitSet bitSet = null;
        int n5 = n2;
        int n6 = n3;
        int n7 = this.viewer.getAtomCount();
        ModelSet modelSet = this.viewer.getModelSet();
        Atom[] atomArray = modelSet.atoms;
        int n8 = -1;
        int n9 = 0;
        int n10 = -1;
        int[] nArray = null;
        int n11 = 0;
        switch (n) {
            case 1297090050: {
                switch (n5) {
                    case 0x10100190: 
                    case 0x10100191: {
                        n8 = Integer.MAX_VALUE;
                    }
                }
                break;
            }
            case 1095761923: {
                try {
                    switch (n2) {
                        case 269484435: {
                            return BitSetUtil.newBitSet(0, n3);
                        }
                        case 269484434: {
                            return BitSetUtil.newBitSet(0, n3 + 1);
                        }
                        case 0x10100191: {
                            return BitSetUtil.newBitSet(n3, n7);
                        }
                        case 0x10100190: {
                            return BitSetUtil.newBitSet(n3 + 1, n7);
                        }
                        case 269484436: {
                            return n3 < n7 ? BitSetUtil.newBitSet(n3, n3 + 1) : new BitSet();
                        }
                    }
                    BitSet bitSet2 = BitSetUtil.setAll(n7);
                    if (n3 >= 0) {
                        bitSet2.clear(n3);
                    }
                    return bitSet2;
                }
                catch (Exception exception) {
                    return new BitSet();
                }
            }
        }
        BitSet bitSet3 = new BitSet(n7);
        block37: for (int i = 0; i < n7; ++i) {
            boolean bl = false;
            Atom atom = atomArray[i];
            switch (n) {
                default: {
                    n4 = Atom.atomPropertyInt(atom, n);
                    break;
                }
                case 1095766022: {
                    return BitSetUtil.copy(this.viewer.getConformation(-1, n3 - 1, false));
                }
                case 1297090050: {
                    int n12;
                    bitSet = atom.getAtomSymmetry();
                    if (bitSet == null) continue block37;
                    if (atom.getModelIndex() != n10) {
                        n10 = atom.getModelIndex();
                        nArray = modelSet.getModelCellRange(n10);
                        n11 = modelSet.getModelSymmetryCount(n10);
                    }
                    if (n6 >= 200) {
                        if (nArray == null) continue block37;
                        n3 = n6 % 1000;
                        n12 = n6 / 1000 - 1;
                        if (n12 < 0) {
                            bl = true;
                        } else if (n11 == 0 || n12 >= 0 && !(bl = bitSet.get(n12))) continue block37;
                        n5 = 0x10000B;
                        n4 = n12 < 0 ? atom.getCellTranslation(n3, nArray, n11) : atom.getSymmetryTranslation(n12, nArray, n11);
                    } else if (n11 > 0) {
                        if (n3 > n11 && n5 != 269484435 && n5 != 269484434) continue block37;
                        if (n5 == 269484437) {
                            if (n3 <= 0 || n3 > n11 || bitSet.get(n3)) continue block37;
                            bitSet3.set(i);
                            continue block37;
                        }
                    }
                    switch (n5) {
                        case 269484435: {
                            n8 = n3 - 1;
                            break;
                        }
                        case 269484434: {
                            n8 = n3;
                            break;
                        }
                        case 0x10100191: {
                            n9 = n3 - 1;
                            break;
                        }
                        case 0x10100190: {
                            n9 = n3;
                            break;
                        }
                        case 269484436: {
                            n8 = n3;
                            n9 = n3 - 1;
                            break;
                        }
                        case 269484437: {
                            boolean bl2 = bl = !bitSet.get(n3);
                        }
                    }
                    if (n9 < 0) {
                        n9 = 0;
                    }
                    if (n9 < n8 && (n12 = bitSet.nextSetBit(n9)) >= 0 && n12 < n8) {
                        bl = true;
                    }
                    if (bl && n4 != Integer.MAX_VALUE) break;
                    n2 = 0x10000B;
                }
            }
            switch (n2) {
                case 0x10000B: {
                    break;
                }
                case 269484435: {
                    bl = n4 < n3;
                    break;
                }
                case 269484434: {
                    bl = n4 <= n3;
                    break;
                }
                case 0x10100191: {
                    bl = n4 >= n3;
                    break;
                }
                case 0x10100190: {
                    bl = n4 > n3;
                    break;
                }
                case 269484436: {
                    bl = n4 == n3;
                    break;
                }
                case 269484437: {
                    boolean bl3 = bl = n4 != n3;
                }
            }
            if (!bl) continue;
            bitSet3.set(i);
        }
        return bitSet3;
    }

    private boolean compareString(int n, String string, String string2) throws ScriptException {
        switch (n) {
            case 269484436: 
            case 269484437: {
                return TextFormat.isMatch(string, string2, true, true) == (n == 269484436);
            }
        }
        this.error(22);
        return false;
    }

    private static boolean compareFloat(int n, float f, float f2) {
        switch (n) {
            case 269484435: {
                return f < f2;
            }
            case 269484434: {
                return f <= f2;
            }
            case 0x10100191: {
                return f >= f2;
            }
            case 0x10100190: {
                return f > f2;
            }
            case 269484436: {
                return f == f2;
            }
            case 269484437: {
                return f != f2;
            }
        }
        return false;
    }

    private BitSet getAtomBits(int n, Object object) {
        return this.isSyntaxCheck ? new BitSet() : this.viewer.getAtomBits(n, object);
    }

    private static int getSeqCode(Token token) {
        return token.intValue != Integer.MAX_VALUE ? Group.getSeqcode(token.intValue, ' ') : (Integer)token.value;
    }

    private int checkLast(int n) throws ScriptException {
        return this.checkLength(n + 1) - 1;
    }

    private int checkLength(int n) throws ScriptException {
        if (n >= 0) {
            return this.checkLength(n, 0);
        }
        if (this.statementLength > -n) {
            this.iToken = -n;
            this.error(2);
        }
        return this.statementLength;
    }

    private int checkLength(int n, int n2) throws ScriptException {
        if (this.statementLength != n) {
            this.iToken = n2 > 0 ? n2 : this.statementLength;
            this.error(n2 > 0 ? 22 : 2);
        }
        return this.statementLength;
    }

    private int checkLength23() throws ScriptException {
        this.iToken = this.statementLength;
        if (this.statementLength != 2 && this.statementLength != 3) {
            this.error(2);
        }
        return this.statementLength;
    }

    private int checkLength34() throws ScriptException {
        this.iToken = this.statementLength;
        if (this.statementLength != 3 && this.statementLength != 4) {
            this.error(2);
        }
        return this.statementLength;
    }

    private Token getToken(int n) throws ScriptException {
        if (!this.checkToken(n)) {
            this.error(13);
        }
        this.theToken = this.statement[n];
        this.theTok = this.theToken.tok;
        return this.theToken;
    }

    private int tokAt(int n) {
        return n < this.statementLength && this.statement[n] != null ? this.statement[n].tok : 0;
    }

    private int tokAt(int n, Token[] tokenArray) {
        return n < tokenArray.length && tokenArray[n] != null ? tokenArray[n].tok : 0;
    }

    private Token tokenAt(int n, Token[] tokenArray) {
        return n < tokenArray.length ? tokenArray[n] : null;
    }

    private boolean checkToken(int n) {
        this.iToken = n;
        return this.iToken < this.statementLength;
    }

    private int modelNumberParameter(int n) throws ScriptException {
        int n2 = 0;
        boolean bl = false;
        switch (this.tokAt(n)) {
            case 2: {
                bl = true;
            }
            case 3: {
                n2 = this.getToken((int)n).intValue;
                break;
            }
            case 4: {
                n2 = JmolConstants.modelValue(this.stringParameter(n));
                break;
            }
            default: {
                this.error(22);
            }
        }
        return this.viewer.getModelNumberIndex(n2, bl, true);
    }

    private String optParameterAsString(int n) throws ScriptException {
        if (n >= this.statementLength) {
            return "";
        }
        return this.parameterAsString(n);
    }

    private String parameterAsString(int n) throws ScriptException {
        this.getToken(n);
        if (this.theToken == null) {
            this.error(13);
        }
        return this.theTok == 2 ? "" + this.theToken.intValue : "" + this.theToken.value;
    }

    private int intParameter(int n) throws ScriptException {
        if (this.checkToken(n) && this.getToken((int)n).tok == 2) {
            return this.theToken.intValue;
        }
        this.error(20);
        return 0;
    }

    private int intParameter(int n, int n2, int n3) throws ScriptException {
        int n4 = this.intParameter(n);
        if (n4 < n2 || n4 > n3) {
            this.integerOutOfRange(n2, n3);
        }
        return n4;
    }

    private boolean isFloatParameter(int n) {
        switch (this.tokAt(n)) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    private float floatParameter(int n, float f, float f2) throws ScriptException {
        float f3 = this.floatParameter(n);
        if (f3 < f || f3 > f2) {
            this.numberOutOfRange(f, f2);
        }
        return f3;
    }

    private float floatParameter(int n) throws ScriptException {
        if (this.checkToken(n)) {
            this.getToken(n);
            switch (this.theTok) {
                case 1048615: {
                    return -this.theToken.intValue;
                }
                case 2: 
                case 1048614: {
                    return this.theToken.intValue;
                }
                case 3: 
                case 1048611: {
                    return ((Float)this.theToken.value).floatValue();
                }
            }
        }
        this.error(34);
        return 0.0f;
    }

    private float[] floatParameterSet(int n, int n2, int n3) throws ScriptException {
        int n4 = this.tokAt(n);
        boolean bl = n4 == 0x10000A;
        boolean bl2 = n4 == 0x10100040;
        float[] fArray = null;
        ArrayList<Float> arrayList = new ArrayList<Float>();
        int n5 = 0;
        if (bl || bl2) {
            ++n;
        }
        String string = null;
        block0 : switch (this.tokAt(n)) {
            case 4: 
            case 7: {
                string = ScriptVariable.sValue(this.statement[n]);
                string = TextFormat.replaceAllCharacters(string, "{},[]\"'", ' ');
                fArray = Parser.parseFloatArray(string);
                n5 = fArray.length;
                break;
            }
            default: {
                while (n5 < n3) {
                    n4 = this.tokAt(n);
                    if (bl && n4 == 0x10000E || bl2 && n4 == 0x10100041) break block0;
                    switch (n4) {
                        case 0x10000A: 
                        case 0x10000E: 
                        case 0x10100030: {
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 8: {
                            Point3f point3f = this.getPoint3f(n, false);
                            arrayList.add(new Float(point3f.x));
                            arrayList.add(new Float(point3f.y));
                            arrayList.add(new Float(point3f.z));
                            n5 += 3;
                            break;
                        }
                        case 9: {
                            Point4f point4f = this.getPoint4f(n);
                            arrayList.add(new Float(point4f.x));
                            arrayList.add(new Float(point4f.y));
                            arrayList.add(new Float(point4f.z));
                            arrayList.add(new Float(point4f.w));
                            n5 += 4;
                            break;
                        }
                        default: {
                            arrayList.add(new Float(this.floatParameter(n)));
                            if (++n5 != n3 || !bl2 || this.tokAt(n + 1) != 0x10000E) break;
                            ++n;
                        }
                    }
                    ++n;
                }
                break block0;
            }
        }
        if (bl && this.tokAt(n++) != 0x10000E || bl2 && this.tokAt(n++) != 0x10100041) {
            this.error(22);
        }
        this.iToken = n - 1;
        if (n5 < n2 || n5 > n3) {
            this.error(22);
        }
        if (fArray == null) {
            fArray = new float[n5];
            for (int i = 0; i < n5; ++i) {
                fArray[i] = ((Float)arrayList.get(i)).floatValue();
            }
        }
        return fArray;
    }

    private Point3f[] getPointArray(int n, int n2) throws ScriptException {
        int n3 = this.getToken((int)n++).tok;
        Point3f[] point3fArray = new Point3f[n2];
        if (n3 == 7) {
            String[] stringArray = (String[])this.theToken.value;
            if (stringArray.length != n2) {
                this.error(22);
            }
            for (int i = 0; i < n2; ++i) {
                Object object = Escape.unescapePoint(stringArray[i]);
                if (!(object instanceof Point3f)) {
                    this.error(22);
                }
                point3fArray[i] = (Point3f)object;
            }
            return point3fArray;
        }
        if (n3 != 0x10100040) {
            this.error(22);
        }
        int n4 = 0;
        block5: while (n3 != 0x10100041) {
            n3 = this.getToken((int)n).tok;
            switch (n3) {
                case 0x10100041: {
                    continue block5;
                }
                case 0x10100030: {
                    ++n;
                    continue block5;
                }
            }
            point3fArray[n4++] = this.getPoint3f(n, true);
            n = this.iToken + 1;
            if (n4 != n2 || this.tokAt(n) == 0x10100041) continue;
            this.error(22);
        }
        return point3fArray;
    }

    private float[][] floatArraySet(int n, int n2, int n3) throws ScriptException {
        int n4;
        if ((n4 = this.tokAt(n++)) != 0x10100040) {
            this.error(22);
        }
        float[][] fArrayArray = new float[n2][];
        int n5 = 0;
        block5: while (n4 != 0x10100041) {
            n4 = this.getToken((int)n).tok;
            switch (n4) {
                case 0x10100041: {
                    continue block5;
                }
                case 0x10100030: {
                    ++n;
                    continue block5;
                }
                case 0x10100040: {
                    ++n;
                    float[] fArray = new float[n3];
                    fArrayArray[n5++] = fArray;
                    for (int i = 0; i < n3; ++i) {
                        fArray[i] = this.floatParameter(n++);
                        if (this.tokAt(n) != 0x10100030) continue;
                        ++n;
                    }
                    if (this.tokAt(n++) != 0x10100041) {
                        this.error(22);
                    }
                    n4 = 0;
                    if (n5 != n2 || this.tokAt(n) == 0x10100041) continue block5;
                    this.error(22);
                    continue block5;
                }
            }
            this.error(22);
        }
        return fArrayArray;
    }

    private float[][][] floatArraySet(int n, int n2, int n3, int n4) throws ScriptException {
        int n5;
        if ((n5 = this.tokAt(n++)) != 0x10100040 || n2 <= 0) {
            this.error(22);
        }
        float[][][] fArrayArray = new float[n2][][];
        int n6 = 0;
        block5: while (n5 != 0x10100041) {
            n5 = this.getToken((int)n).tok;
            switch (n5) {
                case 0x10100041: {
                    continue block5;
                }
                case 0x10100030: {
                    ++n;
                    continue block5;
                }
                case 0x10100040: {
                    fArrayArray[n6++] = this.floatArraySet(n, n3, n4);
                    n = ++this.iToken;
                    n5 = 0;
                    if (n6 != n2 || this.tokAt(n) == 0x10100041) continue block5;
                    this.error(22);
                    continue block5;
                }
            }
            this.error(22);
        }
        return fArrayArray;
    }

    private String stringParameter(int n) throws ScriptException {
        if (!this.checkToken(n) || this.getToken((int)n).tok != 4) {
            this.error(41);
        }
        return (String)this.theToken.value;
    }

    private String[] stringParameterSet(int n) throws ScriptException {
        int n2;
        switch (this.tokAt(n)) {
            case 4: {
                Object object;
                String string = this.stringParameter(n);
                if (string.startsWith("[\"") && (object = this.viewer.evaluateExpression(string)) instanceof String) {
                    return TextFormat.split((String)object, '\n');
                }
                return new String[]{string};
            }
            case 0x10100040: {
                ++n;
                break;
            }
            default: {
                this.error(22);
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((n2 = this.tokAt(n)) != 0x10100041) {
            switch (n2) {
                case 0x10100030: {
                    break;
                }
                case 4: {
                    arrayList.add(this.stringParameter(n));
                    break;
                }
                default: {
                    this.error(22);
                }
            }
            ++n;
        }
        this.iToken = n;
        int n3 = arrayList.size();
        String[] stringArray = new String[n3];
        for (int i = 0; i < n3; ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    private String objectNameParameter(int n) throws ScriptException {
        if (!this.checkToken(n)) {
            this.error(37);
        }
        return this.parameterAsString(n);
    }

    private boolean booleanParameter(int n) throws ScriptException {
        if (this.statementLength == n) {
            return true;
        }
        switch (this.getToken((int)this.checkLast((int)n)).tok) {
            case 0x10000D: {
                return true;
            }
            case 0x10000C: {
                return false;
            }
        }
        this.error(5);
        return false;
    }

    private Point3f atomCenterOrCoordinateParameter(int n) throws ScriptException {
        switch (this.getToken((int)n).tok) {
            case 10: 
            case 0x100001: {
                BitSet bitSet = this.atomExpression(this.statement, n, 0, true, false, false, true);
                if (bitSet != null) {
                    return this.viewer.getAtomSetCenter(bitSet);
                }
                if (this.expressionResult instanceof Point3f) {
                    return (Point3f)this.expressionResult;
                }
                this.error(22);
                break;
            }
            case 8: 
            case 0x10000A: {
                return this.getPoint3f(n, true);
            }
        }
        this.error(22);
        return null;
    }

    private boolean isCenterParameter(int n) {
        int n2 = this.tokAt(n);
        return n2 == 0x100007 || n2 == 0x10000A || n2 == 0x100001 || n2 == 8 || n2 == 10;
    }

    private Point3f centerParameter(int n) throws ScriptException {
        return this.centerParameter(n, Integer.MIN_VALUE);
    }

    private Point3f centerParameter(int n, int n2) throws ScriptException {
        Point3f point3f = null;
        this.expressionResult = null;
        if (this.checkToken(n)) {
            switch (this.getToken((int)n).tok) {
                case 0x100007: {
                    String string = this.objectNameParameter(++n);
                    int n3 = Integer.MIN_VALUE;
                    if (this.tokAt(n + 1) == 0x10100040) {
                        n3 = this.intParameter(n + 2);
                        if (this.getToken((int)(n + 3)).tok != 0x10100041) {
                            this.error(22);
                        }
                    }
                    if (this.isSyntaxCheck) {
                        return new Point3f();
                    }
                    point3f = this.getObjectCenter(string, n3, n2);
                    if (point3f != null) break;
                    this.error(12, string);
                    break;
                }
                case 8: 
                case 10: 
                case 0x100001: 
                case 0x10000A: {
                    point3f = this.atomCenterOrCoordinateParameter(n);
                }
            }
        }
        if (point3f == null) {
            this.error(11);
        }
        return point3f;
    }

    private Point4f planeParameter(int n) throws ScriptException {
        boolean bl;
        Tuple4f tuple4f;
        block28: {
            Vector3f vector3f = new Vector3f();
            Vector3f vector3f2 = new Vector3f();
            tuple4f = null;
            boolean bl2 = bl = this.tokAt(n) == 0x101000A0;
            if (bl) {
                ++n;
            }
            if (n >= this.statementLength) break block28;
            switch (this.getToken((int)n).tok) {
                case 9: {
                    tuple4f = (Point4f)this.theToken.value;
                    break;
                }
                case 0x100007: {
                    String string = this.objectNameParameter(++n);
                    if (this.isSyntaxCheck) {
                        return new Point4f();
                    }
                    int n2 = this.shapeManager.getShapeIdFromObjectName(string);
                    switch (n2) {
                        case 22: {
                            this.setShapeProperty(22, "thisID", string);
                            Point3f[] point3fArray = (Point3f[])this.getShapeProperty(22, "vertices");
                            if (point3fArray != null && point3fArray.length >= 3 && point3fArray[0] != null && point3fArray[1] != null) {
                                if (point3fArray[2] == null) break;
                                tuple4f = Measure.getPlaneThroughPoints(point3fArray[0], point3fArray[1], point3fArray[2], new Vector3f(), vector3f, vector3f2);
                                break;
                            }
                            break block28;
                        }
                        case 23: {
                            this.setShapeProperty(23, "thisID", string);
                            tuple4f = (Point4f)this.getShapeProperty(23, "plane");
                        }
                    }
                    break;
                }
                case 1112541203: {
                    if (!this.checkToken(++n) || this.getToken((int)n++).tok != 269484436) {
                        this.evalError("x=?", null);
                    }
                    tuple4f = new Point4f(1.0f, 0.0f, 0.0f, -this.floatParameter(n));
                    break;
                }
                case 1112541204: {
                    if (!this.checkToken(++n) || this.getToken((int)n++).tok != 269484436) {
                        this.evalError("y=?", null);
                    }
                    tuple4f = new Point4f(0.0f, 1.0f, 0.0f, -this.floatParameter(n));
                    break;
                }
                case 1112541205: {
                    if (!this.checkToken(++n) || this.getToken((int)n++).tok != 269484436) {
                        this.evalError("z=?", null);
                    }
                    tuple4f = new Point4f(0.0f, 0.0f, 1.0f, -this.floatParameter(n));
                    break;
                }
                case 4: 
                case 0x40000000: {
                    String string = this.parameterAsString(n);
                    if (string.equalsIgnoreCase("xy")) {
                        return new Point4f(0.0f, 0.0f, 1.0f, 0.0f);
                    }
                    if (string.equalsIgnoreCase("xz")) {
                        return new Point4f(0.0f, 1.0f, 0.0f, 0.0f);
                    }
                    if (string.equalsIgnoreCase("yz")) {
                        return new Point4f(1.0f, 0.0f, 0.0f, 0.0f);
                    }
                    this.iToken += 2;
                    break;
                }
                case 0x10000A: {
                    if (!this.isPoint3f(n)) {
                        tuple4f = this.getPoint4f(n);
                        break;
                    }
                }
                case 10: 
                case 0x100001: {
                    Point3f point3f = this.atomCenterOrCoordinateParameter(n);
                    if (this.getToken((int)(++this.iToken)).tok == 0x10100030) {
                        ++this.iToken;
                    }
                    Point3f point3f2 = this.atomCenterOrCoordinateParameter(this.iToken);
                    if (this.getToken((int)(++this.iToken)).tok == 0x10100030) {
                        ++this.iToken;
                    }
                    Point3f point3f3 = this.atomCenterOrCoordinateParameter(this.iToken);
                    n = this.iToken;
                    Vector3f vector3f3 = new Vector3f();
                    float f = Measure.getNormalThroughPoints(point3f, point3f2, point3f3, vector3f3, vector3f, vector3f2);
                    tuple4f = new Point4f(vector3f3.x, vector3f3.y, vector3f3.z, f);
                    if (this.isSyntaxCheck || !Logger.debugging) break;
                    Logger.debug("points: " + point3f + point3f2 + point3f3 + " defined plane: " + tuple4f);
                }
            }
        }
        if (tuple4f == null) {
            this.planeExpected();
        }
        if (bl) {
            tuple4f.scale(-1.0f);
        }
        return tuple4f;
    }

    private Point4f hklParameter(int n) throws ScriptException {
        Point3f point3f;
        Point4f point4f;
        if (!this.isSyntaxCheck && this.viewer.getCurrentUnitCell() == null) {
            this.error(33);
        }
        if ((point4f = this.getHklPlane(point3f = (Point3f)this.getPointOrPlane(n, false, true, false, true, 3, 3))) == null) {
            this.error(3);
        }
        if (!this.isSyntaxCheck && Logger.debugging) {
            Logger.info("defined plane: " + point4f);
        }
        return point4f;
    }

    protected Point4f getHklPlane(Point3f point3f) {
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Point3f point3f2 = new Point3f(point3f.x == 0.0f ? 1.0f : 1.0f / point3f.x, 0.0f, 0.0f);
        Point3f point3f3 = new Point3f(0.0f, point3f.y == 0.0f ? 1.0f : 1.0f / point3f.y, 0.0f);
        Point3f point3f4 = new Point3f(0.0f, 0.0f, point3f.z == 0.0f ? 1.0f : 1.0f / point3f.z);
        if (point3f.x == 0.0f && point3f.y == 0.0f && point3f.z == 0.0f) {
            return null;
        }
        if (point3f.x == 0.0f && point3f.y == 0.0f) {
            point3f2.set(1.0f, 0.0f, point3f4.z);
            point3f3.set(0.0f, 1.0f, point3f4.z);
        } else if (point3f.y == 0.0f && point3f.z == 0.0f) {
            point3f3.set(point3f2.x, 0.0f, 1.0f);
            point3f4.set(point3f2.x, 1.0f, 0.0f);
        } else if (point3f.z == 0.0f && point3f.x == 0.0f) {
            point3f4.set(0.0f, point3f3.y, 1.0f);
            point3f2.set(1.0f, point3f3.y, 0.0f);
        } else if (point3f.x == 0.0f) {
            point3f2.set(1.0f, point3f3.y, 0.0f);
        } else if (point3f.y == 0.0f) {
            point3f3.set(0.0f, 1.0f, point3f4.z);
        } else if (point3f.z == 0.0f) {
            point3f4.set(point3f2.x, 0.0f, 1.0f);
        }
        this.viewer.toCartesian(point3f2, false);
        this.viewer.toCartesian(point3f3, false);
        this.viewer.toCartesian(point3f4, false);
        Vector3f vector3f3 = new Vector3f();
        float f = Measure.getNormalThroughPoints(point3f2, point3f3, point3f4, vector3f3, vector3f, vector3f2);
        return new Point4f(vector3f3.x, vector3f3.y, vector3f3.z, f);
    }

    private int getMadParameter() throws ScriptException {
        int n = 1;
        switch (this.getToken((int)1).tok) {
            case 1073742072: {
                this.restrictSelected(false, false);
                break;
            }
            case 0x10000D: {
                break;
            }
            case 0x10000C: {
                n = 0;
                break;
            }
            case 2: {
                int n2 = this.intParameter(1, 0, 750);
                n = n2 * 4 * 2;
                break;
            }
            case 3: {
                n = (int)(this.floatParameter(1, -3.0f, 3.0f) * 1000.0f * 2.0f);
                if (n >= 0) break;
                this.restrictSelected(false, false);
                n = -n;
                break;
            }
            default: {
                this.error(6);
            }
        }
        return n;
    }

    private int getSetAxesTypeMad(int n) throws ScriptException {
        if (n == this.statementLength) {
            return 1;
        }
        switch (this.getToken((int)this.checkLast((int)n)).tok) {
            case 0x10000D: {
                return 1;
            }
            case 0x10000C: {
                return 0;
            }
            case 0x40000066: {
                return -1;
            }
            case 2: {
                return this.intParameter(n, -1, 19);
            }
            case 3: {
                float f = this.floatParameter(n, 0.0f, 2.0f);
                return (int)(f * 1000.0f * 2.0f);
            }
        }
        this.error(7, "\"DOTTED\"");
        return 0;
    }

    private boolean isColorParam(int n) {
        int n2 = this.tokAt(n);
        return n2 == 0x22000022 || n2 == 0x10100040 || n2 == 8 || this.isPoint3f(n) || (n2 == 4 || Token.tokAttr(n2, 0x40000000)) && Graphics3D.getArgbFromString((String)this.statement[n].value) != 0;
    }

    private int getArgbParam(int n) throws ScriptException {
        return this.getArgbParam(n, false);
    }

    private int getArgbParamLast(int n, boolean bl) throws ScriptException {
        int n2 = this.getArgbParam(n, bl);
        this.checkLast(this.iToken);
        return n2;
    }

    private int getArgbParam(int n, boolean bl) throws ScriptException {
        Point3f point3f = null;
        if (this.checkToken(n)) {
            switch (this.getToken((int)n).tok) {
                default: {
                    if (!Token.tokAttr(this.theTok, 0x40000000)) break;
                }
                case 4: 
                case 0x22000022: {
                    return Graphics3D.getArgbFromString(this.parameterAsString(n));
                }
                case 0x10100040: {
                    return this.getColorTriad(++n);
                }
                case 8: {
                    point3f = (Point3f)this.theToken.value;
                    break;
                }
                case 0x10000A: {
                    point3f = this.getPoint3f(n, false);
                    break;
                }
                case 0x10000B: {
                    if (!bl) break;
                    return 0;
                }
            }
        }
        if (point3f == null) {
            this.error(8);
        }
        return Graphics3D.colorPtToInt(point3f);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getColorTriad(int n) throws ScriptException {
        Point3f point3f;
        String string;
        int n2;
        block22: {
            float[] fArray = new float[3];
            n2 = 0;
            string = "";
            this.getToken(n);
            point3f = null;
            float f = 0.0f;
            switch (this.theTok) {
                case 2: 
                case 3: 
                case 1048614: {
                    break;
                }
                case 8: {
                    point3f = (Point3f)this.theToken.value;
                    break block22;
                }
                case 0x40000000: {
                    string = this.parameterAsString(n);
                    break block22;
                }
                default: {
                    this.error(4);
                    break block22;
                }
            }
            while (n < this.statementLength) {
                block23: {
                    switch (this.getToken((int)n).tok) {
                        case 0x10100030: {
                            break block23;
                        }
                        case 0x40000000: {
                            if (n2 != 1 || fArray[0] != 0.0f) {
                                this.error(4);
                            }
                            string = "0" + this.parameterAsString(n);
                            break block22;
                        }
                        case 3: {
                            if (n2 > 2) {
                                this.error(4);
                            }
                            f = this.floatParameter(n);
                            break;
                        }
                        case 2: {
                            if (n2 > 2) {
                                this.error(4);
                            }
                            f = this.theToken.intValue;
                            break;
                        }
                        case 1048614: {
                            if (n2 > 2) {
                                this.error(4);
                            }
                            f = (Integer)this.theToken.value % 256;
                            break;
                        }
                        case 0x10100041: {
                            if (n2 != 3) {
                                this.error(4);
                            }
                            --n;
                            point3f = new Point3f(fArray[0], fArray[1], fArray[2]);
                            break block22;
                        }
                        default: {
                            this.error(4);
                        }
                    }
                    fArray[n2++] = f;
                }
                ++n;
            }
            this.error(4);
        }
        if (this.getToken((int)(++n)).tok != 0x10100041) {
            this.error(4);
        }
        if (point3f != null) {
            return Graphics3D.colorPtToInt(point3f);
        }
        n2 = Graphics3D.getArgbFromString("[" + string + "]");
        if (n2 == 0) {
            this.error(4);
        }
        return n2;
    }

    private boolean isPoint3f(int n) {
        boolean bl = this.tokAt(n) == 8;
        if (bl || this.tokAt(n) == 9 || this.isFloatParameter(n + 1) && this.isFloatParameter(n + 2) && this.isFloatParameter(n + 3) && this.isFloatParameter(n + 4)) {
            return bl;
        }
        this.ignoreError = true;
        int n2 = this.iToken;
        bl = true;
        try {
            this.getPoint3f(n, true);
        }
        catch (Exception exception) {
            bl = false;
        }
        this.ignoreError = false;
        this.iToken = n2;
        return bl;
    }

    private Point3f getPoint3f(int n, boolean bl) throws ScriptException {
        return (Point3f)this.getPointOrPlane(n, false, bl, true, false, 3, 3);
    }

    private Point4f getPoint4f(int n) throws ScriptException {
        return (Point4f)this.getPointOrPlane(n, false, false, false, false, 4, 4);
    }

    private Object getPointOrPlane(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2, int n3) throws ScriptException {
        float[] fArray = new float[6];
        int n4 = 0;
        this.coordinatesAreFractional = bl4;
        if (this.tokAt(n) == 8) {
            if (n2 <= 3 && n3 >= 3) {
                return this.getToken((int)n).value;
            }
            this.error(22);
        }
        if (this.tokAt(n) == 9) {
            if (n2 <= 4 && n3 >= 4) {
                return this.getToken((int)n).value;
            }
            this.error(22);
        }
        int n5 = 1;
        block9: for (int i = n; i < this.statement.length; ++i) {
            switch (this.getToken((int)i).tok) {
                case 0x10000A: 
                case 0x10100030: 
                case 0x10100060: 
                case 0x10100080: {
                    continue block9;
                }
                case 0x10000E: {
                    break block9;
                }
                case 0x101000A0: {
                    n5 = -1;
                    continue block9;
                }
                case 1048615: {
                    if (n4 == 6) {
                        this.error(22);
                    }
                    fArray[n4++] = this.theToken.intValue;
                    n5 = -1;
                    continue block9;
                }
                case 2: 
                case 1048614: {
                    if (n4 == 6) {
                        this.error(22);
                    }
                    fArray[n4++] = this.theToken.intValue * n5;
                    n5 = 1;
                    continue block9;
                }
                case 0x100022: 
                case 0x101000B0: {
                    if (!bl2) {
                        this.error(22);
                    }
                    if (this.theTok == 0x101000B0) {
                        this.getToken(++i);
                    }
                    if (--n4 < 0 || bl) {
                        this.error(22);
                    }
                    if (this.theToken.value instanceof Integer || this.theTok == 2) {
                        int n6 = n4++;
                        fArray[n6] = fArray[n6] / (float)(this.theToken.intValue == Integer.MAX_VALUE ? (Integer)this.theToken.value : this.theToken.intValue);
                    } else if (this.theToken.value instanceof Float) {
                        int n7 = n4++;
                        fArray[n7] = fArray[n7] / ((Float)this.theToken.value).floatValue();
                    }
                    this.coordinatesAreFractional = true;
                    continue block9;
                }
                case 3: 
                case 1048611: {
                    if (bl) {
                        this.error(22);
                    }
                    if (n4 == 6) {
                        this.error(22);
                    }
                    fArray[n4++] = ((Float)this.theToken.value).floatValue();
                    continue block9;
                }
                default: {
                    this.error(22);
                }
            }
        }
        if (n4 < n2 || n4 > n3) {
            this.error(22);
        }
        if (n4 == 3) {
            Point3f point3f = new Point3f(fArray[0], fArray[1], fArray[2]);
            if (this.coordinatesAreFractional && bl3 && !this.isSyntaxCheck) {
                this.viewer.toCartesian(point3f, !this.viewer.getFractionalRelative());
            }
            return point3f;
        }
        if (n4 == 4) {
            if (this.coordinatesAreFractional) {
                this.error(22);
            }
            Point4f point4f = new Point4f(fArray[0], fArray[1], fArray[2], fArray[3]);
            return point4f;
        }
        return fArray;
    }

    private Point3f xypParameter(int n) throws ScriptException {
        boolean bl;
        if (this.tokAt(n) != 0x10100040 || !this.isFloatParameter(++n)) {
            return null;
        }
        Point3f point3f = new Point3f();
        point3f.x = this.floatParameter(n);
        if (this.tokAt(++n) == 0x10100030) {
            ++n;
        }
        if (!this.isFloatParameter(n)) {
            return null;
        }
        point3f.y = this.floatParameter(n);
        boolean bl2 = bl = this.tokAt(++n) == 269484210;
        if (bl) {
            ++n;
        }
        if (this.tokAt(n) != 0x10100041) {
            return null;
        }
        this.iToken = n;
        point3f.z = (float)(bl ? -1 : 1) * Float.MAX_VALUE;
        return point3f;
    }

    private int intSetting(int n, int n2, int n3, int n4) throws ScriptException {
        if (n2 == Integer.MAX_VALUE) {
            n2 = this.intSetting(n);
        }
        if (n2 != Integer.MIN_VALUE && n2 < n3 || n2 > n4) {
            this.integerOutOfRange(n3, n4);
        }
        return n2;
    }

    private int intSetting(int n) throws ScriptException {
        if (n == this.statementLength) {
            return Integer.MIN_VALUE;
        }
        List<ScriptVariable> list = this.parameterExpressionList(n, -1);
        if (list == null || list.size() == 0) {
            this.error(22);
        }
        return ScriptVariable.iValue(list.get(0));
    }

    private float floatSetting(int n, float f, float f2) throws ScriptException {
        if (n == this.statementLength) {
            return Float.NaN;
        }
        float f3 = this.floatSetting(n);
        if (f3 < f || f3 > f2) {
            this.numberOutOfRange(f, f2);
        }
        return f3;
    }

    private float floatSetting(int n) throws ScriptException {
        List<ScriptVariable> list = this.parameterExpressionList(n, -1);
        if (list == null || list.size() == 0) {
            this.error(22);
        }
        return ScriptVariable.fValue(list.get(0));
    }

    private String stringSetting(int n, boolean bl) throws ScriptException {
        if (bl && this.statementLength == n + 1) {
            return this.parameterAsString(n);
        }
        List<ScriptVariable> list = this.parameterExpressionList(n, -1);
        if (list == null || list.size() == 0) {
            this.error(22);
        }
        return ScriptVariable.sValue(list.get(0));
    }

    private ScriptVariable tokenSetting(int n) throws ScriptException {
        List<ScriptVariable> list = this.parameterExpressionList(n, -1);
        if (list == null || list.size() == 0) {
            this.error(22);
        }
        return list.get(0);
    }

    private boolean isCommandDisplayable(int n) {
        if (n >= this.aatoken.length || n >= this.pcEnd || this.aatoken[n] == null) {
            return false;
        }
        return this.lineIndices[n][1] > this.lineIndices[n][0];
    }

    private boolean checkContinue() {
        if (this.interruptExecution) {
            return false;
        }
        if (this.executionStepping && this.isCommandDisplayable(this.pc)) {
            this.viewer.scriptStatus("Next: " + this.getNextStatement(), "stepping -- type RESUME to continue", 0, null);
            this.executionPaused = true;
        } else if (!this.executionPaused) {
            return true;
        }
        if (Logger.debugging) {
            Logger.info("script execution paused at command " + (this.pc + 1) + " level " + this.scriptLevel + ": " + this.thisCommand);
        }
        try {
            this.refresh();
            while (this.executionPaused) {
                this.viewer.popHoldRepaint("pause");
                Thread.sleep(100L);
                String string = this.viewer.getInterruptScript();
                if (string != "") {
                    this.resumePausedExecution();
                    this.setErrorMessage(null);
                    ScriptContext scriptContext = this.getScriptContext();
                    --this.pc;
                    try {
                        this.runScript(string);
                    }
                    catch (Exception exception) {
                        this.setErrorMessage("" + exception);
                    }
                    catch (Error error) {
                        this.setErrorMessage("" + error);
                    }
                    if (this.error) {
                        this.scriptStatusOrBuffer(this.errorMessage);
                        this.setErrorMessage(null);
                    }
                    this.restoreScriptContext(scriptContext, true, false, false);
                    this.pauseExecution(false);
                }
                this.viewer.pushHoldRepaint("pause");
            }
            if (!(this.isSyntaxCheck || this.interruptExecution || this.executionStepping)) {
                this.viewer.scriptStatus("script execution " + (this.error || this.interruptExecution ? "interrupted" : "resumed"));
            }
        }
        catch (Exception exception) {
            this.viewer.pushHoldRepaint("pause");
        }
        Logger.debug("script execution resumed");
        return !this.error && !this.interruptExecution;
    }

    private void instructionDispatchLoop(boolean bl) throws ScriptException {
        long l = 0L;
        this.vProcess = null;
        boolean bl2 = false;
        if (this.shapeManager == null) {
            this.shapeManager = this.viewer.getShapeManager();
        }
        this.logMessages = false;
        this.debugScript = false;
        if (!this.isSyntaxCheck) {
            this.setDebugging();
        }
        if (this.logMessages) {
            l = System.currentTimeMillis();
            this.viewer.scriptStatus("Eval.instructionDispatchLoop():" + l);
            this.viewer.scriptStatus(this.script);
        }
        if (this.pcEnd == 0) {
            this.pcEnd = Integer.MAX_VALUE;
        }
        if (this.lineEnd == 0) {
            this.lineEnd = Integer.MAX_VALUE;
        }
        String string = "";
        if (this.aatoken == null) {
            return;
        }
        while (this.pc < this.aatoken.length && this.pc < this.pcEnd && (this.isSyntaxCheck || this.checkContinue()) && this.lineNumbers[this.pc] <= this.lineEnd) {
            block111: {
                block114: {
                    block113: {
                        block112: {
                            block110: {
                                String string2;
                                Token token = this.theToken = this.aatoken[this.pc].length == 0 ? null : this.aatoken[this.pc][0];
                                if (!(this.historyDisabled || this.isSyntaxCheck || this.scriptLevel > this.commandHistoryLevelMax || this.tQuiet)) {
                                    string2 = this.getCommand(this.pc, true, true);
                                    if (!(this.theToken == null || string2.length() <= 0 || string2.equals(string) || this.theToken.tok != 135368713 && this.theToken.tok != 102436 && Token.tokAttr(this.theToken.tok, 102400))) {
                                        string = string2;
                                        this.viewer.addCommand(string);
                                    }
                                }
                                if (!this.isSyntaxCheck && (string2 = this.viewer.getInterruptScript()) != "") {
                                    this.runScript(string2);
                                }
                                if (this.setStatement(this.pc)) break block110;
                                Logger.info(this.getCommand(this.pc, true, false) + " -- STATEMENT CONTAINING @{} SKIPPED");
                                break block111;
                            }
                            this.thisCommand = this.getCommand(this.pc, false, true);
                            this.fullCommand = this.thisCommand + this.getNextComment();
                            this.getToken(0);
                            this.iToken = 0;
                            if (bl || !this.isSyntaxCheck) {
                                int n = this.viewer.getScriptDelay();
                                if (bl || n > 0 && this.scriptLevel > 0) {
                                    if (n > 0) {
                                        this.delay(-((long)n));
                                    }
                                    this.viewer.scriptEcho("$[" + this.scriptLevel + "." + this.lineNumbers[this.pc] + "." + (this.pc + 1) + "] " + this.thisCommand);
                                }
                            }
                            if (this.vProcess == null || this.theTok == 0x119009 && this.statementLength >= 2 && this.statement[1].tok == 102439) break block112;
                            this.vProcess.add(this.statement);
                            break block111;
                        }
                        if (!this.isSyntaxCheck) break block113;
                        if (this.isCmdLine_c_or_C_Option) {
                            Logger.info(this.thisCommand);
                        }
                        if (this.statementLength != 1 || this.statement[0].tok == 135368713 || this.statement[0].tok == 102436) break block114;
                        break block111;
                    }
                    if (this.debugScript) {
                        this.logDebugScript(0);
                    }
                    if (this.scriptLevel == 0 && this.viewer.logCommands()) {
                        this.viewer.log(this.thisCommand);
                    }
                    if (this.logMessages && this.theToken != null) {
                        Logger.debug(this.theToken.toString());
                    }
                }
                if (this.theToken != null) {
                    if (Token.tokAttr(this.theToken.tok, 135168)) {
                        this.processShapeCommand(this.theToken.tok);
                    } else {
                        switch (this.theToken.tok) {
                            case 0: {
                                String string3;
                                if (this.isSyntaxCheck || !this.viewer.getMessageStyleChime() || (string3 = (String)this.theToken.value) == null) break;
                                if (this.outputBuffer == null) {
                                    string3 = "#" + string3;
                                    this.viewer.showMessage(string3);
                                }
                                this.scriptStatusOrBuffer(string3);
                                break;
                            }
                            case 266280: {
                                this.pushContext((ContextToken)this.theToken);
                                break;
                            }
                            case 266278: {
                                this.popContext(true, false);
                                break;
                            }
                            case 0x10100022: {
                                break;
                            }
                            case 20501: 
                            case 102402: 
                            case 102406: 
                            case 102407: 
                            case 102408: 
                            case 102410: 
                            case 102411: 
                            case 102412: 
                            case 102413: 
                            case 102439: 
                            case 364547: 
                            case 364548: 
                            case 528410: 
                            case 0x119009: 
                            case 135369224: 
                            case 135369225: {
                                bl2 = this.flowControl(this.theToken.tok, bl2);
                                break;
                            }
                            case 4097: {
                                this.animation();
                                break;
                            }
                            case 4098: {
                                this.assign();
                                break;
                            }
                            case 1610616835: {
                                this.background(1);
                                break;
                            }
                            case 4100: {
                                this.bind();
                                break;
                            }
                            case 4101: {
                                this.bondorder();
                                break;
                            }
                            case 4102: {
                                this.calculate();
                                break;
                            }
                            case 1069064: {
                                this.cd();
                                break;
                            }
                            case 12289: {
                                this.center(1);
                                break;
                            }
                            case 4105: {
                                this.centerAt();
                                break;
                            }
                            case 1766856708: {
                                this.color();
                                break;
                            }
                            case 135270405: {
                                this.compare();
                                break;
                            }
                            case 1095766022: {
                                this.configuration();
                                break;
                            }
                            case 4106: {
                                this.connect(1);
                                break;
                            }
                            case 528395: {
                                this.console();
                                break;
                            }
                            case 135270407: {
                                this.data();
                                break;
                            }
                            case 1060866: {
                                this.define();
                                break;
                            }
                            case 528396: {
                                this.delay();
                                break;
                            }
                            case 12291: {
                                this.delete();
                                break;
                            }
                            case 554176525: {
                                this.slab(true);
                                break;
                            }
                            case 1610625028: {
                                this.display(true);
                                break;
                            }
                            case 266254: 
                            case 266281: {
                                if (this.isSyntaxCheck) break;
                                if (this.pc > 0 && this.theToken.tok == 266254) {
                                    this.viewer.clearScriptQueue();
                                }
                                this.interruptExecution = this.pc > 0 || !this.viewer.usingScriptQueue();
                                break;
                            }
                            case 266257: {
                                if (this.isSyntaxCheck || this.viewer.isApplet()) {
                                    return;
                                }
                                this.viewer.exitJmol();
                                break;
                            }
                            case 1229984263: {
                                this.file();
                                break;
                            }
                            case 1060869: {
                                this.fixed();
                                break;
                            }
                            case 4115: {
                                this.font(-1, 0.0f);
                                break;
                            }
                            case 4116: 
                            case 1095766028: {
                                this.frame(1);
                                break;
                            }
                            case 102436: 
                            case 135368713: {
                                this.function();
                                break;
                            }
                            case 135270410: {
                                this.getProperty();
                                break;
                            }
                            case 20482: {
                                this.help();
                                break;
                            }
                            case 12294: {
                                this.display(false);
                                break;
                            }
                            case 1612189718: {
                                this.hbond();
                                break;
                            }
                            case 1610616855: {
                                this.history(1);
                                break;
                            }
                            case 544771: {
                                this.hover();
                                break;
                            }
                            case 266264: {
                                this.viewer.initialize();
                                break;
                            }
                            case 4121: {
                                this.invertSelected();
                                break;
                            }
                            case 135287298: {
                                this.script(135287298, null, false);
                                break;
                            }
                            case 135271426: {
                                this.load();
                                break;
                            }
                            case 36869: {
                                this.log();
                                break;
                            }
                            case 0x10101C: {
                                this.mapProperty();
                                break;
                            }
                            case 20485: {
                                this.message();
                                break;
                            }
                            case 4126: {
                                this.minimize();
                                break;
                            }
                            case 4128: {
                                this.move();
                                break;
                            }
                            case 4130: {
                                this.moveto();
                                break;
                            }
                            case 4131: {
                                this.navigate();
                                break;
                            }
                            case 20486: {
                                this.pause();
                                break;
                            }
                            case 4133: 
                            case 1052714: 
                            case 0x8101011: {
                                this.plot(this.statement);
                                break;
                            }
                            case 36865: {
                                this.print();
                                break;
                            }
                            case 135304706: {
                                this.prompt();
                                break;
                            }
                            case 266283: {
                                this.refresh();
                                break;
                            }
                            case 4140: {
                                this.reset();
                                break;
                            }
                            case 4141: {
                                this.restore();
                                break;
                            }
                            case 12295: {
                                this.restrict();
                                break;
                            }
                            case 266286: {
                                if (this.isSyntaxCheck) break;
                                this.resumePausedExecution();
                                break;
                            }
                            case 36866: {
                                this.returnCmd(null);
                                break;
                            }
                            case 528432: {
                                this.rotate(false, false);
                                break;
                            }
                            case 4145: {
                                this.rotate(false, true);
                                break;
                            }
                            case 4146: {
                                this.save();
                                break;
                            }
                            case 1085443: {
                                this.set();
                                break;
                            }
                            case 135271429: {
                                this.script(135271429, null, bl);
                                break;
                            }
                            case 135280131: {
                                this.select(1);
                                break;
                            }
                            case 1611141171: {
                                this.selectionHalo(1);
                                break;
                            }
                            case 4148: {
                                this.show();
                                break;
                            }
                            case 554176565: {
                                this.slab(false);
                                break;
                            }
                            case 1611141175: {
                                this.rotate(true, false);
                                break;
                            }
                            case 1611141176: {
                                this.ssbond();
                                break;
                            }
                            case 266298: {
                                if (!this.pause()) break;
                                this.stepPausedExecution();
                                break;
                            }
                            case 528443: {
                                this.stereo();
                                break;
                            }
                            case 1641025539: {
                                this.structure();
                                break;
                            }
                            case 0x303008: {
                                this.subset();
                                break;
                            }
                            case 4156: {
                                this.sync();
                                break;
                            }
                            case 536875070: {
                                this.timeout(1);
                                break;
                            }
                            case 4160: {
                                this.translate(false);
                                break;
                            }
                            case 4162: {
                                this.translate(true);
                                break;
                            }
                            case 4164: {
                                this.unbind();
                                break;
                            }
                            case 4166: {
                                this.vibration();
                                break;
                            }
                            case 135270419: {
                                this.write(null);
                                break;
                            }
                            case 1060873: {
                                this.zap(true);
                                break;
                            }
                            case 4168: {
                                this.zoom(false);
                                break;
                            }
                            case 4170: {
                                this.zoom(true);
                                break;
                            }
                            default: {
                                this.error(47);
                            }
                        }
                    }
                    this.setCursorWait(false);
                    if (this.executionStepping) {
                        this.executionPaused = this.isCommandDisplayable(this.pc + 1);
                    }
                }
            }
            ++this.pc;
        }
    }

    private void setCursorWait(boolean bl) {
        if (!this.isSyntaxCheck) {
            this.viewer.setCursor(bl ? 4 : 0);
        }
    }

    private void processShapeCommand(int n) throws ScriptException {
        int n2 = 0;
        switch (n) {
            case 1611272194: {
                n2 = 29;
                break;
            }
            case 1115297793: {
                n2 = 9;
                break;
            }
            case 1679429641: {
                n2 = 30;
                break;
            }
            case 1113200642: {
                n2 = 11;
                break;
            }
            case 135182: {
                n2 = 17;
                break;
            }
            case 1113198595: {
                n2 = 16;
                break;
            }
            case 135184: {
                n2 = 22;
                break;
            }
            case 537022465: {
                n2 = 28;
                break;
            }
            case 1113198596: {
                n2 = 20;
                break;
            }
            case 1611272213: {
                n2 = 33;
                break;
            }
            case 1113198597: {
                n2 = 19;
                break;
            }
            case 1113200646: {
                n2 = 8;
                break;
            }
            case 135197: {
                n2 = 23;
                break;
            }
            case 1826248716: {
                n2 = 5;
                break;
            }
            case 135198: {
                n2 = 24;
                break;
            }
            case 537006111: 
            case 1746538509: {
                n2 = 6;
                break;
            }
            case 1113200647: {
                n2 = 13;
                break;
            }
            case 0x121021: {
                n2 = 25;
                break;
            }
            case 135207: {
                n2 = 27;
                break;
            }
            case 135206: {
                n2 = 26;
                break;
            }
            case 135208: {
                n2 = 21;
                break;
            }
            case 1113200649: {
                n2 = 14;
                break;
            }
            case 1113200650: {
                n2 = 15;
                break;
            }
            case 1113200651: {
                n2 = 0;
                break;
            }
            case 1113200652: {
                n2 = 7;
                break;
            }
            case 1650071565: {
                n2 = 12;
                break;
            }
            case 1708089: {
                n2 = 4;
                break;
            }
            case 1113200654: {
                n2 = 10;
                break;
            }
            case 1614417984: {
                n2 = 31;
                break;
            }
            case 135233: {
                n2 = 18;
                break;
            }
            case 659523: {
                n2 = 1;
                break;
            }
            default: {
                this.error(47);
            }
        }
        switch (n) {
            case 1113200642: 
            case 1113200647: 
            case 1113200649: 
            case 1113200650: 
            case 1113200654: 
            case 1115297793: 
            case 1650071565: {
                this.proteinShape(n2);
                return;
            }
            case 1113198595: 
            case 1113198597: {
                this.dots(n2);
                return;
            }
            case 1113198596: {
                this.ellipsoid();
                return;
            }
            case 1113200646: 
            case 1113200651: 
            case 1113200652: {
                this.setAtomShapeSize(n2, n == 1113200646 ? -1.0f : 1.0f);
                return;
            }
            case 1826248716: {
                this.label(1);
                return;
            }
            case 135198: {
                this.lcaoCartoon();
                return;
            }
            case 135208: {
                this.polyhedra();
                return;
            }
            case 1708089: {
                this.struts();
                return;
            }
            case 135233: {
                this.vector();
                return;
            }
            case 659523: {
                this.wireframe();
                return;
            }
        }
        switch (n) {
            case 1611272194: {
                this.axes(1);
                return;
            }
            case 1679429641: {
                this.boundbox(1);
                return;
            }
            case 135182: {
                this.dipole();
                return;
            }
            case 135184: {
                this.draw();
                return;
            }
            case 537022465: {
                this.echo(1, false);
                return;
            }
            case 1611272213: {
                this.frank(1);
                return;
            }
            case 135197: 
            case 135206: 
            case 135207: {
                this.isosurface(n2);
                return;
            }
            case 537006111: 
            case 1746538509: {
                this.measure();
                return;
            }
            case 0x121021: {
                this.mo(false);
                return;
            }
            case 1614417984: {
                this.unitcell(1);
                return;
            }
        }
    }

    private boolean flowControl(int n, boolean bl) throws ScriptException {
        int n2;
        switch (n) {
            case 20501: {
                String string = this.parameterAsString(this.checkLast(1));
                this.gotoCmd(string);
                return bl;
            }
            case 528410: {
                this.delay();
                if (!this.isSyntaxCheck) {
                    this.pc = -1;
                }
                return bl;
            }
        }
        boolean bl2 = n2 < 0 && !this.isSyntaxCheck;
        boolean bl3 = true;
        int n3 = 0;
        switch (n) {
            case 102412: {
                this.pushContext((ContextToken)this.theToken);
                bl3 = !bl2;
                break;
            }
            case 102439: {
                this.pushContext((ContextToken)this.theToken);
                bl3 = true;
                bl2 = true;
                this.addProcess(this.pc, n2, true);
                break;
            }
            case 102410: 
            case 102411: 
            case 102413: {
                n3 = Math.abs(this.aatoken[Math.abs((int)n2)][0].intValue);
                switch (bl2 ? 0 : this.switchCmd((ContextToken)this.theToken, n)) {
                    case 0: {
                        n3 = -n3;
                        bl3 = false;
                        break;
                    }
                    case -1: {
                        bl3 = false;
                        break;
                    }
                }
                this.aatoken[this.pc][0].intValue = Math.abs(n2);
                this.theToken = this.aatoken[Math.abs(n2)][0];
                if (this.theToken.tok == 0x119009) break;
                this.theToken.intValue = n3;
                break;
            }
            case 102402: 
            case 135369225: {
                boolean bl4 = bl3 = !bl2 && this.ifCmd();
                if (this.isSyntaxCheck) break;
                n3 = Math.abs(this.aatoken[Math.abs((int)n2)][0].intValue);
                this.aatoken[Math.abs((int)n2)][0].intValue = n3 = bl2 || bl3 ? -n3 : n3;
                if (n != 102412) break;
                this.aatoken[this.pc][0].intValue = -n2;
                break;
            }
            case 364547: {
                this.checkLength(1);
                if (n2 >= 0 || this.isSyntaxCheck) break;
                this.pc = -n2 - 1;
                break;
            }
            case 364548: {
                this.checkLength(1);
                break;
            }
            case 102406: {
                if (!bl) {
                    this.pushContext((ContextToken)this.theToken);
                }
                bl = false;
                if (this.ifCmd() || this.isSyntaxCheck) break;
                this.pc = n2;
                this.popContext(true, false);
                break;
            }
            case 102407: {
                if (!this.isSyntaxCheck) {
                    this.breakCmd(n2);
                    break;
                }
                if (this.statementLength == 1) break;
                int n4 = this.intParameter(this.checkLast(1));
                if (this.isSyntaxCheck) break;
                for (int i = 0; i < n4; ++i) {
                    this.popContext(true, false);
                }
                break;
            }
            case 102408: {
                bl = true;
                if (!this.isSyntaxCheck) {
                    this.pc = n2 - 1;
                }
                if (this.statementLength <= 1) break;
                this.intParameter(this.checkLast(1));
                break;
            }
            case 135369224: {
                Token token = this.theToken;
                int[] nArray = new int[2];
                int n5 = 0;
                BitSet bitSet = null;
                int n6 = 0;
                block34: for (int i = 1; i < this.statementLength && n5 < 2; ++i) {
                    switch (this.tokAt(i)) {
                        case 0x10000F: {
                            if (n6 > 0) {
                                --n6;
                                continue block34;
                            }
                            nArray[n5++] = i;
                            continue block34;
                        }
                        case 1073741979: {
                            n6 -= 2;
                            bitSet = this.atomExpression(++i);
                            i = this.iToken;
                            continue block34;
                        }
                        case 135280131: {
                            n6 += 2;
                        }
                    }
                }
                if (bl) {
                    n5 = nArray[1] + 1;
                    bl = false;
                } else {
                    this.pushContext((ContextToken)token);
                    n5 = 2;
                    if (this.tokAt(n5) == 36868) {
                        ++n5;
                    }
                }
                String string = this.parameterAsString(n5);
                int n7 = n6 = string.equals("--") || string.equals("++") ? 1 : 0;
                if (n6 != 0) {
                    string = this.parameterAsString(++n5);
                }
                if (Token.tokAttr(this.tokAt(n5), 0x40000000) || this.getContextVariableAsVariable(string) != null) {
                    if (bitSet == null && n6 == 0 && this.getToken((int)(++n5)).tok != 269484436) {
                        this.error(22);
                    }
                    if (bitSet == null) {
                        if (n6 != 0) {
                            n5 -= 2;
                        }
                        this.setVariable(++n5, this.statementLength - 1, string, 0);
                    } else {
                        this.setVariable(n5 + 2, this.statementLength - 1, string + "_set", 0);
                        this.setVariable(n5 + 2, this.statementLength - 1, string, 0);
                    }
                }
                bl3 = this.parameterExpressionBoolean(nArray[0] + 1, nArray[1]);
                ++n2;
                if (bl3) break;
                this.popContext(true, false);
                break;
            }
            case 0x119009: {
                switch (this.getToken((int)this.checkLast((int)1)).tok) {
                    case 364558: {
                        int n8;
                        ScriptFunction scriptFunction = (ScriptFunction)this.getToken((int)1).value;
                        if (this.isSyntaxCheck) {
                            return false;
                        }
                        Map map = (Map)this.runFunction((ScriptFunction)scriptFunction, (String)"try", null, null, (boolean)true).value;
                        ScriptVariable scriptVariable = (ScriptVariable)map.get("_tryret");
                        if (scriptVariable.value != null || scriptVariable.intValue != Integer.MAX_VALUE) {
                            this.returnCmd(scriptVariable);
                            return false;
                        }
                        String string = (String)((ScriptVariable)map.get((Object)"_errorval")).value;
                        if (string.length() == 0 && (n8 = ((ScriptVariable)map.get((Object)"_breakval")).intValue) != Integer.MAX_VALUE) {
                            this.breakCmd(this.pc - n8);
                            return false;
                        }
                        if (this.pc + 1 < this.aatoken.length && this.aatoken[this.pc + 1][0].tok == 102412) {
                            ContextToken contextToken = (ContextToken)this.aatoken[this.pc + 1][0];
                            if (contextToken.contextVariables != null) {
                                contextToken.contextVariables.put(contextToken.name0, ScriptVariable.getVariable(string));
                            }
                            contextToken.intValue = (string.length() > 0 ? 1 : -1) * Math.abs(contextToken.intValue);
                        }
                        return false;
                    }
                    case 102412: {
                        this.popContext(true, false);
                        break;
                    }
                    case 102436: 
                    case 135368713: {
                        this.viewer.addFunction((ScriptFunction)this.theToken.value);
                        return bl;
                    }
                    case 102439: {
                        this.addProcess(n2, this.pc, false);
                        this.popContext(true, false);
                        break;
                    }
                    case 102410: {
                        if (n2 <= 0 || this.switchCmd((ContextToken)this.aatoken[n2][0], 0) != -1) break;
                        for (n2 = this.statement[0].intValue; n2 < this.pc && ((n = this.aatoken[n2][0].tok) == 102413 || n == 102411); ++n2) {
                        }
                        bl3 = this.pc == n2;
                    }
                }
                bl3 = this.theTok == 102412 || this.theTok == 102439 || this.theTok == 135369225 || this.theTok == 102410;
                boolean bl5 = bl = this.theTok == 135369224 || this.theTok == 102406;
            }
        }
        if (!bl3 && !this.isSyntaxCheck) {
            this.pc = Math.abs(n2) - 1;
        }
        return bl;
    }

    private void gotoCmd(String string) throws ScriptException {
        int n;
        int n2 = string == null ? this.aatoken.length - 1 : -1;
        for (n = n2 + 1; n < this.aatoken.length; ++n) {
            Token[] tokenArray = this.aatoken[n];
            if (tokenArray[0].tok != 20485 && tokenArray[0].tok != 0 || !tokenArray[tokenArray.length - 1].value.toString().equalsIgnoreCase(string)) continue;
            n2 = n;
            break;
        }
        if (n2 < 0) {
            this.error(22);
        }
        if (string == null) {
            n2 = 0;
        }
        n = n2 < this.pc ? 1 : -1;
        int n3 = 0;
        block9: for (int i = n2; i != this.pc; i += n) {
            switch (this.aatoken[i][0].tok) {
                case 102406: 
                case 102412: 
                case 102439: 
                case 266280: 
                case 135369224: {
                    ++n3;
                    continue block9;
                }
                case 266278: {
                    --n3;
                    continue block9;
                }
                case 0x119009: {
                    switch (this.aatoken[i][1].tok) {
                        case 102406: 
                        case 102412: 
                        case 102439: 
                        case 135369224: {
                            --n3;
                        }
                    }
                }
            }
        }
        if (string == null) {
            n2 = Integer.MAX_VALUE;
            while (n3 > 0) {
                this.popContext(false, false);
                --n3;
            }
        }
        if (n3 != 0) {
            this.error(22);
        }
        if (!this.isSyntaxCheck) {
            this.pc = n2 - 1;
        }
    }

    private void breakCmd(int n) {
        if (n < 0) {
            this.getContextVariableAsVariable((String)"_breakval").intValue = -n;
            this.pcEnd = this.pc;
            return;
        }
        this.pc = Math.abs(this.aatoken[n][0].intValue);
        int n2 = this.aatoken[n][0].tok;
        if (n2 == 102411 || n2 == 102413) {
            this.theToken = this.aatoken[this.pc--][0];
            int n3 = Math.abs(this.theToken.intValue);
            if (this.theToken.tok != 0x119009) {
                this.theToken.intValue = -n3;
            }
        } else {
            while (this.thisContext != null && !ScriptCompiler.isBreakableContext(this.thisContext.token.tok)) {
                this.popContext(true, false);
            }
            this.popContext(true, false);
        }
    }

    private void addProcess(int n, int n2, boolean bl) {
        if (this.parallelProcessor == null) {
            return;
        }
        if (bl) {
            this.vProcess = new ArrayList<Token[]>();
        } else {
            Token[][] tokenArrayArray = new Token[n2][];
            for (int i = 0; i < this.vProcess.size(); ++i) {
                tokenArrayArray[i + 1 - n] = this.vProcess.get(i);
            }
            ScriptContext scriptContext = this.getScriptContext();
            scriptContext.aatoken = tokenArrayArray;
            scriptContext.pc = 1 - n;
            scriptContext.pcEnd = n2;
            this.parallelProcessor.addProcess("p" + ++iProcess, scriptContext);
            this.vProcess = null;
        }
    }

    private int switchCmd(ContextToken contextToken, int n) throws ScriptException {
        ScriptVariable scriptVariable;
        if (n == 102410) {
            contextToken.addName("_var");
        }
        if ((scriptVariable = contextToken.contextVariables.get("_var")) == null) {
            return 1;
        }
        if (n == 0) {
            contextToken.contextVariables.remove("_var");
            return -1;
        }
        if (n == 102413) {
            return -1;
        }
        List<ScriptVariable> list = this.parameterExpressionList(1, 0);
        if (n == 102411) {
            boolean bl = ScriptVariable.areEqual(scriptVariable, list.get(0));
            if (bl) {
                contextToken.contextVariables.remove("_var");
            }
            return bl ? 1 : -1;
        }
        contextToken.contextVariables.put("_var", list.get(0));
        return 1;
    }

    private boolean ifCmd() throws ScriptException {
        return this.parameterExpressionBoolean(1, 0);
    }

    private void returnCmd(ScriptVariable scriptVariable) throws ScriptException {
        List<ScriptVariable> list;
        ScriptVariable scriptVariable2 = this.getContextVariableAsVariable("_retval");
        if (scriptVariable2 == null) {
            if (!this.isSyntaxCheck) {
                this.gotoCmd(null);
            }
            return;
        }
        List<ScriptVariable> list2 = list = scriptVariable != null || this.statementLength == 1 ? null : this.parameterExpressionList(1, 0);
        if (this.isSyntaxCheck) {
            return;
        }
        if (scriptVariable == null) {
            scriptVariable = list == null || list.size() == 0 ? ScriptVariable.intVariable(0) : list.get(0);
        }
        scriptVariable2.value = scriptVariable.value;
        scriptVariable2.intValue = scriptVariable.intValue;
        scriptVariable2.tok = scriptVariable.tok;
        this.gotoCmd(null);
    }

    private void help() throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        String string = this.optParameterAsString(1).toLowerCase();
        int n = 0;
        if (string.startsWith("mouse") && (n = string.indexOf(" ")) >= 0 && n == string.lastIndexOf(" ")) {
            this.showString(this.viewer.getBindingInfo(string.substring(n + 1)));
            return;
        }
        if (Token.tokAttr(Token.getTokFromName(string), 4096)) {
            string = "?command=" + string;
        }
        this.viewer.getHelp(string);
    }

    private void move() throws ScriptException {
        int n;
        if (this.statementLength > 11) {
            this.error(2);
        }
        Vector3f vector3f = new Vector3f(this.floatParameter(1), this.floatParameter(2), this.floatParameter(3));
        float f = this.floatParameter(4);
        Vector3f vector3f2 = new Vector3f(this.intParameter(5), this.intParameter(6), this.intParameter(7));
        float f2 = this.floatParameter(8);
        float f3 = this.floatParameter(9);
        int n2 = n = this.statementLength == 11 ? this.intParameter(10) : 30;
        if (this.isSyntaxCheck) {
            return;
        }
        this.refresh();
        this.viewer.move(vector3f, f, vector3f2, f2, f3, n);
    }

    private void moveto() throws ScriptException {
        if (this.statementLength == 2 && this.tokAt(1) == 1073742162) {
            if (!this.isSyntaxCheck) {
                this.viewer.stopMotion();
            }
            return;
        }
        if (this.statementLength == 2 && this.isFloatParameter(1)) {
            float f = this.floatParameter(1);
            if (this.isSyntaxCheck) {
                return;
            }
            if (f > 0.0f) {
                this.refresh();
            }
            this.viewer.moveTo(f, null, JmolConstants.axisZ, 0.0f, null, 100.0f, 0.0f, 0.0f, 0.0f, null, Float.NaN, Float.NaN, Float.NaN);
            return;
        }
        Vector3f vector3f = new Vector3f(Float.NaN, 0.0f, 0.0f);
        Point3f point3f = null;
        int n = 1;
        float f = this.isFloatParameter(n) ? this.floatParameter(n++) : 2.0f;
        float f2 = 90.0f;
        BitSet bitSet = null;
        switch (this.getToken((int)n).tok) {
            case 0x8101011: {
                Object object;
                Object object2;
                Quaternion quaternion;
                boolean bl = false;
                if (this.tokAt(++n) == 1073742030) {
                    bl = true;
                    ++n;
                }
                if (this.tokAt(n) == 10 || this.tokAt(n) == 0x100001) {
                    bl = true;
                    point3f = this.centerParameter(n);
                    if (!(this.expressionResult instanceof BitSet)) {
                        this.error(22);
                    }
                    bitSet = (BitSet)this.expressionResult;
                    quaternion = this.isSyntaxCheck ? new Quaternion() : this.viewer.getAtomQuaternion(bitSet.nextSetBit(0));
                } else if (this.tokAt(n) == 7) {
                    object2 = (String[])this.getToken((int)n).value;
                    if (((String[])object2).length == 0) {
                        this.error(22);
                    }
                    if (!((object = Escape.unescapePoint(object2[0])) instanceof Point4f)) {
                        this.error(22);
                    }
                    quaternion = new Quaternion((Point4f)object);
                } else {
                    quaternion = new Quaternion(this.getPoint4f(n));
                }
                n = this.iToken + 1;
                if (quaternion == null) {
                    this.error(22);
                }
                object2 = quaternion.toAxisAngle4f();
                vector3f.set(object2.x, object2.y, object2.z);
                f2 = (float)(bl ? -1 : 1) * (float)((double)object2.angle * 180.0 / Math.PI);
                break;
            }
            case 8: 
            case 9: 
            case 0x10000A: {
                if (this.isPoint3f(n)) {
                    vector3f.set(this.getPoint3f(n, true));
                    n = this.iToken + 1;
                    f2 = this.floatParameter(n++);
                    break;
                }
                Object object = this.getPoint4f(n);
                n = this.iToken + 1;
                vector3f.set(((Point4f)object).x, ((Point4f)object).y, ((Point4f)object).z);
                f2 = ((Point4f)object).x == 0.0f && ((Point4f)object).y == 0.0f && ((Point4f)object).z == 0.0f ? Float.NaN : ((Point4f)object).w;
                break;
            }
            case 1073741954: {
                vector3f.set(1.0f, 0.0f, 0.0f);
                f2 = 0.0f;
                this.checkLength(++n);
                break;
            }
            case 0x40000024: {
                vector3f.set(0.0f, 1.0f, 0.0f);
                f2 = 180.0f;
                this.checkLength(++n);
                break;
            }
            case 1073741996: {
                vector3f.set(0.0f, 1.0f, 0.0f);
                this.checkLength(++n);
                break;
            }
            case 1073742128: {
                vector3f.set(0.0f, -1.0f, 0.0f);
                this.checkLength(++n);
                break;
            }
            case 1074790748: {
                vector3f.set(1.0f, 0.0f, 0.0f);
                this.checkLength(++n);
                break;
            }
            case 0x40000030: {
                vector3f.set(-1.0f, 0.0f, 0.0f);
                this.checkLength(++n);
                break;
            }
            default: {
                vector3f = new Vector3f(this.floatParameter(n++), this.floatParameter(n++), this.floatParameter(n++));
                f2 = this.floatParameter(n++);
            }
        }
        if (Float.isNaN(vector3f.x) || Float.isNaN(vector3f.y) || Float.isNaN(vector3f.z)) {
            vector3f.set(0.0f, 0.0f, 0.0f);
        } else if (vector3f.length() == 0.0f && f2 == 0.0f) {
            f2 = Float.NaN;
        }
        boolean bl = !this.viewer.isInPosition(vector3f, f2);
        float f3 = this.isFloatParameter(n) ? this.floatParameter(n++) : Float.NaN;
        float f4 = 0.0f;
        float f5 = 0.0f;
        if (this.isFloatParameter(n) && !this.isCenterParameter(n)) {
            f4 = this.floatParameter(n++);
            f5 = this.floatParameter(n++);
            if (!bl && Math.abs(f4 - this.viewer.getTranslationXPercent()) >= 1.0f) {
                bl = true;
            }
            if (!bl && Math.abs(f5 - this.viewer.getTranslationYPercent()) >= 1.0f) {
                bl = true;
            }
        }
        if (bitSet == null && n != this.statementLength) {
            point3f = this.centerParameter(n);
            if (this.expressionResult instanceof BitSet) {
                bitSet = (BitSet)this.expressionResult;
            }
            n = this.iToken + 1;
        }
        float f6 = Float.NaN;
        float f7 = this.viewer.getZoomSetting();
        if (point3f != null) {
            if (!bl && (double)point3f.distance(this.viewer.getRotationCenter()) >= 0.1) {
                bl = true;
            }
            if (this.isFloatParameter(n)) {
                f6 = this.floatParameter(n++);
            }
            if (!this.isCenterParameter(n)) {
                if ((f6 == 0.0f || Float.isNaN(f6)) && (f3 == 0.0f || Float.isNaN(f3))) {
                    float f8 = Math.abs(this.getZoom(n, bitSet, f3 == 0.0f ? 0.0f : f7));
                    n = this.iToken + 1;
                    f3 = f8;
                } else if (!bl && (double)Math.abs(f6 - this.viewer.getRotationRadius()) >= 0.1) {
                    bl = true;
                }
            }
        }
        if (f3 == 0.0f || Float.isNaN(f3)) {
            f3 = 100.0f;
        }
        if (Float.isNaN(f6)) {
            f6 = 0.0f;
        }
        if (!bl && Math.abs(f3 - f7) >= 1.0f) {
            bl = true;
        }
        Point3f point3f2 = null;
        float f9 = Float.NaN;
        float f10 = Float.NaN;
        float f11 = Float.NaN;
        if (n != this.statementLength) {
            point3f2 = this.centerParameter(n);
            n = this.iToken + 1;
            if (n != this.statementLength) {
                f9 = this.floatParameter(n++);
                f10 = this.floatParameter(n++);
            }
            if (n != this.statementLength) {
                f11 = this.floatParameter(n++);
            }
        }
        if (n != this.statementLength) {
            this.error(2);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (!bl) {
            f = 0.0f;
        }
        if (f > 0.0f) {
            this.refresh();
        }
        this.viewer.moveTo(f, point3f, vector3f, f2, null, f3, f4, f5, f6, point3f2, f9, f10, f11);
    }

    private void navigate() throws ScriptException {
        if (this.statementLength == 1) {
            this.setBooleanProperty("navigationMode", true);
            return;
        }
        Vector3f vector3f = new Vector3f(0.0f, 1.0f, 0.0f);
        if (this.statementLength == 2) {
            switch (this.getToken((int)1).tok) {
                case 0x10000C: 
                case 0x10000D: {
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.setObjectMad(29, "axes", 1);
                    this.setShapeProperty(29, "position", new Point3f(50.0f, 50.0f, Float.MAX_VALUE));
                    this.setBooleanProperty("navigationMode", true);
                    this.viewer.setNavOn(this.theTok == 0x10000D);
                    return;
                }
                case 1073742162: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.setNavXYZ(0.0f, 0.0f, 0.0f);
                    }
                    return;
                }
                case 8: {
                    break;
                }
                default: {
                    this.error(22);
                }
            }
        }
        if (!this.viewer.getNavigationMode()) {
            this.setBooleanProperty("navigationMode", true);
        }
        block27: for (int i = 1; i < this.statementLength; ++i) {
            float f;
            float f2 = f = this.isFloatParameter(i) ? this.floatParameter(i++) : 2.0f;
            if (f < 0.0f) {
                this.error(22);
            }
            if (!this.isSyntaxCheck && f > 0.0f) {
                this.refresh();
            }
            switch (this.getToken((int)i).tok) {
                case 8: 
                case 0x10000A: {
                    Point3f point3f = this.getPoint3f(i, true);
                    ++this.iToken;
                    if (this.iToken != this.statementLength) {
                        this.error(22);
                    }
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.setNavXYZ(point3f.x, point3f.y, point3f.z);
                    return;
                }
                case 554176525: {
                    float f3 = this.floatParameter(++i);
                    if (this.isSyntaxCheck) continue block27;
                    this.viewer.setNavigationDepthPercent(f, f3);
                    continue block27;
                }
                case 12289: {
                    Point3f point3f = this.centerParameter(++i);
                    i = this.iToken;
                    if (this.isSyntaxCheck) continue block27;
                    this.viewer.navigate(f, point3f);
                    continue block27;
                }
                case 528432: {
                    switch (this.getToken((int)(++i)).tok) {
                        case 1112541203: {
                            vector3f.set(1.0f, 0.0f, 0.0f);
                            break;
                        }
                        case 1112541204: {
                            vector3f.set(0.0f, 1.0f, 0.0f);
                            break;
                        }
                        case 1112541205: {
                            vector3f.set(0.0f, 0.0f, 1.0f);
                            break;
                        }
                        case 0x40000000: {
                            this.error(22);
                            break;
                        }
                        case 8: 
                        case 0x10000A: {
                            vector3f.set(this.getPoint3f(i, true));
                            i = this.iToken + 1;
                        }
                    }
                    float f4 = this.floatParameter(i);
                    if (this.isSyntaxCheck) continue block27;
                    this.viewer.navigate(f, vector3f, f4);
                    continue block27;
                }
                case 4160: {
                    Point3f point3f;
                    float f5 = Float.NaN;
                    float f6 = Float.NaN;
                    if (this.isFloatParameter(++i)) {
                        f5 = this.floatParameter(i);
                        f6 = this.floatParameter(++i);
                    } else {
                        switch (this.tokAt(i)) {
                            case 1112541203: {
                                f5 = this.floatParameter(++i);
                                break;
                            }
                            case 1112541204: {
                                f6 = this.floatParameter(++i);
                                break;
                            }
                            default: {
                                point3f = this.centerParameter(i);
                                i = this.iToken;
                                if (this.isSyntaxCheck) continue block27;
                                this.viewer.navTranslate(f, point3f);
                                continue block27;
                            }
                        }
                    }
                    if (this.isSyntaxCheck) continue block27;
                    this.viewer.navTranslatePercent(f, f5, f6);
                    continue block27;
                }
                case 0x101000B0: {
                    continue block27;
                }
                case 1113200654: {
                    ArrayList<Point3f[]> arrayList = new ArrayList<Point3f[]>();
                    BitSet bitSet = this.atomExpression(++i);
                    i = this.iToken;
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.getPolymerPointsAndVectors(bitSet, arrayList);
                    int n = arrayList.size();
                    if (n <= 0) continue block27;
                    Point3f[][] point3fArray = new Point3f[n][];
                    for (int j = 0; j < n; ++j) {
                        point3fArray[j] = (Point3f[])arrayList.get(j);
                    }
                    this.viewer.navigate(f, point3fArray);
                    continue block27;
                }
                case 0x30000D: {
                    if (i != 1) {
                        this.error(22);
                    }
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.navigateSurface(f, this.optParameterAsString(2));
                    continue block27;
                }
                case 0x40000104: {
                    int n;
                    Object object;
                    float[] fArray = null;
                    if (this.getToken((int)(i + 1)).tok == 0x100007) {
                        ++i;
                        object = this.objectNameParameter(++i);
                        if (this.isSyntaxCheck) {
                            return;
                        }
                        this.setShapeProperty(22, "thisID", object);
                        Point3f[] point3fArray = (Point3f[])this.getShapeProperty(22, "vertices");
                        this.refresh();
                        if (point3fArray == null) {
                            this.error(22);
                        }
                        n = (int)(this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 0.0f);
                        int n2 = (int)(this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 2.1474836E9f);
                        if (this.isSyntaxCheck) continue block27;
                        this.viewer.navigate(f, point3fArray, fArray, n, n2);
                        continue block27;
                    }
                    object = new ArrayList();
                    while (this.isCenterParameter(i + 1)) {
                        object.add(this.centerParameter(++i));
                        i = this.iToken;
                    }
                    if (object.size() > 0) {
                        Point3f[] point3fArray = new Point3f[object.size()];
                        for (n = 0; n < object.size(); ++n) {
                            point3fArray[n] = (Point3f)object.get(n);
                        }
                        if (this.isSyntaxCheck) continue block27;
                        this.viewer.navigate(f, point3fArray, fArray, 0, Integer.MAX_VALUE);
                        continue block27;
                    }
                }
                default: {
                    this.error(22);
                }
            }
        }
    }

    private void bondorder() throws ScriptException {
        this.checkLength(-3);
        int n = 0;
        switch (this.getToken((int)1).tok) {
            case 2: 
            case 3: {
                n = JmolConstants.getBondOrderFromFloat(this.floatParameter(1));
                if (n != 131071) break;
                this.error(22);
                break;
            }
            default: {
                n = JmolConstants.getBondOrderFromString(this.parameterAsString(1));
                if (n == 131071) {
                    this.error(22);
                }
                if (n != 33 || this.tokAt(2) != 3) break;
                n = JmolConstants.getPartialBondOrderFromInteger(this.statement[2].intValue);
            }
        }
        this.setShapeProperty(1, "bondOrder", n);
    }

    private void console() throws ScriptException {
        switch (this.getToken((int)1).tok) {
            case 0x10000C: {
                if (this.isSyntaxCheck) break;
                this.viewer.showConsole(false);
                break;
            }
            case 0x10000D: {
                if (this.isSyntaxCheck) break;
                this.viewer.showConsole(true);
                break;
            }
            default: {
                this.error(22);
            }
        }
    }

    private void centerAt() throws ScriptException {
        String string = null;
        switch (this.getToken((int)1).tok) {
            case 0x40000002: {
                string = "absolute";
                break;
            }
            case 96: {
                string = "average";
                break;
            }
            case 1679429641: {
                string = "boundbox";
                break;
            }
            default: {
                this.error(22);
            }
        }
        Point3f point3f = new Point3f(0.0f, 0.0f, 0.0f);
        if (this.statementLength == 5) {
            point3f.x = this.floatParameter(2);
            point3f.y = this.floatParameter(3);
            point3f.z = this.floatParameter(4);
        } else if (this.isCenterParameter(2)) {
            point3f = this.centerParameter(2);
            this.checkLast(this.iToken);
        } else {
            this.checkLength(2);
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setCenterAt(string, point3f);
        }
    }

    private void stereo() throws ScriptException {
        int n = 1;
        float f = -5.0f;
        boolean bl = false;
        int[] nArray = null;
        int n2 = 0;
        block6: for (int i = 1; i < this.statementLength; ++i) {
            if (this.isColorParam(i)) {
                if (n2 > 1) {
                    this.error(2);
                }
                if (n2 == 0) {
                    nArray = new int[2];
                }
                if (!bl) {
                    f = 3.0f;
                }
                nArray[n2] = this.getArgbParam(i);
                if (n2++ == 0) {
                    nArray[1] = ~nArray[0];
                }
                i = this.iToken;
                continue;
            }
            switch (this.getToken((int)i).tok) {
                case 0x10000D: {
                    this.iToken = 1;
                    this.checkLast(1);
                    this.iToken = 1;
                    continue block6;
                }
                case 0x10000C: {
                    this.iToken = 1;
                    this.checkLast(1);
                    n = 0;
                    continue block6;
                }
                case 2: 
                case 3: {
                    f = this.floatParameter(i);
                    bl = true;
                    continue block6;
                }
                case 0x40000000: {
                    if (!bl) {
                        f = 3.0f;
                    }
                    if ((n = JmolConstants.getStereoMode(this.parameterAsString(i))) != -1) continue block6;
                }
                default: {
                    this.error(22);
                }
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.setStereoMode(nArray, n, f);
    }

    private void compare() throws ScriptException {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        float f = Float.NaN;
        Quaternion[] quaternionArray = null;
        Quaternion[] quaternionArray2 = null;
        BitSet bitSet = null;
        BitSet bitSet2 = null;
        ArrayList<Object> arrayList = null;
        ArrayList<Object[]> arrayList2 = null;
        BitSet bitSet3 = this.atomExpression(1);
        BitSet bitSet4 = this.atomExpression(++this.iToken);
        BitSet bitSet5 = null;
        boolean bl5 = false;
        String string = null;
        block13: for (int i = this.iToken + 1; i < this.statementLength; ++i) {
            switch (this.getToken((int)i).tok) {
                case 135267336: {
                    bl5 = true;
                }
                case 135267335: {
                    string = this.stringParameter(++i);
                    continue block13;
                }
                case 2: 
                case 3: {
                    f = Math.abs(this.floatParameter(i));
                    if (!(f > 0.0f)) continue block13;
                    bl4 = true;
                    continue block13;
                }
                case 0x10100030: {
                    continue block13;
                }
                case 0x303008: {
                    bitSet5 = this.atomExpression(++i);
                    i = this.iToken;
                    continue block13;
                }
                case 10: 
                case 0x100001: {
                    if (arrayList2 != null) {
                        this.error(22);
                    }
                    bitSet = this.atomExpression(this.iToken);
                    int n = this.tokAt(this.iToken + 1);
                    bitSet2 = n == 10 || n == 0x100001 ? this.atomExpression(++this.iToken) : BitSetUtil.copy(bitSet);
                    bitSet.and(bitSet3);
                    bitSet2.and(bitSet4);
                    if (bitSet5 != null) {
                        bitSet.and(bitSet5);
                        bitSet2.and(bitSet5);
                    }
                    if (arrayList == null) {
                        arrayList = new ArrayList();
                    }
                    arrayList.add(new BitSet[]{bitSet, bitSet2});
                    i = this.iToken;
                    continue block13;
                }
                case 7: {
                    if (arrayList != null) {
                        this.error(22);
                    }
                    bl = true;
                    quaternionArray = ScriptMathProcessor.getQuaternionArray((Object[])this.theToken.value);
                    this.getToken(++i);
                    quaternionArray2 = ScriptMathProcessor.getQuaternionArray((Object[])this.theToken.value);
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<Object[]>();
                    }
                    arrayList2.add(new Object[]{quaternionArray, quaternionArray2});
                    continue block13;
                }
                case 1073742078: {
                    bl = true;
                    continue block13;
                }
                case 0x8100010: 
                case 0x44100001: {
                    bl = false;
                    continue block13;
                }
                case 528432: {
                    bl2 = true;
                    continue block13;
                }
                case 4160: {
                    bl3 = true;
                    continue block13;
                }
                default: {
                    this.error(22);
                }
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        float[] fArray = new float[2];
        Quaternion quaternion = null;
        ArrayList<Quaternion> arrayList3 = new ArrayList<Quaternion>();
        Point3f[][] point3fArray = null;
        if (bl) {
            int n;
            if (arrayList == null && arrayList2 == null) {
                arrayList = new ArrayList<BitSet[]>();
                arrayList.add(new BitSet[]{bitSet3, bitSet4});
            }
            if (arrayList2 == null) {
                for (n = 0; n < arrayList.size(); ++n) {
                    BitSet[] bitSetArray = (BitSet[])arrayList.get(n);
                    quaternionArray = this.viewer.getAtomGroupQuaternions(bitSetArray[0], Integer.MAX_VALUE);
                    quaternionArray2 = this.viewer.getAtomGroupQuaternions(bitSetArray[1], Integer.MAX_VALUE);
                    for (int i = 0; i < quaternionArray.length && i < quaternionArray2.length; ++i) {
                        arrayList3.add(quaternionArray2[i].div(quaternionArray[i]));
                    }
                }
            } else {
                for (n = 0; n < quaternionArray.length && n < quaternionArray2.length; ++n) {
                    arrayList3.add(quaternionArray2[n].div(quaternionArray[n]));
                }
            }
            fArray[0] = 0.0f;
            quaternionArray = new Quaternion[arrayList3.size()];
            n = arrayList3.size();
            while (--n >= 0) {
                quaternionArray[n] = (Quaternion)arrayList3.get(n);
            }
            quaternion = Quaternion.sphereMean(quaternionArray, fArray, 1.0E-4f);
            this.showString("RMSD = " + fArray[0] + " degrees");
        } else if (string != null) {
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            bitSet = BitSetUtil.copy(bitSet3);
            bitSet2 = BitSetUtil.copy(bitSet4);
            arrayList.add(new BitSet[]{bitSet, bitSet2});
            Matrix4f matrix4f = new Matrix4f();
            float f2 = this.getSmilesCorrelation(bitSet3, bitSet4, string, null, null, matrix4f, null, !bl5);
            if (Float.isNaN(f2)) {
                this.error(22);
            }
            Vector3f vector3f = new Vector3f();
            matrix4f.get(vector3f);
            object = new Matrix3f();
            matrix4f.get((Matrix3f)object);
            quaternion = new Quaternion((Matrix3f)object);
        } else {
            if (bitSet == null) {
                bitSet = this.viewer.getAtomBitSet("spine");
                if (bitSet.nextSetBit(0) < 0) {
                    bitSet = bitSet3;
                    bitSet2 = bitSet4;
                } else {
                    bitSet2 = BitSetUtil.copy(bitSet);
                    bitSet.and(bitSet3);
                    bitSet2.and(bitSet4);
                }
                arrayList = new ArrayList();
                arrayList.add(new BitSet[]{bitSet, bitSet2});
            }
            point3fArray = this.viewer.getCenterAndPoints(arrayList, true);
            quaternion = Measure.calculateQuaternionRotation(point3fArray, fArray, true);
            float f3 = Float.isNaN(fArray[1]) ? Float.NaN : (float)((int)(fArray[0] * 100.0f)) / 100.0f;
            float f4 = Float.isNaN(fArray[1]) ? Float.NaN : (float)((int)(fArray[1] * 100.0f)) / 100.0f;
            this.showString("RMSD " + f3 + " --> " + f4 + " Angstroms");
        }
        Point3f point3f = new Point3f();
        if (point3fArray == null) {
            point3fArray = this.viewer.getCenterAndPoints(arrayList, true);
        }
        if (Float.isNaN(f) || f < 0.0f) {
            f = 1.0f;
        } else if (!bl2 && !bl3) {
            bl3 = true;
            bl2 = true;
            bl4 = true;
        }
        bl4 = f != 0.0f;
        float f5 = Float.NaN;
        Vector3f vector3f = null;
        if (bl3) {
            vector3f = new Vector3f(point3fArray[1][0]);
            vector3f.sub(point3fArray[0][0]);
            f5 = 0.0f;
        }
        if (bl2) {
            if (quaternion == null) {
                this.evalError("option not implemented", null);
            }
            point3f.set(point3fArray[0][0]);
            point3f.add(quaternion.getNormal());
            f5 = quaternion.getTheta();
        }
        if (Float.isNaN(f5) || Float.isNaN(point3f.x)) {
            return;
        }
        object = null;
        if (bl2 && bl3 && f != 0.0f) {
            List<Point3f> list = this.viewer.getAtomPointVector(bitSet3);
            Matrix4f matrix4f = ScriptMathProcessor.getMatrix4f(quaternion.getMatrix(), vector3f);
            object = Measure.transformPoints(list, matrix4f, point3fArray[0][0]);
        }
        this.viewer.rotateAboutPointsInternal(point3fArray[0][0], point3f, f5 / f, f5, bl4, bitSet3, vector3f, (List<Point3f>)object);
    }

    float getSmilesCorrelation(BitSet bitSet, BitSet bitSet2, String string, List<Point3f> list, List<Point3f> list2, Matrix4f matrix4f, List<BitSet> list3, boolean bl) throws ScriptException {
        float f = 0.1f;
        try {
            int n;
            if (list == null) {
                list = new ArrayList<Point3f>();
                list2 = new ArrayList<Point3f>();
            }
            if (matrix4f == null) {
                matrix4f = new Matrix4f();
            }
            JmolNode[] jmolNodeArray = this.viewer.getModelSet().atoms;
            int n2 = this.viewer.getAtomCount();
            int[][] nArray = this.viewer.getSmilesMatcher().getCorrelationMaps(string, jmolNodeArray, n2, bitSet, bl, true);
            if (nArray == null) {
                this.evalError(this.viewer.getSmilesMatcher().getLastException(), null);
            }
            if (nArray.length == 0) {
                return Float.NaN;
            }
            for (int i = 0; i < nArray[0].length; ++i) {
                list.add((Point3f)((Object)jmolNodeArray[nArray[0][i]]));
            }
            nArray = this.viewer.getSmilesMatcher().getCorrelationMaps(string, jmolNodeArray, n2, bitSet2, bl, false);
            if (nArray == null) {
                this.evalError(this.viewer.getSmilesMatcher().getLastException(), null);
            }
            if (nArray.length == 0) {
                return Float.NaN;
            }
            float f2 = Float.MAX_VALUE;
            int[] nArray2 = null;
            for (n = 0; n < nArray.length; ++n) {
                list2.clear();
                for (int i = 0; i < nArray[n].length; ++i) {
                    list2.add((Point3f)((Object)jmolNodeArray[nArray[n][i]]));
                }
                float f3 = Measure.getTransformMatrix4(list, list2, matrix4f, null);
                Logger.info("getSmilesCorrelation stddev=" + f3);
                if (list3 != null && f3 < f) {
                    BitSet bitSet3 = new BitSet();
                    for (int i = 0; i < nArray[n].length; ++i) {
                        bitSet3.set(nArray[n][i]);
                    }
                    list3.add(bitSet3);
                }
                if (!(f3 < f2)) continue;
                nArray2 = nArray[n];
                f2 = f3;
            }
            for (n = 0; n < nArray2.length; ++n) {
                list2.add((Point3f)((Object)jmolNodeArray[nArray2[n]]));
            }
            return f2;
        }
        catch (Exception exception) {
            this.evalError(exception.getMessage(), null);
            return 0.0f;
        }
    }

    Object getSmilesMatches(String string, String string2, BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2) throws ScriptException {
        int n;
        Object object;
        BitSet[] bitSetArray;
        if (this.isSyntaxCheck) {
            if (bl2) {
                return new BitSet();
            }
            return new String[]{"({})"};
        }
        if (string.length() == 0) {
            boolean bl3 = !bl2;
            String string3 = this.viewer.getSmiles(0, 0, bitSet, bl3, false, true, true);
            if (string3 == null) {
                this.evalError(this.viewer.getSmilesMatcher().getLastException(), null);
            }
            return string3;
        }
        boolean bl4 = true;
        if (bitSet2 == null) {
            bl4 = string2 == null;
            bitSetArray = bl4 ? this.viewer.getSmilesMatcher().getSubstructureSetArray(string, this.viewer.getModelSet().atoms, this.viewer.getAtomCount(), bitSet, null, bl, false) : this.viewer.getSmilesMatcher().find(string, string2, bl, false);
            if (bitSetArray == null) {
                this.showString(this.viewer.getSmilesMatcher().getLastException(), false);
                if (!bl4 && !bl) {
                    return -1;
                }
                return "?";
            }
        } else {
            object = new ArrayList<BitSet>();
            float f = this.getSmilesCorrelation(bitSet2, bitSet, string, null, null, null, (List<BitSet>)object, bl);
            if (Float.isNaN(f)) {
                if (bl2) {
                    return new BitSet();
                }
                return new String[0];
            }
            this.showString("RMSD " + f + " Angstroms");
            bitSetArray = new BitSet[object.size()];
            for (n = 0; n < bitSetArray.length; ++n) {
                bitSetArray[n] = (BitSet)object.get(n);
            }
        }
        if (bl2) {
            object = new BitSet();
            for (int i = 0; i < bitSetArray.length; ++i) {
                object.or(bitSetArray[i]);
            }
            if (bl4) {
                return object;
            }
            if (!bl) {
                return object.cardinality();
            }
            int[] nArray = new int[object.cardinality()];
            n = 0;
            int n2 = object.nextSetBit(0);
            while (n2 >= 0) {
                nArray[n++] = n2 + 1;
                n2 = object.nextSetBit(n2 + 1);
            }
            return nArray;
        }
        object = new String[bitSetArray.length];
        for (int i = 0; i < bitSetArray.length; ++i) {
            object[i] = Escape.escape(bitSetArray[i], bl4);
        }
        return object;
    }

    private void connect(int n) throws ScriptException {
        Object object;
        int n2;
        float[] fArray = new float[2];
        BitSet[] bitSetArray = new BitSet[2];
        bitSetArray[0] = bitSetArray[1] = this.viewer.getSelectionSet(false);
        float f = Float.NaN;
        int n3 = Integer.MIN_VALUE;
        int n4 = 0;
        int n5 = 131071;
        int n6 = 1073742026;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = null;
        float f2 = Float.MAX_VALUE;
        boolean bl4 = false;
        int n7 = 0;
        int n8 = 0;
        BitSet bitSet = new BitSet();
        boolean bl5 = false;
        int n9 = 0;
        int n10 = 0;
        float f3 = 0.0f;
        if (this.statementLength == 1) {
            this.viewer.rebond();
            return;
        }
        block21: for (n2 = n; n2 < this.statementLength; ++n2) {
            switch (this.getToken((int)n2).tok) {
                case 0x10000C: 
                case 0x10000D: {
                    this.checkLength(2);
                    if (!this.isSyntaxCheck) {
                        this.viewer.rebond();
                    }
                    return;
                }
                case 2: 
                case 3: {
                    int n11;
                    if (n7 > 0) {
                        if (bl2 || bl4) {
                            this.error(23);
                        }
                        if ((n11 = JmolConstants.getBondOrderFromFloat(this.floatParameter(n2))) == 131071) {
                            this.error(22);
                        }
                        n5 = n11;
                        bl2 = true;
                        break;
                    }
                    if (++n8 > 2) {
                        this.error(2);
                    }
                    float f4 = this.floatParameter(n2);
                    if (this.tokAt(n2 + 1) == 269484210) {
                        f4 = -f4 / 100.0f;
                        ++n2;
                    }
                    fArray[n4++] = f4;
                    break;
                }
                case 10: 
                case 0x100001: {
                    int n12;
                    int n13;
                    if (n7 > 2 || bl5 && n7 > 0) {
                        this.error(2);
                    }
                    if (bl2 || bl4) {
                        this.error(23);
                    }
                    bitSetArray[n7++] = this.atomExpression(n2);
                    bl5 = this.isBondSet;
                    if (n7 == 2) {
                        n13 = this.iToken;
                        for (n12 = n2; n12 < n13; ++n12) {
                            if (this.tokAt(n12) != 0x40000000 || !this.parameterAsString(n12).equals("_1")) continue;
                            n9 = n2;
                            break;
                        }
                        this.iToken = n13;
                    }
                    n2 = this.iToken;
                    break;
                }
                case 1766856708: {
                    int n13 = this.tokAt(n2 + 1);
                    if (n13 == 1073742180 || n13 == 1073742074) continue block21;
                    n10 = n2 + 1;
                    continue block21;
                }
                case 1073742074: 
                case 1073742180: {
                    if (string != null) {
                        this.error(22);
                    }
                    bl4 = true;
                    string = this.parameterAsString(n2);
                    if (this.theTok == 1073742180 && this.isFloatParameter(n2 + 1)) {
                        f2 = this.getTranslucentLevel(++n2);
                    }
                    n10 = n2 + 1;
                    break;
                }
                case 1074790662: {
                    int n12 = this.tokAt(2) == 1073741852 ? 1 : 0;
                    this.checkLength(n12 != 0 ? 3 : 2);
                    if (!this.isSyntaxCheck) {
                        this.viewer.setPdbConectBonding(n12 != 0);
                    }
                    return;
                }
                case 0x40000006: 
                case 1073741852: 
                case 0x40000050: 
                case 1073742024: 
                case 1073742026: {
                    bl3 = true;
                    if (++n2 != this.statementLength) {
                        this.error(23);
                    }
                    n6 = this.theTok;
                    if (this.theTok != 1073741852 || n5 == 131071 || n5 == 2048 || n5 == 515) break;
                    this.error(22);
                    break;
                }
                case 1708089: {
                    if (!bl4) {
                        n3 = 0xFFFFFF;
                        string = "translucent";
                        f2 = 0.5f;
                        f = this.viewer.getStrutDefaultRadius();
                        bl4 = true;
                    }
                    if (!bl3) {
                        n6 = 1073742026;
                    }
                    bl3 = true;
                }
                case 0x40000000: 
                case 1076887572: 
                case 1612189718: {
                    int n11;
                    if (n2 > 0) {
                        if (n10 == n2) break;
                        if (this.isColorParam(n2)) {
                            n10 = -n2;
                            break;
                        }
                    }
                    if ((n11 = JmolConstants.getBondOrderFromString((String)(object = this.parameterAsString(n2)))) == 131071) {
                        this.error(22);
                    }
                    if (bl2) {
                        this.error(18);
                    }
                    bl2 = true;
                    switch (n11) {
                        case 33: {
                            switch (this.tokAt(n2 + 1)) {
                                case 3: {
                                    n11 = JmolConstants.getPartialBondOrderFromInteger(this.statement[++n2].intValue);
                                    break;
                                }
                                case 2: {
                                    n11 = (short)this.intParameter(++n2);
                                }
                            }
                            break;
                        }
                        case 2048: {
                            if (this.tokAt(n2 + 1) != 2) break;
                            n11 = (short)(this.intParameter(++n2) << 11);
                            f3 = this.floatParameter(++n2);
                        }
                    }
                    n5 = n11;
                    break;
                }
                case 1666189314: {
                    f = this.floatParameter(++n2);
                    bl4 = true;
                    break;
                }
                case 12291: 
                case 0x10000B: {
                    if (++n2 != this.statementLength) {
                        this.error(23);
                    }
                    n6 = 12291;
                    bl = true;
                    bl4 = false;
                    break;
                }
                default: {
                    n10 = n2;
                }
            }
            if (n2 <= 0) continue;
            if (n10 == -n2 || n10 == n2 && this.isColorParam(n2)) {
                n3 = this.getArgbParam(n2);
                n2 = this.iToken;
                bl4 = true;
                continue;
            }
            if (n10 != n2) continue;
            this.error(22);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (n4 < 2) {
            if (n4 == 0) {
                fArray[0] = 1.0E8f;
            }
            fArray[1] = fArray[0];
            fArray[0] = 0.1f;
        }
        if (string != null || !Float.isNaN(f) || n3 != Integer.MIN_VALUE) {
            if (!bl2) {
                n5 = 65535;
            }
            if (!bl3) {
                n6 = 1073742024;
            }
        }
        n2 = 0;
        int n14 = 0;
        if (n9 > 0) {
            BitSet bitSet2 = new BitSet();
            this.definedAtomSets.put("_1", bitSet2);
            object = bitSetArray[0];
            int n15 = ((BitSet)object).nextSetBit(0);
            while (n15 >= 0) {
                bitSet2.set(n15);
                int[] nArray = this.viewer.makeConnections(fArray[0], fArray[1], n5, n6, bitSet2, this.atomExpression(n9), bitSet, bl5, 0.0f);
                n2 += Math.abs(nArray[0]);
                n14 += nArray[1];
                bitSet2.clear(n15);
                n15 = ((BitSet)object).nextSetBit(n15 + 1);
            }
        } else {
            int[] nArray = this.viewer.makeConnections(fArray[0], fArray[1], n5, n6, bitSetArray[0], bitSetArray[1], bitSet, bl5, f3);
            n2 += Math.abs(nArray[0]);
            n14 += nArray[1];
        }
        if (bl) {
            if (!this.tQuiet && this.scriptLevel <= this.scriptReportingLevel) {
                this.scriptStatusOrBuffer(GT._("{0} connections deleted", n14));
            }
            return;
        }
        if (bl4) {
            this.viewer.selectBonds(bitSet);
            if (!Float.isNaN(f)) {
                this.setShapeSize(1, (int)(f * 2000.0f), null);
            }
            if (n3 != Integer.MIN_VALUE) {
                this.setShapeProperty(1, "color", n3, bitSet);
            }
            if (string != null) {
                if (f2 == Float.MAX_VALUE) {
                    f2 = this.viewer.getDefaultTranslucent();
                }
                this.setShapeProperty(1, "translucentLevel", new Float(f2));
                this.setShapeProperty(1, "translucency", string, bitSet);
            }
            this.viewer.selectBonds(null);
        }
        if (!this.tQuiet && this.scriptLevel <= this.scriptReportingLevel) {
            this.scriptStatusOrBuffer(GT._("{0} new bonds; {1} modified", new Object[]{n2, n14}));
        }
    }

    private float getTranslucentLevel(int n) throws ScriptException {
        float f = this.floatParameter(n);
        return this.theTok == 2 && f > 0.0f && f < 9.0f ? f + 1.0f : f;
    }

    private void getProperty() throws ScriptException {
        BitSet bitSet;
        if (this.isSyntaxCheck) {
            return;
        }
        String string = "";
        String string2 = this.optParameterAsString(1);
        String string3 = string2;
        if (string3.indexOf(".") >= 0) {
            string3 = string3.substring(0, string3.indexOf("."));
        }
        if (string3.indexOf("[") >= 0) {
            string3 = string3.substring(0, string3.indexOf("["));
        }
        int n = PropertyManager.getPropertyNumber(string3);
        String string4 = this.optParameterAsString(2);
        int n2 = this.tokAt(2);
        BitSet bitSet2 = bitSet = n2 == 0x100001 || n2 == 10 ? this.atomExpression(2) : null;
        if (string2.length() > 0 && n < 0) {
            string2 = "";
            string4 = "";
        } else if (n >= 0 && this.statementLength < 3) {
            string4 = PropertyManager.getDefaultParam(n);
            if (string4.equals("(visible)")) {
                this.viewer.setModelVisibility();
                bitSet = this.viewer.getVisibleSet();
            }
        } else if (n == 3) {
            for (int i = 3; i < this.statementLength; ++i) {
                string4 = string4 + this.parameterAsString(i);
            }
        }
        string = (String)this.viewer.getProperty("readable", string2, bitSet == null ? string4 : bitSet);
        this.showString(string);
    }

    private void background(int n) throws ScriptException {
        this.getToken(n);
        if (this.theTok == 1073741978) {
            String string = this.parameterAsString(this.checkLast(++n));
            if (this.isSyntaxCheck) {
                return;
            }
            String[] stringArray = new String[1];
            Image image = null;
            if (!string.equalsIgnoreCase("none") && string.length() > 0) {
                image = this.viewer.getFileAsImage(string, stringArray);
            }
            if (image == null) {
                this.evalError(stringArray[0], null);
            }
            this.viewer.setBackgroundImage(stringArray[0], image);
            return;
        }
        if (this.isColorParam(n) || this.theTok == 0x10000B) {
            int n2 = this.getArgbParamLast(n, true);
            if (this.isSyntaxCheck) {
                return;
            }
            this.setObjectArgb("background", n2);
            this.viewer.setBackgroundImage(null, null);
            return;
        }
        int n3 = this.getShapeType(this.theTok);
        this.colorShape(n3, n + 1, true);
    }

    private void center(int n) throws ScriptException {
        if (this.statementLength == 1) {
            this.viewer.setNewRotationCenter(null);
            return;
        }
        Point3f point3f = this.centerParameter(n);
        if (point3f == null) {
            this.error(22);
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setNewRotationCenter(point3f);
        }
    }

    private String setObjectProperty() throws ScriptException {
        String string = "";
        String string2 = this.getShapeNameParameter(2);
        Object[] objectArray = new Object[]{string2, null};
        if (this.isSyntaxCheck) {
            return "";
        }
        int n = this.iToken;
        int n2 = this.tokAt(0);
        boolean bl = TextFormat.isWild(string2);
        int n3 = 17;
        do {
            if (n3 != 25 && this.getShapeProperty(n3, "checkID", objectArray)) {
                this.setShapeProperty(n3, "thisID", string2);
                switch (n2) {
                    case 12291: {
                        this.setShapeProperty(n3, "delete", null);
                        break;
                    }
                    case 12294: 
                    case 1610625028: {
                        this.setShapeProperty(n3, "hidden", n2 == 1610625028 ? Boolean.FALSE : Boolean.TRUE);
                        break;
                    }
                    case 4148: {
                        if (n3 == 23 && !bl) {
                            return this.getIsosurfaceJvxl(false, 23);
                        }
                        if (n3 == 26 && !bl) {
                            return this.getIsosurfaceJvxl(true, 26);
                        }
                        string = string + (String)this.getShapeProperty(n3, "command") + "\n";
                    }
                    case 1766856708: {
                        this.colorShape(n3, n + 1, false);
                    }
                }
                if (!bl) break;
            }
            if (n3 != 17) continue;
            n3 = 29;
        } while (--n3 >= 22);
        return string;
    }

    private void color() throws ScriptException {
        int n = 1;
        if (this.isColorParam(1)) {
            this.theTok = 0x44100001;
        } else {
            int n2 = 0;
            n = 2;
            int n3 = this.getToken((int)1).tok;
            switch (n3) {
                case 0x100007: {
                    this.setObjectProperty();
                    return;
                }
                case 0x10000B: 
                case 0x300001: 
                case 1073741946: 
                case 1073741992: 
                case 0x400000D0: 
                case 1073742074: 
                case 1073742116: 
                case 0x40000140: 
                case 1073742180: 
                case 1073742186: 
                case 1087373315: 
                case 0x40D00004: 
                case 1087373318: 
                case 1087373322: 
                case 1095761934: 
                case 1095761935: 
                case 1112539144: 
                case 1112539145: 
                case 1112541195: 
                case 1112541198: 
                case 1112541199: 
                case 1113200651: 
                case 1632634889: 
                case 1641025539: 
                case 1716520972: {
                    this.theTok = 0x44100001;
                    n = 1;
                    break;
                }
                case 4: {
                    boolean bl;
                    String string = this.stringParameter(1);
                    boolean bl2 = bl = this.tokAt(2) == 1073742180;
                    if (!this.isSyntaxCheck) {
                        this.viewer.setPropertyColorScheme(string, bl, true);
                    }
                    int n4 = n = bl ? 3 : 2;
                    if (this.tokAt(n) == 1073742114 || this.tokAt(n) == 0x40000002) {
                        float f = this.floatParameter(++n);
                        float f2 = this.floatParameter(++n);
                        if (!this.isSyntaxCheck) {
                            this.viewer.setCurrentColorRange(f, f2);
                        }
                    }
                    return;
                }
                case 0x40000002: 
                case 1073742114: {
                    float f = this.floatParameter(2);
                    float f3 = this.floatParameter(this.checkLast(3));
                    if (!this.isSyntaxCheck) {
                        this.viewer.setCurrentColorRange(f, f3);
                    }
                    return;
                }
                case 1610616835: {
                    n2 = this.getArgbParamLast(2, true);
                    if (!this.isSyntaxCheck) {
                        this.setObjectArgb("background", n2);
                    }
                    return;
                }
                case 10: 
                case 0x100001: {
                    n = -1;
                    this.theTok = 0x44100001;
                    break;
                }
                case 1073742134: {
                    n2 = this.getArgbParamLast(2, false);
                    if (!this.isSyntaxCheck) {
                        this.viewer.setRubberbandArgb(n2);
                    }
                    return;
                }
                case 0x20000008: 
                case 1611141171: {
                    n = 2;
                    if (this.tokAt(2) == 1073742074) {
                        ++n;
                    }
                    n2 = this.getArgbParamLast(n, true);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.shapeManager.loadShape(8);
                    this.setShapeProperty(8, n3 == 1611141171 ? "argbSelection" : "argbHighlight", n2);
                    return;
                }
                case 0x40000000: 
                case 1611272194: 
                case 1613758468: 
                case 1614417984: 
                case 1679429641: {
                    String string = this.parameterAsString(1);
                    if (this.checkToken(2)) {
                        switch (this.getToken((int)2).tok) {
                            case 1073742116: {
                                n2 = 1073742116;
                                break;
                            }
                            case 0x10000B: 
                            case 1073741992: {
                                n2 = 1073741992;
                                break;
                            }
                            default: {
                                n2 = this.getArgbParam(2);
                            }
                        }
                    }
                    if (n2 == 0) {
                        this.error(9);
                    }
                    this.checkLast(this.iToken);
                    if (string.equalsIgnoreCase("axes") || StateManager.getObjectIdFromName(string) >= 0) {
                        this.setObjectArgb(string, n2);
                        return;
                    }
                    if (this.changeElementColor(string, n2)) {
                        return;
                    }
                    this.error(22);
                }
                case 135197: {
                    this.setShapeProperty(23, "thisID", "+PREVIOUS_MESH+");
                }
            }
        }
        this.colorShape(this.getShapeType(this.theTok), n, false);
    }

    private boolean changeElementColor(String string, int n) {
        int n2 = Elements.elementNumberMax;
        while (--n2 >= 0) {
            if (!string.equalsIgnoreCase(Elements.elementNameFromNumber(n2))) continue;
            if (!this.isSyntaxCheck) {
                this.viewer.setElementArgb(n2, n);
            }
            return true;
        }
        n2 = Elements.altElementMax;
        while (--n2 >= 0) {
            if (!string.equalsIgnoreCase(Elements.altElementNameFromIndex(n2))) continue;
            if (!this.isSyntaxCheck) {
                this.viewer.setElementArgb(Elements.altElementNumberFromIndex(n2), n);
            }
            return true;
        }
        if (string.charAt(0) != '_') {
            return false;
        }
        n2 = Elements.elementNumberMax;
        while (--n2 >= 0) {
            if (!string.equalsIgnoreCase("_" + Elements.elementSymbolFromNumber(n2))) continue;
            if (!this.isSyntaxCheck) {
                this.viewer.setElementArgb(n2, n);
            }
            return true;
        }
        n2 = Elements.altElementMax;
        while (--n2 >= 4) {
            if (string.equalsIgnoreCase("_" + Elements.altElementSymbolFromIndex(n2))) {
                if (!this.isSyntaxCheck) {
                    this.viewer.setElementArgb(Elements.altElementNumberFromIndex(n2), n);
                }
                return true;
            }
            if (!string.equalsIgnoreCase("_" + Elements.altIsotopeSymbolFromIndex(n2))) continue;
            if (!this.isSyntaxCheck) {
                this.viewer.setElementArgb(Elements.altElementNumberFromIndex(n2), n);
            }
            return true;
        }
        return false;
    }

    private void colorShape(int n, int n2, boolean bl) throws ScriptException {
        boolean bl2;
        String string = null;
        Number number = null;
        BitSet bitSet = null;
        String string2 = "";
        boolean bl3 = false;
        boolean bl4 = n == 23;
        int n3 = 0;
        boolean bl5 = false;
        float f = Float.MAX_VALUE;
        if (n2 < 0) {
            bitSet = this.atomExpression(-n2);
            n2 = this.iToken + 1;
            if (this.isBondSet) {
                bl5 = true;
                n = 1;
            }
        }
        if (bl) {
            this.getToken(n2);
        } else {
            bl = this.getToken((int)n2).tok == 1610616835;
            if (bl) {
                this.getToken(++n2);
            }
        }
        if (bl) {
            string2 = "bg";
        }
        if (!this.isSyntaxCheck && n == 25 && !this.mo(true)) {
            return;
        }
        boolean bl6 = bl2 = this.theTok == 1073742180;
        if (bl2 || this.theTok == 1073742074) {
            string = this.parameterAsString(n2++);
            if (bl2 && this.isFloatParameter(n2)) {
                f = this.getTranslucentLevel(n2++);
            }
        }
        int n4 = 0;
        if (n2 < this.statementLength && this.tokAt(n2) != 0x10000D && this.tokAt(n2) != 0x10000C) {
            bl3 = true;
            n4 = this.getToken((int)n2).tok;
            if (this.isColorParam(n2)) {
                int n5 = this.getArgbParam(n2, false);
                Integer n6 = number = n5 == 0 ? null : Integer.valueOf(n5);
                if (string == null && this.tokAt(n2 = this.iToken + 1) != 0) {
                    this.getToken(n2);
                    boolean bl7 = bl2 = this.theTok == 1073742180;
                    if (bl2 || this.theTok == 1073742074) {
                        string = this.parameterAsString(n2);
                        if (bl2 && this.isFloatParameter(n2 + 1)) {
                            f = this.getTranslucentLevel(++n2);
                        }
                    }
                }
            } else if (n == 24) {
                --this.iToken;
            } else {
                BitSet bitSet2;
                int n7;
                boolean bl8;
                String string3 = this.parameterAsString(n2).toLowerCase();
                boolean bl9 = string3.indexOf("byelement") == 0;
                boolean bl10 = bl8 = bl9 || string3.indexOf("byresidue") == 0;
                int n8 = bl8 || bl4 ? 84 : (n7 = n4 == 1113200651 ? 1 : (int)JmolConstants.getPaletteID(string3));
                if (n7 == -1 || (n7 == 18 || n7 == 19) && n != 2) {
                    this.error(22);
                }
                float[] fArray = null;
                BitSet bitSet3 = bitSet2 = n7 != 84 && n7 != 85 || !this.viewer.isRangeSelected() ? null : this.viewer.getSelectionSet(false);
                if (n7 == 84) {
                    if (bl8) {
                        if (!this.isSyntaxCheck) {
                            fArray = this.getBitsetPropertyFloat(bitSet2, (bl9 ? 1095763976 : 1095761930) | 0x100, Float.NaN, Float.NaN);
                        }
                    } else {
                        if (!bl8 && !bl4) {
                            ++n2;
                        }
                        if (string3.equals("property") && Token.tokAttr(n4 = this.getToken((int)n2).tok, 0x40500000) && !Token.tokAttr(n4, 0x40D00000) && !this.isSyntaxCheck) {
                            fArray = this.getBitsetPropertyFloat(bitSet2, this.getToken((int)n2++).tok | 0x100, Float.NaN, Float.NaN);
                        }
                    }
                } else if (n7 == 85) {
                    int n9 = ++n2;
                    ++n2;
                    string3 = this.parameterAsString(n9);
                    fArray = new float[this.viewer.getAtomCount()];
                    Parser.parseStringInfestedFloatArray("" + this.getParameter(string3, false), null, fArray);
                    n7 = 84;
                }
                if (n7 == 84) {
                    Object object;
                    String string4;
                    String string5 = string4 = this.tokAt(n2) == 4 ? this.parameterAsString(n2++).toLowerCase() : null;
                    if (string4 != null && !bl4) {
                        this.setStringProperty("propertyColorScheme", (bl2 && f == Float.MAX_VALUE ? "translucent " : "") + string4);
                        bl8 = string4.indexOf("byelement") == 0 || string4.indexOf("byresidue") == 0;
                    }
                    Object object2 = 0.0f;
                    Object object3 = Float.MAX_VALUE;
                    if (!(bl8 || this.tokAt(n2) != 0x40000002 && this.tokAt(n2) != 1073742114)) {
                        object2 = this.floatParameter(n2 + 1);
                        object3 = this.floatParameter(n2 + 2);
                        n2 += 3;
                        if (object2 == object3 && bl4) {
                            object = (float[])this.getShapeProperty(n, "dataRange");
                            if (object != null) {
                                object2 = object[0];
                                object3 = object[1];
                            }
                        } else if (object2 == object3) {
                            object3 = Float.MAX_VALUE;
                        }
                    }
                    if (!this.isSyntaxCheck) {
                        if (!bl4) {
                            if (fArray == null) {
                                this.viewer.setCurrentColorRange(string3);
                            } else {
                                this.viewer.setCurrentColorRange(fArray, bitSet2);
                            }
                        }
                        if (bl4) {
                            this.checkLength(n2);
                            bl3 = false;
                            object = this.viewer.getColorEncoder(string4);
                            if (object == null) {
                                return;
                            }
                            ((ColorEncoder)object).isTranslucent = bl2 && f == Float.MAX_VALUE;
                            ((ColorEncoder)object).setRange((float)object2, (float)object3, object2 > object3);
                            if (object3 == Float.MAX_VALUE) {
                                ((ColorEncoder)object).hi = object3;
                            }
                            this.setShapeProperty(n, "remapcolor", object);
                            this.showString(this.getIsosurfaceDataRange(n, ""));
                            if (f == Float.MAX_VALUE) {
                                return;
                            }
                        } else if (object3 != Float.MAX_VALUE) {
                            this.viewer.setCurrentColorRange((float)object2, (float)object3);
                        }
                    }
                } else {
                    ++n2;
                }
                this.checkLength(n2);
                number = new Byte((byte)n7);
            }
        }
        if (this.isSyntaxCheck || n < 0) {
            return;
        }
        switch (n) {
            case 4: {
                n3 = 32768;
                break;
            }
            case 2: {
                n3 = 30720;
                break;
            }
            case 3: {
                n3 = 256;
                break;
            }
            case 1: {
                n3 = 1023;
                break;
            }
            default: {
                n3 = 0;
            }
        }
        if (n3 == 0) {
            this.shapeManager.loadShape(n);
            if (n == 5) {
                this.setShapeProperty(5, "setDefaults", this.viewer.getNoneSelected());
            }
        } else {
            if (bitSet != null) {
                this.viewer.selectBonds(bitSet);
                bitSet = null;
            }
            n = 1;
            this.setShapeProperty(n, "type", n3);
        }
        if (bl3) {
            switch (n4) {
                case 1112539144: 
                case 1112539145: {
                    this.viewer.autoCalculate(n4);
                    break;
                }
                case 1112541198: {
                    if (!this.viewer.isRangeSelected()) break;
                    this.viewer.clearBfactorRange();
                    break;
                }
                case 1087373318: {
                    this.viewer.calcSelectedGroupsCount();
                    break;
                }
                case 0x400000D0: 
                case 1095761935: {
                    this.viewer.calcSelectedMonomersCount();
                    break;
                }
                case 1095761934: {
                    this.viewer.calcSelectedMoleculesCount();
                }
            }
            if (bitSet == null) {
                this.setShapeProperty(n, string2 + "color", number);
            } else {
                this.setShapeProperty(n, string2 + "color", number, bitSet);
            }
        }
        if (string != null) {
            this.setShapeTranslucency(n, string2, string, f, bitSet);
        }
        if (n3 != 0) {
            this.setShapeProperty(1, "type", 1023);
        }
        if (bl5) {
            this.viewer.selectBonds(null);
        }
    }

    private void colorShape(int n, int n2, int n3, String string, float f, BitSet bitSet) {
        if (n2 != 0) {
            n = 1;
            this.setShapeProperty(1, "type", n2);
        }
        this.setShapeProperty(n, "color", n3, bitSet);
        if (string != null) {
            this.setShapeTranslucency(n, "", string, f, bitSet);
        }
        if (n2 != 0) {
            this.setShapeProperty(1, "type", 1023);
        }
    }

    private void setShapeTranslucency(int n, String string, String string2, float f, BitSet bitSet) {
        if (f == Float.MAX_VALUE) {
            f = this.viewer.getDefaultTranslucent();
        }
        this.setShapeProperty(n, "translucentLevel", new Float(f));
        if (string == null) {
            return;
        }
        if (bitSet == null) {
            this.setShapeProperty(n, string + "translucency", string2);
        } else if (!this.isSyntaxCheck) {
            this.setShapeProperty(n, string + "translucency", string2, bitSet);
        }
    }

    private void cd() throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        String string = this.statementLength == 1 ? null : this.parameterAsString(1);
        this.showString(this.viewer.cd(string));
    }

    private void mapProperty() throws ScriptException {
        block19: {
            int n;
            Object object;
            Object[] objectArray;
            Object object2;
            String string;
            String string2;
            String string3;
            BitSet bitSet;
            BitSet bitSet2;
            int n2;
            int n3;
            int n4;
            block18: {
                block17: {
                    n4 = 0;
                    n3 = 0;
                    n2 = 0;
                    if (this.tokAt(1) != 1114638349) break block17;
                    bitSet2 = this.viewer.getSelectionSet(false);
                    bitSet = this.atomExpression(2);
                    string3 = "selected";
                    string2 = "selected";
                    break block18;
                }
                bitSet2 = this.atomExpression(1);
                if (this.tokAt(++this.iToken) != 0x100008 || !Token.tokAttr(n4 = this.tokAt(++this.iToken), 0x40500000)) break block19;
                string2 = this.parameterAsString(this.iToken);
                bitSet = this.atomExpression(++this.iToken);
                if (this.tokAt(++this.iToken) != 0x100008 || !Token.tokAttr(n3 = this.tokAt(++this.iToken), 2048)) break block19;
                string3 = this.parameterAsString(this.iToken);
            }
            n2 = this.tokAt(this.iToken + 1);
            if (Token.tokAttr(n2, 0x40500000)) {
                string = this.parameterAsString(++this.iToken);
            } else {
                n2 = 1095763969;
                string = Token.nameOf(1095763969);
            }
            this.checkLast(this.iToken);
            if (this.isSyntaxCheck) {
                return;
            }
            BitSet bitSet3 = null;
            this.showString("mapping " + string2.toUpperCase() + " for " + bitSet2.cardinality() + " atoms to " + string3.toUpperCase() + " for " + bitSet.cardinality() + " atoms using " + string.toUpperCase());
            if (Token.tokAttrOr(n4, 1095761920, 1112539136) && Token.tokAttrOr(n3, 1095761920, 1112539136) && Token.tokAttrOr(n2, 1095761920, 1112539136)) {
                object2 = this.getBitsetPropertyFloat(bitSet2, n4 | 0xE0, Float.NaN, Float.NaN);
                objectArray = this.getBitsetPropertyFloat(bitSet2, n2 | 0xE0, Float.NaN, Float.NaN);
                object = this.getBitsetPropertyFloat(bitSet, n2 | 0xE0, Float.NaN, Float.NaN);
                n = n3 == 1716520972 ? 1 : 0;
                float[] fArray = new float[n != 0 ? this.viewer.getAtomCount() : ((float[])object).length];
                bitSet3 = new BitSet();
                if (((float[])object2).length == objectArray.length) {
                    int n5;
                    Hashtable<Float, Float> hashtable = new Hashtable<Float, Float>();
                    for (n5 = 0; n5 < ((float[])object2).length; ++n5) {
                        hashtable.put(Float.valueOf(objectArray[n5]), Float.valueOf(object2[n5]));
                    }
                    n5 = -1;
                    int n6 = 0;
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        n5 = bitSet.nextSetBit(n5 + 1);
                        Float f = (Float)hashtable.get(Float.valueOf((float)object[i]));
                        if (f == null) continue;
                        bitSet3.set(n5);
                        fArray[n != 0 ? n5 : n6] = f.floatValue();
                        ++n6;
                    }
                    if (n != 0) {
                        this.viewer.setData(string3, new Object[]{string3, fArray, bitSet3}, this.viewer.getAtomCount(), 0, 0, Integer.MAX_VALUE, 0);
                    } else {
                        this.viewer.setAtomProperty(bitSet3, n3, 0, 0.0f, null, fArray, null);
                    }
                }
            }
            if (bitSet3 == null) {
                object2 = "{" + string + "=%[" + string + "]}." + string3 + " = %[" + string2 + "]";
                objectArray = (String[])this.getBitsetIdent(bitSet2, (String)object2, null, false, Integer.MAX_VALUE, false);
                object = new StringBuffer();
                for (n = 0; n < objectArray.length; ++n) {
                    if (objectArray[n].indexOf("null") >= 0) continue;
                    ((StringBuffer)object).append((String)objectArray[n]).append('\n');
                }
                if (Logger.debugging) {
                    Logger.info(((StringBuffer)object).toString());
                }
                BitSet bitSet4 = BitSetUtil.copy(this.viewer.getSelectionSubset());
                this.viewer.setSelectionSubset(bitSet);
                try {
                    this.runScript(((StringBuffer)object).toString());
                }
                catch (Exception exception) {
                    this.viewer.setSelectionSubset(bitSet4);
                    this.error(-1, "Error: " + exception.getMessage());
                }
                catch (Error error) {
                    this.viewer.setSelectionSubset(bitSet4);
                    this.error(-1, "Error: " + error.getMessage());
                }
                this.viewer.setSelectionSubset(bitSet4);
            }
            this.showString("DONE");
            return;
        }
        this.error(22);
    }

    private void data() throws ScriptException {
        String string = null;
        String string2 = null;
        boolean bl = false;
        this.iToken = this.statementLength;
        switch (this.iToken) {
            case 5: {
                string = this.parameterAsString(2);
            }
            case 2: 
            case 4: {
                string2 = this.parameterAsString(1);
                if (string2.equalsIgnoreCase("clear")) {
                    if (!this.isSyntaxCheck) {
                        this.viewer.setData(null, null, 0, 0, 0, 0, 0);
                    }
                    return;
                }
                int n = string2.indexOf("@");
                if (n >= 0) {
                    string = "" + this.getParameter(string2.substring(n + 1), false);
                    string2 = string2.substring(0, n).trim();
                    break;
                }
                if (string != null || (n = string2.indexOf(" ")) < 0) break;
                string = string2.substring(n + 1).trim();
                string2 = string2.substring(0, n).trim();
                bl = true;
                break;
            }
            default: {
                this.error(2);
            }
        }
        String string3 = string2 + " ";
        string3 = string3.substring(0, string3.indexOf(" ")).toLowerCase();
        if (string3.equals("model") || string3.equals("append")) {
            this.load();
            return;
        }
        if (this.isSyntaxCheck) {
            return;
        }
        boolean bl2 = string2.toLowerCase().indexOf("(default)") >= 0;
        this.data = new Object[3];
        if (string3.equals("element_vdw")) {
            this.data[0] = string3;
            this.data[1] = string.replace(';', '\n');
            int n = Elements.elementNumberMax;
            int[] nArray = new int[n + 1];
            for (int i = 1; i <= n; ++i) {
                nArray[i] = i;
            }
            this.data[2] = nArray;
            this.viewer.setData("element_vdw", this.data, n, 0, 0, 0, 0);
            return;
        }
        if (string3.equals("connect_atoms")) {
            this.viewer.connect(Parser.parseFloatArray2d(string));
            return;
        }
        if (string3.indexOf("data2d_") == 0) {
            this.data[0] = string2;
            this.data[1] = Parser.parseFloatArray2d(string);
            this.viewer.setData(string2, this.data, 0, 0, 0, 0, 0);
            return;
        }
        if (string3.indexOf("data3d_") == 0) {
            this.data[0] = string2;
            this.data[1] = Parser.parseFloatArray3d(string);
            this.viewer.setData(string2, this.data, 0, 0, 0, 0, 0);
            return;
        }
        String[] stringArray = Parser.getTokens(string2);
        if (!(string3.indexOf("property_") != 0 || stringArray.length == 2 && stringArray[1].equals("set"))) {
            int n;
            BitSet bitSet = this.viewer.getSelectionSet(false);
            this.data[0] = string3;
            int n2 = bl ? 0 : (Integer)this.viewer.getParameter("propertyAtomNumberField");
            int n3 = bl ? 0 : (Integer)this.viewer.getParameter("propertyAtomNumberColumnCount");
            int n4 = bl ? Integer.MIN_VALUE : (Integer)this.viewer.getParameter("propertyDataField");
            int n5 = n = bl ? 0 : (Integer)this.viewer.getParameter("propertyDataColumnCount");
            if (!bl && string2.indexOf(" ") >= 0) {
                if (stringArray.length == 3) {
                    string2 = stringArray[0];
                    n2 = Parser.parseInt(stringArray[1]);
                    n4 = Parser.parseInt(stringArray[2]);
                }
                if (stringArray.length == 5) {
                    string2 = stringArray[0];
                    n2 = Parser.parseInt(stringArray[1]);
                    n3 = Parser.parseInt(stringArray[2]);
                    n4 = Parser.parseInt(stringArray[3]);
                    n = Parser.parseInt(stringArray[4]);
                }
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            int n6 = this.viewer.getAtomCount();
            int[] nArray = null;
            BitSet bitSet2 = new BitSet(n6);
            if (n2 > 0) {
                int n7;
                nArray = new int[n6 + 2];
                for (n7 = 0; n7 <= n6; ++n7) {
                    nArray[n7] = -1;
                }
                n7 = bitSet.nextSetBit(0);
                while (n7 >= 0) {
                    int n8 = this.viewer.getAtomNumber(n7);
                    if (n8 <= n6 + 1 && n8 >= 0 && !bitSet2.get(n8)) {
                        bitSet2.set(n8);
                        nArray[n8] = n7;
                    }
                    n7 = bitSet.nextSetBit(n7 + 1);
                }
                this.data[2] = nArray;
            } else {
                this.data[2] = BitSetUtil.copy(bitSet);
            }
            this.data[1] = string;
            this.viewer.setData(string3, this.data, n6, n2, n3, n4, n);
            return;
        }
        int n = AtomCollection.getUserSettableType(string3);
        if (n >= 0) {
            this.viewer.setAtomData(n, string3, string, bl2);
            return;
        }
        this.data[0] = string2;
        this.data[1] = string;
        this.viewer.setData(string3, this.data, 0, 0, 0, 0, 0);
    }

    private void define() throws ScriptException {
        boolean bl;
        String string = ((String)this.getToken((int)1).value).toLowerCase();
        if (this.isSyntaxCheck) {
            return;
        }
        boolean bl2 = string.startsWith("site_");
        boolean bl3 = bl = string.indexOf("dynamic_") == 0;
        if (bl || bl2) {
            Token[] tokenArray = new Token[this.statementLength];
            int n = this.statementLength;
            while (--n >= 0) {
                tokenArray[n] = this.statement[n];
            }
            this.definedAtomSets.put("!" + (bl2 ? string : string.substring(8)), tokenArray);
            if (!bl2) {
                this.viewer.addStateScript(this.thisCommand, false, true);
            }
        } else {
            BitSet bitSet = this.atomExpression(2);
            this.definedAtomSets.put(string, bitSet);
            this.setStringProperty("@" + string, Escape.escape(bitSet));
        }
    }

    private void echo(int n, boolean bl) throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        String string = this.optParameterAsString(n);
        if (this.viewer.getEchoStateActive()) {
            if (bl) {
                String[] stringArray = new String[1];
                Image image = this.viewer.getFileAsImage(string, stringArray);
                if (image == null) {
                    string = stringArray[0];
                } else {
                    this.setShapeProperty(28, "text", stringArray[0]);
                    this.setShapeProperty(28, "image", image);
                    string = null;
                }
            } else if (string.startsWith("\u0001")) {
                string = string.substring(1);
                bl = true;
            }
            if (string != null) {
                this.setShapeProperty(28, "text", string);
            }
        }
        if (!bl && this.viewer.getRefreshing()) {
            this.showString(this.viewer.formatText(string));
        }
    }

    private void message() throws ScriptException {
        String string = this.parameterAsString(this.checkLast(1));
        if (this.isSyntaxCheck) {
            return;
        }
        String string2 = this.viewer.formatText(string);
        if (this.outputBuffer == null) {
            this.viewer.showMessage(string2);
        }
        if (!string2.startsWith("_")) {
            this.scriptStatusOrBuffer(string2);
        }
    }

    private void log() throws ScriptException {
        if (this.statementLength == 1) {
            this.error(2);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        String string = this.parameterExpressionString(1, 0);
        if (this.tokAt(1) == 0x10000C) {
            this.setStringProperty("logFile", "");
        } else {
            this.viewer.log(string);
        }
    }

    private void label(int n) throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        this.shapeManager.loadShape(5);
        String string = null;
        switch (this.getToken((int)n).tok) {
            case 0x10000D: {
                string = this.viewer.getStandardLabelFormat();
                break;
            }
            case 0x10000C: {
                break;
            }
            case 12294: 
            case 1610625028: {
                this.setShapeProperty(5, "display", this.theTok == 1610625028 ? Boolean.TRUE : Boolean.FALSE);
                return;
            }
            default: {
                string = this.parameterAsString(n);
            }
        }
        this.shapeManager.setLabel(string, this.viewer.getSelectionSet(false));
    }

    private void hover() throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        String string = this.parameterAsString(1);
        if (string.equalsIgnoreCase("on")) {
            string = "%U";
        } else if (string.equalsIgnoreCase("off")) {
            string = null;
        }
        this.viewer.setHoverLabel(string);
    }

    private void load() throws ScriptException {
        String string;
        String string2;
        int n;
        BitSet bitSet;
        String string3;
        int n2;
        boolean bl = !this.isSyntaxCheck || this.isCmdLine_C_Option;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n3 = this.tokAt(0) == 135270407 ? 0 : 1;
        boolean bl6 = this.viewer.getAppendNew();
        String string4 = null;
        ArrayList<Object> arrayList = null;
        int n4 = this.viewer.getModelCount() - (this.viewer.getFileName().equals("zapped") ? 1 : 0);
        StringBuffer stringBuffer = new StringBuffer("load");
        int n5 = 1;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        String string5 = null;
        String string6 = null;
        float[] fArray = null;
        String[] stringArray = null;
        String[] stringArray2 = null;
        String string7 = null;
        String string8 = "";
        int n6 = 0;
        if (this.statementLength == 1) {
            n3 = 0;
        } else {
            Object object;
            string5 = this.parameterAsString(n3);
            n2 = this.tokAt(n3);
            if (n2 == 135270407) {
                bl5 = true;
                stringBuffer.append(" data");
                object = this.stringParameter(++n3).toLowerCase();
                stringBuffer.append(" ").append(Escape.escape((String)object));
                string3 = this.parameterAsString(++n3);
                string3 = this.viewer.fixInlineString(string3, this.viewer.getInlineChar());
                hashtable.put("fileData", string3);
                hashtable.put("isData", Boolean.TRUE);
                stringBuffer.append('\n');
                stringBuffer.append(string3);
                stringBuffer.append(" end ").append(Escape.escape((String)object));
                n3 += 2;
                bl2 = ((String)object).startsWith("append");
            } else if (n2 == 0x40000000 || string5.equalsIgnoreCase("fileset")) {
                if (string5.equals("menu")) {
                    String string9 = this.parameterAsString(this.checkLast(2));
                    if (!this.isSyntaxCheck) {
                        this.viewer.setMenu(string9, true);
                    }
                    return;
                }
                ++n3;
                stringBuffer.append(" " + string5);
                bl2 = string5.equalsIgnoreCase("append");
                bl3 = string5.equalsIgnoreCase("inline");
                bl4 = string5.equalsIgnoreCase("smiles");
                int n7 = n6 = Parser.isOneOf(string5.toLowerCase(), "xyz;vxyz;vibration;temperature;occupancy;partialcharge") ? Token.getTokFromName(string5.toLowerCase()) : 0;
                if (n6 > 0) {
                    hashtable.put("atomDataOnly", Boolean.TRUE);
                    hashtable.put("modelNumber", 1);
                    if (n6 == 4166) {
                        n6 = 1146095630;
                    }
                    stringArray2 = this.viewer.getFileInfo();
                }
                if (bl2 && ((string6 = this.optParameterAsString(n3)).equalsIgnoreCase("trajectory") || string6.equalsIgnoreCase("models") || string6.equalsIgnoreCase("inline"))) {
                    string5 = string6;
                    stringBuffer.append(" " + string5);
                    ++n3;
                }
                if (n6 > 0) {
                    bl2 = true;
                }
                if (string5.equalsIgnoreCase("trajectory") || string5.equalsIgnoreCase("models")) {
                    if (string5.equalsIgnoreCase("trajectory")) {
                        hashtable.put("isTrajectory", Boolean.TRUE);
                    }
                    if (this.isPoint3f(n3)) {
                        object = this.getPoint3f(n3, false);
                        n3 = this.iToken + 1;
                        hashtable.put("firstLastStep", new int[]{(int)((Point3f)object).x, (int)((Point3f)object).y, (int)((Point3f)object).z});
                        stringBuffer.append(" " + Escape.escape((Tuple3f)object));
                    } else if (this.tokAt(n3) == 10) {
                        bitSet = (BitSet)this.getToken((int)n3++).value;
                        hashtable.put("bsModels", bitSet);
                        stringBuffer.append(" " + Escape.escape(bitSet));
                    } else if (n2 == 1073742114) {
                        fArray = this.floatParameterSet(++n3, 0, Integer.MAX_VALUE);
                        string8 = string8 + " range " + Escape.escape(fArray);
                        n3 = this.iToken + 1;
                    } else {
                        hashtable.put("firstLastStep", new int[]{0, -1, 1});
                    }
                }
            } else if (!string5.equalsIgnoreCase("inline")) {
                string5 = "fileset";
            }
            if (this.getToken((int)n3).tok != 4) {
                this.error(16);
            }
        }
        int n8 = n3;
        string3 = null;
        if (this.tokAt(n8 + 1) == 1073741848) {
            string3 = this.stringParameter(n3 += 2);
        }
        if (this.statementLength == n3 + 1) {
            if (n3 == 0 || (string6 = this.parameterAsString(n8)).length() == 0) {
                string6 = this.viewer.getFullPathName();
            }
            if (string6 == null) {
                this.zap(false);
                return;
            }
            if (string6.indexOf("[]") >= 0) {
                return;
            }
            if (string6.indexOf("[") == 0 && (stringArray = Escape.unescapeStringArray(string6)) != null) {
                if (n3 == 1) {
                    stringBuffer.append(" files");
                }
                if (stringBuffer.indexOf(" files") < 0) {
                    this.error(22);
                }
                for (n = 0; n < stringArray.length; ++n) {
                    stringBuffer.append(" /*file*/").append(Escape.escape(stringArray[n]));
                }
            }
            if (bl4) {
                string6 = "$" + string6;
            }
        } else if (this.getToken((int)(n3 + 1)).tok == 0x10000A || this.theTok == 8 || this.theTok == 2 || this.theTok == 1073742114 || this.theTok == 1073742010 || this.theTok == 0x40000100 || this.theTok == 0x40000074 && this.tokAt(n3 + 3) != 0x100006 || this.theTok == 0x40000000 && this.tokAt(n3 + 3) != 0x100006) {
            string6 = this.parameterAsString(n8);
            if (string6.length() == 0) {
                string6 = this.viewer.getFullPathName();
            }
            if (n8 == n3) {
                ++n3;
            }
            if (string6 == null) {
                this.zap(false);
                return;
            }
            if (string6.indexOf("[]") >= 0) {
                return;
            }
            n2 = this.tokAt(n3);
            if (n2 == 1073742010) {
                String string10 = this.stringParameter(++n3);
                hashtable.put("manifest", string10);
                string8 = string8 + " MANIFEST " + Escape.escape(string10);
                n2 = this.tokAt(++n3);
            }
            if (n2 == 2) {
                int n9 = this.intParameter(n3);
                string8 = string8 + " " + n9;
                if (n9 < 0) {
                    hashtable.put("vibrationNumber", -n9);
                } else {
                    hashtable.put("modelNumber", n9);
                }
                n2 = this.tokAt(++n3);
            } else if (n2 == 1073742114) {
                fArray = this.floatParameterSet(++n3, 0, Integer.MAX_VALUE);
                n3 = this.iToken + 1;
                n2 = this.tokAt(n3);
                string8 = string8 + " range " + Escape.escape(fArray);
            }
            Point3f point3f = null;
            if (n2 == 0x10000A || n2 == 8) {
                point3f = this.getPoint3f(n3, false);
                n3 = this.iToken + 1;
                n2 = this.tokAt(n3);
            }
            boolean bl7 = false;
            if (n2 == 0x40000100) {
                if (point3f == null) {
                    point3f = new Point3f(555.0f, 555.0f, -1.0f);
                }
                bl7 = true;
                ++this.iToken;
                ++n3;
            }
            if (point3f != null) {
                n3 = this.iToken + 1;
                hashtable.put("lattice", point3f);
                string8 = string8 + " {" + (int)point3f.x + " " + (int)point3f.y + " " + (int)point3f.z + "}";
                if (bl7) {
                    hashtable.put("packed", Boolean.TRUE);
                    string8 = string8 + " PACKED";
                }
                float f = 0.0f;
                if (this.tokAt(n3) == 1073742114) {
                    int n10 = ++n3;
                    ++n3;
                    f = this.floatParameter(n10);
                    string8 = string8 + " range " + f;
                }
                hashtable.put("symmetryRange", new Float(f));
                String string11 = null;
                float[] fArray2 = null;
                int n11 = Integer.MIN_VALUE;
                if (this.tokAt(n3) == 1073742152) {
                    int n12 = ++n3;
                    ++n3;
                    string11 = TextFormat.simpleReplace(this.parameterAsString(n12), "''", "\"");
                    string8 = string8 + " spacegroup " + Escape.escape(string11);
                }
                if (this.tokAt(n3) == 1614417984) {
                    if ((fArray2 = this.floatParameterSet(++n3, 6, 9)).length != 6 && fArray2.length != 9) {
                        this.error(22);
                    }
                    n3 = this.iToken;
                    string8 = string8 + " unitcell {";
                    for (int i = 0; i < 6; ++i) {
                        string8 = string8 + (i == 0 ? "" : " ") + fArray2[i];
                    }
                    string8 = string8 + "}";
                    hashtable.put("unitcell", fArray2);
                }
                if (string11 != null) {
                    if (string11.equalsIgnoreCase("ignoreOperators")) {
                        n11 = -999;
                    } else {
                        if (string11.indexOf(",") >= 0 && point3f.x < 9.0f && point3f.y < 9.0f && point3f.z == 0.0f) {
                            string11 = string11 + "#doNormalize=0";
                        }
                        n11 = -2;
                        hashtable.put("spaceGroupName", string11);
                    }
                }
                if (fArray2 != null && n11 == Integer.MIN_VALUE) {
                    n11 = -1;
                }
                if (n11 != Integer.MIN_VALUE) {
                    hashtable.put("spaceGroupIndex", n11);
                }
            }
            if (this.tokAt(n3) == 0x40000074) {
                string4 = this.stringParameter(++n3);
            }
        } else {
            if (n3 != 2) {
                string5 = this.parameterAsString(n3++);
                stringBuffer.append(" ").append(Escape.escape(string5));
            }
            Point3f point3f = null;
            BitSet bitSet2 = null;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            block9: while (n3 < this.statementLength) {
                switch (this.tokAt(n3)) {
                    case 0x40000074: {
                        string4 = this.stringParameter(++n3);
                        ++n3;
                        continue block9;
                    }
                    case 0x100006: {
                        hashtable.remove("isTrajectory");
                        if (arrayList == null) {
                            arrayList = new ArrayList<Object>();
                            point3f = new Point3f(0.0f, -1.0f, 1.0f);
                        }
                        if (this.isPoint3f(++n3)) {
                            point3f = this.getPoint3f(n3, false);
                            n3 = this.iToken + 1;
                            break;
                        }
                        if (this.tokAt(n3) != 10) break;
                        bitSet2 = (BitSet)this.getToken((int)n3).value;
                        point3f = null;
                        n3 = this.iToken + 1;
                        break;
                    }
                    case 0x40000000: {
                        this.error(22);
                    }
                }
                string6 = this.parameterAsString(n3++);
                arrayList2.add(string6);
                if (point3f != null) {
                    arrayList.add(new int[]{(int)point3f.x, (int)point3f.y, (int)point3f.z});
                    stringBuffer.append(" COORD " + Escape.escape(point3f));
                } else if (bitSet2 != null) {
                    arrayList.add(bitSet2);
                    stringBuffer.append(" COORD " + Escape.escape(bitSet2));
                }
                stringBuffer.append(" /*file*/$FILENAME" + arrayList2.size() + "$");
            }
            if (arrayList != null) {
                hashtable.put("firstLastSteps", arrayList);
            }
            n5 = arrayList2.size();
            stringArray = new String[n5];
            for (int i = 0; i < n5; ++i) {
                stringArray[i] = (String)arrayList2.get(i);
            }
            string6 = string5;
        }
        if (!bl) {
            return;
        }
        if (fArray != null) {
            bitSet = new BitSet();
            for (n = 0; n < fArray.length; ++n) {
                if (!(fArray[n] >= 1.0f)) continue;
                bitSet.set((int)fArray[n] - 1);
            }
            hashtable.put("bsModels", bitSet);
        }
        if (string4 == null) {
            string4 = this.viewer.getDefaultLoadFilter();
        }
        if (string4.length() > 0) {
            hashtable.put("filter", string4);
            if (string4.equalsIgnoreCase("2d")) {
                string4 = "2D-noMin";
            }
            string8 = string8 + " FILTER " + Escape.escape(string4);
        }
        if (stringArray == null) {
            if (string6.startsWith("@") && string6.length() > 1) {
                String string12 = this.getStringParameter(string6.substring(1), false);
                hashtable.put("fileData", string12);
                stringBuffer = new StringBuffer("{\nvar " + string6.substring(1) + " = " + Escape.escape(string12) + ";\n  " + stringBuffer + "\n}\n");
            } else if (bl3) {
                hashtable.put("fileData", string6);
            }
        }
        OutputStream outputStream = null;
        if (string3 != null) {
            String[] stringArray3;
            if (string3.equals(".")) {
                string3 = this.viewer.getFilePath(string6, true);
            }
            if (string3.length() == 0 || this.viewer.getFilePath(string3, false).equalsIgnoreCase(this.viewer.getFilePath(string6, false))) {
                this.error(22);
            }
            if ((outputStream = this.viewer.getOutputStream(string3, stringArray3 = new String[]{string3})) == null) {
                Logger.error("Could not create output stream for " + stringArray3[0]);
            } else {
                hashtable.put("OutputStream", outputStream);
            }
        }
        if (stringArray == null && n6 == 0) {
            stringBuffer.append(" ");
            if (string6.startsWith("@") || bl3) {
                stringBuffer.append(Escape.escape(string6));
            } else if (!bl5) {
                if (!string6.equals("string") && !string6.equals("string[]")) {
                    stringBuffer.append("/*file*/");
                }
                if (string3 != null) {
                    string3 = this.viewer.getFilePath(string3, false);
                }
                stringBuffer.append(Escape.escape(string3 != null ? string3 : "$FILENAME$"));
            }
            stringBuffer.append(string8);
            hashtable.put("loadScript", stringBuffer);
        }
        this.setCursorWait(true);
        string7 = this.viewer.loadModelFromFile(null, string6, stringArray, null, bl2, hashtable, stringBuffer, n6);
        if (outputStream != null) {
            try {
                this.viewer.setFileInfo(new String[]{string3, string3, string3});
                Logger.info(GT._("file {0} created", string3));
                this.showString(this.viewer.getFilePath(string3, false) + " created");
                outputStream.close();
            }
            catch (IOException iOException) {
                Logger.error("error closing file " + iOException.getMessage());
            }
        }
        if (n6 > 0) {
            this.viewer.setFileInfo(stringArray2);
            if (string7 != null && !this.isCmdLine_c_or_C_Option) {
                this.evalError(string7, null);
            }
            return;
        }
        if (string7 != null && !this.isCmdLine_c_or_C_Option) {
            if (this.statementLength == 2) {
                String string13;
                if (string7.indexOf("NOTE: file recognized as a script file:") == 0) {
                    string6 = string7.substring(string7.indexOf("file:") + 5).trim();
                    this.script(0, string6, false);
                    return;
                }
                String string14 = string13 = string7.indexOf("java.io.FileNotFound") >= 0 ? null : SurfaceFileTyper.determineSurfaceFileType(this.viewer.getBufferedInputStream(string6));
                if (string13 != null) {
                    this.runScript("isosurface " + Escape.escape(string6));
                    return;
                }
            }
            this.evalError(string7, null);
        }
        if (bl2 && (bl6 || n5 > 1)) {
            this.viewer.setAnimationRange(-1, -1);
            this.viewer.setCurrentModelIndex(n4);
        }
        if (this.logMessages) {
            this.scriptStatusOrBuffer("Successfully loaded:" + (stringArray == null ? hashtable.get("fullPathName") : string5));
        }
        String string15 = this.viewer.getDefaultLoadScript();
        String string16 = "";
        if (string15.length() > 0) {
            string16 = string16 + "\nUsing defaultLoadScript: " + string15;
        }
        if (this.viewer.getAllowEmbeddedScripts() && (string2 = (String)this.viewer.getModelSetAuxiliaryInfo().remove("jmolscript")) != null && string2.length() > 0) {
            string16 = string16 + "\nAdding embedded #jmolscript: " + string2;
            string15 = string15 + ";" + string2;
            this.setStringProperty("_loadScript", string15);
            string15 = "allowEmbeddedScripts = false;try{" + string15 + "} allowEmbeddedScripts = true;";
        }
        if (string16.length() > 0) {
            Logger.info(string16);
        }
        if ((string = (String)this.viewer.getModelSetAuxiliaryInfo().remove("sitescript")) != null) {
            string15 = string + ";" + string15;
        }
        if (string15.length() > 0 && !this.isCmdLine_c_or_C_Option) {
            this.runScript(string15);
        }
    }

    private String getFullPathName() throws ScriptException {
        String string;
        String string2 = string = !this.isSyntaxCheck || this.isCmdLine_C_Option ? this.viewer.getFullPathName() : "test.xyz";
        if (string == null) {
            this.error(22);
        }
        return string;
    }

    private void measure() throws ScriptException {
        if (this.tokAt(1) == 135267335) {
            String string = this.stringParameter(this.statementLength == 3 ? 2 : 4);
            if (this.isSyntaxCheck) {
                return;
            }
            JmolNode[] jmolNodeArray = this.viewer.getModelSet().atoms;
            int n = this.viewer.getAtomCount();
            int[][] nArray = this.viewer.getSmilesMatcher().getCorrelationMaps(string, jmolNodeArray, n, this.viewer.getSelectionSet(false), true, false);
            if (nArray == null) {
                return;
            }
            this.setShapeProperty(6, "maps", nArray);
            return;
        }
        switch (this.statementLength) {
            case 1: 
            case 2: {
                switch (this.getToken((int)1).tok) {
                    case 0: 
                    case 0x10000D: {
                        this.setShapeProperty(6, "hideAll", Boolean.FALSE);
                        return;
                    }
                    case 0x10000C: {
                        this.setShapeProperty(6, "hideAll", Boolean.TRUE);
                        return;
                    }
                    case 12291: {
                        if (!this.isSyntaxCheck) {
                            this.viewer.clearAllMeasurements();
                        }
                        return;
                    }
                    case 4: {
                        this.setShapeProperty(6, "setFormats", this.stringParameter(1));
                        return;
                    }
                }
                this.error(24, "ON, OFF, DELETE");
                break;
            }
            case 3: {
                switch (this.getToken((int)1).tok) {
                    case 12291: {
                        if (this.getToken((int)2).tok == 0x100003) {
                            if (!this.isSyntaxCheck) {
                                this.viewer.clearAllMeasurements();
                            }
                        } else {
                            int n = this.intParameter(2) - 1;
                            if (!this.isSyntaxCheck) {
                                this.viewer.deleteMeasurement(n);
                            }
                        }
                        return;
                    }
                }
            }
        }
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int[] nArray = new int[5];
        float[] fArray = new float[]{Float.MAX_VALUE, Float.MAX_VALUE};
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        int n6 = 269484114;
        String string = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        BitSet bitSet = new BitSet();
        Serializable serializable = null;
        TickInfo tickInfo = null;
        block33: for (int i = 1; i < this.statementLength; ++i) {
            switch (this.getToken((int)i).tok) {
                case 0x40000000: {
                    this.error(24, "ALL, ALLCONNECTED, DELETE");
                }
                default: {
                    this.error(15);
                }
                case 0x10100070: {
                    if (this.tokAt(i + 1) != 135266310) {
                        this.error(22);
                    }
                    ++i;
                    bl3 = true;
                    continue block33;
                }
                case 0x100003: 
                case 135266310: 
                case 0x4000000A: {
                    bl2 = this.theTok == 0x4000000A;
                    n4 = -1;
                    bl = true;
                    if (!bl2 || !bl3) continue block33;
                    this.error(22);
                    continue block33;
                }
                case 3: {
                    bl = true;
                    bl4 = true;
                    n5 = (n5 + 1) % 2;
                    fArray[n5] = this.floatParameter(i);
                    continue block33;
                }
                case 12291: {
                    if (n6 != 269484114) {
                        this.error(22);
                    }
                    n6 = 12291;
                    continue block33;
                }
                case 2: {
                    int n7 = this.intParameter(i);
                    if (bl) {
                        bl4 = true;
                        n5 = (n5 + 1) % 2;
                        fArray[n5] = n7;
                        continue block33;
                    }
                    n4 = this.viewer.getAtomIndexFromAtomNumber(n7);
                    if (!this.isSyntaxCheck && n4 < 0) {
                        return;
                    }
                    if (serializable != null) {
                        this.error(22);
                    }
                    if ((nArray[0] = ++n) > 4) {
                        this.error(2);
                    }
                    nArray[n] = n4;
                    continue block33;
                }
                case 1095761933: {
                    n3 = this.intParameter(++i);
                    continue block33;
                }
                case 0x10000C: {
                    if (n6 != 269484114) {
                        this.error(22);
                    }
                    n6 = 0x10000C;
                    continue block33;
                }
                case 0x10000D: {
                    if (n6 != 269484114) {
                        this.error(22);
                    }
                    n6 = 0x10000D;
                    continue block33;
                }
                case 1073742114: {
                    bl = true;
                    bl4 = true;
                    n4 = -1;
                    continue block33;
                }
                case 4: {
                    string = this.stringParameter(i);
                    continue block33;
                }
                case 1073742164: {
                    tickInfo = this.checkTicks(i, false, true, true);
                    i = this.iToken;
                    n6 = 1060866;
                    continue block33;
                }
                case 8: 
                case 10: 
                case 0x100001: 
                case 0x100007: 
                case 0x10000A: {
                    if (n4 >= 0) {
                        this.error(22);
                    }
                    this.expressionResult = Boolean.FALSE;
                    serializable = this.centerParameter(i);
                    if (this.expressionResult instanceof BitSet) {
                        bitSet = (BitSet)this.expressionResult;
                        serializable = bitSet;
                        if (!this.isSyntaxCheck && bitSet.length() == 0) {
                            return;
                        }
                    }
                    if (serializable instanceof Point3f) {
                        Point3fi point3fi = new Point3fi();
                        point3fi.set((Tuple3f)serializable);
                        point3fi.modelIndex = (short)n3;
                        serializable = point3fi;
                    }
                    if ((n = ++n2) > 4) {
                        this.error(2);
                    }
                    arrayList.add(serializable);
                    i = this.iToken;
                }
            }
        }
        if (n < 2 && (tickInfo == null || n == 1)) {
            this.error(2);
        }
        if (string != null && string.indexOf(n + ":") != 0) {
            string = n + ":" + string;
        }
        if (bl4 && fArray[1] < fArray[0]) {
            fArray[1] = fArray[0];
            float f = fArray[0] = fArray[1] == Float.MAX_VALUE ? Float.MAX_VALUE : -200.0f;
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (serializable != null || tickInfo != null) {
            if (serializable == null) {
                tickInfo.id = "default";
            }
            this.setShapeProperty(6, "measure", new MeasurementData(arrayList, n6, fArray, string, null, tickInfo, bl2, bl3, bl));
            return;
        }
        switch (n6) {
            case 12291: {
                this.setShapeProperty(6, "delete", nArray);
                break;
            }
            case 0x10000D: {
                this.setShapeProperty(6, "show", nArray);
                break;
            }
            case 0x10000C: {
                this.setShapeProperty(6, "hide", nArray);
            }
            default: {
                this.setShapeProperty(6, string == null ? "toggle" : "toggleOn", nArray);
                if (string == null) break;
                this.setShapeProperty(6, "setFormats", string);
            }
        }
    }

    private String plot(Token[] tokenArray) throws ScriptException {
        String string;
        Object object;
        int n;
        int n2 = this.viewer.getCurrentModelIndex();
        if (n2 < 0) {
            this.error(30, "plot");
        }
        n2 = this.viewer.getJmolDataSourceFrame(n2);
        int n3 = tokenArray.length - 1;
        boolean bl = tokenArray != this.statement;
        Token[] tokenArray2 = this.statement;
        if (bl) {
            this.statement = tokenArray;
        }
        int n4 = bl ? 4148 : tokenArray[0].tok;
        int n5 = bl || n4 == 0x8101011 || n4 == 1052714 ? 0 : 1;
        String string2 = null;
        boolean bl2 = true;
        boolean bl3 = false;
        switch (n4) {
            case 4133: 
            case 1052714: 
            case 0x8101011: {
                break;
            }
            case 135184: {
                bl2 = false;
                bl3 = true;
                break;
            }
            case 4148: {
                bl2 = false;
                break;
            }
            case 135270419: {
                bl2 = false;
                if (this.tokAt(n3, tokenArray) == 4) {
                    string2 = this.stringParameter(n3--);
                    break;
                }
                if (this.tokAt(n3 - 1, tokenArray) == 0x100008) {
                    string2 = this.parameterAsString(n3 - 2) + "." + this.parameterAsString(n3);
                    n3 -= 3;
                    break;
                }
                this.statement = tokenArray2;
                this.iToken = this.statement.length;
                this.error(13);
            }
        }
        String string3 = "";
        Object[] objectArray = null;
        String string4 = "";
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        BitSet bitSet = BitSetUtil.copy(this.viewer.getSelectionSet(false));
        String string5 = "; select " + Escape.escape(bitSet) + ";\n ";
        String string6 = this.optParameterAsString(n3).toLowerCase();
        Point3f point3f = null;
        Point3f point3f2 = null;
        int n9 = 0;
        int n10 = this.tokAt(n5, tokenArray);
        if (n10 == 4) {
            n10 = Token.getTokFromName((String)tokenArray[n5].value);
        }
        switch (n10) {
            case 0x8101011: 
            case 137363467: {
                n9 = 1;
                break;
            }
            case 1052714: {
                n9 = 0;
                break;
            }
            case 1716520972: {
                n9 = -1;
                this.iToken = n5 + 1;
                break;
            }
            default: {
                this.iToken = 1;
                this.error(22);
            }
        }
        switch (n9) {
            case -1: {
                n6 = this.tokAt(this.iToken++);
                if (!Token.tokAttr(n6, 0x40500000) || !Token.tokAttr(n7 = this.tokAt(this.iToken++), 0x40500000)) {
                    this.error(22);
                }
                if (Token.tokAttr(n8 = this.tokAt(this.iToken), 0x40500000)) {
                    ++this.iToken;
                } else {
                    n8 = 0;
                }
                if (this.tokAt(this.iToken) == 32) {
                    point3f = this.getPoint3f(++this.iToken, false);
                    ++this.iToken;
                }
                if (this.tokAt(this.iToken) == 64) {
                    point3f2 = this.getPoint3f(++this.iToken, false);
                    ++this.iToken;
                }
                string6 = "property " + Token.nameOf(n6) + " " + Token.nameOf(n7) + (n8 == 0 ? "" : " " + Token.nameOf(n8));
                if (bitSet.nextSetBit(0) < 0) {
                    bitSet = this.viewer.getModelUndeletedAtomsBitSet(n2);
                }
                string4 = "select " + Escape.escape(bitSet) + ";\n ";
                break;
            }
            case 0: {
                if (string6.equalsIgnoreCase("draw")) {
                    bl3 = true;
                    string6 = this.optParameterAsString(--n3).toLowerCase();
                }
                bl7 = n3 > n5 && string6.startsWith("r");
                string6 = "ramachandran" + (bl7 ? " r" : "") + (n4 == 135184 ? " draw" : "");
                break;
            }
            case 1: {
                string3 = " \"" + this.viewer.getQuaternionFrame() + "\"";
                string4 = "set quaternionFrame" + string3 + ";\n  ";
                bl4 = true;
                if (string6.equalsIgnoreCase("draw")) {
                    bl3 = true;
                    string6 = this.optParameterAsString(--n3).toLowerCase();
                }
                bl5 = string6.startsWith("deriv") || string6.startsWith("diff");
                boolean bl8 = bl6 = bl5 && string6.indexOf("2") > 0;
                if (bl5) {
                    --n3;
                }
                if (string6.equalsIgnoreCase("helix") || string6.equalsIgnoreCase("axis")) {
                    bl3 = true;
                    bl5 = true;
                    n3 = -1;
                }
                if ((string6 = ((n3 <= n5 ? "" : this.optParameterAsString(n3)) + "w").substring(0, 1)).equals("a") || string6.equals("r")) {
                    bl5 = true;
                }
                if (!Parser.isOneOf(string6, "w;x;y;z;r;a")) {
                    this.evalError("QUATERNION [w,x,y,z,a,r] [difference][2]", null);
                }
                string6 = "quaternion " + string6 + (bl5 ? " difference" : "") + (bl6 ? "2" : "") + (bl3 ? " draw" : "");
            }
        }
        this.statement = tokenArray2;
        if (this.isSyntaxCheck) {
            return "";
        }
        if (bl2 && (n = this.viewer.getJmolDataFrameIndex(n2, string4 = string4 + "plot " + string6)) > 0 && n4 != 135270419 && n4 != 4148) {
            this.viewer.setCurrentModelIndex(n, true);
            return "";
        }
        float[] fArray = null;
        float[] fArray2 = null;
        float[] fArray3 = null;
        Point3f point3f3 = new Point3f(1.0f, 1.0f, 1.0f);
        if (n9 == -1) {
            int n11;
            fArray = this.getBitsetPropertyFloat(bitSet, n6 | 0xE0, point3f == null ? Float.NaN : point3f.x, point3f2 == null ? Float.NaN : point3f2.x);
            fArray2 = this.getBitsetPropertyFloat(bitSet, n7 | 0xE0, point3f == null ? Float.NaN : point3f.y, point3f2 == null ? Float.NaN : point3f2.y);
            if (n8 != 0) {
                fArray3 = this.getBitsetPropertyFloat(bitSet, n8 | 0xE0, point3f == null ? Float.NaN : point3f.z, point3f2 == null ? Float.NaN : point3f2.z);
            }
            if (point3f == null) {
                point3f = new Point3f(ScriptEvaluator.getMinMax(fArray, false, n6), ScriptEvaluator.getMinMax(fArray2, false, n7), ScriptEvaluator.getMinMax(fArray3, false, n8));
            }
            if (point3f2 == null) {
                point3f2 = new Point3f(ScriptEvaluator.getMinMax(fArray, true, n6), ScriptEvaluator.getMinMax(fArray2, true, n7), ScriptEvaluator.getMinMax(fArray3, true, n8));
            }
            Logger.info("plot min/max: " + point3f + " " + point3f2);
            object = new Point3f(point3f2);
            ((Tuple3f)object).add(point3f);
            ((Tuple3f)object).scale(0.5f);
            point3f3.set(point3f2);
            point3f3.sub(point3f);
            point3f3.set(point3f3.x / 200.0f, point3f3.y / 200.0f, point3f3.z / 200.0f);
            if (Token.tokAttr(n6, 1095761920)) {
                point3f3.x = 1.0f;
                ((Point3f)object).x = 0.0f;
            } else if ((double)point3f3.x > 0.1 && point3f3.x <= 10.0f) {
                point3f3.x = 1.0f;
            }
            if (Token.tokAttr(n7, 1095761920)) {
                point3f3.y = 1.0f;
                ((Point3f)object).y = 0.0f;
            } else if ((double)point3f3.y > 0.1 && point3f3.y <= 10.0f) {
                point3f3.y = 1.0f;
            }
            if (Token.tokAttr(n8, 1095761920)) {
                point3f3.z = 1.0f;
                ((Point3f)object).z = 0.0f;
            } else if ((double)point3f3.z > 0.1 && point3f3.z <= 10.0f) {
                point3f3.z = 1.0f;
            }
            if (n8 == 0) {
                point3f3.z = 0.0f;
                point3f2.z = 0.0f;
                point3f.z = 0.0f;
                ((Point3f)object).z = 0.0f;
            }
            for (n11 = 0; n11 < fArray.length; ++n11) {
                fArray[n11] = (fArray[n11] - ((Point3f)object).x) / point3f3.x;
            }
            for (n11 = 0; n11 < fArray2.length; ++n11) {
                fArray2[n11] = (fArray2[n11] - ((Point3f)object).y) / point3f3.y;
            }
            if (n8 != 0) {
                for (n11 = 0; n11 < fArray3.length; ++n11) {
                    fArray3[n11] = (fArray3[n11] - ((Point3f)object).z) / point3f3.z;
                }
            }
            objectArray = new Object[]{bitSet, fArray, fArray2, fArray3, point3f, point3f2, point3f3, object};
        }
        if (n4 == 135270419) {
            return this.viewer.streamFileData(string2, "PLOT", string6, n2, objectArray);
        }
        object = this.viewer.getPdbData(n2, string6, objectArray);
        if (n4 == 4148) {
            return object;
        }
        if (Logger.debugging) {
            Logger.info((String)object);
        }
        if (n4 == 135184) {
            this.runScript((String)object);
            return "";
        }
        String[] stringArray = this.viewer.getFileInfo();
        boolean bl9 = this.viewer.getAppendNew();
        this.viewer.setAppendNew(true);
        boolean bl10 = object != null && this.viewer.loadInline((String)object, true) == null;
        this.viewer.setAppendNew(bl9);
        this.viewer.setFileInfo(stringArray);
        if (!bl10) {
            return "";
        }
        int n12 = this.viewer.getModelCount();
        this.viewer.setJmolDataFrame(string4, n2, n12 - 1);
        if (n9 != -1) {
            string4 = string4 + ";\n" + string5;
        }
        ModelCollection.StateScript stateScript = this.viewer.addStateScript(string4, true, false);
        switch (n9) {
            case -1: {
                this.viewer.setFrameTitle(n12 - 1, string6 + " plot for model " + this.viewer.getModelNumberDotted(n2));
                float f = 3.0f;
                string = "frame 0.0; frame last; reset;select visible; spacefill " + f + "; wireframe 0;" + "draw plotAxisX" + n12 + " {100 -100 -100} {-100 -100 -100} \"" + Token.nameOf(n6) + "\";" + "draw plotAxisY" + n12 + " {-100 100 -100} {-100 -100 -100} \"" + Token.nameOf(n7) + "\";";
                if (n8 == 0) break;
                string = string + "draw plotAxisZ" + n12 + " {-100 -100 100} {-100 -100 -100} \"" + Token.nameOf(n8) + "\";";
                break;
            }
            default: {
                this.viewer.setFrameTitle(n12 - 1, "ramachandran plot for model " + this.viewer.getModelNumberDotted(n2));
                string = "frame 0.0; frame last; reset;select visible; color structure; spacefill 3.0; wireframe 0;draw ramaAxisX" + n12 + " {100 0 0} {-100 0 0} \"phi\";" + "draw ramaAxisY" + n12 + " {0 100 0} {0 -100 0} \"psi\";";
                break;
            }
            case 1: {
                this.viewer.setFrameTitle(n12 - 1, string6.replace('w', ' ') + string3 + " for model " + this.viewer.getModelNumberDotted(n2));
                String string7 = Graphics3D.getHexCode(this.viewer.getColixBackgroundContrast());
                string = "frame 0.0; frame last; reset;select visible; wireframe 0; spacefill 3.0; isosurface quatSphere" + n12 + " color " + string7 + " sphere 100.0 mesh nofill frontonly translucent 0.8;" + "draw quatAxis" + n12 + "X {100 0 0} {-100 0 0} color red \"x\";" + "draw quatAxis" + n12 + "Y {0 100 0} {0 -100 0} color green \"y\";" + "draw quatAxis" + n12 + "Z {0 0 100} {0 0 -100} color blue \"z\";" + "color structure;" + "draw quatCenter" + n12 + "{0 0 0} scale 0.02;";
            }
        }
        this.runScript(string + string5);
        stateScript.setModelIndex(this.viewer.getCurrentModelIndex());
        this.viewer.setRotationRadius(150.0f, true);
        this.shapeManager.loadShape(28);
        this.showString("frame " + this.viewer.getModelNumberDotted(n12 - 1) + " created: " + string6 + (bl4 ? string3 : ""));
        return "";
    }

    private static float getMinMax(float[] fArray, boolean bl, int n) {
        if (fArray == null) {
            return 0.0f;
        }
        switch (n) {
            case 1112539141: 
            case 1112539142: 
            case 1112539143: {
                return bl ? 180 : -180;
            }
            case 1112539140: 
            case 1112539146: {
                return bl ? 360 : 0;
            }
            case 1112539144: {
                return bl ? 1 : -1;
            }
        }
        float f = bl ? -1.0E10f : 1.0E10f;
        int n2 = fArray.length;
        while (--n2 >= 0) {
            float f2 = fArray[n2];
            if (Float.isNaN(f2) || bl != f2 > f) continue;
            f = f2;
        }
        return f;
    }

    private boolean pause() throws ScriptException {
        if (this.isSyntaxCheck) {
            return false;
        }
        String string = this.optParameterAsString(1);
        if (!this.viewer.getBooleanProperty("_useCommandThread")) {
            // empty if block
        }
        if (this.viewer.autoExit || !this.viewer.haveDisplay) {
            return false;
        }
        if (this.scriptLevel == 0 && this.pc == this.aatoken.length - 1) {
            this.viewer.scriptStatus("nothing to pause: " + string);
            return false;
        }
        string = string.length() == 0 ? ": RESUME to continue." : ": " + this.viewer.formatText(string);
        this.pauseExecution(true);
        this.viewer.scriptStatus("script execution paused" + string, "script paused for RESUME");
        return true;
    }

    private void print() throws ScriptException {
        if (this.statementLength == 1) {
            this.error(2);
        }
        this.showString(this.parameterExpressionString(1, 0), true);
    }

    private void prompt() throws ScriptException {
        String string = null;
        if (this.statementLength == 1) {
            if (!this.isSyntaxCheck) {
                string = this.getScriptContext().getContextTrace(null, true).toString();
            }
        } else {
            string = this.parameterExpressionString(1, 0);
        }
        if (!this.isSyntaxCheck) {
            this.viewer.prompt(string, "OK", null, true);
        }
    }

    private void refresh() {
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.setTainted(true);
        this.viewer.requestRepaintAndWait();
    }

    private void reset() throws ScriptException {
        this.checkLength(-2);
        if (this.isSyntaxCheck) {
            return;
        }
        if (this.statementLength == 1) {
            this.viewer.reset(false);
            return;
        }
        switch (this.tokAt(1)) {
            case 0x40000070: {
                this.viewer.resetError();
                return;
            }
            case 135368713: {
                this.viewer.clearFunctions();
                return;
            }
            case 1112541199: {
                this.viewer.setData("element_vdw", new Object[]{null, ""}, 0, 0, 0, 0, 0);
                return;
            }
            case 1076887572: {
                this.viewer.resetAromatic();
                return;
            }
            case 1611141175: {
                this.viewer.reset(true);
                return;
            }
        }
        String string = this.parameterAsString(1);
        if (string.charAt(0) == '_') {
            this.error(22);
        }
        this.viewer.unsetProperty(string);
    }

    private void restrict() throws ScriptException {
        boolean bl = this.tokAt(1) == 1678770178;
        this.select(bl ? 2 : 1);
        if (this.isSyntaxCheck) {
            return;
        }
        this.restrictSelected(bl, true);
    }

    private void restrictSelected(boolean bl, boolean bl2) {
        BitSet bitSet = BitSetUtil.copy(this.viewer.getSelectionSet(true));
        if (bl2) {
            this.viewer.invertSelection();
            BitSet bitSet2 = this.viewer.getSelectionSubset();
            if (bitSet2 != null) {
                bitSet = BitSetUtil.copy(this.viewer.getSelectionSet(true));
                bitSet.and(bitSet2);
                this.viewer.setSelectionSet(bitSet);
                BitSetUtil.invertInPlace(bitSet, this.viewer.getAtomCount());
                bitSet.and(bitSet2);
            }
        }
        BitSetUtil.andNot(bitSet, this.viewer.getDeletedAtoms());
        boolean bl3 = this.viewer.getBondSelectionModeOr();
        if (!bl) {
            this.setBooleanProperty("bondModeOr", true);
        }
        this.setShapeSize(1, 0, null);
        this.setShapeProperty(1, "type", 32768);
        this.setShapeSize(1, 0, null);
        this.setShapeProperty(1, "type", 1023);
        int n = 21;
        while (--n >= 0) {
            if (n == 6) continue;
            this.setShapeSize(n, 0, null);
        }
        this.setShapeProperty(21, "delete", null);
        this.shapeManager.setLabel(null, this.viewer.getSelectionSet(true));
        if (!bl) {
            this.setBooleanProperty("bondModeOr", bl3);
        }
        this.viewer.setSelectionSet(bitSet);
    }

    private void rotate(boolean bl, boolean bl2) throws ScriptException {
        float f;
        Object[] objectArray;
        if (this.statementLength == 2) {
            switch (this.getToken((int)1).tok) {
                case 0x10000D: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.setSpinOn(true);
                    }
                    return;
                }
                case 0x10000C: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.setSpinOn(false);
                    }
                    return;
                }
            }
        }
        BitSet bitSet = null;
        float f2 = Float.MIN_VALUE;
        int n = 0;
        float f3 = Float.MAX_VALUE;
        boolean bl3 = false;
        boolean bl4 = false;
        List<Point3f> list = null;
        Point3f[] point3fArray = new Point3f[2];
        Vector3f vector3f = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f vector3f2 = null;
        Matrix4f matrix4f = null;
        Matrix3f matrix3f = null;
        int n2 = 1;
        Quaternion quaternion = null;
        boolean bl5 = false;
        List<Point3f> list2 = null;
        BitSet bitSet2 = null;
        Point3f point3f = null;
        Point4f point4f = null;
        boolean bl6 = this.viewer.getAxesOrientationRasmol();
        block23: for (int i = 1; i < this.statementLength; ++i) {
            int n3 = this.getToken((int)i).tok;
            switch (n3) {
                case 8: 
                case 10: 
                case 0x100001: 
                case 0x100007: 
                case 0x10000A: {
                    if (!(n3 != 10 && n3 != 0x100001 || vector3f2 == null && quaternion == null && n != 2)) {
                        bitSet = this.atomExpression(i);
                        list2 = null;
                        bl2 = true;
                        break;
                    }
                    bl4 = true;
                    if (n == 2) {
                        n = 0;
                    }
                    objectArray = this.centerParameter(i, this.viewer.getCurrentModelIndex());
                    if (!this.isSyntaxCheck && n3 == 0x100007 && this.tokAt(i + 2) != 0x10100040) {
                        bl3 = true;
                        vector3f = this.getDrawObjectAxis(this.objectNameParameter(++i), this.viewer.getCurrentModelIndex());
                    }
                    point3fArray[n++] = objectArray;
                    break;
                }
                case 1611141175: {
                    bl = true;
                    continue block23;
                }
                case 0x400000A4: 
                case 1073742030: {
                    bl3 = true;
                    continue block23;
                }
                case 1114638349: {
                    bl2 = true;
                    break;
                }
                case 0x10100030: {
                    continue block23;
                }
                case 2: 
                case 3: {
                    if (f3 == Float.MAX_VALUE) {
                        f3 = this.floatParameter(i);
                        continue block23;
                    }
                    f2 = this.floatParameter(i);
                    bl = f2 != 0.0f;
                    continue block23;
                }
                case 0x101000A0: {
                    n2 = -1;
                    continue block23;
                }
                case 1112541203: {
                    bl4 = true;
                    vector3f.set(n2, 0.0f, 0.0f);
                    continue block23;
                }
                case 1112541204: {
                    bl4 = true;
                    vector3f.set(0.0f, bl6 && !bl3 ? -n2 : n2, 0.0f);
                    continue block23;
                }
                case 1112541205: {
                    bl4 = true;
                    vector3f.set(0.0f, 0.0f, n2);
                    continue block23;
                }
                case 9: 
                case 0x8101011: {
                    String[] stringArray;
                    if (n3 == 0x8101011) {
                        ++i;
                    }
                    bl4 = true;
                    if (this.tokAt(i) == 7) {
                        Object object;
                        stringArray = (String[])this.getToken((int)i).value;
                        if (stringArray.length == 0) {
                            this.error(22);
                        }
                        if (!((object = Escape.unescapePoint(stringArray[0])) instanceof Point4f)) {
                            this.error(22);
                        }
                        quaternion = new Quaternion((Point4f)object);
                    } else {
                        quaternion = new Quaternion(this.getPoint4f(i));
                    }
                    vector3f.set(quaternion.getNormal());
                    f3 = quaternion.getTheta();
                    break;
                }
                case 135266307: {
                    bl4 = true;
                    if (this.isPoint3f(++i)) {
                        vector3f.set(this.centerParameter(i));
                        break;
                    }
                    String[] stringArray = this.getPoint4f(i);
                    vector3f.set(stringArray.x, stringArray.y, stringArray.z);
                    f3 = stringArray.w;
                    quaternion = new Quaternion(vector3f, f3);
                    break;
                }
                case 0x100004: {
                    bl4 = true;
                    int n4 = this.atomExpression(++i).nextSetBit(0);
                    int n5 = this.atomExpression(++this.iToken).nextSetBit(0);
                    if (n4 < 0 || n5 < 0) {
                        return;
                    }
                    bitSet = this.viewer.getBranchBitSet(n5, n4);
                    bl2 = true;
                    bl3 = true;
                    point3fArray[0] = this.viewer.getAtomPoint3f(n4);
                    point3fArray[1] = this.viewer.getAtomPoint3f(n5);
                    n = 2;
                    break;
                }
                case 4160: {
                    vector3f2 = new Vector3f(this.centerParameter(++i));
                    bl2 = true;
                    bl3 = true;
                    break;
                }
                case 137363467: {
                    bl5 = true;
                    continue block23;
                }
                case 1297090050: {
                    Object[] objectArray2;
                    int n6 = this.intParameter(++i);
                    if (this.isSyntaxCheck) continue block23;
                    Map<String, Object> map = this.viewer.getSpaceGroupInfo(null);
                    Object[] objectArray3 = objectArray2 = map == null ? null : (Object[])map.get("operations");
                    if (n6 == 0 || objectArray2 == null || objectArray2.length < Math.abs(n6)) {
                        this.error(22);
                    }
                    objectArray2 = (Object[])objectArray2[Math.abs(n6) - 1];
                    vector3f2 = (Vector3f)objectArray2[5];
                    point3f = (Point3f)objectArray2[6];
                    point3fArray[0] = (Point3f)objectArray2[7];
                    if (objectArray2[8] != null) {
                        vector3f = (Vector3f)objectArray2[8];
                    }
                    f3 = ((Integer)objectArray2[9]).intValue();
                    if (n6 < 0) {
                        f3 = -f3;
                        if (vector3f2 != null) {
                            vector3f2.scale(-1.0f);
                        }
                    }
                    if (f3 == 0.0f && point3fArray[0] != null) {
                        point4f = Measure.getPlaneThroughPoint(point3fArray[0], vector3f);
                    }
                    quaternion = new Quaternion(vector3f, f3);
                    n = point3fArray[0] == null ? 0 : 1;
                    bl3 = true;
                    bl4 = true;
                    bl2 = true;
                    continue block23;
                }
                case 11: 
                case 12: 
                case 135270405: {
                    bl4 = true;
                    if (n3 == 135270405) {
                        float f4;
                        if ((list = this.viewer.getAtomPointVector(bitSet2 = this.atomExpression(++i))) == null) {
                            this.error(22, i);
                        }
                        i = this.iToken;
                        if ((list2 = this.getPointVector(this.getToken((int)i).value, ++i)) == null || list.size() != list2.size()) {
                            this.error(22, i);
                        }
                        matrix4f = new Matrix4f();
                        point3fArray[0] = new Point3f();
                        n = 1;
                        float f5 = f4 = this.isSyntaxCheck ? 0.0f : Measure.getTransformMatrix4(list, list2, matrix4f, point3fArray[0]);
                        if ((double)f4 > 0.001) {
                            list2 = null;
                        }
                    } else if (n3 == 12) {
                        matrix4f = (Matrix4f)this.theToken.value;
                    }
                    matrix3f = new Matrix3f();
                    if (matrix4f != null) {
                        vector3f2 = new Vector3f();
                        matrix4f.get(vector3f2);
                        matrix4f.get(matrix3f);
                    } else {
                        matrix3f = (Matrix3f)this.theToken.value;
                    }
                    quaternion = this.isSyntaxCheck ? new Quaternion() : new Quaternion(matrix3f);
                    vector3f.set(quaternion.getNormal());
                    f3 = quaternion.getTheta();
                    bl3 = true;
                    break;
                }
                default: {
                    this.error(22);
                }
            }
            i = this.iToken;
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (bl2 && bitSet == null) {
            bitSet = this.viewer.getSelectionSet(false);
        }
        if (bitSet2 != null) {
            bl2 = true;
            if (bitSet == null) {
                bitSet = bitSet2;
            }
        }
        float f6 = f2 == Float.MIN_VALUE ? 10.0f : (f = f2 < 0.0f ? -f3 / f2 : f2);
        if (quaternion != null) {
            if (n == 0 && vector3f2 != null) {
                point3fArray[0] = this.viewer.getAtomSetCenter(bitSet != null ? bitSet : (bl2 ? this.viewer.getSelectionSet(false) : this.viewer.getModelUndeletedAtomsBitSet(-1)));
            }
            if (bl5 && vector3f2 != null) {
                point3fArray[1] = new Point3f(point3fArray[0]);
                point3fArray[1].add(vector3f2);
                objectArray = (Object[])Measure.computeHelicalAxis(null, 135266306, point3fArray[0], point3fArray[1], quaternion);
                point3fArray[0] = (Point3f)objectArray[0];
                float f7 = ((Point3f)objectArray[3]).x;
                if (f7 != 0.0f) {
                    vector3f2 = (Vector3f)objectArray[1];
                    vector3f = new Vector3f(vector3f2);
                    if (f7 < 0.0f) {
                        vector3f.scale(-1.0f);
                    }
                }
                matrix4f = null;
            }
            if (bl && matrix4f == null) {
                matrix4f = ScriptMathProcessor.getMatrix4f(quaternion.getMatrix(), vector3f2);
            }
            if (point3fArray[0] != null) {
                n = 1;
            }
        }
        if (point3f != null) {
            this.viewer.invertAtomCoord(point3f, bitSet);
            if (vector3f == null) {
                return;
            }
        }
        if (point4f != null) {
            this.viewer.invertAtomCoord(point4f, bitSet);
            if (vector3f == null) {
                return;
            }
        }
        if (n < 2) {
            if (!bl3) {
                this.viewer.rotateAxisAngleAtCenter(point3fArray[0], vector3f, f, f3, bl, bitSet);
                return;
            }
            if (n == 0) {
                point3fArray[0] = new Point3f();
            }
            point3fArray[1] = new Point3f(point3fArray[0]);
            point3fArray[1].add(vector3f);
            n = 2;
        }
        if (n == 0) {
            point3fArray[0] = new Point3f();
        }
        if (n < 2 || point3fArray[0].distance(point3fArray[1]) == 0.0f) {
            point3fArray[1] = new Point3f(point3fArray[0]);
            point3fArray[1].y = (float)((double)point3fArray[1].y + 1.0);
        }
        if (f3 == Float.MAX_VALUE) {
            f3 = 0.0f;
        }
        if (f3 != 0.0f && vector3f2 != null && !bl4) {
            vector3f2.scale(f3 / vector3f2.length());
        }
        if (bl && vector3f2 != null && (f3 == 0.0f || f2 == 0.0f)) {
            f3 = 0.01f;
            f = f2 == Float.MIN_VALUE ? 0.01f : (f2 < 0.0f ? -f3 / f2 : f2 * 0.01f / vector3f2.length());
            f2 = 0.01f;
        }
        if (bitSet != null && bl && list2 == null && matrix4f != null) {
            list = this.viewer.getAtomPointVector(bitSet);
            list2 = Measure.transformPoints(list, matrix4f, point3fArray[0]);
        }
        if (bitSet != null && !bl && list2 != null) {
            this.viewer.setAtomCoord(bitSet, 1146095626, list2);
        } else {
            this.viewer.rotateAboutPointsInternal(point3fArray[0], point3fArray[1], f, f3, bl, bitSet, vector3f2, list2);
        }
    }

    List<Point3f> getPointVector(Object object, int n) throws ScriptException {
        if (object instanceof BitSet) {
            return this.viewer.getAtomPointVector((BitSet)object);
        }
        if (object instanceof String[]) {
            return Escape.unescapePointVector((String[])object);
        }
        if (n > 0) {
            return this.viewer.getAtomPointVector(this.atomExpression(n));
        }
        return null;
    }

    private Point3f getObjectCenter(String string, int n, int n2) {
        Object[] objectArray = new Object[]{string, n, n2};
        return this.getShapeProperty(22, "getCenter", objectArray) || this.getShapeProperty(23, "getCenter", objectArray) ? (Point3f)objectArray[2] : null;
    }

    private Point3f[] getObjectBoundingBox(String string) {
        Object[] objectArray = new Object[]{string, null, null};
        return this.getShapeProperty(23, "getBoundingBox", objectArray) ? (Point3f[])objectArray[2] : null;
    }

    private Vector3f getDrawObjectAxis(String string, int n) {
        Object[] objectArray = new Object[]{string, n, null};
        return this.getShapeProperty(22, "getSpinAxis", objectArray) ? (Vector3f)objectArray[2] : null;
    }

    private void script(int n, String string, boolean bl) throws ScriptException {
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 2;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (n == 135287298) {
            this.checkLength(2);
            if (!this.isSyntaxCheck) {
                this.viewer.jsEval(this.parameterAsString(1));
            }
            return;
        }
        if (string == null) {
            n = this.tokAt(1);
            if (n != 4) {
                this.error(16);
            }
            if ((string = this.parameterAsString(1)).equalsIgnoreCase("applet")) {
                String string6 = this.parameterAsString(2);
                string2 = this.parameterExpressionString(3, 0);
                this.checkLast(this.iToken);
                if (this.isSyntaxCheck) {
                    return;
                }
                if (string6.length() == 0 || string6.equals("all")) {
                    string6 = "*";
                }
                if (!string6.equals(".")) {
                    this.viewer.jsEval(string6 + "\u0001" + string2);
                    if (!string6.equals("*")) {
                        return;
                    }
                }
            } else {
                n = this.tokAt(this.statementLength - 1);
                boolean bl5 = bl4 = n == 266298;
                if (string.equalsIgnoreCase("inline")) {
                    string2 = this.parameterExpressionString(2, bl4 ? this.statementLength - 1 : 0);
                    n6 = this.iToken + 1;
                }
                while (string.equalsIgnoreCase("localPath") || string.equalsIgnoreCase("remotePath") || string.equalsIgnoreCase("scriptPath")) {
                    if (string.equalsIgnoreCase("localPath")) {
                        string3 = this.parameterAsString(n6++);
                    } else if (string.equalsIgnoreCase("scriptPath")) {
                        string5 = this.parameterAsString(n6++);
                    } else {
                        string4 = this.parameterAsString(n6++);
                    }
                    string = this.parameterAsString(n6++);
                }
                n = this.tokAt(n6);
                if (n == 1073741878) {
                    bl3 = true;
                    n = this.tokAt(++n6);
                }
                if (n == 1073742050) {
                    bl2 = false;
                    n = this.tokAt(++n6);
                }
                if (n == 1073741998 || n == 0x44100004) {
                    int n7 = ++n6;
                    n4 = n2 = Math.max(this.intParameter(n7), 0);
                    if (this.checkToken(++n6) && (n4 = this.getToken((int)n6).tok == 0x101000A0 ? (this.checkToken(++n6) ? this.intParameter(n6++) : 0) : -this.intParameter(n6++)) <= 0) {
                        this.error(22);
                    }
                } else if (n == 0x40000042 || n == 0x40000044) {
                    int n8 = ++n6;
                    n3 = Math.max(this.intParameter(n8) - 1, 0);
                    n5 = n3 + 1;
                    if (this.checkToken(++n6) && (n5 = this.getToken((int)n6).tok == 0x101000A0 ? (this.checkToken(++n6) ? this.intParameter(n6++) : 0) : -this.intParameter(n6++)) <= 0) {
                        this.error(22);
                    }
                }
                this.checkLength(bl4 ? n6 + 1 : n6);
            }
        }
        if (this.isSyntaxCheck && !this.isCmdLine_c_or_C_Option) {
            return;
        }
        if (this.isCmdLine_c_or_C_Option) {
            bl3 = true;
        }
        boolean bl6 = this.isSyntaxCheck;
        boolean bl7 = this.isCmdLine_c_or_C_Option;
        if (bl3) {
            this.isCmdLine_c_or_C_Option = true;
            this.isSyntaxCheck = true;
        }
        this.pushContext(null);
        this.contextPath = this.contextPath + " >> " + string;
        if (string2 == null ? this.compileScriptFileInternal(string, string3, string4, string5) : this.compileScript(null, string2, false)) {
            this.pcEnd = n5;
            this.lineEnd = n4;
            while (n3 < this.lineNumbers.length && this.lineNumbers[n3] < n2) {
                ++n3;
            }
            this.pc = n3;
            boolean bl8 = this.isCmdLine_C_Option;
            this.isCmdLine_C_Option &= bl2;
            this.executionStepping |= bl4;
            this.instructionDispatchLoop(bl3 || bl);
            if (this.debugScript && this.viewer.getMessageStyleChime()) {
                this.viewer.scriptStatus("script <exiting>");
            }
            this.isCmdLine_C_Option = bl8;
            this.popContext(false, false);
        } else {
            Logger.error(GT._("script ERROR: ") + this.errorMessage);
            this.popContext(false, false);
            if (bl7) {
                this.setErrorMessage(null);
            } else {
                this.evalError(null, null);
            }
        }
        this.isSyntaxCheck = bl6;
        this.isCmdLine_c_or_C_Option = bl7;
    }

    private void function() throws ScriptException {
        List<ScriptVariable> list;
        if (this.isSyntaxCheck && !this.isCmdLine_c_or_C_Option) {
            return;
        }
        String string = (String)this.getToken((int)0).value;
        if (!this.viewer.isFunction(string)) {
            this.error(10);
        }
        List<ScriptVariable> list2 = list = this.statementLength == 1 || this.statementLength == 3 && this.tokAt(1) == 0x10100010 && this.tokAt(2) == 0x10100011 ? null : this.parameterExpressionList(1, 0);
        if (this.isSyntaxCheck) {
            return;
        }
        this.runFunction(null, string, list, null, false);
    }

    private void sync() throws ScriptException {
        this.checkLength(-3);
        String string = "";
        String string2 = "";
        switch (this.statementLength) {
            case 1: {
                string2 = "*";
                string = "ON";
                break;
            }
            case 2: {
                string2 = this.parameterAsString(1);
                if (string2.indexOf("jmolApplet") == 0 || Parser.isOneOf(string2, "*;.;^")) {
                    string = "ON";
                    if (!this.isSyntaxCheck) {
                        this.viewer.syncScript(string, string2);
                    }
                    string2 = ".";
                    break;
                }
                string = string2;
                string2 = "*";
                break;
            }
            case 3: {
                string2 = this.parameterAsString(1);
                String string3 = string = this.tokAt(2) == 528443 ? "GET_GRAPHICS" : this.parameterAsString(2);
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.syncScript(string, string2);
    }

    private void history(int n) throws ScriptException {
        if (this.statementLength == 1) {
            this.showString(this.viewer.getSetHistory(Integer.MAX_VALUE));
            return;
        }
        if (n == 2) {
            int n2 = this.intParameter(this.checkLast(2));
            if (n2 < 0) {
                this.error(22);
            }
            if (!this.isSyntaxCheck) {
                this.viewer.getSetHistory(n2 == 0 ? 0 : -2 - n2);
            }
            return;
        }
        switch (this.getToken((int)this.checkLast((int)1)).tok) {
            case 0x10000D: 
            case 1073741882: {
                if (!this.isSyntaxCheck) {
                    this.viewer.getSetHistory(Integer.MIN_VALUE);
                }
                return;
            }
            case 0x10000C: {
                if (this.isSyntaxCheck) break;
                this.viewer.getSetHistory(0);
                break;
            }
            default: {
                this.error(24, "ON, OFF, CLEAR");
            }
        }
    }

    private void display(boolean bl) throws ScriptException {
        BitSet bitSet = null;
        switch (this.tokAt(1)) {
            case 0x100007: {
                this.setObjectProperty();
                return;
            }
            case 0: {
                break;
            }
            default: {
                bitSet = this.statementLength == 4 && this.tokAt(2) == 1678770178 ? new Bond.BondSet(BitSetUtil.newBitSet(0, this.viewer.getModelSet().getBondCount())) : this.atomExpression(1);
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (bitSet instanceof Bond.BondSet) {
            this.viewer.displayBonds((Bond.BondSet)bitSet, bl);
            return;
        }
        if (bl) {
            this.viewer.display(bitSet, this.tQuiet);
        } else {
            this.viewer.hide(bitSet, this.tQuiet);
        }
    }

    private void delete() throws ScriptException {
        if (this.statementLength == 1) {
            this.zap(true);
            return;
        }
        if (this.tokAt(1) == 0x100007) {
            this.setObjectProperty();
            return;
        }
        BitSet bitSet = this.atomExpression(this.statement, 1, 0, true, false, true, false);
        if (this.isSyntaxCheck) {
            return;
        }
        int n = this.viewer.deleteAtoms(bitSet, false);
        if (!this.tQuiet && this.scriptLevel <= this.scriptReportingLevel) {
            this.scriptStatusOrBuffer(GT._("{0} atoms deleted", n));
        }
    }

    private void minimize() throws ScriptException {
        BitSet bitSet = null;
        int n = Integer.MAX_VALUE;
        float f = 0.0f;
        boolean bl = false;
        boolean bl2 = false;
        BitSet bitSet2 = null;
        MinimizerInterface minimizerInterface = this.viewer.getMinimizer(false);
        block12: for (int i = 1; i < this.statementLength; ++i) {
            switch (this.getToken((int)i).tok) {
                case 0x40000004: {
                    bl = true;
                    continue block12;
                }
                case 1073741873: 
                case 1073742162: {
                    this.checkLength(2);
                    if (this.isSyntaxCheck || minimizerInterface == null) {
                        return;
                    }
                    minimizerInterface.setProperty(this.parameterAsString(i), null);
                    return;
                }
                case 1073741882: {
                    this.checkLength(2);
                    if (this.isSyntaxCheck || minimizerInterface == null) {
                        return;
                    }
                    minimizerInterface.setProperty("clear", null);
                    return;
                }
                case 0x40000046: {
                    if (i != 1) {
                        this.error(22);
                    }
                    int n2 = 0;
                    float f2 = 0.0f;
                    int[] nArray = new int[5];
                    if (this.tokAt(++i) == 1073741882) {
                        this.checkLength(2);
                    } else {
                        while (n2 < 4 && !this.isFloatParameter(i)) {
                            nArray[++n2] = this.atomExpression(i).nextSetBit(0);
                            i = this.iToken + 1;
                        }
                        nArray[0] = n2;
                        if (n2 == 1) {
                            this.error(22);
                        }
                        f2 = this.floatParameter(this.checkLast(i));
                    }
                    if (!this.isSyntaxCheck) {
                        this.viewer.getMinimizer(true).setProperty("constraint", new Object[]{nArray, new int[n2], new Float(f2)});
                    }
                    return;
                }
                case 1073741905: {
                    f = this.floatParameter(++i);
                    continue block12;
                }
                case 1073741935: {
                    n = 0;
                    continue block12;
                }
                case 1060869: {
                    if (i != 1) {
                        this.error(22);
                    }
                    if ((bitSet2 = this.atomExpression(++i)).nextSetBit(0) < 0) {
                        bitSet2 = null;
                    }
                    i = this.iToken;
                    if (!this.isSyntaxCheck) {
                        this.viewer.getMinimizer(true).setProperty("fixed", bitSet2);
                    }
                    if (i + 1 != this.statementLength) continue block12;
                    return;
                }
                case 135280131: {
                    bitSet = this.atomExpression(++i);
                    i = this.iToken;
                    continue block12;
                }
                case 0x40000144: {
                    bl2 = true;
                    continue block12;
                }
                case 266298: 
                case 1073742160: {
                    n = this.intParameter(++i);
                    continue block12;
                }
                default: {
                    this.error(22);
                }
            }
        }
        if (!this.isSyntaxCheck) {
            this.viewer.minimize(n, f, bitSet, bitSet2, 0.0f, bl, bl2, false);
        }
    }

    private void select(int n) throws ScriptException {
        Object object;
        if (this.statementLength == 1) {
            this.viewer.select(null, this.tQuiet || this.scriptLevel > this.scriptReportingLevel);
            return;
        }
        if (this.statementLength == 2 && this.tokAt(1) == 1073742072) {
            return;
        }
        this.viewer.setNoneSelected(this.statementLength == 4 && this.tokAt(2) == 0x10000B);
        if (this.tokAt(2) == 10 && this.getToken((int)2).value instanceof Bond.BondSet || this.getToken((int)2).tok == 1678770178 && this.getToken((int)3).tok == 10) {
            if (this.statementLength == this.iToken + 2) {
                if (!this.isSyntaxCheck) {
                    this.viewer.selectBonds((BitSet)this.theToken.value);
                }
                return;
            }
            this.error(22);
        }
        if (this.getToken((int)2).tok == 1746538509) {
            if (this.statementLength == 5 && this.getToken((int)3).tok == 10) {
                if (!this.isSyntaxCheck) {
                    this.setShapeProperty(6, "select", this.theToken.value);
                }
                return;
            }
            this.error(22);
        }
        Object object2 = null;
        if (this.getToken((int)1).intValue == 0) {
            object = this.tokenSetting((int)0).value;
            if (!(object instanceof BitSet)) {
                this.error(22);
            }
            this.checkLast(this.iToken);
            object2 = (BitSet)object;
        } else {
            object2 = this.atomExpression(n);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (this.isBondSet) {
            this.viewer.selectBonds((BitSet)object2);
        } else {
            if (((BitSet)object2).length() > this.viewer.getAtomCount()) {
                object = this.viewer.getModelUndeletedAtomsBitSet(-1);
                ((BitSet)object).and((BitSet)object2);
                object2 = object;
            }
            this.viewer.select((BitSet)object2, this.tQuiet || this.scriptLevel > this.scriptReportingLevel);
        }
    }

    private void subset() throws ScriptException {
        BitSet bitSet;
        BitSet bitSet2 = bitSet = this.statementLength == 1 ? null : this.atomExpression(-1);
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.setSelectionSubset(bitSet);
    }

    private void invertSelected() throws ScriptException {
        Point3f point3f = null;
        Point4f point4f = null;
        BitSet bitSet = null;
        int n = Integer.MIN_VALUE;
        switch (this.tokAt(1)) {
            case 0: {
                if (this.isSyntaxCheck) {
                    return;
                }
                bitSet = this.viewer.getSelectionSet(false);
                point3f = this.viewer.getAtomSetCenter(bitSet);
                this.viewer.invertAtomCoord(point3f, bitSet);
                return;
            }
            case 528443: {
                n = this.atomExpression(2).nextSetBit(0);
                bitSet = this.atomExpression(this.iToken + 1);
                break;
            }
            case 0x8100010: {
                point3f = this.centerParameter(2);
                break;
            }
            case 135266319: {
                point4f = this.planeParameter(2);
                break;
            }
            case 135267841: {
                point4f = this.hklParameter(2);
            }
        }
        this.checkLength(this.iToken + 1, 1);
        if (point4f == null && point3f == null && n == Integer.MIN_VALUE) {
            this.error(22);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (n == -1) {
            return;
        }
        this.viewer.invertSelected(point3f, point4f, n, bitSet);
    }

    private void translate(boolean bl) throws ScriptException {
        char c;
        float f;
        BitSet bitSet = null;
        int n = 1;
        if (this.tokAt(1) == 1114638349) {
            bl = true;
            ++n;
        }
        if (this.isPoint3f(n)) {
            Point3f point3f = this.getPoint3f(n, true);
            bitSet = !bl && this.iToken + 1 < this.statementLength ? this.atomExpression(++this.iToken) : null;
            this.checkLast(this.iToken);
            if (!this.isSyntaxCheck) {
                this.viewer.setAtomCoordRelative(point3f, bitSet);
            }
            return;
        }
        int n2 = this.getToken((int)n).tok;
        if (n2 != 1112541203 && n2 != 1112541204 && n2 != 1112541205) {
            this.error(0);
        }
        if ((f = this.floatParameter(++n)) == 0.0f) {
            return;
        }
        switch (this.tokAt(++n)) {
            case 0: 
            case 10: 
            case 0x100001: {
                c = '\u0000';
                break;
            }
            default: {
                c = (this.optParameterAsString(n).toLowerCase() + '\u0000').charAt(0);
            }
        }
        int n3 = this.iToken = c == '\u0000' ? 2 : 3;
        bitSet = bl ? this.viewer.getSelectionSet(false) : (this.iToken + 1 < this.statementLength ? this.atomExpression(++this.iToken) : null);
        this.checkLast(this.iToken);
        if (!this.isSyntaxCheck) {
            this.viewer.translate(this.parameterAsString(1).charAt(0), f, c, bitSet);
        }
    }

    private void zap(boolean bl) throws ScriptException {
        boolean bl2;
        if (this.statementLength == 1 || !bl) {
            this.viewer.zap(true, bl && !this.isStateScript, true);
            this.refresh();
            return;
        }
        BitSet bitSet = this.atomExpression(1);
        if (this.isSyntaxCheck) {
            return;
        }
        int n = this.viewer.deleteAtoms(bitSet, true);
        boolean bl3 = bl2 = this.tQuiet || this.scriptLevel > this.scriptReportingLevel;
        if (!bl2) {
            this.scriptStatusOrBuffer(GT._("{0} atoms deleted", n));
        }
        this.viewer.select(null, bl2);
    }

    private void zoom(boolean bl) throws ScriptException {
        float f;
        if (!bl) {
            int n = this.statementLength > 1 ? this.getToken((int)1).tok : 0x10000D;
            switch (n) {
                case 1073741979: 
                case 0x400000FF: {
                    break;
                }
                case 0x10000C: 
                case 0x10000D: {
                    if (this.statementLength > 2) {
                        this.error(2);
                    }
                    if (!this.isSyntaxCheck) {
                        this.setBooleanProperty("zoomEnabled", n == 0x10000D);
                    }
                    return;
                }
            }
        }
        Point3f point3f = null;
        int n = 1;
        float f2 = bl ? (this.isFloatParameter(n) ? this.floatParameter(n++) : 2.0f) : (f = 0.0f);
        if (f < 0.0f) {
            --n;
            f = 0.0f;
        }
        int n2 = 0;
        BitSet bitSet = null;
        if (this.isCenterParameter(n)) {
            n2 = n;
            point3f = this.centerParameter(n);
            if (this.expressionResult instanceof BitSet) {
                bitSet = (BitSet)this.expressionResult;
            }
            n = this.iToken + 1;
        }
        boolean bl2 = false;
        float f3 = this.viewer.getZoomSetting();
        float f4 = this.getZoom(n, bitSet, f3);
        n = this.iToken + 1;
        float f5 = Float.NaN;
        float f6 = Float.NaN;
        if (n != this.statementLength) {
            f5 = this.floatParameter(n++);
            f6 = this.floatParameter(n++);
        }
        if (n != this.statementLength) {
            this.error(22);
        }
        if (f4 < 0.0f) {
            f4 = -f4;
            if (bl) {
                if (this.statementLength == 1 || bl2) {
                    f4 *= 2.0f;
                } else if (point3f == null) {
                    f4 /= 2.0f;
                }
            }
        }
        float f7 = this.viewer.getMaxZoomPercent();
        if (f4 < 5.0f || f4 > f7) {
            this.numberOutOfRange(5.0f, f7);
        }
        if (!this.viewer.isWindowCentered()) {
            if (point3f != null) {
                BitSet bitSet2 = this.atomExpression(n2);
                if (!this.isSyntaxCheck) {
                    this.viewer.setCenterBitSet(bitSet2, false);
                }
            }
            point3f = this.viewer.getRotationCenter();
            if (Float.isNaN(f5)) {
                f5 = this.viewer.getTranslationXPercent();
            }
            if (Float.isNaN(f6)) {
                f6 = this.viewer.getTranslationYPercent();
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (Float.isNaN(f5)) {
            f5 = 0.0f;
        }
        if (Float.isNaN(f6)) {
            f6 = 0.0f;
        }
        if (bl2 && Math.abs(f3 - f4) < 1.0f) {
            f = 0.0f;
        }
        this.viewer.moveTo(f, point3f, JmolConstants.center, Float.NaN, null, f4, f5, f6, Float.NaN, null, Float.NaN, Float.NaN, Float.NaN);
    }

    private float getZoom(int n, BitSet bitSet, float f) throws ScriptException {
        float f2;
        float f3 = f2 = this.isFloatParameter(n) ? this.floatParameter(n++) : Float.NaN;
        if (f2 == 0.0f || f == 0.0f) {
            if (bitSet == null) {
                this.error(22);
            }
            float f4 = this.viewer.calcRotationRadius(bitSet);
            f = this.viewer.getRotationRadius() / f4 * 100.0f;
            f2 = Float.NaN;
        }
        if (f2 < 0.0f) {
            f2 += f;
        } else if (Float.isNaN(f2)) {
            int n2 = this.tokAt(n);
            switch (n2) {
                case 1073741979: 
                case 0x400000FF: {
                    f2 = f * (n2 == 0x400000FF ? 0.5f : 2.0f);
                    ++n;
                    break;
                }
                case 0x101000A1: 
                case 0x101000B0: 
                case 0x101000B1: {
                    float f5 = this.floatParameter(++n);
                    ++n;
                    switch (n2) {
                        case 0x101000B0: {
                            f2 = f / f5;
                            break;
                        }
                        case 0x101000B1: {
                            f2 = f * f5;
                            break;
                        }
                        case 0x101000A1: {
                            f2 = f + f5;
                        }
                    }
                    break;
                }
                default: {
                    f2 = bitSet == null ? -f : f;
                }
            }
        }
        this.iToken = n - 1;
        return f2;
    }

    private void delay() throws ScriptException {
        long l = 0L;
        switch (this.getToken((int)1).tok) {
            case 0x10000D: {
                l = 1L;
                break;
            }
            case 2: {
                l = this.intParameter(1) * 1000;
                break;
            }
            case 3: {
                l = (long)(this.floatParameter(1) * 1000.0f);
                break;
            }
            default: {
                this.error(34);
            }
        }
        if (!this.isSyntaxCheck) {
            this.delay(l);
        }
    }

    private void delay(long l) {
        long l2 = System.currentTimeMillis();
        this.refresh();
        if (l < 0L) {
            l = -l;
        } else {
            int n = this.viewer.getDelayMaximum();
            if (n > 0 && l > (long)n) {
                l = n;
            }
        }
        int n = (int)(l -= System.currentTimeMillis() - l2) / 1000;
        if ((l -= (long)(n * 1000)) <= 0L) {
            l = 1L;
        }
        while (n >= 0 && l > 0L && !this.interruptExecution && this.currentThread == Thread.currentThread()) {
            this.viewer.popHoldRepaint("delay");
            try {
                Thread.sleep(n-- > 0 ? 1000L : l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.viewer.pushHoldRepaint("delay");
        }
    }

    private void slab(boolean bl) throws ScriptException {
        boolean bl2 = false;
        Point4f point4f = null;
        if (this.isCenterParameter(1) || this.tokAt(1) == 9) {
            point4f = this.planeParameter(1);
        } else {
            block0 : switch (this.getToken((int)1).tok) {
                case 2: {
                    int n = this.intParameter(this.checkLast(1));
                    if (!this.isSyntaxCheck) {
                        if (bl) {
                            this.viewer.depthToPercent(n);
                        } else {
                            this.viewer.slabToPercent(n);
                        }
                    }
                    return;
                }
                case 0x10000D: {
                    this.checkLength(2);
                    bl2 = true;
                }
                case 0x10000C: {
                    this.checkLength(2);
                    this.setBooleanProperty("slabEnabled", bl2);
                    return;
                }
                case 4140: {
                    this.checkLength(2);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.slabReset();
                    this.setBooleanProperty("slabEnabled", true);
                    return;
                }
                case 1085443: {
                    this.checkLength(2);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.setSlabDepthInternal(bl);
                    this.setBooleanProperty("slabEnabled", true);
                    return;
                }
                case 0x101000A0: {
                    String string = this.parameterAsString(2);
                    if (string.equalsIgnoreCase("hkl")) {
                        point4f = this.hklParameter(3);
                    } else if (string.equalsIgnoreCase("plane")) {
                        point4f = this.planeParameter(3);
                    }
                    if (point4f == null) {
                        this.error(22);
                    }
                    point4f.scale(-1.0f);
                    break;
                }
                case 135266319: {
                    switch (this.getToken((int)2).tok) {
                        case 0x10000B: {
                            break block0;
                        }
                    }
                    point4f = this.planeParameter(2);
                    break;
                }
                case 135267841: {
                    point4f = this.getToken((int)2).tok == 0x10000B ? null : this.hklParameter(2);
                    break;
                }
                case 1073742118: {
                    return;
                }
                default: {
                    this.error(22);
                }
            }
        }
        if (!this.isSyntaxCheck) {
            this.viewer.slabInternal(point4f, bl);
        }
    }

    private void ellipsoid() throws ScriptException {
        int n = 0;
        int n2 = 1;
        switch (this.getToken((int)1).tok) {
            case 0x10000D: {
                n = 50;
                break;
            }
            case 0x10000C: {
                break;
            }
            case 2: {
                n = this.intParameter(1);
                break;
            }
            case 0x101000B1: 
            case 0x40000000: 
            case 1074790550: {
                this.shapeManager.loadShape(20);
                if (this.theTok == 1074790550) {
                    ++n2;
                }
                this.setShapeId(20, n2, false);
                n2 = this.iToken;
                block16: while (++n2 < this.statementLength) {
                    String string = this.parameterAsString(n2);
                    Object object = null;
                    switch (this.tokAt(n2)) {
                        case 1611272194: {
                            Vector3f[] vector3fArray = new Vector3f[3];
                            for (int i = 0; i < 3; ++i) {
                                vector3fArray[i] = new Vector3f();
                                vector3fArray[i].set(this.centerParameter(++n2));
                                n2 = this.iToken;
                            }
                            object = vector3fArray;
                            break;
                        }
                        case 12289: {
                            object = this.centerParameter(++n2);
                            n2 = this.iToken;
                            break;
                        }
                        case 1766856708: {
                            float f = Float.NaN;
                            this.theTok = this.tokAt(++n2);
                            if (this.theTok == 1073742180) {
                                object = "translucent";
                                f = this.isFloatParameter(++n2) ? this.getTranslucentLevel(n2++) : this.viewer.getDefaultTranslucent();
                            } else if (this.theTok == 1073742074) {
                                object = "opaque";
                                ++n2;
                            }
                            if (this.isColorParam(n2)) {
                                this.setShapeProperty(20, "color", this.getArgbParam(n2));
                                n2 = this.iToken;
                            }
                            if (object == null) continue block16;
                            if (!Float.isNaN(f)) {
                                this.setShapeProperty(20, "translucentLevel", new Float(f));
                            }
                            string = "translucency";
                            break;
                        }
                        case 12291: {
                            object = Boolean.TRUE;
                            this.checkLength(3);
                            break;
                        }
                        case 1095761933: {
                            object = this.intParameter(++n2);
                            break;
                        }
                        case 0x10000D: {
                            object = Boolean.TRUE;
                            break;
                        }
                        case 0x10000C: {
                            string = "on";
                            object = Boolean.FALSE;
                            break;
                        }
                        case 1073742138: {
                            object = new Float(this.floatParameter(++n2));
                        }
                    }
                    if (object == null) {
                        this.error(22);
                    }
                    this.setShapeProperty(20, string.toLowerCase(), object);
                }
                this.setShapeProperty(20, "thisID", null);
                return;
            }
            default: {
                this.error(22);
            }
        }
        this.setShapeSize(20, n, null);
    }

    private String getShapeNameParameter(int n) throws ScriptException {
        String string = this.parameterAsString(n);
        boolean bl = string.equals("*");
        if (string.length() == 0) {
            this.error(22);
        }
        if (bl) {
            switch (this.tokAt(n + 1)) {
                case 0: 
                case 12291: 
                case 0x10000C: 
                case 0x10000D: 
                case 3145751: 
                case 3145752: 
                case 1766856708: {
                    break;
                }
                default: {
                    string = string + this.optParameterAsString(++n);
                }
            }
        }
        if (this.tokAt(n + 1) == 0x101000B1) {
            string = string + this.parameterAsString(++n);
        }
        this.iToken = n;
        return string;
    }

    private String setShapeId(int n, int n2, boolean bl) throws ScriptException {
        if (bl) {
            this.error(22);
        }
        String string = this.getShapeNameParameter(n2).toLowerCase();
        this.setShapeProperty(n, "thisID", string);
        return string;
    }

    private void setAtomShapeSize(int n, float f) throws ScriptException {
        RadiusData radiusData = null;
        int n2 = this.tokAt(1);
        boolean bl = false;
        switch (n2) {
            case 1073742072: {
                this.restrictSelected(false, false);
                break;
            }
            case 0x10000D: {
                break;
            }
            case 0x10000C: {
                f = 0.0f;
                break;
            }
            case 3: {
                bl = this.floatParameter(1) < 0.0f;
            }
            default: {
                radiusData = this.encodeRadiusParameter(1, bl);
                if (!Float.isNaN(radiusData.value)) break;
                this.error(22);
            }
        }
        if (radiusData == null) {
            radiusData = new RadiusData(f, 2, 8);
        }
        if (bl) {
            this.restrictSelected(false, false);
        }
        this.setShapeSize(n, radiusData);
    }

    private RadiusData encodeRadiusParameter(int n, boolean bl) throws ScriptException {
        float f = Float.NaN;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getToken((int)n).tok;
        switch (n4) {
            case 1112539137: 
            case 1112539138: 
            case 1112541194: 
            case 1112541198: 
            case 1112541199: {
                f = 1.0f;
                n2 = 2;
                n3 = n4 == 1112541199 ? 0 : n4;
                n4 = this.tokAt(++n);
            }
        }
        switch (n4) {
            case 4140: {
                return this.viewer.getDefaultRadiusData();
            }
            case 1073741852: 
            case 0x40000020: 
            case 0x40000022: 
            case 1073741992: 
            case 1073742116: {
                f = 1.0f;
                n2 = 2;
                this.iToken = n - 1;
                break;
            }
            case 3: 
            case 0x101000A1: {
                if (n4 == 0x101000A1) {
                    ++n;
                    n2 = 1;
                } else {
                    n2 = 0;
                    n3 = Integer.MAX_VALUE;
                }
                f = this.floatParameter(n, bl ? -16 : 0, 16.0f);
                if (!bl) break;
                f = -f;
                break;
            }
            case 2: {
                f = this.intParameter(n);
                if (this.tokAt(n + 1) == 269484210) {
                    this.iToken = ++n;
                    n2 = 2;
                    if (f < 0.0f || f > 200.0f) {
                        this.integerOutOfRange(0, 200);
                    }
                    f /= 100.0f;
                    break;
                }
                if (f > 749.0f || f < -200.0f) {
                    this.integerOutOfRange(-200, 749);
                }
                if (f > 0.0f) {
                    f /= 250.0f;
                    n2 = 0;
                    break;
                }
                f /= -100.0f;
                n2 = 2;
                break;
            }
            default: {
                if (f != 1.0f) break;
                --n;
            }
        }
        if (n3 == 0 && (n3 = JmolConstants.getVdwType(this.optParameterAsString(++this.iToken))) < 0) {
            this.iToken = n;
            n3 = JmolConstants.getVdwType("auto");
        }
        return new RadiusData(f, n2, n3);
    }

    private void structure() throws ScriptException {
        byte by = JmolConstants.getProteinStructureType(this.parameterAsString(1));
        if (by < 0) {
            this.error(22);
        }
        BitSet bitSet = null;
        switch (this.tokAt(2)) {
            case 10: 
            case 0x100001: {
                bitSet = this.atomExpression(2);
                this.checkLast(this.iToken);
                break;
            }
            default: {
                this.checkLength(2);
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        this.clearDefinedVariableAtomSets();
        this.viewer.setProteinType(by, bitSet);
    }

    private void wireframe() throws ScriptException {
        int n = Integer.MIN_VALUE;
        if (this.tokAt(1) == 4140) {
            this.checkLast(1);
        } else {
            n = this.getMadParameter();
        }
        if (this.isSyntaxCheck) {
            return;
        }
        this.setShapeProperty(1, "type", 1023);
        this.setShapeSize(1, n == Integer.MIN_VALUE ? 300 : n, null);
    }

    private void ssbond() throws ScriptException {
        int n = this.getMadParameter();
        this.setShapeProperty(1, "type", 256);
        this.setShapeSize(1, n, null);
        this.setShapeProperty(1, "type", 1023);
    }

    private void struts() throws ScriptException {
        boolean bl = this.tokAt(1) == 1073742072 || this.tokAt(1) == 0x10000D || this.statementLength == 1;
        int n = this.getMadParameter();
        if (bl) {
            n = (int)(this.viewer.getStrutDefaultRadius() * 2000.0f);
        }
        this.setShapeProperty(1, "type", 32768);
        this.setShapeSize(1, n, null);
        this.setShapeProperty(1, "type", 1023);
    }

    private void hbond() throws ScriptException {
        if (this.statementLength == 2 && this.getToken((int)1).tok == 4102) {
            if (this.isSyntaxCheck) {
                return;
            }
            int n = this.viewer.autoHbond(null, null);
            this.scriptStatusOrBuffer(GT._("{0} hydrogen bonds", Math.abs(n)));
            return;
        }
        if (this.statementLength == 2 && this.getToken((int)1).tok == 12291) {
            if (this.isSyntaxCheck) {
                return;
            }
            this.connect(0);
            return;
        }
        int n = this.getMadParameter();
        this.setShapeProperty(1, "type", 30720);
        this.setShapeSize(1, n, null);
        this.setShapeProperty(1, "type", 1023);
    }

    private void configuration() throws ScriptException {
        int n;
        BitSet bitSet;
        if (this.statementLength == 1) {
            bitSet = this.viewer.setConformation();
            this.viewer.addStateScript("select", null, this.viewer.getSelectionSet(false), null, "configuration", true, false);
        } else {
            n = this.intParameter(this.checkLast(1));
            if (this.isSyntaxCheck) {
                return;
            }
            bitSet = this.viewer.getConformation(this.viewer.getCurrentModelIndex(), n - 1, true);
            this.viewer.addStateScript("configuration " + n + ";", true, false);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        n = this.viewer.hasCalculatedHBonds(bitSet) ? 1 : 0;
        this.setShapeProperty(1, "type", 30720);
        this.setShapeSize(1, 0, bitSet);
        if (n != 0) {
            this.viewer.autoHbond(bitSet, bitSet);
        }
        this.viewer.select(bitSet, this.tQuiet);
    }

    private void vector() throws ScriptException {
        int n = 3;
        float f = 1.0f;
        this.checkLength(-3);
        this.iToken = this.statementLength;
        block0 : switch (this.iToken) {
            case 1: {
                break;
            }
            case 2: {
                switch (this.getToken((int)1).tok) {
                    case 0x10000D: {
                        break block0;
                    }
                    case 0x10000C: {
                        f = 0.0f;
                        break block0;
                    }
                    case 2: {
                        n = 3;
                        f = this.intParameter(1, 0, 19);
                        break block0;
                    }
                    case 3: {
                        n = 0;
                        f = this.floatParameter(1, 0.0f, 3.0f);
                        break block0;
                    }
                }
                this.error(6);
                break;
            }
            case 3: {
                if (this.tokAt(1) != 1073742138) break;
                this.setFloatProperty("vectorScale", this.floatParameter(2, -100.0f, 100.0f));
                return;
            }
        }
        this.setShapeSize(18, new RadiusData(f, n, 0));
    }

    private void dipole() throws ScriptException {
        String string = null;
        Serializable serializable = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.shapeManager.loadShape(17);
        if (this.tokAt(1) == 7 && this.listIsosurface(17)) {
            return;
        }
        this.setShapeProperty(17, "init", null);
        if (this.statementLength == 1) {
            this.setShapeProperty(17, "thisID", null);
            return;
        }
        for (int i = 1; i < this.statementLength; ++i) {
            string = null;
            serializable = null;
            switch (this.getToken((int)i).tok) {
                case 0x10000D: {
                    string = "on";
                    break;
                }
                case 0x10000C: {
                    string = "off";
                    break;
                }
                case 12291: {
                    string = "delete";
                    break;
                }
                case 2: 
                case 3: {
                    string = "value";
                    serializable = new Float(this.floatParameter(i));
                    break;
                }
                case 10: {
                    string = "atomBitset";
                }
                case 0x100001: {
                    if (string == null) {
                        string = bl || bl2 ? "endSet" : "startSet";
                    }
                    serializable = this.atomExpression(i);
                    i = this.iToken;
                    bl = true;
                    break;
                }
                case 8: 
                case 0x10000A: {
                    Point3f point3f = this.getPoint3f(i, true);
                    i = this.iToken;
                    string = bl || bl2 ? "endCoord" : "startCoord";
                    serializable = point3f;
                    bl2 = true;
                    break;
                }
                case 1678770178: {
                    string = "bonds";
                    break;
                }
                case 4102: {
                    string = "calculate";
                    break;
                }
                case 1074790550: {
                    this.setShapeId(17, ++i, bl3);
                    i = this.iToken;
                    break;
                }
                case 135267329: {
                    string = "cross";
                    serializable = Boolean.TRUE;
                    break;
                }
                case 1073742038: {
                    string = "cross";
                    serializable = Boolean.FALSE;
                    break;
                }
                case 1073742066: {
                    float f = this.floatParameter(++i);
                    if (this.theTok == 2) {
                        string = "offsetPercent";
                        serializable = Integer.valueOf((int)f);
                        break;
                    }
                    string = "offset";
                    serializable = new Float(f);
                    break;
                }
                case 0x400000F4: {
                    string = "offsetSide";
                    serializable = new Float(this.floatParameter(++i));
                    break;
                }
                case 1073742188: {
                    string = "value";
                    serializable = new Float(this.floatParameter(++i));
                    break;
                }
                case 1073742196: {
                    string = "width";
                    serializable = new Float(this.floatParameter(++i));
                    break;
                }
                default: {
                    if (this.theTok == 0x101000B1 || Token.tokAttr(this.theTok, 0x40000000)) {
                        this.setShapeId(17, i, bl3);
                        i = this.iToken;
                        break;
                    }
                    this.error(22);
                }
            }
            boolean bl4 = bl3 = this.theTok != 12291 && this.theTok != 4102;
            if (string == null) continue;
            this.setShapeProperty(17, string, serializable);
        }
        if (bl2 || bl) {
            this.setShapeProperty(17, "set", null);
        }
    }

    private void animationMode() throws ScriptException {
        float f = 1.0f;
        float f2 = 1.0f;
        if (this.statementLength > 5) {
            this.error(2);
        }
        int n = 0;
        switch (this.getToken((int)2).tok) {
            case 528410: {
                n = 1;
                break;
            }
            case 1073742070: {
                f2 = 0.0f;
                f = 0.0f;
                break;
            }
            case 1073742082: {
                n = 2;
                break;
            }
            case 0x40000000: {
                this.error(22);
            }
        }
        if (this.statementLength >= 4) {
            f = f2 = this.floatParameter(3);
            if (this.statementLength == 5) {
                f2 = this.floatParameter(4);
            }
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setAnimationReplayMode(n, f, f2);
        }
    }

    private void vibration() throws ScriptException {
        this.checkLength(-3);
        float f = 0.0f;
        switch (this.getToken((int)1).tok) {
            case 0x10000D: {
                this.checkLength(2);
                f = this.viewer.getVibrationPeriod();
                break;
            }
            case 0x10000C: {
                this.checkLength(2);
                f = 0.0f;
                break;
            }
            case 2: 
            case 3: {
                this.checkLength(2);
                f = this.floatParameter(1);
                break;
            }
            case 1073742138: {
                this.setFloatProperty("vibrationScale", this.floatParameter(2, -10.0f, 10.0f));
                return;
            }
            case 1073742090: {
                this.setFloatProperty("vibrationPeriod", this.floatParameter(2));
                return;
            }
            case 0x40000000: {
                this.error(22);
            }
            default: {
                f = -1.0f;
            }
        }
        if (f < 0.0f) {
            this.error(22);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (f == 0.0f) {
            this.viewer.setVibrationOff();
            return;
        }
        this.viewer.setVibrationPeriod(-f);
    }

    private void animationDirection() throws ScriptException {
        int n = 2;
        int n2 = 0;
        switch (this.tokAt(n)) {
            case 0x101000A0: {
                n2 = -this.intParameter(++n);
                break;
            }
            case 0x101000A1: {
                n2 = this.intParameter(++n);
                break;
            }
            case 2: {
                n2 = this.intParameter(n);
                if (n2 <= 0) break;
                n2 = 0;
                break;
            }
            default: {
                this.error(22);
            }
        }
        this.checkLength(++n);
        if (n2 != 1 && n2 != -1) {
            this.error(35, "-1", "1");
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setAnimationDirection(n2);
        }
    }

    private void calculate() throws ScriptException {
        boolean bl = false;
        int n = Integer.MIN_VALUE;
        this.iToken = this.statementLength;
        if (this.iToken >= 2) {
            this.clearDefinedVariableAtomSets();
            switch (this.getToken((int)1).tok) {
                case 1112539144: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.calculateStraightness();
                        this.viewer.addStateScript(this.thisCommand, false, true);
                    }
                    return;
                }
                case 1613758468: {
                    BitSet bitSet = this.statementLength == 2 ? null : this.atomExpression(2);
                    this.checkLast(this.iToken);
                    if (!this.isSyntaxCheck) {
                        this.viewer.addHydrogens(bitSet, false, false);
                    }
                    return;
                }
                case 1073742102: {
                    this.pointGroup();
                    return;
                }
                case 0x30000D: {
                    bl = true;
                }
                case 1112539145: {
                    boolean bl2 = false;
                    switch (this.tokAt(2)) {
                        case 135266322: {
                            ++this.iToken;
                            break;
                        }
                        case 0: {
                            bl2 = !bl;
                            break;
                        }
                        case 0x40000080: {
                            bl2 = true;
                            ++this.iToken;
                            break;
                        }
                        default: {
                            bl2 = true;
                        }
                    }
                    BitSet bitSet = this.iToken + 1 < this.statementLength ? this.atomExpression(++this.iToken) : this.viewer.getSelectionSet(false);
                    this.checkLength(++this.iToken);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.calculateSurface(bitSet, bl2 ? Float.MAX_VALUE : -1.0f);
                    return;
                }
                case 1708089: {
                    BitSet bitSet = this.iToken + 1 < this.statementLength ? this.atomExpression(++this.iToken) : null;
                    BitSet bitSet2 = this.iToken + 1 < this.statementLength ? this.atomExpression(++this.iToken) : null;
                    this.checkLength(++this.iToken);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    n = this.viewer.calculateStruts(bitSet, bitSet2);
                    if (n > 0) {
                        this.colorShape(4, 32768, 0xFFFFFF, "translucent", 0.5f, null);
                    }
                    this.showString(GT._("{0} struts added", n));
                    return;
                }
                case 1313866247: {
                    if (this.isSyntaxCheck) break;
                    float f = this.viewer.getVolume(null, null);
                    this.showString("" + (float)Math.round(f * 10.0f) / 10.0f + " A^3; " + (float)Math.round((double)f * 6.02) / 10.0f + " cm^3/mole (VDW " + this.viewer.getDefaultVdwTypeNameOrData(Integer.MIN_VALUE) + ")");
                    return;
                }
                case 1076887572: {
                    this.checkLength(2);
                    if (!this.isSyntaxCheck) {
                        this.viewer.assignAromaticBonds();
                    }
                    return;
                }
                case 0x40000000: {
                    this.checkLength(2);
                    break;
                }
                case 1612189718: {
                    if (this.statementLength == 2) {
                        if (!this.isSyntaxCheck) {
                            n = this.viewer.autoHbond(null, null);
                            break;
                        }
                        return;
                    }
                    BitSet bitSet = this.atomExpression(2);
                    BitSet bitSet3 = this.atomExpression(this.iToken + 1);
                    if (!this.isSyntaxCheck) {
                        n = this.viewer.autoHbond(bitSet, bitSet3);
                        break;
                    }
                    return;
                }
                case 1641025539: {
                    BitSet bitSet;
                    BitSet bitSet4 = bitSet = this.statementLength == 2 ? null : this.atomExpression(2);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.calculateStructures(bitSet);
                    this.viewer.addStateScript(this.thisCommand, false, true);
                    return;
                }
            }
            if (n != Integer.MIN_VALUE) {
                this.scriptStatusOrBuffer(GT._("{0} hydrogen bonds", Math.abs(n)));
                return;
            }
        }
        this.error(53, "CALCULATE", "aromatic? hbonds? polymers? straightness? structure? strut? surfaceDistance FROM? surfaceDistance WITHIN? volume?");
    }

    private void pointGroup() throws ScriptException {
        switch (this.tokAt(0)) {
            case 4102: {
                if (!this.isSyntaxCheck) {
                    this.showString(this.viewer.calculatePointGroup());
                }
                return;
            }
            case 4148: {
                if (!this.isSyntaxCheck) {
                    this.showString(this.viewer.getPointGroupAsString(false, null, 0, 0.0f));
                }
                return;
            }
        }
        int n = 2;
        String string = this.tokAt(n) == 1073742138 ? "" : this.optParameterAsString(n);
        float f = 1.0f;
        int n2 = 0;
        if (string.length() > 0 && this.isFloatParameter(++n)) {
            n2 = this.intParameter(n++);
        }
        if (this.tokAt(n) == 1073742138) {
            f = this.floatParameter(++n);
        }
        if (!this.isSyntaxCheck) {
            this.runScript(this.viewer.getPointGroupAsString(true, string, n2, f));
        }
    }

    private void dots(int n) throws ScriptException {
        RadiusData radiusData;
        if (!this.isSyntaxCheck) {
            this.shapeManager.loadShape(n);
        }
        this.setShapeProperty(n, "init", null);
        float f = Float.NaN;
        int n2 = 0;
        int n3 = 1;
        switch (this.getToken((int)n3).tok) {
            case 1073742072: {
                this.restrictSelected(false, false);
                f = 1.0f;
                n2 = 2;
                break;
            }
            case 0x10000D: {
                f = 1.0f;
                n2 = 2;
                break;
            }
            case 0x10000C: {
                f = 0.0f;
                break;
            }
            case 2: {
                int n4 = this.intParameter(n3);
                if (this.tokAt(n3 + 1) != 1666189314) break;
                ++n3;
                this.setShapeProperty(n, "atom", n4);
                this.setShapeProperty(n, "radius", new Float(this.floatParameter(++n3)));
                if (this.tokAt(++n3) == 1766856708) {
                    this.setShapeProperty(n, "colorRGB", this.getArgbParam(++n3));
                    ++n3;
                }
                if (this.getToken((int)n3).tok != 10) {
                    this.error(22);
                }
                this.setShapeProperty(n, "dots", this.statement[n3].value);
                return;
            }
        }
        RadiusData radiusData2 = radiusData = Float.isNaN(f) ? this.encodeRadiusParameter(n3, false) : new RadiusData(f, n2, 0);
        if (Float.isNaN(radiusData.value)) {
            this.error(22);
        }
        this.setShapeSize(n, radiusData);
    }

    private void proteinShape(int n) throws ScriptException {
        int n2 = 0;
        switch (this.getToken((int)1).tok) {
            case 1073742072: {
                if (this.isSyntaxCheck) {
                    return;
                }
                this.restrictSelected(false, false);
                n2 = -1;
                break;
            }
            case 0x10000D: {
                n2 = -1;
                break;
            }
            case 0x10000C: {
                break;
            }
            case 1641025539: {
                n2 = -2;
                break;
            }
            case 1073741922: 
            case 1112541198: {
                n2 = -4;
                break;
            }
            case 2: {
                n2 = this.intParameter(1, 0, 499) * 8;
                break;
            }
            case 3: {
                n2 = (int)(this.floatParameter(1, -4.0f, 4.0f) * 2000.0f);
                if (n2 >= 0) break;
                this.restrictSelected(false, false);
                n2 = -n2;
                break;
            }
            case 10: {
                if (!this.isSyntaxCheck) {
                    this.shapeManager.loadShape(n);
                }
                this.setShapeProperty(n, "bitset", this.theToken.value);
                return;
            }
            default: {
                this.error(6);
            }
        }
        this.setShapeSize(n, n2, null);
    }

    private void animation() throws ScriptException {
        boolean bl = false;
        switch (this.getToken((int)1).tok) {
            case 0x10000D: {
                bl = true;
            }
            case 0x10000C: {
                if (this.isSyntaxCheck) break;
                this.viewer.setAnimationOn(bl);
                break;
            }
            case 4116: {
                this.frame(2);
                break;
            }
            case 1073742022: {
                this.animationMode();
                break;
            }
            case 1073741918: {
                this.animationDirection();
                break;
            }
            case 1074790526: {
                this.setIntProperty("animationFps", this.intParameter(this.checkLast(2)));
                break;
            }
            default: {
                this.frameControl(1);
            }
        }
    }

    private void assign() throws ScriptException {
        Point3f point3f;
        int n = this.tokAt(1);
        int n2 = this.atomExpression(2).nextSetBit(0);
        int n3 = -1;
        String string = null;
        if (n2 < 0) {
            this.error(22);
        }
        if (n == 4106) {
            n3 = this.atomExpression(++this.iToken).nextSetBit(0);
        } else {
            string = this.parameterAsString(++this.iToken);
        }
        Point3f point3f2 = point3f = ++this.iToken < this.statementLength ? this.centerParameter(this.iToken) : null;
        if (this.isSyntaxCheck) {
            return;
        }
        switch (n) {
            case 0x44100001: {
                this.viewer.assignAtom(n2, point3f, string);
                break;
            }
            case 1678770178: {
                this.viewer.assignBond(n2, (string + "p").charAt(0));
                break;
            }
            case 4106: {
                this.viewer.assignConnect(n2, n3);
            }
        }
    }

    private void file() throws ScriptException {
        int n = this.intParameter(this.checkLast(1));
        if (this.isSyntaxCheck) {
            return;
        }
        int n2 = this.viewer.getModelNumberIndex(n * 1000000 + 1, false, false);
        int n3 = -1;
        if (n2 >= 0) {
            n3 = this.viewer.getModelNumberIndex((n + 1) * 1000000 + 1, false, false);
            if (n3 < 0) {
                n3 = this.viewer.getModelCount();
            }
            --n3;
        }
        this.viewer.setAnimationOn(false);
        this.viewer.setAnimationDirection(1);
        this.viewer.setAnimationRange(n2, n3);
        this.viewer.setCurrentModelIndex(-1);
    }

    private void fixed() throws ScriptException {
        BitSet bitSet;
        BitSet bitSet2 = bitSet = this.statementLength == 1 ? null : this.atomExpression(1);
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.setMotionFixedAtoms(bitSet);
    }

    private void frame(int n) throws ScriptException {
        int n2;
        int n3;
        boolean bl = true;
        if (this.statementLength == 1 && n == 1) {
            int n4;
            int n5 = this.viewer.getCurrentModelIndex();
            if (!this.isSyntaxCheck && n5 >= 0 && (n4 = this.viewer.getJmolDataSourceFrame(n5)) >= 0) {
                this.viewer.setCurrentModelIndex(n4 == n5 ? Integer.MIN_VALUE : n4);
            }
            return;
        }
        switch (this.tokAt(1)) {
            case 1073742166: {
                if (this.checkLength23() > 0 && !this.isSyntaxCheck) {
                    this.viewer.setFrameTitle(this.statementLength == 2 ? "@{_modelName}" : this.parameterAsString(2));
                }
                return;
            }
            case 0x40000008: {
                BitSet bitSet;
                BitSet bitSet2 = bitSet = this.statementLength == 2 || this.tokAt(2) == 0x10000B ? null : this.atomExpression(2);
                if (!this.isSyntaxCheck) {
                    this.viewer.setFrameOffsets(bitSet);
                }
                return;
            }
        }
        if (this.getToken((int)n).tok == 0x101000A0) {
            if (this.getToken((int)this.checkLast((int)(++n))).tok != 2 || this.intParameter(n) != 1) {
                this.error(22);
            }
            if (!this.isSyntaxCheck) {
                this.viewer.setAnimation(1073742108);
            }
            return;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int[] nArray = new int[]{-1, -1};
        int n6 = 0;
        block13: for (n3 = n; n3 < this.statementLength; ++n3) {
            switch (this.getToken((int)n3).tok) {
                case 0x100003: 
                case 0x101000B1: {
                    this.checkLength(n + (bl3 ? 2 : 1));
                    bl4 = true;
                    continue block13;
                }
                case 0x101000A0: {
                    if (n6 != 1) {
                        this.error(22);
                    }
                    bl5 = true;
                    continue block13;
                }
                case 0x10000B: {
                    this.checkLength(n + 1);
                    continue block13;
                }
                case 3: {
                    bl = false;
                    if (this.floatParameter(n3) < 0.0f) {
                        bl5 = true;
                    }
                }
                case 2: 
                case 4: {
                    if (n6 == 2) {
                        this.error(22);
                    }
                    int n7 = n2 = this.theTok == 4 ? JmolConstants.modelValue((String)this.theToken.value) : this.theToken.intValue;
                    if (n2 == -1) {
                        this.checkLength(n + 1);
                        if (!this.isSyntaxCheck) {
                            this.viewer.setAnimation(1073742108);
                        }
                        return;
                    }
                    if (n2 >= 1000 && n2 < 1000000 && this.viewer.haveFileSet()) {
                        n2 = n2 / 1000 * 1000000 + n2 % 1000;
                    }
                    if (!bl && n2 == 0) {
                        bl4 = true;
                    }
                    if (n2 >= 1000000) {
                        bl = false;
                    }
                    nArray[n6++] = n2;
                    continue block13;
                }
                case 0x40000110: {
                    bl2 = true;
                    continue block13;
                }
                case 1073742114: {
                    bl3 = true;
                    continue block13;
                }
                default: {
                    this.frameControl(n);
                    return;
                }
            }
        }
        n3 = this.viewer.haveFileSet() ? 1 : 0;
        if (bl3 && n6 == 0) {
            bl4 = true;
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (bl4) {
            this.viewer.setAnimationOn(false);
            this.viewer.setAnimationRange(-1, -1);
            if (!bl3) {
                this.viewer.setCurrentModelIndex(-1);
            }
            return;
        }
        if (n6 == 2 && !bl3) {
            bl5 = true;
        }
        if (n3 != 0) {
            bl = false;
        } else if (bl) {
            for (n2 = 0; n2 < n6; ++n2) {
                if (nArray[n2] < 0) continue;
                int n8 = n2;
                nArray[n8] = nArray[n8] % 1000000;
            }
        }
        n2 = this.viewer.getModelNumberIndex(nArray[0], bl, false);
        int n9 = -1;
        if (n3 != 0 && n6 == 1 && n2 < 0 && nArray[0] != 0) {
            if (nArray[0] < 1000000) {
                nArray[0] = nArray[0] * 1000000;
            }
            if (nArray[0] % 1000000 == 0) {
                nArray[0] = nArray[0] + 1;
                n2 = this.viewer.getModelNumberIndex(nArray[0], false, false);
                if (n2 >= 0) {
                    n9 = this.viewer.getModelNumberIndex(nArray[0] + 1000000, false, false);
                    if (n9 < 0) {
                        n9 = this.viewer.getModelCount();
                    }
                    --n9;
                    if (bl3) {
                        n6 = 2;
                    } else if (!bl5 && n9 != n2) {
                        bl5 = true;
                    }
                    bl3 = bl3 || n2 == n9;
                }
            } else {
                return;
            }
        }
        if (!bl2 && !bl3 || n2 >= 0) {
            this.viewer.setCurrentModelIndex(n2, false);
        }
        if (bl2 && n6 == 2 || bl3 || bl5) {
            if (n9 < 0) {
                n9 = this.viewer.getModelNumberIndex(nArray[1], bl, false);
            }
            this.viewer.setAnimationOn(false);
            this.viewer.setAnimationDirection(1);
            this.viewer.setAnimationRange(n2, n9);
            this.viewer.setCurrentModelIndex(bl5 && !bl3 ? -1 : (n2 >= 0 ? n2 : 0), false);
        }
        if (bl2) {
            this.viewer.setAnimation(266286);
        }
    }

    BitSet bitSetForModelFileNumber(int n) {
        int n2;
        BitSet bitSet = new BitSet(this.viewer.getAtomCount());
        if (this.isSyntaxCheck) {
            return bitSet;
        }
        int n3 = this.viewer.getModelCount();
        boolean bl = this.viewer.haveFileSet();
        if (n < 1000000 && bl) {
            n *= 1000000;
        }
        if ((n2 = n % 1000000) == 0) {
            int n4;
            int n5 = this.viewer.getModelNumberIndex(n + 1, false, false);
            if (n5 < 0) {
                return bitSet;
            }
            int n6 = n4 = n == 0 ? n3 : this.viewer.getModelNumberIndex(n + 1000001, false, false);
            if (n5 < 0) {
                n5 = 0;
            }
            if (n4 < 0) {
                n4 = n3;
            }
            if (this.viewer.isTrajectory(n5)) {
                n4 = n5 + 1;
            }
            for (int i = n5; i < n4; ++i) {
                bitSet.or(this.viewer.getModelUndeletedAtomsBitSet(i));
            }
        } else {
            int n7 = this.viewer.getModelNumberIndex(n, false, true);
            if (n7 >= 0) {
                bitSet.or(this.viewer.getModelUndeletedAtomsBitSet(n7));
            }
        }
        return bitSet;
    }

    private void frameControl(int n) throws ScriptException {
        switch (this.getToken((int)this.checkLast((int)n)).tok) {
            case 20486: 
            case 266286: 
            case 1073741942: 
            case 0x400000AA: 
            case 1073742034: 
            case 0x40000110: 
            case 1073742098: 
            case 1073742108: 
            case 1073742126: {
                if (!this.isSyntaxCheck) {
                    this.viewer.setAnimation(this.theTok);
                }
                return;
            }
        }
        this.error(22);
    }

    private int getShapeType(int n) throws ScriptException {
        int n2 = JmolConstants.shapeTokenIndex(n);
        if (n2 < 0) {
            this.error(49);
        }
        return n2;
    }

    private void font(int n, float f) throws ScriptException {
        String string = "SansSerif";
        String string2 = "Plain";
        int n2 = 0;
        float f2 = -1.0f;
        this.iToken = this.statementLength;
        switch (this.iToken) {
            case 6: {
                f2 = this.floatParameter(5);
                if (f2 >= 5.0f) {
                    f2 = this.viewer.getZoomSetting() / f2 / this.viewer.getScalePixelsPerAngstrom(false);
                }
            }
            case 5: {
                if (this.getToken((int)4).tok != 0x40000000) {
                    this.error(22);
                }
                string2 = this.parameterAsString(4);
            }
            case 4: {
                if (this.getToken((int)3).tok != 0x40000000) {
                    this.error(22);
                }
                string = this.parameterAsString(3);
                if (!this.isFloatParameter(2)) {
                    this.error(34);
                }
                f = this.floatParameter(2);
                n = this.getShapeType(this.getToken((int)1).tok);
                break;
            }
            case 3: {
                if (!this.isFloatParameter(2)) {
                    this.error(34);
                }
                if (n == -1) {
                    n = this.getShapeType(this.getToken((int)1).tok);
                    f = this.floatParameter(2);
                    break;
                }
                if (!(f >= 1.0f)) break;
                n2 = 5;
                f += (float)5;
                break;
            }
            default: {
                if (n == 5) {
                    f = 13.0f;
                    break;
                }
                this.error(2);
            }
        }
        if (n == 5) {
            if (f < 0.0f || f >= 1.0f && (f < 6.0f || f > 63.0f)) {
                this.integerOutOfRange(6 - n2, 63 - n2);
            }
            this.setShapeProperty(5, "setDefaults", this.viewer.getNoneSelected());
        }
        if (this.isSyntaxCheck) {
            return;
        }
        Font3D font3D = this.viewer.getFont3D(string, string2, f);
        this.shapeManager.loadShape(n);
        this.setShapeProperty(n, "font", font3D);
        if (f2 >= 0.0f) {
            this.setShapeProperty(n, "scalereference", new Float(f2));
        }
    }

    private void set() throws ScriptException {
        boolean bl;
        int n;
        List<ScriptVariable> list;
        String string;
        if (this.statementLength == 1) {
            this.showString(this.viewer.getAllSettings(null));
            return;
        }
        boolean bl2 = this.parameterAsString(0).equals("set");
        String string2 = this.optParameterAsString(1);
        if (bl2 && this.statementLength == 2 && string2.indexOf("?") >= 0) {
            this.showString(this.viewer.getAllSettings(string2.substring(0, string2.indexOf("?"))));
            return;
        }
        int n2 = this.getToken((int)1).tok;
        int n3 = 0;
        int n4 = Integer.MAX_VALUE;
        boolean bl3 = !this.isSyntaxCheck && !this.tQuiet && this.scriptLevel <= this.scriptReportingLevel && !((String)this.statement[0].value).equals("var");
        switch (n2) {
            case 1611272194: {
                this.axes(2);
                return;
            }
            case 1610616835: {
                this.background(2);
                return;
            }
            case 1679429641: {
                this.boundbox(2);
                return;
            }
            case 1611272213: {
                this.frank(2);
                return;
            }
            case 1610616855: {
                this.history(2);
                return;
            }
            case 1826248716: {
                this.label(2);
                return;
            }
            case 1614417984: {
                this.unitcell(2);
                return;
            }
            case 0x20000008: {
                this.shapeManager.loadShape(8);
                this.setShapeProperty(8, "highlight", this.tokAt(2) == 0x10000C ? null : this.atomExpression(2));
                return;
            }
            case 1610625028: 
            case 1611141171: {
                this.selectionHalo(2);
                return;
            }
            case 536875070: {
                this.timeout(2);
                return;
            }
        }
        switch (n2) {
            case 1641025539: {
                float[] fArray;
                byte by = JmolConstants.getProteinStructureType(this.parameterAsString(2));
                if (by < 1) {
                    this.error(22);
                }
                if ((fArray = this.floatParameterSet(3, 0, Integer.MAX_VALUE)).length % 4 != 0) {
                    this.error(22);
                }
                this.viewer.setStructureList(fArray, by);
                this.checkLast(this.iToken);
                return;
            }
            case 545259526: {
                n4 = this.getArgbParam(2);
                if (!this.isSyntaxCheck) {
                    this.setObjectArgb("axes", n4);
                }
                return;
            }
            case 0x60000001: {
                this.setBondmode();
                return;
            }
            case 0x20000004: {
                if (this.isSyntaxCheck) {
                    return;
                }
                int n5 = this.tokAt(2) == 0x10000C || this.tokAt(2) == 2 && this.intParameter(2) == 0 ? 4 : 5;
                Logger.setLogLevel(n5);
                this.setIntProperty("logLevel", n5);
                if (n5 == 4) {
                    this.viewer.setDebugScript(false);
                    if (bl3) {
                        this.viewer.showParameter("debugScript", true, 80);
                    }
                }
                this.setDebugging();
                if (bl3) {
                    this.viewer.showParameter("logLevel", true, 80);
                }
                return;
            }
            case 537022465: {
                this.setEcho();
                return;
            }
            case 0x60000002: {
                this.font(5, this.checkLength23() == 2 ? 0.0f : this.floatParameter(2));
                return;
            }
            case 1612189718: {
                this.setHbond();
                return;
            }
            case 537006111: 
            case 1746538509: {
                this.setMonitor();
                return;
            }
            case 1611141176: {
                this.setSsbond();
                return;
            }
            case 0x60000005: {
                this.setLabel("toggle");
                return;
            }
            case 0x20000010: {
                this.setUserColors();
                return;
            }
        }
        boolean bl4 = true;
        switch (n2) {
            case 0x22000002: {
                this.setFloatProperty("axesScale", this.floatSetting(2, -100.0f, 100.0f));
                break;
            }
            case 0x20000002: {
                int n6;
                if (this.statementLength <= 2) break;
                String string3 = this.stringSetting(2, false);
                boolean bl5 = false;
                if (string3.indexOf(".") < 0) {
                    n6 = Parser.parseInt(string3);
                    bl5 = true;
                } else {
                    n6 = JmolConstants.modelValue(string3);
                }
                if (this.isSyntaxCheck) {
                    return;
                }
                int n7 = this.viewer.getModelNumberIndex(n6, bl5, true);
                this.viewer.setBackgroundModelIndex(n7);
                return;
            }
            case 545259556: {
                if (this.statementLength <= 2) break;
                String string4 = string = this.statementLength == 3 && JmolConstants.getVdwType(this.parameterAsString(2)) == -1 ? this.stringSetting(2, false) : this.parameterAsString(2);
                if (JmolConstants.getVdwType(string) < 0) {
                    this.error(22);
                }
                this.setStringProperty(string2, string);
                break;
            }
            case 0x20000006: {
                if (this.statementLength <= 2) break;
                list = this.parameterExpressionList(2, 0);
                if (list == null || list.size() == 0) {
                    this.error(22);
                }
                ScriptVariable scriptVariable = list.get(0);
                Point3f point3f = scriptVariable.tok == 8 ? (Point3f)scriptVariable.value : ((n = ScriptVariable.iValue(scriptVariable)) < 555 ? new Point3f() : this.viewer.getSymmetry().ijkToPoint3f(n + 111));
                if (this.isSyntaxCheck) break;
                this.viewer.setDefaultLattice(point3f);
                break;
            }
            case 545259544: 
            case 0x20800020: {
                if (this.statementLength <= 2) break;
                this.theTok = this.tokAt(2);
                string = this.theTok == 1073741992 || this.theTok == 1073742116 ? this.parameterAsString(this.checkLast(2)).toLowerCase() : this.stringSetting(2, false).toLowerCase();
                if (!string.equals("jmol") && !string.equals("rasmol")) {
                    this.error(22);
                }
                this.setStringProperty(string2, string);
                break;
            }
            case 0x2200000C: {
                this.setFloatProperty("dipoleScale", this.floatSetting(2, -10.0f, 10.0f));
                break;
            }
            case 1632634889: {
                n4 = this.intSetting(2);
                if (n4 == Integer.MIN_VALUE) {
                    this.error(22);
                }
                if (!this.isSyntaxCheck) {
                    this.viewer.setFormalCharges(n4);
                }
                return;
            }
            case 553648148: {
                n4 = this.intSetting(2);
                if (this.isSyntaxCheck) break;
                if (n4 != Integer.MIN_VALUE) {
                    this.commandHistoryLevelMax = n4;
                }
                this.setIntProperty(string2, n4);
                break;
            }
            case 545259564: {
                if (this.statementLength <= 2) break;
                this.setStringProperty(string2, this.stringSetting(2, bl2));
                break;
            }
            case 545259568: {
                if (this.statementLength <= 2) break;
                this.setMeasurementUnits(this.stringSetting(2, bl2));
                break;
            }
            case 553648156: {
                this.setIntProperty(string2, this.intSetting(2, Integer.MAX_VALUE, 0, 1000));
                break;
            }
            case 545259569: {
                if (this.statementLength <= 2) break;
                this.setPicking();
                return;
            }
            case 545259570: {
                if (this.statementLength <= 2) break;
                this.setPickingStyle();
                return;
            }
            case 1716520972: {
                break;
            }
            case 553648168: {
                n4 = this.intSetting(2);
                if (this.isSyntaxCheck) break;
                if (n4 != Integer.MIN_VALUE) {
                    this.scriptReportingLevel = n4;
                }
                this.setIntProperty(string2, n4);
                break;
            }
            case 0x22000032: {
                this.setFloatProperty(string2, this.floatSetting(2, 0.0f, 10.0f));
                break;
            }
            case 0x2000000C: 
            case 0x21000002: 
            case 553648142: 
            case 553648174: {
                n4 = this.intSetting(2);
                if (n2 == 0x2000000C) {
                    if (n4 == Integer.MIN_VALUE || n4 == 0 || n4 == 1) {
                        bl4 = false;
                        break;
                    }
                    n2 = 553648174;
                    string2 = "specularPercent";
                }
                this.setIntProperty(string2, this.intSetting(2, n4, 0, 100));
                break;
            }
            case 553648172: 
            case 553648176: {
                n4 = this.intSetting(2);
                if (n2 == 553648176) {
                    if (n4 >= 0) {
                        bl4 = false;
                        break;
                    }
                    n2 = 553648172;
                    string2 = "specularExponent";
                    if (n4 < -10 || n4 > -1) {
                        this.integerOutOfRange(-10, -1);
                    }
                    n4 = -n4;
                }
                this.setIntProperty(string2, this.intSetting(2, n4, 0, 10));
                break;
            }
            case 553648178: 
            case 553648180: 
            case 553648182: 
            case 1650071565: {
                if (n2 == 1650071565) {
                    n2 = 553648178;
                    string2 = "strandCount";
                }
                this.setIntProperty(string2, this.intSetting(2, Integer.MAX_VALUE, 0, 20));
                break;
            }
            default: {
                bl4 = false;
            }
        }
        if (bl4 && !bl3) {
            return;
        }
        boolean bl6 = bl = !bl4 && !bl2 && this.getContextVariableAsVariable(string2) != null;
        if (!bl4 && !bl) {
            switch (n2) {
                case 1678770178: {
                    n3 = 603979928;
                    break;
                }
                case 0x60300003: {
                    n3 = 603979908;
                    break;
                }
                case 1613758468: {
                    n3 = 603979910;
                    break;
                }
                case 0x60000003: {
                    n3 = 603979878;
                    break;
                }
                case 1666189314: {
                    n3 = 0x22000032;
                    this.setFloatProperty("solventProbeRadius", this.floatSetting(2, 0.0f, 10.0f));
                    bl4 = true;
                    break;
                }
                case 0x60000004: {
                    n3 = 0x2200002E;
                    break;
                }
                case 1613758475: {
                    n3 = 603979948;
                    break;
                }
                case 1766856708: {
                    n3 = 545259544;
                    break;
                }
                case 1611141175: {
                    string = this.parameterAsString(2).toLowerCase();
                    switch ("x;y;z;fps".indexOf(string + ";")) {
                        case 0: {
                            n3 = 570425398;
                            break;
                        }
                        case 2: {
                            n3 = 570425400;
                            break;
                        }
                        case 4: {
                            n3 = 570425402;
                            break;
                        }
                        case 6: {
                            n3 = 570425396;
                            break;
                        }
                        default: {
                            this.error(50, "set SPIN ", string);
                        }
                    }
                    if (!this.isSyntaxCheck) {
                        this.viewer.setSpin(string, (int)this.floatParameter(this.checkLast(3)));
                    }
                    bl4 = true;
                }
            }
        }
        if (n3 != 0) {
            n2 = n3;
            string2 = Token.nameOf(n2);
        } else if (!bl4 && !bl) {
            if (string2.charAt(0) == '_') {
                this.error(22);
            }
            if (((String)((Object)(list = string2.toLowerCase()))).indexOf("label") == 0 && Parser.isOneOf(string2.substring(5).toLowerCase(), "front;group;atom;offset;offsetexact;pointer;alignment;toggle;scalereference") && this.setLabel(string2.substring(5))) {
                return;
            }
            if (((String)((Object)list)).indexOf("callback") >= 0) {
                n2 = 0x20000000;
            }
        }
        if (bl2 && !Token.tokAttr(n2, 0x20000000)) {
            this.iToken = 1;
            if (!this.isStateScript) {
                this.error(50, "SET", string2);
            }
            this.warning(51, "SET", string2);
        }
        if (!bl4 && bl2) {
            switch (this.statementLength) {
                case 2: {
                    this.setBooleanProperty(string2, true);
                    bl4 = true;
                    break;
                }
                case 3: {
                    if (n4 == Integer.MAX_VALUE) break;
                    this.setIntProperty(string2, n4);
                    bl4 = true;
                }
            }
        }
        if (!bl4 && !bl2 && this.tokAt(2) == 0x10000B) {
            if (!this.isSyntaxCheck) {
                this.viewer.removeUserVariable(string2);
            }
            bl4 = true;
        }
        if (!bl4) {
            int n8 = this.tokAt(1) == 0x100001 ? 0 : this.tokAt(2);
            int n9 = this.statement[0].intValue;
            n = n8 == 269484436 ? 3 : (n9 == 61 && !string2.equals("return") && n8 != 269484436 ? 0 : 2);
            this.setVariable(n, 0, string2, n9);
            if (!bl2) {
                return;
            }
        }
        if (bl3) {
            this.viewer.showParameter(string2, true, 80);
        }
    }

    private void setBondmode() throws ScriptException {
        boolean bl = false;
        switch (this.getToken((int)this.checkLast((int)2)).tok) {
            case 0x10100060: {
                break;
            }
            case 0x10100050: {
                bl = true;
                break;
            }
            default: {
                this.error(22);
            }
        }
        this.setBooleanProperty("bondModeOr", bl);
    }

    private void setEcho() throws ScriptException {
        int n;
        String string = "target";
        Object object = null;
        boolean bl = true;
        int n2 = 3;
        switch (this.getToken((int)2).tok) {
            case 0x10000C: {
                this.checkLength(3);
                bl = false;
                string = "allOff";
                break;
            }
            case 12294: 
            case 3145752: {
                string = "hidden";
                object = Boolean.TRUE;
                break;
            }
            case 0x10000D: 
            case 3145751: 
            case 1610625028: {
                string = "hidden";
                object = Boolean.FALSE;
                break;
            }
            case 0x10000B: {
                bl = false;
            }
            case 0x100003: {
                this.checkLength(3);
            }
            case 12289: 
            case 0x40000000: 
            case 0x40000030: 
            case 1073741996: 
            case 1073742128: 
            case 1074790748: {
                object = this.parameterAsString(2);
                break;
            }
            case 1095766028: {
                n = this.modelNumberParameter(3);
                if (this.isSyntaxCheck) {
                    return;
                }
                if (n >= this.viewer.getModelCount()) {
                    this.error(22);
                }
                string = "model";
                object = n;
                n2 = 4;
                break;
            }
            case 1073741978: {
                this.echo(3, true);
                return;
            }
            case 554176525: {
                string = "%zpos";
                object = (int)this.floatParameter(3);
                n2 = 4;
                break;
            }
            case 4: {
                this.echo(2, false);
                return;
            }
            default: {
                if (!Token.tokAttr(this.theTok, 0x40000000)) {
                    this.error(22);
                }
                object = this.parameterAsString(2);
            }
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setEchoStateActive(bl);
            this.shapeManager.loadShape(28);
            this.setShapeProperty(28, string, object);
        }
        if (this.statementLength == n2) {
            return;
        }
        string = "align";
        object = null;
        if (this.statementLength == 4) {
            if (this.isCenterParameter(3)) {
                this.setShapeProperty(28, "xyz", this.centerParameter(3));
                return;
            }
            switch (this.getToken((int)3).tok) {
                case 0x10000C: {
                    string = "off";
                    break;
                }
                case 3145752: {
                    string = "hidden";
                    object = Boolean.TRUE;
                    break;
                }
                case 0x10000D: 
                case 3145751: {
                    string = "hidden";
                    object = Boolean.FALSE;
                    break;
                }
                case 1095766028: {
                    n = this.modelNumberParameter(4);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    if (n >= this.viewer.getModelCount()) {
                        this.error(22);
                    }
                    string = "model";
                    object = n;
                    break;
                }
                case 12289: 
                case 0x40000000: 
                case 0x40000030: 
                case 1073741996: 
                case 1073742128: 
                case 1074790748: {
                    object = this.parameterAsString(3);
                    break;
                }
                default: {
                    if (!Token.tokAttr(this.theTok, 0x40000000)) {
                        this.error(22);
                    }
                    object = this.parameterAsString(3);
                }
            }
            this.setShapeProperty(28, string, object);
            return;
        }
        if (this.statementLength == 5) {
            switch (this.tokAt(3)) {
                case 135271429: {
                    string = "script";
                    object = this.parameterAsString(4);
                    break;
                }
                case 1095766028: {
                    n = this.modelNumberParameter(4);
                    if (!this.isSyntaxCheck && n >= this.viewer.getModelCount()) {
                        this.error(22);
                    }
                    string = "model";
                    object = n;
                    break;
                }
                case 1073741978: {
                    this.echo(4, true);
                    return;
                }
                case 554176525: {
                    string = "%zpos";
                    object = (int)this.floatParameter(4);
                }
            }
            if (object != null) {
                this.setShapeProperty(28, string, object);
                return;
            }
        }
        this.getToken(4);
        n = 3;
        if (this.isCenterParameter(n)) {
            if (!this.isSyntaxCheck) {
                this.setShapeProperty(28, "xyz", this.centerParameter(n));
            }
            return;
        }
        String string2 = "xypos";
        object = this.xypParameter(n);
        if (object == null) {
            int n3 = this.intParameter(n++);
            object = n3;
            string2 = this.tokAt(n) == 269484210 ? "%xpos" : "xpos";
            this.setShapeProperty(28, string2, object);
            int n4 = ++n;
            n3 = this.intParameter(n4);
            object = n3;
            if (this.tokAt(++n) == 269484210) {
                string2 = "%ypos";
                ++n;
            } else {
                string2 = "ypos";
            }
        }
        this.setShapeProperty(28, string2, object);
    }

    private boolean setLabel(String string) throws ScriptException {
        this.shapeManager.loadShape(5);
        Object object = null;
        this.setShapeProperty(5, "setDefaults", this.viewer.getNoneSelected());
        if (string.equals("scalereference")) {
            float f = this.floatParameter(2);
            if (f >= 5.0f) {
                f = this.viewer.getZoomSetting() / f / this.viewer.getScalePixelsPerAngstrom(false);
            }
            object = new Float(f);
        } else if (string.equals("offset") || string.equals("offsetexact")) {
            int n = this.intParameter(2, -127, 127);
            int n2 = this.intParameter(3, -127, 127);
            object = Object2d.getOffset(n, n2);
        } else if (string.equals("alignment")) {
            switch (this.getToken((int)2).tok) {
                case 12289: 
                case 1073741996: 
                case 1073742128: {
                    string = "align";
                    object = this.theToken.value;
                    break;
                }
                default: {
                    this.error(22);
                    break;
                }
            }
        } else if (string.equals("pointer")) {
            int n = 0;
            switch (this.getToken((int)2).tok) {
                case 0x10000B: 
                case 0x10000C: {
                    break;
                }
                case 1610616835: {
                    n |= 2;
                }
                case 0x10000D: {
                    n |= 1;
                    break;
                }
                default: {
                    this.error(22);
                }
            }
            object = n;
        } else {
            boolean bl;
            if (string.equals("toggle")) {
                this.iToken = 1;
                BitSet bitSet = this.statementLength == 2 ? null : this.atomExpression(2);
                this.checkLast(this.iToken);
                if (!this.isSyntaxCheck) {
                    this.viewer.togglePickingLabel(bitSet);
                }
                return true;
            }
            this.iToken = 1;
            boolean bl2 = bl = this.statementLength == 2 || this.getToken((int)2).tok == 0x10000D;
            if (string.equals("front") || string.equals("group")) {
                if (!bl && this.tokAt(2) != 0x10000C) {
                    this.error(22);
                }
                if (!bl) {
                    string = "front";
                }
                object = bl ? Boolean.TRUE : Boolean.FALSE;
            } else if (string.equals("atom")) {
                if (!bl && this.tokAt(2) != 0x10000C) {
                    this.error(22);
                }
                string = "front";
                object = bl ? Boolean.FALSE : Boolean.TRUE;
            } else {
                return false;
            }
        }
        BitSet bitSet = this.iToken + 1 < this.statementLength ? this.atomExpression(++this.iToken) : null;
        this.checkLast(this.iToken);
        if (this.isSyntaxCheck) {
            return true;
        }
        if (bitSet == null) {
            this.setShapeProperty(5, string, object);
        } else {
            this.setShapeProperty(5, string, object, bitSet);
        }
        return true;
    }

    private void setMonitor() throws ScriptException {
        int n = this.tokAt(this.checkLast(2));
        switch (n) {
            case 0x10000C: 
            case 0x10000D: {
                this.setShapeProperty(6, "showMeasurementNumbers", n == 0x10000D ? Boolean.TRUE : Boolean.FALSE);
                return;
            }
            case 2: 
            case 3: 
            case 0x40000066: {
                this.setShapeSize(6, this.getSetAxesTypeMad(2), null);
                return;
            }
        }
        this.setMeasurementUnits(this.parameterAsString(2));
    }

    private boolean setMeasurementUnits(String string) throws ScriptException {
        if (!StateManager.isMeasurementUnit(string)) {
            this.error(50, "set measurementUnits ", string);
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setMeasureDistanceUnits(string);
        }
        return true;
    }

    private void setSsbond() throws ScriptException {
        boolean bl = false;
        switch (this.tokAt(this.checkLast(2))) {
            case 1115297793: {
                bl = true;
                break;
            }
            case 0x30000C: {
                break;
            }
            default: {
                this.error(22);
            }
        }
        this.setBooleanProperty("ssbondsBackbone", bl);
    }

    private void setHbond() throws ScriptException {
        boolean bl = false;
        switch (this.tokAt(this.checkLast(2))) {
            case 1115297793: {
                bl = true;
            }
            case 0x30000C: {
                this.setBooleanProperty("hbondsBackbone", bl);
                break;
            }
            case 1073742151: {
                bl = true;
            }
            case 0x40000066: {
                this.setBooleanProperty("hbondsSolid", bl);
                break;
            }
            default: {
                this.error(22);
            }
        }
    }

    private void setPicking() throws ScriptException {
        if (this.statementLength == 2) {
            this.setStringProperty("picking", "identify");
            return;
        }
        if (this.statementLength > 4 || this.tokAt(2) == 4) {
            this.setStringProperty("picking", this.stringSetting(2, false));
            return;
        }
        int n = 2;
        String string = "SELECT";
        switch (this.getToken((int)2).tok) {
            case 135280131: 
            case 1611141175: 
            case 1746538509: {
                if (this.checkLength34() == 4) {
                    string = this.parameterAsString(2).toUpperCase();
                    if (string.equals("SPIN")) {
                        this.setIntProperty("pickingSpinRate", this.intParameter(3));
                        break;
                    }
                    n = 3;
                }
            }
            case 12291: {
                break;
            }
            default: {
                this.checkLength(3);
            }
        }
        String string2 = this.parameterAsString(n);
        int n2 = ActionManager.getPickingMode(string2);
        switch (this.getToken((int)n).tok) {
            case 0x10000D: 
            case 1073742056: {
                string2 = "identify";
                break;
            }
            case 0x10000B: {
                string2 = "off";
                break;
            }
            case 135280131: {
                string2 = "atom";
                break;
            }
            case 1826248716: {
                string2 = "label";
                break;
            }
            case 1678770178: {
                string2 = "bond";
                break;
            }
            case 12291: {
                this.checkLength(4);
                if (this.tokAt(3) != 1678770178) {
                    this.error(22);
                }
                string2 = "deleteBond";
            }
        }
        n2 = string2.indexOf("_");
        n2 = n2 >= 0 ? n2 : string2.length();
        n2 = ActionManager.getPickingMode(string2.substring(0, n2));
        if (n2 < 0) {
            this.error(50, "SET PICKING " + string, string2);
        }
        this.setStringProperty("picking", string2);
    }

    private void setPickingStyle() throws ScriptException {
        if (this.statementLength > 4 || this.tokAt(2) == 4) {
            this.setStringProperty("pickingStyle", this.stringSetting(2, false));
            return;
        }
        int n = 2;
        boolean bl = false;
        String string = "SELECT";
        switch (this.getToken((int)2).tok) {
            case 1746538509: {
                bl = true;
                string = "MEASURE";
            }
            case 135280131: {
                if (this.checkLength34() != 4) break;
                n = 3;
                break;
            }
            default: {
                this.checkLength(3);
            }
        }
        String string2 = this.parameterAsString(n);
        switch (this.getToken((int)n).tok) {
            case 0x10000B: 
            case 0x10000C: {
                string2 = bl ? "measureoff" : "toggle";
                break;
            }
            case 0x10000D: {
                if (!bl) break;
                string2 = "measure";
            }
        }
        if (ActionManager.getPickingStyle(string2) < 0) {
            this.error(50, "SET PICKINGSTYLE " + string, string2);
        }
        this.setStringProperty("pickingStyle", string2);
    }

    private void timeout(int n) throws ScriptException {
        String string = null;
        String string2 = null;
        int n2 = 0;
        if (this.statementLength == n) {
            this.showString(this.viewer.showTimeout(null));
            return;
        }
        block6: for (int i = n; i < this.statementLength; ++i) {
            switch (this.getToken((int)i).tok) {
                case 1074790550: {
                    string = this.parameterAsString(++i);
                    continue block6;
                }
                case 0x10000C: {
                    continue block6;
                }
                case 2: {
                    n2 = this.intParameter(i);
                    continue block6;
                }
                case 3: {
                    n2 = (int)(this.floatParameter(i) * 1000.0f);
                    continue block6;
                }
                default: {
                    if (string == null) {
                        string = this.parameterAsString(i);
                        continue block6;
                    }
                    if (string2 == null) {
                        string2 = this.parameterAsString(i);
                        continue block6;
                    }
                    this.error(22);
                }
            }
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setTimeout(string, n2, string2);
        }
    }

    private void setUserColors() throws ScriptException {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 2; n < this.statementLength; ++n) {
            int n2 = this.getArgbParam(n);
            arrayList.add(n2);
            n = this.iToken;
        }
        if (this.isSyntaxCheck) {
            return;
        }
        n = arrayList.size();
        int[] nArray = new int[n];
        int n3 = n;
        while (--n3 >= 0) {
            nArray[n3] = (Integer)arrayList.get(n3);
        }
        this.viewer.setUserScale(nArray);
    }

    private void setVariable(int n, int n2, String string, int n3) throws ScriptException {
        boolean bl;
        Object object;
        boolean bl2;
        BitSet bitSet = null;
        String string2 = "";
        int n4 = 0;
        boolean bl3 = this.statement[0].intValue == 91;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = string.startsWith("property_");
        ScriptVariable scriptVariable = bl6 ? null : this.getContextVariableAsVariable(string);
        boolean bl7 = bl2 = scriptVariable != null;
        if (n > 0 && this.tokAt(n - 1) == 0x100001) {
            bitSet = this.atomExpression(n - 1);
            n = this.iToken + 1;
            bl5 = true;
        }
        if (this.tokAt(n) == 0x100008) {
            bl4 = true;
            if ((object = this.getBitsetPropertySelector(++n, true)) == null) {
                this.error(22);
            }
            if (this.tokAt(++n) != 269484436) {
                this.error(22);
            }
            ++n;
            n4 = ((ScriptVariable)object).intValue;
            string2 = (String)((ScriptVariable)object).value;
        }
        if (bl5 && !bl4) {
            this.error(22);
        }
        if ((object = (List)this.parameterExpression(n, n2, string, true, true, -1, bl3, null, null)) == null) {
            return;
        }
        int n5 = object.size();
        if (n5 == 0 || !bl3 && n5 > 1 || bl3 && n5 != 3) {
            this.error(22);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        ScriptVariable scriptVariable2 = (ScriptVariable)object.get(bl3 ? 2 : 0);
        boolean bl8 = bl = !bl2 && !bl5 && !bl6 && (bl3 || bl4 || !(scriptVariable2.value instanceof String) && scriptVariable2.tok != 2 && !(scriptVariable2.value instanceof Integer) && !(scriptVariable2.value instanceof Float) && !(scriptVariable2.value instanceof Boolean));
        if (bl) {
            scriptVariable = this.viewer.getOrSetNewVariable(string, true);
            if (scriptVariable == null) {
                this.error(22);
            }
            bl2 = true;
        }
        if (bl3) {
            ScriptVariable scriptVariable3 = (ScriptVariable)object.get(0);
            if (scriptVariable.tok == 6 || scriptVariable.tok == 10) {
                if (scriptVariable.tok == 10) {
                    scriptVariable.tok = 6;
                    scriptVariable.value = new Hashtable();
                }
                String string3 = ScriptVariable.sValue(scriptVariable3);
                ((Map)scriptVariable.value).put(string3, scriptVariable2);
            } else {
                int n6 = ScriptVariable.iValue(scriptVariable3);
                scriptVariable.setSelectedValue(n6, scriptVariable2);
            }
            return;
        }
        if (bl4) {
            if (!bl5 && (bitSet = ScriptVariable.getBitSet(scriptVariable, true)) == null) {
                this.error(22);
            }
            if (string2.startsWith("property_")) {
                this.viewer.setData(string2, new Object[]{string2, ScriptVariable.sValue(scriptVariable2), BitSetUtil.copy(bitSet)}, this.viewer.getAtomCount(), 0, 0, scriptVariable2.tok == 7 ? Integer.MAX_VALUE : Integer.MIN_VALUE, 0);
                return;
            }
            this.setBitsetProperty(bitSet, n4, ScriptVariable.iValue(scriptVariable2), ScriptVariable.fValue(scriptVariable2), scriptVariable2);
            return;
        }
        if (bl2) {
            scriptVariable.set(scriptVariable2);
            return;
        }
        Object object2 = ScriptVariable.oValue(scriptVariable2);
        if (string.startsWith("property_")) {
            int n7 = this.viewer.getAtomCount();
            if (object2 instanceof String[]) {
                object2 = TextFormat.join((String[])object2, '\n', 0);
            }
            this.viewer.setData(string, new Object[]{string, "" + object2, BitSetUtil.copy(this.viewer.getSelectionSet(false))}, n7, 0, 0, Integer.MIN_VALUE, 0);
            return;
        }
        if (object2 instanceof Boolean) {
            this.setBooleanProperty(string, (Boolean)object2);
        } else if (object2 instanceof Integer) {
            this.setIntProperty(string, (Integer)object2);
        } else if (object2 instanceof Float) {
            this.setFloatProperty(string, ((Float)object2).floatValue());
        } else if (object2 instanceof String) {
            this.setStringProperty(string, (String)object2);
        } else if (object2 instanceof Bond.BondSet) {
            this.setStringProperty(string, Escape.escape((BitSet)object2, false));
        } else if (object2 instanceof BitSet) {
            this.setStringProperty(string, Escape.escape((BitSet)object2));
        } else if (object2 instanceof Point3f) {
            String string4 = Escape.escape((Point3f)object2);
            this.setStringProperty(string, string4);
        } else if (object2 instanceof Point4f) {
            String string5 = Escape.escape((Point4f)object2);
            this.setStringProperty(string, string5);
        } else {
            Logger.error("ERROR -- return from propertyExpression was " + object2);
        }
    }

    private void axes(int n) throws ScriptException {
        TickInfo tickInfo = this.checkTicks(n, true, true, false);
        n = this.iToken + 1;
        int n2 = this.tokAt(n);
        String string = this.optParameterAsString(n).toLowerCase();
        if (this.statementLength == n + 1 && Parser.isOneOf(string, "window;unitcell;molecular")) {
            this.setBooleanProperty("axes" + string, true);
            return;
        }
        switch (n2) {
            case 12289: {
                Point3f point3f = this.centerParameter(n + 1);
                this.setShapeProperty(29, "origin", point3f);
                this.checkLast(this.iToken);
                return;
            }
            case 1073742138: {
                this.setFloatProperty("axesScale", this.floatParameter(this.checkLast(++n)));
                return;
            }
            case 1826248716: {
                n2 = this.tokAt(n + 1);
                switch (n2) {
                    case 0x10000C: 
                    case 0x10000D: {
                        this.checkLength(n + 2);
                        this.setShapeProperty(29, "labels" + (n2 == 0x10000D ? "On" : "Off"), null);
                        return;
                    }
                }
                if (this.statementLength == n + 7) {
                    this.setShapeProperty(29, "labels", new String[]{this.parameterAsString(++n), this.parameterAsString(++n), this.parameterAsString(++n), this.parameterAsString(++n), this.parameterAsString(++n), this.parameterAsString(++n)});
                } else {
                    this.checkLength(n + 4);
                    this.setShapeProperty(29, "labels", new String[]{this.parameterAsString(++n), this.parameterAsString(++n), this.parameterAsString(++n)});
                }
                return;
            }
        }
        if (string.equals("position")) {
            Point3f point3f;
            if (this.tokAt(++n) == 0x10000C) {
                point3f = new Point3f();
            } else {
                point3f = this.xypParameter(n);
                if (point3f == null) {
                    this.error(22);
                }
                n = this.iToken;
            }
            this.setShapeProperty(29, "position", point3f);
            return;
        }
        int n3 = this.getSetAxesTypeMad(n);
        if (this.isSyntaxCheck) {
            return;
        }
        this.setObjectMad(29, "axes", n3);
        if (tickInfo != null) {
            this.setShapeProperty(29, "tickInfo", tickInfo);
        }
    }

    private void boundbox(int n) throws ScriptException {
        int n2;
        boolean bl;
        TickInfo tickInfo = this.checkTicks(n, false, true, false);
        n = this.iToken + 1;
        float f = 1.0f;
        if (this.tokAt(n) == 1073742138) {
            f = this.floatParameter(++n);
            if (!this.isSyntaxCheck && f == 0.0f) {
                this.error(22);
            }
            if (++n == this.statementLength) {
                if (!this.isSyntaxCheck) {
                    this.viewer.setBoundBox(null, null, true, f);
                }
                return;
            }
        }
        boolean bl2 = bl = this.tokAt(n) == 0x4000004E;
        if (bl) {
            ++n;
        }
        if (this.isCenterParameter(n)) {
            this.expressionResult = null;
            n2 = n;
            Point3f point3f = this.centerParameter(n);
            n = this.iToken + 1;
            if (bl || this.isCenterParameter(n)) {
                Point3f point3f2 = bl ? this.centerParameter(n) : this.getPoint3f(n, true);
                n = this.iToken + 1;
                if (!this.isSyntaxCheck) {
                    this.viewer.setBoundBox(point3f, point3f2, bl, f);
                }
            } else if (this.expressionResult != null && this.expressionResult instanceof BitSet) {
                if (!this.isSyntaxCheck) {
                    this.viewer.calcBoundBoxDimensions((BitSet)this.expressionResult, f);
                }
            } else if (this.expressionResult == null && this.tokAt(n2) == 0x100007) {
                Point3f[] point3fArray;
                if (this.isSyntaxCheck) {
                    return;
                }
                if ((point3fArray = this.getObjectBoundingBox(this.objectNameParameter(++n2))) == null) {
                    this.error(22);
                }
                this.viewer.setBoundBox(point3fArray[0], point3fArray[1], true, f);
                n = this.iToken + 1;
            } else {
                this.error(22);
            }
            if (n == this.statementLength) {
                return;
            }
        }
        n2 = this.getSetAxesTypeMad(n);
        if (this.isSyntaxCheck) {
            return;
        }
        if (tickInfo != null) {
            this.setShapeProperty(30, "tickInfo", tickInfo);
        }
        this.setObjectMad(30, "boundbox", n2);
    }

    private TickInfo checkTicks(int n, boolean bl, boolean bl2, boolean bl3) throws ScriptException {
        this.iToken = n - 1;
        if (this.tokAt(n) != 1073742164) {
            return null;
        }
        String string = " ";
        switch (this.tokAt(n + 1)) {
            case 1112541203: 
            case 1112541204: 
            case 1112541205: {
                string = this.parameterAsString(++n).toLowerCase();
                break;
            }
            case 0x40000000: {
                this.error(22);
            }
        }
        if (this.tokAt(++n) == 0x10000B) {
            TickInfo tickInfo = new TickInfo(null);
            tickInfo.type = string;
            this.iToken = n;
            return tickInfo;
        }
        TickInfo tickInfo = new TickInfo((Point3f)this.getPointOrPlane(n, false, true, false, false, 3, 3));
        if (this.coordinatesAreFractional || this.tokAt(this.iToken + 1) == 1614417984) {
            tickInfo.scale = new Point3f(Float.NaN, Float.NaN, Float.NaN);
            bl2 = false;
        }
        if (this.tokAt(this.iToken + 1) == 1614417984) {
            ++this.iToken;
        }
        tickInfo.type = string;
        if (this.tokAt(this.iToken + 1) == 1288701960) {
            tickInfo.tickLabelFormats = this.stringParameterSet(this.iToken + 2);
        }
        if (!bl2) {
            return tickInfo;
        }
        if (this.tokAt(this.iToken + 1) == 1073742138) {
            if (this.isFloatParameter(this.iToken + 2)) {
                float f = this.floatParameter(this.iToken + 2);
                tickInfo.scale = new Point3f(f, f, f);
            } else {
                tickInfo.scale = this.getPoint3f(this.iToken + 2, true);
            }
        }
        if (bl3 && this.tokAt(this.iToken + 1) == 1073741942) {
            tickInfo.first = this.floatParameter(this.iToken + 2);
        }
        return tickInfo;
    }

    private void unitcell(int n) throws ScriptException {
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        Point3f point3f = null;
        TickInfo tickInfo = this.checkTicks(n, true, false, false);
        n = this.iToken;
        if (this.statementLength == n + 2) {
            if (this.getToken((int)(n + 1)).tok == 2 && this.intParameter(n + 1) >= 111) {
                n2 = this.intParameter(++n);
            }
        } else if (this.statementLength > n + 1) {
            point3f = (Point3f)this.getPointOrPlane(++n, false, true, false, true, 3, 3);
            n = this.iToken;
        }
        n3 = this.getSetAxesTypeMad(++n);
        this.checkLast(this.iToken);
        if (this.isSyntaxCheck) {
            return;
        }
        if (n2 != Integer.MAX_VALUE) {
            this.viewer.setCurrentUnitCellOffset(n2);
        }
        this.setObjectMad(31, "unitCell", n3);
        if (point3f != null) {
            this.viewer.setCurrentUnitCellOffset(point3f);
        }
        if (tickInfo != null) {
            this.setShapeProperty(31, "tickInfo", tickInfo);
        }
    }

    private void frank(int n) throws ScriptException {
        this.setBooleanProperty("frank", this.booleanParameter(n));
    }

    private void selectionHalo(int n) throws ScriptException {
        boolean bl = false;
        switch (n == this.statementLength ? 0x10000D : this.getToken((int)n).tok) {
            case 0x10000D: 
            case 1114638349: {
                bl = true;
            }
            case 0x10000B: 
            case 0x10000C: 
            case 1073742056: {
                this.setBooleanProperty("selectionHalos", bl);
                break;
            }
            default: {
                this.error(22);
            }
        }
    }

    private void save() throws ScriptException {
        if (this.statementLength > 1) {
            String string = this.optParameterAsString(2);
            switch (this.tokAt(1)) {
                case 1073742132: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveOrientation(string);
                    }
                    return;
                }
                case 1073742078: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveOrientation(string);
                    }
                    return;
                }
                case 1678770178: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveBonds(string);
                    }
                    return;
                }
                case 1073742158: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveState(string);
                    }
                    return;
                }
                case 1641025539: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveStructure(string);
                    }
                    return;
                }
                case 0x100006: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveCoordinates(string, this.viewer.getSelectionSet(false));
                    }
                    return;
                }
                case 1073742140: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveSelection(string);
                    }
                    return;
                }
            }
        }
        this.error(53, "SAVE", "bonds? coordinates? orientation? selection? state? structure?");
    }

    private void restore() throws ScriptException {
        if (this.statementLength > 1) {
            String string = this.optParameterAsString(2);
            if (this.getToken((int)1).tok != 1073742078) {
                this.checkLength23();
            }
            switch (this.getToken((int)1).tok) {
                case 1073742132: {
                    float f;
                    float f2 = f = this.statementLength > 3 ? this.floatParameter(3) : 0.0f;
                    if (f < 0.0f) {
                        this.error(22);
                    }
                    if (!this.isSyntaxCheck) {
                        this.viewer.restoreRotation(string, f);
                    }
                    return;
                }
                case 1073742078: {
                    float f;
                    float f3 = f = this.statementLength > 3 ? this.floatParameter(3) : 0.0f;
                    if (f < 0.0f) {
                        this.error(22);
                    }
                    if (!this.isSyntaxCheck) {
                        this.viewer.restoreOrientation(string, f);
                    }
                    return;
                }
                case 1678770178: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.restoreBonds(string);
                    }
                    return;
                }
                case 0x100006: {
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    String string2 = this.viewer.getSavedCoordinates(string);
                    if (string2 == null) {
                        this.error(22);
                    }
                    this.runScript(string2);
                    this.viewer.checkCoordinatesChanged();
                    return;
                }
                case 1073742158: {
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    String string3 = this.viewer.getSavedState(string);
                    if (string3 == null) {
                        this.error(22);
                    }
                    this.runScript(string3);
                    return;
                }
                case 1641025539: {
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    String string4 = this.viewer.getSavedStructure(string);
                    if (string4 == null) {
                        this.error(22);
                    }
                    this.runScript(string4);
                    return;
                }
                case 1073742140: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.restoreSelection(string);
                    }
                    return;
                }
            }
        }
        this.error(53, "RESTORE", "bonds? coords? orientation? selection? state? structure?");
    }

    String write(Token[] tokenArray) throws ScriptException {
        Object object;
        boolean bl;
        boolean bl2;
        int n = 0;
        int n2 = 0;
        if (tokenArray == null) {
            tokenArray = this.statement;
            n2 = 1;
            n = 1;
            bl2 = true;
            bl = this.viewer.isApplet() && !this.viewer.isSignedApplet();
        } else {
            bl2 = false;
            bl = true;
        }
        int n3 = bl2 ? this.statementLength : tokenArray.length;
        int n4 = bl2 && tokenArray.length == 1 ? 1073741884 : this.tokAt(n, tokenArray);
        int n5 = 0;
        int n6 = -1;
        int n7 = -1;
        int n8 = Integer.MIN_VALUE;
        String string = this.viewer.getExportDriverList();
        String string2 = "SPT";
        String string3 = "";
        String string4 = "";
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String[] stringArray = new String[1];
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        BitSet bitSet = null;
        if (n4 == 4 && (object = Token.getTokenFromName(ScriptVariable.sValue(tokenArray[n]).toLowerCase())) != null) {
            n4 = ((Token)object).tok;
        }
        switch (n4) {
            case 1052714: 
            case 0x8101011: 
            case 1716520972: {
                string9 = this.plot(tokenArray);
                if (bl2) break;
                return string9;
            }
            case 1073742102: {
                string2 = "PGRP";
                string4 = ScriptVariable.sValue(this.tokenAt(++n, tokenArray)).toLowerCase();
                if (!string4.equals("draw")) break;
                ++n;
                break;
            }
            case 135368713: {
                string2 = "FUNCS";
                ++n;
                break;
            }
            case 0x100006: 
            case 135270407: {
                string2 = ScriptVariable.sValue(this.tokenAt(++n, tokenArray)).toLowerCase();
                string2 = "data";
                bl3 = true;
                break;
            }
            case 135271429: 
            case 1073742158: {
                string8 = ScriptVariable.sValue(this.tokenAt(++n, tokenArray)).toLowerCase();
                while (string8.equals("localpath") || string8.equals("remotepath")) {
                    if (string8.equals("localpath")) {
                        string6 = ScriptVariable.sValue(this.tokenAt(++n, tokenArray));
                    } else {
                        string7 = ScriptVariable.sValue(this.tokenAt(++n, tokenArray));
                    }
                    string8 = ScriptVariable.sValue(this.tokenAt(++n, tokenArray)).toLowerCase();
                }
                string2 = "SPT";
                break;
            }
            case 0x121021: {
                string2 = "MO";
                ++n;
                break;
            }
            case 135206: {
                string2 = "PMESH";
                ++n;
                break;
            }
            case 1073742018: {
                string2 = "MESH";
                ++n;
                break;
            }
            case 135197: {
                string2 = "ISO";
                ++n;
                break;
            }
            case 1610616855: {
                string2 = "HIS";
                ++n;
                break;
            }
            case 36868: {
                string2 = "VAR";
                n += 2;
                break;
            }
            case 1229984263: {
                string2 = "FILE";
                ++n;
                break;
            }
            case 4: 
            case 4116: 
            case 0x40000000: 
            case 1073741978: {
                string2 = ScriptVariable.sValue(this.tokenAt(n, tokenArray)).toLowerCase();
                if (n4 == 1073741978) {
                    ++n;
                } else if (n4 == 4116) {
                    if (n + 1 < n3 && tokenArray[++n].tok == 0x100001 || tokenArray[n].tok == 10) {
                        object = this.atomExpression(tokenArray, n, 0, true, false, true, true);
                        n = this.iToken + 1;
                    } else {
                        object = this.viewer.getModelUndeletedAtomsBitSet(-1);
                    }
                    if (!this.isSyntaxCheck) {
                        bitSet = this.viewer.getModelBitSet((BitSet)object, true);
                    }
                } else if (Parser.isOneOf(string2, string.toLowerCase())) {
                    ++n;
                    string2 = string2.substring(0, 1).toUpperCase() + string2.substring(1);
                    bl4 = true;
                    string5 = "Jmol." + string2;
                } else if (string2.equals("menu")) {
                    ++n;
                    string2 = "MENU";
                } else if (string2.equals("zip")) {
                    string2 = "ZIP";
                    ++n;
                } else if (string2.equals("zipall")) {
                    string2 = "ZIPALL";
                    ++n;
                } else {
                    string2 = "(image)";
                }
                if (this.tokAt(n, tokenArray) != 2) break;
                n6 = ScriptVariable.iValue(this.tokenAt(n++, tokenArray));
                n7 = ScriptVariable.iValue(this.tokenAt(n++, tokenArray));
            }
        }
        if (string9 == null) {
            string8 = ScriptVariable.sValue(this.tokenAt(n, tokenArray));
            if (string8.equalsIgnoreCase("clipboard")) {
                if (this.isSyntaxCheck) {
                    return "";
                }
            } else if (Parser.isOneOf(string8.toLowerCase(), "png;jpg;jpeg;jpg64;jpeg64") && this.tokAt(n + 1, tokenArray) == 2) {
                n8 = ScriptVariable.iValue(this.tokenAt(++n, tokenArray));
            } else if (Parser.isOneOf(string8.toLowerCase(), "xyz;mol;pdb;cml")) {
                string2 = string8.toUpperCase();
                if (n + 1 == n3) {
                    ++n;
                }
            }
            if (string2.equals("(image)") && Parser.isOneOf(string8.toUpperCase(), "GIF;JPG;JPG64;JPEG;JPEG64;PNG;PPM")) {
                string2 = string8.toUpperCase();
                ++n;
            }
            if (n + 2 == n3 && (string3 = ScriptVariable.sValue(this.tokenAt(++n, tokenArray))).length() > 0 && string3.charAt(0) != '.') {
                string2 = string8.toUpperCase();
            }
            switch (this.tokAt(n, tokenArray)) {
                case 0: {
                    bl = true;
                    break;
                }
                case 1073741884: {
                    break;
                }
                case 4: 
                case 0x40000000: {
                    string5 = ScriptVariable.sValue(this.tokenAt(n, tokenArray));
                    if (n == n3 - 3 && this.tokAt(n + 1, tokenArray) == 0x100008) {
                        string5 = string5 + "." + ScriptVariable.sValue(this.tokenAt(n + 2, tokenArray));
                    }
                    if (string2 != "VAR" && n == n2) {
                        string2 = "image";
                    } else if (string5.length() > 0 && string5.charAt(0) == '.' && (n == n2 + 1 || n == n2 + 2)) {
                        string5 = ScriptVariable.sValue(this.tokenAt(n - 1, tokenArray)) + string5;
                        if (string2 != "VAR" && n == n2 + 1) {
                            string2 = "image";
                        }
                    }
                    if (!string5.equalsIgnoreCase("clipboard")) break;
                    string5 = null;
                    break;
                }
                default: {
                    this.error(22);
                }
            }
            if (string2.equals("image") || string2.equals("frame")) {
                string2 = string5 != null && string5.indexOf(".") >= 0 ? string5.substring(string5.lastIndexOf(".") + 1).toUpperCase() : "JPG";
                if (string2.equals("MNU")) {
                    string2 = "MENU";
                } else if (string2.equals("WRL") || string2.equals("VRML")) {
                    string2 = "Vrml";
                    bl4 = true;
                } else if (string2.equals("X3D")) {
                    string2 = "X3d";
                    bl4 = true;
                } else if (string2.equals("IDTF")) {
                    string2 = "Idtf";
                    bl4 = true;
                } else if (string2.equals("MA")) {
                    string2 = "Maya";
                    bl4 = true;
                } else if (string2.equals("JVXL")) {
                    string2 = "ISOX";
                } else if (string2.equals("XJVXL")) {
                    string2 = "ISOX";
                } else if (string2.equals("MESH")) {
                    string2 = "MESH";
                } else if (string2.equals("JMOL")) {
                    string2 = "ZIPALL";
                }
            }
            if (string2.equals("data")) {
                string2 = string5 != null && string5.indexOf(".") >= 0 ? string5.substring(string5.lastIndexOf(".") + 1).toUpperCase() : "XYZ";
            }
            if ((bl5 = Parser.isOneOf(string2, "GIF;JPEG64;JPEG;JPG64;JPG;PPM;PNG")) && bl) {
                string2 = "JPG64";
            } else if (!(bl5 || bl4 || Parser.isOneOf(string2, "ZIP;ZIPALL;SPT;HIS;MO;ISO;ISOX;MESH;PMESH;VAR;FILE;CML;XYZ;MENU;MOL;PDB;PGRP;QUAT;RAMA;FUNCS;"))) {
                this.error(54, "COORDS|FILE|FUNCTIONS|HISTORY|IMAGE|ISOSURFACE|JMOL|MENU|MO|POINTGROUP|QUATERNION [w,x,y,z] [derivative]|RAMACHANDRAN|SPT|STATE|VAR x|ZIP|ZIPALL  CLIPBOARD", "CML|GIF|JPG|JPG64|JVXL|MESH|MOL|PDB|PMESH|PNG|PPM|SPT|XJVXL|XYZ|ZIP" + string.toUpperCase().replace(';', '|'));
            }
            if (this.isSyntaxCheck) {
                return "";
            }
            string3 = string2.intern();
            object = null;
            boolean bl6 = false;
            if (bl4) {
                stringArray[0] = string5;
                if ((string3 = this.viewer.generateOutput(string3, stringArray, n6, n7)) == null || string3.length() == 0) {
                    return "";
                }
                if (!bl2) {
                    return string3;
                }
                if ((string2.equals("Povray") || string2.equals("Idtf")) && stringArray[0] != null) {
                    String string10 = string2.equals("Idtf") ? ".tex" : ".ini";
                    string5 = stringArray[0] + string10;
                    string9 = this.viewer.createImage(string5, string10, string3, Integer.MIN_VALUE, 0, 0, null, stringArray);
                    if (string2.equals("Idtf")) {
                        string3 = string3.substring(0, string3.indexOf("\\begin{comment}"));
                    }
                    string3 = "Created " + stringArray[0] + ":\n\n" + string3;
                } else {
                    string9 = string3;
                }
                if (string9 != null) {
                    if (!string9.startsWith("OK")) {
                        this.evalError(string9, null);
                    }
                    this.scriptStatusOrBuffer(string3);
                }
                return "";
            }
            if (string3 == "MENU") {
                string3 = this.viewer.getMenu("");
            } else if (string3 == "PGRP") {
                string3 = this.viewer.getPointGroupAsString(string4.equals("draw"), null, 0, 1.0f);
            } else if (string3 == "PDB") {
                if (bl) {
                    string3 = this.viewer.getPdbData(null, null);
                } else {
                    bl6 = true;
                }
            } else if (string3 == "FILE") {
                if (bl) {
                    string3 = this.viewer.getCurrentFileAsString();
                } else {
                    bl6 = true;
                }
                if ("?".equals(string5)) {
                    string5 = "?Jmol." + this.viewer.getParameter("_fileType");
                }
            } else if (string3 == "MOL" && bl3) {
                string3 = this.viewer.getModelExtract("selected", true);
            } else if (string3 == "XYZ" || string3 == "MOL" || string3 == "CML") {
                string3 = this.viewer.getData("selected", string3);
            } else if (string3 == "FUNCS") {
                string3 = this.viewer.getFunctionCalls(null);
                string2 = "TXT";
            } else if (string3 == "VAR") {
                string3 = ScriptVariable.sValue((ScriptVariable)this.getParameter(ScriptVariable.sValue(this.tokenAt(bl2 ? 2 : 1, tokenArray)), true));
                string2 = "TXT";
            } else if (string3 == "SPT") {
                if (bl3) {
                    BitSet bitSet2 = this.viewer.getTaintedAtoms((byte)2);
                    this.viewer.setAtomCoordRelative(new Point3f(0.0f, 0.0f, 0.0f), null);
                    string3 = (String)this.viewer.getProperty("string", "stateInfo", null);
                    this.viewer.setTaintedAtoms(bitSet2, (byte)2);
                } else {
                    string3 = (String)this.viewer.getProperty("string", "stateInfo", null);
                    if (string6 != null || string7 != null) {
                        string3 = FileManager.setScriptFileReferences(string3, string6, string7, null);
                    }
                }
            } else if (string3 == "ZIP" || string3 == "ZIPALL") {
                string3 = (String)this.viewer.getProperty("string", "stateInfo", null);
                object = this.viewer.createImage(string5, string2, string3, Integer.MIN_VALUE, -1, -1);
            } else if (string3 == "HIS") {
                string3 = this.viewer.getSetHistory(Integer.MAX_VALUE);
                string2 = "SPT";
            } else if (string3 == "MO") {
                string3 = this.getMoJvxl(Integer.MAX_VALUE);
                string2 = "XJVXL";
            } else if (string3 == "PMESH") {
                string3 = this.getIsosurfaceJvxl(true, 26);
                if (string3 == null) {
                    this.error(31);
                }
                string2 = "XJVXL";
            } else if (string3 == "ISO" || string3 == "ISOX" || string3 == "MESH") {
                if ((string3 = this.getIsosurfaceJvxl(string3 == "MESH", 23)) == null) {
                    this.error(31);
                }
                String string11 = string2 = string3.indexOf("<?xml") >= 0 ? "XJVXL" : "JVXL";
                if (!bl) {
                    this.showString((String)this.getShapeProperty(23, "jvxlFileInfo"));
                }
            } else {
                n5 = -1;
                if (n8 < 0) {
                    n8 = -1;
                }
            }
            if (string3 == null && !bl6) {
                string3 = "";
            }
            if (n5 == 0 && !bl6) {
                int n9 = object == null ? string3.length() : (n5 = object instanceof String ? ((String)object).length() : ((byte[])object).length);
            }
            if (bl5) {
                this.refresh();
                if (n6 < 0) {
                    n6 = this.viewer.getScreenWidth();
                }
                if (n7 < 0) {
                    n7 = this.viewer.getScreenHeight();
                }
            }
            if (!bl2) {
                return string3;
            }
            if (bl) {
                this.showString(string3);
                return "";
            }
            if (object != null && object instanceof String) {
                this.scriptStatusOrBuffer((String)object);
                return (String)object;
            }
            if (!(object != null || bl5 && string5 == null)) {
                object = string3;
            }
            string9 = bl6 ? this.viewer.streamFileData(string5, string2, string4, 0, null) : this.viewer.createImage(string5, string2, object, n8, n6, n7, bitSet, stringArray);
        }
        if (string9 != null) {
            if (!string9.startsWith("OK")) {
                this.evalError(string9, null);
            }
            this.scriptStatusOrBuffer(string9 + (bl5 ? "; width=" + n6 + "; height=" + n7 : ""));
            return string9;
        }
        return "";
    }

    private void show() throws ScriptException {
        int n;
        String string = null;
        String string2 = this.parameterAsString(1);
        String string3 = null;
        String string4 = null;
        int n2 = 2;
        Token token = this.getToken(1);
        int n3 = n = token instanceof ScriptVariable ? 0 : token.tok;
        if (n == 4 && (token = Token.getTokenFromName(string2.toLowerCase())) != null) {
            n = token.tok;
        }
        if (n != 1297090050 && n != 1073742158) {
            this.checkLength(-3);
        }
        if (this.statementLength == 2 && string2.indexOf("?") >= 0) {
            this.showString(this.viewer.getAllSettings(string2.substring(0, string2.indexOf("?"))));
            return;
        }
        block0 : switch (n) {
            case 0: {
                string3 = Escape.escape(((ScriptVariable)this.theToken).value);
                break;
            }
            case 135267336: {
                this.checkLength(2);
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getSmiles(0, 0, this.viewer.getSelectionSet(false), false, true, false, false);
                break;
            }
            case 1297090050: {
                int n4;
                if (this.statementLength > 3) {
                    Point3f point3f = this.centerParameter(2);
                    Point3f point3f2 = this.centerParameter(++this.iToken);
                    if (!this.isSyntaxCheck) {
                        string3 = this.viewer.getSymmetryOperation(null, 0, point3f, point3f2, false);
                    }
                    n2 = ++this.iToken;
                    break;
                }
                int n5 = n4 = this.checkLength23() == 2 ? 0 : this.intParameter(2);
                if (!this.isSyntaxCheck) {
                    string3 = this.viewer.getSymmetryOperation(null, n4, null, null, false);
                }
                n2 = -3;
                break;
            }
            case 1112541199: {
                if (this.statementLength == 2) {
                    if (!this.isSyntaxCheck) {
                        this.showString(this.viewer.getDefaultVdwTypeNameOrData(-1));
                    }
                    return;
                }
                int n6 = JmolConstants.getVdwType(this.parameterAsString(2));
                if (n6 == -1) {
                    this.error(22);
                }
                if (!this.isSyntaxCheck) {
                    this.showString(this.viewer.getDefaultVdwTypeNameOrData(n6));
                }
                return;
            }
            case 135368713: {
                this.checkLength23();
                if (!this.isSyntaxCheck) {
                    this.showString(this.viewer.getFunctionCalls(this.optParameterAsString(2)));
                }
                return;
            }
            case 1085443: {
                this.checkLength(2);
                if (!this.isSyntaxCheck) {
                    this.showString(this.viewer.getAllSettings(null));
                }
                return;
            }
            case 1074790760: {
                n2 = this.statementLength;
                if (n2 == 2) {
                    if (!this.isSyntaxCheck) {
                        this.viewer.showUrl(this.getFullPathName());
                    }
                    return;
                }
                string4 = this.parameterAsString(2);
                if (!this.isSyntaxCheck) {
                    this.viewer.showUrl(string4);
                }
                return;
            }
            case 1766856708: {
                string2 = "defaultColorScheme";
                break;
            }
            case 0x60000004: {
                string2 = "scaleAngstromsPerInch";
                break;
            }
            case 1052714: 
            case 0x8101011: {
                if (this.isSyntaxCheck) {
                    return;
                }
                int n7 = this.viewer.getCurrentModelIndex();
                if (n7 < 0) {
                    this.error(30, "show " + this.theToken.value);
                }
                string3 = this.plot(this.statement);
                n2 = this.statementLength;
                break;
            }
            case 1113200654: {
                if (this.isSyntaxCheck) break;
                string3 = this.getContext(false);
                break;
            }
            case 0x40000040: {
                string4 = this.optParameterAsString(2);
                if (string4.length() > 0) {
                    n2 = 3;
                }
                if (this.isSyntaxCheck) break;
                string = this.viewer.getColorSchemeList(string4);
                break;
            }
            case 1073742192: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getVariableList() + this.getContext(true);
                break;
            }
            case 0x2000000E: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getTrajectoryInfo();
                break;
            }
            case 553648148: {
                string = "" + this.commandHistoryLevelMax;
                break;
            }
            case 553648150: {
                string = "" + Logger.getLogLevel();
                break;
            }
            case 603979824: {
                string = "" + this.viewer.getDebugScript();
                break;
            }
            case 553648178: {
                string3 = "set strandCountForStrands " + this.viewer.getStrandCount(12) + "; set strandCountForMeshRibbon " + this.viewer.getStrandCount(13);
                break;
            }
            case 536875070: {
                n2 = this.statementLength;
                string3 = this.viewer.showTimeout(n2 == 2 ? null : this.parameterAsString(2));
                break;
            }
            case 0x20000006: {
                string = Escape.escape(this.viewer.getDefaultLattice());
                break;
            }
            case 4126: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getMinimizationInfo();
                break;
            }
            case 1611272194: {
                switch (this.viewer.getAxesMode()) {
                    case 2: {
                        string3 = "set axesUnitcell";
                        break block0;
                    }
                    case 0: {
                        string3 = "set axesWindow";
                        break block0;
                    }
                }
                string3 = "set axesMolecular";
                break;
            }
            case 0x60000001: {
                string3 = "set bondMode " + (this.viewer.getBondSelectionModeOr() ? "OR" : "AND");
                break;
            }
            case 1650071565: {
                if (this.isSyntaxCheck) break;
                string3 = "set strandCountForStrands " + this.viewer.getStrandCount(12) + "; set strandCountForMeshRibbon " + this.viewer.getStrandCount(13);
                break;
            }
            case 1612189718: {
                string3 = "set hbondsBackbone " + this.viewer.getHbondsBackbone() + ";set hbondsSolid " + this.viewer.getHbondsSolid();
                break;
            }
            case 1611141175: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getSpinState();
                break;
            }
            case 1611141176: {
                string3 = "set ssbondsBackbone " + this.viewer.getSsbondsBackbone();
                break;
            }
            case 1610625028: 
            case 1611141171: {
                string3 = "selectionHalos " + (this.viewer.getSelectionHaloEnabled() ? "ON" : "OFF");
                break;
            }
            case 0x60300003: {
                string3 = "set selectHetero " + this.viewer.getRasmolSetting(n);
                break;
            }
            case 0x40000004: {
                string3 = Escape.escapeArray(this.viewer.getAdditionalHydrogens(null, true, true, null));
                break;
            }
            case 1613758468: {
                string3 = "set selectHydrogens " + this.viewer.getRasmolSetting(n);
                break;
            }
            case 0x2000000C: 
            case 0x21000002: 
            case 553648142: 
            case 553648172: 
            case 553648176: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getSpecularState();
                break;
            }
            case 4146: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.listSavedStates();
                break;
            }
            case 1614417984: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getUnitCellInfoText();
                break;
            }
            case 0x100006: {
                n2 = this.statementLength;
                if (n2 == 2) {
                    if (this.isSyntaxCheck) break;
                    string3 = this.viewer.getCoordinateState(this.viewer.getSelectionSet(false));
                    break;
                }
                String string5 = this.parameterAsString(2);
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getSavedCoordinates(string5);
                break;
            }
            case 1073742158: {
                n2 = this.statementLength;
                if (n2 == 2) {
                    if (this.isSyntaxCheck) break;
                    string3 = this.viewer.getStateInfo();
                    break;
                }
                string4 = this.parameterAsString(2);
                if (string4.equals("/") && (n2 = this.statementLength) == 4) {
                    string4 = this.parameterAsString(3);
                    if (this.isSyntaxCheck) break;
                    String[] stringArray = TextFormat.split(this.viewer.getStateInfo(), '\n');
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i].indexOf(string4) < 0) continue;
                        stringBuffer.append(stringArray[i]).append('\n');
                    }
                    string3 = stringBuffer.toString();
                    break;
                }
                n2 = 3;
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getSavedState(string4);
                break;
            }
            case 1641025539: {
                n2 = this.statementLength;
                if (n2 == 2) {
                    if (this.isSyntaxCheck) break;
                    string3 = this.viewer.getProteinStructureState();
                    break;
                }
                String string6 = this.parameterAsString(2);
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getSavedStructure(string6);
                break;
            }
            case 135270407: {
                Object[] objectArray;
                String string7;
                n2 = this.statementLength;
                String string8 = string7 = n2 == 3 ? this.parameterAsString(2) : null;
                if (this.isSyntaxCheck) break;
                Object[] objectArray2 = objectArray = string7 == null ? this.data : this.viewer.getData(string7);
                string3 = objectArray == null ? "no data" : "data \"" + objectArray[0] + "\"\n" + (objectArray[1] instanceof float[] ? Escape.escape((float[])objectArray[1], false) : (objectArray[1] instanceof float[][] ? Escape.escape((float[][])objectArray[1], false) : "" + objectArray[1])) + "\nend \"" + objectArray[0] + "\";";
                break;
            }
            case 1073742152: {
                Map<String, Object> map = null;
                n2 = this.statementLength;
                if (n2 == 2) {
                    if (!this.isSyntaxCheck) {
                        map = this.viewer.getSpaceGroupInfo(null);
                    }
                } else {
                    String string9 = this.parameterAsString(2);
                    if (!this.isSyntaxCheck) {
                        map = this.viewer.getSpaceGroupInfo(TextFormat.simpleReplace(string9, "''", "\""));
                    }
                }
                if (map == null) break;
                string3 = "" + map.get("spaceGroupInfo") + map.get("symmetryInfo");
                break;
            }
            case 0x100007: {
                n2 = 3;
                string3 = this.setObjectProperty();
                break;
            }
            case 1679429641: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getBoundBoxCommand(true);
                break;
            }
            case 12289: {
                if (this.isSyntaxCheck) break;
                string3 = "center " + Escape.escape(this.viewer.getRotationCenter());
                break;
            }
            case 135184: {
                if (this.isSyntaxCheck) break;
                string3 = (String)this.getShapeProperty(22, "command");
                break;
            }
            case 1229984263: {
                if (this.statementLength == 2) {
                    if (!this.isSyntaxCheck) {
                        string3 = this.viewer.getCurrentFileAsString();
                    }
                    if (string3 != null) break;
                    string3 = "<unavailable>";
                    break;
                }
                n2 = 3;
                string = this.parameterAsString(2);
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getFileAsString(string);
                break;
            }
            case 4116: {
                if (this.tokAt(2) == 0x100003) {
                    n2 = 3;
                    if (3 > 0) {
                        string3 = this.viewer.getModelFileInfoAll();
                        break;
                    }
                }
                string3 = this.viewer.getModelFileInfo();
                break;
            }
            case 1610616855: {
                int n8;
                n2 = this.statementLength;
                int n9 = n8 = n2 == 2 ? Integer.MAX_VALUE : this.intParameter(2);
                if (n8 < 1) {
                    this.error(22);
                }
                if (this.isSyntaxCheck) break;
                this.viewer.removeCommand();
                string3 = this.viewer.getSetHistory(n8);
                break;
            }
            case 135197: {
                if (this.isSyntaxCheck) break;
                string3 = (String)this.getShapeProperty(23, "jvxlDataXml");
                break;
            }
            case 0x121021: {
                int n10;
                if (this.optParameterAsString(2).equalsIgnoreCase("list")) {
                    string3 = this.viewer.getMoInfo(-1);
                    n2 = 3;
                    break;
                }
                n2 = this.statementLength;
                int n11 = n10 = n2 == 2 ? Integer.MIN_VALUE : this.intParameter(2);
                if (this.isSyntaxCheck) break;
                string3 = this.getMoJvxl(n10);
                break;
            }
            case 1095766028: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getModelInfoAsString();
                break;
            }
            case 537006111: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getMeasurementInfoAsString();
                break;
            }
            case 4130: 
            case 1073742132: 
            case 1073742178: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getOrientationText(n, null);
                break;
            }
            case 1073742078: {
                n2 = 2;
                if (this.statementLength > 3) break;
                n = this.tokAt(2);
                switch (n) {
                    case 0: 
                    case 4130: 
                    case 1073742132: 
                    case 1073742178: {
                        if (this.isSyntaxCheck) break;
                        string3 = this.viewer.getOrientationText(n, null);
                        break;
                    }
                    default: {
                        string4 = this.optParameterAsString(2);
                        string3 = this.viewer.getOrientationText(0, string4);
                    }
                }
                n2 = this.statementLength;
                break;
            }
            case 1073742088: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getPDBHeader();
                break;
            }
            case 1073742102: {
                this.pointGroup();
                return;
            }
            case 1089470478: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getSymmetryInfoAsString();
                break;
            }
            case 1073742176: {
                if (this.isSyntaxCheck) break;
                string3 = "transform:\n" + this.viewer.getTransformText();
                break;
            }
            case 4168: {
                string3 = "zoom " + (this.viewer.getZoomEnabled() ? "" + this.viewer.getZoomSetting() : "off");
                break;
            }
            case 1611272213: {
                string3 = this.viewer.getShowFrank() ? "frank ON" : "frank OFF";
                break;
            }
            case 1666189314: {
                string2 = "solventProbeRadius";
                break;
            }
            case 1073741864: 
            case 1073741982: 
            case 1073742120: 
            case 0x40D00004: 
            case 1087373318: 
            case 1087373320: 
            case 1114638349: 
            case 0x44100001: 
            case 1678770178: {
                string3 = this.viewer.getChimeInfo(n);
                break;
            }
            case 20482: 
            case 537022465: 
            case 0x60000002: 
            case 1613758475: 
            case 1716520972: {
                string = "?";
                break;
            }
            case 0x40000000: {
                String string10;
                if (string2.equalsIgnoreCase("fileHeader")) {
                    if (this.isSyntaxCheck) break;
                    string3 = this.viewer.getPDBHeader();
                    break;
                }
                if (string2.equalsIgnoreCase("menu")) {
                    if (this.isSyntaxCheck) break;
                    string = this.viewer.getMenu("");
                    break;
                }
                if (!string2.equalsIgnoreCase("mouse")) break;
                n2 = this.statementLength;
                String string11 = string10 = n2 == 2 ? null : this.parameterAsString(2);
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getBindingInfo(string10);
            }
        }
        this.checkLength(n2);
        if (this.isSyntaxCheck) {
            return;
        }
        if (string3 != null) {
            this.showString(string3);
        } else if (string != null) {
            this.showString(string2 + " = " + string);
        } else if (string2 != null) {
            if (string2.indexOf(" ") >= 0) {
                this.showString(string2);
            } else {
                this.showString(string2 + " = " + this.getParameterEscaped(string2));
            }
        }
    }

    private String getIsosurfaceJvxl(boolean bl, int n) {
        if (this.isSyntaxCheck) {
            return "";
        }
        return (String)this.getShapeProperty(n, bl ? "jvxlMeshXml" : "jvxlDataXml");
    }

    private String getMoJvxl(int n) throws ScriptException {
        Integer n2;
        Map map;
        this.shapeManager.loadShape(25);
        int n3 = this.viewer.getCurrentModelIndex();
        if (n3 < 0) {
            this.error(30, "MO isosurfaces");
        }
        if ((map = (Map)this.viewer.getModelAuxiliaryInfo(n3, "moData")) == null) {
            this.error(27);
        }
        if ((n2 = (Integer)this.getShapeProperty(25, "moNumber")) == null || n2 == 0) {
            this.setShapeProperty(25, "init", n3);
            this.setShapeProperty(25, "moData", map);
        } else if (n == Integer.MAX_VALUE) {
            // empty if block
        }
        return (String)this.getShapeProperty(25, "showMO", n);
    }

    private String extractCommandOption(String string) {
        int n = this.fullCommand.indexOf(string + "=");
        return n < 0 ? null : Parser.getNextQuotedString(this.fullCommand, n);
    }

    private void draw() throws ScriptException {
        this.shapeManager.loadShape(22);
        switch (this.tokAt(1)) {
            case 7: {
                if (!this.listIsosurface(22)) break;
                return;
            }
            case 1073742102: {
                this.pointGroup();
                return;
            }
            case 1052714: 
            case 0x8101011: 
            case 137363467: {
                this.plot(this.statement);
                return;
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n = 0;
        float f = Float.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = 0;
        String string = "";
        int n4 = 0;
        Point3f point3f = null;
        String string2 = this.initIsosurface(22);
        boolean bl7 = string2 != null;
        boolean bl8 = bl7 && this.getShapeProperty(22, "ID") == null;
        block59: for (int i = this.iToken; i < this.statementLength; ++i) {
            String string3 = null;
            ArrayList<Object> arrayList = null;
            switch (this.getToken((int)i).tok) {
                case 1614417984: 
                case 1679429641: {
                    if (this.isSyntaxCheck) break;
                    List<Object> list = this.viewer.getPlaneIntersection(this.theTok, null, (float)n3 / 100.0f, 0);
                    n3 = 0;
                    if (list == null) continue block59;
                    string3 = "polygon";
                    arrayList = list;
                    bl = true;
                    break;
                }
                case 1073741990: {
                    switch (this.getToken((int)(++i)).tok) {
                        case 1614417984: 
                        case 1679429641: {
                            n = this.theTok;
                            bl5 = true;
                            continue block59;
                        }
                        case 0x100007: {
                            string3 = "intersect";
                            arrayList = this.objectNameParameter(++i);
                            i = this.iToken;
                            bl5 = true;
                            bl = true;
                            break;
                        }
                        default: {
                            this.error(22);
                            break;
                        }
                    }
                    break;
                }
                case 1073742106: {
                    int n5 = this.intParameter(++i);
                    Point3f[] point3fArray = new Point3f[n5];
                    for (int j = 0; j < n5; ++j) {
                        point3fArray[j] = this.getPoint3f(++this.iToken, true);
                        i = this.iToken;
                    }
                    ArrayList<Object> arrayList2 = new ArrayList<Object>();
                    arrayList2.add(point3fArray);
                    int n6 = this.intParameter(++i);
                    int[][] nArrayArray = new int[n6][];
                    for (int j = 0; j < n6; ++j) {
                        float[] fArray = this.floatParameterSet(++i, 3, 4);
                        nArrayArray[j] = new int[]{(int)fArray[0], (int)fArray[1], (int)fArray[2], fArray.length == 3 ? 7 : (int)fArray[3]};
                        i = this.iToken;
                    }
                    arrayList2.add(nArrayArray);
                    string3 = "polygon";
                    arrayList = arrayList2;
                    bl = true;
                    break;
                }
                case 1297090050: {
                    String string4 = null;
                    int n7 = 0;
                    Point4f point4f = null;
                    Point3f point3f2 = null;
                    switch (this.tokAt(++i)) {
                        case 4: {
                            string4 = this.stringParameter(i);
                            break;
                        }
                        case 12: {
                            string4 = ScriptVariable.sValue(this.getToken(i));
                            break;
                        }
                        default: {
                            if (!this.isCenterParameter(i)) {
                                n7 = this.intParameter(i++);
                            }
                            if (this.isCenterParameter(i)) {
                                point3f = this.centerParameter(i);
                            }
                            if (this.isCenterParameter(this.iToken + 1)) {
                                point3f2 = this.centerParameter(++this.iToken);
                            }
                            if (this.isSyntaxCheck) {
                                return;
                            }
                            i = this.iToken;
                        }
                    }
                    BitSet bitSet = null;
                    if (point3f == null && i + 1 < this.statementLength) {
                        point3f = this.centerParameter(++i);
                        bitSet = this.tokAt(i) == 10 || this.tokAt(i) == 0x100001 ? this.atomExpression(i) : null;
                        i = this.iToken + 1;
                    }
                    this.checkLast(this.iToken);
                    if (!this.isSyntaxCheck) {
                        this.runScript((String)this.viewer.getSymmetryInfo(bitSet, string4, n7, point3f, point3f2, string2, 135184));
                    }
                    return;
                }
                case 4116: {
                    bl6 = true;
                    continue block59;
                }
                case 8: 
                case 9: 
                case 0x10000A: {
                    if (this.theTok == 9 || !this.isPoint3f(i)) {
                        arrayList = this.getPoint4f(i);
                        if (bl6) {
                            this.checkLast(this.iToken);
                            if (!this.isSyntaxCheck) {
                                this.runScript(new Quaternion((Point4f)((Object)arrayList)).draw(string2 == null ? "frame" : string2, " " + string, point3f == null ? new Point3f() : point3f, (float)n3 / 100.0f));
                            }
                            return;
                        }
                        string3 = "planedef";
                    } else {
                        point3f = this.getPoint3f(i, true);
                        arrayList = point3f;
                        string3 = "coord";
                    }
                    i = this.iToken;
                    bl = true;
                    break;
                }
                case 135266319: 
                case 135267841: {
                    Object object;
                    if (!bl && !bl5 && n == 0 && this.theTok != 135267841) {
                        string3 = "plane";
                        break;
                    }
                    Point4f point4f = this.theTok == 135266319 ? this.planeParameter(++i) : this.hklParameter(++i);
                    i = this.iToken;
                    if (n != 0) {
                        if (this.isSyntaxCheck) break;
                        object = this.viewer.getPlaneIntersection(n, point4f, (float)n3 / 100.0f, 0);
                        n3 = 0;
                        if (object == null) continue block59;
                        string3 = "polygon";
                        arrayList = object;
                    } else {
                        arrayList = point4f;
                        string3 = "planedef";
                    }
                    bl = true;
                    break;
                }
                case 0x400000B0: {
                    string3 = "lineData";
                    arrayList = (ArrayList<Object>)this.floatParameterSet(++i, 0, Integer.MAX_VALUE);
                    i = this.iToken;
                    bl = true;
                    break;
                }
                case 10: 
                case 0x100001: {
                    string3 = "atomSet";
                    arrayList = this.atomExpression(i);
                    if (bl6) {
                        point3f = this.centerParameter(i);
                    }
                    i = this.iToken;
                    bl = true;
                    break;
                }
                case 7: {
                    string3 = "modelBasedPoints";
                    arrayList = this.theToken.value;
                    bl = true;
                    break;
                }
                case 0x10100030: {
                    break;
                }
                case 0x10100040: {
                    arrayList = this.xypParameter(i);
                    if (arrayList != null) {
                        i = this.iToken;
                        string3 = "coord";
                        bl = true;
                        break;
                    }
                    if (bl3) {
                        this.error(22);
                    }
                    bl3 = true;
                    break;
                }
                case 0x10100041: {
                    if (!bl3) {
                        this.error(22);
                    }
                    bl3 = false;
                    break;
                }
                case 1141899269: {
                    string3 = "reverse";
                    break;
                }
                case 4: {
                    arrayList = this.stringParameter(i);
                    string3 = "title";
                    break;
                }
                case 135233: {
                    string3 = "vector";
                    break;
                }
                case 1141899267: {
                    arrayList = new Float(this.floatParameter(++i));
                    string3 = "length";
                    break;
                }
                case 3: {
                    arrayList = new Float(this.floatParameter(i));
                    string3 = "length";
                    break;
                }
                case 1095761933: {
                    string3 = "modelIndex";
                    arrayList = this.intParameter(++i);
                    break;
                }
                case 2: {
                    if (bl3) {
                        string3 = "modelIndex";
                        arrayList = this.intParameter(i);
                        break;
                    }
                    n3 = this.intParameter(i);
                    break;
                }
                case 1073742138: {
                    if (++i >= this.statementLength) {
                        this.error(34);
                    }
                    switch (this.getToken((int)i).tok) {
                        case 2: {
                            n3 = this.intParameter(i);
                            continue block59;
                        }
                        case 3: {
                            n3 = (int)(this.floatParameter(i) * 100.0f);
                            continue block59;
                        }
                        default: {
                            this.error(34);
                            break;
                        }
                    }
                    break;
                }
                case 1074790550: {
                    string2 = this.setShapeId(22, ++i, bl7);
                    bl8 = this.getShapeProperty(22, "ID") == null;
                    i = this.iToken;
                    break;
                }
                case 0x400000CC: {
                    string3 = "fixed";
                    arrayList = Boolean.FALSE;
                    break;
                }
                case 1060869: {
                    string3 = "fixed";
                    arrayList = Boolean.TRUE;
                    break;
                }
                case 1073742066: {
                    Object object = this.getPoint3f(++i, true);
                    i = this.iToken;
                    string3 = "offset";
                    arrayList = object;
                    break;
                }
                case 1073741906: {
                    string3 = "crossed";
                    break;
                }
                case 1073742196: {
                    arrayList = new Float(this.floatParameter(++i));
                    string3 = "width";
                    string = string3 + " " + arrayList;
                    break;
                }
                case 1073741998: {
                    string3 = "line";
                    arrayList = Boolean.TRUE;
                    break;
                }
                case 0x40000054: {
                    string3 = "curve";
                    break;
                }
                case 0x40100010: {
                    string3 = "arc";
                    break;
                }
                case 1073741846: {
                    string3 = "arrow";
                    break;
                }
                case 1073741880: {
                    string3 = "circle";
                    break;
                }
                case 1073741912: {
                    string3 = "cylinder";
                    break;
                }
                case 1073742194: {
                    string3 = "vertices";
                    break;
                }
                case 0x400000E0: {
                    string3 = "nohead";
                    break;
                }
                case 1073742130: {
                    string3 = "rotate45";
                    break;
                }
                case 1073742092: {
                    string3 = "perp";
                    break;
                }
                case 1073741916: {
                    float f2 = this.floatParameter(++i);
                    arrayList = new Float(f2);
                    string3 = this.tokAt(i) == 3 ? "width" : "diameter";
                    string = string3 + (this.tokAt(i) == 3 ? " " + f2 : " " + (int)f2);
                    break;
                }
                case 0x100007: {
                    if (this.tokAt(i + 2) == 0x10100040 || bl6) {
                        Point3f point3f3 = point3f = this.centerParameter(i);
                        i = this.iToken;
                        string3 = "coord";
                        arrayList = point3f3;
                        bl = true;
                        break;
                    }
                    arrayList = this.objectNameParameter(++i);
                    string3 = "identifier";
                    bl = true;
                    break;
                }
                case 1073742074: 
                case 1073742180: 
                case 1766856708: {
                    if (this.theTok != 1766856708) {
                        --i;
                    }
                    if (this.tokAt(i + 1) == 1073742180) {
                        bl4 = true;
                        if (this.isFloatParameter(++i + 1)) {
                            f = this.getTranslucentLevel(++i);
                        }
                    } else if (this.tokAt(i + 1) == 1073742074) {
                        ++i;
                        bl4 = true;
                        f = 0.0f;
                    }
                    if (this.isColorParam(i + 1)) {
                        n2 = this.getArgbParam(++i);
                        i = this.iToken;
                    } else if (!bl4) {
                        this.error(22);
                    }
                    bl7 = true;
                    continue block59;
                }
                default: {
                    if (!this.setMeshDisplayProperty(22, 0, this.theTok)) {
                        if (this.theTok == 0x101000B1 || Token.tokAttr(this.theTok, 0x40000000)) {
                            string2 = this.setShapeId(22, i, bl7);
                            i = this.iToken;
                            break;
                        }
                        this.error(22);
                    }
                    if (n4 == 0) {
                        n4 = i;
                    }
                    i = this.iToken;
                    continue block59;
                }
            }
            boolean bl9 = bl7 = this.theTok != 12291;
            if (bl && !bl2 && !bl6) {
                this.setShapeProperty(22, "points", n3);
                bl2 = true;
                n3 = 0;
            }
            if (bl && bl8) {
                this.error(22);
            }
            if (string3 == null) continue;
            this.setShapeProperty(22, string3, arrayList);
        }
        if (bl) {
            this.setShapeProperty(22, "set", null);
        }
        if (n2 != Integer.MIN_VALUE) {
            this.setShapeProperty(22, "color", n2);
        }
        if (bl4) {
            this.setShapeTranslucency(22, "", "translucent", f, null);
        }
        if (n3 != 0) {
            this.setShapeProperty(22, "scale", n3);
        }
        if (n4 > 0 && !this.setMeshDisplayProperty(22, n4, this.getToken((int)n4).tok)) {
            this.error(22);
        }
    }

    private void polyhedra() throws ScriptException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n = 0;
        this.shapeManager.loadShape(21);
        this.setShapeProperty(21, "init", null);
        String string = "centers";
        String string2 = "radius_";
        boolean bl6 = false;
        float f = Float.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        block14: for (int i = 1; i < this.statementLength; ++i) {
            if (this.isColorParam(i)) {
                n2 = this.getArgbParam(i);
                i = this.iToken;
                continue;
            }
            String string3 = null;
            Object object = null;
            switch (this.getToken((int)i).tok) {
                case 12291: 
                case 0x10000C: 
                case 0x10000D: {
                    if (i + 1 != this.statementLength || bl || n > 1 || n == 0 && string == "to") {
                        this.error(18);
                    }
                    string3 = this.parameterAsString(i);
                    bl2 = true;
                    break;
                }
                case 0x10100030: 
                case 269484436: {
                    continue block14;
                }
                case 1678770178: {
                    if (n > 0) {
                        this.error(23);
                    }
                    bl = true;
                    string3 = "bonds";
                    break;
                }
                case 1666189314: {
                    string2 = "radius";
                    continue block14;
                }
                case 2: 
                case 3: {
                    if (n > 0 && !bl5) {
                        this.error(23);
                    }
                    if (this.theTok == 2 && string2 == "radius_") {
                        string3 = "nVertices";
                        object = this.intParameter(i);
                        bl = true;
                        break;
                    }
                    string3 = string2 == "radius_" ? "radius" : string2;
                    object = new Float(this.floatParameter(i));
                    string2 = "radius_";
                    bl5 = false;
                    bl = true;
                    break;
                }
                case 10: 
                case 0x100001: {
                    if (bl3) {
                        this.error(23);
                    }
                    if (++n > 2) {
                        this.error(2);
                    }
                    if (string == "to") {
                        bl = true;
                    }
                    string3 = string;
                    string = "to";
                    object = this.atomExpression(i);
                    i = this.iToken;
                    break;
                }
                case 1074790746: {
                    if (n > 1) {
                        this.error(23);
                    }
                    if (this.getToken((int)(i + 1)).tok == 10) {
                        string3 = "toBitSet";
                        object = this.getToken((int)(++i)).value;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.error(19);
                    }
                    string = "to";
                    continue block14;
                }
                case 1073741937: {
                    if (!bl) {
                        this.error(19);
                    }
                    string2 = "faceCenterOffset";
                    bl5 = true;
                    continue block14;
                }
                case 0x40000064: {
                    if (!bl) {
                        this.error(19);
                    }
                    string2 = "distanceFactor";
                    bl5 = true;
                    continue block14;
                }
                case 1073742074: 
                case 1073742180: 
                case 1766856708: {
                    bl6 = false;
                    if (this.theTok != 1766856708) {
                        --i;
                    }
                    if (this.tokAt(i + 1) == 1073742180) {
                        ++i;
                        bl6 = true;
                        if (this.isFloatParameter(++i)) {
                            f = this.getTranslucentLevel(i);
                        }
                    } else if (this.tokAt(i + 1) == 1073742074) {
                        ++i;
                        bl6 = true;
                        f = 0.0f;
                    }
                    if (this.isColorParam(i + 1)) {
                        n2 = this.getArgbParam(i);
                        i = this.iToken;
                        continue block14;
                    }
                    if (bl6) continue block14;
                    this.error(22);
                    continue block14;
                }
                case 1073741886: 
                case 1073741948: {
                    string3 = "collapsed";
                    Object object2 = object = this.theTok == 1073741886 ? Boolean.TRUE : Boolean.FALSE;
                    if (bl3) {
                        this.error(18);
                    }
                    bl3 = true;
                    break;
                }
                case 1073741934: 
                case 0x40000084: 
                case 1073742044: {
                    if (bl4) {
                        this.error(18);
                    }
                    string3 = this.parameterAsString(i);
                    bl4 = true;
                    break;
                }
                default: {
                    this.error(22);
                }
            }
            this.setShapeProperty(21, string3, object);
            if (!bl2) continue;
            return;
        }
        if (!(bl || bl3 || bl4)) {
            this.error(19);
        }
        if (bl) {
            this.setShapeProperty(21, "generate", null);
        }
        if (n2 != Integer.MIN_VALUE) {
            this.setShapeProperty(21, "colorThis", n2);
        }
        if (bl6) {
            this.setShapeTranslucency(21, "", "translucent", f, null);
        }
    }

    private void lcaoCartoon() throws ScriptException {
        this.shapeManager.loadShape(24);
        if (this.tokAt(1) == 7 && this.listIsosurface(24)) {
            return;
        }
        this.setShapeProperty(24, "init", this.fullCommand);
        if (this.statementLength == 1) {
            this.setShapeProperty(24, "lcaoID", null);
            return;
        }
        boolean bl = false;
        String string = null;
        block24: for (int i = 1; i < this.statementLength; ++i) {
            String string2 = null;
            Object object = null;
            switch (this.getToken((int)i).tok) {
                case 554176565: 
                case 1074790450: {
                    string2 = (String)this.theToken.value;
                    if (this.tokAt(i + 1) == 0x10000C) {
                        this.iToken = i + 1;
                    }
                    object = this.getCapSlabObject(null, i);
                    i = this.iToken;
                    break;
                }
                case 12289: {
                    this.isosurface(24);
                    return;
                }
                case 528432: {
                    float f = 0.0f;
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    switch (this.getToken((int)(++i)).tok) {
                        case 1112541203: {
                            f = this.floatParameter(++i) * ((float)Math.PI / 180);
                            break;
                        }
                        case 1112541204: {
                            f2 = this.floatParameter(++i) * ((float)Math.PI / 180);
                            break;
                        }
                        case 1112541205: {
                            f3 = this.floatParameter(++i) * ((float)Math.PI / 180);
                            break;
                        }
                        default: {
                            this.error(22);
                        }
                    }
                    string2 = "rotationAxis";
                    object = new Vector3f(f, f2, f3);
                    break;
                }
                case 0x10000D: 
                case 3145751: 
                case 1610625028: {
                    string2 = "on";
                    break;
                }
                case 12294: 
                case 0x10000C: 
                case 3145752: {
                    string2 = "off";
                    break;
                }
                case 12291: {
                    string2 = "delete";
                    break;
                }
                case 10: 
                case 0x100001: {
                    string2 = "select";
                    object = this.atomExpression(i);
                    i = this.iToken;
                    break;
                }
                case 1766856708: {
                    string = this.setColorOptions(null, i + 1, 24, -2);
                    if (string != null) {
                        this.setShapeProperty(24, "settranslucency", string);
                    }
                    i = this.iToken;
                    bl = true;
                    continue block24;
                }
                case 1073742074: 
                case 1073742180: {
                    this.setMeshDisplayProperty(24, i, this.theTok);
                    i = this.iToken;
                    bl = true;
                    continue block24;
                }
                case 4: 
                case 1113200651: {
                    object = this.parameterAsString(i).toLowerCase();
                    if (object.equals("spacefill")) {
                        object = "cpk";
                    }
                    string2 = "create";
                    if (!this.optParameterAsString(i + 1).equalsIgnoreCase("molecular")) break;
                    ++i;
                    string2 = "molecular";
                    break;
                }
                case 135280131: {
                    if (this.tokAt(i + 1) == 10 || this.tokAt(i + 1) == 0x100001) {
                        string2 = "select";
                        object = this.atomExpression(i + 1);
                        i = this.iToken;
                        break;
                    }
                    string2 = "selectType";
                    if (!(object = this.parameterAsString(++i)).equals("spacefill")) break;
                    object = "cpk";
                    break;
                }
                case 1073742138: {
                    string2 = "scale";
                    object = new Float(this.floatParameter(++i));
                    break;
                }
                case 0x400000B4: 
                case 1073742006: {
                    string2 = "lonePair";
                    break;
                }
                case 1073742110: 
                case 1073742112: {
                    string2 = "radical";
                    break;
                }
                case 1073742030: {
                    string2 = "molecular";
                    break;
                }
                case 0x40000050: {
                    object = this.parameterAsString(++i);
                    string2 = "create";
                    if (!this.optParameterAsString(i + 1).equalsIgnoreCase("molecular")) break;
                    ++i;
                    string2 = "molecular";
                    break;
                }
                case 1074790550: {
                    object = this.getShapeNameParameter(++i);
                    i = this.iToken;
                    if (bl) {
                        this.error(22);
                    }
                    string2 = "lcaoID";
                    break;
                }
                default: {
                    if (this.theTok != 0x101000B1 && !Token.tokAttr(this.theTok, 0x40000000)) break;
                    if (this.theTok != 0x101000B1) {
                        object = this.parameterAsString(i);
                    }
                    if (bl) {
                        this.error(22);
                    }
                    string2 = "lcaoID";
                }
            }
            if (this.theTok != 12291) {
                bl = true;
            }
            if (string2 == null) {
                this.error(22);
            }
            this.setShapeProperty(24, string2, object);
        }
        this.setShapeProperty(24, "clear", null);
    }

    private Object getCapSlabObject(StringBuffer stringBuffer, int n) throws ScriptException {
        Object object = null;
        if (stringBuffer != null) {
            stringBuffer.append(" ").append(this.getToken((int)n).value).append(" ");
        }
        int n2 = this.tokAt(n + 1);
        Point4f point4f = null;
        switch (n2) {
            case 135266322: {
                ++n;
                object = this.getPointArray(++n, 4);
                break;
            }
            case 1679429641: {
                object = BoxInfo.getCriticalPoints(this.viewer.getBoundBoxVertices(), null);
                this.iToken = n + 1;
                break;
            }
            case 1614417984: {
                SymmetryInterface symmetryInterface = this.viewer.getCurrentUnitCell();
                if (symmetryInterface == null) {
                    this.error(22);
                }
                Point3f[] point3fArray = BoxInfo.getCriticalPoints(symmetryInterface.getUnitCellVertices(), symmetryInterface.getCartesianOffset());
                int n3 = (int)symmetryInterface.getUnitCellInfo(6);
                Vector3f vector3f = null;
                Vector3f vector3f2 = null;
                switch (n3) {
                    case 3: {
                        break;
                    }
                    case 1: {
                        vector3f2 = new Vector3f(point3fArray[2]);
                        vector3f2.sub(point3fArray[0]);
                        vector3f2.scale(1000.0f);
                    }
                    case 2: {
                        vector3f = new Vector3f(point3fArray[1]);
                        vector3f.sub(point3fArray[0]);
                        vector3f.scale(1000.0f);
                        point3fArray[0].sub(vector3f);
                        point3fArray[1].scale(2000.0f);
                        if (n3 != 1) break;
                        point3fArray[0].sub(vector3f2);
                        point3fArray[2].scale(2000.0f);
                    }
                }
                object = point3fArray;
                this.iToken = n + 1;
                break;
            }
            default: {
                float f;
                point4f = this.planeParameter(++n);
                float f2 = f = this.isFloatParameter(this.iToken + 1) ? this.floatParameter(++this.iToken) : Float.NaN;
                if (!Float.isNaN(f)) {
                    point4f.w -= f;
                }
                object = point4f;
            }
        }
        if (stringBuffer != null) {
            if (point4f == null) {
                stringBuffer.append("within ").append(Escape.escape(object));
            } else {
                stringBuffer.append(Escape.escape(point4f));
            }
        }
        return object;
    }

    private boolean mo(boolean bl) throws ScriptException {
        int n = Integer.MAX_VALUE;
        BitSet bitSet = this.viewer.getVisibleFramesBitSet();
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        int n2 = 1;
        if (this.tokAt(1) == 1095766028 || this.tokAt(1) == 4116) {
            n2 = this.modelNumberParameter(2);
            if (n2 < 0) {
                this.error(22);
            }
            bitSet.clear();
            bitSet.set(n2);
            n2 = 3;
        }
        int n3 = bitSet.nextSetBit(0);
        while (n3 >= 0) {
            this.shapeManager.loadShape(25);
            if (this.tokAt(n2) == 7 && this.listIsosurface(25)) {
                return true;
            }
            this.setShapeProperty(25, "init", n3);
            String string = null;
            int n4 = (Integer)this.getShapeProperty(25, "moNumber");
            if (bl) {
                return true;
            }
            if (n4 == 0) {
                n4 = Integer.MAX_VALUE;
            }
            String string2 = null;
            Object object = null;
            switch (this.getToken((int)n2).tok) {
                case 2: {
                    n4 = this.intParameter(n2);
                    break;
                }
                case 1073742034: {
                    n4 = 1073742034;
                    break;
                }
                case 1073742108: {
                    n4 = 1073742108;
                    break;
                }
                case 1766856708: {
                    this.setColorOptions(null, n2 + 1, 25, 2);
                    break;
                }
                case 135266319: {
                    string2 = "plane";
                    object = this.planeParameter(n2 + 1);
                    break;
                }
                case 1073742138: {
                    string2 = "scale";
                    object = new Float(this.floatParameter(n2 + 1));
                    break;
                }
                case 1073741910: {
                    if (this.tokAt(n2 + 1) == 0x101000A1) {
                        string2 = "cutoffPositive";
                        object = new Float(this.floatParameter(n2 + 2));
                        break;
                    }
                    string2 = "cutoff";
                    object = new Float(this.floatParameter(n2 + 1));
                    break;
                }
                case 0x20000004: {
                    string2 = "debug";
                    break;
                }
                case 1073742054: {
                    string2 = "plane";
                    break;
                }
                case 1073742104: 
                case 1073742122: {
                    string2 = "resolution";
                    object = new Float(this.floatParameter(n2 + 1));
                    break;
                }
                case 1073742156: {
                    string2 = "squareData";
                    object = Boolean.TRUE;
                    break;
                }
                case 1073742168: {
                    if (n2 + 1 >= this.statementLength || this.tokAt(n2 + 1) != 4) break;
                    string2 = "titleFormat";
                    object = this.parameterAsString(n2 + 1);
                    break;
                }
                case 0x40000094: 
                case 1073742008: {
                    n = this.moOffset(n2);
                    if (n == Integer.MAX_VALUE) {
                        this.error(22);
                    }
                    n4 = 0;
                    break;
                }
                case 0x40000000: {
                    this.error(22);
                }
                default: {
                    int n5 = this.iToken;
                    if (!this.setMeshDisplayProperty(25, 0, this.theTok)) {
                        this.error(22);
                    }
                    this.setShapeProperty(25, "setProperties", arrayList);
                    this.setMeshDisplayProperty(25, n5, this.tokAt(n5));
                    return true;
                }
            }
            if (string2 != null) {
                this.addShapeProperty(arrayList, string2, object);
            }
            if (n4 != Integer.MAX_VALUE) {
                if (this.tokAt(n2 + 1) == 4) {
                    string = this.parameterAsString(n2 + 1);
                }
                this.setCursorWait(true);
                this.setMoData(arrayList, n4, n, n3, string);
                this.addShapeProperty(arrayList, "finalize", null);
            }
            if (arrayList.size() > 0) {
                this.setShapeProperty(25, "setProperties", arrayList);
            }
            arrayList.clear();
            n3 = bitSet.nextSetBit(n3 + 1);
        }
        return true;
    }

    private String setColorOptions(StringBuffer stringBuffer, int n, int n2, int n3) throws ScriptException {
        this.getToken(n);
        String string = "opaque";
        if (this.theTok == 1073742180) {
            string = "translucent";
            if (n3 < 0) {
                float f = this.isFloatParameter(n + 1) ? this.floatParameter(++n) : Float.MAX_VALUE;
                this.setShapeTranslucency(n2, null, "translucent", f, null);
                if (stringBuffer != null) {
                    stringBuffer.append(" translucent");
                    if (f != Float.MAX_VALUE) {
                        stringBuffer.append(" ").append(f);
                    }
                }
            } else {
                this.setMeshDisplayProperty(n2, n, this.theTok);
            }
        } else if (this.theTok == 1073742074) {
            if (n3 >= 0) {
                this.setMeshDisplayProperty(n2, n, this.theTok);
            }
        } else {
            --this.iToken;
        }
        n3 = Math.abs(n3);
        for (int i = 0; i < n3; ++i) {
            if (this.isColorParam(this.iToken + 1)) {
                int n4 = this.getArgbParam(++this.iToken);
                this.setShapeProperty(n2, "colorRGB", n4);
                if (stringBuffer == null) continue;
                stringBuffer.append(" ").append(Escape.escapeColor(n4));
                continue;
            }
            if (this.iToken >= n) break;
            this.error(22);
        }
        return string;
    }

    private int moOffset(int n) throws ScriptException {
        int n2;
        boolean bl = this.getToken((int)n).tok == 0x40000094;
        int n3 = bl ? 0 : 1;
        if ((n2 = this.tokAt(++n)) == 2 && this.intParameter(n) < 0) {
            n3 += this.intParameter(n);
        } else if (n2 == 0x101000A1) {
            n3 += this.intParameter(++n);
        } else if (n2 == 0x101000A0) {
            n3 -= this.intParameter(++n);
        }
        return n3;
    }

    private void setMoData(List<Object[]> list, int n, int n2, int n3, String string) throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        if (n3 < 0 && (n3 = this.viewer.getCurrentModelIndex()) < 0) {
            this.error(30, "MO isosurfaces");
        }
        Map map = (Map)this.viewer.getModelAuxiliaryInfo(n3, "jmolSurfaceInfo");
        int n4 = n;
        if (map == null || !((String)map.get("surfaceDataType")).equals("mo")) {
            int n5;
            int n6;
            map = (Map)this.viewer.getModelAuxiliaryInfo(n3, "moData");
            if (map == null) {
                this.error(27);
            }
            int n7 = n6 = map.containsKey("lastMoNumber") ? (Integer)map.get("lastMoNumber") : 0;
            if (n == 1073742108) {
                n = n6 - 1;
            } else if (n == 1073742034) {
                n = n6 + 1;
            }
            List list2 = (List)map.get("mos");
            int n8 = n5 = list2 == null ? 0 : list2.size();
            if (n5 == 0) {
                this.error(25);
            }
            if (n5 == 1 && n > 1) {
                this.error(29);
            }
            if (n2 != Integer.MAX_VALUE) {
                if (map.containsKey("HOMO")) {
                    n = (Integer)map.get("HOMO") + n2;
                } else {
                    for (int i = 0; i < n5; ++i) {
                        Map map2 = (Map)list2.get(i);
                        if (!map2.containsKey("occupancy")) {
                            this.error(28);
                        }
                        if (((Float)map2.get("occupancy")).floatValue() != 0.0f) continue;
                        n = i + n2;
                        break;
                    }
                }
                Logger.info("MO " + n);
            }
            if (n < 1 || n > n5) {
                this.error(26, "" + n5);
            }
        }
        map.put("lastMoNumber", n);
        this.addShapeProperty(list, "moData", map);
        if (string != null) {
            this.addShapeProperty(list, "title", string);
        }
        if (n4 < 0) {
            this.addShapeProperty(list, "charges", this.viewer.getAtomicCharges());
        }
        this.addShapeProperty(list, "molecularOrbital", n4 < 0 ? -n : n);
        this.addShapeProperty(list, "clear", null);
    }

    private String initIsosurface(int n) throws ScriptException {
        this.setShapeProperty(n, "init", this.fullCommand);
        this.iToken = 0;
        if (this.tokAt(1) == 12291 || this.tokAt(2) == 12291 && this.tokAt(++this.iToken) == 0x100003) {
            this.setShapeProperty(n, "delete", null);
            this.iToken += 2;
            if (this.statementLength > this.iToken) {
                this.setShapeProperty(n, "init", this.fullCommand);
                this.setShapeProperty(n, "thisID", "+PREVIOUS_MESH+");
            }
            return null;
        }
        this.iToken = 1;
        if (!this.setMeshDisplayProperty(n, 0, this.tokAt(1))) {
            this.setShapeProperty(n, "thisID", "+PREVIOUS_MESH+");
            if (n != 22) {
                this.setShapeProperty(n, "title", new String[]{this.thisCommand});
            }
            if (this.tokAt(2) == 0x101000B1 && this.tokAt(1) != 1074790550) {
                String string = this.setShapeId(n, 1, false);
                ++this.iToken;
                return string;
            }
        }
        return null;
    }

    private String getNextComment() {
        String string = this.getCommand(this.pc + 1, false, true);
        return string.startsWith("#") ? string : "";
    }

    private boolean listIsosurface(int n) throws ScriptException {
        if (this.getToken((int)1).value instanceof String[]) {
            return false;
        }
        this.checkLength(2);
        if (!this.isSyntaxCheck) {
            this.showString((String)this.getShapeProperty(n, "list"));
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void isosurface(int var1_1) throws ScriptException {
        this.shapeManager.loadShape(var1_1);
        if (this.tokAt(1) == 7 && this.listIsosurface(var1_1)) {
            return;
        }
        var2_2 = 0;
        var3_3 = var1_1 == 23;
        var4_4 = var1_1 == 26;
        var5_5 = var1_1 == 27;
        var6_6 = var1_1 == 24;
        var7_7 = false;
        var8_8 = false;
        var9_9 = false;
        var10_10 = false;
        var11_11 = false;
        var12_12 = false;
        var13_13 = false;
        var14_14 = new float[5];
        var15_15 = null;
        var16_16 = 0;
        var17_17 = 0;
        var23_18 = NaNf;
        var24_19 = NaNf;
        var25_20 = 0;
        var26_21 = null;
        var27_22 = 0x7FFFFFFF;
        var29_23 = null;
        var30_24 = null;
        var31_25 = new StringBuffer();
        var33_26 = null;
        var34_27 = this.isSyntaxCheck != false ? 0 : this.viewer.getCurrentModelIndex();
        this.setCursorWait(true);
        var35_28 = this.initIsosurface(var1_1) != null;
        var36_29 = var35_28 != false && this.getShapeProperty(var1_1, "ID") == null;
        var37_30 = false;
        var38_31 = null;
        var39_32 = null;
        var40_33 = null;
        var41_34 = null;
        var42_35 = new ArrayList<Object[]>();
        var43_36 = false;
        if (var4_4 || var5_5) {
            this.addShapeProperty(var42_35, "fileType", "Pmesh");
        }
        block89: for (var44_37 = this.iToken; var44_37 < this.statementLength; ++var44_37) {
            var45_47 = null;
            var46_48 /* !! */  = null;
            this.getToken(var44_37);
            if (this.theTok == 0x40000000 && (var33_26 = this.parameterAsString(var44_37)).equalsIgnoreCase("inline")) {
                this.theTok = 4;
            }
            block3 : switch (this.theTok) {
                case 1073742090: {
                    var31_25.append(" periodic");
                    var45_47 = "periodic";
                    break;
                }
                case 1679429641: {
                    if (this.fullCommand.indexOf("# BBOX=") >= 0) {
                        var47_49 /* !! */  = TextFormat.split(this.extractCommandOption("# BBOX"), ',');
                        var32_46 = new Point3f[]{(Point3f)Escape.unescapePoint(var47_49 /* !! */ [0]), (Point3f)Escape.unescapePoint(var47_49 /* !! */ [1])};
                    } else if (this.isCenterParameter(var44_37 + 1)) {
                        var32_46 = new Point3f[]{this.getPoint3f(var44_37 + 1, true), this.getPoint3f(this.iToken + 1, true)};
                        var44_37 = this.iToken;
                    } else {
                        var32_46 = this.viewer.getBoundBoxVertices();
                    }
                    this.addShapeProperty(var42_35, "boundingBox", var32_46);
                    var31_25.append(" boundBox " + Escape.escape(var32_46[0]) + " " + Escape.escape(var32_46[var32_46.length - 1]));
                    continue block89;
                }
                case 135206: {
                    var4_4 = true;
                    this.addShapeProperty(var42_35, "fileType", "Pmesh");
                    var31_25.append(" pmesh");
                    continue block89;
                }
                case 135266322: 
                case 1610625028: {
                    v0 = var47_50 = this.theTok == 1610625028;
                    if (var47_50) {
                        var2_2 = var44_37++;
                        var31_25.append(" display");
                        var48_51 = this.tokAt(var44_37);
                        if (var48_51 == 0) continue block89;
                        if (var48_51 == 10 || var48_51 == 0x100003) {
                            var45_47 = "bsDisplay";
                            if (var48_51 == 0x100003) {
                                var31_25.append(" all");
                            } else {
                                var46_48 /* !! */  = this.statement[var44_37].value;
                                var31_25.append(" ").append(Escape.escape(var46_48 /* !! */ ));
                            }
                            this.checkLast(var44_37);
                            break;
                        }
                        if (var48_51 != 135266322) {
                            this.iToken = var44_37;
                            this.error(22);
                        }
                    } else {
                        var25_20 = var44_37;
                    }
                    var49_53 = null;
                    var28_45 = null;
                    var50_54 = false;
                    if (this.tokAt(var44_37 + 1) == 0x100001) {
                        var48_52 = this.floatParameter(var44_37 + 3);
                        if (this.isPoint3f(var44_37 + 4)) {
                            var49_53 = this.centerParameter(var44_37 + 4);
                            var50_54 = true;
                            this.iToken += 2;
                        } else if (this.isPoint3f(var44_37 + 5)) {
                            var49_53 = this.centerParameter(var44_37 + 5);
                            var50_54 = true;
                            this.iToken += 2;
                        } else {
                            var28_45 = this.atomExpression(this.statement, var44_37 + 5, this.statementLength, true, false, false, true);
                            if (var28_45 == null) {
                                this.error(22);
                            }
                        }
                    } else {
                        var48_52 = this.floatParameter(++var44_37);
                        var49_53 = this.centerParameter(++var44_37);
                    }
                    if (var47_50) {
                        this.checkLast(this.iToken);
                    }
                    var44_37 = this.iToken;
                    if (this.fullCommand.indexOf("# WITHIN=") >= 0) {
                        var28_45 = Escape.unescapeBitset(this.extractCommandOption("# WITHIN"));
                    } else if (!var50_54) {
                        v1 = var28_45 = this.expressionResult instanceof BitSet != false ? (BitSet)this.expressionResult : null;
                    }
                    if (this.isSyntaxCheck) continue block89;
                    if (var28_45 != null) {
                        var28_45.and(this.viewer.getModelUndeletedAtomsBitSet(var34_27));
                    }
                    if (var49_53 == null) {
                        var49_53 = this.viewer.getAtomSetCenter(var28_45);
                    }
                    this.getWithinDistanceVector(var42_35, var48_52, var49_53, var28_45, var47_50);
                    var31_25.append(" within ").append(var48_52).append(" ").append(var28_45 == null ? Escape.escape(var49_53) : Escape.escape(var28_45));
                    continue block89;
                }
                case 603979870: {
                    v2 = this.getToken((int)(++var44_37)).tok == 0x10000D ? Boolean.TRUE : (var26_21 = this.theTok == 0x10000C ? Boolean.FALSE : null);
                    if (var26_21 != null) continue block89;
                    this.error(22);
                    continue block89;
                }
                case 553648149: {
                    var27_22 = this.intParameter(++var44_37);
                    continue block89;
                }
                case 1073742190: 
                case 1716520972: {
                    if (var34_27 < 0) {
                        this.error(30, "ISOSURFACE " + this.theToken.value);
                    }
                    if (var11_11) {
                        this.error(22);
                    }
                    v3 = var51_55 = this.theTok == 1073742190;
                    if (var40_33 == null) {
                        if (!var7_7) {
                            var7_7 = true;
                            this.addShapeProperty(var42_35, "sasurface", new Float(0.0f));
                            var31_25.append(" vdw");
                        }
                        var45_47 = "property";
                        if (var26_21 == null) {
                            var26_21 = this.viewer.getIsosurfacePropertySmoothing(false) == 1 ? Boolean.TRUE : Boolean.FALSE;
                        }
                        this.addShapeProperty(var42_35, "propertySmoothing", var26_21);
                        var31_25.append(" isosurfacePropertySmoothing " + var26_21);
                        if (var27_22 == 0x7FFFFFFF) {
                            var27_22 = this.viewer.getIsosurfacePropertySmoothing(true);
                        }
                        this.addShapeProperty(var42_35, "propertySmoothingPower", var27_22);
                        var31_25.append(" isosurfacePropertySmoothingPower " + var27_22);
                        if (this.viewer.isRangeSelected()) {
                            this.addShapeProperty(var42_35, "rangeSelected", Boolean.TRUE);
                        }
                    } else {
                        var45_47 = var40_33;
                    }
                    var33_26 = this.parameterAsString(var44_37);
                    var31_25.append(" ").append(var33_26);
                    if (var33_26.toLowerCase().indexOf("property_") == 0) {
                        var15_15 = new float[this.viewer.getAtomCount()];
                        if (this.isSyntaxCheck) continue block89;
                        var15_15 = this.viewer.getDataFloat(var33_26);
                        if (var15_15 == null) {
                            this.error(22);
                        }
                        this.addShapeProperty(var42_35, var45_47, var15_15);
                        continue block89;
                    }
                    var52_56 = this.viewer.getAtomCount();
                    var15_15 = new float[var52_56];
                    if (var51_55) {
                        if ((var53_57 = this.parameterAsString(++var44_37)).length() == 0) {
                            var15_15 = this.floatParameterSet(var44_37, var52_56, var52_56);
                        } else {
                            var15_15 = new float[var52_56];
                            if (!this.isSyntaxCheck) {
                                Parser.parseStringInfestedFloatArray("" + this.getParameter(var53_57, false), null, var15_15);
                            }
                        }
                        if (!this.isSyntaxCheck) {
                            var31_25.append(" \"\" ").append(Escape.escape(var15_15));
                        }
                    } else {
                        var53_58 = this.getToken((int)(++var44_37)).tok;
                        if (!this.isSyntaxCheck) {
                            var31_25.append(" " + this.theToken.value);
                            var54_61 = this.viewer.getModelSet().atoms;
                            this.viewer.autoCalculate(var53_58);
                            var55_63 = var52_56;
                            while (--var55_63 >= 0) {
                                var15_15[var55_63] = Atom.atomPropertyFloat(this.viewer, var54_61[var55_63], var53_58);
                            }
                        }
                        if (var53_58 == 1766856708) {
                            var39_32 = "colorRGB";
                        }
                    }
                    var46_48 /* !! */  = var15_15;
                    break;
                }
                case 1095766028: {
                    if (var7_7) {
                        this.error(22);
                    }
                    var34_27 = this.modelNumberParameter(++var44_37);
                    var31_25.append(" model " + var34_27);
                    if (var34_27 < 0) {
                        var45_47 = "fixed";
                        var46_48 /* !! */  = Boolean.TRUE;
                        break;
                    }
                    var45_47 = "modelIndex";
                    var46_48 /* !! */  = var34_27;
                    break;
                }
                case 135280131: {
                    var45_47 = "select";
                    var46_48 /* !! */  = this.atomExpression(++var44_37);
                    var44_37 = this.iToken;
                    if (var7_7) {
                        var31_25.append(" select " + Escape.escape(var46_48 /* !! */ ));
                        break;
                    }
                    var29_23 = (BitSet)var46_48 /* !! */ ;
                    break;
                }
                case 1085443: {
                    var16_16 = this.intParameter(++var44_37);
                    var31_25.append(" set " + var16_16);
                    break;
                }
                case 1073742066: {
                    var45_47 = "offset";
                    var46_48 /* !! */  = this.centerParameter(++var44_37);
                    var44_37 = this.iToken;
                    var31_25.append(" offset " + Escape.escape((Point3f)var46_48 /* !! */ ));
                    break;
                }
                case 12289: {
                    var45_47 = "center";
                    var46_48 /* !! */  = this.centerParameter(++var44_37);
                    var31_25.append(" center " + Escape.escape((Point3f)var46_48 /* !! */ ));
                    var44_37 = this.iToken;
                    break;
                }
                case 1073742147: 
                case 1766856708: {
                    var35_28 = true;
                    var31_25.append(" " + this.theToken.value);
                    v4 = var54_62 = this.theTok == 1073742147;
                    if (!var54_62) ** GOTO lbl264
                    this.addShapeProperty(var42_35, "sign", Boolean.TRUE);
                    ** GOTO lbl-1000
lbl264:
                    // 1 sources

                    if (this.tokAt(var44_37 + 1) == 1073741914) {
                        ++var44_37;
                        var45_47 = "colorDensity";
                        var31_25.append(" density");
                        break;
                    }
                    if (this.getToken((int)(var44_37 + 1)).tok == 4) {
                        var39_32 = this.parameterAsString(++var44_37);
                        var31_25.append(" ").append(Escape.escape(var39_32));
                        if (var39_32.indexOf(" ") > 0 && (var41_34 = Graphics3D.getColixArray(var39_32)) == null) {
                            this.error(4);
                        }
                    } else if (this.theTok == 1073742018) {
                        ++var44_37;
                        var31_25.append(" mesh");
                        var53_59 = this.getArgbParam(++var44_37);
                        this.addShapeProperty(var42_35, "colorMesh", var53_59);
                        var31_25.append(" ").append(Escape.escapeColor(var53_59));
                        var44_37 = this.iToken;
                        continue block89;
                    }
                    if ((this.theTok = this.tokAt(var44_37 + 1)) == 1073742180 || this.theTok == 1073742074) {
                        var38_31 = this.setColorOptions(var31_25, var44_37 + 1, 23, -2);
                        var44_37 = this.iToken;
                        continue block89;
                    }
                    switch (this.tokAt(var44_37 + 1)) {
                        case 0x40000002: 
                        case 1073742114: {
                            this.getToken(++var44_37);
                            var31_25.append(" range");
                            this.addShapeProperty(var42_35, "rangeAll", null);
                            if (this.tokAt(var44_37 + 1) == 0x100003) {
                                ++var44_37;
                                var31_25.append(" all");
                                break;
                            }
                            var55_64 = this.floatParameter(++var44_37);
                            var56_66 = this.floatParameter(++var44_37);
                            this.addShapeProperty(var42_35, "red", new Float(var55_64));
                            this.addShapeProperty(var42_35, "blue", new Float(var56_66));
                            var31_25.append(" ").append(var55_64).append(" ").append(var56_66);
                            break;
                        }
                        default: lbl-1000:
                        // 2 sources

                        {
                            if (this.isColorParam(var44_37 + 1)) {
                                var53_60 = this.getArgbParam(++var44_37);
                                this.addShapeProperty(var42_35, "colorRGB", var53_60);
                                var31_25.append(" ").append(Escape.escapeColor(var53_60));
                                var44_37 = this.iToken;
                                var35_28 = true;
                                if (this.isColorParam(var44_37 + 1)) {
                                    var53_60 = this.getArgbParam(++var44_37);
                                    var44_37 = this.iToken;
                                    this.addShapeProperty(var42_35, "colorRGB", var53_60);
                                    var31_25.append(" ").append(Escape.escapeColor(var53_60));
                                    break;
                                }
                                if (!var54_62) continue block89;
                                this.error(23);
                                break;
                            }
                            if (var54_62 || var41_34 != null) continue block89;
                            this.error(23);
                            break;
                        }
                    }
                    continue block89;
                }
                case 1229984263: {
                    continue block89;
                }
                case 1112541194: 
                case 1112541199: {
                    var31_25.append(" ").append(this.theToken.value);
                    var55_65 = this.encodeRadiusParameter(var44_37, false);
                    var31_25.append(" ").append(var55_65);
                    if (Float.isNaN(var55_65.value)) {
                        var55_65.value = 100.0f;
                    }
                    var46_48 /* !! */  = var55_65;
                    var45_47 = "radius";
                    var12_12 = true;
                    var44_37 = this.iToken;
                    break;
                }
                case 135266319: {
                    var8_8 = true;
                    var45_47 = "plane";
                    var46_48 /* !! */  = this.planeParameter(++var44_37);
                    var44_37 = this.iToken;
                    var31_25.append(" plane ").append(Escape.escape((Point4f)var46_48 /* !! */ ));
                    break;
                }
                case 0x60000004: {
                    var45_47 = "scale3d";
                    var46_48 /* !! */  = new Float(this.floatParameter(++var44_37));
                    var31_25.append(" scale3d ").append(var46_48 /* !! */ );
                    break;
                }
                case 1073742138: {
                    var45_47 = "scale";
                    var46_48 /* !! */  = new Float(this.floatParameter(++var44_37));
                    var31_25.append(" scale ").append(var46_48 /* !! */ );
                    break;
                }
                case 0x100003: {
                    if (var35_28) {
                        this.error(22);
                    }
                    var45_47 = "thisID";
                    break;
                }
                case 1113198596: {
                    var7_7 = true;
                    ++var44_37;
                    try {
                        var46_48 /* !! */  = this.getPoint4f(var44_37);
                        var45_47 = "ellipsoid";
                        var44_37 = this.iToken;
                        var31_25.append(" ellipsoid ").append(Escape.escape((Point4f)var46_48 /* !! */ ));
                    }
                    catch (ScriptException var56_67) {
                        try {
                            var45_47 = "ellipsoid";
                            var46_48 /* !! */  = this.floatParameterSet(var44_37, 6, 6);
                            var44_37 = this.iToken;
                            var31_25.append(" ellipsoid ").append(Escape.escape(var46_48 /* !! */ ));
                        }
                        catch (ScriptException var56_68) {
                            var28_45 = this.atomExpression(var44_37);
                            var31_25.append(" ellipsoid ").append(Escape.escape(var28_45));
                            var56_69 = var28_45.nextSetBit(0);
                            var57_70 = this.viewer.getModelSet().atoms;
                            if (var56_69 >= 0) {
                                var46_48 /* !! */  = var57_70[var56_69].getEllipsoid();
                            }
                            if (var46_48 /* !! */  == null) {
                                return;
                            }
                            var44_37 = this.iToken;
                            var45_47 = "ellipsoid";
                            if (this.isSyntaxCheck) break;
                            this.addShapeProperty(var42_35, "center", this.viewer.getAtomPoint3f(var56_69));
                        }
                    }
                    break;
                }
                case 135267841: {
                    var8_8 = true;
                    var45_47 = "plane";
                    var46_48 /* !! */  = this.hklParameter(++var44_37);
                    var44_37 = this.iToken;
                    var31_25.append(" plane ").append(Escape.escape((Point4f)var46_48 /* !! */ ));
                    break;
                }
                case 135198: {
                    var7_7 = true;
                    var58_71 = this.parameterAsString(++var44_37);
                    this.addShapeProperty(var42_35, "lcaoType", var58_71);
                    var31_25.append(" lcaocartoon ").append(Escape.escape(var58_71));
                    switch (this.getToken((int)(++var44_37)).tok) {
                        case 10: 
                        case 0x100001: {
                            var45_47 = "lcaoCartoon";
                            var28_45 = this.atomExpression(var44_37);
                            var31_25.append(" ").append(Escape.escape(var28_45));
                            var44_37 = this.iToken;
                            var59_72 = var28_45.nextSetBit(0);
                            var34_27 = 0;
                            if (var59_72 < 0) {
                                if (!this.isSyntaxCheck) {
                                    this.error(14);
                                }
                                var60_73 = new Point3f();
                            } else {
                                var34_27 = this.viewer.getAtomModelIndex(var59_72);
                                var60_73 = this.viewer.getAtomPoint3f(var59_72);
                            }
                            this.addShapeProperty(var42_35, "modelIndex", var34_27);
                            var61_75 = new Vector3f[]{new Vector3f(), new Vector3f(), new Vector3f(var60_73), new Vector3f()};
                            if (!this.isSyntaxCheck && !var58_71.equalsIgnoreCase("s") && this.viewer.getHybridizationAndAxes(var59_72, var61_75[0], var61_75[1], var58_71) == null) {
                                return;
                            }
                            var46_48 /* !! */  = var61_75;
                            break block3;
                        }
                    }
                    this.error(14);
                    break;
                }
                case 0x121021: {
                    var59_72 = 0x7FFFFFFF;
                    var60_74 = 0x7FFFFFFF;
                    switch (this.tokAt(++var44_37)) {
                        case 0: {
                            this.error(2);
                        }
                        case 0x40000094: 
                        case 1073742008: {
                            var60_74 = this.moOffset(var44_37);
                            var59_72 = 0;
                            var44_37 = this.iToken;
                            var31_25.append(" mo HOMO ");
                            if (var60_74 > 0) {
                                var31_25.append("+");
                            }
                            if (var60_74 == 0) break;
                            var31_25.append(var60_74);
                            break;
                        }
                        case 2: {
                            var59_72 = this.intParameter(var44_37);
                            var31_25.append(" mo ").append(var59_72);
                        }
                    }
                    this.setMoData(var42_35, var59_72, var60_74, var34_27, null);
                    var7_7 = true;
                    continue block89;
                }
                case 0x400000C0: 
                case 1073742021: {
                    var61_76 = this.theTok == 0x400000C0;
                    var45_47 = var61_76 != false ? "mep" : "mlp";
                    var31_25.append(" " + var45_47);
                    var62_77 = null;
                    var63_78 = -1;
                    var7_7 = true;
                    if (this.tokAt(var44_37 + 1) == 2) {
                        var63_78 = this.intParameter(++var44_37);
                        var31_25.append(" " + var63_78);
                        this.addShapeProperty(var42_35, "mepCalcType", var63_78);
                    }
                    if (this.tokAt(var44_37 + 1) == 4) {
                        var62_77 = this.stringParameter(++var44_37);
                        var31_25.append(" /*file*/" + Escape.escape(var62_77));
                    } else if (this.tokAt(var44_37 + 1) == 1716520972) {
                        var40_33 = var45_47;
                        continue block89;
                    }
                    if (!this.isSyntaxCheck) {
                        try {
                            var15_15 = var62_77 == null && var61_76 != false ? this.viewer.getPartialCharges() : this.viewer.getAtomicPotentials(var61_76, var29_23, var30_24, var62_77);
                        }
                        catch (Exception var64_79) {
                            // empty catch block
                        }
                    }
                    if (!this.isSyntaxCheck && var15_15 == null) {
                        this.error(32);
                    }
                    var46_48 /* !! */  = var15_15;
                    break;
                }
                case 1313866247: {
                    var10_10 = this.isSyntaxCheck == false;
                    var31_25.append(" volume");
                    break;
                }
                case 1074790550: {
                    this.setShapeId(var1_1, ++var44_37, var35_28);
                    var36_29 = this.getShapeProperty(var1_1, "ID") == null;
                    var44_37 = this.iToken;
                    break;
                }
                case 0x40000040: {
                    if (this.tokAt(var44_37 + 1) == 1073742180) {
                        var37_30 = true;
                        ++var44_37;
                    }
                    if ((var39_32 = this.parameterAsString(++var44_37).toLowerCase()).equals("sets")) {
                        var37_30 = false;
                    }
                    var31_25.append(" colorScheme");
                    if (var37_30) {
                        var31_25.append(" translucent");
                    }
                    var31_25.append(" ").append(Escape.escape(var39_32));
                    break;
                }
                case 0x40000004: {
                    var45_47 = "addHydrogens";
                    var46_48 /* !! */  = Boolean.TRUE;
                    var31_25.append(" addHydrogens");
                    break;
                }
                case 0x4000000C: {
                    var45_47 = "angstroms";
                    var31_25.append(" angstroms");
                    break;
                }
                case 0x4000000E: {
                    var45_47 = "anisotropy";
                    var46_48 /* !! */  = this.getPoint3f(++var44_37, false);
                    var31_25.append(" anisotropy").append(Escape.escape((Point3f)var46_48 /* !! */ ));
                    var44_37 = this.iToken;
                    break;
                }
                case 1073741842: {
                    var9_9 = this.isSyntaxCheck == false;
                    var31_25.append(" area");
                    break;
                }
                case 1073741850: 
                case 1073742076: {
                    var7_7 = true;
                    var14_14[0] = this.intParameter(++var44_37);
                    var14_14[1] = this.intParameter(++var44_37);
                    var14_14[2] = this.intParameter(++var44_37);
                    var14_14[3] = this.isFloatParameter(var44_37 + 1) != false ? this.floatParameter(++var44_37) : 6.0f;
                    var31_25.append(" atomicOrbital ").append((int)var14_14[0]).append(" ").append((int)var14_14[1]).append(" ").append((int)var14_14[2]).append(" ").append(var14_14[3]);
                    var45_47 = "hydrogenOrbital";
                    var46_48 /* !! */  = var14_14;
                    break;
                }
                case 1073741866: {
                    var31_25.append(" binary");
                    continue block89;
                }
                case 1073741868: {
                    var31_25.append(" blockData");
                    var45_47 = "blockData";
                    var46_48 /* !! */  = Boolean.TRUE;
                    break;
                }
                case 554176565: 
                case 1074790450: {
                    var45_47 = (String)this.theToken.value;
                    var46_48 /* !! */  = this.getCapSlabObject(var31_25, var44_37);
                    var44_37 = this.iToken;
                    break;
                }
                case 0x40000034: {
                    if (!var3_3) {
                        this.error(22);
                    }
                    var11_11 = true;
                    if (this.isSyntaxCheck) continue block89;
                    var64_80 = this.isFloatParameter(var44_37 + 1) != false ? this.floatParameter(++var44_37) : 1.2f;
                    v5 = var65_81 = this.isFloatParameter(var44_37 + 1) != false ? this.floatParameter(++var44_37) : 10.0f;
                    if (var65_81 > 10.0f) {
                        this.integerOutOfRange(0, 10);
                    }
                    var31_25.append(" cavity ").append(var64_80).append(" ").append(var65_81);
                    this.addShapeProperty(var42_35, "envelopeRadius", new Float(var65_81));
                    this.addShapeProperty(var42_35, "cavityRadius", new Float(var64_80));
                    var45_47 = "cavity";
                    break;
                }
                case 0x40000048: 
                case 0x4000004C: {
                    var45_47 = "contour";
                    var31_25.append(" contour");
                    switch (this.tokAt(var44_37 + 1)) {
                        case 0x40000060: {
                            var46_48 /* !! */  = this.floatParameterSet(var44_37 + 2, 1, 0x7FFFFFFF);
                            var31_25.append(" discrete ").append(Escape.escape(var46_48 /* !! */ ));
                            var44_37 = this.iToken;
                            break block3;
                        }
                        case 1073741980: {
                            var66_82 = this.getPoint3f(var44_37 + 2, false);
                            if (var66_82.z <= 0.0f || var66_82.y < var66_82.x) {
                                this.error(22);
                            }
                            if (var66_82.z == (float)((int)var66_82.z) && var66_82.z > var66_82.y - var66_82.x) {
                                var66_82.z = (var66_82.y - var66_82.x) / var66_82.z;
                            }
                            var46_48 /* !! */  = var66_82;
                            var44_37 = this.iToken;
                            var31_25.append(" increment ").append(Escape.escape(var66_82));
                            break block3;
                        }
                    }
                    var46_48 /* !! */  = this.tokAt(var44_37 + 1) == 2 ? this.intParameter(++var44_37) : 0;
                    var31_25.append(" ").append(var46_48 /* !! */ );
                    break;
                }
                case 1073741910: {
                    var31_25.append(" cutoff ");
                    if (this.tokAt(++var44_37) == 0x101000A1) {
                        var45_47 = "cutoffPositive";
                        var24_19 = this.floatParameter(++var44_37);
                        var46_48 /* !! */  = new Float(var24_19);
                        var31_25.append("+").append(var46_48 /* !! */ );
                        break;
                    }
                    if (this.isFloatParameter(var44_37)) {
                        var45_47 = "cutoff";
                        var24_19 = this.floatParameter(var44_37);
                        var46_48 /* !! */  = new Float(var24_19);
                        var31_25.append(var46_48 /* !! */ );
                        break;
                    }
                    var45_47 = "cutoffRange";
                    var46_48 /* !! */  = this.floatParameterSet(var44_37, 2, 2);
                    this.addShapeProperty(var42_35, "cutoff", Float.valueOf(0.0f));
                    var31_25.append(Escape.escape((float[])var46_48 /* !! */ , true));
                    var44_37 = this.iToken;
                    break;
                }
                case 1073741928: {
                    var45_47 = "downsample";
                    var46_48 /* !! */  = this.intParameter(++var44_37);
                    var31_25.append(" downsample ").append(var46_48 /* !! */ );
                    break;
                }
                case 1073741930: {
                    var45_47 = "eccentricity";
                    var46_48 /* !! */  = this.getPoint4f(++var44_37);
                    var31_25.append(" eccentricity ").append(Escape.escape((Point4f)var46_48 /* !! */ ));
                    var44_37 = this.iToken;
                    break;
                }
                case 1074790508: {
                    var31_25.append(" ed");
                    this.setMoData(var42_35, -1, 0, var34_27, null);
                    var7_7 = true;
                    continue block89;
                }
                case 0x20000004: 
                case 1073742040: {
                    var31_25.append(" ").append(this.theToken.value);
                    var45_47 = "debug";
                    var46_48 /* !! */  = this.theTok == 0x20000004 ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 1060869: {
                    var31_25.append(" fixed");
                    var45_47 = "fixed";
                    var46_48 /* !! */  = Boolean.TRUE;
                    break;
                }
                case 1073741962: {
                    var31_25.append(" fullPlane");
                    var45_47 = "fullPlane";
                    var46_48 /* !! */  = Boolean.TRUE;
                    break;
                }
                case 1073741966: 
                case 0x40000090: {
                    var66_83 = this.theTok == 0x40000090;
                    var45_47 = "" + this.theToken.value;
                    var67_84 = new ArrayList<Object>();
                    v6 = ++var44_37;
                    ++var44_37;
                    var68_85 = this.parameterAsString(v6);
                    var69_86 = this.extractCommandOption("# DATA" + (var13_13 != false ? "2" : ""));
                    if (var69_86 == null) {
                        var69_86 = "inline";
                    } else {
                        var68_85 = var69_86;
                    }
                    var31_25.append(" ").append(var45_47).append(" inline");
                    var70_87 = var68_85.indexOf("data2d_") == 0;
                    var71_88 = var68_85.indexOf("data3d_") == 0;
                    var72_89 = var68_85.equals("inline");
                    var67_84.add(var68_85);
                    var73_90 = this.getPoint3f(var44_37, false);
                    var31_25.append(" ").append(Escape.escape(var73_90));
                    var67_84.add(var73_90);
                    var21_43 = ++this.iToken;
                    var74_91 = this.getPoint4f(var21_43);
                    var67_84.add(var74_91);
                    var31_25.append(" ").append(Escape.escape(var74_91));
                    var18_40 = (int)var74_91.x;
                    var22_44 = ++this.iToken;
                    var74_91 = this.getPoint4f(var22_44);
                    var67_84.add(var74_91);
                    var31_25.append(" ").append(Escape.escape(var74_91));
                    var19_41 = (int)var74_91.x;
                    var74_91 = this.getPoint4f(++this.iToken);
                    var67_84.add(var74_91);
                    var31_25.append(" ").append(Escape.escape(var74_91));
                    var20_42 = (int)var74_91.x;
                    if (var18_40 == 0 || var19_41 == 0 || var20_42 == 0) {
                        this.error(22);
                    }
                    if (!this.isSyntaxCheck) {
                        var75_92 = null;
                        var76_94 = null;
                        if (var66_83) {
                            if (var72_89) {
                                var18_40 = Math.abs(var18_40);
                                var19_41 = Math.abs(var19_41);
                                var20_42 = Math.abs(var20_42);
                                var76_94 = this.floatArraySet(++this.iToken, var18_40, var19_41, var20_42);
                            } else {
                                var76_94 = var71_88 != false ? (Object)this.viewer.getDataFloat3D(var68_85) : (Object)this.viewer.functionXYZ(var68_85, var18_40, var19_41, var20_42);
                            }
                            var18_40 = Math.abs(var18_40);
                            var19_41 = Math.abs(var19_41);
                            var20_42 = Math.abs(var20_42);
                            if (var76_94 == null) {
                                this.iToken = var21_43;
                                this.error(53, "xyzdata is null.");
                            }
                            if (((Object)var76_94).length != var18_40 || ((Object)var76_94[0]).length != var19_41 || ((Object)var76_94[0][0]).length != var20_42) {
                                this.iToken = var21_43;
                                this.error(53, "xyzdata[" + ((Object)var76_94).length + "][" + ((Object)var76_94[0]).length + "][" + ((Object)var76_94[0][0]).length + "] is not of size [" + var18_40 + "][" + var19_41 + "][" + var20_42 + "]");
                            }
                            var67_84.add(var76_94);
                            var31_25.append(" ").append(Escape.escape(var76_94));
                        } else {
                            if (var72_89) {
                                var18_40 = Math.abs(var18_40);
                                var19_41 = Math.abs(var19_41);
                                var75_92 = this.floatArraySet(++this.iToken, var18_40, var19_41);
                            } else if (var70_87) {
                                var75_92 = this.viewer.getDataFloat2D(var68_85);
                                var18_40 = var75_92 == null ? 0 : var75_92.length;
                                var19_41 = 3;
                            } else {
                                var75_92 = this.viewer.functionXY(var68_85, var18_40, var19_41);
                                var18_40 = Math.abs(var18_40);
                                var19_41 = Math.abs(var19_41);
                            }
                            if (var75_92 == null) {
                                this.iToken = var21_43;
                                this.error(53, "fdata is null.");
                            }
                            if (var75_92.length != var18_40 && !var70_87) {
                                this.iToken = var21_43;
                                this.error(53, "fdata length is not correct: " + var75_92.length + " " + var18_40 + ".");
                            }
                            for (var77_95 = 0; var77_95 < var18_40; ++var77_95) {
                                if (var75_92[var77_95] == null) {
                                    this.iToken = var22_44;
                                    this.error(53, "fdata[" + var77_95 + "] is null.");
                                }
                                if (var75_92[var77_95].length == var19_41) continue;
                                this.iToken = var22_44;
                                this.error(53, "fdata[" + var77_95 + "] is not the right length: " + var75_92[var77_95].length + " " + var19_41 + ".");
                            }
                            var67_84.add(var75_92);
                            var31_25.append(" ").append(Escape.escape(var75_92));
                        }
                    }
                    var44_37 = this.iToken;
                    var46_48 /* !! */  = var67_84;
                    var7_7 = true;
                    var13_13 = true;
                    break;
                }
                case 1073741970: {
                    var45_47 = "gridPoints";
                    var31_25.append(" gridPoints");
                    break;
                }
                case 1073741976: {
                    var45_47 = "ignore";
                    var30_24 = this.atomExpression(++var44_37);
                    var46_48 /* !! */  = var30_24;
                    var31_25.append(" ignore ").append(Escape.escape((BitSet)var46_48 /* !! */ ));
                    var44_37 = this.iToken;
                    break;
                }
                case 0x400000A0: {
                    var45_47 = "insideOut";
                    var31_25.append(" insideout");
                    break;
                }
                case 1073741986: 
                case 0x400000A4: 
                case 0x40000114: {
                    var31_25.append(" ").append(this.theToken.value);
                    var45_47 = "pocket";
                    var46_48 /* !! */  = this.theTok == 0x40000114 ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 1073742002: {
                    var7_7 = true;
                    var45_47 = "lobe";
                    var46_48 /* !! */  = this.getPoint4f(++var44_37);
                    var44_37 = this.iToken;
                    var31_25.append(" lobe ").append(Escape.escape((Point4f)var46_48 /* !! */ ));
                    break;
                }
                case 0x400000B4: 
                case 1073742006: {
                    var7_7 = true;
                    var45_47 = "lp";
                    var46_48 /* !! */  = this.getPoint4f(++var44_37);
                    var44_37 = this.iToken;
                    var31_25.append(" lp ").append(Escape.escape((Point4f)var46_48 /* !! */ ));
                    break;
                }
                case 0x10101C: {
                    var31_25.append(" map");
                    if ((var11_11 || var12_12) && !var7_7) {
                        var7_7 = true;
                        this.addShapeProperty(var42_35, "bsSolvent", this.lookupIdentifierValue("solvent"));
                        this.addShapeProperty(var42_35, "sasurface", new Float(0.0f));
                    }
                    var7_7 = var11_11 == false;
                    var45_47 = "map";
                    break;
                }
                case 1073742014: {
                    var45_47 = "maxset";
                    var46_48 /* !! */  = this.intParameter(++var44_37);
                    var31_25.append(" maxSet ").append(var46_48 /* !! */ );
                    break;
                }
                case 0x400000C4: {
                    var45_47 = "minset";
                    var46_48 /* !! */  = this.intParameter(++var44_37);
                    var31_25.append(" minSet ").append(var46_48 /* !! */ );
                    break;
                }
                case 1073742112: {
                    var7_7 = true;
                    var45_47 = "rad";
                    var46_48 /* !! */  = this.getPoint4f(++var44_37);
                    var44_37 = this.iToken;
                    var31_25.append(" radical ").append(Escape.escape((Point4f)var46_48 /* !! */ ));
                    break;
                }
                case 0x400000CC: {
                    var45_47 = "fixed";
                    var46_48 /* !! */  = Boolean.FALSE;
                    var31_25.append(" modelBased");
                    break;
                }
                case 1073742030: 
                case 1073742136: 
                case 1613758475: {
                    if (var34_27 < 0) {
                        this.error(30, "ISOSURFACE " + this.theToken.value);
                    }
                    var7_7 = true;
                    if (this.theTok == 1073742030) {
                        var45_47 = "molecular";
                        var31_25.append(" molecular");
                        var75_93 = 1.4f;
                    } else {
                        this.addShapeProperty(var42_35, "bsSolvent", this.lookupIdentifierValue("solvent"));
                        var45_47 = this.theTok == 1073742136 ? "sasurface" : "solvent";
                        var31_25.append(" ").append(this.theToken.value);
                        var75_93 = this.isFloatParameter(var44_37 + 1) != false ? this.floatParameter(++var44_37) : this.viewer.getSolventProbeRadius();
                        var31_25.append(" ").append(var75_93);
                    }
                    var46_48 /* !! */  = Float.valueOf(var75_93);
                    break;
                }
                case 0x400000EE: 
                case 0x400000F0: {
                    this.addShapeProperty(var42_35, "fileType", "Obj");
                    var31_25.append(" obj");
                    continue block89;
                }
                case 1073742094: {
                    if (var7_7) {
                        this.error(22);
                    }
                    var45_47 = "phase";
                    var46_48 /* !! */  = this.tokAt(var44_37 + 1) == 4 ? this.stringParameter(++var44_37) : "_orb";
                    var31_25.append(" phase ").append(Escape.escape(var46_48 /* !! */ ));
                    break;
                }
                case 1073742104: 
                case 1073742122: {
                    var45_47 = "resolution";
                    var46_48 /* !! */  = new Float(this.floatParameter(++var44_37));
                    var31_25.append(" resolution ").append(var46_48 /* !! */ );
                    break;
                }
                case 1073742124: {
                    var45_47 = "reverseColor";
                    var46_48 /* !! */  = Boolean.TRUE;
                    var31_25.append(" reversecolor");
                    break;
                }
                case 1073742146: {
                    var45_47 = "sigma";
                    var23_18 = this.floatParameter(++var44_37);
                    var46_48 /* !! */  = new Float(var23_18);
                    var31_25.append(" sigma ").append(var46_48 /* !! */ );
                    break;
                }
                case 1073742154: {
                    var7_7 = true;
                    var45_47 = "sphere";
                    var46_48 /* !! */  = new Float(this.floatParameter(++var44_37));
                    var31_25.append(" sphere ").append(var46_48 /* !! */ );
                    break;
                }
                case 1073742156: {
                    var45_47 = "squareData";
                    var46_48 /* !! */  = Boolean.TRUE;
                    var31_25.append(" squared");
                    break;
                }
                case 4: {
                    var76_94 = this.parameterAsString(var44_37);
                    v7 = var77_95 = var7_7 == false && var8_8 == false ? 1 : 0;
                    if (var76_94.startsWith("=") && var76_94.length() > 1) {
                        var78_96 = (String[])this.viewer.setLoadFormat((String)var76_94, '_', false);
                        var76_94 = var78_96[0];
                        v8 = var79_98 = var77_95 == 0 || Float.isNaN(var24_19) == false ? null : var78_96[1];
                        if (var79_98 != null && !this.isSyntaxCheck && (var24_19 = ScriptVariable.fValue(ScriptVariable.getVariable(this.viewer.evaluateExpression(var79_98)))) > 0.0f) {
                            if (!Float.isNaN(var23_18)) {
                                var24_19 *= var23_18;
                                var23_18 = NaNf;
                                this.addShapeProperty(var42_35, "sigma", new Float(var23_18));
                            }
                            this.addShapeProperty(var42_35, "cutoff", new Float(var24_19));
                            var31_25.append(" cutoff ").append(var24_19);
                        }
                        if (var25_20 == 0) {
                            var28_45 = this.viewer.getModelUndeletedAtomsBitSet(var34_27);
                            this.getWithinDistanceVector(var42_35, 2.0f, null, var28_45, false);
                            var31_25.append(" within 2.0 ").append(Escape.escape(var28_45));
                        }
                        if (var77_95 != 0) {
                            var43_36 = true;
                        }
                    }
                    if (var77_95 != 0 && this.viewer.getParameter("_fileType").equals("Pdb") && Float.isNaN(var23_18) && Float.isNaN(var24_19)) {
                        this.addShapeProperty(var42_35, "sigma", new Float(-1.0f));
                        var31_25.append(" sigma -1.0");
                    }
                    v9 = var45_47 = var77_95 != 0 ? "readFile" : "mapColor";
                    if (var76_94.equals("TESTDATA") && ScriptEvaluator.testData != null) {
                        var46_48 /* !! */  = ScriptEvaluator.testData;
                        break;
                    }
                    if (var76_94.equals("TESTDATA2") && ScriptEvaluator.testData2 != null) {
                        var46_48 /* !! */  = ScriptEvaluator.testData2;
                        break;
                    }
                    if (var76_94.length() == 0) {
                        if (var7_7 || var8_8) {
                            var46_48 /* !! */  = this.viewer.getModelAuxiliaryInfo(var34_27, "jmolMappedDataInfo");
                        }
                        if (var46_48 /* !! */  == null) {
                            var46_48 /* !! */  = this.viewer.getModelAuxiliaryInfo(var34_27, "jmolSurfaceInfo");
                        }
                        var7_7 = true;
                        if (var46_48 /* !! */  != null) break;
                        var76_94 = this.getFullPathName();
                    }
                    var7_7 = true;
                    var78_97 = -1;
                    if (this.tokAt(var44_37 + 1) == 2) {
                        var78_97 = this.intParameter(++var44_37);
                        this.addShapeProperty(var42_35, "fileIndex", var78_97);
                    }
                    if (var76_94.equalsIgnoreCase("INLINE")) {
                        if (this.tokAt(var44_37 + 1) != 4) {
                            this.error(41);
                        }
                        var79_98 = this.parameterAsString(++var44_37);
                        if (var4_4) {
                            var79_98 = TextFormat.replaceAllCharacters((String)var79_98, "{,}|", ' ');
                        }
                        if (this.logMessages) {
                            Logger.debug("pmesh inline data:\n" + (String)var79_98);
                        }
                        var46_48 /* !! */  = this.isSyntaxCheck != false ? null : var79_98;
                        this.addShapeProperty(var42_35, "fileName", "");
                        var31_25.append(" INLINE ").append(Escape.escape((String)var79_98));
                    } else if (!this.isSyntaxCheck) {
                        var80_99 = null;
                        if (this.fullCommand.indexOf("# FILE" + var17_17 + "=") >= 0) {
                            var76_94 = this.extractCommandOption("# FILE" + var17_17);
                            if (this.tokAt(var44_37 + 1) == 1073741848) {
                                var44_37 += 2;
                            }
                        } else if (this.tokAt(var44_37 + 1) == 1073741848) {
                            this.iToken = var44_37 += 2;
                            var80_99 = this.viewer.getFilePath(this.stringParameter(var44_37), false);
                            var79_98 = this.viewer.getFullPathNameOrError(var80_99);
                            var80_99 = var79_98[0];
                            this.addShapeProperty(var42_35, "localName", var80_99);
                        }
                        var79_98 = this.viewer.getFullPathNameOrError((String)var76_94);
                        var76_94 = var79_98[0];
                        if (var79_98[1] != null) {
                            this.error(17, (String)var76_94 + ":" + var79_98[1]);
                        }
                        Logger.info("reading isosurface data from " + (String)var76_94);
                        this.addShapeProperty(var42_35, "fileName", var76_94);
                        if (var80_99 != null) {
                            var76_94 = var80_99;
                        }
                        var31_25.append(" /*file*/").append(Escape.escape((String)var76_94));
                        var46_48 /* !! */  = null;
                    }
                    if (var78_97 < 0) break;
                    var31_25.append(" ").append(var78_97);
                    break;
                }
                case 0x40000000: {
                    if (var33_26.equalsIgnoreCase("LINK")) {
                        var45_47 = "link";
                        var31_25.append(" link");
                        break;
                    }
                    if (var33_26.equalsIgnoreCase("REMAPPABLE")) {
                        var45_47 = "remappable";
                        var31_25.append(" remappable");
                        break;
                    }
                    var45_47 = "thisID";
                    var46_48 /* !! */  = var33_26;
                }
                default: {
                    if (var8_8 && !var7_7) {
                        this.addShapeProperty(var42_35, "nomap", new Float(0.0f));
                        var7_7 = true;
                    }
                    if (!this.setMeshDisplayProperty(var1_1, 0, this.theTok)) {
                        if (Token.tokAttr(this.theTok, 0x40000000) && !var35_28) {
                            this.setShapeId(var1_1, var44_37, var35_28);
                            var44_37 = this.iToken;
                            break;
                        }
                        this.error(22);
                    }
                    if (var2_2 == 0) {
                        var2_2 = var44_37;
                    }
                    var44_37 = this.statementLength - 1;
                }
            }
            v10 = var35_28 = this.theTok != 12291;
            if (var45_47 == "property" && !var7_7) {
                var7_7 = true;
                this.addShapeProperty(var42_35, "bsSolvent", this.lookupIdentifierValue("solvent"));
                var45_47 = "sasurface";
                var46_48 /* !! */  = new Float(0.0f);
            }
            if (var36_29 && var7_7) {
                this.error(22);
            }
            if (var45_47 == null) continue;
            this.addShapeProperty(var42_35, var45_47, var46_48 /* !! */ );
        }
        if ((var11_11 || var12_12) && !var7_7) {
            var7_7 = true;
            this.addShapeProperty(var42_35, "bsSolvent", this.lookupIdentifierValue("solvent"));
            this.addShapeProperty(var42_35, "sasurface", new Float(0.0f));
        }
        if (var8_8 && !var7_7) {
            this.addShapeProperty(var42_35, "nomap", new Float(0.0f));
            var7_7 = true;
        }
        if (var16_16 > 0) {
            this.addShapeProperty(var42_35, "getSurfaceSets", var16_16 - 1);
        }
        if (var41_34 != null) {
            this.addShapeProperty(var42_35, "colorDiscrete", var41_34);
        } else if (var39_32 != null) {
            if (var39_32.equals("sets")) {
                this.addShapeProperty(var42_35, "setColorScheme", "sets");
            } else {
                var44_38 = this.viewer.getColorEncoder(var39_32);
                if (var44_38 != null) {
                    var44_38.isTranslucent = var37_30;
                    this.addShapeProperty(var42_35, "setColorScheme", var44_38);
                }
            }
        }
        this.setShapeProperty(var1_1, "setProperties", var42_35);
        if (var43_36) {
            this.setShapeProperty(var1_1, "token", 1073742018);
            this.setShapeProperty(var1_1, "token", 1073742046);
            this.setShapeProperty(var1_1, "token", 0x40000088);
            var31_25.append(" mesh nofill frontOnly");
        }
        if (var2_2 > 0 && !this.setMeshDisplayProperty(var1_1, var2_2, this.getToken((int)var2_2).tok)) {
            this.error(22);
        }
        var44_39 = null;
        var45_47 = null;
        if (var9_9) {
            var44_39 = this.getShapeProperty(var1_1, "area");
            if (var44_39 instanceof Float) {
                this.viewer.setFloatProperty("isosurfaceArea", ((Float)var44_39).floatValue());
            } else {
                this.viewer.setUserVariable("isosurfaceArea", ScriptVariable.getVariable(var44_39));
            }
        }
        if (var10_10) {
            v11 = var45_47 = var10_10 != false ? this.getShapeProperty(var1_1, "volume") : null;
            if (var45_47 instanceof Float) {
                this.viewer.setFloatProperty("isosurfaceVolume", ((Float)var45_47).floatValue());
            } else {
                this.viewer.setUserVariable("isosurfaceVolume", ScriptVariable.getVariable(var45_47));
            }
        }
        if (var7_7 && !var6_6 && !this.isSyntaxCheck) {
            if (var29_23 == null) {
                var29_23 = this.viewer.getSelectionSet(false);
            }
            var29_23.and(this.viewer.getModelUndeletedAtomsBitSet(var34_27));
            this.setShapeProperty(var1_1, "finalize", " select " + Escape.escape(var29_23) + " " + var31_25);
            var46_48 /* !! */  = (String)this.getShapeProperty(var1_1, "ID");
            if (var46_48 /* !! */  != null) {
                var24_19 = ((Float)this.getShapeProperty(var1_1, "cutoff")).floatValue();
                if (Float.isNaN(var24_19) && !Float.isNaN(var23_18)) {
                    Logger.error("sigma not supported");
                }
                var46_48 /* !! */  = (String)var46_48 /* !! */  + " created with cutoff=" + var24_19;
                var47_49 /* !! */  = (String[])((float[])this.getShapeProperty(var1_1, "minMaxInfo"));
                if (var47_49 /* !! */ [0] != 3.4028235E38f) {
                    var46_48 /* !! */  = (String)var46_48 /* !! */  + " min=" + (float)var47_49 /* !! */ [0] + " max=" + (float)var47_49 /* !! */ [1];
                }
                var46_48 /* !! */  = (String)var46_48 /* !! */  + "; number of isosurfaces = " + this.getShapeProperty(var1_1, "count");
                var46_48 /* !! */  = (String)var46_48 /* !! */  + this.getIsosurfaceDataRange(var1_1, "\n");
                if (var9_9) {
                    var46_48 /* !! */  = (String)var46_48 /* !! */  + "\nisosurfaceArea = " + Escape.escapeArray(var44_39);
                }
                if (var10_10) {
                    var46_48 /* !! */  = (String)var46_48 /* !! */  + "\nisosurfaceVolume = " + Escape.escapeArray(var45_47);
                }
                this.showString((String)var46_48 /* !! */ );
            }
        } else if (var9_9 || var10_10) {
            if (var9_9) {
                this.showString("isosurfaceArea = " + Escape.escapeArray(var44_39));
            }
            if (var10_10) {
                this.showString("isosurfaceVolume = " + Escape.escapeArray(var45_47));
            }
        }
        if (var38_31 != null) {
            this.setShapeProperty(var1_1, "translucency", var38_31);
        }
        this.setShapeProperty(var1_1, "clear", null);
    }

    private String getIsosurfaceDataRange(int n, String string) {
        float[] fArray = (float[])this.getShapeProperty(n, "dataRange");
        return fArray != null && fArray[0] != Float.MAX_VALUE && fArray[0] != fArray[1] ? string + "isosurface" + " full data range " + fArray[0] + " to " + fArray[1] + " with color scheme spanning " + fArray[2] + " to " + fArray[3] : "";
    }

    private void getWithinDistanceVector(List<Object[]> list, float f, Point3f point3f, BitSet bitSet, boolean bl) {
        ArrayList<Point3f> arrayList = new ArrayList<Point3f>();
        Point3f[] point3fArray = new Point3f[2];
        if (bitSet == null) {
            Point3f point3f2 = new Point3f(f, f, f);
            Point3f point3f3 = new Point3f(point3f);
            point3f3.sub(point3f2);
            point3f2.add(point3f);
            point3fArray[0] = point3f3;
            point3fArray[1] = point3f2;
            arrayList.add(point3f);
        } else {
            BoxInfo boxInfo = this.viewer.getBoxInfo(bitSet, -f);
            point3fArray[0] = boxInfo.getBboxVertices()[0];
            point3fArray[1] = boxInfo.getBboxVertices()[7];
            if (bitSet.cardinality() == 1) {
                arrayList.add(this.viewer.getAtomPoint3f(bitSet.nextSetBit(0)));
            }
        }
        if (arrayList.size() == 1 && !bl) {
            this.addShapeProperty(list, "withinDistance", new Float(f));
            this.addShapeProperty(list, "withinPoint", arrayList.get(0));
        }
        this.addShapeProperty(list, bl ? "displayWithin" : "withinPoints", new Object[]{new Float(f), point3fArray, bitSet, arrayList});
    }

    private boolean setMeshDisplayProperty(int n, int n2, int n3) throws ScriptException {
        boolean bl;
        String string = null;
        Serializable serializable = null;
        boolean bl2 = bl = n2 == 0;
        if (!bl) {
            this.iToken = n2;
        }
        switch (n3) {
            case 1073741995: {
                if (bl) {
                    return true;
                }
                Point3f point3f = this.getPoint3f(this.iToken + 1, false);
                point3f.x = (int)point3f.x;
                point3f.y = (int)point3f.y;
                point3f.z = (int)point3f.z;
                string = "lattice";
                serializable = point3f;
                break;
            }
            case 1073742074: 
            case 1073742180: {
                if (!bl) {
                    this.colorShape(n, this.iToken, false);
                }
                return true;
            }
            case 0: 
            case 12291: 
            case 12294: 
            case 0x10000C: 
            case 0x10000D: 
            case 3145751: 
            case 3145752: 
            case 1610625028: {
                if (this.iToken == 1) {
                    this.setShapeProperty(n, "thisID", null);
                }
                if (n3 == 0) {
                    return this.iToken == 1;
                }
                if (bl) {
                    return true;
                }
                switch (n3) {
                    case 12291: {
                        this.setShapeProperty(n, "delete", null);
                        return true;
                    }
                    case 12294: 
                    case 3145752: {
                        n3 = 0x10000C;
                        break;
                    }
                    case 3145751: {
                        n3 = 0x10000D;
                        break;
                    }
                    case 1610625028: {
                        if (n2 + 1 != this.statementLength) break;
                        n3 = 0x10000D;
                    }
                }
            }
            case 1073741862: 
            case 0x4000004A: 
            case 1073741938: 
            case 1073741958: 
            case 0x40000088: 
            case 1073741964: 
            case 1073742018: 
            case 0x400000D4: 
            case 1073742042: 
            case 1073742046: 
            case 0x400000E4: 
            case 1073742058: 
            case 1073742060: 
            case 1073742182: 
            case 1113198595: {
                string = "token";
                serializable = n3;
            }
        }
        if (string == null) {
            return false;
        }
        if (bl) {
            return true;
        }
        this.setShapeProperty(n, string, serializable);
        n3 = this.tokAt(this.iToken + 1);
        if (n3 != 0 && !this.setMeshDisplayProperty(n, ++this.iToken, n3)) {
            --this.iToken;
        }
        return true;
    }

    private void bind() throws ScriptException {
        String string = this.stringParameter(1);
        String string2 = this.parameterAsString(2);
        Point3f point3f = null;
        Point3f point3f2 = null;
        this.checkLength(3);
        if (!this.isSyntaxCheck) {
            this.viewer.bindAction(string, string2, point3f, point3f2);
        }
    }

    private void unbind() throws ScriptException {
        if (this.statementLength != 1) {
            this.checkLength23();
        }
        String string = this.optParameterAsString(1);
        String string2 = this.optParameterAsString(2);
        if (string.length() == 0 || this.tokAt(1) == 0x100003) {
            string = null;
        }
        if (string2.length() == 0 || this.tokAt(2) == 0x100003) {
            string2 = null;
        }
        if (string2 == null && string != null && ActionManager.getActionFromName(string) >= 0) {
            string2 = string;
            string = null;
        }
        if (!this.isSyntaxCheck) {
            this.viewer.unBindAction(string, string2);
        }
    }

    class ScriptException
    extends Exception {
        private String message;
        private String untranslated;

        ScriptException(String string, String string2) {
            ScriptEvaluator.this.errorType = this.message = string;
            ScriptEvaluator.this.iCommandError = ScriptEvaluator.this.pc;
            String string3 = this.untranslated = string2 == null ? string : string2;
            if (this.message == null) {
                this.message = "";
                return;
            }
            String string4 = ScriptEvaluator.this.getScriptContext().getContextTrace(null, true).toString();
            while (ScriptEvaluator.this.scriptLevel > 0) {
                ScriptEvaluator.this.popContext(false, false);
            }
            this.message = this.message + string4;
            this.untranslated = this.untranslated + string4;
            if (ScriptEvaluator.this.isSyntaxCheck || string.indexOf("file recognized as a script file:") >= 0) {
                return;
            }
            Logger.error("eval ERROR: " + this.toString());
            if (ScriptEvaluator.this.viewer.autoExit) {
                ScriptEvaluator.this.viewer.exitJmol();
            }
        }

        protected String getErrorMessageUntranslated() {
            return this.untranslated;
        }

        public String toString() {
            return this.message;
        }
    }
}

