/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.util.BitSet;
import java.util.List;
import java.util.Map;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.atomdata.RadiusData;
import org.jmol.jvxl.readers.SurfaceReader;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameters {
    public static final int STATE_UNINITIALIZED = 0;
    public static final int STATE_INITIALIZED = 1;
    public static final int STATE_DATA_READ = 2;
    public static final int STATE_DATA_COLORED = 3;
    int state = 0;
    boolean logMessages = false;
    boolean logCompression = false;
    boolean logCube = false;
    boolean isSilent = false;
    float assocCutoff = 0.3f;
    static final int NO_ANISOTROPY = 32;
    static final int IS_SILENT = 64;
    public static final int IS_SOLVENTTYPE = 128;
    static final int HAS_MAXGRID = 256;
    public int dataType;
    int surfaceType;
    static final int SURFACE_NONE = 0;
    static final int SURFACE_SPHERE = 65;
    static final int SURFACE_ELLIPSOID2 = 66;
    static final int SURFACE_ELLIPSOID3 = 67;
    static final int SURFACE_LOBE = 68;
    static final int SURFACE_LCAOCARTOON = 69;
    public static final int SURFACE_LONEPAIR = 70;
    public static final int SURFACE_RADICAL = 71;
    static final int SURFACE_FUNCTIONXY = 8;
    static final int SURFACE_FUNCTIONXYZ = 9;
    static final int SURFACE_SOLVENT = 171;
    static final int SURFACE_SASURFACE = 172;
    static final int SURFACE_MOLECULARORBITAL = 301;
    static final int SURFACE_ATOMICORBITAL = 270;
    static final int SURFACE_MEP = 304;
    static final int SURFACE_MLP = 305;
    static final int SURFACE_MOLECULAR = 179;
    static final int SURFACE_NOMAP = 180;
    static final int SURFACE_PROPERTY = 181;
    String calculationType = "";
    RadiusData atomRadiusData;
    boolean addHydrogens;
    float solventRadius;
    float solventExtendedAtomRadius;
    boolean propertySmoothing;
    int propertySmoothingPower = 4;
    float envelopeRadius;
    float cavityRadius;
    boolean isCavity;
    Boolean pocket;
    int minSet;
    public Object cappingObject;
    public Object slabbingObject;
    float slabPlaneOffset = Float.NaN;
    float[] theProperty;
    float solvent_ptsPerAngstrom = 4.0f;
    int solvent_gridMax = 60;
    static final float ANGSTROMS_PER_BOHR = 0.5291772f;
    static final int defaultEdgeFractionBase = 35;
    static final int defaultEdgeFractionRange = 90;
    static final int defaultColorFractionBase = 35;
    static final int defaultColorFractionRange = 90;
    static final float defaultMappedDataMin = 0.0f;
    static final float defaultMappedDataMax = 1.0f;
    static final float defaultCutoff = 0.02f;
    static final float defaultOrbitalCutoff = 0.14f;
    public static final float defaultQMOrbitalCutoff = 0.05f;
    static final float defaultQMElectronDensityCutoff = 0.01f;
    static final int defaultContourCount = 11;
    static final int nContourMax = 100;
    static final int defaultColorNegative = -65536;
    static final int defaultColorPositive = -16776961;
    static final int defaultColorNegativeLCAO = -8388480;
    static final int defaultColorPositiveLCAO = -23296;
    static final float defaultSolventRadius = 1.2f;
    static final float defaultMepCutoff = 0.1f;
    static final float defaultMepMin = -0.1f;
    static final float defaultMepMax = 0.1f;
    boolean colorBySign;
    boolean colorByPhase;
    boolean colorBySets;
    int colorNeg;
    int colorPos;
    int colorPosLCAO;
    int colorNegLCAO;
    int colorPhase;
    public boolean colorDensity;
    boolean iAddGridPoints;
    boolean remappable;
    int atomIndex;
    boolean isAngstroms;
    float scale;
    public float scale3d;
    float[] anisotropy = new float[3];
    boolean isAnisotropic;
    Matrix3f eccentricityMatrix;
    Matrix3f eccentricityMatrixInverse;
    boolean isEccentric;
    float eccentricityScale;
    float eccentricityRatio;
    float[] aniosU;
    float[] anisoB;
    String lcaoType;
    public List<Object> functionXYinfo;
    int psi_n = 2;
    int psi_l = 1;
    int psi_m = 1;
    float psi_Znuc = 1.0f;
    float psi_ptsPerAngstrom = 5.0f;
    public static final int MEP_MAX_GRID = 40;
    int mep_gridMax = 40;
    float mep_ptsPerAngstrom = 3.0f;
    float mep_marginAngstroms = 1.0f;
    public int mep_calcType = -1;
    int qmOrbitalType;
    int qmOrbitalCount;
    static final int QM_TYPE_UNKNOWN = 0;
    static final int QM_TYPE_GAUSSIAN = 1;
    static final int QM_TYPE_SLATER = 2;
    Map<String, Object> moData;
    Map<String, Object> mo;
    float[] moCoefficients;
    int[][] dfCoefMaps;
    public static final int MO_MAX_GRID = 80;
    int qm_gridMax = 80;
    float qm_ptsPerAngstrom = 10.0f;
    float qm_marginAngstroms = 1.0f;
    int qm_nAtoms;
    int qm_moNumber = Integer.MAX_VALUE;
    Point3f center;
    Point3f point;
    float distance;
    String script;
    BitSet bsSelected;
    BitSet bsIgnore;
    BitSet bsSolvent;
    boolean iUseBitSets = false;
    String[] title;
    boolean blockCubeData;
    boolean readAllData;
    int fileIndex;
    String fileName;
    int modelIndex = -1;
    public boolean isXLowToHigh;
    boolean insideOut;
    boolean dataXYReversed;
    public float cutoff = Float.MAX_VALUE;
    public float sigma = Float.MAX_VALUE;
    boolean cutoffAutomatic = true;
    public boolean isCutoffAbsolute;
    boolean isPositiveOnly;
    boolean rangeAll;
    boolean rangeSelected;
    public boolean rangeDefined;
    float valueMappedToRed;
    float valueMappedToBlue;
    float mappedDataMin;
    float mappedDataMax;
    boolean isColorReversed;
    boolean isBicolorMap;
    public boolean isSquared;
    public Point4f thePlane;
    public boolean isContoured;
    int nContours;
    int thisContour;
    boolean contourFromZero;
    float resolution;
    int downsampleFactor;
    int maxSet;
    public float[] contoursDiscrete;
    public short[] contourColixes;
    Point3f contourIncrements;
    public Point3f[] boundingBox;
    public BitSet[] bsExcluded;
    public int contourType;
    public boolean colorSchemeTranslucent;
    public ColorEncoder colorEncoder;
    public boolean usePropertyForColorRange = true;
    public boolean isPeriodic;

    void initialize() {
        this.addHydrogens = false;
        this.atomIndex = -1;
        this.blockCubeData = false;
        this.bsIgnore = null;
        this.bsSelected = null;
        this.bsSolvent = null;
        this.calculationType = "";
        this.center = new Point3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        this.cappingObject = null;
        this.colorBySets = false;
        this.colorByPhase = false;
        this.colorBySign = false;
        this.colorDensity = false;
        this.colorEncoder = null;
        this.colorNeg = -65536;
        this.colorNegLCAO = -8388480;
        this.colorPos = -16776961;
        this.colorPosLCAO = -23296;
        this.cutoff = Float.MAX_VALUE;
        this.cutoffAutomatic = true;
        this.dataXYReversed = false;
        this.distance = Float.MAX_VALUE;
        this.envelopeRadius = 10.0f;
        this.fileIndex = 1;
        this.readAllData = true;
        this.fileName = "";
        this.functionXYinfo = null;
        this.iAddGridPoints = false;
        this.insideOut = false;
        this.isAngstroms = false;
        this.isPositiveOnly = false;
        this.isCutoffAbsolute = false;
        this.isBicolorMap = false;
        this.isCavity = false;
        this.isColorReversed = false;
        this.isSquared = false;
        this.isContoured = false;
        this.isAnisotropic = false;
        this.isEccentric = false;
        this.isSilent = false;
        this.iUseBitSets = false;
        this.logCompression = false;
        this.logCube = false;
        this.logMessages = Logger.debugging;
        this.mappedDataMin = Float.MAX_VALUE;
        this.minSet = 0;
        this.modelIndex = -1;
        this.boundingBox = null;
        this.bsExcluded = new BitSet[4];
        this.nContours = 0;
        this.colorSchemeTranslucent = false;
        this.contourIncrements = null;
        this.contoursDiscrete = null;
        this.contourColixes = null;
        this.mep_calcType = -1;
        this.pocket = null;
        this.propertySmoothing = false;
        this.propertySmoothingPower = 4;
        this.rangeDefined = false;
        this.resolution = Float.MAX_VALUE;
        this.scale = Float.NaN;
        this.scale3d = 0.0f;
        this.sigma = Float.NaN;
        this.slabbingObject = null;
        this.solventExtendedAtomRadius = 0.0f;
        this.state = 1;
        this.thePlane = null;
        this.theProperty = null;
        this.usePropertyForColorRange = true;
        this.thisContour = -1;
        this.contourFromZero = true;
        this.title = null;
        this.atomRadiusData = null;
        this.rangeAll = false;
        this.rangeSelected = false;
        this.isPeriodic = false;
    }

    void setAnisotropy(Point3f point3f) {
        this.anisotropy[0] = point3f.x;
        this.anisotropy[1] = point3f.y;
        this.anisotropy[2] = point3f.z;
        this.isAnisotropic = true;
        if (this.center.x == Float.MAX_VALUE) {
            this.center.set(0.0f, 0.0f, 0.0f);
        }
    }

    void setEccentricity(Point4f point4f) {
        Vector3f vector3f = new Vector3f(point4f.x, point4f.y, point4f.z);
        float f = this.scale > 0.0f ? this.scale : (point4f.w < 0.0f ? 1.0f : vector3f.length());
        float f2 = Math.abs(point4f.w);
        vector3f.normalize();
        Vector3f vector3f2 = new Vector3f(0.0f, 0.0f, 1.0f);
        vector3f.add((Tuple3f)vector3f2);
        vector3f.normalize();
        if (Float.isNaN(vector3f.x)) {
            vector3f.set(1.0f, 0.0f, 0.0f);
        }
        this.eccentricityMatrix = new Matrix3f();
        this.eccentricityMatrix.setIdentity();
        this.eccentricityMatrix.set(new AxisAngle4f(vector3f, (float)Math.PI));
        this.eccentricityMatrixInverse = new Matrix3f();
        this.eccentricityMatrixInverse.invert(this.eccentricityMatrix);
        this.isAnisotropic = true;
        this.isEccentric = true;
        this.eccentricityScale = f;
        this.eccentricityRatio = f2;
        if (f2 > 1.0f) {
            this.eccentricityScale *= f2;
        }
        this.anisotropy[0] = f2 * f;
        this.anisotropy[1] = f2 * f;
        this.anisotropy[2] = f;
        if (this.center.x == Float.MAX_VALUE) {
            this.center.set(0.0f, 0.0f, 0.0f);
        }
    }

    void setPlane(Point4f point4f) {
        this.thePlane = point4f;
        if (this.thePlane.x == 0.0f && this.thePlane.y == 0.0f && this.thePlane.z == 0.0f) {
            this.thePlane.z = 1.0f;
        }
        this.isContoured = true;
    }

    void setSphere(float f) {
        this.dataType = 65;
        this.distance = f;
        this.setEccentricity(new Point4f(0.0f, 0.0f, 1.0f, 1.0f));
        this.cutoff = Float.MIN_VALUE;
        this.isCutoffAbsolute = false;
        this.isSilent = !this.logMessages;
        this.script = this.getScriptParams() + " SPHERE " + f + ";";
    }

    void setEllipsoid(Point4f point4f) {
        this.dataType = 66;
        this.distance = 1.0f;
        this.setEccentricity(point4f);
        this.cutoff = Float.MIN_VALUE;
        this.isCutoffAbsolute = false;
        this.isSilent = !this.logMessages;
    }

    public void setEllipsoid(float[] fArray) {
        this.anisoB = fArray;
        for (int i = 0; i < 6; ++i) {
            System.out.print(fArray[i] + " ");
        }
        System.out.println(" in Parameters setEllipsoid" + this.center);
        this.dataType = 67;
        this.distance = 0.3f * (Float.isNaN(this.scale) ? 1.0f : this.scale);
        this.cutoff = Float.MIN_VALUE;
        this.isCutoffAbsolute = false;
        boolean bl = this.isSilent = !this.logMessages;
        if (this.center.x == Float.MAX_VALUE) {
            this.center.set(0.0f, 0.0f, 0.0f);
        }
        if (this.resolution == Float.MAX_VALUE) {
            this.resolution = 6.0f;
        }
    }

    void setLobe(Point4f point4f) {
        this.dataType = 68;
        this.setEccentricity(point4f);
        if (this.cutoff == Float.MAX_VALUE) {
            this.cutoff = 0.14f;
            if (this.isSquared) {
                this.cutoff *= this.cutoff;
            }
        }
        this.isSilent = !this.logMessages;
        this.script = this.getScriptParams() + " LOBE {" + point4f.x + " " + point4f.y + " " + point4f.z + " " + point4f.w + "};";
    }

    private String getScriptParams() {
        return (this.slabbingObject == null ? "" : " slab within " + Escape.escape((Object)this.slabbingObject)) + (this.cappingObject == null ? "" : " cap within " + Escape.escape((Object)this.cappingObject)) + " center " + Escape.escape((Tuple3f)this.center) + (Float.isNaN(this.scale) ? "" : " scale " + this.scale);
    }

    void setLp(Point4f point4f) {
        this.dataType = 70;
        this.setEccentricity(point4f);
        if (this.cutoff == Float.MAX_VALUE) {
            this.cutoff = 0.14f;
            if (this.isSquared) {
                this.cutoff *= this.cutoff;
            }
        }
        this.isSilent = !this.logMessages;
        this.script = " center " + Escape.escape((Tuple3f)this.center) + (Float.isNaN(this.scale) ? "" : " scale " + this.scale) + " LP {" + point4f.x + " " + point4f.y + " " + point4f.z + " " + point4f.w + "};";
    }

    void setRadical(Point4f point4f) {
        this.dataType = 71;
        this.setEccentricity(point4f);
        if (this.cutoff == Float.MAX_VALUE) {
            this.cutoff = 0.14f;
            if (this.isSquared) {
                this.cutoff *= this.cutoff;
            }
        }
        this.isSilent = !this.logMessages;
        this.script = " center " + Escape.escape((Tuple3f)this.center) + (Float.isNaN(this.scale) ? "" : " scale " + this.scale) + " RAD {" + point4f.x + " " + point4f.y + " " + point4f.z + " " + point4f.w + "};";
    }

    void setLcao(String string, int n) {
        this.lcaoType = string;
        if (n == 1) {
            this.colorPosLCAO = this.colorNegLCAO;
        }
        this.isSilent = !this.logMessages;
    }

    void setRadius(RadiusData radiusData) {
        this.atomRadiusData = radiusData;
    }

    void setSolvent(String string, float f) {
        this.isAnisotropic = false;
        this.isEccentric = false;
        this.solventRadius = f;
        if (this.solventRadius < 0.0f) {
            this.solventRadius = 1.2f;
        }
        this.dataType = "nomap" == string ? 180 : ("molecular" == string ? 179 : ("sasurface" == string || this.solventRadius == 0.0f ? 172 : 171));
        switch (this.dataType) {
            case 180: {
                this.calculationType = "unmapped plane";
                break;
            }
            case 179: {
                this.calculationType = "molecular surface with radius " + this.solventRadius;
                break;
            }
            case 171: {
                this.calculationType = "solvent-excluded surface with radius " + this.solventRadius;
                break;
            }
            case 172: {
                this.calculationType = "solvent-accessible surface with radius " + this.solventRadius;
            }
        }
        switch (this.dataType) {
            case 180: {
                this.solventExtendedAtomRadius = this.solventRadius;
                this.solventRadius = 0.0f;
                this.isContoured = false;
                break;
            }
            case 179: {
                this.solventExtendedAtomRadius = 0.0f;
                break;
            }
            case 171: {
                this.solventExtendedAtomRadius = 0.0f;
                if (this.bsIgnore != null) break;
                this.bsIgnore = this.bsSolvent;
                break;
            }
            case 172: {
                this.solventExtendedAtomRadius = this.solventRadius;
                this.solventRadius = 0.0f;
                if (this.bsIgnore != null) break;
                this.bsIgnore = this.bsSolvent;
            }
        }
    }

    void setFunctionXY(List<Object> list) {
        this.dataType = 8;
        this.functionXYinfo = list;
        this.cutoff = Float.MIN_VALUE;
        this.isAnisotropic = false;
        this.isEccentric = false;
    }

    void setFunctionXYZ(List<Object> list) {
        this.dataType = 9;
        this.functionXYinfo = list;
        this.cutoff = Float.MIN_VALUE;
        this.isAnisotropic = false;
        this.isEccentric = false;
    }

    boolean setAtomicOrbital(float[] fArray) {
        this.dataType = 270;
        this.psi_n = (int)fArray[0];
        this.psi_l = (int)fArray[1];
        this.psi_m = (int)fArray[2];
        this.psi_Znuc = fArray[3];
        this.psi_ptsPerAngstrom = 10.0f;
        if (this.cutoff == Float.MAX_VALUE) {
            this.cutoff = 0.14f;
            if (this.isSquared) {
                this.cutoff *= this.cutoff;
            }
        }
        this.isCutoffAbsolute = true;
        if (this.state < 2 && this.thePlane == null && this.colorBySign) {
            this.isBicolorMap = true;
        }
        return this.psi_Znuc > 0.0f && Math.abs(this.psi_m) <= this.psi_l && this.psi_l < this.psi_n;
    }

    void setMep(float[] fArray, boolean bl) {
        this.dataType = bl ? 305 : 304;
        this.theProperty = fArray;
        this.usePropertyForColorRange = false;
        this.isAnisotropic = false;
        this.isEccentric = false;
        if (this.cutoff == Float.MAX_VALUE) {
            this.cutoff = 0.1f;
            if (this.isSquared) {
                this.cutoff *= this.cutoff;
            }
        }
        this.isCutoffAbsolute = this.cutoff > 0.0f && !this.isPositiveOnly;
        this.contourFromZero = false;
        if (this.state >= 2 || this.thePlane != null) {
            if (!this.rangeDefined && !this.rangeAll) {
                this.valueMappedToRed = -0.1f;
                this.valueMappedToBlue = 0.1f;
                this.rangeDefined = true;
            }
        } else {
            this.colorBySign = true;
            this.isBicolorMap = true;
        }
    }

    void setMO(int n) {
        boolean bl;
        this.iUseBitSets = true;
        this.qm_moNumber = Math.abs(n);
        this.qmOrbitalType = this.moData.containsKey("gaussians") ? 1 : (this.moData.containsKey("slaters") ? 2 : 0);
        boolean bl2 = bl = n <= 0;
        if (this.qmOrbitalType == 0) {
            Logger.error((String)"MO ERROR: No basis functions found in file for MO calculation. (GAUSSIAN 'gfprint' keyword may be missing?)");
            this.mo = null;
            this.title = new String[]{"no basis functions found in file"};
        } else {
            List list = (List)this.moData.get("mos");
            this.qmOrbitalCount = list.size();
            this.calculationType = (String)this.moData.get("calculationType");
            this.calculationType = "Molecular orbital #" + this.qm_moNumber + "/" + this.qmOrbitalCount + " " + (this.calculationType == null ? "" : this.calculationType);
            if (!bl) {
                if (this.title == null) {
                    this.title = new String[5];
                    this.title[0] = "%F";
                    this.title[1] = "Model %M  MO %I/%N %T";
                    this.title[2] = "?Energy = %E %U";
                    this.title[3] = "?Symmetry = %S";
                    this.title[4] = "?Occupancy = %O";
                }
                this.mo = (Map)list.get(this.qm_moNumber - 1);
                this.moCoefficients = (float[])this.mo.get("coefficients");
                this.dfCoefMaps = (int[][])this.mo.get("dfCoefMaps");
            }
        }
        this.dataType = 301;
        if (this.cutoff == Float.MAX_VALUE) {
            float f = this.cutoff = bl ? 0.01f : 0.05f;
            if (this.isSquared) {
                this.cutoff *= this.cutoff;
            }
        }
        this.isAnisotropic = false;
        this.isEccentric = false;
        boolean bl3 = this.isCutoffAbsolute = this.cutoff > 0.0f && !this.isPositiveOnly;
        if (this.state >= 2 || this.thePlane != null) {
            return;
        }
        this.colorBySign = true;
        if (this.colorByPhase && this.colorPhase == 0) {
            this.colorByPhase = false;
        }
        this.isBicolorMap = true;
    }

    void setMapRanges(SurfaceReader surfaceReader, boolean bl) {
        if (!this.colorDensity && (this.colorByPhase || this.colorBySign || (this.thePlane != null || this.isBicolorMap) && !this.isContoured)) {
            this.mappedDataMin = -1.0f;
            this.mappedDataMax = 1.0f;
        }
        if (this.mappedDataMin == Float.MAX_VALUE || this.mappedDataMin == this.mappedDataMax) {
            float[] fArray = surfaceReader.getMinMaxMappedValues(bl);
            this.mappedDataMin = fArray[0];
            this.mappedDataMax = fArray[1];
        }
        if (this.mappedDataMin == 0.0f && this.mappedDataMax == 0.0f) {
            this.mappedDataMin = -1.0f;
            this.mappedDataMax = 1.0f;
        }
        if (!this.rangeDefined) {
            this.valueMappedToRed = this.mappedDataMin;
            this.valueMappedToBlue = this.mappedDataMax;
        }
    }
}

