/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.util.List;
import java.util.Map;
import org.jmol.api.Interface;
import org.jmol.api.MOCalculationInterface;
import org.jmol.api.VolumeDataInterface;
import org.jmol.jvxl.readers.AtomDataReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IsoMOReader
extends AtomDataReader {
    IsoMOReader(SurfaceGenerator surfaceGenerator) {
        super(surfaceGenerator);
    }

    @Override
    protected void setup() {
        super.setup();
        this.doAddHydrogens = false;
        this.getAtoms(this.params.qm_marginAngstroms, true, false);
        this.setHeader("MO", "calculation type: " + this.params.moData.get("calculationType"));
        this.setRangesAndAddAtoms(this.params.qm_ptsPerAngstrom, this.params.qm_gridMax, this.myAtomCount);
        int n = this.params.title.length;
        while (--n >= 0) {
            this.fixTitleLine(n, this.params.mo);
        }
    }

    private void fixTitleLine(int n, Map<String, Object> map) {
        if (!this.fixTitleLine(n)) {
            return;
        }
        String string = this.params.title[n];
        int n2 = string.indexOf("%");
        if (string.length() == 0 || n2 < 0) {
            return;
        }
        int n3 = 0;
        if (string.indexOf("%F") >= 0) {
            string = TextFormat.formatString((String)string, (String)"F", (String)this.params.fileName);
        }
        if (string.indexOf("%I") >= 0) {
            string = TextFormat.formatString((String)string, (String)"I", (String)("" + this.params.qm_moNumber));
        }
        if (string.indexOf("%N") >= 0) {
            string = TextFormat.formatString((String)string, (String)"N", (String)("" + this.params.qmOrbitalCount));
        }
        if (string.indexOf("%E") >= 0) {
            string = TextFormat.formatString((String)string, (String)"E", (String)(map.containsKey("energy") && ++n3 != 0 ? "" + map.get("energy") : ""));
        }
        if (string.indexOf("%U") >= 0) {
            string = TextFormat.formatString((String)string, (String)"U", (String)(this.params.moData.containsKey("energyUnits") && ++n3 != 0 ? (String)this.params.moData.get("energyUnits") : ""));
        }
        if (string.indexOf("%S") >= 0) {
            string = TextFormat.formatString((String)string, (String)"S", (String)(map.containsKey("symmetry") && ++n3 != 0 ? "" + map.get("symmetry") : ""));
        }
        if (string.indexOf("%O") >= 0) {
            string = TextFormat.formatString((String)string, (String)"O", (String)(map.containsKey("occupancy") && ++n3 != 0 ? "" + map.get("occupancy") : ""));
        }
        if (string.indexOf("%T") >= 0) {
            string = TextFormat.formatString((String)string, (String)"T", (String)(map.containsKey("type") && ++n3 != 0 ? "" + map.get("type") : ""));
        }
        boolean bl = string.indexOf("?") == 0;
        this.params.title[n] = !bl ? string : (n3 > 0 && !string.trim().endsWith("=") ? string.substring(1) : "");
    }

    @Override
    protected void generateCube() {
        this.voxelData = new float[this.nPointsX][this.nPointsY][this.nPointsZ];
        this.volumeData.voxelData = this.voxelData;
        MOCalculationInterface mOCalculationInterface = (MOCalculationInterface)Interface.getOptionInterface((String)"quantum.MOCalculation");
        Map<String, Object> map = this.params.moData;
        float[] fArray = this.params.moCoefficients;
        int[][] nArray = this.params.dfCoefMaps;
        if (fArray == null) {
            List list = (List)map.get("mos");
            if (list == null) {
                return;
            }
            int n = this.params.qm_moNumber;
            while (--n >= 0) {
                Logger.info((String)(" generating isosurface data for MO " + (n + 1)));
                Map map2 = (Map)list.get(n);
                fArray = (float[])map2.get("coefficients");
                nArray = (int[][])map2.get("dfCoefMaps");
                this.getData(mOCalculationInterface, map, fArray, nArray, this.params.theProperty);
            }
        } else {
            Logger.info((String)("generating isosurface data for MO using cutoff " + this.params.cutoff));
            this.getData(mOCalculationInterface, map, fArray, nArray, null);
        }
    }

    private void getData(MOCalculationInterface mOCalculationInterface, Map<String, Object> map, float[] fArray, int[][] nArray, float[] fArray2) {
        switch (this.params.qmOrbitalType) {
            case 1: {
                mOCalculationInterface.calculate((VolumeDataInterface)this.volumeData, this.bsMySelected, (String)map.get("calculationType"), this.atomData.atomXyz, this.atomData.firstAtomIndex, (List)map.get("shells"), (float[][])map.get("gaussians"), nArray, null, fArray, fArray2, map.get("isNormalized") == null);
                break;
            }
            case 2: {
                mOCalculationInterface.calculate((VolumeDataInterface)this.volumeData, this.bsMySelected, (String)map.get("calculationType"), this.atomData.atomXyz, this.atomData.firstAtomIndex, null, (float[][])null, (int[][])null, map.get("slaters"), fArray, fArray2, true);
                break;
            }
        }
    }
}

