/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import org.jmol.g3d.Graphics3D;

final class Shade3D {
    static final int shadeIndexMax = 64;
    static final int shadeIndexLast = 63;
    static final byte shadeIndexNormal = 52;
    static final byte shadeIndexNoisyLimit = 56;
    public static int zPower = 1;
    private static final float xLightsource = -1.0f;
    private static final float yLightsource = -1.0f;
    private static final float zLightsource = 2.5f;
    private static final float magnitudeLight = (float)Math.sqrt(8.25);
    static final float xLight = -1.0f / magnitudeLight;
    static final float yLight = -1.0f / magnitudeLight;
    static final float zLight = 2.5f / magnitudeLight;
    static boolean specularOn = true;
    static boolean usePhongExponent = false;
    static int ambientPercent = 45;
    static int diffusePercent = 84;
    static int specularExponent = 6;
    static int specularPercent = 22;
    static int specularPower = 40;
    static int phongExponent = 64;
    static float ambientFraction = (float)ambientPercent / 100.0f;
    static float diffuseFactor = (float)diffusePercent / 100.0f;
    static float intenseFraction = (float)specularPower / 100.0f;
    static float specularFactor = (float)specularPercent / 100.0f;
    static boolean sphereShadingCalculated = false;
    static final byte[] sphereShadeIndexes = new byte[65536];
    private static int seed = 305419897;

    Shade3D() {
    }

    static int[] getShades(int n, boolean bl) {
        int n2;
        int[] nArray = new int[64];
        if (n == 0) {
            return nArray;
        }
        float f = n >> 16 & 0xFF;
        float f2 = n >> 8 & 0xFF;
        float f3 = n & 0xFF;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = ambientFraction;
        while (true) {
            f4 = f * f7 + 0.5f;
            f5 = f2 * f7 + 0.5f;
            f6 = f3 * f7 + 0.5f;
            if (!(f7 > 0.0f) || !(f4 < 4.0f) || !(f5 < 4.0f) || !(f6 < 4.0f)) break;
            f += 1.0f;
            f2 += 1.0f;
            f3 += 1.0f;
            if (f7 < 0.1f) {
                f7 += 0.1f;
            }
            n = Shade3D.rgb((int)f, (int)f2, (int)f3);
        }
        f7 = (1.0f - f7) / 52.0f;
        float f8 = f * f7;
        float f9 = f2 * f7;
        float f10 = f3 * f7;
        for (n2 = 0; n2 < 52; ++n2) {
            nArray[n2] = Shade3D.rgb((int)f4, (int)f5, (int)f6);
            f4 += f8;
            f5 += f9;
            f6 += f10;
        }
        nArray[n2++] = n;
        f7 = intenseFraction / (float)(64 - n2);
        f8 = (255.5f - f4) * f7;
        f9 = (255.5f - f5) * f7;
        f10 = (255.5f - f6) * f7;
        while (n2 < 64) {
            nArray[n2] = Shade3D.rgb((int)(f4 += f8), (int)(f5 += f9), (int)(f6 += f10));
            ++n2;
        }
        if (bl) {
            while (--n2 >= 0) {
                nArray[n2] = Graphics3D.calcGreyscaleRgbFromRgb(nArray[n2]);
            }
        }
        return nArray;
    }

    static final int rgb(int n, int n2, int n3) {
        return 0xFF000000 | n << 16 | n2 << 8 | n3;
    }

    static int getShadeIndex(float f, float f2, float f3) {
        double d = Math.sqrt(f * f + f2 * f2 + f3 * f3);
        return (int)(Shade3D.getFloatShadeIndexNormalized((float)((double)f / d), (float)((double)f2 / d), (float)((double)f3 / d)) * 63.0f + 0.5f);
    }

    static byte getShadeIndexNormalized(float f, float f2, float f3) {
        return (byte)(Shade3D.getFloatShadeIndexNormalized(f, f2, f3) * 63.0f + 0.5f);
    }

    static int getFp8ShadeIndex(float f, float f2, float f3) {
        double d = Math.sqrt(f * f + f2 * f2 + f3 * f3);
        return (int)(Shade3D.getFloatShadeIndexNormalized((float)((double)f / d), (float)((double)f2 / d), (float)((double)f3 / d)) * 63.0f * 256.0f);
    }

    private static float getFloatShadeIndexNormalized(float f, float f2, float f3) {
        float f4;
        float f5 = f * xLight + f2 * yLight + f3 * zLight;
        if (f5 <= 0.0f) {
            return 0.0f;
        }
        float f6 = f5 * diffuseFactor;
        if (specularOn && (f4 = 2.0f * f5 * f3 - zLight) > 0.0f) {
            if (usePhongExponent) {
                f4 = (float)Math.pow(f4, phongExponent);
            } else {
                int n = specularExponent;
                while (--n >= 0 && f4 > 1.0E-4f) {
                    f4 *= f4;
                }
            }
            f6 += f4 * specularFactor;
        }
        if (f6 > 1.0f) {
            return 1.0f;
        }
        return f6;
    }

    static byte getDitheredNoisyShadeIndex(float f, float f2, float f3, float f4) {
        int n;
        int n2 = (int)(Shade3D.getFloatShadeIndexNormalized(f / f4, f2 / f4, f3 / f4) * 63.0f * 256.0f);
        int n3 = n2 >> 8;
        if ((n2 & 0xFF) > Shade3D.nextRandom8Bit()) {
            ++n3;
        }
        if ((n = seed & 0xFFFF) < 21845 && n3 > 0) {
            --n3;
        } else if (n > 43690 && n3 < 63) {
            ++n3;
        }
        return (byte)n3;
    }

    static synchronized void calcSphereShading() {
        float f = -127.5f;
        for (int i = 0; i < 256; ++i) {
            float f2 = -127.5f;
            for (int j = 0; j < 256; ++j) {
                byte by = 0;
                float f3 = 16900.0f - f * f - f2 * f2;
                if (f3 > 0.0f) {
                    float f4 = (float)Math.sqrt(f3);
                    by = Shade3D.getDitheredNoisyShadeIndex(f, f2, f4, 130.0f);
                }
                Shade3D.sphereShadeIndexes[(j << 8) + i] = by;
                f2 += 1.0f;
            }
            f += 1.0f;
        }
        sphereShadingCalculated = true;
    }

    static int nextRandom8Bit() {
        int n = seed;
        seed = n = (n << 16) + (n << 1) + n & Integer.MAX_VALUE;
        return n >> 23;
    }
}

