/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeDataReader;

class IsoFxyzReader
extends VolumeDataReader {
    private String functionName;
    private float[][][] data;

    IsoFxyzReader(SurfaceGenerator surfaceGenerator) {
        super(surfaceGenerator);
        this.precalculateVoxelData = false;
    }

    protected void setup() {
        this.functionName = (String)this.params.functionXYinfo.get(0);
        this.jvxlFileHeaderBuffer = new StringBuffer();
        this.jvxlFileHeaderBuffer.append("functionXYZ\n").append(this.functionName).append("\n");
        this.volumetricOrigin.set((Tuple3f)((Point3f)this.params.functionXYinfo.get(1)));
        for (int i = 0; i < 3; ++i) {
            Point4f point4f = (Point4f)this.params.functionXYinfo.get(i + 2);
            this.voxelCounts[i] = Math.abs((int)point4f.x);
            this.volumetricVectors[i].set(point4f.y, point4f.z, point4f.w);
        }
        if (this.isAnisotropic) {
            this.setVolumetricAnisotropy();
        }
        this.data = (float[][][])this.params.functionXYinfo.get(5);
        JvxlCoder.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
    }

    public float getValue(int n, int n2, int n3, int n4) {
        return this.data[n][n2][n3];
    }
}

