#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <assert.h>
#include "graph.h"
#include "readfile.h"
#include "dotgen.h"
#include "config.h"

void printUsage()
{
	fprintf(stderr, "events2dot <eventsfile>\n");
}

void FindMaximum(void * content, void * arg)
{
	int maximum_edgewidth = *(int*)arg;
	AnnotatedEdge * node = (AnnotatedEdge *)content;

	while (node != NULL)
	{
		if (maximum_edgewidth < node->n_taken)
		{
			//fprintf("New maximum edgewidth: %d for %s to %s\n", maximum_edgewidth);
			maximum_edgewidth = node->n_taken;
		}
		node = node->next;
	}
	*(int *)arg = maximum_edgewidth;
}

int GetMaxEdgeWidth (AnnotatedGraph * g)
{
	int maximum_edgewidth=0;
	g->edgetree->walk(FindMaximum, (void*)&maximum_edgewidth);
	return maximum_edgewidth;

	/*int retval = 1;
	AnnotatedEdge * current = g->edges;
	while (current != NULL)
	{
		if (current->n_taken > retval)
			retval = current->n_taken;
		current=current->next;
	}
	return retval;
	*/
}

int main (int argc, char ** argv)
{
	NodeHashTbl * nodehash = new NodeHashTbl (255);
	GraphList g;

	if (((argc != 2) && (argc != 3))
		|| (strcmp(argv[1], "--help") == 0)
		|| (strcmp(argv[1], "-help") == 0)
		|| (strcmp(argv[1], "-?") == 0)
		|| (strcmp(argv[1], "-h") == 0))
	{
		printUsage();
		exit(0);
	}

	Config * config;
	if (argc == 3)
	  config = ReadConfig (argv[2]);
	else
	  config = ReadConfig ("pathalizer.conf");

	g = getGraphFromFile(argv[1], nodehash, config);

	/* Do filtering here ... */

	AnnotatedGraph * ag = summarize(g, config);

	int max_edgewidth = GetMaxEdgeWidth (ag);

	GenerateDot (stdout, ag, nodehash, config, max_edgewidth);

	return 0;
}
