#! perl
# Copyright (C) 2011, Parrot Foundation.

use warnings;
use strict;
use lib 'lib';
use Parrot::SHA1;
use Parrot::Git::Describe;

=head1 NAME

tools/build/gen_version.pl - generate runtime/parrot/include/parrot_version.pir

=head1 SYNOPSIS

    % perl tools/build/gen_version.pl >runtime/parrot/include/parrot_version.pir

=head1 DESCRIPTION

Generate C<runtime/parrot/include/parrot_version.pir>, which contains
information about which commit was used to build parrot.

=cut

my $sha1 = $Parrot::SHA1::current;
my $describe = $Parrot::Git::Describe::current;

print <<"PIR";
# generated by tools/build/gen_version.pl
.macro_const PARROT_SHA1 "$sha1"
.macro_const PARROT_GIT_DESCRIBE "$describe"
PIR


# Local Variables:
#   mode: cperl
#   cperl-indent-level: 4
#   fill-column: 100
# End:
# vim: expandtab shiftwidth=4:
