%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%
%%%%   MIT License
%%%%
%%%%   ParaMonte: plain powerful parallel Monte Carlo library.
%%%%
%%%%   Copyright (C) 2012-present, The Computational Data Science Lab
%%%%
%%%%   This file is part of the ParaMonte library.
%%%%
%%%%   Permission is hereby granted, free of charge, to any person obtaining a 
%%%%   copy of this software and associated documentation files (the "Software"), 
%%%%   to deal in the Software without restriction, including without limitation 
%%%%   the rights to use, copy, modify, merge, publish, distribute, sublicense, 
%%%%   and/or sell copies of the Software, and to permit persons to whom the 
%%%%   Software is furnished to do so, subject to the following conditions:
%%%%
%%%%   The above copyright notice and this permission notice shall be 
%%%%   included in all copies or substantial portions of the Software.
%%%%
%%%%   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
%%%%   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
%%%%   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
%%%%   IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
%%%%   DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR 
%%%%   OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
%%%%   OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
%%%%
%%%%   ACKNOWLEDGMENT
%%%%
%%%%   ParaMonte is an honor-ware and its currency is acknowledgment and citations.
%%%%   As per the ParaMonte library license agreement terms, if you use any parts of 
%%%%   this library for any purposes, kindly acknowledge the use of ParaMonte in your 
%%%%   work (education/research/industry/development/...) by citing the ParaMonte 
%%%%   library as described on this page:
%%%%
%%%%       https://github.com/cdslaborg/paramonte/blob/main/ACKNOWLEDGMENT.md
%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function c = getRGB(colorname)
% getRGB('amber')
% returns RGB tuples adapted from
% http://en.wikipedia.org/wiki/List_of_colors
color_database = containers.Map();
color_database('air force blue')=[0.360000 0.540000 0.660000];
color_database('alice blue')=[0.940000 0.970000 1.000000];
color_database('alizarin crimson')=[0.890000 0.150000 0.210000];
color_database('almond')=[0.940000 0.870000 0.800000];
color_database('amaranth')=[0.900000 0.170000 0.310000];
color_database('amber')=[1.000000 0.750000 0.000000];
color_database('amber (sae/ece)')=[1.000000 0.490000 0.000000];
color_database('american rose')=[1.000000 0.010000 0.240000];
color_database('amethyst')=[0.600000 0.400000 0.800000];
color_database('android green')=[0.640000 0.780000 0.220000];
color_database('anti-flash white')=[0.950000 0.950000 0.960000];
color_database('antique brass')=[0.800000 0.580000 0.460000];
color_database('antique fuchsia')=[0.570000 0.360000 0.510000];
color_database('antique white')=[0.980000 0.920000 0.840000];
color_database('ao (english)')=[0.000000 0.500000 0.000000];
color_database('apple green')=[0.550000 0.710000 0.000000];
color_database('apricot')=[0.980000 0.810000 0.690000];
color_database('aqua')=[0.000000 1.000000 1.000000];
color_database('aquamarine')=[0.500000 1.000000 0.830000];
color_database('army green')=[0.290000 0.330000 0.130000];
color_database('arsenic')=[0.230000 0.270000 0.290000];
color_database('arylide yellow')=[0.910000 0.840000 0.420000];
color_database('ash grey')=[0.700000 0.750000 0.710000];
color_database('asparagus')=[0.530000 0.660000 0.420000];
color_database('atomic tangerine')=[1.000000 0.600000 0.400000];
color_database('auburn')=[0.650000 0.160000 0.160000];
color_database('aureolin')=[0.990000 0.930000 0.000000];
color_database('aurometalsaurus')=[0.430000 0.500000 0.500000];
color_database('awesome')=[1.000000 0.130000 0.320000];
color_database('azure')=[0.000000 0.500000 1.000000];
color_database('azure mist/web')=[0.940000 1.000000 1.000000];
color_database('baby blue')=[0.470000 0.810000 0.940000];
color_database('baby blue eyes')=[0.630000 0.790000 0.950000];
color_database('baby pink')=[0.960000 0.760000 0.760000];
color_database('ball blue')=[0.130000 0.670000 0.800000];
color_database('banana mania')=[0.980000 0.910000 0.710000];
color_database('banana yellow')=[1.000000 0.880000 0.210000];
color_database('battleship grey')=[0.520000 0.520000 0.510000];
color_database('bazaar')=[0.600000 0.470000 0.480000];
color_database('bear')=[0.070000 0.100000 0.170000];
color_database('beau blue')=[0.740000 0.830000 0.900000];
color_database('beaver')=[0.620000 0.510000 0.440000];
color_database('beige')=[0.960000 0.960000 0.860000];
color_database('bisque')=[1.000000 0.890000 0.770000];
color_database('bistre')=[0.240000 0.170000 0.120000];
color_database('bittersweet')=[1.000000 0.440000 0.370000];
color_database('black')=[0.000000 0.000000 0.000000];
color_database('blanched almond')=[1.000000 0.920000 0.800000];
color_database('bleu de france')=[0.190000 0.550000 0.910000];
color_database('blizzard blue')=[0.670000 0.900000 0.930000];
color_database('blond')=[0.980000 0.940000 0.750000];
color_database('blue')=[0.000000 0.000000 1.000000];
color_database('blue (munsell)')=[0.000000 0.500000 0.690000];
color_database('blue (ncs)')=[0.000000 0.530000 0.740000];
color_database('blue (pigment)')=[0.200000 0.200000 0.600000];
color_database('blue (ryb)')=[0.010000 0.280000 1.000000];
color_database('blue bell')=[0.640000 0.640000 0.820000];
color_database('blue gray')=[0.400000 0.600000 0.800000];
color_database('blue-green')=[0.050000 0.600000 0.730000];
color_database('blue-violet')=[0.540000 0.170000 0.890000];
color_database('blush')=[0.870000 0.360000 0.510000];
color_database('bole')=[0.470000 0.270000 0.230000];
color_database('bondi blue')=[0.000000 0.580000 0.710000];
color_database('boston university red')=[0.800000 0.000000 0.000000];
color_database('boysenberry')=[0.530000 0.200000 0.380000];
color_database('brandeis blue')=[0.000000 0.440000 1.000000];
color_database('brass')=[0.710000 0.650000 0.260000];
color_database('brick red')=[0.800000 0.250000 0.330000];
color_database('bright cerulean')=[0.110000 0.670000 0.840000];
color_database('bright green')=[0.400000 1.000000 0.000000];
color_database('bright lavender')=[0.750000 0.580000 0.890000];
color_database('bright maroon')=[0.760000 0.130000 0.280000];
color_database('bright pink')=[1.000000 0.000000 0.500000];
color_database('bright turquoise')=[0.030000 0.910000 0.870000];
color_database('bright ube')=[0.820000 0.620000 0.910000];
color_database('brilliant lavender')=[0.960000 0.730000 1.000000];
color_database('brilliant rose')=[1.000000 0.330000 0.640000];
color_database('brink pink')=[0.980000 0.380000 0.500000];
color_database('british racing green')=[0.000000 0.260000 0.150000];
color_database('bronze')=[0.800000 0.500000 0.200000];
color_database('brown (traditional)')=[0.590000 0.290000 0.000000];
color_database('brown (web)')=[0.650000 0.160000 0.160000];
color_database('bubble gum')=[0.990000 0.760000 0.800000];
color_database('bubbles')=[0.910000 1.000000 1.000000];
color_database('buff')=[0.940000 0.860000 0.510000];
color_database('bulgarian rose')=[0.280000 0.020000 0.030000];
color_database('burgundy')=[0.500000 0.000000 0.130000];
color_database('burlywood')=[0.870000 0.720000 0.530000];
color_database('burnt orange')=[0.800000 0.330000 0.000000];
color_database('burnt sienna')=[0.910000 0.450000 0.320000];
color_database('burnt umber')=[0.540000 0.200000 0.140000];
color_database('byzantine')=[0.740000 0.200000 0.640000];
color_database('byzantium')=[0.440000 0.160000 0.390000];
color_database('cadet')=[0.330000 0.410000 0.470000];
color_database('cadet blue')=[0.370000 0.620000 0.630000];
color_database('cadet grey')=[0.570000 0.640000 0.690000];
color_database('cadmium green')=[0.000000 0.420000 0.240000];
color_database('cadmium orange')=[0.930000 0.530000 0.180000];
color_database('cadmium red')=[0.890000 0.000000 0.130000];
color_database('cadmium yellow')=[1.000000 0.960000 0.000000];
color_database('caf au lait')=[0.650000 0.480000 0.360000];
color_database('caf noir')=[0.290000 0.210000 0.130000];
color_database('cal poly pomona green')=[0.120000 0.300000 0.170000];
color_database('cambridge blue')=[0.640000 0.760000 0.680000];
color_database('camel')=[0.760000 0.600000 0.420000];
color_database('camouflage green')=[0.470000 0.530000 0.420000];
color_database('canary yellow')=[1.000000 0.940000 0.000000];
color_database('candy apple red')=[1.000000 0.030000 0.000000];
color_database('candy pink')=[0.890000 0.440000 0.480000];
color_database('capri')=[0.000000 0.750000 1.000000];
color_database('caput mortuum')=[0.350000 0.150000 0.130000];
color_database('cardinal')=[0.770000 0.120000 0.230000];
color_database('caribbean green')=[0.000000 0.800000 0.600000];
color_database('carmine')=[0.590000 0.000000 0.090000];
color_database('carmine pink')=[0.920000 0.300000 0.260000];
color_database('carmine red')=[1.000000 0.000000 0.220000];
color_database('carnation pink')=[1.000000 0.650000 0.790000];
color_database('carnelian')=[0.700000 0.110000 0.110000];
color_database('carolina blue')=[0.600000 0.730000 0.890000];
color_database('carrot orange')=[0.930000 0.570000 0.130000];
color_database('ceil')=[0.570000 0.630000 0.810000];
color_database('celadon')=[0.670000 0.880000 0.690000];
color_database('celeste (colour)')=[0.700000 1.000000 1.000000];
color_database('celestial blue')=[0.290000 0.590000 0.820000];
color_database('cerise')=[0.870000 0.190000 0.390000];
color_database('cerise pink')=[0.930000 0.230000 0.510000];
color_database('cerulean')=[0.000000 0.480000 0.650000];
color_database('cerulean blue')=[0.160000 0.320000 0.750000];
color_database('cg blue')=[0.000000 0.480000 0.650000];
color_database('cg red')=[0.880000 0.240000 0.190000];
color_database('chamoisee')=[0.630000 0.470000 0.350000];
color_database('champagne')=[0.970000 0.910000 0.810000];
color_database('charcoal')=[0.210000 0.270000 0.310000];
color_database('chartreuse (traditional)')=[0.870000 1.000000 0.000000];
color_database('chartreuse (web)')=[0.500000 1.000000 0.000000];
color_database('cherry blossom pink')=[1.000000 0.720000 0.770000];
color_database('chestnut')=[0.800000 0.360000 0.360000];
color_database('chocolate (traditional)')=[0.480000 0.250000 0.000000];
color_database('chocolate (web)')=[0.820000 0.410000 0.120000];
color_database('chrome yellow')=[1.000000 0.650000 0.000000];
color_database('cinereous')=[0.600000 0.510000 0.480000];
color_database('cinnabar')=[0.890000 0.260000 0.200000];
color_database('cinnamon')=[0.820000 0.410000 0.120000];
color_database('citrine')=[0.890000 0.820000 0.040000];
color_database('classic rose')=[0.980000 0.800000 0.910000];
color_database('cobalt')=[0.000000 0.280000 0.670000];
color_database('cocoa brown')=[0.820000 0.410000 0.120000];
color_database('coffee')=[0.440000 0.310000 0.220000];
color_database('columbia blue')=[0.610000 0.870000 1.000000];
color_database('cool black')=[0.000000 0.180000 0.390000];
color_database('cool grey')=[0.550000 0.570000 0.670000];
color_database('copper')=[0.720000 0.450000 0.200000];
color_database('copper rose')=[0.600000 0.400000 0.400000];
color_database('coquelicot')=[1.000000 0.220000 0.000000];
color_database('coral')=[1.000000 0.500000 0.310000];
color_database('coral pink')=[0.970000 0.510000 0.470000];
color_database('coral red')=[1.000000 0.250000 0.250000];
color_database('cordovan')=[0.540000 0.250000 0.270000];
color_database('corn')=[0.980000 0.930000 0.360000];
color_database('cornell red')=[0.700000 0.110000 0.110000];
color_database('cornflower blue')=[0.390000 0.580000 0.930000];
color_database('cornsilk')=[1.000000 0.970000 0.860000];
color_database('cosmic latte')=[1.000000 0.970000 0.910000];
color_database('cotton candy')=[1.000000 0.740000 0.850000];
color_database('cream')=[1.000000 0.990000 0.820000];
color_database('crimson')=[0.860000 0.080000 0.240000];
color_database('crimson glory')=[0.750000 0.000000 0.200000];
color_database('cyan')=[0.000000 1.000000 1.000000];
color_database('cyan (process)')=[0.000000 0.720000 0.920000];
color_database('daffodil')=[1.000000 1.000000 0.190000];
color_database('dandelion')=[0.940000 0.880000 0.190000];
color_database('dark blue')=[0.000000 0.000000 0.550000];
color_database('dark brown')=[0.400000 0.260000 0.130000];
color_database('dark byzantium')=[0.360000 0.220000 0.330000];
color_database('dark candy apple red')=[0.640000 0.000000 0.000000];
color_database('dark cerulean')=[0.030000 0.270000 0.490000];
color_database('dark champagne')=[0.760000 0.700000 0.500000];
color_database('dark chestnut')=[0.600000 0.410000 0.380000];
color_database('dark coral')=[0.800000 0.360000 0.270000];
color_database('dark cyan')=[0.000000 0.550000 0.550000];
color_database('dark electric blue')=[0.330000 0.410000 0.470000];
color_database('dark goldenrod')=[0.720000 0.530000 0.040000];
color_database('dark gray')=[0.660000 0.660000 0.660000];
color_database('dark green')=[0.000000 0.200000 0.130000];
color_database('dark jungle green')=[0.100000 0.140000 0.130000];
color_database('dark khaki')=[0.740000 0.720000 0.420000];
color_database('dark lava')=[0.280000 0.240000 0.200000];
color_database('dark lavender')=[0.450000 0.310000 0.590000];
color_database('dark magenta')=[0.550000 0.000000 0.550000];
color_database('dark midnight blue')=[0.000000 0.200000 0.400000];
color_database('dark olive green')=[0.330000 0.420000 0.180000];
color_database('dark orange')=[1.000000 0.550000 0.000000];
color_database('dark orchid')=[0.600000 0.200000 0.800000];
color_database('dark pastel blue')=[0.470000 0.620000 0.800000];
color_database('dark pastel green')=[0.010000 0.750000 0.240000];
color_database('dark pastel purple')=[0.590000 0.440000 0.840000];
color_database('dark pastel red')=[0.760000 0.230000 0.130000];
color_database('dark pink')=[0.910000 0.330000 0.500000];
color_database('dark powder blue')=[0.000000 0.200000 0.600000];
color_database('dark raspberry')=[0.530000 0.150000 0.340000];
color_database('dark red')=[0.550000 0.000000 0.000000];
color_database('dark salmon')=[0.910000 0.590000 0.480000];
color_database('dark scarlet')=[0.340000 0.010000 0.100000];
color_database('dark sea green')=[0.560000 0.740000 0.560000];
color_database('dark sienna')=[0.240000 0.080000 0.080000];
color_database('dark slate blue')=[0.280000 0.240000 0.550000];
color_database('dark slate gray')=[0.180000 0.310000 0.310000];
color_database('dark spring green')=[0.090000 0.450000 0.270000];
color_database('dark tan')=[0.570000 0.510000 0.320000];
color_database('dark tangerine')=[1.000000 0.660000 0.070000];
color_database('dark taupe')=[0.280000 0.240000 0.200000];
color_database('dark terra cotta')=[0.800000 0.310000 0.360000];
color_database('dark turquoise')=[0.000000 0.810000 0.820000];
color_database('dark violet')=[0.580000 0.000000 0.830000];
color_database('dartmouth green')=[0.050000 0.500000 0.060000];
color_database('davys grey')=[0.330000 0.330000 0.330000];
color_database('debian red')=[0.840000 0.040000 0.330000];
color_database('deep carmine')=[0.660000 0.130000 0.240000];
color_database('deep carmine pink')=[0.940000 0.190000 0.220000];
color_database('deep carrot orange')=[0.910000 0.410000 0.170000];
color_database('deep cerise')=[0.850000 0.200000 0.530000];
color_database('deep champagne')=[0.980000 0.840000 0.650000];
color_database('deep chestnut')=[0.730000 0.310000 0.280000];
color_database('deep coffee')=[0.440000 0.260000 0.250000];
color_database('deep fuchsia')=[0.760000 0.330000 0.760000];
color_database('deep jungle green')=[0.000000 0.290000 0.290000];
color_database('deep lilac')=[0.600000 0.330000 0.730000];
color_database('deep magenta')=[0.800000 0.000000 0.800000];
color_database('deep peach')=[1.000000 0.800000 0.640000];
color_database('deep pink')=[1.000000 0.080000 0.580000];
color_database('deep saffron')=[1.000000 0.600000 0.200000];
color_database('deep sky blue')=[0.000000 0.750000 1.000000];
color_database('denim')=[0.080000 0.380000 0.740000];
color_database('desert')=[0.760000 0.600000 0.420000];
color_database('desert sand')=[0.930000 0.790000 0.690000];
color_database('dim gray')=[0.410000 0.410000 0.410000];
color_database('dodger blue')=[0.120000 0.560000 1.000000];
color_database('dogwood rose')=[0.840000 0.090000 0.410000];
color_database('dollar bill')=[0.520000 0.730000 0.400000];
color_database('dolphin')=[0.390000 0.380000 0.470000];
color_database('drab')=[0.590000 0.440000 0.090000];
color_database('duke blue')=[0.000000 0.000000 0.610000];
color_database('earth yellow')=[0.880000 0.660000 0.370000];
color_database('ecru')=[0.760000 0.700000 0.500000];
color_database('eggplant')=[0.380000 0.250000 0.320000];
color_database('eggshell')=[0.940000 0.920000 0.840000];
color_database('egyptian blue')=[0.060000 0.200000 0.650000];
color_database('electric blue')=[0.490000 0.980000 1.000000];
color_database('electric crimson')=[1.000000 0.000000 0.250000];
color_database('electric cyan')=[0.000000 1.000000 1.000000];
color_database('electric green')=[0.000000 1.000000 0.000000];
color_database('electric indigo')=[0.440000 0.000000 1.000000];
color_database('electric lavender')=[0.960000 0.730000 1.000000];
color_database('electric lime')=[0.800000 1.000000 0.000000];
color_database('electric purple')=[0.750000 0.000000 1.000000];
color_database('electric ultramarine')=[0.250000 0.000000 1.000000];
color_database('electric violet')=[0.560000 0.000000 1.000000];
color_database('electric yellow')=[1.000000 1.000000 0.000000];
color_database('emerald')=[0.310000 0.780000 0.470000];
color_database('eton blue')=[0.590000 0.780000 0.640000];
color_database('fallow')=[0.760000 0.600000 0.420000];
color_database('falu red')=[0.500000 0.090000 0.090000];
color_database('fandango')=[0.710000 0.200000 0.540000];
color_database('fashion fuchsia')=[0.960000 0.000000 0.630000];
color_database('fawn')=[0.900000 0.670000 0.440000];
color_database('feldgrau')=[0.300000 0.360000 0.330000];
color_database('fern green')=[0.310000 0.470000 0.260000];
color_database('ferrari red')=[1.000000 0.110000 0.000000];
color_database('field drab')=[0.420000 0.330000 0.120000];
color_database('firebrick')=[0.700000 0.130000 0.130000];
color_database('fire engine red')=[0.810000 0.090000 0.130000];
color_database('flame')=[0.890000 0.350000 0.130000];
color_database('flamingo pink')=[0.990000 0.560000 0.670000];
color_database('flavescent')=[0.970000 0.910000 0.560000];
color_database('flax')=[0.930000 0.860000 0.510000];
color_database('floral white')=[1.000000 0.980000 0.940000];
color_database('fluorescent orange')=[1.000000 0.750000 0.000000];
color_database('fluorescent pink')=[1.000000 0.080000 0.580000];
color_database('fluorescent yellow')=[0.800000 1.000000 0.000000];
color_database('folly')=[1.000000 0.000000 0.310000];
color_database('forest green (traditional)')=[0.000000 0.270000 0.130000];
color_database('forest green (web)')=[0.130000 0.550000 0.130000];
color_database('french beige')=[0.650000 0.480000 0.360000];
color_database('french blue')=[0.000000 0.450000 0.730000];
color_database('french lilac')=[0.530000 0.380000 0.560000];
color_database('french rose')=[0.960000 0.290000 0.540000];
color_database('fuchsia')=[1.000000 0.000000 1.000000];
color_database('fuchsia pink')=[1.000000 0.470000 1.000000];
color_database('fulvous')=[0.860000 0.520000 0.000000];
color_database('fuzzy wuzzy')=[0.800000 0.400000 0.400000];
color_database('gainsboro')=[0.860000 0.860000 0.860000];
color_database('gamboge')=[0.890000 0.610000 0.060000];
color_database('ghost white')=[0.970000 0.970000 1.000000];
color_database('ginger')=[0.690000 0.400000 0.000000];
color_database('glaucous')=[0.380000 0.510000 0.710000];
color_database('glitter')=[0.900000 0.910000 0.980000];
color_database('gold (metallic)')=[0.830000 0.690000 0.220000];
color_database('gold (web) (golden)')=[1.000000 0.840000 0.000000];
color_database('golden brown')=[0.600000 0.400000 0.080000];
color_database('golden poppy')=[0.990000 0.760000 0.000000];
color_database('golden yellow')=[1.000000 0.870000 0.000000];
color_database('goldenrod')=[0.850000 0.650000 0.130000];
color_database('granny smith apple')=[0.660000 0.890000 0.630000];
color_database('gray')=[0.500000 0.500000 0.500000];
color_database('gray (html/css gray)')=[0.500000 0.500000 0.500000];
color_database('gray (x11 gray)')=[0.750000 0.750000 0.750000];
color_database('gray-asparagus')=[0.270000 0.350000 0.270000];
color_database('green (color wheel) (x11 green)')=[0.000000 1.000000 0.000000];
color_database('green (html/css green)')=[0.000000 0.500000 0.000000];
color_database('green (munsell)')=[0.000000 0.660000 0.470000];
color_database('green (ncs)')=[0.000000 0.620000 0.420000];
color_database('green (pigment)')=[0.000000 0.650000 0.310000];
color_database('green (ryb)')=[0.400000 0.690000 0.200000];
color_database('green-yellow')=[0.680000 1.000000 0.180000];
color_database('grullo')=[0.660000 0.600000 0.530000];
color_database('guppie green')=[0.000000 1.000000 0.500000];
color_database('halaya ube')=[0.400000 0.220000 0.330000];
color_database('han blue')=[0.270000 0.420000 0.810000];
color_database('han purple')=[0.320000 0.090000 0.980000];
color_database('hansa yellow')=[0.910000 0.840000 0.420000];
color_database('harlequin')=[0.250000 1.000000 0.000000];
color_database('harvard crimson')=[0.790000 0.000000 0.090000];
color_database('harvest gold')=[0.850000 0.570000 0.000000];
color_database('heart gold')=[0.500000 0.500000 0.000000];
color_database('heliotrope')=[0.870000 0.450000 1.000000];
color_database('hollywood cerise')=[0.960000 0.000000 0.630000];
color_database('honeydew')=[0.940000 1.000000 0.940000];
color_database('hookers green')=[0.000000 0.440000 0.000000];
color_database('hot magenta')=[1.000000 0.110000 0.810000];
color_database('hot pink')=[1.000000 0.410000 0.710000];
color_database('hunter green')=[0.210000 0.370000 0.230000];
color_database('iceberg')=[0.440000 0.650000 0.820000];
color_database('icterine')=[0.990000 0.970000 0.370000];
color_database('inchworm')=[0.700000 0.930000 0.360000];
color_database('india green')=[0.070000 0.530000 0.030000];
color_database('indian red')=[0.800000 0.360000 0.360000];
color_database('indian yellow')=[0.890000 0.660000 0.340000];
color_database('indigo (dye)')=[0.000000 0.250000 0.420000];
color_database('indigo (web)')=[0.290000 0.000000 0.510000];
color_database('international klein blue')=[0.000000 0.180000 0.650000];
color_database('international orange')=[1.000000 0.310000 0.000000];
color_database('iris')=[0.350000 0.310000 0.810000];
color_database('isabelline')=[0.960000 0.940000 0.930000];
color_database('islamic green')=[0.000000 0.560000 0.000000];
color_database('ivory')=[1.000000 1.000000 0.940000];
color_database('jade')=[0.000000 0.660000 0.420000];
color_database('jasmine')=[0.970000 0.870000 0.490000];
color_database('jasper')=[0.840000 0.230000 0.240000];
color_database('jazzberry jam')=[0.650000 0.040000 0.370000];
color_database('jonquil')=[0.980000 0.850000 0.370000];
color_database('june bud')=[0.740000 0.850000 0.340000];
color_database('jungle green')=[0.160000 0.670000 0.530000];
color_database('kelly green')=[0.300000 0.730000 0.090000];
color_database('khaki (html/css) (khaki)')=[0.760000 0.690000 0.570000];
color_database('khaki (x11) (light khaki)')=[0.940000 0.900000 0.550000];
color_database('ku crimson')=[0.910000 0.000000 0.050000];
color_database('la salle green')=[0.030000 0.470000 0.190000];
color_database('languid lavender')=[0.840000 0.790000 0.870000];
color_database('lapis lazuli')=[0.150000 0.380000 0.610000];
color_database('laser lemon')=[1.000000 1.000000 0.130000];
color_database('laurel green')=[0.660000 0.730000 0.620000];
color_database('lava')=[0.810000 0.060000 0.130000];
color_database('lavender (floral)')=[0.710000 0.490000 0.860000];
color_database('lavender (web)')=[0.900000 0.900000 0.980000];
color_database('lavender blue')=[0.800000 0.800000 1.000000];
color_database('lavender blush')=[1.000000 0.940000 0.960000];
color_database('lavender gray')=[0.770000 0.760000 0.820000];
color_database('lavender indigo')=[0.580000 0.340000 0.920000];
color_database('lavender magenta')=[0.930000 0.510000 0.930000];
color_database('lavender mist')=[0.900000 0.900000 0.980000];
color_database('lavender pink')=[0.980000 0.680000 0.820000];
color_database('lavender purple')=[0.590000 0.480000 0.710000];
color_database('lavender rose')=[0.980000 0.630000 0.890000];
color_database('lawn green')=[0.490000 0.990000 0.000000];
color_database('lemon')=[1.000000 0.970000 0.000000];
color_database('lemon chiffon')=[1.000000 0.980000 0.800000];
color_database('light apricot')=[0.990000 0.840000 0.690000];
color_database('light blue')=[0.680000 0.850000 0.900000];
color_database('light brown')=[0.710000 0.400000 0.110000];
color_database('light carmine pink')=[0.900000 0.400000 0.380000];
color_database('light coral')=[0.940000 0.500000 0.500000];
color_database('light cornflower blue')=[0.600000 0.810000 0.930000];
color_database('light crimson')=[0.960000 0.410000 0.570000];
color_database('light cyan')=[0.880000 1.000000 1.000000];
color_database('light fuchsia pink')=[0.980000 0.520000 0.940000];
color_database('light goldenrod yellow')=[0.980000 0.980000 0.820000];
color_database('light gray')=[0.830000 0.830000 0.830000];
color_database('light green')=[0.560000 0.930000 0.560000];
color_database('light khaki')=[0.940000 0.900000 0.550000];
color_database('light mauve')=[0.860000 0.820000 1.000000];
color_database('light pastel purple')=[0.690000 0.610000 0.850000];
color_database('light pink')=[1.000000 0.710000 0.760000];
color_database('light salmon')=[1.000000 0.630000 0.480000];
color_database('light salmon pink')=[1.000000 0.600000 0.600000];
color_database('light sea green')=[0.130000 0.700000 0.670000];
color_database('light sky blue')=[0.530000 0.810000 0.980000];
color_database('light slate gray')=[0.470000 0.530000 0.600000];
color_database('light taupe')=[0.700000 0.550000 0.430000];
color_database('light thulian pink')=[0.900000 0.560000 0.670000];
color_database('light timberwolf')=[0.930000 0.910000 0.890000];
color_database('light yellow')=[1.000000 1.000000 0.880000];
color_database('lilac')=[0.780000 0.640000 0.780000];
color_database('lime (color wheel)')=[0.750000 1.000000 0.000000];
color_database('lime (web) (x11 green)')=[0.000000 1.000000 0.000000];
color_database('lime green')=[0.200000 0.800000 0.200000];
color_database('lincoln green')=[0.110000 0.350000 0.020000];
color_database('linen')=[0.980000 0.940000 0.900000];
color_database('lion')=[0.760000 0.600000 0.420000];
color_database('liver')=[0.330000 0.290000 0.310000];
color_database('lust')=[0.900000 0.130000 0.130000];
color_database('magenta')=[1.000000 0.000000 1.000000];
color_database('magenta (dye)')=[0.790000 0.080000 0.480000];
color_database('magenta (process)')=[1.000000 0.000000 0.560000];
color_database('magic mint')=[0.670000 0.940000 0.820000];
color_database('magnolia')=[0.970000 0.960000 1.000000];
color_database('mahogany')=[0.750000 0.250000 0.000000];
color_database('maize')=[0.980000 0.930000 0.370000];
color_database('majorelle blue')=[0.380000 0.310000 0.860000];
color_database('malachite')=[0.040000 0.850000 0.320000];
color_database('manatee')=[0.590000 0.600000 0.670000];
color_database('mango tango')=[1.000000 0.510000 0.260000];
color_database('mantis')=[0.450000 0.760000 0.400000];
color_database('maroon (html/css)')=[0.500000 0.000000 0.000000];
color_database('maroon (x11)')=[0.690000 0.190000 0.380000];
color_database('mauve')=[0.880000 0.690000 1.000000];
color_database('mauve taupe')=[0.570000 0.370000 0.430000];
color_database('mauvelous')=[0.940000 0.600000 0.670000];
color_database('maya blue')=[0.450000 0.760000 0.980000];
color_database('meat brown')=[0.900000 0.720000 0.230000];
color_database('medium aquamarine')=[0.400000 0.800000 0.670000];
color_database('medium blue')=[0.000000 0.000000 0.800000];
color_database('medium candy apple red')=[0.890000 0.020000 0.170000];
color_database('medium carmine')=[0.690000 0.250000 0.210000];
color_database('medium champagne')=[0.950000 0.900000 0.670000];
color_database('medium electric blue')=[0.010000 0.310000 0.590000];
color_database('medium jungle green')=[0.110000 0.210000 0.180000];
color_database('medium lavender magenta')=[0.800000 0.600000 0.800000];
color_database('medium orchid')=[0.730000 0.330000 0.830000];
color_database('medium persian blue')=[0.000000 0.400000 0.650000];
color_database('medium purple')=[0.580000 0.440000 0.860000];
color_database('medium red-violet')=[0.730000 0.200000 0.520000];
color_database('medium sea green')=[0.240000 0.700000 0.440000];
color_database('medium slate blue')=[0.480000 0.410000 0.930000];
color_database('medium spring bud')=[0.790000 0.860000 0.540000];
color_database('medium spring green')=[0.000000 0.980000 0.600000];
color_database('medium taupe')=[0.400000 0.300000 0.280000];
color_database('medium teal blue')=[0.000000 0.330000 0.710000];
color_database('medium turquoise')=[0.280000 0.820000 0.800000];
color_database('medium violet-red')=[0.780000 0.080000 0.520000];
color_database('melon')=[0.990000 0.740000 0.710000];
color_database('midnight blue')=[0.100000 0.100000 0.440000];
color_database('midnight green (eagle green)')=[0.000000 0.290000 0.330000];
color_database('mikado yellow')=[1.000000 0.770000 0.050000];
color_database('mint')=[0.240000 0.710000 0.540000];
color_database('mint cream')=[0.960000 1.000000 0.980000];
color_database('mint green')=[0.600000 1.000000 0.600000];
color_database('misty rose')=[1.000000 0.890000 0.880000];
color_database('moccasin')=[0.980000 0.920000 0.840000];
color_database('mode beige')=[0.590000 0.440000 0.090000];
color_database('moonstone blue')=[0.450000 0.660000 0.760000];
color_database('mordant red 19')=[0.680000 0.050000 0.000000];
color_database('moss green')=[0.680000 0.870000 0.680000];
color_database('mountain meadow')=[0.190000 0.730000 0.560000];
color_database('mountbatten pink')=[0.600000 0.480000 0.550000];
color_database('mulberry')=[0.770000 0.290000 0.550000];
color_database('munsell')=[0.950000 0.950000 0.960000];
color_database('mustard')=[1.000000 0.860000 0.350000];
color_database('myrtle')=[0.130000 0.260000 0.120000];
color_database('msu green')=[0.090000 0.270000 0.230000];
color_database('nadeshiko pink')=[0.960000 0.680000 0.780000];
color_database('napier green')=[0.160000 0.500000 0.000000];
color_database('naples yellow')=[0.980000 0.850000 0.370000];
color_database('navajo white')=[1.000000 0.870000 0.680000];
color_database('navy blue')=[0.000000 0.000000 0.500000];
color_database('neon carrot')=[1.000000 0.640000 0.260000];
color_database('neon fuchsia')=[1.000000 0.250000 0.390000];
color_database('neon green')=[0.220000 0.880000 0.080000];
color_database('non-photo blue')=[0.640000 0.870000 0.930000];
color_database('north texas green')=[0.020000 0.560000 0.200000];
color_database('ocean boat blue')=[0.000000 0.470000 0.750000];
color_database('ochre')=[0.800000 0.470000 0.130000];
color_database('office green')=[0.000000 0.500000 0.000000];
color_database('old gold')=[0.810000 0.710000 0.230000];
color_database('old lace')=[0.990000 0.960000 0.900000];
color_database('old lavender')=[0.470000 0.410000 0.470000];
color_database('old mauve')=[0.400000 0.190000 0.280000];
color_database('old rose')=[0.750000 0.500000 0.510000];
color_database('olive')=[0.500000 0.500000 0.000000];
color_database('olive drab (web) (olive drab #3)')=[0.420000 0.560000 0.140000];
color_database('olive drab #7')=[0.240000 0.200000 0.120000];
color_database('olivine')=[0.600000 0.730000 0.450000];
color_database('onyx')=[0.060000 0.060000 0.060000];
color_database('opera mauve')=[0.720000 0.520000 0.650000];
color_database('orange (color wheel)')=[1.000000 0.500000 0.000000];
color_database('orange (ryb)')=[0.980000 0.600000 0.010000];
color_database('orange (web color)')=[1.000000 0.650000 0.000000];
color_database('orange peel')=[1.000000 0.620000 0.000000];
color_database('orange-red')=[1.000000 0.270000 0.000000];
color_database('orchid')=[0.850000 0.440000 0.840000];
color_database('otter brown')=[0.400000 0.260000 0.130000];
color_database('outer space')=[0.250000 0.290000 0.300000];
color_database('outrageous orange')=[1.000000 0.430000 0.290000];
color_database('oxford blue')=[0.000000 0.130000 0.280000];
color_database('ou crimson red')=[0.600000 0.000000 0.000000];
color_database('pakistan green')=[0.000000 0.400000 0.000000];
color_database('palatinate blue')=[0.150000 0.230000 0.890000];
color_database('palatinate purple')=[0.410000 0.160000 0.380000];
color_database('pale aqua')=[0.740000 0.830000 0.900000];
color_database('pale blue')=[0.690000 0.930000 0.930000];
color_database('pale brown')=[0.600000 0.460000 0.330000];
color_database('pale carmine')=[0.690000 0.250000 0.210000];
color_database('pale cerulean')=[0.610000 0.770000 0.890000];
color_database('pale chestnut')=[0.870000 0.680000 0.690000];
color_database('pale copper')=[0.850000 0.540000 0.400000];
color_database('pale cornflower blue')=[0.670000 0.800000 0.940000];
color_database('pale gold')=[0.900000 0.750000 0.540000];
color_database('pale goldenrod')=[0.930000 0.910000 0.670000];
color_database('pale green')=[0.600000 0.980000 0.600000];
color_database('pale magenta')=[0.980000 0.520000 0.900000];
color_database('pale pink')=[0.980000 0.850000 0.870000];
color_database('pale plum')=[0.800000 0.600000 0.800000];
color_database('pale red-violet')=[0.860000 0.440000 0.580000];
color_database('pale robin egg blue')=[0.590000 0.870000 0.820000];
color_database('pale silver')=[0.790000 0.750000 0.730000];
color_database('pale spring bud')=[0.930000 0.920000 0.740000];
color_database('pale taupe')=[0.740000 0.600000 0.490000];
color_database('pale violet-red')=[0.860000 0.440000 0.580000];
color_database('pansy purple')=[0.470000 0.090000 0.290000];
color_database('papaya whip')=[1.000000 0.940000 0.840000];
color_database('paris green')=[0.310000 0.780000 0.470000];
color_database('pastel blue')=[0.680000 0.780000 0.810000];
color_database('pastel brown')=[0.510000 0.410000 0.330000];
color_database('pastel gray')=[0.810000 0.810000 0.770000];
color_database('pastel green')=[0.470000 0.870000 0.470000];
color_database('pastel magenta')=[0.960000 0.600000 0.760000];
color_database('pastel orange')=[1.000000 0.700000 0.280000];
color_database('pastel pink')=[1.000000 0.820000 0.860000];
color_database('pastel purple')=[0.700000 0.620000 0.710000];
color_database('pastel red')=[1.000000 0.410000 0.380000];
color_database('pastel violet')=[0.800000 0.600000 0.790000];
color_database('pastel yellow')=[0.990000 0.990000 0.590000];
color_database('patriarch')=[0.500000 0.000000 0.500000];
color_database('paynes grey')=[0.250000 0.250000 0.280000];
color_database('peach')=[1.000000 0.900000 0.710000];
color_database('peach-orange')=[1.000000 0.800000 0.600000];
color_database('peach puff')=[1.000000 0.850000 0.730000];
color_database('peach-yellow')=[0.980000 0.870000 0.680000];
color_database('pear')=[0.820000 0.890000 0.190000];
color_database('pearl')=[0.920000 0.880000 0.780000];
color_database('pearl aqua')=[0.530000 0.850000 0.750000];
color_database('peridot')=[0.900000 0.890000 0.000000];
color_database('periwinkle')=[0.800000 0.800000 1.000000];
color_database('persian blue')=[0.110000 0.220000 0.730000];
color_database('persian green')=[0.000000 0.650000 0.580000];
color_database('persian indigo')=[0.200000 0.070000 0.480000];
color_database('persian orange')=[0.850000 0.560000 0.350000];
color_database('persian pink')=[0.970000 0.500000 0.750000];
color_database('persian plum')=[0.440000 0.110000 0.110000];
color_database('persian red')=[0.800000 0.200000 0.200000];
color_database('persian rose')=[1.000000 0.160000 0.640000];
color_database('persimmon')=[0.930000 0.350000 0.000000];
color_database('phlox')=[0.870000 0.000000 1.000000];
color_database('phthalo blue')=[0.000000 0.060000 0.540000];
color_database('phthalo green')=[0.070000 0.210000 0.140000];
color_database('piggy pink')=[0.990000 0.870000 0.900000];
color_database('pine green')=[0.000000 0.470000 0.440000];
color_database('pink')=[1.000000 0.750000 0.800000];
color_database('pink-orange')=[1.000000 0.600000 0.400000];
color_database('pink pearl')=[0.910000 0.670000 0.810000];
color_database('pink sherbet')=[0.970000 0.560000 0.650000];
color_database('pistachio')=[0.580000 0.770000 0.450000];
color_database('platinum')=[0.900000 0.890000 0.890000];
color_database('plum (traditional)')=[0.560000 0.270000 0.520000];
color_database('plum (web)')=[0.800000 0.600000 0.800000];
color_database('polar bear')=[0.980000 0.950000 0.840000];
color_database('portland orange')=[1.000000 0.350000 0.210000];
color_database('powder blue (web)')=[0.690000 0.880000 0.900000];
color_database('princeton orange')=[1.000000 0.560000 0.000000];
color_database('prune')=[0.440000 0.110000 0.110000];
color_database('prussian blue')=[0.000000 0.190000 0.330000];
color_database('psychedelic purple')=[0.870000 0.000000 1.000000];
color_database('puce')=[0.800000 0.530000 0.600000];
color_database('pumpkin')=[1.000000 0.460000 0.090000];
color_database('purple (html/css)')=[0.500000 0.000000 0.500000];
color_database('purple (munsell)')=[0.620000 0.000000 0.770000];
color_database('purple (x11)')=[0.630000 0.360000 0.940000];
color_database('purple heart')=[0.410000 0.210000 0.610000];
color_database('purple mountain majesty')=[0.590000 0.470000 0.710000];
color_database('purple pizzazz')=[1.000000 0.310000 0.850000];
color_database('purple taupe')=[0.310000 0.250000 0.300000];
color_database('quartz')=[0.320000 0.280000 0.310000];
color_database('radical red')=[1.000000 0.210000 0.370000];
color_database('raspberry')=[0.890000 0.040000 0.360000];
color_database('raspberry glace')=[0.570000 0.370000 0.430000];
color_database('raspberry pink')=[0.890000 0.310000 0.610000];
color_database('raspberry rose')=[0.700000 0.270000 0.420000];
color_database('raw umber')=[0.510000 0.400000 0.270000];
color_database('razzle dazzle rose')=[1.000000 0.200000 0.800000];
color_database('razzmatazz')=[0.890000 0.150000 0.420000];
color_database('red')=[1.000000 0.000000 0.000000];
color_database('red (munsell)')=[0.950000 0.000000 0.240000];
color_database('red (ncs)')=[0.770000 0.010000 0.200000];
color_database('red (pigment)')=[0.930000 0.110000 0.140000];
color_database('red (ryb)')=[1.000000 0.150000 0.070000];
color_database('red-brown')=[0.650000 0.160000 0.160000];
color_database('red-violet')=[0.780000 0.080000 0.520000];
color_database('redwood')=[0.670000 0.310000 0.320000];
color_database('regalia')=[0.320000 0.180000 0.500000];
color_database('rich black')=[0.000000 0.250000 0.250000];
color_database('rich brilliant lavender')=[0.950000 0.650000 1.000000];
color_database('rich carmine')=[0.840000 0.000000 0.250000];
color_database('rich electric blue')=[0.030000 0.570000 0.820000];
color_database('rich lavender')=[0.670000 0.380000 0.800000];
color_database('rich lilac')=[0.710000 0.400000 0.820000];
color_database('rich maroon')=[0.690000 0.190000 0.380000];
color_database('rifle green')=[0.250000 0.280000 0.200000];
color_database('robin egg blue')=[0.000000 0.800000 0.800000];
color_database('rose')=[1.000000 0.000000 0.500000];
color_database('rose bonbon')=[0.980000 0.260000 0.620000];
color_database('rose ebony')=[0.400000 0.300000 0.280000];
color_database('rose gold')=[0.720000 0.430000 0.470000];
color_database('rose madder')=[0.890000 0.150000 0.210000];
color_database('rose pink')=[1.000000 0.400000 0.800000];
color_database('rose quartz')=[0.670000 0.600000 0.660000];
color_database('rose taupe')=[0.560000 0.360000 0.360000];
color_database('rose vale')=[0.670000 0.310000 0.320000];
color_database('rosewood')=[0.400000 0.000000 0.040000];
color_database('rosso corsa')=[0.830000 0.000000 0.000000];
color_database('rosy brown')=[0.740000 0.560000 0.560000];
color_database('royal azure')=[0.000000 0.220000 0.660000];
color_database('royal blue (traditional)')=[0.000000 0.140000 0.400000];
color_database('royal blue (web)')=[0.250000 0.410000 0.880000];
color_database('royal fuchsia')=[0.790000 0.170000 0.570000];
color_database('royal purple')=[0.470000 0.320000 0.660000];
color_database('ruby')=[0.880000 0.070000 0.370000];
color_database('ruddy')=[1.000000 0.000000 0.160000];
color_database('ruddy brown')=[0.730000 0.400000 0.160000];
color_database('ruddy pink')=[0.880000 0.560000 0.590000];
color_database('rufous')=[0.660000 0.110000 0.030000];
color_database('russet')=[0.500000 0.270000 0.110000];
color_database('rust')=[0.720000 0.250000 0.050000];
color_database('sacramento state green')=[0.000000 0.340000 0.250000];
color_database('saddle brown')=[0.550000 0.270000 0.070000];
color_database('safety orange (blaze orange)')=[1.000000 0.400000 0.000000];
color_database('saffron')=[0.960000 0.770000 0.190000];
color_database('st. patricks blue')=[0.140000 0.160000 0.480000];
color_database('salmon')=[1.000000 0.550000 0.410000];
color_database('salmon pink')=[1.000000 0.570000 0.640000];
color_database('sand')=[0.760000 0.700000 0.500000];
color_database('sand dune')=[0.590000 0.440000 0.090000];
color_database('sandstorm')=[0.930000 0.840000 0.250000];
color_database('sandy brown')=[0.960000 0.640000 0.380000];
color_database('sandy taupe')=[0.590000 0.440000 0.090000];
color_database('sangria')=[0.570000 0.000000 0.040000];
color_database('sap green')=[0.310000 0.490000 0.160000];
color_database('sapphire')=[0.060000 0.320000 0.730000];
color_database('satin sheen gold')=[0.800000 0.630000 0.210000];
color_database('scarlet')=[1.000000 0.140000 0.000000];
color_database('school bus yellow')=[1.000000 0.850000 0.000000];
color_database('screamin green')=[0.460000 1.000000 0.440000];
color_database('sea green')=[0.180000 0.550000 0.340000];
color_database('seal brown')=[0.200000 0.080000 0.080000];
color_database('seashell')=[1.000000 0.960000 0.930000];
color_database('selective yellow')=[1.000000 0.730000 0.000000];
color_database('sepia')=[0.440000 0.260000 0.080000];
color_database('shadow')=[0.540000 0.470000 0.360000];
color_database('shamrock green')=[0.000000 0.620000 0.380000];
color_database('shocking pink')=[0.990000 0.060000 0.750000];
color_database('sienna')=[0.530000 0.180000 0.090000];
color_database('silver')=[0.750000 0.750000 0.750000];
color_database('sinopia')=[0.800000 0.250000 0.040000];
color_database('skobeloff')=[0.000000 0.480000 0.450000];
color_database('sky blue')=[0.530000 0.810000 0.920000];
color_database('sky magenta')=[0.810000 0.440000 0.690000];
color_database('slate blue')=[0.420000 0.350000 0.800000];
color_database('slate gray')=[0.440000 0.500000 0.560000];
color_database('smalt (dark powder blue)')=[0.000000 0.200000 0.600000];
color_database('smokey topaz')=[0.580000 0.250000 0.030000];
color_database('smoky black')=[0.060000 0.050000 0.030000];
color_database('snow')=[1.000000 0.980000 0.980000];
color_database('spiro disco ball')=[0.060000 0.750000 0.990000];
color_database('splashed white')=[1.000000 0.990000 1.000000];
color_database('spring bud')=[0.650000 0.990000 0.000000];
color_database('spring green')=[0.000000 1.000000 0.500000];
color_database('steel blue')=[0.270000 0.510000 0.710000];
color_database('stil de grain yellow')=[0.980000 0.850000 0.370000];
color_database('stizza')=[0.600000 0.000000 0.000000];
color_database('straw')=[0.890000 0.850000 0.440000];
color_database('sunglow')=[1.000000 0.800000 0.200000];
color_database('sunset')=[0.980000 0.840000 0.650000];
color_database('tan')=[0.820000 0.710000 0.550000];
color_database('tangelo')=[0.980000 0.300000 0.000000];
color_database('tangerine')=[0.950000 0.520000 0.000000];
color_database('tangerine yellow')=[1.000000 0.800000 0.000000];
color_database('taupe')=[0.280000 0.240000 0.200000];
color_database('taupe gray')=[0.550000 0.520000 0.540000];
color_database('tea green')=[0.820000 0.940000 0.750000];
color_database('tea rose (orange)')=[0.970000 0.510000 0.470000];
color_database('tea rose (rose)')=[0.960000 0.760000 0.760000];
color_database('teal')=[0.000000 0.500000 0.500000];
color_database('teal blue')=[0.210000 0.460000 0.530000];
color_database('teal green')=[0.000000 0.510000 0.500000];
color_database('tenn (tawny)')=[0.800000 0.340000 0.000000];
color_database('terra cotta')=[0.890000 0.450000 0.360000];
color_database('thistle')=[0.850000 0.750000 0.850000];
color_database('thulian pink')=[0.870000 0.440000 0.630000];
color_database('tickle me pink')=[0.990000 0.540000 0.670000];
color_database('tiffany blue')=[0.040000 0.730000 0.710000];
color_database('tigers eye')=[0.880000 0.550000 0.240000];
color_database('timberwolf')=[0.860000 0.840000 0.820000];
color_database('titanium yellow')=[0.930000 0.900000 0.000000];
color_database('tomato')=[1.000000 0.390000 0.280000];
color_database('toolbox')=[0.450000 0.420000 0.750000];
color_database('topaz')=[1.000000 0.780000 0.490000];
color_database('tractor red')=[0.990000 0.050000 0.210000];
color_database('trolley grey')=[0.500000 0.500000 0.500000];
color_database('tropical rain forest')=[0.000000 0.460000 0.370000];
color_database('true blue')=[0.000000 0.450000 0.810000];
color_database('tufts blue')=[0.280000 0.570000 0.810000];
color_database('tumbleweed')=[0.870000 0.670000 0.530000];
color_database('turkish rose')=[0.710000 0.450000 0.510000];
color_database('turquoise')=[0.190000 0.840000 0.780000];
color_database('turquoise blue')=[0.000000 1.000000 0.940000];
color_database('turquoise green')=[0.630000 0.840000 0.710000];
color_database('tuscan red')=[0.400000 0.260000 0.300000];
color_database('twilight lavender')=[0.540000 0.290000 0.420000];
color_database('tyrian purple')=[0.400000 0.010000 0.240000];
color_database('ua blue')=[0.000000 0.200000 0.670000];
color_database('ua red')=[0.850000 0.000000 0.300000];
color_database('ube')=[0.530000 0.470000 0.760000];
color_database('ucla blue')=[0.330000 0.410000 0.580000];
color_database('ucla gold')=[1.000000 0.700000 0.000000];
color_database('ufo green')=[0.240000 0.820000 0.440000];
color_database('ultramarine')=[0.070000 0.040000 0.560000];
color_database('ultramarine blue')=[0.250000 0.400000 0.960000];
color_database('ultra pink')=[1.000000 0.440000 1.000000];
color_database('umber')=[0.390000 0.320000 0.280000];
color_database('united nations blue')=[0.360000 0.570000 0.900000];
color_database('university of california gold')=[0.720000 0.530000 0.150000];
color_database('unmellow yellow')=[1.000000 1.000000 0.400000];
color_database('up forest green')=[0.000000 0.270000 0.130000];
color_database('up maroon')=[0.480000 0.070000 0.070000];
color_database('upsdell red')=[0.680000 0.090000 0.130000];
color_database('urobilin')=[0.880000 0.680000 0.130000];
color_database('usc cardinal')=[0.600000 0.000000 0.000000];
color_database('usc gold')=[1.000000 0.800000 0.000000];
color_database('utah crimson')=[0.830000 0.000000 0.250000];
color_database('vanilla')=[0.950000 0.900000 0.670000];
color_database('vegas gold')=[0.770000 0.700000 0.350000];
color_database('venetian red')=[0.780000 0.030000 0.080000];
color_database('verdigris')=[0.260000 0.700000 0.680000];
color_database('vermilion')=[0.890000 0.260000 0.200000];
color_database('veronica')=[0.630000 0.360000 0.940000];
color_database('violet')=[0.560000 0.000000 1.000000];
color_database('violet (color wheel)')=[0.500000 0.000000 1.000000];
color_database('violet (ryb)')=[0.530000 0.000000 0.690000];
color_database('violet (web)')=[0.930000 0.510000 0.930000];
color_database('viridian')=[0.250000 0.510000 0.430000];
color_database('vivid auburn')=[0.580000 0.150000 0.140000];
color_database('vivid burgundy')=[0.620000 0.110000 0.210000];
color_database('vivid cerise')=[0.850000 0.110000 0.510000];
color_database('vivid tangerine')=[1.000000 0.630000 0.540000];
color_database('vivid violet')=[0.620000 0.000000 1.000000];
color_database('warm black')=[0.000000 0.260000 0.260000];
color_database('wenge')=[0.390000 0.330000 0.320000];
color_database('wheat')=[0.960000 0.870000 0.700000];
color_database('white')=[1.000000 1.000000 1.000000];
color_database('white smoke')=[0.960000 0.960000 0.960000];
color_database('wild blue yonder')=[0.640000 0.680000 0.820000];
color_database('wild strawberry')=[1.000000 0.260000 0.640000];
color_database('wild watermelon')=[0.990000 0.420000 0.520000];
color_database('wine')=[0.450000 0.180000 0.220000];
color_database('wisteria')=[0.790000 0.630000 0.860000];
color_database('xanadu')=[0.450000 0.530000 0.470000];
color_database('yale blue')=[0.060000 0.300000 0.570000];
color_database('yellow')=[1.000000 1.000000 0.000000];
color_database('yellow (munsell)')=[0.940000 0.800000 0.000000];
color_database('yellow (ncs)')=[1.000000 0.830000 0.000000];
color_database('yellow (process)')=[1.000000 0.940000 0.000000];
color_database('yellow (ryb)')=[1.000000 1.000000 0.200000];
color_database('yellow-green')=[0.600000 0.800000 0.200000];
color_database('yellow orange')=[1.000000 0.680000 0.260000];
color_database('zinnwaldite brown')=[0.170000 0.090000 0.030000];
color_database('zaffre')=[0.000000 0.080000 0.660000];
if strcmp(colorname,'list')
k = color_database.keys;
k'
return; end
try
    c = color_database(lower(colorname));
catch ex
    colorname
    ex
end