#include "models/configuration.h"
#include <thread>
#include <libnick/system/environment.h>

using namespace Nickvision::App;
using namespace Nickvision::System;

namespace Nickvision::TubeConverter::Shared::Models
{
    Configuration::Configuration(const std::string& key, const std::string& appName)
        : DataFileBase{ key, appName }
    {
        
    }

    Theme Configuration::getTheme() const
    {
        return m_json["Theme"].is_int64() ? static_cast<Theme>(m_json["Theme"].as_int64()) : Theme::System;
    }

    void Configuration::setTheme(Theme theme)
    {
        m_json["Theme"] = static_cast<int>(theme);
    }

    WindowGeometry Configuration::getWindowGeometry() const
    {
        WindowGeometry geometry;
        if(!m_json["WindowGeometry"].is_object())
        {
            geometry.setWidth(800);
            geometry.setHeight(600);
            geometry.setIsMaximized(false);
            return geometry;
        }
        boost::json::object& obj{ m_json["WindowGeometry"].as_object() };
        geometry.setWidth(obj["Width"].is_int64() ? static_cast<long>(obj["Width"].as_int64()) : 800);
        geometry.setHeight(obj["Height"].is_int64() ? static_cast<long>(obj["Height"].as_int64()) : 600);
        geometry.setIsMaximized(obj["IsMaximized"].is_bool() ? obj["IsMaximized"].as_bool() : false);
        return geometry;
    }

    void Configuration::setWindowGeometry(const WindowGeometry& geometry)
    {
        boost::json::object obj;
        obj["Width"] = geometry.getWidth();
        obj["Height"] = geometry.getHeight();
        obj["IsMaximized"] = geometry.isMaximized();
        m_json["WindowGeometry"] = obj;
    }

    bool Configuration::getAutomaticallyCheckForUpdates() const
    {
        return m_json["AutomaticallyCheckForUpdates"].is_bool() ? m_json["AutomaticallyCheckForUpdates"].as_bool() : Environment::getOperatingSystem() == OperatingSystem::Windows;
    }

    void Configuration::setAutomaticallyCheckForUpdates(bool check)
    {
        m_json["AutomaticallyCheckForUpdates"] = check;
    }

    CompletedNotificationPreference Configuration::getCompletedNotificationPreference() const
    {
        return m_json["CompletedNotificationPreference"].is_int64() ? static_cast<CompletedNotificationPreference>(m_json["CompletedNotificationPreference"].as_int64()) : CompletedNotificationPreference::ForEach;
    }

    void Configuration::setCompletedNotificationPreference(CompletedNotificationPreference preference)
    {
        m_json["CompletedNotificationPreference"] = static_cast<int>(preference);
    }

    bool Configuration::getPreventSuspend() const
    {
        return m_json["PreventSuspend"].is_bool() ? m_json["PreventSuspend"].as_bool() : false;
    }

    void Configuration::setPreventSuspend(bool prevent)
    {
        m_json["PreventSuspend"] = prevent;
    }

    bool Configuration::getRecoverCrashedDownloads() const
    {
        return m_json["RecoverCrashedDownloads"].is_bool() ? m_json["RecoverCrashedDownloads"].as_bool() : true;
    }

    void Configuration::setRecoverCrashedDownloads(bool recoverCrashedDownloads)
    {
        m_json["RecoverCrashedDownloads"] = recoverCrashedDownloads;
    }

    DownloaderOptions Configuration::getDownloaderOptions() const
    {
        DownloaderOptions options;
        options.setOverwriteExistingFiles(m_json["OverwriteExistingFiles"].is_bool() ? m_json["OverwriteExistingFiles"].as_bool() : true);
        options.setMaxNumberOfActiveDownloads(m_json["MaxNumberOfActiveDownloads"].is_int64() ? static_cast<int>(m_json["MaxNumberOfActiveDownloads"].as_int64()) : 5);
        options.setLimitCharacters(m_json["LimitCharacters"].is_bool() ? m_json["LimitCharacters"].as_bool() : Environment::getOperatingSystem() == OperatingSystem::Windows);
        options.setIncludeMediaIdInTitle(m_json["IncludeMediaIdInTitle"].is_bool() ? m_json["IncludeMediaIdInTitle"].as_bool() : true);
        options.setIncludeAutoGeneratedSubtitles(m_json["IncludeAutoGeneratedSubtitles"].is_bool() ? m_json["IncludeAutoGeneratedSubtitles"].as_bool() : true);
        options.setPreferredVideoCodec(m_json["PreferredVideoCodec"].is_int64() ? static_cast<VideoCodec>(m_json["PreferredVideoCodec"].as_int64()) : VideoCodec::Any);
        options.setPreferredSubtitleFormat(m_json["PreferredSubtitleFormat"].is_int64() ? static_cast<SubtitleFormat>(m_json["PreferredSubtitleFormat"].as_int64()) : SubtitleFormat::Any);
        options.setUseAria(m_json["UseAria"].is_bool() ? m_json["UseAria"].as_bool() : false);
        options.setAriaMaxConnectionsPerServer(m_json["AriaMaxConnectionsPerServer"].is_int64() ? static_cast<int>(m_json["AriaMaxConnectionsPerServer"].as_int64()) : 16);
        options.setAriaMinSplitSize(m_json["AriaMinSplitSize"].is_int64() ? static_cast<int>(m_json["AriaMinSplitSize"].as_int64()) : 20);
        options.setVerboseLogging(m_json["VerboseLogging"].is_bool() ? m_json["VerboseLogging"].as_bool() : true);
        options.setSpeedLimit(m_json["SpeedLimit"].is_int64() ? static_cast<int>(m_json["SpeedLimit"].as_int64()) : 1024);
        options.setProxyUrl(m_json["ProxyUrl"].is_string() ? m_json["ProxyUrl"].as_string().c_str() : "");
        options.setCookiesBrowser(m_json["CookiesBrowser"].is_int64() ? static_cast<Browser>(m_json["CookiesBrowser"].as_int64()) : Browser::None);
        options.setCookiesPath(m_json["CookiesPath"].is_string() ? m_json["CookiesPath"].as_string().c_str() : "");
        options.setYouTubeSponsorBlock(m_json["YouTubeSponsorBlock"].is_bool() ? m_json["YouTubeSponsorBlock"].as_bool() : false);
        options.setEmbedMetadata(m_json["EmbedMetadata"].is_bool() ? m_json["EmbedMetadata"].as_bool() : true);
        options.setCropAudioThumbnails(m_json["CropAudioThumbnails"].is_bool() ? m_json["CropAudioThumbnails"].as_bool() : false);
        options.setRemoveSourceData(m_json["RemoveSourceData"].is_bool() ? m_json["RemoveSourceData"].as_bool() : false);
        options.setEmbedChapters(m_json["EmbedChapters"].is_bool() ? m_json["EmbedChapters"].as_bool() : false);
        options.setEmbedSubtitles(m_json["EmbedSubtitle"].is_bool() ? m_json["EmbedSubtitle"].as_bool() : true);
        options.setPostprocessingThreads(m_json["PostprocessingThreads"].is_int64() ? static_cast<int>(m_json["PostprocessingThreads"].as_int64()) : static_cast<int>(std::thread::hardware_concurrency()));
        return options;
    }

    void Configuration::setDownloaderOptions(const DownloaderOptions& downloaderOptions)
    {
        m_json["OverwriteExistingFiles"] = downloaderOptions.getOverwriteExistingFiles();
        m_json["MaxNumberOfActiveDownloads"] = downloaderOptions.getMaxNumberOfActiveDownloads();
        m_json["LimitCharacters"] = downloaderOptions.getLimitCharacters();
        m_json["IncludeMediaIdInTitle"] = downloaderOptions.getIncludeMediaIdInTitle();
        m_json["IncludeAutoGeneratedSubtitles"] = downloaderOptions.getIncludeAutoGeneratedSubtitles();
        m_json["PreferredVideoCodec"] = static_cast<int>(downloaderOptions.getPreferredVideoCodec());
        m_json["PreferredSubtitleFormat"] = static_cast<int>(downloaderOptions.getPreferredSubtitleFormat());
        m_json["UseAria"] = downloaderOptions.getUseAria();
        m_json["AriaMaxConnectionsPerServer"] = downloaderOptions.getAriaMaxConnectionsPerServer();
        m_json["AriaMinSplitSize"] = downloaderOptions.getAriaMinSplitSize();
        m_json["VerboseLogging"] = downloaderOptions.getVerboseLogging();
        m_json["SpeedLimit"] = downloaderOptions.getSpeedLimit();
        m_json["ProxyUrl"] = downloaderOptions.getProxyUrl();
        m_json["CookiesBrowser"] = static_cast<int>(downloaderOptions.getCookiesBrowser());
        m_json["CookiesPath"] = downloaderOptions.getCookiesPath().string();
        m_json["YouTubeSponsorBlock"] = downloaderOptions.getYouTubeSponsorBlock();
        m_json["EmbedMetadata"] = downloaderOptions.getEmbedMetadata();
        m_json["CropAudioThumbnails"] = downloaderOptions.getCropAudioThumbnails();
        m_json["RemoveSourceData"] = downloaderOptions.getRemoveSourceData();
        m_json["EmbedChapters"] = downloaderOptions.getEmbedChapters();
        m_json["EmbedSubtitle"] = downloaderOptions.getEmbedSubtitles();
        m_json["PostprocessingThreads"] = downloaderOptions.getPostprocessingThreads();
    }

    bool Configuration::getShowDisclaimerOnStartup() const
    {
        return m_json["ShowDisclaimerOnStartup"].is_bool() ? m_json["ShowDisclaimerOnStartup"].as_bool() : true;
    }

    void Configuration::setShowDisclaimerOnStartup(bool showDisclaimerOnStartup)
    {
        m_json["ShowDisclaimerOnStartup"] = showDisclaimerOnStartup;
    }

    bool Configuration::getDownloadImmediatelyAfterValidation() const
    {
        return m_json["DownloadImmediatelyAfterValidation"].is_bool() ? m_json["DownloadImmediatelyAfterValidation"].as_bool() : false;
    }

    void Configuration::setDownloadImmediatelyAfterValidation(bool downloadImmediatelyAfterValidation)
    {
        m_json["DownloadImmediatelyAfterValidation"] = downloadImmediatelyAfterValidation;
    }
}