.TH "Pandoc Test Suite" "" "July 17, 2006" ""
.PP
This is a set of tests for pandoc.
Most of them are adapted from John Gruber\(cqs markdown test suite.
.PP
   *   *   *   *   *
.SH Headers
.SS Level 2 with an embedded link
.SS Level 3 with \f[I]emphasis\f[R]
.SS Level 4
.SS Level 5
.SH Level 1
.SS Level 2 with \f[I]emphasis\f[R]
.SS Level 3
with no blank line
.SS Level 2
with no blank line
.PP
   *   *   *   *   *
.SH Paragraphs
Here\(cqs a regular paragraph.
.PP
In Markdown 1.0.0 and earlier.
Version 8.
This line turns into a list item.
Because a hard\-wrapped line in the middle of a paragraph looked like a list
item.
.PP
Here\(cqs one with a bullet.
* criminey.
.PP
There should be a hard line break
.PD 0
.P
.PD
here.
.PP
   *   *   *   *   *
.SH Block Quotes
E\-mail style:
.RS
.PP
This is a block quote.
It is pretty short.
.RE
.RS
.PP
Code in a block quote:
.IP
.EX
sub status {
    print \(dqworking\(dq;
}
.EE
.PP
A list:
.IP "1." 3
item one
.IP "2." 3
item two
.PP
Nested block quotes:
.RS
.PP
nested
.RE
.RS
.PP
nested
.RE
.RE
.PP
This should not be a block quote: 2 > 1.
.PP
And a following paragraph.
.PP
   *   *   *   *   *
.SH Code Blocks
Code:
.IP
.EX
\-\-\-\- (should be four hyphens)

sub status {
    print \(dqworking\(dq;
}

this code block is indented by one tab
.EE
.PP
And:
.IP
.EX
    this code block is indented by two tabs

These should not be escaped:  \(rs$ \(rs\(rs \(rs> \(rs[ \(rs{
.EE
.PP
   *   *   *   *   *
.SH Lists
.SS Unordered
Asterisks tight:
.IP \(bu 2
asterisk 1
.IP \(bu 2
asterisk 2
.IP \(bu 2
asterisk 3
.PP
Asterisks loose:
.IP \(bu 2
asterisk 1
.IP \(bu 2
asterisk 2
.IP \(bu 2
asterisk 3
.PP
Pluses tight:
.IP \(bu 2
Plus 1
.IP \(bu 2
Plus 2
.IP \(bu 2
Plus 3
.PP
Pluses loose:
.IP \(bu 2
Plus 1
.IP \(bu 2
Plus 2
.IP \(bu 2
Plus 3
.PP
Minuses tight:
.IP \(bu 2
Minus 1
.IP \(bu 2
Minus 2
.IP \(bu 2
Minus 3
.PP
Minuses loose:
.IP \(bu 2
Minus 1
.IP \(bu 2
Minus 2
.IP \(bu 2
Minus 3
.SS Ordered
Tight:
.IP "1." 3
First
.IP "2." 3
Second
.IP "3." 3
Third
.PP
and:
.IP "1." 3
One
.IP "2." 3
Two
.IP "3." 3
Three
.PP
Loose using tabs:
.IP "1." 3
First
.IP "2." 3
Second
.IP "3." 3
Third
.PP
and using spaces:
.IP "1." 3
One
.IP "2." 3
Two
.IP "3." 3
Three
.PP
Multiple paragraphs:
.IP "1." 3
Item 1, graf one.
.RS 4
.PP
Item 1.
graf two.
The quick brown fox jumped over the lazy dog\(cqs back.
.RE
.IP "2." 3
Item 2.
.IP "3." 3
Item 3.
.SS Nested
.IP \(bu 2
Tab
.RS 2
.IP \(bu 2
Tab
.RS 2
.IP \(bu 2
Tab
.RE
.RE
.PP
Here\(cqs another:
.IP "1." 3
First
.IP "2." 3
Second:
.RS 4
.IP \(bu 2
Fee
.IP \(bu 2
Fie
.IP \(bu 2
Foe
.RE
.IP "3." 3
Third
.PP
Same thing but with paragraphs:
.IP "1." 3
First
.IP "2." 3
Second:
.RS 4
.IP \(bu 2
Fee
.IP \(bu 2
Fie
.IP \(bu 2
Foe
.RE
.IP "3." 3
Third
.SS Tabs and spaces
.IP \(bu 2
this is a list item indented with tabs
.IP \(bu 2
this is a list item indented with spaces
.RS 2
.IP \(bu 2
this is an example list item indented with tabs
.IP \(bu 2
this is an example list item indented with spaces
.RE
.SS Fancy list markers
.IP "(2)" 4
begins with 2
.IP "(3)" 4
and now 3
.RS 4
.PP
with a continuation
.IP "iv." 4
sublist with roman numerals, starting with 4
.IP " v." 4
more items
.RS 4
.IP "(A)" 4
a subsublist
.IP "(B)" 4
a subsublist
.RE
.RE
.PP
Nesting:
.IP "A." 3
Upper Alpha
.RS 4
.IP "I." 3
Upper Roman.
.RS 4
.IP "(6)" 4
Decimal start with 6
.RS 4
.IP "c)" 3
Lower alpha with paren
.RE
.RE
.RE
.PP
Autonumbering:
.IP "1." 3
Autonumber.
.IP "2." 3
More.
.RS 4
.IP "1." 3
Nested.
.RE
.PP
Should not be a list item:
.PP
M.A.\ 2007
.PP
B. Williams
.PP
   *   *   *   *   *
.SH Definition Lists
Tight using spaces:
.TP
apple
red fruit
.TP
orange
orange fruit
.TP
banana
yellow fruit
.PP
Tight using tabs:
.TP
apple
red fruit
.TP
orange
orange fruit
.TP
banana
yellow fruit
.PP
Loose:
.TP
apple
red fruit
.TP
orange
orange fruit
.TP
banana
yellow fruit
.PP
Multiple blocks with italics:
.TP
\f[I]apple\f[R]
red fruit
.RS
.PP
contains seeds, crisp, pleasant to taste
.RE
.TP
\f[I]orange\f[R]
orange fruit
.RS
.IP
.EX
{ orange code block }
.EE
.RS
.PP
orange block quote
.RE
.RE
.PP
Multiple definitions, tight:
.TP
apple
red fruit
computer
.TP
orange
orange fruit
bank
.PP
Multiple definitions, loose:
.TP
apple
red fruit
computer
.TP
orange
orange fruit
bank
.PP
Blank line after term, indented marker, alternate markers:
.TP
apple
red fruit
computer
.TP
orange
orange fruit
.RS
.IP "1." 3
sublist
.IP "2." 3
sublist
.RE
.SH HTML Blocks
Simple block on one line:
foo
.PP
And nested without indentation:
.PP
foo
bar
.PP
Interpreted markdown in a table:
This is \f[I]emphasized\f[R]
And this is \f[B]strong\f[R]
.PP
Here\(cqs a simple block:
.PP
foo
.PP
This should be a code block, though:
.IP
.EX
<div>
    foo
</div>
.EE
.PP
As should this:
.IP
.EX
<div>foo</div>
.EE
.PP
Now, nested:
foo
.PP
This should just be an HTML comment:
.PP
Multiline:
.PP
Code block:
.IP
.EX
<!\-\- Comment \-\->
.EE
.PP
Just plain comment, with trailing spaces on the line:
.PP
Code:
.IP
.EX
<hr />
.EE
.PP
Hr\(cqs:
.PP
   *   *   *   *   *
.SH Inline Markup
This is \f[I]emphasized\f[R], and so \f[I]is this\f[R].
.PP
This is \f[B]strong\f[R], and so \f[B]is this\f[R].
.PP
An \f[I]emphasized link\f[R].
.PP
\f[B]\f[BI]This is strong and em.\f[B]\f[R]
.PP
So is \f[B]\f[BI]this\f[B]\f[R] word.
.PP
\f[B]\f[BI]This is strong and em.\f[B]\f[R]
.PP
So is \f[B]\f[BI]this\f[B]\f[R] word.
.PP
This is code: \f[CR]>\f[R], \f[CR]$\f[R], \f[CR]\(rs\f[R], \f[CR]\(rs$\f[R],
\f[CR]<html>\f[R].
.PP
[STRIKEOUT:This is \f[I]strikeout\f[R].]
.PP
Superscripts: a^bc^d a^\f[I]hello\f[R]^ a^hello\ there^.
.PP
Subscripts: H~2~O, H~23~O, H~many\ of\ them~O.
.PP
These should not be superscripts or subscripts, because of the unescaped spaces:
a\(hab c\(had, a\(tib c\(tid.
.PP
   *   *   *   *   *
.SH Smart quotes, ellipses, dashes
\(lqHello,\(rq said the spider.
\(lq`Shelob' is my name.\(rq
.PP
`A', `B', and `C' are letters.
.PP
`Oak,' `elm,' and `beech' are names of trees.
So is `pine.'
.PP
`He said, \(lqI want to go.\(rq' Were you alive in the 70\(cqs?
.PP
Here is some quoted `\f[CR]code\f[R]' and a \(lq\c
.UR http://example.com/?foo=1&bar=2
quoted link
.UE \c
\(rq.
.PP
Some dashes: one\(emtwo \(em three\(emfour \(em five.
.PP
Dashes between numbers: 5\(en7, 255\(en66, 1987\(en1999.
.PP
Ellipses\&...and\&...and\&....
.PP
   *   *   *   *   *
.SH LaTeX
.IP \(bu 2
.IP \(bu 2
2 + 2 = 4
.IP \(bu 2
\f[I]x\f[R] ∈ \f[I]y\f[R]
.IP \(bu 2
\f[I]α\f[R] ∧ \f[I]ω\f[R]
.IP \(bu 2
223
.IP \(bu 2
\f[I]p\f[R]\-Tree
.IP \(bu 2
Here\(cqs some display math:
.RS
$$\(rsfrac{d}{dx}f(x)=\(rslim_{h\(rsto 0}\(rsfrac{f(x+h)\-f(x)}{h}$$
.RE
.IP \(bu 2
Here\(cqs one that has a line break in it:
\f[I]α\f[R] + \f[I]ω\f[R] × \f[I]x\f[R]^2^.
.PP
These shouldn\(cqt be math:
.IP \(bu 2
To get the famous equation, write \f[CR]$e = mc\(ha2$\f[R].
.IP \(bu 2
$22,000 is a \f[I]lot\f[R] of money.
So is $34,000.
(It worked if \(lqlot\(rq is emphasized.)
.IP \(bu 2
Shoes ($20) and socks ($5).
.IP \(bu 2
Escaped \f[CR]$\f[R]: $73 \f[I]this should be emphasized\f[R] 23$.
.PP
Here\(cqs a LaTeX table:
.PP
   *   *   *   *   *
.SH Special Characters
Here is some unicode:
.IP \(bu 2
I hat: Î
.IP \(bu 2
o umlaut: ö
.IP \(bu 2
section: §
.IP \(bu 2
set membership: ∈
.IP \(bu 2
copyright: ©
.PP
AT&T has an ampersand in their name.
.PP
AT&T is another way to write it.
.PP
This & that.
.PP
4 < 5.
.PP
6 > 5.
.PP
Backslash: \(rs
.PP
Backtick: \(ga
.PP
Asterisk: *
.PP
Underscore: _
.PP
Left brace: {
.PP
Right brace: }
.PP
Left bracket: [
.PP
Right bracket: ]
.PP
Left paren: (
.PP
Right paren: )
.PP
Greater\-than: >
.PP
Hash: #
.PP
Period: .
.PP
Bang: !
.PP
Plus: +
.PP
Minus: \-
.PP
   *   *   *   *   *
.SH Links
.SS Explicit
Just a URL.
.PP
URL and title.
.PP
URL and title.
.PP
URL and title.
.PP
URL and title
.PP
URL and title
.PP
with_underscore
.PP
\c
.MT nobody@nowhere.net
Email link
.ME \c
.PP
Empty.
.SS Reference
Foo bar.
.PP
With embedded [brackets].
.PP
b by itself should be a link.
.PP
Indented once.
.PP
Indented twice.
.PP
Indented thrice.
.PP
This should [not][] be a link.
.IP
.EX
[not]: /url
.EE
.PP
Foo bar.
.PP
Foo biz.
.SS With ampersands
Here\(cqs a \c
.UR http://example.com/?foo=1&bar=2
link with an ampersand in the URL
.UE \c
\&.
.PP
Here\(cqs a link with an amersand in the link text: \c
.UR http://att.com/
AT&T
.UE \c
\&.
.PP
Here\(cqs an inline link.
.PP
Here\(cqs an inline link in pointy braces.
.SS Autolinks
With an ampersand: \c
.UR http://example.com/?foo=1&bar=2
.UE \c
.IP \(bu 2
In a list?
.IP \(bu 2
\c
.UR http://example.com/
.UE \c
.IP \(bu 2
It should.
.PP
An e\-mail address: \c
.MT nobody@nowhere.net
.ME \c
.RS
.PP
Blockquoted: \c
.UR http://example.com/
.UE \c
.RE
.PP
Auto\-links should not occur here: \f[CR]<http://example.com/>\f[R]
.IP
.EX
or here: <http://example.com/>
.EE
.PP
   *   *   *   *   *
.SH Images
From \(lqVoyage dans la Lune\(rq by Georges Melies (1902):
[IMAGE: lalune]
lalune
.PP
Here is a movie [IMAGE: movie] icon.
.PP
   *   *   *   *   *
.SH Footnotes
Here is a footnote reference,[1] and another.[2] This should \f[I]not\f[R] be a
footnote reference, because it contains a space.[\(hamy note] Here is an inline
note.[3]
.RS
.PP
Notes can go in quotes.[4]
.RE
.IP "1." 3
And in list items.[5]
.PP
This paragraph should not be part of the note, as it is not indented.
.SH NOTES
.SS [1]
.PP
Here is the footnote.
It can go anywhere after the footnote reference.
It need not be placed at the end of the document.
.SS [2]
.PP
Here\(cqs the long note.
This one contains multiple blocks.
.PP
Subsequent blocks are indented to show that they belong to the footnote (as with
list items).
.IP
.EX
  { <code> }
.EE
.PP
If you want, you can indent every line, but you can also be lazy and just indent
the first line of each block.
.SS [3]
.PP
This is \f[I]easier\f[R] to type.
Inline notes may contain \c
.UR http://google.com
links
.UE \c
\ and \f[CR]]\f[R] verbatim characters, as well as [bracketed text].
.SS [4]
.PP
In quote.
.SS [5]
.PP
In list.
.SH AUTHORS
John MacFarlane; Anonymous.
