/*
 * Sample program which just displays a few simple items from a PDB or
 * PRC file.
 */

#include <iostream>
#include <string>

#include "File.h"

using namespace std;
using namespace PalmLib;

static string id2str(pi_int32_t v)
{
    string r;

    r += static_cast<char> ((v >> 24) & 0xFF);
    r += static_cast<char> ((v >> 16) & 0xFF);
    r += static_cast<char> ((v >> 8) & 0xFF);
    r += static_cast<char> (v & 0xFF);

    return r;
}

int main(int argc, char *argv[])
{
    if (argc != 2) {
        cerr << "usage: " << argv[0] << " PDB_FILE\n";
        return 1;
    }

    PalmLib::File pdb(argv[1]);

    try {
      pdb.load();
    } catch (PalmLib::error e) {
        cerr << argv[0] << ": " << argv[1] << ": " << e.what() << endl;
        return 1;
    }
  
    cout << "Name: '" << pdb.name() << "'" << endl;
    cout << "Creator: " << id2str(pdb.creator()) << endl;
    cout << "Type: " << id2str(pdb.type()) << endl;

    cout << "AppInfBlock:\n";
    unsigned int i;
    for (i = 0; i < pdb.getAppInfoBlock().size(); i++) {
        printf("0x%2X ", pdb.getAppInfoBlock()[i]);
        if (!((i + 1) % 8)) {
            printf ("  ");
            for (int j = 0; j < 8; j++) {
                if ( pdb.getAppInfoBlock()[i - 8 + j] > 0x19)
                    printf("%c", pdb.getAppInfoBlock()[i - 8 + j]);
                else
                    printf("");
            }
            printf("\n");
        }
    }
    for (unsigned int j = 0; j < (i + 1) % 8; j++) {
        if ( pdb.getAppInfoBlock()[i - ((i + 1) % 8) + j] > 0x19)
            printf("%c", pdb.getAppInfoBlock()[i - ((i + 1) % 8) + j]);
        else
            printf("");
    }
    printf("\n");
    
    return 0;
}
