#!/bin/sh
exec ruby -w -x $0 ${1+"$@"} # -*- ruby -*-
#!ruby -w

# $Id: p4deltarun.rb,v 1.2 2003/06/18 17:59:17 jeugenepace Exp $

# p4delta: summarizes Perforce changes and executes the appropriate commands

require './p4deltaopt'
require './p4delta'

$stdout.sync = true             # unbuffer
$stderr.sync = true             # unbuffer
$stdin.sync  = true             # unbuffer

$PACKAGE = "p4delta"
$VERSION = "1.3.2"

begin
  trap("INT") do
    # This bypasses the stack trace on exit.
    abort
  end

  Log.log "creating options"
  Log.log "ARGV: #{ARGV}"

  options = P4DeltaOptions.new($PACKAGE, $VERSION)
  Log.log "running options"
  options.run
  Log.log "done running options"

  Log.verbose = options.verbose
  
  # Log.output = "/tmp/p4delta.log." + Process.pid.to_s
  Log.set_widths(-12, 5, -35)

  Log.log "creating p4delta"
  Log.log "ARGV: #{ARGV}"

  delta = P4Delta.new(options, ARGV)
  Log.log "running p4delta"
  delta.run
  Log.log "printing change summary"
  delta.print_change_summary

  if options.execute
    delta.execute
  end
rescue => e
  # show only the message, not the stack trace:
  $stderr.puts "error: #{e}"
end
