function(__addIcon THEME ICON_NAME)
    set(icon "theme/${THEME}/${ICON_NAME}.svg")
    if (EXISTS ${OEM_THEME_DIR}/${icon})
        file(APPEND "${QRC}" "<file alias=\"${icon}\">${OEM_THEME_DIR}/${icon}</file>\n")
    else()
        set(icon "theme/${THEME}/${ICON_NAME}.png")
        if (EXISTS ${OEM_THEME_DIR}/${icon})
            file(APPEND "${QRC}" "<file alias=\"${icon}\">${OEM_THEME_DIR}/${icon}</file>\n")
        else()
            set(SIZES "16;22,32;48;64;128;256;512;1024")
            foreach(size ${SIZES})
                set(icon "theme/${THEME}/${ICON_NAME}-${size}.png")
                if (EXISTS ${OEM_THEME_DIR}/${icon})
                    file(APPEND "${QRC}" "<file alias=\"${icon}\">${OEM_THEME_DIR}/${icon}</file>\n")
                endif()
            endforeach()
        endif()
    endif()
endfunction()

function(generate_theme TARGET)
    if(NOT "${OEM_THEME_DIR}" STREQUAL "${PROJECT_SOURCE_DIR}")
        set(QRC ${CMAKE_BINARY_DIR}/theme.qrc)
        file(WRITE "${QRC}" "<RCC>\n<qresource prefix=\"/client/${APPLICATION_SHORTNAME}\">\n")
        __addIcon("colored" "${APPLICATION_ICON_NAME}-icon")
        __addIcon("colored" "wizard_logo")

        set(STATES "ok;error;information;offline;pause;sync")
        set(THEMES "colored;dark;black;white")
        foreach(theme ${THEMES})
            foreach(state ${STATES})
                __addIcon(${theme} "state-${state}")
            endforeach()
        endforeach()
        file(APPEND "${QRC}" "</qresource>\n</RCC>\n")
        target_sources(${TARGET} PRIVATE ${QRC})
    endif()
endfunction()


function(generate_legacy_icons theme_dir OUT)
    # allow legacy file names
    file(GLOB_RECURSE OWNCLOUD_ICONS_OLD "${theme_dir}/colored/${APPLICATION_ICON_NAME}-icon-*.png")
    foreach(icon ${OWNCLOUD_ICONS_OLD})
        get_filename_component(icon_name ${icon} NAME)
        string(REGEX MATCH "([0-9]+)" size ${icon_name})
        set(out_name "${CMAKE_BINARY_DIR}/${size}-app-icon.png")
        configure_file(${icon} ${out_name} COPYONLY)
        list(APPEND OWNCLOUD_ICONS ${out_name})
    endforeach()
    set(${OUT} ${OWNCLOUD_ICONS} PARENT_SCOPE)
endfunction()
