/* Copyright (c) 2009 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

//
//  GDataEntryContactProfile.m
//

#if !GDATA_REQUIRE_SERVICE_INCLUDES || GDATA_INCLUDE_CONTACTS_SERVICE

#import "GDataEntryContactProfile.h"
#import "GDataContactConstants.h"

@implementation GDataEntryContactProfile

+ (id)contactProfileEntry {
  GDataEntryContactProfile *obj = [[[self alloc] init] autorelease];
  [obj setNamespaces:[GDataContactConstants contactNamespaces]];
  return obj;
}

+ (NSString *)standardEntryKind {
  return kGDataCategoryContactProfile;
}

+ (void)load {
  [self registerEntryClass];
}

+ (NSString *)defaultServiceVersion {
  return kGDataContactDefaultServiceVersion;
}

@end

#endif // !GDATA_REQUIRE_SERVICE_INCLUDES || GDATA_INCLUDE_CONTACTS_SERVICE
