//
//  Signer.h
//  autoinstaller
//
//  Created by Greg Miller on 7/18/08.
//  Copyright 2008 Google Inc. All rights reserved.
//

#import <SenTestingKit/SenTestingKit.h>
#import "Signer.h"


@interface SignerTest : SenTestCase
@end

// Generated with:
//
// $ openssl genrsa 1024 > private_key.pem
// $ openssl rsa -inform PEM -outform DER < private_key.pem > private_key.der 
// $ xxd -i private_key.der
//
unsigned char private_der[] = {
  0x30, 0x82, 0x02, 0x5b, 0x02, 0x01, 0x00, 0x02, 0x81, 0x81, 0x00, 0xb5,
  0x98, 0x0f, 0xc0, 0x21, 0x6f, 0xe3, 0xcd, 0xad, 0xea, 0xae, 0xc8, 0x76,
  0xaa, 0x15, 0xfa, 0xfc, 0x4c, 0x16, 0x56, 0xf4, 0xc4, 0xe0, 0x73, 0xf2,
  0xe4, 0xb4, 0x4d, 0x90, 0x27, 0x19, 0x56, 0x81, 0x22, 0xef, 0x65, 0xac,
  0x01, 0xfb, 0xba, 0x14, 0x54, 0xaa, 0x3c, 0xfa, 0xbb, 0xf9, 0xc3, 0x1e,
  0xe5, 0x55, 0xdd, 0x1e, 0x9c, 0xa7, 0x34, 0xf9, 0xe4, 0xdb, 0xd3, 0x47,
  0x7a, 0x0e, 0x3a, 0xd8, 0xe1, 0x23, 0x82, 0xde, 0x51, 0x4e, 0xe6, 0x91,
  0x1e, 0x5a, 0xee, 0x57, 0x58, 0x56, 0x99, 0x0e, 0x91, 0xfb, 0x7f, 0xc4,
  0x98, 0xfb, 0x79, 0x22, 0x66, 0xb0, 0x59, 0x93, 0xe0, 0xc0, 0x7c, 0x8f,
  0x4e, 0x1d, 0x3d, 0xbe, 0x45, 0x59, 0x8f, 0x90, 0x0a, 0x62, 0x95, 0x3c,
  0xd3, 0x64, 0x30, 0x86, 0x43, 0xa7, 0x57, 0xb4, 0xb6, 0x03, 0x6e, 0xcc,
  0x98, 0x09, 0x35, 0x68, 0xf8, 0x38, 0xbb, 0x02, 0x03, 0x01, 0x00, 0x01,
  0x02, 0x81, 0x80, 0x43, 0x77, 0x07, 0x02, 0xfe, 0x69, 0x2f, 0x5d, 0x0e,
  0xac, 0x0d, 0xdb, 0x74, 0x1a, 0xa4, 0xa7, 0xe6, 0x6b, 0xee, 0x30, 0xc8,
  0x27, 0x0c, 0xac, 0x87, 0x24, 0xe8, 0xc7, 0x98, 0x32, 0xae, 0x7b, 0x30,
  0xe6, 0xe5, 0xc2, 0x04, 0x31, 0x88, 0x70, 0x0d, 0x75, 0x96, 0xf9, 0xa8,
  0xbd, 0x85, 0x81, 0x34, 0x4d, 0x47, 0xa5, 0x2a, 0xe6, 0x50, 0x48, 0xa2,
  0x3e, 0xa0, 0x5c, 0xd2, 0x45, 0x4a, 0x5b, 0x7a, 0x56, 0x02, 0x78, 0x59,
  0x26, 0x84, 0x34, 0x6b, 0x2c, 0x43, 0xca, 0xbe, 0x7c, 0x3d, 0xfb, 0x10,
  0x36, 0x3a, 0x13, 0xcd, 0x8a, 0x8f, 0x41, 0xfb, 0x51, 0x35, 0x60, 0xba,
  0xa6, 0x61, 0x7f, 0xbb, 0xaf, 0xe9, 0x3d, 0xa1, 0x4f, 0x4c, 0x1c, 0x27,
  0xc8, 0xac, 0x1a, 0xb7, 0xa9, 0xf5, 0x47, 0x27, 0x16, 0xe6, 0xe0, 0x5e,
  0xb3, 0xcc, 0x2e, 0x52, 0xbf, 0x54, 0x54, 0xaf, 0x12, 0x8c, 0x01, 0x02,
  0x41, 0x00, 0xda, 0xd8, 0x3d, 0xf6, 0xc4, 0x10, 0xd4, 0xbb, 0x04, 0x89,
  0x80, 0xca, 0xb9, 0xa4, 0x5c, 0x15, 0xc7, 0xc7, 0x1f, 0x1f, 0xa7, 0x53,
  0x1a, 0xc1, 0x4f, 0x92, 0xfe, 0xee, 0x0f, 0x3a, 0x16, 0x1c, 0x6a, 0x70,
  0xbe, 0xfd, 0xaf, 0x51, 0x53, 0x70, 0xe7, 0x4c, 0x08, 0xa6, 0xaa, 0x82,
  0xdd, 0x1f, 0x3c, 0x49, 0x9b, 0x31, 0xdd, 0x35, 0x97, 0x3a, 0x64, 0xaf,
  0xe7, 0x17, 0x9e, 0x65, 0xc4, 0x81, 0x02, 0x41, 0x00, 0xd4, 0x6c, 0xc5,
  0xf0, 0x13, 0x5d, 0xd1, 0x93, 0x4f, 0x56, 0xe9, 0xcb, 0x70, 0xe1, 0x90,
  0x33, 0x4d, 0xad, 0x1a, 0x43, 0x03, 0xd8, 0x85, 0x88, 0x7b, 0x86, 0x82,
  0xed, 0x43, 0x63, 0x5f, 0x7d, 0xfd, 0xec, 0x7f, 0xb6, 0x15, 0xcc, 0x79,
  0xbd, 0x61, 0xfe, 0xc8, 0x97, 0x02, 0xfa, 0x4d, 0x19, 0xfd, 0xa9, 0xfe,
  0x1b, 0xc6, 0x0b, 0xda, 0x54, 0x4b, 0xd6, 0x65, 0x1c, 0xdf, 0x50, 0x6f,
  0x3b, 0x02, 0x3f, 0x34, 0x25, 0x52, 0x9e, 0x7a, 0x19, 0x88, 0x97, 0x07,
  0x7d, 0xbc, 0x32, 0x92, 0x09, 0x97, 0xe7, 0x98, 0xb2, 0xd9, 0xb7, 0xb1,
  0x27, 0x1c, 0x38, 0xf3, 0xbd, 0x13, 0x01, 0xa6, 0x9f, 0x30, 0xa5, 0x94,
  0xb7, 0x48, 0xcb, 0x29, 0xfb, 0x36, 0xe6, 0xb0, 0x36, 0x6d, 0xd9, 0x48,
  0xc7, 0xe5, 0xe8, 0x8b, 0x74, 0xfe, 0x85, 0xe3, 0x2f, 0xe1, 0xd9, 0x08,
  0x24, 0xe1, 0xeb, 0xbe, 0xd2, 0x81, 0x02, 0x40, 0x25, 0x03, 0x2a, 0xdd,
  0xf0, 0xd1, 0xe9, 0x01, 0x4c, 0xd2, 0xac, 0xfb, 0xd8, 0x98, 0x44, 0xc2,
  0xdb, 0xa6, 0xec, 0xab, 0x7e, 0x91, 0x0c, 0x7b, 0x42, 0x62, 0xa6, 0x8f,
  0x66, 0xad, 0x7a, 0xe6, 0xfe, 0x06, 0x66, 0x1e, 0x38, 0xe0, 0x1e, 0xda,
  0x23, 0xa7, 0xfc, 0x15, 0x6b, 0xdc, 0x66, 0xf0, 0xbf, 0x65, 0x0e, 0x34,
  0x92, 0xa6, 0x60, 0x0d, 0x4e, 0x05, 0x76, 0x2a, 0xb8, 0xb2, 0x50, 0x1f,
  0x02, 0x41, 0x00, 0xc5, 0xd4, 0x7f, 0xbf, 0x58, 0x08, 0x52, 0x1a, 0x38,
  0xf9, 0x9d, 0x76, 0x8c, 0xa7, 0x06, 0x31, 0x6f, 0xdd, 0xb5, 0x2a, 0x5d,
  0x6f, 0x02, 0x39, 0x60, 0x9b, 0xa9, 0x29, 0xdb, 0xf7, 0x34, 0x71, 0x3b,
  0x0c, 0x4c, 0x1d, 0xcf, 0x20, 0x85, 0x10, 0x52, 0xfc, 0x8e, 0x38, 0x7b,
  0x96, 0x41, 0x4a, 0x4e, 0x9f, 0xc1, 0xf8, 0x71, 0x1b, 0xec, 0xab, 0xa9,
  0x85, 0x25, 0xb5, 0x0a, 0xfe, 0x7f, 0xca
};
unsigned int private_der_len = 607;

// Generated with:
//
// $ openssl rsa -pubout < private_key.pem > public_key.pem
// $ openssl rsa -inform PEM -outform DER -pubin <public_key.pem >public_key.der
// $ xxd -i public_key.der
//
unsigned char public_der[] = {
  0x30, 0x81, 0x9f, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7,
  0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x81, 0x8d, 0x00, 0x30, 0x81,
  0x89, 0x02, 0x81, 0x81, 0x00, 0xb5, 0x98, 0x0f, 0xc0, 0x21, 0x6f, 0xe3,
  0xcd, 0xad, 0xea, 0xae, 0xc8, 0x76, 0xaa, 0x15, 0xfa, 0xfc, 0x4c, 0x16,
  0x56, 0xf4, 0xc4, 0xe0, 0x73, 0xf2, 0xe4, 0xb4, 0x4d, 0x90, 0x27, 0x19,
  0x56, 0x81, 0x22, 0xef, 0x65, 0xac, 0x01, 0xfb, 0xba, 0x14, 0x54, 0xaa,
  0x3c, 0xfa, 0xbb, 0xf9, 0xc3, 0x1e, 0xe5, 0x55, 0xdd, 0x1e, 0x9c, 0xa7,
  0x34, 0xf9, 0xe4, 0xdb, 0xd3, 0x47, 0x7a, 0x0e, 0x3a, 0xd8, 0xe1, 0x23,
  0x82, 0xde, 0x51, 0x4e, 0xe6, 0x91, 0x1e, 0x5a, 0xee, 0x57, 0x58, 0x56,
  0x99, 0x0e, 0x91, 0xfb, 0x7f, 0xc4, 0x98, 0xfb, 0x79, 0x22, 0x66, 0xb0,
  0x59, 0x93, 0xe0, 0xc0, 0x7c, 0x8f, 0x4e, 0x1d, 0x3d, 0xbe, 0x45, 0x59,
  0x8f, 0x90, 0x0a, 0x62, 0x95, 0x3c, 0xd3, 0x64, 0x30, 0x86, 0x43, 0xa7,
  0x57, 0xb4, 0xb6, 0x03, 0x6e, 0xcc, 0x98, 0x09, 0x35, 0x68, 0xf8, 0x38,
  0xbb, 0x02, 0x03, 0x01, 0x00, 0x01
};
unsigned int public_der_len = 162;

@implementation SignerTest

- (void)testBasic {
  
//  NSData *publicKey = [NSData dataWithBytes:public_der length:public_der_len];
//  NSData *privateKey = [NSData dataWithBytes:private_der length:private_der_len];
//
//  Signer *signer = [[Signer alloc] initWithPublicKey:publicKey
//                                                                  privateKey:privateKey];
  
  //
  // Run some basic tests with no keys
  //
  Signer *signer = nil;
  signer = [Signer signerWithPublicKey:nil privateKey:nil];
  STAssertNotNil(signer, @"signer shouldn't be nil");
  
  STAssertNil([signer signData:nil], @"shouldn't be able to nil data");
  char bytes[] = { 1, 2, 3, 4, 5, 6, 7, 8, 9, 0 };
  NSData *someData = [NSData dataWithBytes:bytes length:sizeof(bytes)];
  STAssertNil([signer signData:someData], @"shouldn't be able to sign data");
  
  //
  // Run tests with just a private key 
  //
  NSData *privateKey = [NSData dataWithBytes:private_der
                                      length:private_der_len];
  [signer setPrivateKey:privateKey];
  NSData *signature = [signer signData:someData];
  STAssertNotNil(signature, @"should be able to sign data now");
  STAssertNil([signer signData:nil], @"still shouldn't be able to sign nil");
  STAssertFalse([signer isSignature:signature validForData:someData],
                @"shouldn't be able to verify sig w/o a public key");
  STAssertFalse([signer isSignature:signature validForData:nil],
                @"shouldn't be able to verify sig for nil data");
  STAssertFalse([signer isSignature:nil validForData:nil],
                @"shouldn't be able to verify sig with nil sig and nil data");
  STAssertFalse([signer isSignature:nil validForData:someData],
                @"shouldn't be able to verify sig with nil sig");

  //
  // Run tests with both a public and private key
  //
  NSData *publicKey = [NSData dataWithBytes:public_der length:public_der_len];
  [signer setPublicKey:publicKey];
  STAssertTrue([signer isSignature:signature validForData:someData],
                @"should be able to verify data");
  STAssertFalse([signer isSignature:signature validForData:nil],
                @"shouldn't be able to verify sig for nil data");
  STAssertFalse([signer isSignature:nil validForData:nil],
                @"shouldn't be able to verify sig with nil sig and nil data");
  STAssertFalse([signer isSignature:nil validForData:someData],
                @"shouldn't be able to verify sig with nil sig");
  
  //
  // Run tests with just a public key
  // (These should pass just like the ones above since the private key shouldn't
  // be used.)
  //
  [signer setPrivateKey:nil];
  STAssertTrue([signer isSignature:signature validForData:someData],
               @"should be able to verify sig");
  STAssertFalse([signer isSignature:signature validForData:nil],
                @"shouldn't be able to verify sig for nil data");
  STAssertFalse([signer isSignature:nil validForData:nil],
                @"shouldn't be able to verify sig with nil sig and nil data");
  STAssertFalse([signer isSignature:nil validForData:someData],
                @"shouldn't be able to verify sig with nil sig");
  
  // Set the private key again
  [signer setPrivateKey:privateKey];
  
  //
  // Misc. tests
  //
  
  STAssertFalse([signer isSignature:[NSData data] validForData:someData],
                @"shouldn't be able to verify w/ 0 byte sig");
  STAssertFalse([signer isSignature:[NSData data] validForData:[NSData data]],
                @"shouldn't be able to verify w/ 0 byte sig and data");
  STAssertFalse([signer isSignature:signature validForData:[NSData data]],
                @"shouldn't be able to verify w/ 0 byte data");
  
  char other_bytes[] = { 1, 2, 3, 4, 5, 6, 7, 8, 9, 0 };
  NSData *otherData = [NSData dataWithBytes:other_bytes
                                     length:sizeof(other_bytes)];
  STAssertTrue([signer isSignature:signature validForData:otherData],
               @"should be able to verify sig");
  
  char diff_bytes[] = { 1, 1, 1, 1, 1, 1, 1, 1, 2 };
  NSData *diffData = [NSData dataWithBytes:diff_bytes
                                    length:sizeof(diff_bytes)];
  STAssertFalse([someData isEqualTo:diffData],
                @"someData should not equal diffData");
  STAssertFalse([signer isSignature:signature validForData:diffData],
                @"shouldn't be able to verify sig against different data");
}

@end
