/**
 *  \file src/MBCSR/MatMult/3x7.c
 *  \brief MBCSR 3x7 SpMV implementation, for all transpose options.
 *  \ingroup MATTYPE_MBCSR
 *
 *  Automatically generated by ./gen_symm.sh on Wed Jun  8 15:57:47 PDT 2005.
 */

#if HAVE_CONFIG_H
#include <config/config.h> /* for 'restrict' keyword */
#endif

#include <assert.h>

#include <oski/common.h>
#include <oski/mangle.h>
#include <oski/vecview.h>
#include <oski/MBCSR/format.h>
#include <oski/MBCSR/module.h>

#if IS_VAL_COMPLEX
/** Complex-valued, so do not use explicit 'register' keyword */
#define REGISTER
#else
/** Real-valued, so use explicit 'register' keyword */
#define REGISTER register
#endif



#if defined(DO_NAME_MANGLING)
/** Mangled name for MBCSR_SymmMatMult_v1_aX_b1_xs1_ys1 */
#define MBCSR_SymmMatMult_v1_aX_b1_xs1_ys1 MANGLE_MOD_(MBCSR_SymmMatMult_v1_aX_b1_xs1_ys1_3x7)
#endif

/**
 *  \brief MBCSR implementation of
 *  \f$y \leftarrow y + \alpha\cdot A\cdot x\f$.
 */
void
MBCSR_SymmMatMult_v1_aX_b1_xs1_ys1( oski_index_t M, oski_index_t d0,
	const oski_index_t* restrict bptr, const oski_index_t* restrict bind,
	const oski_value_t* restrict bval, const oski_value_t* restrict bdiag,
	oski_value_t alpha, const oski_value_t* restrict x,
	oski_value_t* restrict y )
{
	oski_value_t* yp = y + d0;
	const oski_value_t* xp = x + d0;
	oski_index_t I;

	for( I = 0; I < M; I++, yp += 3, xp += 3 )
	{
		REGISTER oski_value_t _y0;
		REGISTER oski_value_t _y1;
		REGISTER oski_value_t _y2;
		REGISTER oski_value_t _x0;
		REGISTER oski_value_t _x1;
		REGISTER oski_value_t _x2;
		oski_index_t K;

		VAL_SET_ZERO( _y0 );
		VAL_SET_ZERO( _y1 );
		VAL_SET_ZERO( _y2 );
		VAL_MUL( _x0, alpha, xp[0] );
		VAL_MUL( _x1, alpha, xp[1] );
		VAL_MUL( _x2, alpha, xp[2] );

		for( K = bptr[I]; K < bptr[I+1]; K++, bind++, bval += 3*7 )
		{
			oski_index_t j0 = bind[0]; /* block's leftmost col index */
			const oski_value_t* xpp = x + j0;
			oski_value_t* ypp = y + j0;

			REGISTER oski_value_t _xp0;
			REGISTER oski_value_t _xp1;
			REGISTER oski_value_t _xp2;
			REGISTER oski_value_t _xp3;
			REGISTER oski_value_t _xp4;
			REGISTER oski_value_t _xp5;
			REGISTER oski_value_t _xp6;
			REGISTER oski_value_t _yp0;
			REGISTER oski_value_t _yp1;
			REGISTER oski_value_t _yp2;
			REGISTER oski_value_t _yp3;
			REGISTER oski_value_t _yp4;
			REGISTER oski_value_t _yp5;
			REGISTER oski_value_t _yp6;
			VAL_SET_ZERO( _yp0 );
			VAL_SET_ZERO( _yp1 );
			VAL_SET_ZERO( _yp2 );
			VAL_SET_ZERO( _yp3 );
			VAL_SET_ZERO( _yp4 );
			VAL_SET_ZERO( _yp5 );
			VAL_SET_ZERO( _yp6 );
			VAL_ASSIGN( _xp0, xpp[0] );
			VAL_ASSIGN( _xp1, xpp[1] );
			VAL_ASSIGN( _xp2, xpp[2] );
			VAL_ASSIGN( _xp3, xpp[3] );
			VAL_ASSIGN( _xp4, xpp[4] );
			VAL_ASSIGN( _xp5, xpp[5] );
			VAL_ASSIGN( _xp6, xpp[6] );
			VAL_MAC( _yp0, bval[0], _x0 );
			VAL_MAC( _yp1, bval[1], _x0 );
			VAL_MAC( _yp2, bval[2], _x0 );
			VAL_MAC( _yp3, bval[3], _x0 );
			VAL_MAC( _yp4, bval[4], _x0 );
			VAL_MAC( _yp5, bval[5], _x0 );
			VAL_MAC( _yp6, bval[6], _x0 );
			VAL_MAC( _yp0, bval[7], _x1 );
			VAL_MAC( _yp1, bval[8], _x1 );
			VAL_MAC( _yp2, bval[9], _x1 );
			VAL_MAC( _yp3, bval[10], _x1 );
			VAL_MAC( _yp4, bval[11], _x1 );
			VAL_MAC( _yp5, bval[12], _x1 );
			VAL_MAC( _yp6, bval[13], _x1 );
			VAL_MAC( _yp0, bval[14], _x2 );
			VAL_MAC( _yp1, bval[15], _x2 );
			VAL_MAC( _yp2, bval[16], _x2 );
			VAL_MAC( _yp3, bval[17], _x2 );
			VAL_MAC( _yp4, bval[18], _x2 );
			VAL_MAC( _yp5, bval[19], _x2 );
			VAL_MAC( _yp6, bval[20], _x2 );
			VAL_MAC( _y0, bval[0], _xp0 );
			VAL_MAC( _y1, bval[7], _xp0 );
			VAL_MAC( _y2, bval[14], _xp0 );
			VAL_MAC( _y0, bval[1], _xp1 );
			VAL_MAC( _y1, bval[8], _xp1 );
			VAL_MAC( _y2, bval[15], _xp1 );
			VAL_MAC( _y0, bval[2], _xp2 );
			VAL_MAC( _y1, bval[9], _xp2 );
			VAL_MAC( _y2, bval[16], _xp2 );
			VAL_MAC( _y0, bval[3], _xp3 );
			VAL_MAC( _y1, bval[10], _xp3 );
			VAL_MAC( _y2, bval[17], _xp3 );
			VAL_MAC( _y0, bval[4], _xp4 );
			VAL_MAC( _y1, bval[11], _xp4 );
			VAL_MAC( _y2, bval[18], _xp4 );
			VAL_MAC( _y0, bval[5], _xp5 );
			VAL_MAC( _y1, bval[12], _xp5 );
			VAL_MAC( _y2, bval[19], _xp5 );
			VAL_MAC( _y0, bval[6], _xp6 );
			VAL_MAC( _y1, bval[13], _xp6 );
			VAL_MAC( _y2, bval[20], _xp6 );
			VAL_INC( ypp[0], _yp0 );
			VAL_INC( ypp[1], _yp1 );
			VAL_INC( ypp[2], _yp2 );
			VAL_INC( ypp[3], _yp3 );
			VAL_INC( ypp[4], _yp4 );
			VAL_INC( ypp[5], _yp5 );
			VAL_INC( ypp[6], _yp6 );
		}
		VAL_MAC( yp[0], alpha, _y0 );
		VAL_MAC( yp[1], alpha, _y1 );
		VAL_MAC( yp[2], alpha, _y2 );
	}
	/* Diagonal block multiply */
	yp = y + d0;
	xp = x + d0;
	for( I = 0; I < M; I++, bdiag += 3*3, yp += 3, xp += 3 )
	{
		REGISTER oski_value_t _x0;
		REGISTER oski_value_t _x1;
		REGISTER oski_value_t _x2;
		REGISTER oski_value_t _y0;
		REGISTER oski_value_t _y1;
		REGISTER oski_value_t _y2;
		VAL_ASSIGN( _x0, xp[0] );
		VAL_ASSIGN( _x1, xp[1] );
		VAL_ASSIGN( _x2, xp[2] );
		VAL_SET_ZERO( _y0 );
		VAL_SET_ZERO( _y1 );
		VAL_SET_ZERO( _y2 );
		VAL_MAC( _y0, bdiag[0], _x0 );
		VAL_MAC( _y1, bdiag[3], _x0 );
		VAL_MAC( _y2, bdiag[6], _x0 );
		VAL_MAC( _y0, bdiag[1], _x1 );
		VAL_MAC( _y1, bdiag[4], _x1 );
		VAL_MAC( _y2, bdiag[7], _x1 );
		VAL_MAC( _y0, bdiag[2], _x2 );
		VAL_MAC( _y1, bdiag[5], _x2 );
		VAL_MAC( _y2, bdiag[8], _x2 );
		VAL_MAC( yp[0], alpha, _y0 );
		VAL_MAC( yp[1], alpha, _y1 );
		VAL_MAC( yp[2], alpha, _y2 );
	}
}


#if defined(DO_NAME_MANGLING)
/** Mangled name for MBCSR_SymmMatMult_v1_aX_b1_xs1_ysX */
#define MBCSR_SymmMatMult_v1_aX_b1_xs1_ysX MANGLE_MOD_(MBCSR_SymmMatMult_v1_aX_b1_xs1_ysX_3x7)
#endif

/**
 *  \brief MBCSR implementation of
 *  \f$y \leftarrow y + \alpha\cdot A\cdot x\f$.
 */
void
MBCSR_SymmMatMult_v1_aX_b1_xs1_ysX( oski_index_t M, oski_index_t d0,
	const oski_index_t* restrict bptr, const oski_index_t* restrict bind,
	const oski_value_t* restrict bval, const oski_value_t* restrict bdiag,
	oski_value_t alpha, const oski_value_t* restrict x,
	oski_value_t* restrict y, oski_index_t incy )
{
	oski_value_t* yp = y + d0*incy;
	const oski_value_t* xp = x + d0;
	oski_index_t I;

	for( I = 0; I < M; I++, yp += 3*incy, xp += 3 )
	{
		REGISTER oski_value_t _y0;
		REGISTER oski_value_t _y1;
		REGISTER oski_value_t _y2;
		REGISTER oski_value_t _x0;
		REGISTER oski_value_t _x1;
		REGISTER oski_value_t _x2;
		oski_index_t K;

		VAL_SET_ZERO( _y0 );
		VAL_SET_ZERO( _y1 );
		VAL_SET_ZERO( _y2 );
		VAL_MUL( _x0, alpha, xp[0] );
		VAL_MUL( _x1, alpha, xp[1] );
		VAL_MUL( _x2, alpha, xp[2] );

		for( K = bptr[I]; K < bptr[I+1]; K++, bind++, bval += 3*7 )
		{
			oski_index_t j0 = bind[0]; /* block's leftmost col index */
			const oski_value_t* xpp = x + j0;
			oski_value_t* ypp = y + j0*incy;

			REGISTER oski_value_t _xp0;
			REGISTER oski_value_t _xp1;
			REGISTER oski_value_t _xp2;
			REGISTER oski_value_t _xp3;
			REGISTER oski_value_t _xp4;
			REGISTER oski_value_t _xp5;
			REGISTER oski_value_t _xp6;
			REGISTER oski_value_t _yp0;
			REGISTER oski_value_t _yp1;
			REGISTER oski_value_t _yp2;
			REGISTER oski_value_t _yp3;
			REGISTER oski_value_t _yp4;
			REGISTER oski_value_t _yp5;
			REGISTER oski_value_t _yp6;
			VAL_SET_ZERO( _yp0 );
			VAL_SET_ZERO( _yp1 );
			VAL_SET_ZERO( _yp2 );
			VAL_SET_ZERO( _yp3 );
			VAL_SET_ZERO( _yp4 );
			VAL_SET_ZERO( _yp5 );
			VAL_SET_ZERO( _yp6 );
			VAL_ASSIGN( _xp0, xpp[0] );
			VAL_ASSIGN( _xp1, xpp[1] );
			VAL_ASSIGN( _xp2, xpp[2] );
			VAL_ASSIGN( _xp3, xpp[3] );
			VAL_ASSIGN( _xp4, xpp[4] );
			VAL_ASSIGN( _xp5, xpp[5] );
			VAL_ASSIGN( _xp6, xpp[6] );
			VAL_MAC( _yp0, bval[0], _x0 );
			VAL_MAC( _yp1, bval[1], _x0 );
			VAL_MAC( _yp2, bval[2], _x0 );
			VAL_MAC( _yp3, bval[3], _x0 );
			VAL_MAC( _yp4, bval[4], _x0 );
			VAL_MAC( _yp5, bval[5], _x0 );
			VAL_MAC( _yp6, bval[6], _x0 );
			VAL_MAC( _yp0, bval[7], _x1 );
			VAL_MAC( _yp1, bval[8], _x1 );
			VAL_MAC( _yp2, bval[9], _x1 );
			VAL_MAC( _yp3, bval[10], _x1 );
			VAL_MAC( _yp4, bval[11], _x1 );
			VAL_MAC( _yp5, bval[12], _x1 );
			VAL_MAC( _yp6, bval[13], _x1 );
			VAL_MAC( _yp0, bval[14], _x2 );
			VAL_MAC( _yp1, bval[15], _x2 );
			VAL_MAC( _yp2, bval[16], _x2 );
			VAL_MAC( _yp3, bval[17], _x2 );
			VAL_MAC( _yp4, bval[18], _x2 );
			VAL_MAC( _yp5, bval[19], _x2 );
			VAL_MAC( _yp6, bval[20], _x2 );
			VAL_MAC( _y0, bval[0], _xp0 );
			VAL_MAC( _y1, bval[7], _xp0 );
			VAL_MAC( _y2, bval[14], _xp0 );
			VAL_MAC( _y0, bval[1], _xp1 );
			VAL_MAC( _y1, bval[8], _xp1 );
			VAL_MAC( _y2, bval[15], _xp1 );
			VAL_MAC( _y0, bval[2], _xp2 );
			VAL_MAC( _y1, bval[9], _xp2 );
			VAL_MAC( _y2, bval[16], _xp2 );
			VAL_MAC( _y0, bval[3], _xp3 );
			VAL_MAC( _y1, bval[10], _xp3 );
			VAL_MAC( _y2, bval[17], _xp3 );
			VAL_MAC( _y0, bval[4], _xp4 );
			VAL_MAC( _y1, bval[11], _xp4 );
			VAL_MAC( _y2, bval[18], _xp4 );
			VAL_MAC( _y0, bval[5], _xp5 );
			VAL_MAC( _y1, bval[12], _xp5 );
			VAL_MAC( _y2, bval[19], _xp5 );
			VAL_MAC( _y0, bval[6], _xp6 );
			VAL_MAC( _y1, bval[13], _xp6 );
			VAL_MAC( _y2, bval[20], _xp6 );
			VAL_INC( ypp[0], _yp0 );
			VAL_INC( ypp[1*incy], _yp1 );
			VAL_INC( ypp[2*incy], _yp2 );
			VAL_INC( ypp[3*incy], _yp3 );
			VAL_INC( ypp[4*incy], _yp4 );
			VAL_INC( ypp[5*incy], _yp5 );
			VAL_INC( ypp[6*incy], _yp6 );
		}
		VAL_MAC( yp[0], alpha, _y0 );
		VAL_MAC( yp[1*incy], alpha, _y1 );
		VAL_MAC( yp[2*incy], alpha, _y2 );
	}
	/* Diagonal block multiply */
	yp = y + d0*incy;
	xp = x + d0;
	for( I = 0; I < M; I++, bdiag += 3*3, yp += 3*incy, xp += 3 )
	{
		REGISTER oski_value_t _x0;
		REGISTER oski_value_t _x1;
		REGISTER oski_value_t _x2;
		REGISTER oski_value_t _y0;
		REGISTER oski_value_t _y1;
		REGISTER oski_value_t _y2;
		VAL_ASSIGN( _x0, xp[0] );
		VAL_ASSIGN( _x1, xp[1] );
		VAL_ASSIGN( _x2, xp[2] );
		VAL_SET_ZERO( _y0 );
		VAL_SET_ZERO( _y1 );
		VAL_SET_ZERO( _y2 );
		VAL_MAC( _y0, bdiag[0], _x0 );
		VAL_MAC( _y1, bdiag[3], _x0 );
		VAL_MAC( _y2, bdiag[6], _x0 );
		VAL_MAC( _y0, bdiag[1], _x1 );
		VAL_MAC( _y1, bdiag[4], _x1 );
		VAL_MAC( _y2, bdiag[7], _x1 );
		VAL_MAC( _y0, bdiag[2], _x2 );
		VAL_MAC( _y1, bdiag[5], _x2 );
		VAL_MAC( _y2, bdiag[8], _x2 );
		VAL_MAC( yp[0], alpha, _y0 );
		VAL_MAC( yp[1*incy], alpha, _y1 );
		VAL_MAC( yp[2*incy], alpha, _y2 );
	}
}


#if defined(DO_NAME_MANGLING)
/** Mangled name for MBCSR_SymmMatMult_v1_aX_b1_xsX_ys1 */
#define MBCSR_SymmMatMult_v1_aX_b1_xsX_ys1 MANGLE_MOD_(MBCSR_SymmMatMult_v1_aX_b1_xsX_ys1_3x7)
#endif

/**
 *  \brief MBCSR implementation of
 *  \f$y \leftarrow y + \alpha\cdot A\cdot x\f$.
 */
void
MBCSR_SymmMatMult_v1_aX_b1_xsX_ys1( oski_index_t M, oski_index_t d0,
	const oski_index_t* restrict bptr, const oski_index_t* restrict bind,
	const oski_value_t* restrict bval, const oski_value_t* restrict bdiag,
	oski_value_t alpha, const oski_value_t* restrict x, oski_index_t incx,
	oski_value_t* restrict y )
{
	oski_value_t* yp = y + d0;
	const oski_value_t* xp = x + d0*incx;
	oski_index_t I;

	for( I = 0; I < M; I++, yp += 3, xp += 3*incx )
	{
		REGISTER oski_value_t _y0;
		REGISTER oski_value_t _y1;
		REGISTER oski_value_t _y2;
		REGISTER oski_value_t _x0;
		REGISTER oski_value_t _x1;
		REGISTER oski_value_t _x2;
		oski_index_t K;

		VAL_SET_ZERO( _y0 );
		VAL_SET_ZERO( _y1 );
		VAL_SET_ZERO( _y2 );
		VAL_MUL( _x0, alpha, xp[0] );
		VAL_MUL( _x1, alpha, xp[1*incx] );
		VAL_MUL( _x2, alpha, xp[2*incx] );

		for( K = bptr[I]; K < bptr[I+1]; K++, bind++, bval += 3*7 )
		{
			oski_index_t j0 = bind[0]; /* block's leftmost col index */
			const oski_value_t* xpp = x + j0*incx;
			oski_value_t* ypp = y + j0;

			REGISTER oski_value_t _xp0;
			REGISTER oski_value_t _xp1;
			REGISTER oski_value_t _xp2;
			REGISTER oski_value_t _xp3;
			REGISTER oski_value_t _xp4;
			REGISTER oski_value_t _xp5;
			REGISTER oski_value_t _xp6;
			REGISTER oski_value_t _yp0;
			REGISTER oski_value_t _yp1;
			REGISTER oski_value_t _yp2;
			REGISTER oski_value_t _yp3;
			REGISTER oski_value_t _yp4;
			REGISTER oski_value_t _yp5;
			REGISTER oski_value_t _yp6;
			VAL_SET_ZERO( _yp0 );
			VAL_SET_ZERO( _yp1 );
			VAL_SET_ZERO( _yp2 );
			VAL_SET_ZERO( _yp3 );
			VAL_SET_ZERO( _yp4 );
			VAL_SET_ZERO( _yp5 );
			VAL_SET_ZERO( _yp6 );
			VAL_ASSIGN( _xp0, xpp[0] );
			VAL_ASSIGN( _xp1, xpp[1*incx] );
			VAL_ASSIGN( _xp2, xpp[2*incx] );
			VAL_ASSIGN( _xp3, xpp[3*incx] );
			VAL_ASSIGN( _xp4, xpp[4*incx] );
			VAL_ASSIGN( _xp5, xpp[5*incx] );
			VAL_ASSIGN( _xp6, xpp[6*incx] );
			VAL_MAC( _yp0, bval[0], _x0 );
			VAL_MAC( _yp1, bval[1], _x0 );
			VAL_MAC( _yp2, bval[2], _x0 );
			VAL_MAC( _yp3, bval[3], _x0 );
			VAL_MAC( _yp4, bval[4], _x0 );
			VAL_MAC( _yp5, bval[5], _x0 );
			VAL_MAC( _yp6, bval[6], _x0 );
			VAL_MAC( _yp0, bval[7], _x1 );
			VAL_MAC( _yp1, bval[8], _x1 );
			VAL_MAC( _yp2, bval[9], _x1 );
			VAL_MAC( _yp3, bval[10], _x1 );
			VAL_MAC( _yp4, bval[11], _x1 );
			VAL_MAC( _yp5, bval[12], _x1 );
			VAL_MAC( _yp6, bval[13], _x1 );
			VAL_MAC( _yp0, bval[14], _x2 );
			VAL_MAC( _yp1, bval[15], _x2 );
			VAL_MAC( _yp2, bval[16], _x2 );
			VAL_MAC( _yp3, bval[17], _x2 );
			VAL_MAC( _yp4, bval[18], _x2 );
			VAL_MAC( _yp5, bval[19], _x2 );
			VAL_MAC( _yp6, bval[20], _x2 );
			VAL_MAC( _y0, bval[0], _xp0 );
			VAL_MAC( _y1, bval[7], _xp0 );
			VAL_MAC( _y2, bval[14], _xp0 );
			VAL_MAC( _y0, bval[1], _xp1 );
			VAL_MAC( _y1, bval[8], _xp1 );
			VAL_MAC( _y2, bval[15], _xp1 );
			VAL_MAC( _y0, bval[2], _xp2 );
			VAL_MAC( _y1, bval[9], _xp2 );
			VAL_MAC( _y2, bval[16], _xp2 );
			VAL_MAC( _y0, bval[3], _xp3 );
			VAL_MAC( _y1, bval[10], _xp3 );
			VAL_MAC( _y2, bval[17], _xp3 );
			VAL_MAC( _y0, bval[4], _xp4 );
			VAL_MAC( _y1, bval[11], _xp4 );
			VAL_MAC( _y2, bval[18], _xp4 );
			VAL_MAC( _y0, bval[5], _xp5 );
			VAL_MAC( _y1, bval[12], _xp5 );
			VAL_MAC( _y2, bval[19], _xp5 );
			VAL_MAC( _y0, bval[6], _xp6 );
			VAL_MAC( _y1, bval[13], _xp6 );
			VAL_MAC( _y2, bval[20], _xp6 );
			VAL_INC( ypp[0], _yp0 );
			VAL_INC( ypp[1], _yp1 );
			VAL_INC( ypp[2], _yp2 );
			VAL_INC( ypp[3], _yp3 );
			VAL_INC( ypp[4], _yp4 );
			VAL_INC( ypp[5], _yp5 );
			VAL_INC( ypp[6], _yp6 );
		}
		VAL_MAC( yp[0], alpha, _y0 );
		VAL_MAC( yp[1], alpha, _y1 );
		VAL_MAC( yp[2], alpha, _y2 );
	}
	/* Diagonal block multiply */
	yp = y + d0;
	xp = x + d0*incx;
	for( I = 0; I < M; I++, bdiag += 3*3, yp += 3, xp += 3*incx )
	{
		REGISTER oski_value_t _x0;
		REGISTER oski_value_t _x1;
		REGISTER oski_value_t _x2;
		REGISTER oski_value_t _y0;
		REGISTER oski_value_t _y1;
		REGISTER oski_value_t _y2;
		VAL_ASSIGN( _x0, xp[0] );
		VAL_ASSIGN( _x1, xp[1*incx] );
		VAL_ASSIGN( _x2, xp[2*incx] );
		VAL_SET_ZERO( _y0 );
		VAL_SET_ZERO( _y1 );
		VAL_SET_ZERO( _y2 );
		VAL_MAC( _y0, bdiag[0], _x0 );
		VAL_MAC( _y1, bdiag[3], _x0 );
		VAL_MAC( _y2, bdiag[6], _x0 );
		VAL_MAC( _y0, bdiag[1], _x1 );
		VAL_MAC( _y1, bdiag[4], _x1 );
		VAL_MAC( _y2, bdiag[7], _x1 );
		VAL_MAC( _y0, bdiag[2], _x2 );
		VAL_MAC( _y1, bdiag[5], _x2 );
		VAL_MAC( _y2, bdiag[8], _x2 );
		VAL_MAC( yp[0], alpha, _y0 );
		VAL_MAC( yp[1], alpha, _y1 );
		VAL_MAC( yp[2], alpha, _y2 );
	}
}


#if defined(DO_NAME_MANGLING)
/** Mangled name for MBCSR_SymmMatMult_v1_aX_b1_xsX_ysX */
#define MBCSR_SymmMatMult_v1_aX_b1_xsX_ysX MANGLE_MOD_(MBCSR_SymmMatMult_v1_aX_b1_xsX_ysX_3x7)
#endif

/**
 *  \brief MBCSR implementation of
 *  \f$y \leftarrow y + \alpha\cdot A\cdot x\f$.
 */
void
MBCSR_SymmMatMult_v1_aX_b1_xsX_ysX( oski_index_t M, oski_index_t d0,
	const oski_index_t* restrict bptr, const oski_index_t* restrict bind,
	const oski_value_t* restrict bval, const oski_value_t* restrict bdiag,
	oski_value_t alpha, const oski_value_t* restrict x, oski_index_t incx,
	oski_value_t* restrict y, oski_index_t incy )
{
	oski_value_t* yp = y + d0*incy;
	const oski_value_t* xp = x + d0*incx;
	oski_index_t I;

	for( I = 0; I < M; I++, yp += 3*incy, xp += 3*incx )
	{
		REGISTER oski_value_t _y0;
		REGISTER oski_value_t _y1;
		REGISTER oski_value_t _y2;
		REGISTER oski_value_t _x0;
		REGISTER oski_value_t _x1;
		REGISTER oski_value_t _x2;
		oski_index_t K;

		VAL_SET_ZERO( _y0 );
		VAL_SET_ZERO( _y1 );
		VAL_SET_ZERO( _y2 );
		VAL_MUL( _x0, alpha, xp[0] );
		VAL_MUL( _x1, alpha, xp[1*incx] );
		VAL_MUL( _x2, alpha, xp[2*incx] );

		for( K = bptr[I]; K < bptr[I+1]; K++, bind++, bval += 3*7 )
		{
			oski_index_t j0 = bind[0]; /* block's leftmost col index */
			const oski_value_t* xpp = x + j0*incx;
			oski_value_t* ypp = y + j0*incy;

			REGISTER oski_value_t _xp0;
			REGISTER oski_value_t _xp1;
			REGISTER oski_value_t _xp2;
			REGISTER oski_value_t _xp3;
			REGISTER oski_value_t _xp4;
			REGISTER oski_value_t _xp5;
			REGISTER oski_value_t _xp6;
			REGISTER oski_value_t _yp0;
			REGISTER oski_value_t _yp1;
			REGISTER oski_value_t _yp2;
			REGISTER oski_value_t _yp3;
			REGISTER oski_value_t _yp4;
			REGISTER oski_value_t _yp5;
			REGISTER oski_value_t _yp6;
			VAL_SET_ZERO( _yp0 );
			VAL_SET_ZERO( _yp1 );
			VAL_SET_ZERO( _yp2 );
			VAL_SET_ZERO( _yp3 );
			VAL_SET_ZERO( _yp4 );
			VAL_SET_ZERO( _yp5 );
			VAL_SET_ZERO( _yp6 );
			VAL_ASSIGN( _xp0, xpp[0] );
			VAL_ASSIGN( _xp1, xpp[1*incx] );
			VAL_ASSIGN( _xp2, xpp[2*incx] );
			VAL_ASSIGN( _xp3, xpp[3*incx] );
			VAL_ASSIGN( _xp4, xpp[4*incx] );
			VAL_ASSIGN( _xp5, xpp[5*incx] );
			VAL_ASSIGN( _xp6, xpp[6*incx] );
			VAL_MAC( _yp0, bval[0], _x0 );
			VAL_MAC( _yp1, bval[1], _x0 );
			VAL_MAC( _yp2, bval[2], _x0 );
			VAL_MAC( _yp3, bval[3], _x0 );
			VAL_MAC( _yp4, bval[4], _x0 );
			VAL_MAC( _yp5, bval[5], _x0 );
			VAL_MAC( _yp6, bval[6], _x0 );
			VAL_MAC( _yp0, bval[7], _x1 );
			VAL_MAC( _yp1, bval[8], _x1 );
			VAL_MAC( _yp2, bval[9], _x1 );
			VAL_MAC( _yp3, bval[10], _x1 );
			VAL_MAC( _yp4, bval[11], _x1 );
			VAL_MAC( _yp5, bval[12], _x1 );
			VAL_MAC( _yp6, bval[13], _x1 );
			VAL_MAC( _yp0, bval[14], _x2 );
			VAL_MAC( _yp1, bval[15], _x2 );
			VAL_MAC( _yp2, bval[16], _x2 );
			VAL_MAC( _yp3, bval[17], _x2 );
			VAL_MAC( _yp4, bval[18], _x2 );
			VAL_MAC( _yp5, bval[19], _x2 );
			VAL_MAC( _yp6, bval[20], _x2 );
			VAL_MAC( _y0, bval[0], _xp0 );
			VAL_MAC( _y1, bval[7], _xp0 );
			VAL_MAC( _y2, bval[14], _xp0 );
			VAL_MAC( _y0, bval[1], _xp1 );
			VAL_MAC( _y1, bval[8], _xp1 );
			VAL_MAC( _y2, bval[15], _xp1 );
			VAL_MAC( _y0, bval[2], _xp2 );
			VAL_MAC( _y1, bval[9], _xp2 );
			VAL_MAC( _y2, bval[16], _xp2 );
			VAL_MAC( _y0, bval[3], _xp3 );
			VAL_MAC( _y1, bval[10], _xp3 );
			VAL_MAC( _y2, bval[17], _xp3 );
			VAL_MAC( _y0, bval[4], _xp4 );
			VAL_MAC( _y1, bval[11], _xp4 );
			VAL_MAC( _y2, bval[18], _xp4 );
			VAL_MAC( _y0, bval[5], _xp5 );
			VAL_MAC( _y1, bval[12], _xp5 );
			VAL_MAC( _y2, bval[19], _xp5 );
			VAL_MAC( _y0, bval[6], _xp6 );
			VAL_MAC( _y1, bval[13], _xp6 );
			VAL_MAC( _y2, bval[20], _xp6 );
			VAL_INC( ypp[0], _yp0 );
			VAL_INC( ypp[1*incy], _yp1 );
			VAL_INC( ypp[2*incy], _yp2 );
			VAL_INC( ypp[3*incy], _yp3 );
			VAL_INC( ypp[4*incy], _yp4 );
			VAL_INC( ypp[5*incy], _yp5 );
			VAL_INC( ypp[6*incy], _yp6 );
		}
		VAL_MAC( yp[0], alpha, _y0 );
		VAL_MAC( yp[1*incy], alpha, _y1 );
		VAL_MAC( yp[2*incy], alpha, _y2 );
	}
	/* Diagonal block multiply */
	yp = y + d0*incy;
	xp = x + d0*incx;
	for( I = 0; I < M; I++, bdiag += 3*3, yp += 3*incy, xp += 3*incx )
	{
		REGISTER oski_value_t _x0;
		REGISTER oski_value_t _x1;
		REGISTER oski_value_t _x2;
		REGISTER oski_value_t _y0;
		REGISTER oski_value_t _y1;
		REGISTER oski_value_t _y2;
		VAL_ASSIGN( _x0, xp[0] );
		VAL_ASSIGN( _x1, xp[1*incx] );
		VAL_ASSIGN( _x2, xp[2*incx] );
		VAL_SET_ZERO( _y0 );
		VAL_SET_ZERO( _y1 );
		VAL_SET_ZERO( _y2 );
		VAL_MAC( _y0, bdiag[0], _x0 );
		VAL_MAC( _y1, bdiag[3], _x0 );
		VAL_MAC( _y2, bdiag[6], _x0 );
		VAL_MAC( _y0, bdiag[1], _x1 );
		VAL_MAC( _y1, bdiag[4], _x1 );
		VAL_MAC( _y2, bdiag[7], _x1 );
		VAL_MAC( _y0, bdiag[2], _x2 );
		VAL_MAC( _y1, bdiag[5], _x2 );
		VAL_MAC( _y2, bdiag[8], _x2 );
		VAL_MAC( yp[0], alpha, _y0 );
		VAL_MAC( yp[1*incy], alpha, _y1 );
		VAL_MAC( yp[2*incy], alpha, _y2 );
	}
}


/**
 *  \brief Symmetric matrix times single-vector multiply in the normal case.
 */
static void
SymmMatMult_v1( oski_index_t M, oski_index_t d0,
	const oski_index_t* bptr, const oski_index_t* bind,
	const oski_value_t* bval, const oski_value_t* bdiag,
	oski_value_t alpha, const oski_value_t* x, oski_index_t incx,
	oski_value_t* y, oski_index_t incy )
{
	if( incx == 1 ) {
		if( incy == 1 ) {
			MBCSR_SymmMatMult_v1_aX_b1_xs1_ys1( M, d0,
				bptr, bind, bval, bdiag, alpha, x, y );
		} else { /* general incy */
			MBCSR_SymmMatMult_v1_aX_b1_xs1_ysX( M, d0,
				bptr, bind, bval, bdiag, alpha, x, y, incy );
		}
	} else { /* general incx */
		if( incy == 1 ) {
			MBCSR_SymmMatMult_v1_aX_b1_xsX_ys1( M, d0,
				bptr, bind, bval, bdiag, alpha, x, incx, y );
		} else { /* general incy */
			MBCSR_SymmMatMult_v1_aX_b1_xsX_ysX( M, d0,
				bptr, bind, bval, bdiag, alpha, x, incx, y, incy );
		}
	}
}


/**
 *  \brief Computes
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$\mathrm{op}(A) = A\f$, on the fully blocked
 *  portion of \f$A\f$.
 */
static int
SymmMatMult( const oski_submatMBCSR_t* A,
	oski_value_t alpha, const oski_vecview_t x_view,
	oski_vecview_t y_view )
{
	oski_index_t j; /* column number */
	const oski_value_t* xpj; /* X(:, j) */
	oski_value_t* ypj; /* Y(:, j) */

	assert( A->r == 3 );
	assert( A->c == 7 );

	for( j = 0, xpj = x_view->val, ypj = y_view->val;
		j < x_view->num_cols;
		j++, xpj += x_view->colinc, ypj += y_view->colinc )
	{
		SymmMatMult_v1( A->num_block_rows, A->offset,
			A->bptr, A->bind, A->bval, A->bdiag,
			alpha, xpj, x_view->rowinc, ypj, y_view->rowinc );
	}

	return 0;
}


#if !IS_VAL_COMPLEX

#if defined(DO_NAME_MANGLING)
/** See MBCSR_SymmMatMult_v1_aX_b1_xs1_ys1(). */
#define MBCSR_SymmMatConjMult_v1_aX_b1_xs1_ys1 MBCSR_SymmMatMult_v1_aX_b1_xs1_ys1
#endif

#else /* IS_VAL_COMPLEX */



#if defined(DO_NAME_MANGLING)
/** Mangled name for MBCSR_SymmMatConjMult_v1_aX_b1_xs1_ys1 */
#define MBCSR_SymmMatConjMult_v1_aX_b1_xs1_ys1 MANGLE_MOD_(MBCSR_SymmMatConjMult_v1_aX_b1_xs1_ys1_3x7)
#endif

/**
 *  \brief MBCSR implementation of
 *  \f$y \leftarrow y + \alpha\cdot \bar{A}\cdot x\f$.
 */
void
MBCSR_SymmMatConjMult_v1_aX_b1_xs1_ys1( oski_index_t M, oski_index_t d0,
	const oski_index_t* restrict bptr, const oski_index_t* restrict bind,
	const oski_value_t* restrict bval, const oski_value_t* restrict bdiag,
	oski_value_t alpha, const oski_value_t* restrict x,
	oski_value_t* restrict y )
{
	oski_value_t* yp = y + d0;
	const oski_value_t* xp = x + d0;
	oski_index_t I;

	for( I = 0; I < M; I++, yp += 3, xp += 3 )
	{
		REGISTER oski_value_t _y0;
		REGISTER oski_value_t _y1;
		REGISTER oski_value_t _y2;
		REGISTER oski_value_t _x0;
		REGISTER oski_value_t _x1;
		REGISTER oski_value_t _x2;
		oski_index_t K;

		VAL_SET_ZERO( _y0 );
		VAL_SET_ZERO( _y1 );
		VAL_SET_ZERO( _y2 );
		VAL_MUL( _x0, alpha, xp[0] );
		VAL_MUL( _x1, alpha, xp[1] );
		VAL_MUL( _x2, alpha, xp[2] );

		for( K = bptr[I]; K < bptr[I+1]; K++, bind++, bval += 3*7 )
		{
			oski_index_t j0 = bind[0]; /* block's leftmost col index */
			const oski_value_t* xpp = x + j0;
			oski_value_t* ypp = y + j0;

			REGISTER oski_value_t _xp0;
			REGISTER oski_value_t _xp1;
			REGISTER oski_value_t _xp2;
			REGISTER oski_value_t _xp3;
			REGISTER oski_value_t _xp4;
			REGISTER oski_value_t _xp5;
			REGISTER oski_value_t _xp6;
			REGISTER oski_value_t _yp0;
			REGISTER oski_value_t _yp1;
			REGISTER oski_value_t _yp2;
			REGISTER oski_value_t _yp3;
			REGISTER oski_value_t _yp4;
			REGISTER oski_value_t _yp5;
			REGISTER oski_value_t _yp6;
			VAL_SET_ZERO( _yp0 );
			VAL_SET_ZERO( _yp1 );
			VAL_SET_ZERO( _yp2 );
			VAL_SET_ZERO( _yp3 );
			VAL_SET_ZERO( _yp4 );
			VAL_SET_ZERO( _yp5 );
			VAL_SET_ZERO( _yp6 );
			VAL_ASSIGN( _xp0, xpp[0] );
			VAL_ASSIGN( _xp1, xpp[1] );
			VAL_ASSIGN( _xp2, xpp[2] );
			VAL_ASSIGN( _xp3, xpp[3] );
			VAL_ASSIGN( _xp4, xpp[4] );
			VAL_ASSIGN( _xp5, xpp[5] );
			VAL_ASSIGN( _xp6, xpp[6] );
			VAL_MAC_CONJ( _yp0, bval[0], _x0 );
			VAL_MAC_CONJ( _yp1, bval[1], _x0 );
			VAL_MAC_CONJ( _yp2, bval[2], _x0 );
			VAL_MAC_CONJ( _yp3, bval[3], _x0 );
			VAL_MAC_CONJ( _yp4, bval[4], _x0 );
			VAL_MAC_CONJ( _yp5, bval[5], _x0 );
			VAL_MAC_CONJ( _yp6, bval[6], _x0 );
			VAL_MAC_CONJ( _yp0, bval[7], _x1 );
			VAL_MAC_CONJ( _yp1, bval[8], _x1 );
			VAL_MAC_CONJ( _yp2, bval[9], _x1 );
			VAL_MAC_CONJ( _yp3, bval[10], _x1 );
			VAL_MAC_CONJ( _yp4, bval[11], _x1 );
			VAL_MAC_CONJ( _yp5, bval[12], _x1 );
			VAL_MAC_CONJ( _yp6, bval[13], _x1 );
			VAL_MAC_CONJ( _yp0, bval[14], _x2 );
			VAL_MAC_CONJ( _yp1, bval[15], _x2 );
			VAL_MAC_CONJ( _yp2, bval[16], _x2 );
			VAL_MAC_CONJ( _yp3, bval[17], _x2 );
			VAL_MAC_CONJ( _yp4, bval[18], _x2 );
			VAL_MAC_CONJ( _yp5, bval[19], _x2 );
			VAL_MAC_CONJ( _yp6, bval[20], _x2 );
			VAL_MAC_CONJ( _y0, bval[0], _xp0 );
			VAL_MAC_CONJ( _y1, bval[7], _xp0 );
			VAL_MAC_CONJ( _y2, bval[14], _xp0 );
			VAL_MAC_CONJ( _y0, bval[1], _xp1 );
			VAL_MAC_CONJ( _y1, bval[8], _xp1 );
			VAL_MAC_CONJ( _y2, bval[15], _xp1 );
			VAL_MAC_CONJ( _y0, bval[2], _xp2 );
			VAL_MAC_CONJ( _y1, bval[9], _xp2 );
			VAL_MAC_CONJ( _y2, bval[16], _xp2 );
			VAL_MAC_CONJ( _y0, bval[3], _xp3 );
			VAL_MAC_CONJ( _y1, bval[10], _xp3 );
			VAL_MAC_CONJ( _y2, bval[17], _xp3 );
			VAL_MAC_CONJ( _y0, bval[4], _xp4 );
			VAL_MAC_CONJ( _y1, bval[11], _xp4 );
			VAL_MAC_CONJ( _y2, bval[18], _xp4 );
			VAL_MAC_CONJ( _y0, bval[5], _xp5 );
			VAL_MAC_CONJ( _y1, bval[12], _xp5 );
			VAL_MAC_CONJ( _y2, bval[19], _xp5 );
			VAL_MAC_CONJ( _y0, bval[6], _xp6 );
			VAL_MAC_CONJ( _y1, bval[13], _xp6 );
			VAL_MAC_CONJ( _y2, bval[20], _xp6 );
			VAL_INC( ypp[0], _yp0 );
			VAL_INC( ypp[1], _yp1 );
			VAL_INC( ypp[2], _yp2 );
			VAL_INC( ypp[3], _yp3 );
			VAL_INC( ypp[4], _yp4 );
			VAL_INC( ypp[5], _yp5 );
			VAL_INC( ypp[6], _yp6 );
		}
		VAL_MAC( yp[0], alpha, _y0 );
		VAL_MAC( yp[1], alpha, _y1 );
		VAL_MAC( yp[2], alpha, _y2 );
	}
	/* Diagonal block multiply */
	yp = y + d0;
	xp = x + d0;
	for( I = 0; I < M; I++, bdiag += 3*3, yp += 3, xp += 3 )
	{
		REGISTER oski_value_t _x0;
		REGISTER oski_value_t _x1;
		REGISTER oski_value_t _x2;
		REGISTER oski_value_t _y0;
		REGISTER oski_value_t _y1;
		REGISTER oski_value_t _y2;
		VAL_ASSIGN( _x0, xp[0] );
		VAL_ASSIGN( _x1, xp[1] );
		VAL_ASSIGN( _x2, xp[2] );
		VAL_SET_ZERO( _y0 );
		VAL_SET_ZERO( _y1 );
		VAL_SET_ZERO( _y2 );
		VAL_MAC_CONJ( _y0, bdiag[0], _x0 );
		VAL_MAC_CONJ( _y1, bdiag[3], _x0 );
		VAL_MAC_CONJ( _y2, bdiag[6], _x0 );
		VAL_MAC_CONJ( _y0, bdiag[1], _x1 );
		VAL_MAC_CONJ( _y1, bdiag[4], _x1 );
		VAL_MAC_CONJ( _y2, bdiag[7], _x1 );
		VAL_MAC_CONJ( _y0, bdiag[2], _x2 );
		VAL_MAC_CONJ( _y1, bdiag[5], _x2 );
		VAL_MAC_CONJ( _y2, bdiag[8], _x2 );
		VAL_MAC( yp[0], alpha, _y0 );
		VAL_MAC( yp[1], alpha, _y1 );
		VAL_MAC( yp[2], alpha, _y2 );
	}
}


#endif /* !IS_VAL_COMPLEX */


#if !IS_VAL_COMPLEX

#if defined(DO_NAME_MANGLING)
/** See MBCSR_SymmMatMult_v1_aX_b1_xs1_ysX(). */
#define MBCSR_SymmMatConjMult_v1_aX_b1_xs1_ysX MBCSR_SymmMatMult_v1_aX_b1_xs1_ysX
#endif

#else /* IS_VAL_COMPLEX */



#if defined(DO_NAME_MANGLING)
/** Mangled name for MBCSR_SymmMatConjMult_v1_aX_b1_xs1_ysX */
#define MBCSR_SymmMatConjMult_v1_aX_b1_xs1_ysX MANGLE_MOD_(MBCSR_SymmMatConjMult_v1_aX_b1_xs1_ysX_3x7)
#endif

/**
 *  \brief MBCSR implementation of
 *  \f$y \leftarrow y + \alpha\cdot \bar{A}\cdot x\f$.
 */
void
MBCSR_SymmMatConjMult_v1_aX_b1_xs1_ysX( oski_index_t M, oski_index_t d0,
	const oski_index_t* restrict bptr, const oski_index_t* restrict bind,
	const oski_value_t* restrict bval, const oski_value_t* restrict bdiag,
	oski_value_t alpha, const oski_value_t* restrict x,
	oski_value_t* restrict y, oski_index_t incy )
{
	oski_value_t* yp = y + d0*incy;
	const oski_value_t* xp = x + d0;
	oski_index_t I;

	for( I = 0; I < M; I++, yp += 3*incy, xp += 3 )
	{
		REGISTER oski_value_t _y0;
		REGISTER oski_value_t _y1;
		REGISTER oski_value_t _y2;
		REGISTER oski_value_t _x0;
		REGISTER oski_value_t _x1;
		REGISTER oski_value_t _x2;
		oski_index_t K;

		VAL_SET_ZERO( _y0 );
		VAL_SET_ZERO( _y1 );
		VAL_SET_ZERO( _y2 );
		VAL_MUL( _x0, alpha, xp[0] );
		VAL_MUL( _x1, alpha, xp[1] );
		VAL_MUL( _x2, alpha, xp[2] );

		for( K = bptr[I]; K < bptr[I+1]; K++, bind++, bval += 3*7 )
		{
			oski_index_t j0 = bind[0]; /* block's leftmost col index */
			const oski_value_t* xpp = x + j0;
			oski_value_t* ypp = y + j0*incy;

			REGISTER oski_value_t _xp0;
			REGISTER oski_value_t _xp1;
			REGISTER oski_value_t _xp2;
			REGISTER oski_value_t _xp3;
			REGISTER oski_value_t _xp4;
			REGISTER oski_value_t _xp5;
			REGISTER oski_value_t _xp6;
			REGISTER oski_value_t _yp0;
			REGISTER oski_value_t _yp1;
			REGISTER oski_value_t _yp2;
			REGISTER oski_value_t _yp3;
			REGISTER oski_value_t _yp4;
			REGISTER oski_value_t _yp5;
			REGISTER oski_value_t _yp6;
			VAL_SET_ZERO( _yp0 );
			VAL_SET_ZERO( _yp1 );
			VAL_SET_ZERO( _yp2 );
			VAL_SET_ZERO( _yp3 );
			VAL_SET_ZERO( _yp4 );
			VAL_SET_ZERO( _yp5 );
			VAL_SET_ZERO( _yp6 );
			VAL_ASSIGN( _xp0, xpp[0] );
			VAL_ASSIGN( _xp1, xpp[1] );
			VAL_ASSIGN( _xp2, xpp[2] );
			VAL_ASSIGN( _xp3, xpp[3] );
			VAL_ASSIGN( _xp4, xpp[4] );
			VAL_ASSIGN( _xp5, xpp[5] );
			VAL_ASSIGN( _xp6, xpp[6] );
			VAL_MAC_CONJ( _yp0, bval[0], _x0 );
			VAL_MAC_CONJ( _yp1, bval[1], _x0 );
			VAL_MAC_CONJ( _yp2, bval[2], _x0 );
			VAL_MAC_CONJ( _yp3, bval[3], _x0 );
			VAL_MAC_CONJ( _yp4, bval[4], _x0 );
			VAL_MAC_CONJ( _yp5, bval[5], _x0 );
			VAL_MAC_CONJ( _yp6, bval[6], _x0 );
			VAL_MAC_CONJ( _yp0, bval[7], _x1 );
			VAL_MAC_CONJ( _yp1, bval[8], _x1 );
			VAL_MAC_CONJ( _yp2, bval[9], _x1 );
			VAL_MAC_CONJ( _yp3, bval[10], _x1 );
			VAL_MAC_CONJ( _yp4, bval[11], _x1 );
			VAL_MAC_CONJ( _yp5, bval[12], _x1 );
			VAL_MAC_CONJ( _yp6, bval[13], _x1 );
			VAL_MAC_CONJ( _yp0, bval[14], _x2 );
			VAL_MAC_CONJ( _yp1, bval[15], _x2 );
			VAL_MAC_CONJ( _yp2, bval[16], _x2 );
			VAL_MAC_CONJ( _yp3, bval[17], _x2 );
			VAL_MAC_CONJ( _yp4, bval[18], _x2 );
			VAL_MAC_CONJ( _yp5, bval[19], _x2 );
			VAL_MAC_CONJ( _yp6, bval[20], _x2 );
			VAL_MAC_CONJ( _y0, bval[0], _xp0 );
			VAL_MAC_CONJ( _y1, bval[7], _xp0 );
			VAL_MAC_CONJ( _y2, bval[14], _xp0 );
			VAL_MAC_CONJ( _y0, bval[1], _xp1 );
			VAL_MAC_CONJ( _y1, bval[8], _xp1 );
			VAL_MAC_CONJ( _y2, bval[15], _xp1 );
			VAL_MAC_CONJ( _y0, bval[2], _xp2 );
			VAL_MAC_CONJ( _y1, bval[9], _xp2 );
			VAL_MAC_CONJ( _y2, bval[16], _xp2 );
			VAL_MAC_CONJ( _y0, bval[3], _xp3 );
			VAL_MAC_CONJ( _y1, bval[10], _xp3 );
			VAL_MAC_CONJ( _y2, bval[17], _xp3 );
			VAL_MAC_CONJ( _y0, bval[4], _xp4 );
			VAL_MAC_CONJ( _y1, bval[11], _xp4 );
			VAL_MAC_CONJ( _y2, bval[18], _xp4 );
			VAL_MAC_CONJ( _y0, bval[5], _xp5 );
			VAL_MAC_CONJ( _y1, bval[12], _xp5 );
			VAL_MAC_CONJ( _y2, bval[19], _xp5 );
			VAL_MAC_CONJ( _y0, bval[6], _xp6 );
			VAL_MAC_CONJ( _y1, bval[13], _xp6 );
			VAL_MAC_CONJ( _y2, bval[20], _xp6 );
			VAL_INC( ypp[0], _yp0 );
			VAL_INC( ypp[1*incy], _yp1 );
			VAL_INC( ypp[2*incy], _yp2 );
			VAL_INC( ypp[3*incy], _yp3 );
			VAL_INC( ypp[4*incy], _yp4 );
			VAL_INC( ypp[5*incy], _yp5 );
			VAL_INC( ypp[6*incy], _yp6 );
		}
		VAL_MAC( yp[0], alpha, _y0 );
		VAL_MAC( yp[1*incy], alpha, _y1 );
		VAL_MAC( yp[2*incy], alpha, _y2 );
	}
	/* Diagonal block multiply */
	yp = y + d0*incy;
	xp = x + d0;
	for( I = 0; I < M; I++, bdiag += 3*3, yp += 3*incy, xp += 3 )
	{
		REGISTER oski_value_t _x0;
		REGISTER oski_value_t _x1;
		REGISTER oski_value_t _x2;
		REGISTER oski_value_t _y0;
		REGISTER oski_value_t _y1;
		REGISTER oski_value_t _y2;
		VAL_ASSIGN( _x0, xp[0] );
		VAL_ASSIGN( _x1, xp[1] );
		VAL_ASSIGN( _x2, xp[2] );
		VAL_SET_ZERO( _y0 );
		VAL_SET_ZERO( _y1 );
		VAL_SET_ZERO( _y2 );
		VAL_MAC_CONJ( _y0, bdiag[0], _x0 );
		VAL_MAC_CONJ( _y1, bdiag[3], _x0 );
		VAL_MAC_CONJ( _y2, bdiag[6], _x0 );
		VAL_MAC_CONJ( _y0, bdiag[1], _x1 );
		VAL_MAC_CONJ( _y1, bdiag[4], _x1 );
		VAL_MAC_CONJ( _y2, bdiag[7], _x1 );
		VAL_MAC_CONJ( _y0, bdiag[2], _x2 );
		VAL_MAC_CONJ( _y1, bdiag[5], _x2 );
		VAL_MAC_CONJ( _y2, bdiag[8], _x2 );
		VAL_MAC( yp[0], alpha, _y0 );
		VAL_MAC( yp[1*incy], alpha, _y1 );
		VAL_MAC( yp[2*incy], alpha, _y2 );
	}
}


#endif /* !IS_VAL_COMPLEX */


#if !IS_VAL_COMPLEX

#if defined(DO_NAME_MANGLING)
/** See MBCSR_SymmMatMult_v1_aX_b1_xsX_ys1(). */
#define MBCSR_SymmMatConjMult_v1_aX_b1_xsX_ys1 MBCSR_SymmMatMult_v1_aX_b1_xsX_ys1
#endif

#else /* IS_VAL_COMPLEX */



#if defined(DO_NAME_MANGLING)
/** Mangled name for MBCSR_SymmMatConjMult_v1_aX_b1_xsX_ys1 */
#define MBCSR_SymmMatConjMult_v1_aX_b1_xsX_ys1 MANGLE_MOD_(MBCSR_SymmMatConjMult_v1_aX_b1_xsX_ys1_3x7)
#endif

/**
 *  \brief MBCSR implementation of
 *  \f$y \leftarrow y + \alpha\cdot \bar{A}\cdot x\f$.
 */
void
MBCSR_SymmMatConjMult_v1_aX_b1_xsX_ys1( oski_index_t M, oski_index_t d0,
	const oski_index_t* restrict bptr, const oski_index_t* restrict bind,
	const oski_value_t* restrict bval, const oski_value_t* restrict bdiag,
	oski_value_t alpha, const oski_value_t* restrict x, oski_index_t incx,
	oski_value_t* restrict y )
{
	oski_value_t* yp = y + d0;
	const oski_value_t* xp = x + d0*incx;
	oski_index_t I;

	for( I = 0; I < M; I++, yp += 3, xp += 3*incx )
	{
		REGISTER oski_value_t _y0;
		REGISTER oski_value_t _y1;
		REGISTER oski_value_t _y2;
		REGISTER oski_value_t _x0;
		REGISTER oski_value_t _x1;
		REGISTER oski_value_t _x2;
		oski_index_t K;

		VAL_SET_ZERO( _y0 );
		VAL_SET_ZERO( _y1 );
		VAL_SET_ZERO( _y2 );
		VAL_MUL( _x0, alpha, xp[0] );
		VAL_MUL( _x1, alpha, xp[1*incx] );
		VAL_MUL( _x2, alpha, xp[2*incx] );

		for( K = bptr[I]; K < bptr[I+1]; K++, bind++, bval += 3*7 )
		{
			oski_index_t j0 = bind[0]; /* block's leftmost col index */
			const oski_value_t* xpp = x + j0*incx;
			oski_value_t* ypp = y + j0;

			REGISTER oski_value_t _xp0;
			REGISTER oski_value_t _xp1;
			REGISTER oski_value_t _xp2;
			REGISTER oski_value_t _xp3;
			REGISTER oski_value_t _xp4;
			REGISTER oski_value_t _xp5;
			REGISTER oski_value_t _xp6;
			REGISTER oski_value_t _yp0;
			REGISTER oski_value_t _yp1;
			REGISTER oski_value_t _yp2;
			REGISTER oski_value_t _yp3;
			REGISTER oski_value_t _yp4;
			REGISTER oski_value_t _yp5;
			REGISTER oski_value_t _yp6;
			VAL_SET_ZERO( _yp0 );
			VAL_SET_ZERO( _yp1 );
			VAL_SET_ZERO( _yp2 );
			VAL_SET_ZERO( _yp3 );
			VAL_SET_ZERO( _yp4 );
			VAL_SET_ZERO( _yp5 );
			VAL_SET_ZERO( _yp6 );
			VAL_ASSIGN( _xp0, xpp[0] );
			VAL_ASSIGN( _xp1, xpp[1*incx] );
			VAL_ASSIGN( _xp2, xpp[2*incx] );
			VAL_ASSIGN( _xp3, xpp[3*incx] );
			VAL_ASSIGN( _xp4, xpp[4*incx] );
			VAL_ASSIGN( _xp5, xpp[5*incx] );
			VAL_ASSIGN( _xp6, xpp[6*incx] );
			VAL_MAC_CONJ( _yp0, bval[0], _x0 );
			VAL_MAC_CONJ( _yp1, bval[1], _x0 );
			VAL_MAC_CONJ( _yp2, bval[2], _x0 );
			VAL_MAC_CONJ( _yp3, bval[3], _x0 );
			VAL_MAC_CONJ( _yp4, bval[4], _x0 );
			VAL_MAC_CONJ( _yp5, bval[5], _x0 );
			VAL_MAC_CONJ( _yp6, bval[6], _x0 );
			VAL_MAC_CONJ( _yp0, bval[7], _x1 );
			VAL_MAC_CONJ( _yp1, bval[8], _x1 );
			VAL_MAC_CONJ( _yp2, bval[9], _x1 );
			VAL_MAC_CONJ( _yp3, bval[10], _x1 );
			VAL_MAC_CONJ( _yp4, bval[11], _x1 );
			VAL_MAC_CONJ( _yp5, bval[12], _x1 );
			VAL_MAC_CONJ( _yp6, bval[13], _x1 );
			VAL_MAC_CONJ( _yp0, bval[14], _x2 );
			VAL_MAC_CONJ( _yp1, bval[15], _x2 );
			VAL_MAC_CONJ( _yp2, bval[16], _x2 );
			VAL_MAC_CONJ( _yp3, bval[17], _x2 );
			VAL_MAC_CONJ( _yp4, bval[18], _x2 );
			VAL_MAC_CONJ( _yp5, bval[19], _x2 );
			VAL_MAC_CONJ( _yp6, bval[20], _x2 );
			VAL_MAC_CONJ( _y0, bval[0], _xp0 );
			VAL_MAC_CONJ( _y1, bval[7], _xp0 );
			VAL_MAC_CONJ( _y2, bval[14], _xp0 );
			VAL_MAC_CONJ( _y0, bval[1], _xp1 );
			VAL_MAC_CONJ( _y1, bval[8], _xp1 );
			VAL_MAC_CONJ( _y2, bval[15], _xp1 );
			VAL_MAC_CONJ( _y0, bval[2], _xp2 );
			VAL_MAC_CONJ( _y1, bval[9], _xp2 );
			VAL_MAC_CONJ( _y2, bval[16], _xp2 );
			VAL_MAC_CONJ( _y0, bval[3], _xp3 );
			VAL_MAC_CONJ( _y1, bval[10], _xp3 );
			VAL_MAC_CONJ( _y2, bval[17], _xp3 );
			VAL_MAC_CONJ( _y0, bval[4], _xp4 );
			VAL_MAC_CONJ( _y1, bval[11], _xp4 );
			VAL_MAC_CONJ( _y2, bval[18], _xp4 );
			VAL_MAC_CONJ( _y0, bval[5], _xp5 );
			VAL_MAC_CONJ( _y1, bval[12], _xp5 );
			VAL_MAC_CONJ( _y2, bval[19], _xp5 );
			VAL_MAC_CONJ( _y0, bval[6], _xp6 );
			VAL_MAC_CONJ( _y1, bval[13], _xp6 );
			VAL_MAC_CONJ( _y2, bval[20], _xp6 );
			VAL_INC( ypp[0], _yp0 );
			VAL_INC( ypp[1], _yp1 );
			VAL_INC( ypp[2], _yp2 );
			VAL_INC( ypp[3], _yp3 );
			VAL_INC( ypp[4], _yp4 );
			VAL_INC( ypp[5], _yp5 );
			VAL_INC( ypp[6], _yp6 );
		}
		VAL_MAC( yp[0], alpha, _y0 );
		VAL_MAC( yp[1], alpha, _y1 );
		VAL_MAC( yp[2], alpha, _y2 );
	}
	/* Diagonal block multiply */
	yp = y + d0;
	xp = x + d0*incx;
	for( I = 0; I < M; I++, bdiag += 3*3, yp += 3, xp += 3*incx )
	{
		REGISTER oski_value_t _x0;
		REGISTER oski_value_t _x1;
		REGISTER oski_value_t _x2;
		REGISTER oski_value_t _y0;
		REGISTER oski_value_t _y1;
		REGISTER oski_value_t _y2;
		VAL_ASSIGN( _x0, xp[0] );
		VAL_ASSIGN( _x1, xp[1*incx] );
		VAL_ASSIGN( _x2, xp[2*incx] );
		VAL_SET_ZERO( _y0 );
		VAL_SET_ZERO( _y1 );
		VAL_SET_ZERO( _y2 );
		VAL_MAC_CONJ( _y0, bdiag[0], _x0 );
		VAL_MAC_CONJ( _y1, bdiag[3], _x0 );
		VAL_MAC_CONJ( _y2, bdiag[6], _x0 );
		VAL_MAC_CONJ( _y0, bdiag[1], _x1 );
		VAL_MAC_CONJ( _y1, bdiag[4], _x1 );
		VAL_MAC_CONJ( _y2, bdiag[7], _x1 );
		VAL_MAC_CONJ( _y0, bdiag[2], _x2 );
		VAL_MAC_CONJ( _y1, bdiag[5], _x2 );
		VAL_MAC_CONJ( _y2, bdiag[8], _x2 );
		VAL_MAC( yp[0], alpha, _y0 );
		VAL_MAC( yp[1], alpha, _y1 );
		VAL_MAC( yp[2], alpha, _y2 );
	}
}


#endif /* !IS_VAL_COMPLEX */


#if !IS_VAL_COMPLEX

#if defined(DO_NAME_MANGLING)
/** See MBCSR_SymmMatMult_v1_aX_b1_xsX_ysX(). */
#define MBCSR_SymmMatConjMult_v1_aX_b1_xsX_ysX MBCSR_SymmMatMult_v1_aX_b1_xsX_ysX
#endif

#else /* IS_VAL_COMPLEX */



#if defined(DO_NAME_MANGLING)
/** Mangled name for MBCSR_SymmMatConjMult_v1_aX_b1_xsX_ysX */
#define MBCSR_SymmMatConjMult_v1_aX_b1_xsX_ysX MANGLE_MOD_(MBCSR_SymmMatConjMult_v1_aX_b1_xsX_ysX_3x7)
#endif

/**
 *  \brief MBCSR implementation of
 *  \f$y \leftarrow y + \alpha\cdot \bar{A}\cdot x\f$.
 */
void
MBCSR_SymmMatConjMult_v1_aX_b1_xsX_ysX( oski_index_t M, oski_index_t d0,
	const oski_index_t* restrict bptr, const oski_index_t* restrict bind,
	const oski_value_t* restrict bval, const oski_value_t* restrict bdiag,
	oski_value_t alpha, const oski_value_t* restrict x, oski_index_t incx,
	oski_value_t* restrict y, oski_index_t incy )
{
	oski_value_t* yp = y + d0*incy;
	const oski_value_t* xp = x + d0*incx;
	oski_index_t I;

	for( I = 0; I < M; I++, yp += 3*incy, xp += 3*incx )
	{
		REGISTER oski_value_t _y0;
		REGISTER oski_value_t _y1;
		REGISTER oski_value_t _y2;
		REGISTER oski_value_t _x0;
		REGISTER oski_value_t _x1;
		REGISTER oski_value_t _x2;
		oski_index_t K;

		VAL_SET_ZERO( _y0 );
		VAL_SET_ZERO( _y1 );
		VAL_SET_ZERO( _y2 );
		VAL_MUL( _x0, alpha, xp[0] );
		VAL_MUL( _x1, alpha, xp[1*incx] );
		VAL_MUL( _x2, alpha, xp[2*incx] );

		for( K = bptr[I]; K < bptr[I+1]; K++, bind++, bval += 3*7 )
		{
			oski_index_t j0 = bind[0]; /* block's leftmost col index */
			const oski_value_t* xpp = x + j0*incx;
			oski_value_t* ypp = y + j0*incy;

			REGISTER oski_value_t _xp0;
			REGISTER oski_value_t _xp1;
			REGISTER oski_value_t _xp2;
			REGISTER oski_value_t _xp3;
			REGISTER oski_value_t _xp4;
			REGISTER oski_value_t _xp5;
			REGISTER oski_value_t _xp6;
			REGISTER oski_value_t _yp0;
			REGISTER oski_value_t _yp1;
			REGISTER oski_value_t _yp2;
			REGISTER oski_value_t _yp3;
			REGISTER oski_value_t _yp4;
			REGISTER oski_value_t _yp5;
			REGISTER oski_value_t _yp6;
			VAL_SET_ZERO( _yp0 );
			VAL_SET_ZERO( _yp1 );
			VAL_SET_ZERO( _yp2 );
			VAL_SET_ZERO( _yp3 );
			VAL_SET_ZERO( _yp4 );
			VAL_SET_ZERO( _yp5 );
			VAL_SET_ZERO( _yp6 );
			VAL_ASSIGN( _xp0, xpp[0] );
			VAL_ASSIGN( _xp1, xpp[1*incx] );
			VAL_ASSIGN( _xp2, xpp[2*incx] );
			VAL_ASSIGN( _xp3, xpp[3*incx] );
			VAL_ASSIGN( _xp4, xpp[4*incx] );
			VAL_ASSIGN( _xp5, xpp[5*incx] );
			VAL_ASSIGN( _xp6, xpp[6*incx] );
			VAL_MAC_CONJ( _yp0, bval[0], _x0 );
			VAL_MAC_CONJ( _yp1, bval[1], _x0 );
			VAL_MAC_CONJ( _yp2, bval[2], _x0 );
			VAL_MAC_CONJ( _yp3, bval[3], _x0 );
			VAL_MAC_CONJ( _yp4, bval[4], _x0 );
			VAL_MAC_CONJ( _yp5, bval[5], _x0 );
			VAL_MAC_CONJ( _yp6, bval[6], _x0 );
			VAL_MAC_CONJ( _yp0, bval[7], _x1 );
			VAL_MAC_CONJ( _yp1, bval[8], _x1 );
			VAL_MAC_CONJ( _yp2, bval[9], _x1 );
			VAL_MAC_CONJ( _yp3, bval[10], _x1 );
			VAL_MAC_CONJ( _yp4, bval[11], _x1 );
			VAL_MAC_CONJ( _yp5, bval[12], _x1 );
			VAL_MAC_CONJ( _yp6, bval[13], _x1 );
			VAL_MAC_CONJ( _yp0, bval[14], _x2 );
			VAL_MAC_CONJ( _yp1, bval[15], _x2 );
			VAL_MAC_CONJ( _yp2, bval[16], _x2 );
			VAL_MAC_CONJ( _yp3, bval[17], _x2 );
			VAL_MAC_CONJ( _yp4, bval[18], _x2 );
			VAL_MAC_CONJ( _yp5, bval[19], _x2 );
			VAL_MAC_CONJ( _yp6, bval[20], _x2 );
			VAL_MAC_CONJ( _y0, bval[0], _xp0 );
			VAL_MAC_CONJ( _y1, bval[7], _xp0 );
			VAL_MAC_CONJ( _y2, bval[14], _xp0 );
			VAL_MAC_CONJ( _y0, bval[1], _xp1 );
			VAL_MAC_CONJ( _y1, bval[8], _xp1 );
			VAL_MAC_CONJ( _y2, bval[15], _xp1 );
			VAL_MAC_CONJ( _y0, bval[2], _xp2 );
			VAL_MAC_CONJ( _y1, bval[9], _xp2 );
			VAL_MAC_CONJ( _y2, bval[16], _xp2 );
			VAL_MAC_CONJ( _y0, bval[3], _xp3 );
			VAL_MAC_CONJ( _y1, bval[10], _xp3 );
			VAL_MAC_CONJ( _y2, bval[17], _xp3 );
			VAL_MAC_CONJ( _y0, bval[4], _xp4 );
			VAL_MAC_CONJ( _y1, bval[11], _xp4 );
			VAL_MAC_CONJ( _y2, bval[18], _xp4 );
			VAL_MAC_CONJ( _y0, bval[5], _xp5 );
			VAL_MAC_CONJ( _y1, bval[12], _xp5 );
			VAL_MAC_CONJ( _y2, bval[19], _xp5 );
			VAL_MAC_CONJ( _y0, bval[6], _xp6 );
			VAL_MAC_CONJ( _y1, bval[13], _xp6 );
			VAL_MAC_CONJ( _y2, bval[20], _xp6 );
			VAL_INC( ypp[0], _yp0 );
			VAL_INC( ypp[1*incy], _yp1 );
			VAL_INC( ypp[2*incy], _yp2 );
			VAL_INC( ypp[3*incy], _yp3 );
			VAL_INC( ypp[4*incy], _yp4 );
			VAL_INC( ypp[5*incy], _yp5 );
			VAL_INC( ypp[6*incy], _yp6 );
		}
		VAL_MAC( yp[0], alpha, _y0 );
		VAL_MAC( yp[1*incy], alpha, _y1 );
		VAL_MAC( yp[2*incy], alpha, _y2 );
	}
	/* Diagonal block multiply */
	yp = y + d0*incy;
	xp = x + d0*incx;
	for( I = 0; I < M; I++, bdiag += 3*3, yp += 3*incy, xp += 3*incx )
	{
		REGISTER oski_value_t _x0;
		REGISTER oski_value_t _x1;
		REGISTER oski_value_t _x2;
		REGISTER oski_value_t _y0;
		REGISTER oski_value_t _y1;
		REGISTER oski_value_t _y2;
		VAL_ASSIGN( _x0, xp[0] );
		VAL_ASSIGN( _x1, xp[1*incx] );
		VAL_ASSIGN( _x2, xp[2*incx] );
		VAL_SET_ZERO( _y0 );
		VAL_SET_ZERO( _y1 );
		VAL_SET_ZERO( _y2 );
		VAL_MAC_CONJ( _y0, bdiag[0], _x0 );
		VAL_MAC_CONJ( _y1, bdiag[3], _x0 );
		VAL_MAC_CONJ( _y2, bdiag[6], _x0 );
		VAL_MAC_CONJ( _y0, bdiag[1], _x1 );
		VAL_MAC_CONJ( _y1, bdiag[4], _x1 );
		VAL_MAC_CONJ( _y2, bdiag[7], _x1 );
		VAL_MAC_CONJ( _y0, bdiag[2], _x2 );
		VAL_MAC_CONJ( _y1, bdiag[5], _x2 );
		VAL_MAC_CONJ( _y2, bdiag[8], _x2 );
		VAL_MAC( yp[0], alpha, _y0 );
		VAL_MAC( yp[1*incy], alpha, _y1 );
		VAL_MAC( yp[2*incy], alpha, _y2 );
	}
}


#endif /* !IS_VAL_COMPLEX */


#if !IS_VAL_COMPLEX
/**
 *  \brief Matrix times single-vector multiply in the conj case;
 *  see SymmMatMult_v1().
 */
#define SymmMatConjMult_v1 SymmMatMult_v1

#else /* IS_VAL_COMPLEX */


/**
 *  \brief Symmetric matrix times single-vector multiply in the conj case.
 */
static void
SymmMatConjMult_v1( oski_index_t M, oski_index_t d0,
	const oski_index_t* bptr, const oski_index_t* bind,
	const oski_value_t* bval, const oski_value_t* bdiag,
	oski_value_t alpha, const oski_value_t* x, oski_index_t incx,
	oski_value_t* y, oski_index_t incy )
{
	if( incx == 1 ) {
		if( incy == 1 ) {
			MBCSR_SymmMatConjMult_v1_aX_b1_xs1_ys1( M, d0,
				bptr, bind, bval, bdiag, alpha, x, y );
		} else { /* general incy */
			MBCSR_SymmMatConjMult_v1_aX_b1_xs1_ysX( M, d0,
				bptr, bind, bval, bdiag, alpha, x, y, incy );
		}
	} else { /* general incx */
		if( incy == 1 ) {
			MBCSR_SymmMatConjMult_v1_aX_b1_xsX_ys1( M, d0,
				bptr, bind, bval, bdiag, alpha, x, incx, y );
		} else { /* general incy */
			MBCSR_SymmMatConjMult_v1_aX_b1_xsX_ysX( M, d0,
				bptr, bind, bval, bdiag, alpha, x, incx, y, incy );
		}
	}
}


#endif /* !IS_VAL_COMPLEX */


#if !IS_VAL_COMPLEX
/**
 *  \brief See SymmMatMult().
 */
#define SymmMatConjMult SymmMatMult

#else /* IS_VAL_COMPLEX */



/**
 *  \brief Computes
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$\mathrm{op}(A) = \bar{A}\f$, on the fully blocked
 *  portion of \f$A\f$.
 */
static int
SymmMatConjMult( const oski_submatMBCSR_t* A,
	oski_value_t alpha, const oski_vecview_t x_view,
	oski_vecview_t y_view )
{
	oski_index_t j; /* column number */
	const oski_value_t* xpj; /* X(:, j) */
	oski_value_t* ypj; /* Y(:, j) */

	assert( A->r == 3 );
	assert( A->c == 7 );

	for( j = 0, xpj = x_view->val, ypj = y_view->val;
		j < x_view->num_cols;
		j++, xpj += x_view->colinc, ypj += y_view->colinc )
	{
		SymmMatConjMult_v1( A->num_block_rows, A->offset,
			A->bptr, A->bind, A->bval, A->bdiag,
			alpha, xpj, x_view->rowinc, ypj, y_view->rowinc );
	}

	return 0;
}


#endif /* !IS_VAL_COMPLEX */


#if !IS_VAL_COMPLEX

#if defined(DO_NAME_MANGLING)
/** See MBCSR_SymmMatMult_v1_aX_b1_xs1_ys1(). */
#define MBCSR_HermMatMult_v1_aX_b1_xs1_ys1 MBCSR_SymmMatMult_v1_aX_b1_xs1_ys1
#endif

#else /* IS_VAL_COMPLEX */



#if defined(DO_NAME_MANGLING)
/** Mangled name for MBCSR_HermMatMult_v1_aX_b1_xs1_ys1 */
#define MBCSR_HermMatMult_v1_aX_b1_xs1_ys1 MANGLE_MOD_(MBCSR_HermMatMult_v1_aX_b1_xs1_ys1_3x7)
#endif

/**
 *  \brief MBCSR implementation of
 *  \f$y \leftarrow y + \alpha\cdot A\cdot x\f$.
 */
void
MBCSR_HermMatMult_v1_aX_b1_xs1_ys1( oski_index_t M, oski_index_t d0,
	const oski_index_t* restrict bptr, const oski_index_t* restrict bind,
	const oski_value_t* restrict bval, const oski_value_t* restrict bdiag,
	oski_value_t alpha, const oski_value_t* restrict x,
	oski_value_t* restrict y )
{
	oski_value_t* yp = y + d0;
	const oski_value_t* xp = x + d0;
	oski_index_t I;

	for( I = 0; I < M; I++, yp += 3, xp += 3 )
	{
		REGISTER oski_value_t _y0;
		REGISTER oski_value_t _y1;
		REGISTER oski_value_t _y2;
		REGISTER oski_value_t _x0;
		REGISTER oski_value_t _x1;
		REGISTER oski_value_t _x2;
		oski_index_t K;

		VAL_SET_ZERO( _y0 );
		VAL_SET_ZERO( _y1 );
		VAL_SET_ZERO( _y2 );
		VAL_MUL( _x0, alpha, xp[0] );
		VAL_MUL( _x1, alpha, xp[1] );
		VAL_MUL( _x2, alpha, xp[2] );

		for( K = bptr[I]; K < bptr[I+1]; K++, bind++, bval += 3*7 )
		{
			oski_index_t j0 = bind[0]; /* block's leftmost col index */
			const oski_value_t* xpp = x + j0;
			oski_value_t* ypp = y + j0;

			REGISTER oski_value_t _xp0;
			REGISTER oski_value_t _xp1;
			REGISTER oski_value_t _xp2;
			REGISTER oski_value_t _xp3;
			REGISTER oski_value_t _xp4;
			REGISTER oski_value_t _xp5;
			REGISTER oski_value_t _xp6;
			REGISTER oski_value_t _yp0;
			REGISTER oski_value_t _yp1;
			REGISTER oski_value_t _yp2;
			REGISTER oski_value_t _yp3;
			REGISTER oski_value_t _yp4;
			REGISTER oski_value_t _yp5;
			REGISTER oski_value_t _yp6;
			VAL_SET_ZERO( _yp0 );
			VAL_SET_ZERO( _yp1 );
			VAL_SET_ZERO( _yp2 );
			VAL_SET_ZERO( _yp3 );
			VAL_SET_ZERO( _yp4 );
			VAL_SET_ZERO( _yp5 );
			VAL_SET_ZERO( _yp6 );
			VAL_ASSIGN( _xp0, xpp[0] );
			VAL_ASSIGN( _xp1, xpp[1] );
			VAL_ASSIGN( _xp2, xpp[2] );
			VAL_ASSIGN( _xp3, xpp[3] );
			VAL_ASSIGN( _xp4, xpp[4] );
			VAL_ASSIGN( _xp5, xpp[5] );
			VAL_ASSIGN( _xp6, xpp[6] );
			VAL_MAC_CONJ( _yp0, bval[0], _x0 );
			VAL_MAC_CONJ( _yp1, bval[1], _x0 );
			VAL_MAC_CONJ( _yp2, bval[2], _x0 );
			VAL_MAC_CONJ( _yp3, bval[3], _x0 );
			VAL_MAC_CONJ( _yp4, bval[4], _x0 );
			VAL_MAC_CONJ( _yp5, bval[5], _x0 );
			VAL_MAC_CONJ( _yp6, bval[6], _x0 );
			VAL_MAC_CONJ( _yp0, bval[7], _x1 );
			VAL_MAC_CONJ( _yp1, bval[8], _x1 );
			VAL_MAC_CONJ( _yp2, bval[9], _x1 );
			VAL_MAC_CONJ( _yp3, bval[10], _x1 );
			VAL_MAC_CONJ( _yp4, bval[11], _x1 );
			VAL_MAC_CONJ( _yp5, bval[12], _x1 );
			VAL_MAC_CONJ( _yp6, bval[13], _x1 );
			VAL_MAC_CONJ( _yp0, bval[14], _x2 );
			VAL_MAC_CONJ( _yp1, bval[15], _x2 );
			VAL_MAC_CONJ( _yp2, bval[16], _x2 );
			VAL_MAC_CONJ( _yp3, bval[17], _x2 );
			VAL_MAC_CONJ( _yp4, bval[18], _x2 );
			VAL_MAC_CONJ( _yp5, bval[19], _x2 );
			VAL_MAC_CONJ( _yp6, bval[20], _x2 );
			VAL_MAC( _y0, bval[0], _xp0 );
			VAL_MAC( _y1, bval[7], _xp0 );
			VAL_MAC( _y2, bval[14], _xp0 );
			VAL_MAC( _y0, bval[1], _xp1 );
			VAL_MAC( _y1, bval[8], _xp1 );
			VAL_MAC( _y2, bval[15], _xp1 );
			VAL_MAC( _y0, bval[2], _xp2 );
			VAL_MAC( _y1, bval[9], _xp2 );
			VAL_MAC( _y2, bval[16], _xp2 );
			VAL_MAC( _y0, bval[3], _xp3 );
			VAL_MAC( _y1, bval[10], _xp3 );
			VAL_MAC( _y2, bval[17], _xp3 );
			VAL_MAC( _y0, bval[4], _xp4 );
			VAL_MAC( _y1, bval[11], _xp4 );
			VAL_MAC( _y2, bval[18], _xp4 );
			VAL_MAC( _y0, bval[5], _xp5 );
			VAL_MAC( _y1, bval[12], _xp5 );
			VAL_MAC( _y2, bval[19], _xp5 );
			VAL_MAC( _y0, bval[6], _xp6 );
			VAL_MAC( _y1, bval[13], _xp6 );
			VAL_MAC( _y2, bval[20], _xp6 );
			VAL_INC( ypp[0], _yp0 );
			VAL_INC( ypp[1], _yp1 );
			VAL_INC( ypp[2], _yp2 );
			VAL_INC( ypp[3], _yp3 );
			VAL_INC( ypp[4], _yp4 );
			VAL_INC( ypp[5], _yp5 );
			VAL_INC( ypp[6], _yp6 );
		}
		VAL_MAC( yp[0], alpha, _y0 );
		VAL_MAC( yp[1], alpha, _y1 );
		VAL_MAC( yp[2], alpha, _y2 );
	}
	/* Diagonal block multiply */
	yp = y + d0;
	xp = x + d0;
	for( I = 0; I < M; I++, bdiag += 3*3, yp += 3, xp += 3 )
	{
		REGISTER oski_value_t _x0;
		REGISTER oski_value_t _x1;
		REGISTER oski_value_t _x2;
		REGISTER oski_value_t _y0;
		REGISTER oski_value_t _y1;
		REGISTER oski_value_t _y2;
		VAL_ASSIGN( _x0, xp[0] );
		VAL_ASSIGN( _x1, xp[1] );
		VAL_ASSIGN( _x2, xp[2] );
		VAL_SET_ZERO( _y0 );
		VAL_SET_ZERO( _y1 );
		VAL_SET_ZERO( _y2 );
		VAL_MAC( _y0, bdiag[0], _x0 );
		VAL_MAC( _y1, bdiag[3], _x0 );
		VAL_MAC( _y2, bdiag[6], _x0 );
		VAL_MAC( _y0, bdiag[1], _x1 );
		VAL_MAC( _y1, bdiag[4], _x1 );
		VAL_MAC( _y2, bdiag[7], _x1 );
		VAL_MAC( _y0, bdiag[2], _x2 );
		VAL_MAC( _y1, bdiag[5], _x2 );
		VAL_MAC( _y2, bdiag[8], _x2 );
		VAL_MAC( yp[0], alpha, _y0 );
		VAL_MAC( yp[1], alpha, _y1 );
		VAL_MAC( yp[2], alpha, _y2 );
	}
}


#endif /* !IS_VAL_COMPLEX */


#if !IS_VAL_COMPLEX

#if defined(DO_NAME_MANGLING)
/** See MBCSR_SymmMatMult_v1_aX_b1_xs1_ysX(). */
#define MBCSR_HermMatMult_v1_aX_b1_xs1_ysX MBCSR_SymmMatMult_v1_aX_b1_xs1_ysX
#endif

#else /* IS_VAL_COMPLEX */



#if defined(DO_NAME_MANGLING)
/** Mangled name for MBCSR_HermMatMult_v1_aX_b1_xs1_ysX */
#define MBCSR_HermMatMult_v1_aX_b1_xs1_ysX MANGLE_MOD_(MBCSR_HermMatMult_v1_aX_b1_xs1_ysX_3x7)
#endif

/**
 *  \brief MBCSR implementation of
 *  \f$y \leftarrow y + \alpha\cdot A\cdot x\f$.
 */
void
MBCSR_HermMatMult_v1_aX_b1_xs1_ysX( oski_index_t M, oski_index_t d0,
	const oski_index_t* restrict bptr, const oski_index_t* restrict bind,
	const oski_value_t* restrict bval, const oski_value_t* restrict bdiag,
	oski_value_t alpha, const oski_value_t* restrict x,
	oski_value_t* restrict y, oski_index_t incy )
{
	oski_value_t* yp = y + d0*incy;
	const oski_value_t* xp = x + d0;
	oski_index_t I;

	for( I = 0; I < M; I++, yp += 3*incy, xp += 3 )
	{
		REGISTER oski_value_t _y0;
		REGISTER oski_value_t _y1;
		REGISTER oski_value_t _y2;
		REGISTER oski_value_t _x0;
		REGISTER oski_value_t _x1;
		REGISTER oski_value_t _x2;
		oski_index_t K;

		VAL_SET_ZERO( _y0 );
		VAL_SET_ZERO( _y1 );
		VAL_SET_ZERO( _y2 );
		VAL_MUL( _x0, alpha, xp[0] );
		VAL_MUL( _x1, alpha, xp[1] );
		VAL_MUL( _x2, alpha, xp[2] );

		for( K = bptr[I]; K < bptr[I+1]; K++, bind++, bval += 3*7 )
		{
			oski_index_t j0 = bind[0]; /* block's leftmost col index */
			const oski_value_t* xpp = x + j0;
			oski_value_t* ypp = y + j0*incy;

			REGISTER oski_value_t _xp0;
			REGISTER oski_value_t _xp1;
			REGISTER oski_value_t _xp2;
			REGISTER oski_value_t _xp3;
			REGISTER oski_value_t _xp4;
			REGISTER oski_value_t _xp5;
			REGISTER oski_value_t _xp6;
			REGISTER oski_value_t _yp0;
			REGISTER oski_value_t _yp1;
			REGISTER oski_value_t _yp2;
			REGISTER oski_value_t _yp3;
			REGISTER oski_value_t _yp4;
			REGISTER oski_value_t _yp5;
			REGISTER oski_value_t _yp6;
			VAL_SET_ZERO( _yp0 );
			VAL_SET_ZERO( _yp1 );
			VAL_SET_ZERO( _yp2 );
			VAL_SET_ZERO( _yp3 );
			VAL_SET_ZERO( _yp4 );
			VAL_SET_ZERO( _yp5 );
			VAL_SET_ZERO( _yp6 );
			VAL_ASSIGN( _xp0, xpp[0] );
			VAL_ASSIGN( _xp1, xpp[1] );
			VAL_ASSIGN( _xp2, xpp[2] );
			VAL_ASSIGN( _xp3, xpp[3] );
			VAL_ASSIGN( _xp4, xpp[4] );
			VAL_ASSIGN( _xp5, xpp[5] );
			VAL_ASSIGN( _xp6, xpp[6] );
			VAL_MAC_CONJ( _yp0, bval[0], _x0 );
			VAL_MAC_CONJ( _yp1, bval[1], _x0 );
			VAL_MAC_CONJ( _yp2, bval[2], _x0 );
			VAL_MAC_CONJ( _yp3, bval[3], _x0 );
			VAL_MAC_CONJ( _yp4, bval[4], _x0 );
			VAL_MAC_CONJ( _yp5, bval[5], _x0 );
			VAL_MAC_CONJ( _yp6, bval[6], _x0 );
			VAL_MAC_CONJ( _yp0, bval[7], _x1 );
			VAL_MAC_CONJ( _yp1, bval[8], _x1 );
			VAL_MAC_CONJ( _yp2, bval[9], _x1 );
			VAL_MAC_CONJ( _yp3, bval[10], _x1 );
			VAL_MAC_CONJ( _yp4, bval[11], _x1 );
			VAL_MAC_CONJ( _yp5, bval[12], _x1 );
			VAL_MAC_CONJ( _yp6, bval[13], _x1 );
			VAL_MAC_CONJ( _yp0, bval[14], _x2 );
			VAL_MAC_CONJ( _yp1, bval[15], _x2 );
			VAL_MAC_CONJ( _yp2, bval[16], _x2 );
			VAL_MAC_CONJ( _yp3, bval[17], _x2 );
			VAL_MAC_CONJ( _yp4, bval[18], _x2 );
			VAL_MAC_CONJ( _yp5, bval[19], _x2 );
			VAL_MAC_CONJ( _yp6, bval[20], _x2 );
			VAL_MAC( _y0, bval[0], _xp0 );
			VAL_MAC( _y1, bval[7], _xp0 );
			VAL_MAC( _y2, bval[14], _xp0 );
			VAL_MAC( _y0, bval[1], _xp1 );
			VAL_MAC( _y1, bval[8], _xp1 );
			VAL_MAC( _y2, bval[15], _xp1 );
			VAL_MAC( _y0, bval[2], _xp2 );
			VAL_MAC( _y1, bval[9], _xp2 );
			VAL_MAC( _y2, bval[16], _xp2 );
			VAL_MAC( _y0, bval[3], _xp3 );
			VAL_MAC( _y1, bval[10], _xp3 );
			VAL_MAC( _y2, bval[17], _xp3 );
			VAL_MAC( _y0, bval[4], _xp4 );
			VAL_MAC( _y1, bval[11], _xp4 );
			VAL_MAC( _y2, bval[18], _xp4 );
			VAL_MAC( _y0, bval[5], _xp5 );
			VAL_MAC( _y1, bval[12], _xp5 );
			VAL_MAC( _y2, bval[19], _xp5 );
			VAL_MAC( _y0, bval[6], _xp6 );
			VAL_MAC( _y1, bval[13], _xp6 );
			VAL_MAC( _y2, bval[20], _xp6 );
			VAL_INC( ypp[0], _yp0 );
			VAL_INC( ypp[1*incy], _yp1 );
			VAL_INC( ypp[2*incy], _yp2 );
			VAL_INC( ypp[3*incy], _yp3 );
			VAL_INC( ypp[4*incy], _yp4 );
			VAL_INC( ypp[5*incy], _yp5 );
			VAL_INC( ypp[6*incy], _yp6 );
		}
		VAL_MAC( yp[0], alpha, _y0 );
		VAL_MAC( yp[1*incy], alpha, _y1 );
		VAL_MAC( yp[2*incy], alpha, _y2 );
	}
	/* Diagonal block multiply */
	yp = y + d0*incy;
	xp = x + d0;
	for( I = 0; I < M; I++, bdiag += 3*3, yp += 3*incy, xp += 3 )
	{
		REGISTER oski_value_t _x0;
		REGISTER oski_value_t _x1;
		REGISTER oski_value_t _x2;
		REGISTER oski_value_t _y0;
		REGISTER oski_value_t _y1;
		REGISTER oski_value_t _y2;
		VAL_ASSIGN( _x0, xp[0] );
		VAL_ASSIGN( _x1, xp[1] );
		VAL_ASSIGN( _x2, xp[2] );
		VAL_SET_ZERO( _y0 );
		VAL_SET_ZERO( _y1 );
		VAL_SET_ZERO( _y2 );
		VAL_MAC( _y0, bdiag[0], _x0 );
		VAL_MAC( _y1, bdiag[3], _x0 );
		VAL_MAC( _y2, bdiag[6], _x0 );
		VAL_MAC( _y0, bdiag[1], _x1 );
		VAL_MAC( _y1, bdiag[4], _x1 );
		VAL_MAC( _y2, bdiag[7], _x1 );
		VAL_MAC( _y0, bdiag[2], _x2 );
		VAL_MAC( _y1, bdiag[5], _x2 );
		VAL_MAC( _y2, bdiag[8], _x2 );
		VAL_MAC( yp[0], alpha, _y0 );
		VAL_MAC( yp[1*incy], alpha, _y1 );
		VAL_MAC( yp[2*incy], alpha, _y2 );
	}
}


#endif /* !IS_VAL_COMPLEX */


#if !IS_VAL_COMPLEX

#if defined(DO_NAME_MANGLING)
/** See MBCSR_SymmMatMult_v1_aX_b1_xsX_ys1(). */
#define MBCSR_HermMatMult_v1_aX_b1_xsX_ys1 MBCSR_SymmMatMult_v1_aX_b1_xsX_ys1
#endif

#else /* IS_VAL_COMPLEX */



#if defined(DO_NAME_MANGLING)
/** Mangled name for MBCSR_HermMatMult_v1_aX_b1_xsX_ys1 */
#define MBCSR_HermMatMult_v1_aX_b1_xsX_ys1 MANGLE_MOD_(MBCSR_HermMatMult_v1_aX_b1_xsX_ys1_3x7)
#endif

/**
 *  \brief MBCSR implementation of
 *  \f$y \leftarrow y + \alpha\cdot A\cdot x\f$.
 */
void
MBCSR_HermMatMult_v1_aX_b1_xsX_ys1( oski_index_t M, oski_index_t d0,
	const oski_index_t* restrict bptr, const oski_index_t* restrict bind,
	const oski_value_t* restrict bval, const oski_value_t* restrict bdiag,
	oski_value_t alpha, const oski_value_t* restrict x, oski_index_t incx,
	oski_value_t* restrict y )
{
	oski_value_t* yp = y + d0;
	const oski_value_t* xp = x + d0*incx;
	oski_index_t I;

	for( I = 0; I < M; I++, yp += 3, xp += 3*incx )
	{
		REGISTER oski_value_t _y0;
		REGISTER oski_value_t _y1;
		REGISTER oski_value_t _y2;
		REGISTER oski_value_t _x0;
		REGISTER oski_value_t _x1;
		REGISTER oski_value_t _x2;
		oski_index_t K;

		VAL_SET_ZERO( _y0 );
		VAL_SET_ZERO( _y1 );
		VAL_SET_ZERO( _y2 );
		VAL_MUL( _x0, alpha, xp[0] );
		VAL_MUL( _x1, alpha, xp[1*incx] );
		VAL_MUL( _x2, alpha, xp[2*incx] );

		for( K = bptr[I]; K < bptr[I+1]; K++, bind++, bval += 3*7 )
		{
			oski_index_t j0 = bind[0]; /* block's leftmost col index */
			const oski_value_t* xpp = x + j0*incx;
			oski_value_t* ypp = y + j0;

			REGISTER oski_value_t _xp0;
			REGISTER oski_value_t _xp1;
			REGISTER oski_value_t _xp2;
			REGISTER oski_value_t _xp3;
			REGISTER oski_value_t _xp4;
			REGISTER oski_value_t _xp5;
			REGISTER oski_value_t _xp6;
			REGISTER oski_value_t _yp0;
			REGISTER oski_value_t _yp1;
			REGISTER oski_value_t _yp2;
			REGISTER oski_value_t _yp3;
			REGISTER oski_value_t _yp4;
			REGISTER oski_value_t _yp5;
			REGISTER oski_value_t _yp6;
			VAL_SET_ZERO( _yp0 );
			VAL_SET_ZERO( _yp1 );
			VAL_SET_ZERO( _yp2 );
			VAL_SET_ZERO( _yp3 );
			VAL_SET_ZERO( _yp4 );
			VAL_SET_ZERO( _yp5 );
			VAL_SET_ZERO( _yp6 );
			VAL_ASSIGN( _xp0, xpp[0] );
			VAL_ASSIGN( _xp1, xpp[1*incx] );
			VAL_ASSIGN( _xp2, xpp[2*incx] );
			VAL_ASSIGN( _xp3, xpp[3*incx] );
			VAL_ASSIGN( _xp4, xpp[4*incx] );
			VAL_ASSIGN( _xp5, xpp[5*incx] );
			VAL_ASSIGN( _xp6, xpp[6*incx] );
			VAL_MAC_CONJ( _yp0, bval[0], _x0 );
			VAL_MAC_CONJ( _yp1, bval[1], _x0 );
			VAL_MAC_CONJ( _yp2, bval[2], _x0 );
			VAL_MAC_CONJ( _yp3, bval[3], _x0 );
			VAL_MAC_CONJ( _yp4, bval[4], _x0 );
			VAL_MAC_CONJ( _yp5, bval[5], _x0 );
			VAL_MAC_CONJ( _yp6, bval[6], _x0 );
			VAL_MAC_CONJ( _yp0, bval[7], _x1 );
			VAL_MAC_CONJ( _yp1, bval[8], _x1 );
			VAL_MAC_CONJ( _yp2, bval[9], _x1 );
			VAL_MAC_CONJ( _yp3, bval[10], _x1 );
			VAL_MAC_CONJ( _yp4, bval[11], _x1 );
			VAL_MAC_CONJ( _yp5, bval[12], _x1 );
			VAL_MAC_CONJ( _yp6, bval[13], _x1 );
			VAL_MAC_CONJ( _yp0, bval[14], _x2 );
			VAL_MAC_CONJ( _yp1, bval[15], _x2 );
			VAL_MAC_CONJ( _yp2, bval[16], _x2 );
			VAL_MAC_CONJ( _yp3, bval[17], _x2 );
			VAL_MAC_CONJ( _yp4, bval[18], _x2 );
			VAL_MAC_CONJ( _yp5, bval[19], _x2 );
			VAL_MAC_CONJ( _yp6, bval[20], _x2 );
			VAL_MAC( _y0, bval[0], _xp0 );
			VAL_MAC( _y1, bval[7], _xp0 );
			VAL_MAC( _y2, bval[14], _xp0 );
			VAL_MAC( _y0, bval[1], _xp1 );
			VAL_MAC( _y1, bval[8], _xp1 );
			VAL_MAC( _y2, bval[15], _xp1 );
			VAL_MAC( _y0, bval[2], _xp2 );
			VAL_MAC( _y1, bval[9], _xp2 );
			VAL_MAC( _y2, bval[16], _xp2 );
			VAL_MAC( _y0, bval[3], _xp3 );
			VAL_MAC( _y1, bval[10], _xp3 );
			VAL_MAC( _y2, bval[17], _xp3 );
			VAL_MAC( _y0, bval[4], _xp4 );
			VAL_MAC( _y1, bval[11], _xp4 );
			VAL_MAC( _y2, bval[18], _xp4 );
			VAL_MAC( _y0, bval[5], _xp5 );
			VAL_MAC( _y1, bval[12], _xp5 );
			VAL_MAC( _y2, bval[19], _xp5 );
			VAL_MAC( _y0, bval[6], _xp6 );
			VAL_MAC( _y1, bval[13], _xp6 );
			VAL_MAC( _y2, bval[20], _xp6 );
			VAL_INC( ypp[0], _yp0 );
			VAL_INC( ypp[1], _yp1 );
			VAL_INC( ypp[2], _yp2 );
			VAL_INC( ypp[3], _yp3 );
			VAL_INC( ypp[4], _yp4 );
			VAL_INC( ypp[5], _yp5 );
			VAL_INC( ypp[6], _yp6 );
		}
		VAL_MAC( yp[0], alpha, _y0 );
		VAL_MAC( yp[1], alpha, _y1 );
		VAL_MAC( yp[2], alpha, _y2 );
	}
	/* Diagonal block multiply */
	yp = y + d0;
	xp = x + d0*incx;
	for( I = 0; I < M; I++, bdiag += 3*3, yp += 3, xp += 3*incx )
	{
		REGISTER oski_value_t _x0;
		REGISTER oski_value_t _x1;
		REGISTER oski_value_t _x2;
		REGISTER oski_value_t _y0;
		REGISTER oski_value_t _y1;
		REGISTER oski_value_t _y2;
		VAL_ASSIGN( _x0, xp[0] );
		VAL_ASSIGN( _x1, xp[1*incx] );
		VAL_ASSIGN( _x2, xp[2*incx] );
		VAL_SET_ZERO( _y0 );
		VAL_SET_ZERO( _y1 );
		VAL_SET_ZERO( _y2 );
		VAL_MAC( _y0, bdiag[0], _x0 );
		VAL_MAC( _y1, bdiag[3], _x0 );
		VAL_MAC( _y2, bdiag[6], _x0 );
		VAL_MAC( _y0, bdiag[1], _x1 );
		VAL_MAC( _y1, bdiag[4], _x1 );
		VAL_MAC( _y2, bdiag[7], _x1 );
		VAL_MAC( _y0, bdiag[2], _x2 );
		VAL_MAC( _y1, bdiag[5], _x2 );
		VAL_MAC( _y2, bdiag[8], _x2 );
		VAL_MAC( yp[0], alpha, _y0 );
		VAL_MAC( yp[1], alpha, _y1 );
		VAL_MAC( yp[2], alpha, _y2 );
	}
}


#endif /* !IS_VAL_COMPLEX */


#if !IS_VAL_COMPLEX

#if defined(DO_NAME_MANGLING)
/** See MBCSR_SymmMatMult_v1_aX_b1_xsX_ysX(). */
#define MBCSR_HermMatMult_v1_aX_b1_xsX_ysX MBCSR_SymmMatMult_v1_aX_b1_xsX_ysX
#endif

#else /* IS_VAL_COMPLEX */



#if defined(DO_NAME_MANGLING)
/** Mangled name for MBCSR_HermMatMult_v1_aX_b1_xsX_ysX */
#define MBCSR_HermMatMult_v1_aX_b1_xsX_ysX MANGLE_MOD_(MBCSR_HermMatMult_v1_aX_b1_xsX_ysX_3x7)
#endif

/**
 *  \brief MBCSR implementation of
 *  \f$y \leftarrow y + \alpha\cdot A\cdot x\f$.
 */
void
MBCSR_HermMatMult_v1_aX_b1_xsX_ysX( oski_index_t M, oski_index_t d0,
	const oski_index_t* restrict bptr, const oski_index_t* restrict bind,
	const oski_value_t* restrict bval, const oski_value_t* restrict bdiag,
	oski_value_t alpha, const oski_value_t* restrict x, oski_index_t incx,
	oski_value_t* restrict y, oski_index_t incy )
{
	oski_value_t* yp = y + d0*incy;
	const oski_value_t* xp = x + d0*incx;
	oski_index_t I;

	for( I = 0; I < M; I++, yp += 3*incy, xp += 3*incx )
	{
		REGISTER oski_value_t _y0;
		REGISTER oski_value_t _y1;
		REGISTER oski_value_t _y2;
		REGISTER oski_value_t _x0;
		REGISTER oski_value_t _x1;
		REGISTER oski_value_t _x2;
		oski_index_t K;

		VAL_SET_ZERO( _y0 );
		VAL_SET_ZERO( _y1 );
		VAL_SET_ZERO( _y2 );
		VAL_MUL( _x0, alpha, xp[0] );
		VAL_MUL( _x1, alpha, xp[1*incx] );
		VAL_MUL( _x2, alpha, xp[2*incx] );

		for( K = bptr[I]; K < bptr[I+1]; K++, bind++, bval += 3*7 )
		{
			oski_index_t j0 = bind[0]; /* block's leftmost col index */
			const oski_value_t* xpp = x + j0*incx;
			oski_value_t* ypp = y + j0*incy;

			REGISTER oski_value_t _xp0;
			REGISTER oski_value_t _xp1;
			REGISTER oski_value_t _xp2;
			REGISTER oski_value_t _xp3;
			REGISTER oski_value_t _xp4;
			REGISTER oski_value_t _xp5;
			REGISTER oski_value_t _xp6;
			REGISTER oski_value_t _yp0;
			REGISTER oski_value_t _yp1;
			REGISTER oski_value_t _yp2;
			REGISTER oski_value_t _yp3;
			REGISTER oski_value_t _yp4;
			REGISTER oski_value_t _yp5;
			REGISTER oski_value_t _yp6;
			VAL_SET_ZERO( _yp0 );
			VAL_SET_ZERO( _yp1 );
			VAL_SET_ZERO( _yp2 );
			VAL_SET_ZERO( _yp3 );
			VAL_SET_ZERO( _yp4 );
			VAL_SET_ZERO( _yp5 );
			VAL_SET_ZERO( _yp6 );
			VAL_ASSIGN( _xp0, xpp[0] );
			VAL_ASSIGN( _xp1, xpp[1*incx] );
			VAL_ASSIGN( _xp2, xpp[2*incx] );
			VAL_ASSIGN( _xp3, xpp[3*incx] );
			VAL_ASSIGN( _xp4, xpp[4*incx] );
			VAL_ASSIGN( _xp5, xpp[5*incx] );
			VAL_ASSIGN( _xp6, xpp[6*incx] );
			VAL_MAC_CONJ( _yp0, bval[0], _x0 );
			VAL_MAC_CONJ( _yp1, bval[1], _x0 );
			VAL_MAC_CONJ( _yp2, bval[2], _x0 );
			VAL_MAC_CONJ( _yp3, bval[3], _x0 );
			VAL_MAC_CONJ( _yp4, bval[4], _x0 );
			VAL_MAC_CONJ( _yp5, bval[5], _x0 );
			VAL_MAC_CONJ( _yp6, bval[6], _x0 );
			VAL_MAC_CONJ( _yp0, bval[7], _x1 );
			VAL_MAC_CONJ( _yp1, bval[8], _x1 );
			VAL_MAC_CONJ( _yp2, bval[9], _x1 );
			VAL_MAC_CONJ( _yp3, bval[10], _x1 );
			VAL_MAC_CONJ( _yp4, bval[11], _x1 );
			VAL_MAC_CONJ( _yp5, bval[12], _x1 );
			VAL_MAC_CONJ( _yp6, bval[13], _x1 );
			VAL_MAC_CONJ( _yp0, bval[14], _x2 );
			VAL_MAC_CONJ( _yp1, bval[15], _x2 );
			VAL_MAC_CONJ( _yp2, bval[16], _x2 );
			VAL_MAC_CONJ( _yp3, bval[17], _x2 );
			VAL_MAC_CONJ( _yp4, bval[18], _x2 );
			VAL_MAC_CONJ( _yp5, bval[19], _x2 );
			VAL_MAC_CONJ( _yp6, bval[20], _x2 );
			VAL_MAC( _y0, bval[0], _xp0 );
			VAL_MAC( _y1, bval[7], _xp0 );
			VAL_MAC( _y2, bval[14], _xp0 );
			VAL_MAC( _y0, bval[1], _xp1 );
			VAL_MAC( _y1, bval[8], _xp1 );
			VAL_MAC( _y2, bval[15], _xp1 );
			VAL_MAC( _y0, bval[2], _xp2 );
			VAL_MAC( _y1, bval[9], _xp2 );
			VAL_MAC( _y2, bval[16], _xp2 );
			VAL_MAC( _y0, bval[3], _xp3 );
			VAL_MAC( _y1, bval[10], _xp3 );
			VAL_MAC( _y2, bval[17], _xp3 );
			VAL_MAC( _y0, bval[4], _xp4 );
			VAL_MAC( _y1, bval[11], _xp4 );
			VAL_MAC( _y2, bval[18], _xp4 );
			VAL_MAC( _y0, bval[5], _xp5 );
			VAL_MAC( _y1, bval[12], _xp5 );
			VAL_MAC( _y2, bval[19], _xp5 );
			VAL_MAC( _y0, bval[6], _xp6 );
			VAL_MAC( _y1, bval[13], _xp6 );
			VAL_MAC( _y2, bval[20], _xp6 );
			VAL_INC( ypp[0], _yp0 );
			VAL_INC( ypp[1*incy], _yp1 );
			VAL_INC( ypp[2*incy], _yp2 );
			VAL_INC( ypp[3*incy], _yp3 );
			VAL_INC( ypp[4*incy], _yp4 );
			VAL_INC( ypp[5*incy], _yp5 );
			VAL_INC( ypp[6*incy], _yp6 );
		}
		VAL_MAC( yp[0], alpha, _y0 );
		VAL_MAC( yp[1*incy], alpha, _y1 );
		VAL_MAC( yp[2*incy], alpha, _y2 );
	}
	/* Diagonal block multiply */
	yp = y + d0*incy;
	xp = x + d0*incx;
	for( I = 0; I < M; I++, bdiag += 3*3, yp += 3*incy, xp += 3*incx )
	{
		REGISTER oski_value_t _x0;
		REGISTER oski_value_t _x1;
		REGISTER oski_value_t _x2;
		REGISTER oski_value_t _y0;
		REGISTER oski_value_t _y1;
		REGISTER oski_value_t _y2;
		VAL_ASSIGN( _x0, xp[0] );
		VAL_ASSIGN( _x1, xp[1*incx] );
		VAL_ASSIGN( _x2, xp[2*incx] );
		VAL_SET_ZERO( _y0 );
		VAL_SET_ZERO( _y1 );
		VAL_SET_ZERO( _y2 );
		VAL_MAC( _y0, bdiag[0], _x0 );
		VAL_MAC( _y1, bdiag[3], _x0 );
		VAL_MAC( _y2, bdiag[6], _x0 );
		VAL_MAC( _y0, bdiag[1], _x1 );
		VAL_MAC( _y1, bdiag[4], _x1 );
		VAL_MAC( _y2, bdiag[7], _x1 );
		VAL_MAC( _y0, bdiag[2], _x2 );
		VAL_MAC( _y1, bdiag[5], _x2 );
		VAL_MAC( _y2, bdiag[8], _x2 );
		VAL_MAC( yp[0], alpha, _y0 );
		VAL_MAC( yp[1*incy], alpha, _y1 );
		VAL_MAC( yp[2*incy], alpha, _y2 );
	}
}


#endif /* !IS_VAL_COMPLEX */


#if !IS_VAL_COMPLEX
/**
 *  \brief Matrix times single-vector multiply in the normal case;
 *  see SymmMatMult_v1().
 */
#define HermMatMult_v1 SymmMatMult_v1

#else /* IS_VAL_COMPLEX */


/**
 *  \brief Hermitian matrix times single-vector multiply in the normal case.
 */
static void
HermMatMult_v1( oski_index_t M, oski_index_t d0,
	const oski_index_t* bptr, const oski_index_t* bind,
	const oski_value_t* bval, const oski_value_t* bdiag,
	oski_value_t alpha, const oski_value_t* x, oski_index_t incx,
	oski_value_t* y, oski_index_t incy )
{
	if( incx == 1 ) {
		if( incy == 1 ) {
			MBCSR_HermMatMult_v1_aX_b1_xs1_ys1( M, d0,
				bptr, bind, bval, bdiag, alpha, x, y );
		} else { /* general incy */
			MBCSR_HermMatMult_v1_aX_b1_xs1_ysX( M, d0,
				bptr, bind, bval, bdiag, alpha, x, y, incy );
		}
	} else { /* general incx */
		if( incy == 1 ) {
			MBCSR_HermMatMult_v1_aX_b1_xsX_ys1( M, d0,
				bptr, bind, bval, bdiag, alpha, x, incx, y );
		} else { /* general incy */
			MBCSR_HermMatMult_v1_aX_b1_xsX_ysX( M, d0,
				bptr, bind, bval, bdiag, alpha, x, incx, y, incy );
		}
	}
}


#endif /* !IS_VAL_COMPLEX */


#if !IS_VAL_COMPLEX
/**
 *  \brief See SymmMatMult().
 */
#define HermMatMult SymmMatMult

#else /* IS_VAL_COMPLEX */



/**
 *  \brief Computes
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$\mathrm{op}(A) = A\f$, on the fully blocked
 *  portion of \f$A\f$.
 */
static int
HermMatMult( const oski_submatMBCSR_t* A,
	oski_value_t alpha, const oski_vecview_t x_view,
	oski_vecview_t y_view )
{
	oski_index_t j; /* column number */
	const oski_value_t* xpj; /* X(:, j) */
	oski_value_t* ypj; /* Y(:, j) */

	assert( A->r == 3 );
	assert( A->c == 7 );

	for( j = 0, xpj = x_view->val, ypj = y_view->val;
		j < x_view->num_cols;
		j++, xpj += x_view->colinc, ypj += y_view->colinc )
	{
		HermMatMult_v1( A->num_block_rows, A->offset,
			A->bptr, A->bind, A->bval, A->bdiag,
			alpha, xpj, x_view->rowinc, ypj, y_view->rowinc );
	}

	return 0;
}


#endif /* !IS_VAL_COMPLEX */


#if !IS_VAL_COMPLEX

#if defined(DO_NAME_MANGLING)
/** See MBCSR_SymmMatMult_v1_aX_b1_xs1_ys1(). */
#define MBCSR_HermMatConjMult_v1_aX_b1_xs1_ys1 MBCSR_SymmMatMult_v1_aX_b1_xs1_ys1
#endif

#else /* IS_VAL_COMPLEX */



#if defined(DO_NAME_MANGLING)
/** Mangled name for MBCSR_HermMatConjMult_v1_aX_b1_xs1_ys1 */
#define MBCSR_HermMatConjMult_v1_aX_b1_xs1_ys1 MANGLE_MOD_(MBCSR_HermMatConjMult_v1_aX_b1_xs1_ys1_3x7)
#endif

/**
 *  \brief MBCSR implementation of
 *  \f$y \leftarrow y + \alpha\cdot \bar{A}\cdot x\f$.
 */
void
MBCSR_HermMatConjMult_v1_aX_b1_xs1_ys1( oski_index_t M, oski_index_t d0,
	const oski_index_t* restrict bptr, const oski_index_t* restrict bind,
	const oski_value_t* restrict bval, const oski_value_t* restrict bdiag,
	oski_value_t alpha, const oski_value_t* restrict x,
	oski_value_t* restrict y )
{
	oski_value_t* yp = y + d0;
	const oski_value_t* xp = x + d0;
	oski_index_t I;

	for( I = 0; I < M; I++, yp += 3, xp += 3 )
	{
		REGISTER oski_value_t _y0;
		REGISTER oski_value_t _y1;
		REGISTER oski_value_t _y2;
		REGISTER oski_value_t _x0;
		REGISTER oski_value_t _x1;
		REGISTER oski_value_t _x2;
		oski_index_t K;

		VAL_SET_ZERO( _y0 );
		VAL_SET_ZERO( _y1 );
		VAL_SET_ZERO( _y2 );
		VAL_MUL( _x0, alpha, xp[0] );
		VAL_MUL( _x1, alpha, xp[1] );
		VAL_MUL( _x2, alpha, xp[2] );

		for( K = bptr[I]; K < bptr[I+1]; K++, bind++, bval += 3*7 )
		{
			oski_index_t j0 = bind[0]; /* block's leftmost col index */
			const oski_value_t* xpp = x + j0;
			oski_value_t* ypp = y + j0;

			REGISTER oski_value_t _xp0;
			REGISTER oski_value_t _xp1;
			REGISTER oski_value_t _xp2;
			REGISTER oski_value_t _xp3;
			REGISTER oski_value_t _xp4;
			REGISTER oski_value_t _xp5;
			REGISTER oski_value_t _xp6;
			REGISTER oski_value_t _yp0;
			REGISTER oski_value_t _yp1;
			REGISTER oski_value_t _yp2;
			REGISTER oski_value_t _yp3;
			REGISTER oski_value_t _yp4;
			REGISTER oski_value_t _yp5;
			REGISTER oski_value_t _yp6;
			VAL_SET_ZERO( _yp0 );
			VAL_SET_ZERO( _yp1 );
			VAL_SET_ZERO( _yp2 );
			VAL_SET_ZERO( _yp3 );
			VAL_SET_ZERO( _yp4 );
			VAL_SET_ZERO( _yp5 );
			VAL_SET_ZERO( _yp6 );
			VAL_ASSIGN( _xp0, xpp[0] );
			VAL_ASSIGN( _xp1, xpp[1] );
			VAL_ASSIGN( _xp2, xpp[2] );
			VAL_ASSIGN( _xp3, xpp[3] );
			VAL_ASSIGN( _xp4, xpp[4] );
			VAL_ASSIGN( _xp5, xpp[5] );
			VAL_ASSIGN( _xp6, xpp[6] );
			VAL_MAC( _yp0, bval[0], _x0 );
			VAL_MAC( _yp1, bval[1], _x0 );
			VAL_MAC( _yp2, bval[2], _x0 );
			VAL_MAC( _yp3, bval[3], _x0 );
			VAL_MAC( _yp4, bval[4], _x0 );
			VAL_MAC( _yp5, bval[5], _x0 );
			VAL_MAC( _yp6, bval[6], _x0 );
			VAL_MAC( _yp0, bval[7], _x1 );
			VAL_MAC( _yp1, bval[8], _x1 );
			VAL_MAC( _yp2, bval[9], _x1 );
			VAL_MAC( _yp3, bval[10], _x1 );
			VAL_MAC( _yp4, bval[11], _x1 );
			VAL_MAC( _yp5, bval[12], _x1 );
			VAL_MAC( _yp6, bval[13], _x1 );
			VAL_MAC( _yp0, bval[14], _x2 );
			VAL_MAC( _yp1, bval[15], _x2 );
			VAL_MAC( _yp2, bval[16], _x2 );
			VAL_MAC( _yp3, bval[17], _x2 );
			VAL_MAC( _yp4, bval[18], _x2 );
			VAL_MAC( _yp5, bval[19], _x2 );
			VAL_MAC( _yp6, bval[20], _x2 );
			VAL_MAC_CONJ( _y0, bval[0], _xp0 );
			VAL_MAC_CONJ( _y1, bval[7], _xp0 );
			VAL_MAC_CONJ( _y2, bval[14], _xp0 );
			VAL_MAC_CONJ( _y0, bval[1], _xp1 );
			VAL_MAC_CONJ( _y1, bval[8], _xp1 );
			VAL_MAC_CONJ( _y2, bval[15], _xp1 );
			VAL_MAC_CONJ( _y0, bval[2], _xp2 );
			VAL_MAC_CONJ( _y1, bval[9], _xp2 );
			VAL_MAC_CONJ( _y2, bval[16], _xp2 );
			VAL_MAC_CONJ( _y0, bval[3], _xp3 );
			VAL_MAC_CONJ( _y1, bval[10], _xp3 );
			VAL_MAC_CONJ( _y2, bval[17], _xp3 );
			VAL_MAC_CONJ( _y0, bval[4], _xp4 );
			VAL_MAC_CONJ( _y1, bval[11], _xp4 );
			VAL_MAC_CONJ( _y2, bval[18], _xp4 );
			VAL_MAC_CONJ( _y0, bval[5], _xp5 );
			VAL_MAC_CONJ( _y1, bval[12], _xp5 );
			VAL_MAC_CONJ( _y2, bval[19], _xp5 );
			VAL_MAC_CONJ( _y0, bval[6], _xp6 );
			VAL_MAC_CONJ( _y1, bval[13], _xp6 );
			VAL_MAC_CONJ( _y2, bval[20], _xp6 );
			VAL_INC( ypp[0], _yp0 );
			VAL_INC( ypp[1], _yp1 );
			VAL_INC( ypp[2], _yp2 );
			VAL_INC( ypp[3], _yp3 );
			VAL_INC( ypp[4], _yp4 );
			VAL_INC( ypp[5], _yp5 );
			VAL_INC( ypp[6], _yp6 );
		}
		VAL_MAC( yp[0], alpha, _y0 );
		VAL_MAC( yp[1], alpha, _y1 );
		VAL_MAC( yp[2], alpha, _y2 );
	}
	/* Diagonal block multiply */
	yp = y + d0;
	xp = x + d0;
	for( I = 0; I < M; I++, bdiag += 3*3, yp += 3, xp += 3 )
	{
		REGISTER oski_value_t _x0;
		REGISTER oski_value_t _x1;
		REGISTER oski_value_t _x2;
		REGISTER oski_value_t _y0;
		REGISTER oski_value_t _y1;
		REGISTER oski_value_t _y2;
		VAL_ASSIGN( _x0, xp[0] );
		VAL_ASSIGN( _x1, xp[1] );
		VAL_ASSIGN( _x2, xp[2] );
		VAL_SET_ZERO( _y0 );
		VAL_SET_ZERO( _y1 );
		VAL_SET_ZERO( _y2 );
		VAL_MAC_CONJ( _y0, bdiag[0], _x0 );
		VAL_MAC_CONJ( _y1, bdiag[3], _x0 );
		VAL_MAC_CONJ( _y2, bdiag[6], _x0 );
		VAL_MAC_CONJ( _y0, bdiag[1], _x1 );
		VAL_MAC_CONJ( _y1, bdiag[4], _x1 );
		VAL_MAC_CONJ( _y2, bdiag[7], _x1 );
		VAL_MAC_CONJ( _y0, bdiag[2], _x2 );
		VAL_MAC_CONJ( _y1, bdiag[5], _x2 );
		VAL_MAC_CONJ( _y2, bdiag[8], _x2 );
		VAL_MAC( yp[0], alpha, _y0 );
		VAL_MAC( yp[1], alpha, _y1 );
		VAL_MAC( yp[2], alpha, _y2 );
	}
}


#endif /* !IS_VAL_COMPLEX */


#if !IS_VAL_COMPLEX

#if defined(DO_NAME_MANGLING)
/** See MBCSR_SymmMatMult_v1_aX_b1_xs1_ysX(). */
#define MBCSR_HermMatConjMult_v1_aX_b1_xs1_ysX MBCSR_SymmMatMult_v1_aX_b1_xs1_ysX
#endif

#else /* IS_VAL_COMPLEX */



#if defined(DO_NAME_MANGLING)
/** Mangled name for MBCSR_HermMatConjMult_v1_aX_b1_xs1_ysX */
#define MBCSR_HermMatConjMult_v1_aX_b1_xs1_ysX MANGLE_MOD_(MBCSR_HermMatConjMult_v1_aX_b1_xs1_ysX_3x7)
#endif

/**
 *  \brief MBCSR implementation of
 *  \f$y \leftarrow y + \alpha\cdot \bar{A}\cdot x\f$.
 */
void
MBCSR_HermMatConjMult_v1_aX_b1_xs1_ysX( oski_index_t M, oski_index_t d0,
	const oski_index_t* restrict bptr, const oski_index_t* restrict bind,
	const oski_value_t* restrict bval, const oski_value_t* restrict bdiag,
	oski_value_t alpha, const oski_value_t* restrict x,
	oski_value_t* restrict y, oski_index_t incy )
{
	oski_value_t* yp = y + d0*incy;
	const oski_value_t* xp = x + d0;
	oski_index_t I;

	for( I = 0; I < M; I++, yp += 3*incy, xp += 3 )
	{
		REGISTER oski_value_t _y0;
		REGISTER oski_value_t _y1;
		REGISTER oski_value_t _y2;
		REGISTER oski_value_t _x0;
		REGISTER oski_value_t _x1;
		REGISTER oski_value_t _x2;
		oski_index_t K;

		VAL_SET_ZERO( _y0 );
		VAL_SET_ZERO( _y1 );
		VAL_SET_ZERO( _y2 );
		VAL_MUL( _x0, alpha, xp[0] );
		VAL_MUL( _x1, alpha, xp[1] );
		VAL_MUL( _x2, alpha, xp[2] );

		for( K = bptr[I]; K < bptr[I+1]; K++, bind++, bval += 3*7 )
		{
			oski_index_t j0 = bind[0]; /* block's leftmost col index */
			const oski_value_t* xpp = x + j0;
			oski_value_t* ypp = y + j0*incy;

			REGISTER oski_value_t _xp0;
			REGISTER oski_value_t _xp1;
			REGISTER oski_value_t _xp2;
			REGISTER oski_value_t _xp3;
			REGISTER oski_value_t _xp4;
			REGISTER oski_value_t _xp5;
			REGISTER oski_value_t _xp6;
			REGISTER oski_value_t _yp0;
			REGISTER oski_value_t _yp1;
			REGISTER oski_value_t _yp2;
			REGISTER oski_value_t _yp3;
			REGISTER oski_value_t _yp4;
			REGISTER oski_value_t _yp5;
			REGISTER oski_value_t _yp6;
			VAL_SET_ZERO( _yp0 );
			VAL_SET_ZERO( _yp1 );
			VAL_SET_ZERO( _yp2 );
			VAL_SET_ZERO( _yp3 );
			VAL_SET_ZERO( _yp4 );
			VAL_SET_ZERO( _yp5 );
			VAL_SET_ZERO( _yp6 );
			VAL_ASSIGN( _xp0, xpp[0] );
			VAL_ASSIGN( _xp1, xpp[1] );
			VAL_ASSIGN( _xp2, xpp[2] );
			VAL_ASSIGN( _xp3, xpp[3] );
			VAL_ASSIGN( _xp4, xpp[4] );
			VAL_ASSIGN( _xp5, xpp[5] );
			VAL_ASSIGN( _xp6, xpp[6] );
			VAL_MAC( _yp0, bval[0], _x0 );
			VAL_MAC( _yp1, bval[1], _x0 );
			VAL_MAC( _yp2, bval[2], _x0 );
			VAL_MAC( _yp3, bval[3], _x0 );
			VAL_MAC( _yp4, bval[4], _x0 );
			VAL_MAC( _yp5, bval[5], _x0 );
			VAL_MAC( _yp6, bval[6], _x0 );
			VAL_MAC( _yp0, bval[7], _x1 );
			VAL_MAC( _yp1, bval[8], _x1 );
			VAL_MAC( _yp2, bval[9], _x1 );
			VAL_MAC( _yp3, bval[10], _x1 );
			VAL_MAC( _yp4, bval[11], _x1 );
			VAL_MAC( _yp5, bval[12], _x1 );
			VAL_MAC( _yp6, bval[13], _x1 );
			VAL_MAC( _yp0, bval[14], _x2 );
			VAL_MAC( _yp1, bval[15], _x2 );
			VAL_MAC( _yp2, bval[16], _x2 );
			VAL_MAC( _yp3, bval[17], _x2 );
			VAL_MAC( _yp4, bval[18], _x2 );
			VAL_MAC( _yp5, bval[19], _x2 );
			VAL_MAC( _yp6, bval[20], _x2 );
			VAL_MAC_CONJ( _y0, bval[0], _xp0 );
			VAL_MAC_CONJ( _y1, bval[7], _xp0 );
			VAL_MAC_CONJ( _y2, bval[14], _xp0 );
			VAL_MAC_CONJ( _y0, bval[1], _xp1 );
			VAL_MAC_CONJ( _y1, bval[8], _xp1 );
			VAL_MAC_CONJ( _y2, bval[15], _xp1 );
			VAL_MAC_CONJ( _y0, bval[2], _xp2 );
			VAL_MAC_CONJ( _y1, bval[9], _xp2 );
			VAL_MAC_CONJ( _y2, bval[16], _xp2 );
			VAL_MAC_CONJ( _y0, bval[3], _xp3 );
			VAL_MAC_CONJ( _y1, bval[10], _xp3 );
			VAL_MAC_CONJ( _y2, bval[17], _xp3 );
			VAL_MAC_CONJ( _y0, bval[4], _xp4 );
			VAL_MAC_CONJ( _y1, bval[11], _xp4 );
			VAL_MAC_CONJ( _y2, bval[18], _xp4 );
			VAL_MAC_CONJ( _y0, bval[5], _xp5 );
			VAL_MAC_CONJ( _y1, bval[12], _xp5 );
			VAL_MAC_CONJ( _y2, bval[19], _xp5 );
			VAL_MAC_CONJ( _y0, bval[6], _xp6 );
			VAL_MAC_CONJ( _y1, bval[13], _xp6 );
			VAL_MAC_CONJ( _y2, bval[20], _xp6 );
			VAL_INC( ypp[0], _yp0 );
			VAL_INC( ypp[1*incy], _yp1 );
			VAL_INC( ypp[2*incy], _yp2 );
			VAL_INC( ypp[3*incy], _yp3 );
			VAL_INC( ypp[4*incy], _yp4 );
			VAL_INC( ypp[5*incy], _yp5 );
			VAL_INC( ypp[6*incy], _yp6 );
		}
		VAL_MAC( yp[0], alpha, _y0 );
		VAL_MAC( yp[1*incy], alpha, _y1 );
		VAL_MAC( yp[2*incy], alpha, _y2 );
	}
	/* Diagonal block multiply */
	yp = y + d0*incy;
	xp = x + d0;
	for( I = 0; I < M; I++, bdiag += 3*3, yp += 3*incy, xp += 3 )
	{
		REGISTER oski_value_t _x0;
		REGISTER oski_value_t _x1;
		REGISTER oski_value_t _x2;
		REGISTER oski_value_t _y0;
		REGISTER oski_value_t _y1;
		REGISTER oski_value_t _y2;
		VAL_ASSIGN( _x0, xp[0] );
		VAL_ASSIGN( _x1, xp[1] );
		VAL_ASSIGN( _x2, xp[2] );
		VAL_SET_ZERO( _y0 );
		VAL_SET_ZERO( _y1 );
		VAL_SET_ZERO( _y2 );
		VAL_MAC_CONJ( _y0, bdiag[0], _x0 );
		VAL_MAC_CONJ( _y1, bdiag[3], _x0 );
		VAL_MAC_CONJ( _y2, bdiag[6], _x0 );
		VAL_MAC_CONJ( _y0, bdiag[1], _x1 );
		VAL_MAC_CONJ( _y1, bdiag[4], _x1 );
		VAL_MAC_CONJ( _y2, bdiag[7], _x1 );
		VAL_MAC_CONJ( _y0, bdiag[2], _x2 );
		VAL_MAC_CONJ( _y1, bdiag[5], _x2 );
		VAL_MAC_CONJ( _y2, bdiag[8], _x2 );
		VAL_MAC( yp[0], alpha, _y0 );
		VAL_MAC( yp[1*incy], alpha, _y1 );
		VAL_MAC( yp[2*incy], alpha, _y2 );
	}
}


#endif /* !IS_VAL_COMPLEX */


#if !IS_VAL_COMPLEX

#if defined(DO_NAME_MANGLING)
/** See MBCSR_SymmMatMult_v1_aX_b1_xsX_ys1(). */
#define MBCSR_HermMatConjMult_v1_aX_b1_xsX_ys1 MBCSR_SymmMatMult_v1_aX_b1_xsX_ys1
#endif

#else /* IS_VAL_COMPLEX */



#if defined(DO_NAME_MANGLING)
/** Mangled name for MBCSR_HermMatConjMult_v1_aX_b1_xsX_ys1 */
#define MBCSR_HermMatConjMult_v1_aX_b1_xsX_ys1 MANGLE_MOD_(MBCSR_HermMatConjMult_v1_aX_b1_xsX_ys1_3x7)
#endif

/**
 *  \brief MBCSR implementation of
 *  \f$y \leftarrow y + \alpha\cdot \bar{A}\cdot x\f$.
 */
void
MBCSR_HermMatConjMult_v1_aX_b1_xsX_ys1( oski_index_t M, oski_index_t d0,
	const oski_index_t* restrict bptr, const oski_index_t* restrict bind,
	const oski_value_t* restrict bval, const oski_value_t* restrict bdiag,
	oski_value_t alpha, const oski_value_t* restrict x, oski_index_t incx,
	oski_value_t* restrict y )
{
	oski_value_t* yp = y + d0;
	const oski_value_t* xp = x + d0*incx;
	oski_index_t I;

	for( I = 0; I < M; I++, yp += 3, xp += 3*incx )
	{
		REGISTER oski_value_t _y0;
		REGISTER oski_value_t _y1;
		REGISTER oski_value_t _y2;
		REGISTER oski_value_t _x0;
		REGISTER oski_value_t _x1;
		REGISTER oski_value_t _x2;
		oski_index_t K;

		VAL_SET_ZERO( _y0 );
		VAL_SET_ZERO( _y1 );
		VAL_SET_ZERO( _y2 );
		VAL_MUL( _x0, alpha, xp[0] );
		VAL_MUL( _x1, alpha, xp[1*incx] );
		VAL_MUL( _x2, alpha, xp[2*incx] );

		for( K = bptr[I]; K < bptr[I+1]; K++, bind++, bval += 3*7 )
		{
			oski_index_t j0 = bind[0]; /* block's leftmost col index */
			const oski_value_t* xpp = x + j0*incx;
			oski_value_t* ypp = y + j0;

			REGISTER oski_value_t _xp0;
			REGISTER oski_value_t _xp1;
			REGISTER oski_value_t _xp2;
			REGISTER oski_value_t _xp3;
			REGISTER oski_value_t _xp4;
			REGISTER oski_value_t _xp5;
			REGISTER oski_value_t _xp6;
			REGISTER oski_value_t _yp0;
			REGISTER oski_value_t _yp1;
			REGISTER oski_value_t _yp2;
			REGISTER oski_value_t _yp3;
			REGISTER oski_value_t _yp4;
			REGISTER oski_value_t _yp5;
			REGISTER oski_value_t _yp6;
			VAL_SET_ZERO( _yp0 );
			VAL_SET_ZERO( _yp1 );
			VAL_SET_ZERO( _yp2 );
			VAL_SET_ZERO( _yp3 );
			VAL_SET_ZERO( _yp4 );
			VAL_SET_ZERO( _yp5 );
			VAL_SET_ZERO( _yp6 );
			VAL_ASSIGN( _xp0, xpp[0] );
			VAL_ASSIGN( _xp1, xpp[1*incx] );
			VAL_ASSIGN( _xp2, xpp[2*incx] );
			VAL_ASSIGN( _xp3, xpp[3*incx] );
			VAL_ASSIGN( _xp4, xpp[4*incx] );
			VAL_ASSIGN( _xp5, xpp[5*incx] );
			VAL_ASSIGN( _xp6, xpp[6*incx] );
			VAL_MAC( _yp0, bval[0], _x0 );
			VAL_MAC( _yp1, bval[1], _x0 );
			VAL_MAC( _yp2, bval[2], _x0 );
			VAL_MAC( _yp3, bval[3], _x0 );
			VAL_MAC( _yp4, bval[4], _x0 );
			VAL_MAC( _yp5, bval[5], _x0 );
			VAL_MAC( _yp6, bval[6], _x0 );
			VAL_MAC( _yp0, bval[7], _x1 );
			VAL_MAC( _yp1, bval[8], _x1 );
			VAL_MAC( _yp2, bval[9], _x1 );
			VAL_MAC( _yp3, bval[10], _x1 );
			VAL_MAC( _yp4, bval[11], _x1 );
			VAL_MAC( _yp5, bval[12], _x1 );
			VAL_MAC( _yp6, bval[13], _x1 );
			VAL_MAC( _yp0, bval[14], _x2 );
			VAL_MAC( _yp1, bval[15], _x2 );
			VAL_MAC( _yp2, bval[16], _x2 );
			VAL_MAC( _yp3, bval[17], _x2 );
			VAL_MAC( _yp4, bval[18], _x2 );
			VAL_MAC( _yp5, bval[19], _x2 );
			VAL_MAC( _yp6, bval[20], _x2 );
			VAL_MAC_CONJ( _y0, bval[0], _xp0 );
			VAL_MAC_CONJ( _y1, bval[7], _xp0 );
			VAL_MAC_CONJ( _y2, bval[14], _xp0 );
			VAL_MAC_CONJ( _y0, bval[1], _xp1 );
			VAL_MAC_CONJ( _y1, bval[8], _xp1 );
			VAL_MAC_CONJ( _y2, bval[15], _xp1 );
			VAL_MAC_CONJ( _y0, bval[2], _xp2 );
			VAL_MAC_CONJ( _y1, bval[9], _xp2 );
			VAL_MAC_CONJ( _y2, bval[16], _xp2 );
			VAL_MAC_CONJ( _y0, bval[3], _xp3 );
			VAL_MAC_CONJ( _y1, bval[10], _xp3 );
			VAL_MAC_CONJ( _y2, bval[17], _xp3 );
			VAL_MAC_CONJ( _y0, bval[4], _xp4 );
			VAL_MAC_CONJ( _y1, bval[11], _xp4 );
			VAL_MAC_CONJ( _y2, bval[18], _xp4 );
			VAL_MAC_CONJ( _y0, bval[5], _xp5 );
			VAL_MAC_CONJ( _y1, bval[12], _xp5 );
			VAL_MAC_CONJ( _y2, bval[19], _xp5 );
			VAL_MAC_CONJ( _y0, bval[6], _xp6 );
			VAL_MAC_CONJ( _y1, bval[13], _xp6 );
			VAL_MAC_CONJ( _y2, bval[20], _xp6 );
			VAL_INC( ypp[0], _yp0 );
			VAL_INC( ypp[1], _yp1 );
			VAL_INC( ypp[2], _yp2 );
			VAL_INC( ypp[3], _yp3 );
			VAL_INC( ypp[4], _yp4 );
			VAL_INC( ypp[5], _yp5 );
			VAL_INC( ypp[6], _yp6 );
		}
		VAL_MAC( yp[0], alpha, _y0 );
		VAL_MAC( yp[1], alpha, _y1 );
		VAL_MAC( yp[2], alpha, _y2 );
	}
	/* Diagonal block multiply */
	yp = y + d0;
	xp = x + d0*incx;
	for( I = 0; I < M; I++, bdiag += 3*3, yp += 3, xp += 3*incx )
	{
		REGISTER oski_value_t _x0;
		REGISTER oski_value_t _x1;
		REGISTER oski_value_t _x2;
		REGISTER oski_value_t _y0;
		REGISTER oski_value_t _y1;
		REGISTER oski_value_t _y2;
		VAL_ASSIGN( _x0, xp[0] );
		VAL_ASSIGN( _x1, xp[1*incx] );
		VAL_ASSIGN( _x2, xp[2*incx] );
		VAL_SET_ZERO( _y0 );
		VAL_SET_ZERO( _y1 );
		VAL_SET_ZERO( _y2 );
		VAL_MAC_CONJ( _y0, bdiag[0], _x0 );
		VAL_MAC_CONJ( _y1, bdiag[3], _x0 );
		VAL_MAC_CONJ( _y2, bdiag[6], _x0 );
		VAL_MAC_CONJ( _y0, bdiag[1], _x1 );
		VAL_MAC_CONJ( _y1, bdiag[4], _x1 );
		VAL_MAC_CONJ( _y2, bdiag[7], _x1 );
		VAL_MAC_CONJ( _y0, bdiag[2], _x2 );
		VAL_MAC_CONJ( _y1, bdiag[5], _x2 );
		VAL_MAC_CONJ( _y2, bdiag[8], _x2 );
		VAL_MAC( yp[0], alpha, _y0 );
		VAL_MAC( yp[1], alpha, _y1 );
		VAL_MAC( yp[2], alpha, _y2 );
	}
}


#endif /* !IS_VAL_COMPLEX */


#if !IS_VAL_COMPLEX

#if defined(DO_NAME_MANGLING)
/** See MBCSR_SymmMatMult_v1_aX_b1_xsX_ysX(). */
#define MBCSR_HermMatConjMult_v1_aX_b1_xsX_ysX MBCSR_SymmMatMult_v1_aX_b1_xsX_ysX
#endif

#else /* IS_VAL_COMPLEX */



#if defined(DO_NAME_MANGLING)
/** Mangled name for MBCSR_HermMatConjMult_v1_aX_b1_xsX_ysX */
#define MBCSR_HermMatConjMult_v1_aX_b1_xsX_ysX MANGLE_MOD_(MBCSR_HermMatConjMult_v1_aX_b1_xsX_ysX_3x7)
#endif

/**
 *  \brief MBCSR implementation of
 *  \f$y \leftarrow y + \alpha\cdot \bar{A}\cdot x\f$.
 */
void
MBCSR_HermMatConjMult_v1_aX_b1_xsX_ysX( oski_index_t M, oski_index_t d0,
	const oski_index_t* restrict bptr, const oski_index_t* restrict bind,
	const oski_value_t* restrict bval, const oski_value_t* restrict bdiag,
	oski_value_t alpha, const oski_value_t* restrict x, oski_index_t incx,
	oski_value_t* restrict y, oski_index_t incy )
{
	oski_value_t* yp = y + d0*incy;
	const oski_value_t* xp = x + d0*incx;
	oski_index_t I;

	for( I = 0; I < M; I++, yp += 3*incy, xp += 3*incx )
	{
		REGISTER oski_value_t _y0;
		REGISTER oski_value_t _y1;
		REGISTER oski_value_t _y2;
		REGISTER oski_value_t _x0;
		REGISTER oski_value_t _x1;
		REGISTER oski_value_t _x2;
		oski_index_t K;

		VAL_SET_ZERO( _y0 );
		VAL_SET_ZERO( _y1 );
		VAL_SET_ZERO( _y2 );
		VAL_MUL( _x0, alpha, xp[0] );
		VAL_MUL( _x1, alpha, xp[1*incx] );
		VAL_MUL( _x2, alpha, xp[2*incx] );

		for( K = bptr[I]; K < bptr[I+1]; K++, bind++, bval += 3*7 )
		{
			oski_index_t j0 = bind[0]; /* block's leftmost col index */
			const oski_value_t* xpp = x + j0*incx;
			oski_value_t* ypp = y + j0*incy;

			REGISTER oski_value_t _xp0;
			REGISTER oski_value_t _xp1;
			REGISTER oski_value_t _xp2;
			REGISTER oski_value_t _xp3;
			REGISTER oski_value_t _xp4;
			REGISTER oski_value_t _xp5;
			REGISTER oski_value_t _xp6;
			REGISTER oski_value_t _yp0;
			REGISTER oski_value_t _yp1;
			REGISTER oski_value_t _yp2;
			REGISTER oski_value_t _yp3;
			REGISTER oski_value_t _yp4;
			REGISTER oski_value_t _yp5;
			REGISTER oski_value_t _yp6;
			VAL_SET_ZERO( _yp0 );
			VAL_SET_ZERO( _yp1 );
			VAL_SET_ZERO( _yp2 );
			VAL_SET_ZERO( _yp3 );
			VAL_SET_ZERO( _yp4 );
			VAL_SET_ZERO( _yp5 );
			VAL_SET_ZERO( _yp6 );
			VAL_ASSIGN( _xp0, xpp[0] );
			VAL_ASSIGN( _xp1, xpp[1*incx] );
			VAL_ASSIGN( _xp2, xpp[2*incx] );
			VAL_ASSIGN( _xp3, xpp[3*incx] );
			VAL_ASSIGN( _xp4, xpp[4*incx] );
			VAL_ASSIGN( _xp5, xpp[5*incx] );
			VAL_ASSIGN( _xp6, xpp[6*incx] );
			VAL_MAC( _yp0, bval[0], _x0 );
			VAL_MAC( _yp1, bval[1], _x0 );
			VAL_MAC( _yp2, bval[2], _x0 );
			VAL_MAC( _yp3, bval[3], _x0 );
			VAL_MAC( _yp4, bval[4], _x0 );
			VAL_MAC( _yp5, bval[5], _x0 );
			VAL_MAC( _yp6, bval[6], _x0 );
			VAL_MAC( _yp0, bval[7], _x1 );
			VAL_MAC( _yp1, bval[8], _x1 );
			VAL_MAC( _yp2, bval[9], _x1 );
			VAL_MAC( _yp3, bval[10], _x1 );
			VAL_MAC( _yp4, bval[11], _x1 );
			VAL_MAC( _yp5, bval[12], _x1 );
			VAL_MAC( _yp6, bval[13], _x1 );
			VAL_MAC( _yp0, bval[14], _x2 );
			VAL_MAC( _yp1, bval[15], _x2 );
			VAL_MAC( _yp2, bval[16], _x2 );
			VAL_MAC( _yp3, bval[17], _x2 );
			VAL_MAC( _yp4, bval[18], _x2 );
			VAL_MAC( _yp5, bval[19], _x2 );
			VAL_MAC( _yp6, bval[20], _x2 );
			VAL_MAC_CONJ( _y0, bval[0], _xp0 );
			VAL_MAC_CONJ( _y1, bval[7], _xp0 );
			VAL_MAC_CONJ( _y2, bval[14], _xp0 );
			VAL_MAC_CONJ( _y0, bval[1], _xp1 );
			VAL_MAC_CONJ( _y1, bval[8], _xp1 );
			VAL_MAC_CONJ( _y2, bval[15], _xp1 );
			VAL_MAC_CONJ( _y0, bval[2], _xp2 );
			VAL_MAC_CONJ( _y1, bval[9], _xp2 );
			VAL_MAC_CONJ( _y2, bval[16], _xp2 );
			VAL_MAC_CONJ( _y0, bval[3], _xp3 );
			VAL_MAC_CONJ( _y1, bval[10], _xp3 );
			VAL_MAC_CONJ( _y2, bval[17], _xp3 );
			VAL_MAC_CONJ( _y0, bval[4], _xp4 );
			VAL_MAC_CONJ( _y1, bval[11], _xp4 );
			VAL_MAC_CONJ( _y2, bval[18], _xp4 );
			VAL_MAC_CONJ( _y0, bval[5], _xp5 );
			VAL_MAC_CONJ( _y1, bval[12], _xp5 );
			VAL_MAC_CONJ( _y2, bval[19], _xp5 );
			VAL_MAC_CONJ( _y0, bval[6], _xp6 );
			VAL_MAC_CONJ( _y1, bval[13], _xp6 );
			VAL_MAC_CONJ( _y2, bval[20], _xp6 );
			VAL_INC( ypp[0], _yp0 );
			VAL_INC( ypp[1*incy], _yp1 );
			VAL_INC( ypp[2*incy], _yp2 );
			VAL_INC( ypp[3*incy], _yp3 );
			VAL_INC( ypp[4*incy], _yp4 );
			VAL_INC( ypp[5*incy], _yp5 );
			VAL_INC( ypp[6*incy], _yp6 );
		}
		VAL_MAC( yp[0], alpha, _y0 );
		VAL_MAC( yp[1*incy], alpha, _y1 );
		VAL_MAC( yp[2*incy], alpha, _y2 );
	}
	/* Diagonal block multiply */
	yp = y + d0*incy;
	xp = x + d0*incx;
	for( I = 0; I < M; I++, bdiag += 3*3, yp += 3*incy, xp += 3*incx )
	{
		REGISTER oski_value_t _x0;
		REGISTER oski_value_t _x1;
		REGISTER oski_value_t _x2;
		REGISTER oski_value_t _y0;
		REGISTER oski_value_t _y1;
		REGISTER oski_value_t _y2;
		VAL_ASSIGN( _x0, xp[0] );
		VAL_ASSIGN( _x1, xp[1*incx] );
		VAL_ASSIGN( _x2, xp[2*incx] );
		VAL_SET_ZERO( _y0 );
		VAL_SET_ZERO( _y1 );
		VAL_SET_ZERO( _y2 );
		VAL_MAC_CONJ( _y0, bdiag[0], _x0 );
		VAL_MAC_CONJ( _y1, bdiag[3], _x0 );
		VAL_MAC_CONJ( _y2, bdiag[6], _x0 );
		VAL_MAC_CONJ( _y0, bdiag[1], _x1 );
		VAL_MAC_CONJ( _y1, bdiag[4], _x1 );
		VAL_MAC_CONJ( _y2, bdiag[7], _x1 );
		VAL_MAC_CONJ( _y0, bdiag[2], _x2 );
		VAL_MAC_CONJ( _y1, bdiag[5], _x2 );
		VAL_MAC_CONJ( _y2, bdiag[8], _x2 );
		VAL_MAC( yp[0], alpha, _y0 );
		VAL_MAC( yp[1*incy], alpha, _y1 );
		VAL_MAC( yp[2*incy], alpha, _y2 );
	}
}


#endif /* !IS_VAL_COMPLEX */


#if !IS_VAL_COMPLEX
/**
 *  \brief Matrix times single-vector multiply in the conj case;
 *  see SymmMatMult_v1().
 */
#define HermMatConjMult_v1 SymmMatMult_v1

#else /* IS_VAL_COMPLEX */


/**
 *  \brief Hermitian matrix times single-vector multiply in the conj case.
 */
static void
HermMatConjMult_v1( oski_index_t M, oski_index_t d0,
	const oski_index_t* bptr, const oski_index_t* bind,
	const oski_value_t* bval, const oski_value_t* bdiag,
	oski_value_t alpha, const oski_value_t* x, oski_index_t incx,
	oski_value_t* y, oski_index_t incy )
{
	if( incx == 1 ) {
		if( incy == 1 ) {
			MBCSR_HermMatConjMult_v1_aX_b1_xs1_ys1( M, d0,
				bptr, bind, bval, bdiag, alpha, x, y );
		} else { /* general incy */
			MBCSR_HermMatConjMult_v1_aX_b1_xs1_ysX( M, d0,
				bptr, bind, bval, bdiag, alpha, x, y, incy );
		}
	} else { /* general incx */
		if( incy == 1 ) {
			MBCSR_HermMatConjMult_v1_aX_b1_xsX_ys1( M, d0,
				bptr, bind, bval, bdiag, alpha, x, incx, y );
		} else { /* general incy */
			MBCSR_HermMatConjMult_v1_aX_b1_xsX_ysX( M, d0,
				bptr, bind, bval, bdiag, alpha, x, incx, y, incy );
		}
	}
}


#endif /* !IS_VAL_COMPLEX */


#if !IS_VAL_COMPLEX
/**
 *  \brief See SymmMatMult().
 */
#define HermMatConjMult SymmMatMult

#else /* IS_VAL_COMPLEX */



/**
 *  \brief Computes
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$\mathrm{op}(A) = \bar{A}\f$, on the fully blocked
 *  portion of \f$A\f$.
 */
static int
HermMatConjMult( const oski_submatMBCSR_t* A,
	oski_value_t alpha, const oski_vecview_t x_view,
	oski_vecview_t y_view )
{
	oski_index_t j; /* column number */
	const oski_value_t* xpj; /* X(:, j) */
	oski_value_t* ypj; /* Y(:, j) */

	assert( A->r == 3 );
	assert( A->c == 7 );

	for( j = 0, xpj = x_view->val, ypj = y_view->val;
		j < x_view->num_cols;
		j++, xpj += x_view->colinc, ypj += y_view->colinc )
	{
		HermMatConjMult_v1( A->num_block_rows, A->offset,
			A->bptr, A->bind, A->bval, A->bdiag,
			alpha, xpj, x_view->rowinc, ypj, y_view->rowinc );
	}

	return 0;
}


#endif /* !IS_VAL_COMPLEX */


#if defined(DO_NAME_MANGLING)
/** Mangled name for primary exported symbol */
#define SymmSubmatReprMult MANGLE_MOD_(SymmSubmatReprMult_3x7)
#endif

/**
 *  \brief Computes
 *  \f$y \leftarrow y + \alpha\cdot\mathrm{op}(A)\cdot x\f$,
 *  where \f$A\f$ is stored in 3x7 MBCSR format and
 *  either \f = A^T\f$ or \f = \bar{A}^T\f$.
 *
 *  Set is_herm to a non-zero value if \f\f$ is Hermitian, or
 *  0 if it is symmetric.
 */
int
SymmSubmatReprMult( const oski_submatMBCSR_t* A, int is_herm,
	oski_matop_t opA,
	oski_value_t alpha, const oski_vecview_t x_view,
	oski_vecview_t y_view )
{
	int err;

	if( is_herm ) {
		switch( opA )
		{
			case OP_NORMAL:
			case OP_CONJ_TRANS:
				err = HermMatMult( A, alpha, x_view, y_view );
				break;
			case OP_CONJ:
			case OP_TRANS:
				err = HermMatConjMult( A, alpha, x_view, y_view );
				break;
			default:
				OSKI_ERR_BAD_MATOP( SubmatReprMult, 3, opA );
				err = ERR_BAD_ARG;
		}
	} else { /* is symmetric, but not Hermitian (!is_herm) */
		switch( opA )
		{
			case OP_NORMAL:
			case OP_TRANS:
				err = SymmMatMult( A, alpha, x_view, y_view );
				break;
			case OP_CONJ_TRANS:
			case OP_CONJ:
				err = SymmMatConjMult( A, alpha, x_view, y_view );
				break;
			default:
				OSKI_ERR_BAD_MATOP( SubmatReprMult, 3, opA );
				err = ERR_BAD_ARG;
		}
	}

	return err;
}


/* eof */
