/*-
 * Copyright (c) 2008-2013
 *	Jeffrey Allen Neitzel <jan (at) v6shell (dot) org>.
 *	All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY JEFFREY ALLEN NEITZEL ``AS IS'', AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL JEFFREY ALLEN NEITZEL BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *	@(#)$Id: be5de9d65fd59b688dcb373f353c3b7377284fdb $
 */
/*
 *	Derived from:
 *		- /usr/src/lib/libc/stdlib/strtol.3
 *			$NetBSD: strtol.3,v 1.22 2003/09/08 17:54:33 wiz Exp $
 */
/*-
 * Copyright (c) 1990, 1991, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Chris Torek and the American National Standards Committee X3,
 * on Information Processing Systems.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)strtol.3	8.1 (Berkeley) 6/4/93
 */

#include "defs.h"
#include "err.h"
#include "strtoint.h"

/*
 * Convert a string value into an int integer value.
 */
bool
strtoint(const char *string, int *integer)
{
	long lint;
	char *lintbad;
	const char *name;

	name = getmyname();

	/*
	 * Fail if the specified string or integer is (or points to) NULL.
	 */
	errno = 0;
	if (string == NULL || integer == NULL) {
		errno = EINVAL;
		fd_print(FD2, FMT3S, name, "strtoint", strerror(errno));
		if (integer != NULL)
			*integer = 0;
		return false;
	}

	lint = strtol(string, &lintbad, 10);
	if (*string == EOS || *lintbad != EOS) {
		errno = EINVAL;
		if (EQUAL(name, "if"))
			fd_print(FD2, FMT3S, name, string, ERR_NOTINTEGER);
		*integer = 0;
		return false;
	}
	if ((errno == ERANGE  && (lint == LONG_MAX || lint == LONG_MIN)) ||
	    (lint  >  INT_MAX ||  lint <  INT_MIN)) {
		errno = ERANGE;
		if (EQUAL(name, "if"))
			fd_print(FD2, FMT3S, name, string, ERR_RANGE);
		*integer = 0;
		return false;
	}
	*integer = (int)lint;
	return true;
}
