/***************************************************************************
  tag: FMTC  Tue Mar 11 21:49:22 CET 2008  AttributesI.cpp

                        AttributesI.cpp -  description
                           -------------------
    begin                : Tue March 11 2008
    copyright            : (C) 2008 FMTC
    email                : peter.soetens@fmtc.be

 ***************************************************************************
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU General Public                   *
 *   License as published by the Free Software Foundation;                 *
 *   version 2 of the License.                                             *
 *                                                                         *
 *   As a special exception, you may use this file as part of a free       *
 *   software library without restriction.  Specifically, if other files   *
 *   instantiate templates or use macros or inline functions from this     *
 *   file, or you compile this file and link it with other files to        *
 *   produce an executable, this file does not by itself cause the         *
 *   resulting executable to be covered by the GNU General Public          *
 *   License.  This exception does not however invalidate any other        *
 *   reasons why the executable file might be covered by the GNU General   *
 *   Public License.                                                       *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place,                                    *
 *   Suite 330, Boston, MA  02111-1307  USA                                *
 *                                                                         *
 ***************************************************************************/


// -*- C++ -*-
//
// $Id$

// ****  Code generated by the The ACE ORB (TAO) IDL Compiler ****
// TAO and the TAO IDL Compiler have been developed by:
//       Center for Distributed Object Computing
//       Washington University
//       St. Louis, MO
//       USA
//       http://www.cs.wustl.edu/~schmidt/doc-center.html
// and
//       Distributed Object Computing Laboratory
//       University of California at Irvine
//       Irvine, CA
//       USA
//       http://doc.ece.uci.edu/
// and
//       Institute for Software Integrated Systems
//       Vanderbilt University
//       Nashville, TN
//       USA
//       http://www.isis.vanderbilt.edu/
//
// Information about TAO is available at:
//     http://www.cs.wustl.edu/~schmidt/TAO.html

// TAO_IDL - Generated from
// be/be_codegen.cpp:910

#include "AttributesI.h"
#include "AttributesC.h"
#include "CorbaLib.hpp"
#include <vector>
#include <PropertyBag.hpp>
#include <Property.hpp>




using namespace RTT;
using namespace RTT::Corba;
using namespace std;

// Implementation skeleton constructor
Orocos_AttributeInterface_i::Orocos_AttributeInterface_i (AttributeRepository* ar, PortableServer::POA_ptr the_poa)
    :mar (ar), mbag(0), mpoa( PortableServer::POA::_duplicate(the_poa))
{
}

Orocos_AttributeInterface_i::Orocos_AttributeInterface_i (PropertyBag* bag, PortableServer::POA_ptr the_poa)
    :mar (0), mbag(bag), mpoa( PortableServer::POA::_duplicate(the_poa))
{
}

// Implementation skeleton destructor
Orocos_AttributeInterface_i::~Orocos_AttributeInterface_i (void)
{
    // if no AttributeRepository, it must have been a PropertyBag.
    if ( mar == 0 )
        delete mbag;
}

::RTT::Corba::AttributeInterface::AttributeNames * Orocos_AttributeInterface_i::getAttributeList (

  )
  ACE_THROW_SPEC ((
    CORBA::SystemException
  ))
{
    ::RTT::Corba::AttributeInterface::AttributeNames_var ret = new ::RTT::Corba::AttributeInterface::AttributeNames();
    if ( !mar )
        return ret._retn();
    vector<string> names = mar->names();
    ret->length( names.size() );
    for(size_t i=0; i != names.size(); ++i)
        ret[i] = CORBA::string_dup( names[i].c_str() );
    return ret._retn();
}

::RTT::Corba::AttributeInterface::PropertyNames * Orocos_AttributeInterface_i::getPropertyList (

  )
  ACE_THROW_SPEC ((
    CORBA::SystemException
  ))
{
  // Add your implementation here
    ::RTT::Corba::AttributeInterface::PropertyNames_var ret = new ::RTT::Corba::AttributeInterface::PropertyNames();
    if (mar)
        mbag = mar->properties(); // leave this here to get latest propertybag.
    if (mbag == 0)
        return ret._retn();
    ret->length( mbag->size() );
    PropertyBag::const_iterator it = mbag->getProperties().begin();
    size_t index = 0;
    for( ; it != mbag->getProperties().end(); ++it, ++index) {
        ::RTT::Corba::AttributeInterface::Property prop;
        prop.name = CORBA::string_dup( (*it)->getName().c_str() );
        prop.description = CORBA::string_dup( (*it)->getDescription().c_str() );
        ret[index] = prop;
    }
    return ret._retn();
}

::RTT::Corba::Expression_ptr Orocos_AttributeInterface_i::getAttribute (
    const char * name
  )
  ACE_THROW_SPEC ((
    CORBA::SystemException
  ))
{
    if ( !mar || !mar->hasAttribute( string(name) ) )
        return ::RTT::Corba::Expression::_nil();
    return (::RTT::Corba::Expression_ptr)mar->getValue( string(name) )->getDataSource()->server(ORO_CORBA_PROTOCOL_ID, (void*) mpoa.in() );
}

::RTT::Corba::Expression_ptr Orocos_AttributeInterface_i::getProperty (
    const char * name
  )
  ACE_THROW_SPEC ((
    CORBA::SystemException
  ))
{
    if (mar)
        mbag = mar->properties(); // leave this here to get latest propertybag.
    if ( mbag ==0 || !mbag->find( string(name) ) )
        return ::RTT::Corba::Expression::_nil();
    DataSourceBase::shared_ptr ds = mbag->find( string(name) )->getDataSource();
    return static_cast<Expression_ptr>(ds->server(ORO_CORBA_PROTOCOL_ID, (void*)mpoa.in() ));
}


