       subroutine   ocea

c - to vary the number of quadratures
      include "paramdef.inc"
      integer nquad
      common /num_quad/ nquad
      real ph,qh,uh
      common /sixs_aerbas/ ph(20,nqmax_p),qh(20,nqmax_p),uh(20,nqmax_p)
      real phr(20,nqdef_p),qhr(20,nqdef_p),uhr(20,nqdef_p)
c - to vary the number of quadratures
      real ex,sc,asy,vi
      common /sixs_coef/ ex(4,20),sc(4,20),asy(4,20),vi(4)
      real ex_m(20),sc_m(20),asy_m(20),vi_m
       integer i,j

c Oceanic model
c Parameters and refractive indices - G.A. d'Almeida, 'Atmospheric
c aerosols. Global climatology and radiative characteristics', 1991.
c Extinction coefficients are calculated in km-1

c*************** MIE (asy) ******************
      data (asy_m(j),j=1,20)/
     a 0.790,0.787,0.785,0.784,0.782,0.784,0.781,0.784,0.781,0.780,
     a 0.780,0.779,0.779,0.778,0.779,0.785,0.787,0.792,0.816,0.749/
c*************** MIE (ext&sca) ******************
        data (ex_m(j),sc_m(j),j=1,20) /
     a 0.3492134E+01,0.3492100E+01,0.3555835E+01,0.3555833E+01,
     a 0.3577440E+01,0.3577438E+01,0.3601985E+01,0.3601983E+01,
     a 0.3625801E+01,0.3625799E+01,0.3628089E+01,0.3628088E+01,
     a 0.3658286E+01,0.3658284E+01,0.3658747E+01,0.3658746E+01,
     a 0.3696527E+01,0.3696526E+01,0.3730609E+01,0.3730607E+01,
     a 0.3736655E+01,0.3736650E+01,0.3763560E+01,0.3763552E+01,
     a 0.3776731E+01,0.3774958E+01,0.3813161E+01,0.3809129E+01,
     a 0.3830686E+01,0.3805399E+01,0.3729777E+01,0.3662509E+01,
     a 0.3675602E+01,0.3619132E+01,0.3516177E+01,0.3413872E+01,
     a 0.3257454E+01,0.2935607E+01,0.2827842E+01,0.2749985E+01 /
c************** MIE (phase fun ph) ***************
        DATA ((PHR(i,j),j=1,83),i= 1, 1)/
     *0.8426E+00,0.6434E+00,0.5956E+00,0.5002E+00,0.4105E+00,
     *0.3836E+00,0.3575E+00,0.3330E+00,0.3124E+00,0.3045E+00,
     *0.2944E+00,0.3130E+00,0.3192E+00,0.3212E+00,0.3219E+00,
     *0.2720E+00,0.1896E+00,0.1406E+00,0.1112E+00,0.8642E-01,
     *0.7607E-01,0.6522E-01,0.5889E-01,0.5396E-01,0.5403E-01,
     *0.5099E-01,0.5312E-01,0.5451E-01,0.5772E-01,0.6023E-01,
     *0.6418E-01,0.6527E-01,0.6742E-01,0.7013E-01,0.7259E-01,
     *0.7394E-01,0.7478E-01,0.7715E-01,0.8478E-01,0.8979E-01,
     *0.9464E-01,0.9427E-01,0.1028E+00,0.1102E+00,0.1198E+00,
     *0.1280E+00,0.1445E+00,0.1604E+00,0.1768E+00,0.1994E+00,
     *0.2309E+00,0.2565E+00,0.2911E+00,0.3180E+00,0.3703E+00,
     *0.4197E+00,0.4777E+00,0.5351E+00,0.6305E+00,0.6948E+00,
     *0.8032E+00,0.9123E+00,0.1045E+01,0.1202E+01,0.1350E+01,
     *0.1547E+01,0.1746E+01,0.1991E+01,0.2292E+01,0.2558E+01,
     *0.2934E+01,0.3345E+01,0.3825E+01,0.4451E+01,0.5155E+01,
     *0.6128E+01,0.7764E+01,0.1050E+02,0.1594E+02,0.2950E+02,
     *0.7409E+02,0.3218E+03,0.1844E+04 /
        DATA ((PHR(i,j),j=1,83),i= 2, 2)/
     *0.7371E+00,0.6009E+00,0.5322E+00,0.4548E+00,0.4231E+00,
     *0.4052E+00,0.3680E+00,0.3354E+00,0.3138E+00,0.3088E+00,
     *0.3007E+00,0.2947E+00,0.3047E+00,0.3135E+00,0.3072E+00,
     *0.2729E+00,0.2174E+00,0.1588E+00,0.1248E+00,0.1018E+00,
     *0.8348E-01,0.7350E-01,0.6763E-01,0.6191E-01,0.5850E-01,
     *0.5710E-01,0.5775E-01,0.6092E-01,0.6167E-01,0.6361E-01,
     *0.6903E-01,0.7096E-01,0.7184E-01,0.7387E-01,0.7345E-01,
     *0.7282E-01,0.7554E-01,0.8142E-01,0.8376E-01,0.8866E-01,
     *0.9809E-01,0.1049E+00,0.1051E+00,0.1109E+00,0.1254E+00,
     *0.1378E+00,0.1500E+00,0.1666E+00,0.1895E+00,0.2086E+00,
     *0.2290E+00,0.2618E+00,0.3000E+00,0.3330E+00,0.3761E+00,
     *0.4294E+00,0.4934E+00,0.5513E+00,0.6135E+00,0.7221E+00,
     *0.8242E+00,0.9168E+00,0.1052E+01,0.1181E+01,0.1371E+01,
     *0.1555E+01,0.1761E+01,0.1987E+01,0.2256E+01,0.2614E+01,
     *0.2954E+01,0.3396E+01,0.3880E+01,0.4503E+01,0.5402E+01,
     *0.6516E+01,0.8200E+01,0.1111E+02,0.1688E+02,0.3112E+02,
     *0.7567E+02,0.2999E+03,0.1405E+04 /
        DATA ((PHR(i,j),j=1,83),i= 3, 3)/
     *0.8416E+00,0.6946E+00,0.5479E+00,0.4787E+00,0.4314E+00,
     *0.4126E+00,0.3866E+00,0.3507E+00,0.3253E+00,0.3055E+00,
     *0.3074E+00,0.3016E+00,0.3081E+00,0.3114E+00,0.2991E+00,
     *0.2695E+00,0.2187E+00,0.1602E+00,0.1267E+00,0.1009E+00,
     *0.8076E-01,0.7510E-01,0.6945E-01,0.6487E-01,0.6009E-01,
     *0.6020E-01,0.5861E-01,0.5718E-01,0.6273E-01,0.6565E-01,
     *0.6835E-01,0.7368E-01,0.7535E-01,0.7684E-01,0.7894E-01,
     *0.8157E-01,0.8408E-01,0.8347E-01,0.8672E-01,0.9469E-01,
     *0.9861E-01,0.1042E+00,0.1064E+00,0.1161E+00,0.1262E+00,
     *0.1420E+00,0.1573E+00,0.1684E+00,0.1934E+00,0.2146E+00,
     *0.2365E+00,0.2647E+00,0.2991E+00,0.3443E+00,0.3853E+00,
     *0.4286E+00,0.4908E+00,0.5560E+00,0.6274E+00,0.7126E+00,
     *0.8060E+00,0.9229E+00,0.1045E+01,0.1180E+01,0.1339E+01,
     *0.1539E+01,0.1746E+01,0.2000E+01,0.2238E+01,0.2586E+01,
     *0.2990E+01,0.3410E+01,0.3942E+01,0.4567E+01,0.5412E+01,
     *0.6598E+01,0.8306E+01,0.1117E+02,0.1722E+02,0.3130E+02,
     *0.7572E+02,0.2951E+03,0.1323E+04 /
        DATA ((PHR(i,j),j=1,83),i= 4, 4)/
     *0.7122E+00,0.6039E+00,0.5204E+00,0.4514E+00,0.4316E+00,
     *0.4104E+00,0.3784E+00,0.3412E+00,0.3191E+00,0.3072E+00,
     *0.3039E+00,0.2959E+00,0.3044E+00,0.3166E+00,0.2903E+00,
     *0.2685E+00,0.2197E+00,0.1659E+00,0.1316E+00,0.1077E+00,
     *0.8814E-01,0.8054E-01,0.7234E-01,0.6789E-01,0.6153E-01,
     *0.6069E-01,0.6230E-01,0.6139E-01,0.6629E-01,0.6950E-01,
     *0.7217E-01,0.7294E-01,0.7528E-01,0.7636E-01,0.7960E-01,
     *0.7800E-01,0.8043E-01,0.8519E-01,0.8747E-01,0.9079E-01,
     *0.1023E+00,0.1104E+00,0.1104E+00,0.1146E+00,0.1316E+00,
     *0.1436E+00,0.1569E+00,0.1720E+00,0.1958E+00,0.2123E+00,
     *0.2367E+00,0.2655E+00,0.3030E+00,0.3428E+00,0.3839E+00,
     *0.4325E+00,0.4958E+00,0.5588E+00,0.6227E+00,0.7247E+00,
     *0.8165E+00,0.9301E+00,0.1054E+01,0.1183E+01,0.1363E+01,
     *0.1559E+01,0.1758E+01,0.2001E+01,0.2272E+01,0.2638E+01,
     *0.3016E+01,0.3460E+01,0.3991E+01,0.4649E+01,0.5551E+01,
     *0.6753E+01,0.8564E+01,0.1164E+02,0.1769E+02,0.3205E+02,
     *0.7577E+02,0.2820E+03,0.1138E+04 /
        DATA ((PHR(i,j),j=1,83),i= 5, 5)/
     *0.8664E+00,0.6659E+00,0.5552E+00,0.5141E+00,0.4301E+00,
     *0.4072E+00,0.3892E+00,0.3549E+00,0.3279E+00,0.3039E+00,
     *0.3054E+00,0.2999E+00,0.3095E+00,0.3093E+00,0.2942E+00,
     *0.2658E+00,0.2103E+00,0.1651E+00,0.1318E+00,0.1062E+00,
     *0.9173E-01,0.8102E-01,0.7050E-01,0.6683E-01,0.6425E-01,
     *0.6434E-01,0.6605E-01,0.6611E-01,0.6616E-01,0.6686E-01,
     *0.6866E-01,0.7485E-01,0.7979E-01,0.7674E-01,0.8148E-01,
     *0.8750E-01,0.8774E-01,0.8990E-01,0.9508E-01,0.1010E+00,
     *0.1022E+00,0.1041E+00,0.1135E+00,0.1254E+00,0.1323E+00,
     *0.1444E+00,0.1635E+00,0.1830E+00,0.1944E+00,0.2175E+00,
     *0.2535E+00,0.2743E+00,0.3041E+00,0.3488E+00,0.3902E+00,
     *0.4369E+00,0.4909E+00,0.5575E+00,0.6392E+00,0.7165E+00,
     *0.8007E+00,0.9262E+00,0.1051E+01,0.1199E+01,0.1342E+01,
     *0.1539E+01,0.1773E+01,0.2018E+01,0.2313E+01,0.2634E+01,
     *0.3033E+01,0.3513E+01,0.4088E+01,0.4782E+01,0.5625E+01,
     *0.6865E+01,0.8698E+01,0.1193E+02,0.1817E+02,0.3233E+02,
     *0.7534E+02,0.2714E+03,0.1019E+04 /
        DATA ((PHR(i,j),j=1,83),i= 6, 6)/
     *0.6608E+00,0.5459E+00,0.5048E+00,0.4428E+00,0.4113E+00,
     *0.3873E+00,0.3655E+00,0.3399E+00,0.3196E+00,0.3124E+00,
     *0.2971E+00,0.2926E+00,0.2948E+00,0.2983E+00,0.2961E+00,
     *0.2627E+00,0.2145E+00,0.1668E+00,0.1355E+00,0.1118E+00,
     *0.9367E-01,0.8208E-01,0.7585E-01,0.7008E-01,0.6669E-01,
     *0.6452E-01,0.6434E-01,0.6681E-01,0.6584E-01,0.6769E-01,
     *0.7257E-01,0.7321E-01,0.7348E-01,0.7569E-01,0.7601E-01,
     *0.7629E-01,0.8110E-01,0.8746E-01,0.8929E-01,0.9444E-01,
     *0.1054E+00,0.1112E+00,0.1103E+00,0.1186E+00,0.1324E+00,
     *0.1464E+00,0.1555E+00,0.1731E+00,0.1950E+00,0.2167E+00,
     *0.2335E+00,0.2678E+00,0.3054E+00,0.3386E+00,0.3825E+00,
     *0.4416E+00,0.4964E+00,0.5581E+00,0.6265E+00,0.7284E+00,
     *0.8331E+00,0.9285E+00,0.1064E+01,0.1209E+01,0.1394E+01,
     *0.1575E+01,0.1804E+01,0.2045E+01,0.2329E+01,0.2699E+01,
     *0.3079E+01,0.3538E+01,0.4056E+01,0.4761E+01,0.5761E+01,
     *0.6998E+01,0.8866E+01,0.1214E+02,0.1836E+02,0.3293E+02,
     *0.7563E+02,0.2628E+03,0.9417E+03 /
        DATA ((PHR(i,j),j=1,83),i= 7, 7)/
     *0.6706E+00,0.5495E+00,0.4882E+00,0.4283E+00,0.4208E+00,
     *0.4096E+00,0.3788E+00,0.3436E+00,0.3238E+00,0.3103E+00,
     *0.3053E+00,0.2946E+00,0.2988E+00,0.3058E+00,0.2862E+00,
     *0.2616E+00,0.2177E+00,0.1697E+00,0.1372E+00,0.1158E+00,
     *0.9579E-01,0.8666E-01,0.7760E-01,0.7292E-01,0.6827E-01,
     *0.6565E-01,0.6730E-01,0.6750E-01,0.6969E-01,0.7152E-01,
     *0.7437E-01,0.7546E-01,0.7707E-01,0.7993E-01,0.8173E-01,
     *0.8010E-01,0.8452E-01,0.8860E-01,0.9152E-01,0.9693E-01,
     *0.1069E+00,0.1138E+00,0.1153E+00,0.1207E+00,0.1364E+00,
     *0.1482E+00,0.1633E+00,0.1778E+00,0.2021E+00,0.2207E+00,
     *0.2427E+00,0.2733E+00,0.3111E+00,0.3492E+00,0.3912E+00,
     *0.4417E+00,0.5052E+00,0.5681E+00,0.6322E+00,0.7343E+00,
     *0.8314E+00,0.9413E+00,0.1068E+01,0.1201E+01,0.1388E+01,
     *0.1587E+01,0.1789E+01,0.2039E+01,0.2325E+01,0.2691E+01,
     *0.3082E+01,0.3564E+01,0.4128E+01,0.4829E+01,0.5822E+01,
     *0.7147E+01,0.9083E+01,0.1239E+02,0.1871E+02,0.3325E+02,
     *0.7514E+02,0.2533E+03,0.8424E+03 /
        DATA ((PHR(i,j),j=1,83),i= 8, 8)/
     *0.5889E+00,0.4993E+00,0.4727E+00,0.4128E+00,0.3737E+00,
     *0.3600E+00,0.3534E+00,0.3382E+00,0.3167E+00,0.2988E+00,
     *0.2874E+00,0.2958E+00,0.2978E+00,0.2869E+00,0.2834E+00,
     *0.2525E+00,0.2030E+00,0.1663E+00,0.1363E+00,0.1144E+00,
     *0.1005E+00,0.8513E-01,0.7800E-01,0.7446E-01,0.7029E-01,
     *0.6724E-01,0.6657E-01,0.6844E-01,0.6837E-01,0.7044E-01,
     *0.7275E-01,0.7142E-01,0.7433E-01,0.7682E-01,0.7981E-01,
     *0.8221E-01,0.8415E-01,0.8919E-01,0.9547E-01,0.1007E+00,
     *0.1060E+00,0.1093E+00,0.1150E+00,0.1228E+00,0.1337E+00,
     *0.1433E+00,0.1590E+00,0.1757E+00,0.1947E+00,0.2150E+00,
     *0.2445E+00,0.2736E+00,0.3074E+00,0.3371E+00,0.3863E+00,
     *0.4432E+00,0.4945E+00,0.5606E+00,0.6452E+00,0.7256E+00,
     *0.8269E+00,0.9382E+00,0.1074E+01,0.1232E+01,0.1402E+01,
     *0.1590E+01,0.1825E+01,0.2099E+01,0.2415E+01,0.2751E+01,
     *0.3163E+01,0.3664E+01,0.4266E+01,0.5023E+01,0.5956E+01,
     *0.7270E+01,0.9373E+01,0.1285E+02,0.1924E+02,0.3383E+02,
     *0.7427E+02,0.2390E+03,0.7401E+03 /
        DATA ((PHR(i,j),j=1,83),i= 9, 9)/
     *0.6593E+00,0.5301E+00,0.4588E+00,0.4268E+00,0.3862E+00,
     *0.3848E+00,0.3614E+00,0.3344E+00,0.3203E+00,0.2993E+00,
     *0.2957E+00,0.2936E+00,0.2870E+00,0.2902E+00,0.2796E+00,
     *0.2515E+00,0.2033E+00,0.1712E+00,0.1405E+00,0.1173E+00,
     *0.1038E+00,0.9074E-01,0.8075E-01,0.7543E-01,0.7246E-01,
     *0.7100E-01,0.7184E-01,0.7128E-01,0.7116E-01,0.7401E-01,
     *0.7320E-01,0.7674E-01,0.7990E-01,0.7918E-01,0.8244E-01,
     *0.8828E-01,0.9053E-01,0.9220E-01,0.1005E+00,0.1051E+00,
     *0.1076E+00,0.1097E+00,0.1169E+00,0.1289E+00,0.1374E+00,
     *0.1468E+00,0.1666E+00,0.1841E+00,0.1985E+00,0.2243E+00,
     *0.2565E+00,0.2809E+00,0.3079E+00,0.3524E+00,0.3968E+00,
     *0.4453E+00,0.4967E+00,0.5700E+00,0.6483E+00,0.7255E+00,
     *0.8248E+00,0.9349E+00,0.1071E+01,0.1223E+01,0.1387E+01,
     *0.1579E+01,0.1822E+01,0.2107E+01,0.2411E+01,0.2766E+01,
     *0.3203E+01,0.3713E+01,0.4361E+01,0.5136E+01,0.6092E+01,
     *0.7494E+01,0.9599E+01,0.1315E+02,0.1974E+02,0.3410E+02,
     *0.7318E+02,0.2264E+03,0.6436E+03 /
        DATA ((PHR(i,j),j=1,83),i=10,10)/
     *0.6636E+00,0.5313E+00,0.4331E+00,0.3833E+00,0.3809E+00,
     *0.3787E+00,0.3648E+00,0.3414E+00,0.3151E+00,0.3003E+00,
     *0.2909E+00,0.2844E+00,0.2831E+00,0.2779E+00,0.2661E+00,
     *0.2450E+00,0.2168E+00,0.1755E+00,0.1450E+00,0.1210E+00,
     *0.1048E+00,0.9460E-01,0.8601E-01,0.7905E-01,0.7576E-01,
     *0.7431E-01,0.7193E-01,0.7079E-01,0.7205E-01,0.7254E-01,
     *0.7474E-01,0.7882E-01,0.8157E-01,0.8212E-01,0.8465E-01,
     *0.8860E-01,0.9026E-01,0.9384E-01,0.9784E-01,0.1040E+00,
     *0.1103E+00,0.1144E+00,0.1176E+00,0.1296E+00,0.1382E+00,
     *0.1531E+00,0.1667E+00,0.1850E+00,0.2033E+00,0.2270E+00,
     *0.2523E+00,0.2788E+00,0.3141E+00,0.3554E+00,0.3984E+00,
     *0.4420E+00,0.5030E+00,0.5699E+00,0.6515E+00,0.7292E+00,
     *0.8238E+00,0.9585E+00,0.1080E+01,0.1234E+01,0.1399E+01,
     *0.1618E+01,0.1845E+01,0.2119E+01,0.2428E+01,0.2781E+01,
     *0.3241E+01,0.3765E+01,0.4413E+01,0.5196E+01,0.6228E+01,
     *0.7736E+01,0.9943E+01,0.1346E+02,0.2017E+02,0.3442E+02,
     *0.7217E+02,0.2140E+03,0.5606E+03 /
        DATA ((PHR(i,j),j=1,83),i=11,11)/
     *0.5688E+00,0.4824E+00,0.4236E+00,0.3780E+00,0.3504E+00,
     *0.3637E+00,0.3511E+00,0.3260E+00,0.3112E+00,0.2946E+00,
     *0.2833E+00,0.2884E+00,0.2804E+00,0.2755E+00,0.2714E+00,
     *0.2430E+00,0.2001E+00,0.1722E+00,0.1431E+00,0.1230E+00,
     *0.1096E+00,0.9526E-01,0.8662E-01,0.7964E-01,0.7711E-01,
     *0.7407E-01,0.7372E-01,0.7438E-01,0.7378E-01,0.7485E-01,
     *0.7721E-01,0.7781E-01,0.7875E-01,0.8057E-01,0.8385E-01,
     *0.8722E-01,0.9066E-01,0.9366E-01,0.1009E+00,0.1071E+00,
     *0.1108E+00,0.1122E+00,0.1187E+00,0.1310E+00,0.1398E+00,
     *0.1494E+00,0.1671E+00,0.1843E+00,0.2007E+00,0.2241E+00,
     *0.2540E+00,0.2828E+00,0.3126E+00,0.3482E+00,0.4003E+00,
     *0.4489E+00,0.5024E+00,0.5708E+00,0.6544E+00,0.7288E+00,
     *0.8358E+00,0.9476E+00,0.1088E+01,0.1246E+01,0.1417E+01,
     *0.1612E+01,0.1864E+01,0.2157E+01,0.2476E+01,0.2846E+01,
     *0.3314E+01,0.3838E+01,0.4520E+01,0.5353E+01,0.6394E+01,
     *0.7848E+01,0.1010E+02,0.1382E+02,0.2050E+02,0.3463E+02,
     *0.7096E+02,0.2021E+03,0.5002E+03 /
        DATA ((PHR(i,j),j=1,83),i=12,12)/
     *0.5587E+00,0.4718E+00,0.4102E+00,0.3746E+00,0.3706E+00,
     *0.3749E+00,0.3569E+00,0.3300E+00,0.3079E+00,0.3001E+00,
     *0.2901E+00,0.2808E+00,0.2791E+00,0.2726E+00,0.2647E+00,
     *0.2433E+00,0.2095E+00,0.1725E+00,0.1478E+00,0.1257E+00,
     *0.1080E+00,0.9734E-01,0.8935E-01,0.8281E-01,0.7891E-01,
     *0.7586E-01,0.7496E-01,0.7630E-01,0.7527E-01,0.7573E-01,
     *0.7931E-01,0.7880E-01,0.8026E-01,0.8262E-01,0.8354E-01,
     *0.8508E-01,0.8891E-01,0.9556E-01,0.9839E-01,0.1037E+00,
     *0.1147E+00,0.1204E+00,0.1221E+00,0.1284E+00,0.1421E+00,
     *0.1557E+00,0.1677E+00,0.1858E+00,0.2075E+00,0.2279E+00,
     *0.2495E+00,0.2798E+00,0.3195E+00,0.3524E+00,0.3936E+00,
     *0.4496E+00,0.5095E+00,0.5705E+00,0.6412E+00,0.7449E+00,
     *0.8497E+00,0.9532E+00,0.1091E+01,0.1244E+01,0.1438E+01,
     *0.1647E+01,0.1877E+01,0.2148E+01,0.2474E+01,0.2871E+01,
     *0.3302E+01,0.3850E+01,0.4476E+01,0.5312E+01,0.6488E+01,
     *0.8012E+01,0.1024E+02,0.1390E+02,0.2057E+02,0.3470E+02,
     *0.7086E+02,0.1962E+03,0.4667E+03 /
        DATA ((PHR(i,j),j=1,83),i=13,13)/
     *0.5378E+00,0.4466E+00,0.3985E+00,0.3581E+00,0.3376E+00,
     *0.3474E+00,0.3401E+00,0.3225E+00,0.3044E+00,0.2916E+00,
     *0.2768E+00,0.2782E+00,0.2727E+00,0.2645E+00,0.2585E+00,
     *0.2334E+00,0.1961E+00,0.1692E+00,0.1461E+00,0.1251E+00,
     *0.1120E+00,0.9955E-01,0.9025E-01,0.8358E-01,0.8109E-01,
     *0.7670E-01,0.7662E-01,0.7581E-01,0.7548E-01,0.7713E-01,
     *0.7839E-01,0.7919E-01,0.8084E-01,0.8268E-01,0.8594E-01,
     *0.8982E-01,0.9255E-01,0.9571E-01,0.1033E+00,0.1086E+00,
     *0.1140E+00,0.1156E+00,0.1217E+00,0.1332E+00,0.1441E+00,
     *0.1531E+00,0.1697E+00,0.1881E+00,0.2042E+00,0.2257E+00,
     *0.2573E+00,0.2852E+00,0.3145E+00,0.3505E+00,0.4015E+00,
     *0.4500E+00,0.5068E+00,0.5702E+00,0.6587E+00,0.7363E+00,
     *0.8402E+00,0.9570E+00,0.1104E+01,0.1260E+01,0.1439E+01,
     *0.1647E+01,0.1900E+01,0.2198E+01,0.2542E+01,0.2920E+01,
     *0.3408E+01,0.3980E+01,0.4681E+01,0.5572E+01,0.6685E+01,
     *0.8232E+01,0.1060E+02,0.1442E+02,0.2112E+02,0.3485E+02,
     *0.6831E+02,0.1793E+03,0.3911E+03 /
        DATA ((PHR(i,j),j=1,83),i=14,14)/
     *0.5168E+00,0.4308E+00,0.3776E+00,0.3454E+00,0.3293E+00,
     *0.3456E+00,0.3340E+00,0.3164E+00,0.3057E+00,0.2831E+00,
     *0.2749E+00,0.2694E+00,0.2609E+00,0.2594E+00,0.2462E+00,
     *0.2234E+00,0.1933E+00,0.1700E+00,0.1469E+00,0.1276E+00,
     *0.1152E+00,0.1024E+00,0.9267E-01,0.8647E-01,0.8277E-01,
     *0.8042E-01,0.7934E-01,0.7891E-01,0.7803E-01,0.7916E-01,
     *0.7961E-01,0.8182E-01,0.8377E-01,0.8415E-01,0.8830E-01,
     *0.9301E-01,0.9631E-01,0.9909E-01,0.1061E+00,0.1129E+00,
     *0.1159E+00,0.1183E+00,0.1249E+00,0.1377E+00,0.1464E+00,
     *0.1574E+00,0.1748E+00,0.1925E+00,0.2083E+00,0.2319E+00,
     *0.2631E+00,0.2900E+00,0.3188E+00,0.3596E+00,0.4058E+00,
     *0.4559E+00,0.5092E+00,0.5805E+00,0.6598E+00,0.7409E+00,
     *0.8458E+00,0.9639E+00,0.1108E+01,0.1271E+01,0.1452E+01,
     *0.1661E+01,0.1930E+01,0.2239E+01,0.2583E+01,0.2991E+01,
     *0.3504E+01,0.4102E+01,0.4866E+01,0.5793E+01,0.6962E+01,
     *0.8615E+01,0.1106E+02,0.1491E+02,0.2162E+02,0.3471E+02,
     *0.6534E+02,0.1592E+03,0.3092E+03 /
        DATA ((PHR(i,j),j=1,83),i=15,15)/
     *0.3996E+00,0.3448E+00,0.2744E+00,0.2618E+00,0.2804E+00,
     *0.2976E+00,0.2947E+00,0.2798E+00,0.2638E+00,0.2525E+00,
     *0.2468E+00,0.2364E+00,0.2288E+00,0.2199E+00,0.2093E+00,
     *0.1969E+00,0.1803E+00,0.1609E+00,0.1437E+00,0.1274E+00,
     *0.1142E+00,0.1066E+00,0.9947E-01,0.9336E-01,0.8845E-01,
     *0.8567E-01,0.8339E-01,0.8190E-01,0.8271E-01,0.8283E-01,
     *0.8322E-01,0.8550E-01,0.8712E-01,0.8869E-01,0.9052E-01,
     *0.9368E-01,0.9776E-01,0.1013E+00,0.1063E+00,0.1132E+00,
     *0.1211E+00,0.1254E+00,0.1297E+00,0.1379E+00,0.1491E+00,
     *0.1643E+00,0.1789E+00,0.1936E+00,0.2155E+00,0.2380E+00,
     *0.2616E+00,0.2901E+00,0.3259E+00,0.3668E+00,0.4091E+00,
     *0.4574E+00,0.5208E+00,0.5911E+00,0.6665E+00,0.7591E+00,
     *0.8703E+00,0.9971E+00,0.1139E+01,0.1310E+01,0.1512E+01,
     *0.1758E+01,0.2034E+01,0.2363E+01,0.2752E+01,0.3240E+01,
     *0.3818E+01,0.4502E+01,0.5355E+01,0.6435E+01,0.7850E+01,
     *0.9727E+01,0.1232E+02,0.1617E+02,0.2240E+02,0.3347E+02,
     *0.5606E+02,0.1104E+03,0.1619E+03 /
        DATA ((PHR(i,j),j=1,83),i=16,16)/
     *0.3001E+00,0.2702E+00,0.2249E+00,0.2075E+00,0.2173E+00,
     *0.2344E+00,0.2445E+00,0.2409E+00,0.2303E+00,0.2189E+00,
     *0.2091E+00,0.2043E+00,0.1989E+00,0.1914E+00,0.1830E+00,
     *0.1709E+00,0.1572E+00,0.1450E+00,0.1322E+00,0.1217E+00,
     *0.1126E+00,0.1031E+00,0.9650E-01,0.9209E-01,0.8818E-01,
     *0.8503E-01,0.8264E-01,0.8130E-01,0.8088E-01,0.8114E-01,
     *0.8147E-01,0.8170E-01,0.8302E-01,0.8619E-01,0.8901E-01,
     *0.9171E-01,0.9569E-01,0.1006E+00,0.1060E+00,0.1123E+00,
     *0.1191E+00,0.1230E+00,0.1274E+00,0.1373E+00,0.1480E+00,
     *0.1604E+00,0.1744E+00,0.1915E+00,0.2109E+00,0.2322E+00,
     *0.2580E+00,0.2882E+00,0.3207E+00,0.3591E+00,0.4045E+00,
     *0.4575E+00,0.5169E+00,0.5861E+00,0.6675E+00,0.7643E+00,
     *0.8749E+00,0.1002E+01,0.1157E+01,0.1339E+01,0.1553E+01,
     *0.1801E+01,0.2102E+01,0.2462E+01,0.2895E+01,0.3405E+01,
     *0.4018E+01,0.4784E+01,0.5723E+01,0.6890E+01,0.8363E+01,
     *0.1030E+02,0.1298E+02,0.1683E+02,0.2268E+02,0.3246E+02,
     *0.5060E+02,0.8808E+02,0.1147E+03 /
        DATA ((PHR(i,j),j=1,83),i=17,17)/
     *0.2823E+00,0.2552E+00,0.2123E+00,0.1951E+00,0.2063E+00,
     *0.2250E+00,0.2330E+00,0.2294E+00,0.2198E+00,0.2091E+00,
     *0.1996E+00,0.1948E+00,0.1897E+00,0.1833E+00,0.1761E+00,
     *0.1658E+00,0.1536E+00,0.1419E+00,0.1308E+00,0.1212E+00,
     *0.1122E+00,0.1029E+00,0.9669E-01,0.9196E-01,0.8785E-01,
     *0.8478E-01,0.8275E-01,0.8117E-01,0.8028E-01,0.8069E-01,
     *0.8124E-01,0.8157E-01,0.8289E-01,0.8540E-01,0.8837E-01,
     *0.9169E-01,0.9499E-01,0.9951E-01,0.1053E+00,0.1113E+00,
     *0.1177E+00,0.1215E+00,0.1259E+00,0.1359E+00,0.1469E+00,
     *0.1586E+00,0.1731E+00,0.1903E+00,0.2089E+00,0.2302E+00,
     *0.2570E+00,0.2864E+00,0.3184E+00,0.3566E+00,0.4030E+00,
     *0.4556E+00,0.5140E+00,0.5843E+00,0.6677E+00,0.7627E+00,
     *0.8738E+00,0.1005E+01,0.1162E+01,0.1346E+01,0.1561E+01,
     *0.1813E+01,0.2123E+01,0.2493E+01,0.2932E+01,0.3452E+01,
     *0.4090E+01,0.4877E+01,0.5840E+01,0.7037E+01,0.8542E+01,
     *0.1052E+02,0.1320E+02,0.1702E+02,0.2271E+02,0.3201E+02,
     *0.4871E+02,0.8147E+02,0.1025E+03 /
        DATA ((PHR(i,j),j=1,83),i=18,18)/
     *0.2252E+00,0.2063E+00,0.1757E+00,0.1674E+00,0.1797E+00,
     *0.1971E+00,0.2027E+00,0.1997E+00,0.1918E+00,0.1829E+00,
     *0.1761E+00,0.1700E+00,0.1643E+00,0.1593E+00,0.1528E+00,
     *0.1457E+00,0.1381E+00,0.1296E+00,0.1203E+00,0.1116E+00,
     *0.1047E+00,0.9838E-01,0.9271E-01,0.8816E-01,0.8463E-01,
     *0.8230E-01,0.8067E-01,0.7946E-01,0.7876E-01,0.7854E-01,
     *0.7920E-01,0.8085E-01,0.8232E-01,0.8368E-01,0.8650E-01,
     *0.9020E-01,0.9374E-01,0.9791E-01,0.1036E+00,0.1096E+00,
     *0.1161E+00,0.1200E+00,0.1244E+00,0.1344E+00,0.1451E+00,
     *0.1573E+00,0.1723E+00,0.1886E+00,0.2069E+00,0.2293E+00,
     *0.2551E+00,0.2835E+00,0.3163E+00,0.3555E+00,0.4005E+00,
     *0.4519E+00,0.5121E+00,0.5835E+00,0.6661E+00,0.7614E+00,
     *0.8745E+00,0.1010E+01,0.1170E+01,0.1355E+01,0.1577E+01,
     *0.1843E+01,0.2163E+01,0.2544E+01,0.3001E+01,0.3554E+01,
     *0.4229E+01,0.5049E+01,0.6064E+01,0.7318E+01,0.8895E+01,
     *0.1094E+02,0.1365E+02,0.1739E+02,0.2280E+02,0.3115E+02,
     *0.4522E+02,0.6977E+02,0.8255E+02 /
        DATA ((PHR(i,j),j=1,83),i=19,19)/
     *0.1310E+00,0.1235E+00,0.1075E+00,0.1051E+00,0.1162E+00,
     *0.1279E+00,0.1325E+00,0.1308E+00,0.1263E+00,0.1212E+00,
     *0.1166E+00,0.1127E+00,0.1094E+00,0.1064E+00,0.1035E+00,
     *0.1002E+00,0.9660E-01,0.9285E-01,0.8897E-01,0.8520E-01,
     *0.8176E-01,0.7844E-01,0.7550E-01,0.7300E-01,0.7107E-01,
     *0.6969E-01,0.6873E-01,0.6809E-01,0.6787E-01,0.6822E-01,
     *0.6902E-01,0.7019E-01,0.7171E-01,0.7369E-01,0.7631E-01,
     *0.7946E-01,0.8301E-01,0.8719E-01,0.9225E-01,0.9801E-01,
     *0.1045E+00,0.1081E+00,0.1121E+00,0.1210E+00,0.1311E+00,
     *0.1426E+00,0.1560E+00,0.1714E+00,0.1888E+00,0.2091E+00,
     *0.2327E+00,0.2598E+00,0.2909E+00,0.3273E+00,0.3697E+00,
     *0.4189E+00,0.4765E+00,0.5443E+00,0.6239E+00,0.7174E+00,
     *0.8283E+00,0.9602E+00,0.1117E+01,0.1304E+01,0.1529E+01,
     *0.1798E+01,0.2125E+01,0.2519E+01,0.2998E+01,0.3582E+01,
     *0.4299E+01,0.5181E+01,0.6276E+01,0.7642E+01,0.9369E+01,
     *0.1159E+02,0.1451E+02,0.1846E+02,0.2404E+02,0.3236E+02,
     *0.4559E+02,0.6589E+02,0.7490E+02 /
        DATA ((PHR(i,j),j=1,83),i=20,20)/
     *0.2124E+00,0.2038E+00,0.1826E+00,0.1735E+00,0.1792E+00,
     *0.1937E+00,0.2072E+00,0.2138E+00,0.2150E+00,0.2119E+00,
     *0.2053E+00,0.1954E+00,0.1843E+00,0.1734E+00,0.1629E+00,
     *0.1531E+00,0.1436E+00,0.1348E+00,0.1272E+00,0.1206E+00,
     *0.1151E+00,0.1107E+00,0.1071E+00,0.1042E+00,0.1022E+00,
     *0.1009E+00,0.1002E+00,0.1001E+00,0.1007E+00,0.1019E+00,
     *0.1037E+00,0.1059E+00,0.1087E+00,0.1123E+00,0.1166E+00,
     *0.1215E+00,0.1273E+00,0.1340E+00,0.1416E+00,0.1506E+00,
     *0.1610E+00,0.1666E+00,0.1724E+00,0.1850E+00,0.1997E+00,
     *0.2168E+00,0.2361E+00,0.2579E+00,0.2828E+00,0.3109E+00,
     *0.3428E+00,0.3798E+00,0.4228E+00,0.4716E+00,0.5269E+00,
     *0.5912E+00,0.6656E+00,0.7513E+00,0.8503E+00,0.9660E+00,
     *0.1101E+01,0.1256E+01,0.1437E+01,0.1649E+01,0.1899E+01,
     *0.2192E+01,0.2534E+01,0.2935E+01,0.3410E+01,0.3972E+01,
     *0.4636E+01,0.5421E+01,0.6351E+01,0.7469E+01,0.8819E+01,
     *0.1046E+02,0.1246E+02,0.1497E+02,0.1818E+02,0.2241E+02,
     *0.2790E+02,0.3310E+02,0.3469E+02 /
c************** MIE (phase fun qh) ***************
        DATA ((QHR(i,j),j=1,83),i= 1, 1)/
     *-0.5652E-21,-0.4313E-02, 0.8133E-01, 0.2057E-01, 0.4002E-01,
     * 0.3516E-01, 0.1535E-01,-0.1468E-01,-0.5310E-01,-0.6907E-01,
     *-0.9040E-01,-0.1349E+00,-0.1587E+00,-0.1714E+00,-0.1827E+00,
     *-0.1288E+00,-0.5406E-01,-0.2625E-01,-0.1019E-01,-0.2488E-02,
     *-0.1738E-02, 0.1211E-02, 0.4563E-03, 0.3466E-02,-0.1493E-03,
     * 0.3994E-03,-0.2694E-02,-0.5007E-02,-0.7406E-02,-0.9019E-02,
     *-0.1274E-01,-0.1195E-01,-0.9552E-02,-0.8995E-02,-0.8926E-02,
     *-0.6393E-02,-0.2516E-02,-0.1326E-02, 0.1299E-02, 0.3362E-02,
     * 0.4485E-02, 0.5630E-02, 0.6771E-02, 0.1022E-01, 0.1252E-01,
     * 0.1659E-01, 0.2257E-01, 0.2038E-01, 0.2396E-01, 0.2829E-01,
     * 0.2622E-01, 0.3117E-01, 0.3548E-01, 0.4045E-01, 0.4483E-01,
     * 0.4913E-01, 0.4837E-01, 0.5558E-01, 0.5632E-01, 0.7013E-01,
     * 0.7452E-01, 0.7231E-01, 0.8890E-01, 0.8722E-01, 0.9534E-01,
     * 0.8891E-01, 0.8269E-01, 0.1003E+00, 0.6763E-01, 0.8108E-01,
     * 0.1530E-01, 0.4417E-01, 0.4865E-01,-0.2253E-01,-0.8601E-02,
     * 0.1806E-01,-0.7635E-01,-0.5849E-02,-0.9235E-02,-0.2265E-01,
     * 0.3535E+00, 0.3803E+00,-0.2302E-17 /
        DATA ((QHR(i,j),j=1,83),i= 2, 2)/
     * 0.9414E-21,-0.2148E-01, 0.3455E-01, 0.7867E-01, 0.4848E-01,
     * 0.3081E-01, 0.6826E-02,-0.1285E-01,-0.2542E-01,-0.6736E-01,
     *-0.9198E-01,-0.1066E+00,-0.1388E+00,-0.1596E+00,-0.1506E+00,
     *-0.1155E+00,-0.6667E-01,-0.2285E-01,-0.1157E-01,-0.6434E-03,
     * 0.4941E-02, 0.5109E-03, 0.9727E-03, 0.2256E-02, 0.1119E-03,
     *-0.2490E-02,-0.2937E-03,-0.3061E-02,-0.4907E-02,-0.6150E-02,
     *-0.9551E-02,-0.1002E-01,-0.1206E-01,-0.9100E-02,-0.5451E-02,
     *-0.3768E-02, 0.2641E-02, 0.5438E-02, 0.5056E-02, 0.5468E-02,
     * 0.9817E-02, 0.1079E-01, 0.1084E-01, 0.9448E-02, 0.1610E-01,
     * 0.1855E-01, 0.1618E-01, 0.2270E-01, 0.2782E-01, 0.2992E-01,
     * 0.3257E-01, 0.4231E-01, 0.3962E-01, 0.4831E-01, 0.5199E-01,
     * 0.5227E-01, 0.6304E-01, 0.6644E-01, 0.6961E-01, 0.7646E-01,
     * 0.7575E-01, 0.8536E-01, 0.7497E-01, 0.9430E-01, 0.8630E-01,
     * 0.8251E-01, 0.6499E-01, 0.7332E-01, 0.8381E-01, 0.3474E-01,
     * 0.5205E-01, 0.9879E-02, 0.3438E-01, 0.4582E-01, 0.7840E-02,
     *-0.1749E-01, 0.2460E-01,-0.1583E+00,-0.5196E-01,-0.7299E-01,
     *-0.3856E+00,-0.1326E-01, 0.9563E-18 /
        DATA ((QHR(i,j),j=1,83),i= 3, 3)/
     * 0.1377E-20,-0.3240E-01, 0.4286E-01, 0.8798E-01, 0.3900E-01,
     * 0.3007E-01, 0.1692E-01,-0.1615E-01,-0.2910E-01,-0.5050E-01,
     *-0.8576E-01,-0.1091E+00,-0.1339E+00,-0.1502E+00,-0.1358E+00,
     *-0.1073E+00,-0.6237E-01,-0.2447E-01,-0.7987E-02, 0.1037E-02,
     * 0.3342E-02, 0.3115E-02, 0.4347E-02, 0.1780E-02, 0.7169E-03,
     *-0.1787E-03,-0.1866E-03,-0.3717E-03,-0.4190E-02,-0.7022E-02,
     *-0.4385E-02,-0.6997E-02,-0.1042E-01,-0.6191E-02,-0.4346E-02,
     *-0.6999E-02,-0.1642E-02, 0.3803E-02, 0.5121E-02, 0.6217E-02,
     * 0.9376E-02, 0.1007E-01, 0.1456E-01, 0.1745E-01, 0.1543E-01,
     * 0.1825E-01, 0.1987E-01, 0.2443E-01, 0.3077E-01, 0.2968E-01,
     * 0.3360E-01, 0.4489E-01, 0.4517E-01, 0.4316E-01, 0.5245E-01,
     * 0.5575E-01, 0.6458E-01, 0.6590E-01, 0.7301E-01, 0.6530E-01,
     * 0.8530E-01, 0.8100E-01, 0.7168E-01, 0.7552E-01, 0.8379E-01,
     * 0.7635E-01, 0.7311E-01, 0.5822E-01, 0.6480E-01, 0.5886E-01,
     * 0.6843E-01, 0.5198E-01, 0.2430E-01, 0.1679E-01,-0.6881E-01,
     *-0.4788E-01,-0.8695E-01,-0.1898E+00,-0.6728E-01, 0.1288E+00,
     *-0.2377E+00,-0.2115E+00, 0.7805E-18 /
        DATA ((QHR(i,j),j=1,83),i= 4, 4)/
     * 0.5153E-21,-0.3973E-01, 0.2373E-01, 0.6997E-01, 0.4090E-01,
     * 0.3377E-01, 0.6982E-02,-0.1835E-01,-0.1770E-01,-0.6745E-01,
     *-0.8655E-01,-0.1051E+00,-0.1330E+00,-0.1530E+00,-0.1223E+00,
     *-0.1081E+00,-0.6315E-01,-0.2324E-01,-0.1108E-01,-0.1200E-02,
     * 0.4999E-02, 0.1866E-02, 0.3340E-02, 0.1777E-02, 0.1436E-02,
     *-0.1121E-02,-0.1198E-02,-0.1074E-02,-0.3401E-02,-0.8284E-02,
     *-0.6722E-02,-0.5177E-02,-0.9347E-02,-0.8328E-02,-0.5107E-02,
     *-0.3385E-02, 0.1059E-02, 0.5830E-02, 0.6722E-02, 0.7302E-02,
     * 0.1098E-01, 0.9981E-02, 0.1275E-01, 0.1250E-01, 0.1623E-01,
     * 0.1743E-01, 0.1780E-01, 0.2224E-01, 0.3006E-01, 0.2789E-01,
     * 0.3505E-01, 0.4417E-01, 0.4075E-01, 0.4337E-01, 0.5498E-01,
     * 0.5322E-01, 0.6139E-01, 0.6674E-01, 0.7196E-01, 0.6613E-01,
     * 0.8054E-01, 0.8335E-01, 0.7577E-01, 0.8372E-01, 0.9626E-01,
     * 0.8004E-01, 0.7107E-01, 0.6142E-01, 0.7472E-01, 0.4178E-01,
     * 0.4422E-01, 0.1839E-01, 0.5264E-01, 0.5821E-01,-0.1082E-01,
     * 0.1844E-01,-0.1667E-02,-0.2010E+00,-0.8919E-01,-0.3129E-01,
     *-0.3706E+00,-0.8864E-01,-0.3064E-17 /
        DATA ((QHR(i,j),j=1,83),i= 5, 5)/
     * 0.6702E-21,-0.2668E-01, 0.8251E-03, 0.4873E-01, 0.5822E-01,
     * 0.3429E-01,-0.1839E-02,-0.2601E-02,-0.4287E-01,-0.6043E-01,
     *-0.8286E-01,-0.1083E+00,-0.1315E+00,-0.1377E+00,-0.1350E+00,
     *-0.9677E-01,-0.5612E-01,-0.2971E-01,-0.1186E-01,-0.1925E-02,
     * 0.6147E-03, 0.3895E-02, 0.5068E-02, 0.2352E-02, 0.2879E-02,
     * 0.2913E-02,-0.2223E-02,-0.5321E-02,-0.4496E-02,-0.2506E-02,
     *-0.6739E-02,-0.6839E-02,-0.5546E-02,-0.5542E-02,-0.4234E-02,
     *-0.8077E-03,-0.3385E-02, 0.2486E-02, 0.3510E-02, 0.6383E-02,
     * 0.1321E-01, 0.1580E-01, 0.1651E-01, 0.1558E-01, 0.1728E-01,
     * 0.2283E-01, 0.2308E-01, 0.2508E-01, 0.2401E-01, 0.3473E-01,
     * 0.3949E-01, 0.3137E-01, 0.3798E-01, 0.5508E-01, 0.4682E-01,
     * 0.5096E-01, 0.5694E-01, 0.6380E-01, 0.6197E-01, 0.6336E-01,
     * 0.7228E-01, 0.6858E-01, 0.8092E-01, 0.7072E-01, 0.7140E-01,
     * 0.6980E-01, 0.9243E-01, 0.6652E-01, 0.6055E-01, 0.6636E-01,
     * 0.5477E-01, 0.6935E-01, 0.3807E-02, 0.4117E-03, 0.3388E-01,
     *-0.6244E-01,-0.4231E-01, 0.1060E+00,-0.1044E+00,-0.1264E+00,
     * 0.4247E+00, 0.4541E+00, 0.8861E-18 /
        DATA ((QHR(i,j),j=1,83),i= 6, 6)/
     *-0.3949E-21,-0.2874E-01, 0.4286E-01, 0.6443E-01, 0.4238E-01,
     * 0.2595E-01, 0.8069E-02,-0.1591E-01,-0.3601E-01,-0.7140E-01,
     *-0.9417E-01,-0.1015E+00,-0.1202E+00,-0.1395E+00,-0.1301E+00,
     *-0.9785E-01,-0.6059E-01,-0.2294E-01,-0.9932E-02,-0.3946E-02,
     * 0.1885E-02, 0.1371E-02, 0.9160E-03, 0.3312E-02, 0.6612E-03,
     *-0.5298E-03,-0.1417E-02,-0.1727E-02,-0.3372E-02,-0.4507E-02,
     *-0.8046E-02,-0.9030E-02,-0.8927E-02,-0.5286E-02,-0.3281E-02,
     *-0.6920E-03, 0.2602E-02, 0.4785E-02, 0.4160E-02, 0.7590E-02,
     * 0.9385E-02, 0.1059E-01, 0.8535E-02, 0.1049E-01, 0.1694E-01,
     * 0.1781E-01, 0.1729E-01, 0.2452E-01, 0.2989E-01, 0.3030E-01,
     * 0.3068E-01, 0.4281E-01, 0.4487E-01, 0.4370E-01, 0.4908E-01,
     * 0.5736E-01, 0.5621E-01, 0.6650E-01, 0.6731E-01, 0.7626E-01,
     * 0.7170E-01, 0.8259E-01, 0.7632E-01, 0.9607E-01, 0.7728E-01,
     * 0.7295E-01, 0.7610E-01, 0.8304E-01, 0.7244E-01, 0.4201E-01,
     * 0.5154E-01, 0.1437E-01, 0.3095E-01, 0.6875E-01, 0.3148E-01,
     * 0.7756E-02,-0.1868E-01,-0.2055E-01, 0.5688E-01,-0.1536E-01,
     *-0.2547E+00, 0.3047E+00, 0.4664E-18 /
        DATA ((QHR(i,j),j=1,83),i= 7, 7)/
     *-0.7177E-23,-0.3681E-01, 0.1664E-01, 0.6839E-01, 0.4673E-01,
     * 0.2728E-01, 0.5361E-02,-0.1598E-01,-0.2734E-01,-0.6933E-01,
     *-0.8660E-01,-0.1027E+00,-0.1238E+00,-0.1361E+00,-0.1154E+00,
     *-0.9423E-01,-0.5514E-01,-0.2077E-01,-0.1127E-01,-0.9738E-03,
     * 0.5773E-02, 0.2083E-02, 0.3273E-02, 0.2883E-02, 0.8928E-03,
     *-0.6255E-03,-0.2589E-03,-0.1137E-02,-0.2237E-02,-0.4908E-02,
     *-0.5277E-02,-0.4451E-02,-0.7563E-02,-0.6745E-02,-0.3568E-02,
     *-0.1200E-02, 0.2491E-02, 0.7746E-02, 0.7179E-02, 0.7156E-02,
     * 0.1314E-01, 0.1313E-01, 0.1336E-01, 0.1225E-01, 0.1854E-01,
     * 0.2003E-01, 0.1786E-01, 0.2448E-01, 0.2963E-01, 0.2795E-01,
     * 0.3517E-01, 0.4348E-01, 0.3882E-01, 0.4532E-01, 0.5204E-01,
     * 0.5212E-01, 0.5906E-01, 0.6778E-01, 0.6769E-01, 0.6898E-01,
     * 0.8005E-01, 0.8349E-01, 0.7226E-01, 0.8684E-01, 0.9591E-01,
     * 0.7709E-01, 0.7128E-01, 0.6704E-01, 0.8266E-01, 0.4439E-01,
     * 0.5628E-01, 0.1977E-01, 0.5664E-01, 0.6722E-01, 0.2624E-01,
     * 0.2828E-01, 0.4223E-02,-0.1563E+00,-0.6070E-01,-0.5531E-01,
     *-0.3453E+00, 0.8463E-01, 0.2078E-17 /
        DATA ((QHR(i,j),j=1,83),i= 8, 8)/
     *-0.3240E-21,-0.9355E-02, 0.1593E-01, 0.1917E-01, 0.2439E-01,
     * 0.1935E-01, 0.7732E-02,-0.2749E-01,-0.5613E-01,-0.6637E-01,
     *-0.8221E-01,-0.1120E+00,-0.1200E+00,-0.1182E+00,-0.1248E+00,
     *-0.9325E-01,-0.4818E-01,-0.2681E-01,-0.1105E-01,-0.4340E-02,
     *-0.1019E-02, 0.2498E-02, 0.3301E-02, 0.2703E-02, 0.2312E-02,
     * 0.1985E-02,-0.4751E-03,-0.1738E-02,-0.2378E-02,-0.5705E-02,
     *-0.6433E-02,-0.4408E-02,-0.3969E-02,-0.3565E-02,-0.3522E-02,
     *-0.5782E-04, 0.4956E-03,-0.2255E-03, 0.4909E-02, 0.7191E-02,
     * 0.5593E-02, 0.6115E-02, 0.7903E-02, 0.1328E-01, 0.1560E-01,
     * 0.1761E-01, 0.2237E-01, 0.2440E-01, 0.2697E-01, 0.2854E-01,
     * 0.3133E-01, 0.3471E-01, 0.4033E-01, 0.3909E-01, 0.4932E-01,
     * 0.5292E-01, 0.5090E-01, 0.5525E-01, 0.6602E-01, 0.6821E-01,
     * 0.7123E-01, 0.7677E-01, 0.8395E-01, 0.8011E-01, 0.8679E-01,
     * 0.9204E-01, 0.7370E-01, 0.9114E-01, 0.7572E-01, 0.7807E-01,
     * 0.3782E-01, 0.4951E-01, 0.7015E-01, 0.8199E-02, 0.1940E-01,
     * 0.3688E-01, 0.5608E-04, 0.4390E-01, 0.1358E+00, 0.1169E+00,
     * 0.1794E+00, 0.4116E+00,-0.1607E-17 /
        DATA ((QHR(i,j),j=1,83),i= 9, 9)/
     * 0.1720E-21,-0.2559E-01, 0.1420E-01, 0.1941E-01, 0.5511E-01,
     * 0.2178E-01,-0.7668E-02,-0.1665E-01,-0.4416E-01,-0.6232E-01,
     *-0.7647E-01,-0.1002E+00,-0.1130E+00,-0.1162E+00,-0.1149E+00,
     *-0.8304E-01,-0.4706E-01,-0.2803E-01,-0.1121E-01,-0.3090E-02,
     *-0.7171E-03, 0.3461E-02, 0.2662E-02, 0.2987E-02, 0.3538E-02,
     * 0.4784E-02,-0.8729E-03,-0.3289E-02,-0.2055E-02,-0.1804E-02,
     *-0.4225E-02,-0.4292E-02,-0.1369E-02,-0.1593E-02,-0.2009E-02,
     * 0.5345E-03, 0.1736E-02, 0.1974E-02, 0.5268E-02, 0.7065E-02,
     * 0.1055E-01, 0.1333E-01, 0.1523E-01, 0.1631E-01, 0.1758E-01,
     * 0.2096E-01, 0.2608E-01, 0.2591E-01, 0.2342E-01, 0.3227E-01,
     * 0.3423E-01, 0.3271E-01, 0.3682E-01, 0.4823E-01, 0.4623E-01,
     * 0.4942E-01, 0.4909E-01, 0.6249E-01, 0.5941E-01, 0.6084E-01,
     * 0.6780E-01, 0.6821E-01, 0.7542E-01, 0.6948E-01, 0.7942E-01,
     * 0.6939E-01, 0.9442E-01, 0.8481E-01, 0.7315E-01, 0.8639E-01,
     * 0.6086E-01, 0.1050E+00, 0.3096E-01,-0.6550E-02, 0.3203E-01,
     *-0.1720E-01, 0.1845E-01, 0.1281E+00,-0.3856E-01,-0.8897E-01,
     * 0.2440E+00, 0.4500E+00, 0.1261E-17 /
        DATA ((QHR(i,j),j=1,83),i=10,10)/
     *-0.7197E-21,-0.5090E-01, 0.2446E-01, 0.4509E-01, 0.4499E-01,
     * 0.1829E-01, 0.2361E-02,-0.2006E-01,-0.3582E-01,-0.5358E-01,
     *-0.7447E-01,-0.8945E-01,-0.1068E+00,-0.1059E+00,-0.9378E-01,
     *-0.7825E-01,-0.5091E-01,-0.2584E-01,-0.1020E-01,-0.2085E-02,
     * 0.2355E-02, 0.4949E-02, 0.5296E-02, 0.2505E-02, 0.2509E-02,
     * 0.1762E-02, 0.1775E-02, 0.3908E-03,-0.1609E-02,-0.8453E-03,
     *-0.4221E-03,-0.3227E-02,-0.3607E-02,-0.1441E-02, 0.8404E-03,
     * 0.8303E-03, 0.2055E-02, 0.5549E-02, 0.6134E-02, 0.8483E-02,
     * 0.1277E-01, 0.1429E-01, 0.1594E-01, 0.1703E-01, 0.1644E-01,
     * 0.2071E-01, 0.2338E-01, 0.2527E-01, 0.2967E-01, 0.3417E-01,
     * 0.3694E-01, 0.3621E-01, 0.4565E-01, 0.5179E-01, 0.4982E-01,
     * 0.5453E-01, 0.6488E-01, 0.6501E-01, 0.6474E-01, 0.6791E-01,
     * 0.7775E-01, 0.7289E-01, 0.7601E-01, 0.6822E-01, 0.7584E-01,
     * 0.7646E-01, 0.8409E-01, 0.5685E-01, 0.7211E-01, 0.6113E-01,
     * 0.7916E-01, 0.5970E-01, 0.1954E-01, 0.2637E-01,-0.3274E-02,
     *-0.1087E-02,-0.5281E-02,-0.9384E-02,-0.9625E-01, 0.7555E-01,
     * 0.2650E+00,-0.1381E+00,-0.4426E-18 /
        DATA ((QHR(i,j),j=1,83),i=11,11)/
     * 0.8139E-21,-0.2558E-01, 0.1282E-01, 0.1142E-01, 0.3862E-01,
     * 0.2034E-01,-0.3045E-02,-0.2027E-01,-0.4761E-01,-0.6124E-01,
     *-0.7568E-01,-0.9914E-01,-0.1048E+00,-0.1049E+00,-0.1087E+00,
     *-0.7790E-01,-0.4430E-01,-0.2972E-01,-0.1305E-01,-0.5027E-02,
     *-0.2336E-02, 0.2746E-02, 0.1041E-02, 0.3174E-02, 0.3479E-02,
     * 0.3466E-02, 0.2804E-03,-0.2467E-02,-0.2409E-02,-0.1813E-02,
     *-0.5080E-02,-0.3482E-02,-0.2263E-04,-0.9982E-03,-0.5088E-03,
     * 0.1044E-02, 0.2645E-02, 0.3514E-02, 0.5332E-02, 0.7357E-02,
     * 0.9363E-02, 0.1166E-01, 0.1333E-01, 0.1562E-01, 0.1571E-01,
     * 0.2050E-01, 0.2396E-01, 0.2515E-01, 0.2609E-01, 0.2929E-01,
     * 0.3304E-01, 0.3278E-01, 0.3400E-01, 0.4360E-01, 0.4444E-01,
     * 0.4499E-01, 0.4726E-01, 0.5435E-01, 0.5612E-01, 0.6334E-01,
     * 0.6192E-01, 0.6735E-01, 0.7705E-01, 0.7289E-01, 0.8262E-01,
     * 0.8428E-01, 0.9148E-01, 0.9670E-01, 0.8878E-01, 0.9254E-01,
     * 0.4597E-01, 0.8947E-01, 0.5791E-01, 0.6618E-02, 0.2768E-01,
     * 0.2528E-01, 0.5614E-01, 0.1248E+00, 0.7790E-02, 0.3756E-01,
     * 0.3277E+00, 0.1548E+00,-0.3183E-18 /
        DATA ((QHR(i,j),j=1,83),i=12,12)/
     *-0.7425E-21,-0.2536E-01, 0.1690E-01, 0.5213E-01, 0.3816E-01,
     * 0.1641E-01,-0.3100E-03,-0.2087E-01,-0.3990E-01,-0.6941E-01,
     *-0.8761E-01,-0.8910E-01,-0.1005E+00,-0.1067E+00,-0.9678E-01,
     *-0.7441E-01,-0.4953E-01,-0.2205E-01,-0.1164E-01,-0.2738E-02,
     * 0.1631E-02, 0.2907E-03, 0.1065E-02, 0.3352E-02, 0.1473E-02,
     *-0.6874E-03, 0.3727E-03, 0.1043E-03,-0.1979E-02,-0.1952E-02,
     *-0.4301E-02,-0.4007E-02,-0.3971E-02,-0.2212E-02,-0.6598E-03,
     * 0.1032E-02, 0.4533E-02, 0.6206E-02, 0.6500E-02, 0.7573E-02,
     * 0.1072E-01, 0.1178E-01, 0.1061E-01, 0.1079E-01, 0.1752E-01,
     * 0.1904E-01, 0.1741E-01, 0.2250E-01, 0.2662E-01, 0.2836E-01,
     * 0.3031E-01, 0.3860E-01, 0.3844E-01, 0.4273E-01, 0.4566E-01,
     * 0.5043E-01, 0.5705E-01, 0.5887E-01, 0.6274E-01, 0.7130E-01,
     * 0.6890E-01, 0.7600E-01, 0.7541E-01, 0.9080E-01, 0.8251E-01,
     * 0.7776E-01, 0.7403E-01, 0.8570E-01, 0.8986E-01, 0.6068E-01,
     * 0.7006E-01, 0.4909E-01, 0.6560E-01, 0.7687E-01, 0.5273E-01,
     * 0.3299E-01, 0.3491E-01,-0.1907E-02, 0.8271E-01, 0.4703E-01,
     *-0.1358E+00, 0.9753E-02, 0.4340E-18 /
        DATA ((QHR(i,j),j=1,83),i=13,13)/
     * 0.5346E-21,-0.2282E-01, 0.1047E-01, 0.1513E-02, 0.2542E-01,
     * 0.2023E-01,-0.3904E-02,-0.2441E-01,-0.4896E-01,-0.6321E-01,
     *-0.7552E-01,-0.9330E-01,-0.9863E-01,-0.9404E-01,-0.9572E-01,
     *-0.7181E-01,-0.3974E-01,-0.2616E-01,-0.1341E-01,-0.4901E-02,
     *-0.1544E-02, 0.1408E-02, 0.1477E-02, 0.3356E-02, 0.2461E-02,
     * 0.3178E-02, 0.6163E-03,-0.1310E-02,-0.1013E-02,-0.2031E-02,
     *-0.4379E-02,-0.2608E-02,-0.6183E-03,-0.7185E-03,-0.3818E-03,
     * 0.8694E-03, 0.2640E-02, 0.3864E-02, 0.5761E-02, 0.7659E-02,
     * 0.8838E-02, 0.1052E-01, 0.1259E-01, 0.1465E-01, 0.1486E-01,
     * 0.1833E-01, 0.2314E-01, 0.2269E-01, 0.2445E-01, 0.2860E-01,
     * 0.2962E-01, 0.3174E-01, 0.3386E-01, 0.4029E-01, 0.4386E-01,
     * 0.4414E-01, 0.4571E-01, 0.5412E-01, 0.5507E-01, 0.6218E-01,
     * 0.6413E-01, 0.6922E-01, 0.7416E-01, 0.7933E-01, 0.8333E-01,
     * 0.8379E-01, 0.8689E-01, 0.9666E-01, 0.8051E-01, 0.8971E-01,
     * 0.4985E-01, 0.8920E-01, 0.7194E-01, 0.3749E-01, 0.4367E-01,
     * 0.4630E-01, 0.5292E-01, 0.1102E+00, 0.6302E-01, 0.6338E-01,
     * 0.3112E+00, 0.2792E+00, 0.9208E-18 /
        DATA ((QHR(i,j),j=1,83),i=14,14)/
     * 0.8020E-21,-0.2738E-01,-0.1208E-02, 0.1797E-01, 0.4030E-01,
     * 0.1935E-01,-0.5775E-02,-0.2120E-01,-0.4041E-01,-0.5868E-01,
     *-0.6833E-01,-0.8267E-01,-0.8673E-01,-0.8466E-01,-0.8131E-01,
     *-0.5719E-01,-0.3646E-01,-0.2559E-01,-0.1172E-01,-0.4864E-02,
     *-0.2056E-02, 0.2111E-02, 0.1751E-02, 0.2285E-02, 0.3585E-02,
     * 0.4080E-02, 0.8305E-03,-0.7996E-03,-0.2206E-03, 0.4236E-03,
     *-0.1935E-02,-0.1592E-02, 0.1039E-02, 0.4550E-03, 0.1046E-02,
     * 0.1521E-02, 0.3464E-02, 0.4350E-02, 0.5730E-02, 0.8103E-02,
     * 0.1006E-01, 0.1214E-01, 0.1383E-01, 0.1552E-01, 0.1547E-01,
     * 0.1995E-01, 0.2294E-01, 0.2445E-01, 0.2457E-01, 0.2931E-01,
     * 0.3258E-01, 0.3044E-01, 0.3379E-01, 0.4396E-01, 0.4278E-01,
     * 0.4506E-01, 0.4588E-01, 0.5532E-01, 0.5771E-01, 0.5807E-01,
     * 0.6175E-01, 0.6692E-01, 0.6815E-01, 0.6942E-01, 0.7462E-01,
     * 0.7353E-01, 0.9213E-01, 0.8559E-01, 0.8296E-01, 0.9431E-01,
     * 0.7357E-01, 0.1039E+00, 0.6191E-01, 0.3470E-01, 0.4893E-01,
     * 0.3296E-01, 0.6785E-01, 0.1091E+00, 0.2150E-01,-0.1466E-01,
     * 0.9967E-01, 0.1809E+00,-0.6464E-19 /
        DATA ((QHR(i,j),j=1,83),i=15,15)/
     *-0.5546E-21,-0.1304E-01, 0.3771E-02, 0.2171E-01, 0.1232E-01,
     * 0.8975E-02,-0.3002E-02,-0.2470E-01,-0.4071E-01,-0.5149E-01,
     *-0.6463E-01,-0.6949E-01,-0.6932E-01,-0.6602E-01,-0.5468E-01,
     *-0.4460E-01,-0.3401E-01,-0.2117E-01,-0.1250E-01,-0.5944E-02,
     *-0.2347E-02,-0.1709E-02,-0.5680E-03,-0.4256E-03,-0.7978E-03,
     *-0.1225E-02,-0.8540E-03,-0.4459E-03,-0.1989E-02,-0.2721E-02,
     *-0.8114E-03,-0.1992E-02,-0.3635E-02,-0.1756E-02,-0.2795E-03,
     *-0.1043E-02, 0.4989E-03, 0.2797E-02, 0.3355E-02, 0.3589E-02,
     * 0.5501E-02, 0.6332E-02, 0.7456E-02, 0.8347E-02, 0.9798E-02,
     * 0.1176E-01, 0.1182E-01, 0.1400E-01, 0.1758E-01, 0.1764E-01,
     * 0.1944E-01, 0.2505E-01, 0.2669E-01, 0.2577E-01, 0.3125E-01,
     * 0.3600E-01, 0.3937E-01, 0.4114E-01, 0.4509E-01, 0.4860E-01,
     * 0.5804E-01, 0.5770E-01, 0.5971E-01, 0.6539E-01, 0.7594E-01,
     * 0.7405E-01, 0.7652E-01, 0.7664E-01, 0.8816E-01, 0.9041E-01,
     * 0.9147E-01, 0.8411E-01, 0.9423E-01, 0.9277E-01, 0.7651E-01,
     * 0.8829E-01, 0.6671E-01, 0.2218E-01, 0.6686E-01, 0.1021E+00,
     * 0.4647E-01, 0.1390E-01, 0.3706E-18 /
        DATA ((QHR(i,j),j=1,83),i=16,16)/
     * 0.1866E-21,-0.7885E-02,-0.1345E-02, 0.9548E-02, 0.1448E-01,
     * 0.1025E-01,-0.1326E-02,-0.1980E-01,-0.3610E-01,-0.4634E-01,
     *-0.5262E-01,-0.5715E-01,-0.5584E-01,-0.5210E-01,-0.4839E-01,
     *-0.3949E-01,-0.2864E-01,-0.2141E-01,-0.1553E-01,-0.1121E-01,
     *-0.7991E-02,-0.5756E-02,-0.3976E-02,-0.3076E-02,-0.2895E-02,
     *-0.3062E-02,-0.2996E-02,-0.2980E-02,-0.3291E-02,-0.4053E-02,
     *-0.3831E-02,-0.3254E-02,-0.2734E-02,-0.2997E-02,-0.3025E-02,
     *-0.1965E-02,-0.1457E-02,-0.1773E-02,-0.2319E-03, 0.1232E-02,
     * 0.6366E-03, 0.8594E-03, 0.1673E-02, 0.4333E-02, 0.4814E-02,
     * 0.5511E-02, 0.7957E-02, 0.9499E-02, 0.1017E-01, 0.1134E-01,
     * 0.1385E-01, 0.1574E-01, 0.1745E-01, 0.1808E-01, 0.2230E-01,
     * 0.2555E-01, 0.2615E-01, 0.2827E-01, 0.3563E-01, 0.3828E-01,
     * 0.3732E-01, 0.4515E-01, 0.5192E-01, 0.5435E-01, 0.5621E-01,
     * 0.6525E-01, 0.6667E-01, 0.7688E-01, 0.7661E-01, 0.8159E-01,
     * 0.8153E-01, 0.8537E-01, 0.9095E-01, 0.8504E-01, 0.8838E-01,
     * 0.8481E-01, 0.9359E-01, 0.1219E+00, 0.1652E+00, 0.1679E+00,
     * 0.1100E+00, 0.1693E-01, 0.2805E-18 /
        DATA ((QHR(i,j),j=1,83),i=17,17)/
     * 0.3793E-21,-0.7249E-02,-0.3766E-02, 0.7035E-02, 0.1472E-01,
     * 0.1122E-01,-0.2153E-02,-0.1956E-01,-0.3404E-01,-0.4349E-01,
     *-0.4988E-01,-0.5493E-01,-0.5460E-01,-0.5109E-01,-0.4825E-01,
     *-0.4026E-01,-0.3002E-01,-0.2356E-01,-0.1751E-01,-0.1310E-01,
     *-0.9902E-02,-0.7011E-02,-0.5689E-02,-0.5154E-02,-0.4173E-02,
     *-0.3917E-02,-0.4468E-02,-0.4325E-02,-0.4049E-02,-0.4832E-02,
     *-0.5011E-02,-0.4280E-02,-0.3671E-02,-0.3999E-02,-0.4196E-02,
     *-0.3150E-02,-0.2700E-02,-0.2816E-02,-0.1362E-02,-0.4341E-03,
     *-0.4483E-03, 0.5659E-04, 0.1032E-02, 0.2605E-02, 0.2722E-02,
     * 0.3645E-02, 0.6001E-02, 0.6844E-02, 0.7440E-02, 0.9040E-02,
     * 0.1074E-01, 0.1194E-01, 0.1392E-01, 0.1539E-01, 0.1904E-01,
     * 0.2107E-01, 0.2186E-01, 0.2566E-01, 0.3135E-01, 0.3269E-01,
     * 0.3479E-01, 0.4155E-01, 0.4620E-01, 0.4829E-01, 0.5326E-01,
     * 0.6045E-01, 0.6287E-01, 0.7114E-01, 0.7291E-01, 0.7942E-01,
     * 0.7793E-01, 0.8813E-01, 0.9055E-01, 0.8425E-01, 0.8670E-01,
     * 0.8757E-01, 0.1005E+00, 0.1175E+00, 0.1312E+00, 0.1295E+00,
     * 0.1019E+00, 0.2994E-01, 0.6088E-19 /
        DATA ((QHR(i,j),j=1,83),i=18,18)/
     * 0.2609E-21,-0.5137E-02,-0.4366E-02, 0.5665E-02, 0.1406E-01,
     * 0.1053E-01,-0.1487E-02,-0.1449E-01,-0.2718E-01,-0.3704E-01,
     *-0.4262E-01,-0.4596E-01,-0.4705E-01,-0.4461E-01,-0.4000E-01,
     *-0.3403E-01,-0.2850E-01,-0.2351E-01,-0.1813E-01,-0.1437E-01,
     *-0.1180E-01,-0.9150E-02,-0.8080E-02,-0.7606E-02,-0.6912E-02,
     *-0.6317E-02,-0.6653E-02,-0.7137E-02,-0.6806E-02,-0.6484E-02,
     *-0.6791E-02,-0.6897E-02,-0.6685E-02,-0.6533E-02,-0.6329E-02,
     *-0.6145E-02,-0.6100E-02,-0.5659E-02,-0.5194E-02,-0.4903E-02,
     *-0.4035E-02,-0.3516E-02,-0.3219E-02,-0.3215E-02,-0.2886E-02,
     *-0.1855E-02,-0.9998E-03,-0.6527E-03, 0.1118E-03, 0.1955E-02,
     * 0.2583E-02, 0.2506E-02, 0.4828E-02, 0.8041E-02, 0.8175E-02,
     * 0.9348E-02, 0.1291E-01, 0.1596E-01, 0.1712E-01, 0.2057E-01,
     * 0.2485E-01, 0.2842E-01, 0.3146E-01, 0.3422E-01, 0.3999E-01,
     * 0.4683E-01, 0.5261E-01, 0.5304E-01, 0.5871E-01, 0.6699E-01,
     * 0.7472E-01, 0.7960E-01, 0.7448E-01, 0.8043E-01, 0.8777E-01,
     * 0.9274E-01, 0.9622E-01, 0.8918E-01, 0.6334E-01, 0.4469E-01,
     * 0.4983E-01, 0.3037E-01,-0.8083E-19 /
        DATA ((QHR(i,j),j=1,83),i=19,19)/
     *-0.5096E-22,-0.1452E-02,-0.1341E-02, 0.3994E-02, 0.8694E-02,
     * 0.7307E-02, 0.1631E-03,-0.8888E-02,-0.1740E-01,-0.2431E-01,
     *-0.2893E-01,-0.3167E-01,-0.3279E-01,-0.3224E-01,-0.3074E-01,
     *-0.2843E-01,-0.2558E-01,-0.2300E-01,-0.2036E-01,-0.1808E-01,
     *-0.1626E-01,-0.1461E-01,-0.1347E-01,-0.1259E-01,-0.1191E-01,
     *-0.1146E-01,-0.1129E-01,-0.1118E-01,-0.1106E-01,-0.1105E-01,
     *-0.1115E-01,-0.1122E-01,-0.1127E-01,-0.1145E-01,-0.1163E-01,
     *-0.1178E-01,-0.1197E-01,-0.1215E-01,-0.1226E-01,-0.1244E-01,
     *-0.1260E-01,-0.1262E-01,-0.1264E-01,-0.1282E-01,-0.1311E-01,
     *-0.1314E-01,-0.1309E-01,-0.1327E-01,-0.1331E-01,-0.1307E-01,
     *-0.1300E-01,-0.1300E-01,-0.1248E-01,-0.1171E-01,-0.1125E-01,
     *-0.1065E-01,-0.9443E-02,-0.8028E-02,-0.6614E-02,-0.4800E-02,
     *-0.2568E-02, 0.2316E-03, 0.3061E-02, 0.6070E-02, 0.1038E-01,
     * 0.1547E-01, 0.2014E-01, 0.2522E-01, 0.3139E-01, 0.3847E-01,
     * 0.4606E-01, 0.5331E-01, 0.5918E-01, 0.6658E-01, 0.7396E-01,
     * 0.8132E-01, 0.8653E-01, 0.8619E-01, 0.8140E-01, 0.7159E-01,
     * 0.5400E-01, 0.1954E-01,-0.3907E-19 /
        DATA ((QHR(i,j),j=1,83),i=20,20)/
     *-0.2177E-21, 0.1329E-03, 0.4220E-02, 0.1304E-01, 0.1961E-01,
     * 0.2278E-01, 0.2239E-01, 0.1925E-01, 0.1498E-01, 0.1017E-01,
     * 0.6718E-02, 0.4972E-02, 0.4223E-02, 0.4145E-02, 0.4127E-02,
     * 0.3634E-02, 0.2971E-02, 0.2403E-02, 0.1743E-02, 0.9126E-03,
     *-0.2284E-03,-0.1605E-02,-0.2910E-02,-0.4133E-02,-0.5437E-02,
     *-0.6707E-02,-0.7812E-02,-0.8877E-02,-0.9991E-02,-0.1106E-01,
     *-0.1208E-01,-0.1311E-01,-0.1413E-01,-0.1507E-01,-0.1598E-01,
     *-0.1684E-01,-0.1754E-01,-0.1824E-01,-0.1911E-01,-0.1991E-01,
     *-0.2051E-01,-0.2079E-01,-0.2106E-01,-0.2146E-01,-0.2170E-01,
     *-0.2211E-01,-0.2266E-01,-0.2292E-01,-0.2289E-01,-0.2282E-01,
     *-0.2253E-01,-0.2219E-01,-0.2208E-01,-0.2176E-01,-0.2092E-01,
     *-0.1980E-01,-0.1841E-01,-0.1695E-01,-0.1556E-01,-0.1355E-01,
     *-0.1080E-01,-0.7844E-02,-0.4848E-02,-0.9065E-03, 0.3866E-02,
     * 0.7975E-02, 0.1258E-01, 0.1858E-01, 0.2488E-01, 0.3137E-01,
     * 0.3738E-01, 0.4299E-01, 0.4889E-01, 0.5418E-01, 0.5791E-01,
     * 0.6107E-01, 0.6273E-01, 0.5995E-01, 0.5742E-01, 0.4489E-01,
     * 0.1604E-01, 0.7223E-03,-0.4384E-19 /
c************** MIE (phase fun uh) ***************
        DATA ((UHR(i,j),j=1,83),i= 1, 1)/
     *-0.8426E+00,-0.1512E+00, 0.1679E+00, 0.2232E+00, 0.1845E+00,
     * 0.1837E+00, 0.1682E+00, 0.1336E+00, 0.1150E+00, 0.9094E-01,
     * 0.6528E-01, 0.4627E-01, 0.3770E-01, 0.3534E-01, 0.1775E-01,
     * 0.3677E-02, 0.8794E-02, 0.4774E-02,-0.2936E-02,-0.1055E-02,
     *-0.4216E-02,-0.3930E-02,-0.2856E-02,-0.3038E-02,-0.4482E-02,
     *-0.4071E-02,-0.1590E-02,-0.1264E-02,-0.1784E-02, 0.1478E-02,
     * 0.6338E-02, 0.9648E-02, 0.1363E-01, 0.1701E-01, 0.1945E-01,
     * 0.2154E-01, 0.2649E-01, 0.2941E-01, 0.3563E-01, 0.4004E-01,
     * 0.4883E-01, 0.5012E-01, 0.5580E-01, 0.6611E-01, 0.7306E-01,
     * 0.8434E-01, 0.9886E-01, 0.1162E+00, 0.1320E+00, 0.1552E+00,
     * 0.1820E+00, 0.2120E+00, 0.2457E+00, 0.2747E+00, 0.3210E+00,
     * 0.3711E+00, 0.4338E+00, 0.4887E+00, 0.5837E+00, 0.6498E+00,
     * 0.7571E+00, 0.8658E+00, 0.9953E+00, 0.1155E+01, 0.1299E+01,
     * 0.1498E+01, 0.1695E+01, 0.1936E+01, 0.2238E+01, 0.2501E+01,
     * 0.2871E+01, 0.3273E+01, 0.3754E+01, 0.4364E+01, 0.5061E+01,
     * 0.6005E+01, 0.7627E+01, 0.1032E+02, 0.1574E+02, 0.2932E+02,
     * 0.7389E+02, 0.3217E+03, 0.1844E+04 /
        DATA ((UHR(i,j),j=1,83),i= 2, 2)/
     *-0.7371E+00,-0.2069E+00, 0.1100E+00, 0.2090E+00, 0.2205E+00,
     * 0.1991E+00, 0.1714E+00, 0.1405E+00, 0.1101E+00, 0.9380E-01,
     * 0.8414E-01, 0.6728E-01, 0.5005E-01, 0.3647E-01, 0.2936E-01,
     * 0.1733E-01, 0.6293E-02, 0.3976E-03, 0.1455E-02,-0.3213E-02,
     * 0.5012E-03,-0.3795E-03,-0.3606E-02,-0.2712E-02, 0.8825E-03,
     * 0.3683E-03,-0.1942E-02,-0.1362E-02, 0.8682E-03, 0.3818E-02,
     * 0.7277E-02, 0.8885E-02, 0.1318E-01, 0.1908E-01, 0.2488E-01,
     * 0.2793E-01, 0.3077E-01, 0.3552E-01, 0.3997E-01, 0.4453E-01,
     * 0.5067E-01, 0.5686E-01, 0.5724E-01, 0.6685E-01, 0.8308E-01,
     * 0.9196E-01, 0.1046E+00, 0.1215E+00, 0.1430E+00, 0.1602E+00,
     * 0.1813E+00, 0.2142E+00, 0.2490E+00, 0.2840E+00, 0.3269E+00,
     * 0.3818E+00, 0.4407E+00, 0.5003E+00, 0.5665E+00, 0.6671E+00,
     * 0.7721E+00, 0.8667E+00, 0.1003E+01, 0.1125E+01, 0.1317E+01,
     * 0.1502E+01, 0.1707E+01, 0.1929E+01, 0.2195E+01, 0.2552E+01,
     * 0.2887E+01, 0.3324E+01, 0.3799E+01, 0.4417E+01, 0.5306E+01,
     * 0.6402E+01, 0.8059E+01, 0.1094E+02, 0.1669E+02, 0.3095E+02,
     * 0.7554E+02, 0.2998E+03, 0.1405E+04 /
        DATA ((UHR(i,j),j=1,83),i= 3, 3)/
     *-0.8416E+00,-0.3336E+00, 0.9135E-01, 0.2252E+00, 0.2291E+00,
     * 0.2010E+00, 0.1750E+00, 0.1408E+00, 0.1050E+00, 0.1006E+00,
     * 0.8382E-01, 0.6330E-01, 0.4451E-01, 0.3715E-01, 0.2777E-01,
     * 0.1595E-01,-0.3422E-03,-0.2512E-02,-0.3530E-02,-0.1489E-02,
     *-0.1350E-02,-0.2088E-02,-0.3299E-02,-0.5737E-02,-0.2474E-02,
     *-0.1479E-03,-0.7506E-04, 0.2579E-02, 0.3300E-02, 0.4082E-02,
     * 0.6788E-02, 0.9169E-02, 0.1302E-01, 0.1588E-01, 0.2172E-01,
     * 0.2824E-01, 0.3144E-01, 0.3614E-01, 0.4318E-01, 0.4702E-01,
     * 0.5160E-01, 0.5825E-01, 0.6118E-01, 0.7179E-01, 0.7945E-01,
     * 0.9315E-01, 0.1078E+00, 0.1222E+00, 0.1414E+00, 0.1642E+00,
     * 0.1869E+00, 0.2160E+00, 0.2484E+00, 0.2934E+00, 0.3363E+00,
     * 0.3786E+00, 0.4398E+00, 0.5034E+00, 0.5749E+00, 0.6606E+00,
     * 0.7526E+00, 0.8687E+00, 0.9887E+00, 0.1126E+01, 0.1281E+01,
     * 0.1478E+01, 0.1685E+01, 0.1940E+01, 0.2169E+01, 0.2514E+01,
     * 0.2913E+01, 0.3329E+01, 0.3850E+01, 0.4472E+01, 0.5298E+01,
     * 0.6475E+01, 0.8152E+01, 0.1098E+02, 0.1701E+02, 0.3107E+02,
     * 0.7555E+02, 0.2950E+03, 0.1323E+04 /
        DATA ((UHR(i,j),j=1,83),i= 4, 4)/
     *-0.7122E+00,-0.3136E+00, 0.8403E-01, 0.1993E+00, 0.2105E+00,
     * 0.2002E+00, 0.1792E+00, 0.1470E+00, 0.1066E+00, 0.1020E+00,
     * 0.8936E-01, 0.6719E-01, 0.4886E-01, 0.3401E-01, 0.3445E-01,
     * 0.2153E-01, 0.6380E-02,-0.2794E-03, 0.2265E-02,-0.4472E-03,
     * 0.5364E-03, 0.5133E-03,-0.1371E-02,-0.2577E-02, 0.2268E-02,
     * 0.3891E-02, 0.1116E-02, 0.2810E-02, 0.2739E-02, 0.4702E-02,
     * 0.8594E-02, 0.1042E-01, 0.1405E-01, 0.2009E-01, 0.2662E-01,
     * 0.2858E-01, 0.3317E-01, 0.3922E-01, 0.4341E-01, 0.4793E-01,
     * 0.5442E-01, 0.6102E-01, 0.6086E-01, 0.7101E-01, 0.8426E-01,
     * 0.9396E-01, 0.1087E+00, 0.1254E+00, 0.1472E+00, 0.1664E+00,
     * 0.1890E+00, 0.2186E+00, 0.2529E+00, 0.2941E+00, 0.3354E+00,
     * 0.3837E+00, 0.4436E+00, 0.5064E+00, 0.5696E+00, 0.6681E+00,
     * 0.7630E+00, 0.8767E+00, 0.9972E+00, 0.1128E+01, 0.1305E+01,
     * 0.1499E+01, 0.1699E+01, 0.1942E+01, 0.2207E+01, 0.2569E+01,
     * 0.2944E+01, 0.3385E+01, 0.3902E+01, 0.4559E+01, 0.5443E+01,
     * 0.6633E+01, 0.8412E+01, 0.1146E+02, 0.1748E+02, 0.3186E+02,
     * 0.7563E+02, 0.2820E+03, 0.1138E+04 /
        DATA ((UHR(i,j),j=1,83),i= 5, 5)/
     *-0.8664E+00,-0.3516E+00, 0.9632E-01, 0.2176E+00, 0.2284E+00,
     * 0.2014E+00, 0.1735E+00, 0.1546E+00, 0.1331E+00, 0.9517E-01,
     * 0.8239E-01, 0.6215E-01, 0.4210E-01, 0.3817E-01, 0.1735E-01,
     * 0.6287E-02, 0.8136E-02, 0.3077E-02,-0.3569E-02,-0.2117E-02,
     *-0.1946E-02,-0.3192E-02, 0.6389E-03, 0.4394E-03,-0.1090E-02,
     *-0.8206E-03, 0.6905E-04, 0.1113E-02, 0.7230E-02, 0.9120E-02,
     * 0.1113E-01, 0.1523E-01, 0.1948E-01, 0.2122E-01, 0.2494E-01,
     * 0.2981E-01, 0.3346E-01, 0.4134E-01, 0.4615E-01, 0.5214E-01,
     * 0.5890E-01, 0.6197E-01, 0.7025E-01, 0.7636E-01, 0.8270E-01,
     * 0.9810E-01, 0.1174E+00, 0.1311E+00, 0.1480E+00, 0.1729E+00,
     * 0.2052E+00, 0.2238E+00, 0.2569E+00, 0.3010E+00, 0.3419E+00,
     * 0.3865E+00, 0.4409E+00, 0.5070E+00, 0.5896E+00, 0.6670E+00,
     * 0.7513E+00, 0.8728E+00, 0.9981E+00, 0.1146E+01, 0.1286E+01,
     * 0.1481E+01, 0.1713E+01, 0.1953E+01, 0.2246E+01, 0.2564E+01,
     * 0.2951E+01, 0.3429E+01, 0.3999E+01, 0.4681E+01, 0.5514E+01,
     * 0.6738E+01, 0.8539E+01, 0.1173E+02, 0.1797E+02, 0.3211E+02,
     * 0.7517E+02, 0.2713E+03, 0.1019E+04 /
        DATA ((UHR(i,j),j=1,83),i= 6, 6)/
     *-0.6608E+00,-0.2564E+00, 0.5049E-01, 0.1855E+00, 0.2171E+00,
     * 0.1947E+00, 0.1732E+00, 0.1510E+00, 0.1202E+00, 0.9626E-01,
     * 0.7806E-01, 0.6872E-01, 0.5575E-01, 0.3391E-01, 0.2664E-01,
     * 0.2403E-01, 0.7792E-02, 0.2567E-02, 0.5055E-02, 0.1865E-02,
     * 0.3724E-02, 0.2628E-02,-0.9249E-03, 0.1178E-02, 0.2739E-02,
     * 0.1562E-02, 0.2546E-02, 0.2344E-02, 0.4967E-02, 0.8470E-02,
     * 0.1109E-01, 0.1367E-01, 0.1831E-01, 0.2340E-01, 0.2935E-01,
     * 0.3149E-01, 0.3429E-01, 0.3978E-01, 0.4564E-01, 0.5085E-01,
     * 0.5827E-01, 0.6404E-01, 0.6469E-01, 0.7351E-01, 0.8817E-01,
     * 0.9956E-01, 0.1115E+00, 0.1276E+00, 0.1492E+00, 0.1686E+00,
     * 0.1886E+00, 0.2221E+00, 0.2572E+00, 0.2898E+00, 0.3335E+00,
     * 0.3927E+00, 0.4463E+00, 0.5085E+00, 0.5800E+00, 0.6761E+00,
     * 0.7810E+00, 0.8779E+00, 0.1015E+01, 0.1153E+01, 0.1340E+01,
     * 0.1522E+01, 0.1748E+01, 0.1985E+01, 0.2265E+01, 0.2636E+01,
     * 0.3011E+01, 0.3462E+01, 0.3973E+01, 0.4675E+01, 0.5664E+01,
     * 0.6881E+01, 0.8720E+01, 0.1196E+02, 0.1817E+02, 0.3278E+02,
     * 0.7552E+02, 0.2627E+03, 0.9417E+03 /
        DATA ((UHR(i,j),j=1,83),i= 7, 7)/
     *-0.6706E+00,-0.3198E+00, 0.4301E-01, 0.1719E+00, 0.2037E+00,
     * 0.2043E+00, 0.1804E+00, 0.1490E+00, 0.1157E+00, 0.1037E+00,
     * 0.9017E-01, 0.6776E-01, 0.4827E-01, 0.3547E-01, 0.3437E-01,
     * 0.2049E-01, 0.8467E-02, 0.4040E-02, 0.5856E-02, 0.4377E-03,
     * 0.4102E-02, 0.4671E-02, 0.1700E-02, 0.1434E-02, 0.5700E-02,
     * 0.6306E-02, 0.3382E-02, 0.5572E-02, 0.5700E-02, 0.7806E-02,
     * 0.1250E-01, 0.1375E-01, 0.1729E-01, 0.2386E-01, 0.2992E-01,
     * 0.3261E-01, 0.3714E-01, 0.4285E-01, 0.4749E-01, 0.5290E-01,
     * 0.5921E-01, 0.6534E-01, 0.6603E-01, 0.7655E-01, 0.9017E-01,
     * 0.1003E+00, 0.1156E+00, 0.1324E+00, 0.1545E+00, 0.1743E+00,
     * 0.1961E+00, 0.2268E+00, 0.2609E+00, 0.2997E+00, 0.3424E+00,
     * 0.3936E+00, 0.4521E+00, 0.5162E+00, 0.5815E+00, 0.6780E+00,
     * 0.7763E+00, 0.8903E+00, 0.1014E+01, 0.1144E+01, 0.1331E+01,
     * 0.1529E+01, 0.1730E+01, 0.1979E+01, 0.2261E+01, 0.2622E+01,
     * 0.3010E+01, 0.3489E+01, 0.4041E+01, 0.4737E+01, 0.5717E+01,
     * 0.7025E+01, 0.8932E+01, 0.1221E+02, 0.1851E+02, 0.3308E+02,
     * 0.7502E+02, 0.2533E+03, 0.8424E+03 /
        DATA ((UHR(i,j),j=1,83),i= 8, 8)/
     *-0.5889E+00,-0.3041E+00, 0.2199E-01, 0.1577E+00, 0.1853E+00,
     * 0.1850E+00, 0.1764E+00, 0.1473E+00, 0.1235E+00, 0.9957E-01,
     * 0.7441E-01, 0.5497E-01, 0.4692E-01, 0.3867E-01, 0.2592E-01,
     * 0.1610E-01, 0.1415E-01, 0.9052E-02, 0.6789E-02, 0.5208E-02,
     * 0.2953E-02, 0.2873E-02, 0.4717E-02, 0.4994E-02, 0.3266E-02,
     * 0.3654E-02, 0.7610E-02, 0.7326E-02, 0.7803E-02, 0.1208E-01,
     * 0.1616E-01, 0.1940E-01, 0.2363E-01, 0.2678E-01, 0.2864E-01,
     * 0.3244E-01, 0.3814E-01, 0.4209E-01, 0.4724E-01, 0.5458E-01,
     * 0.6271E-01, 0.6451E-01, 0.6961E-01, 0.7940E-01, 0.9111E-01,
     * 0.1023E+00, 0.1150E+00, 0.1335E+00, 0.1527E+00, 0.1724E+00,
     * 0.1998E+00, 0.2290E+00, 0.2647E+00, 0.2929E+00, 0.3385E+00,
     * 0.3947E+00, 0.4513E+00, 0.5129E+00, 0.5945E+00, 0.6797E+00,
     * 0.7785E+00, 0.8884E+00, 0.1023E+01, 0.1182E+01, 0.1350E+01,
     * 0.1537E+01, 0.1769E+01, 0.2039E+01, 0.2358E+01, 0.2688E+01,
     * 0.3095E+01, 0.3591E+01, 0.4189E+01, 0.4935E+01, 0.5862E+01,
     * 0.7155E+01, 0.9233E+01, 0.1268E+02, 0.1905E+02, 0.3368E+02,
     * 0.7418E+02, 0.2390E+03, 0.7401E+03 /
        DATA ((UHR(i,j),j=1,83),i= 9, 9)/
     *-0.6593E+00,-0.3391E+00, 0.8364E-02, 0.1549E+00, 0.1888E+00,
     * 0.1881E+00, 0.1804E+00, 0.1559E+00, 0.1343E+00, 0.9504E-01,
     * 0.7598E-01, 0.6421E-01, 0.4938E-01, 0.4081E-01, 0.2308E-01,
     * 0.1172E-01, 0.1688E-01, 0.1230E-01, 0.3472E-02, 0.4617E-02,
     * 0.2471E-02, 0.4665E-02, 0.6909E-02, 0.7610E-02, 0.5710E-02,
     * 0.6339E-02, 0.7626E-02, 0.9925E-02, 0.1292E-01, 0.1354E-01,
     * 0.1763E-01, 0.2100E-01, 0.2619E-01, 0.2812E-01, 0.3083E-01,
     * 0.3404E-01, 0.4007E-01, 0.4421E-01, 0.5155E-01, 0.5915E-01,
     * 0.6470E-01, 0.6747E-01, 0.7480E-01, 0.8388E-01, 0.9402E-01,
     * 0.1055E+00, 0.1228E+00, 0.1376E+00, 0.1558E+00, 0.1806E+00,
     * 0.2092E+00, 0.2346E+00, 0.2644E+00, 0.3067E+00, 0.3496E+00,
     * 0.3989E+00, 0.4515E+00, 0.5236E+00, 0.6013E+00, 0.6781E+00,
     * 0.7775E+00, 0.8857E+00, 0.1020E+01, 0.1174E+01, 0.1333E+01,
     * 0.1525E+01, 0.1764E+01, 0.2044E+01, 0.2347E+01, 0.2701E+01,
     * 0.3130E+01, 0.3630E+01, 0.4280E+01, 0.5044E+01, 0.5992E+01,
     * 0.7370E+01, 0.9457E+01, 0.1297E+02, 0.1955E+02, 0.3393E+02,
     * 0.7306E+02, 0.2264E+03, 0.6436E+03 /
        DATA ((UHR(i,j),j=1,83),i=10,10)/
     *-0.6636E+00,-0.3651E+00,-0.1746E-01, 0.1192E+00, 0.1931E+00,
     * 0.1981E+00, 0.1730E+00, 0.1437E+00, 0.1199E+00, 0.1009E+00,
     * 0.8032E-01, 0.6715E-01, 0.5098E-01, 0.3847E-01, 0.2976E-01,
     * 0.1945E-01, 0.7791E-02, 0.6595E-02, 0.5837E-02, 0.6680E-02,
     * 0.5578E-02, 0.5310E-02, 0.6381E-02, 0.6208E-02, 0.6047E-02,
     * 0.7906E-02, 0.8396E-02, 0.1134E-01, 0.1415E-01, 0.1615E-01,
     * 0.1708E-01, 0.2139E-01, 0.2413E-01, 0.2692E-01, 0.3055E-01,
     * 0.3817E-01, 0.4198E-01, 0.4731E-01, 0.5276E-01, 0.5833E-01,
     * 0.6646E-01, 0.7209E-01, 0.7664E-01, 0.8648E-01, 0.9355E-01,
     * 0.1083E+00, 0.1244E+00, 0.1407E+00, 0.1572E+00, 0.1803E+00,
     * 0.2079E+00, 0.2315E+00, 0.2659E+00, 0.3075E+00, 0.3533E+00,
     * 0.3942E+00, 0.4533E+00, 0.5211E+00, 0.6011E+00, 0.6814E+00,
     * 0.7740E+00, 0.9063E+00, 0.1027E+01, 0.1181E+01, 0.1344E+01,
     * 0.1559E+01, 0.1783E+01, 0.2059E+01, 0.2359E+01, 0.2709E+01,
     * 0.3165E+01, 0.3684E+01, 0.4326E+01, 0.5101E+01, 0.6123E+01,
     * 0.7621E+01, 0.9795E+01, 0.1327E+02, 0.2000E+02, 0.3426E+02,
     * 0.7204E+02, 0.2140E+03, 0.5606E+03 /
        DATA ((UHR(i,j),j=1,83),i=11,11)/
     *-0.5688E+00,-0.3293E+00,-0.2160E-01, 0.1168E+00, 0.1559E+00,
     * 0.1794E+00, 0.1709E+00, 0.1498E+00, 0.1308E+00, 0.9775E-01,
     * 0.7300E-01, 0.5842E-01, 0.4893E-01, 0.3945E-01, 0.2725E-01,
     * 0.1045E-01, 0.2091E-01, 0.1823E-01, 0.8151E-02, 0.9053E-02,
     * 0.6726E-02, 0.7144E-02, 0.1054E-01, 0.1033E-01, 0.8399E-02,
     * 0.9657E-02, 0.1143E-01, 0.1189E-01, 0.1542E-01, 0.1610E-01,
     * 0.1942E-01, 0.2356E-01, 0.2721E-01, 0.3069E-01, 0.3326E-01,
     * 0.3684E-01, 0.4270E-01, 0.4649E-01, 0.5345E-01, 0.6171E-01,
     * 0.6764E-01, 0.6934E-01, 0.7545E-01, 0.8753E-01, 0.9770E-01,
     * 0.1084E+00, 0.1249E+00, 0.1418E+00, 0.1593E+00, 0.1824E+00,
     * 0.2086E+00, 0.2389E+00, 0.2686E+00, 0.3051E+00, 0.3524E+00,
     * 0.4012E+00, 0.4587E+00, 0.5242E+00, 0.6075E+00, 0.6836E+00,
     * 0.7891E+00, 0.8994E+00, 0.1038E+01, 0.1196E+01, 0.1364E+01,
     * 0.1558E+01, 0.1808E+01, 0.2095E+01, 0.2414E+01, 0.2782E+01,
     * 0.3243E+01, 0.3759E+01, 0.4442E+01, 0.5265E+01, 0.6297E+01,
     * 0.7730E+01, 0.9962E+01, 0.1366E+02, 0.2032E+02, 0.3448E+02,
     * 0.7086E+02, 0.2021E+03, 0.5002E+03 /
        DATA ((UHR(i,j),j=1,83),i=12,12)/
     *-0.5587E+00,-0.3274E+00,-0.4008E-01, 0.1140E+00, 0.1774E+00,
     * 0.1834E+00, 0.1683E+00, 0.1485E+00, 0.1220E+00, 0.1030E+00,
     * 0.8363E-01, 0.6368E-01, 0.5153E-01, 0.3881E-01, 0.3151E-01,
     * 0.2560E-01, 0.1660E-01, 0.1176E-01, 0.1176E-01, 0.1015E-01,
     * 0.1212E-01, 0.1034E-01, 0.8066E-02, 0.9159E-02, 0.1119E-01,
     * 0.1101E-01, 0.1041E-01, 0.1083E-01, 0.1326E-01, 0.1673E-01,
     * 0.2001E-01, 0.2191E-01, 0.2539E-01, 0.3158E-01, 0.3700E-01,
     * 0.3955E-01, 0.4345E-01, 0.4933E-01, 0.5397E-01, 0.6058E-01,
     * 0.6889E-01, 0.7388E-01, 0.7673E-01, 0.8589E-01, 0.9998E-01,
     * 0.1118E+00, 0.1247E+00, 0.1419E+00, 0.1632E+00, 0.1817E+00,
     * 0.2045E+00, 0.2356E+00, 0.2719E+00, 0.3053E+00, 0.3478E+00,
     * 0.4032E+00, 0.4600E+00, 0.5230E+00, 0.5951E+00, 0.6927E+00,
     * 0.7986E+00, 0.9034E+00, 0.1042E+01, 0.1189E+01, 0.1383E+01,
     * 0.1592E+01, 0.1821E+01, 0.2087E+01, 0.2409E+01, 0.2807E+01,
     * 0.3232E+01, 0.3774E+01, 0.4394E+01, 0.5224E+01, 0.6392E+01,
     * 0.7899E+01, 0.1010E+02, 0.1373E+02, 0.2039E+02, 0.3457E+02,
     * 0.7078E+02, 0.1962E+03, 0.4667E+03 /
        DATA ((UHR(i,j),j=1,83),i=13,13)/
     *-0.5378E+00,-0.3285E+00,-0.4629E-01, 0.9712E-01, 0.1408E+00,
     * 0.1680E+00, 0.1685E+00, 0.1478E+00, 0.1240E+00, 0.9613E-01,
     * 0.7267E-01, 0.5809E-01, 0.4780E-01, 0.3904E-01, 0.2642E-01,
     * 0.1512E-01, 0.2154E-01, 0.1900E-01, 0.1230E-01, 0.1123E-01,
     * 0.9375E-02, 0.9789E-02, 0.1182E-01, 0.1229E-01, 0.1105E-01,
     * 0.1169E-01, 0.1397E-01, 0.1553E-01, 0.1730E-01, 0.1899E-01,
     * 0.2263E-01, 0.2562E-01, 0.3010E-01, 0.3259E-01, 0.3540E-01,
     * 0.3981E-01, 0.4567E-01, 0.4981E-01, 0.5782E-01, 0.6443E-01,
     * 0.7186E-01, 0.7388E-01, 0.7914E-01, 0.9051E-01, 0.1021E+00,
     * 0.1125E+00, 0.1281E+00, 0.1461E+00, 0.1630E+00, 0.1850E+00,
     * 0.2130E+00, 0.2424E+00, 0.2725E+00, 0.3088E+00, 0.3551E+00,
     * 0.4043E+00, 0.4636E+00, 0.5248E+00, 0.6120E+00, 0.6907E+00,
     * 0.7937E+00, 0.9086E+00, 0.1055E+01, 0.1210E+01, 0.1387E+01,
     * 0.1594E+01, 0.1845E+01, 0.2137E+01, 0.2481E+01, 0.2857E+01,
     * 0.3339E+01, 0.3902E+01, 0.4603E+01, 0.5486E+01, 0.6591E+01,
     * 0.8117E+01, 0.1046E+02, 0.1426E+02, 0.2095E+02, 0.3473E+02,
     * 0.6822E+02, 0.1793E+03, 0.3911E+03 /
        DATA ((UHR(i,j),j=1,83),i=14,14)/
     *-0.5168E+00,-0.3438E+00,-0.6097E-01, 0.8793E-01, 0.1405E+00,
     * 0.1646E+00, 0.1628E+00, 0.1442E+00, 0.1247E+00, 0.9378E-01,
     * 0.7476E-01, 0.6281E-01, 0.4919E-01, 0.3882E-01, 0.2669E-01,
     * 0.1515E-01, 0.2085E-01, 0.1814E-01, 0.1036E-01, 0.1216E-01,
     * 0.9457E-02, 0.1169E-01, 0.1460E-01, 0.1453E-01, 0.1394E-01,
     * 0.1413E-01, 0.1633E-01, 0.1773E-01, 0.2035E-01, 0.2221E-01,
     * 0.2462E-01, 0.2899E-01, 0.3353E-01, 0.3569E-01, 0.3918E-01,
     * 0.4318E-01, 0.4883E-01, 0.5382E-01, 0.6063E-01, 0.6961E-01,
     * 0.7470E-01, 0.7788E-01, 0.8467E-01, 0.9541E-01, 0.1055E+00,
     * 0.1180E+00, 0.1339E+00, 0.1499E+00, 0.1681E+00, 0.1912E+00,
     * 0.2183E+00, 0.2468E+00, 0.2760E+00, 0.3164E+00, 0.3611E+00,
     * 0.4104E+00, 0.4662E+00, 0.5354E+00, 0.6143E+00, 0.6954E+00,
     * 0.8001E+00, 0.9160E+00, 0.1059E+01, 0.1222E+01, 0.1399E+01,
     * 0.1608E+01, 0.1873E+01, 0.2176E+01, 0.2521E+01, 0.2926E+01,
     * 0.3434E+01, 0.4024E+01, 0.4787E+01, 0.5710E+01, 0.6868E+01,
     * 0.8504E+01, 0.1093E+02, 0.1475E+02, 0.2146E+02, 0.3459E+02,
     * 0.6527E+02, 0.1592E+03, 0.3092E+03 /
        DATA ((UHR(i,j),j=1,83),i=15,15)/
     *-0.3996E+00,-0.3168E+00,-0.1228E+00, 0.1827E-01, 0.9226E-01,
     * 0.1194E+00, 0.1239E+00, 0.1140E+00, 0.9693E-01, 0.8495E-01,
     * 0.7222E-01, 0.5605E-01, 0.4485E-01, 0.3834E-01, 0.3263E-01,
     * 0.2842E-01, 0.2225E-01, 0.1883E-01, 0.1916E-01, 0.1937E-01,
     * 0.1935E-01, 0.1982E-01, 0.1889E-01, 0.1784E-01, 0.2071E-01,
     * 0.2268E-01, 0.2282E-01, 0.2415E-01, 0.2597E-01, 0.2800E-01,
     * 0.3068E-01, 0.3297E-01, 0.3614E-01, 0.4040E-01, 0.4572E-01,
     * 0.5020E-01, 0.5506E-01, 0.6099E-01, 0.6752E-01, 0.7365E-01,
     * 0.8126E-01, 0.8619E-01, 0.9118E-01, 0.1010E+00, 0.1111E+00,
     * 0.1247E+00, 0.1396E+00, 0.1558E+00, 0.1759E+00, 0.1983E+00,
     * 0.2222E+00, 0.2502E+00, 0.2848E+00, 0.3254E+00, 0.3679E+00,
     * 0.4154E+00, 0.4781E+00, 0.5479E+00, 0.6221E+00, 0.7134E+00,
     * 0.8247E+00, 0.9508E+00, 0.1090E+01, 0.1261E+01, 0.1461E+01,
     * 0.1705E+01, 0.1980E+01, 0.2309E+01, 0.2693E+01, 0.3179E+01,
     * 0.3754E+01, 0.4436E+01, 0.5285E+01, 0.6362E+01, 0.7768E+01,
     * 0.9639E+01, 0.1222E+02, 0.1605E+02, 0.2228E+02, 0.3338E+02,
     * 0.5602E+02, 0.1104E+03, 0.1619E+03 /
        DATA ((UHR(i,j),j=1,83),i=16,16)/
     *-0.3001E+00,-0.2572E+00,-0.1320E+00,-0.2010E-01, 0.4422E-01,
     * 0.7563E-01, 0.8821E-01, 0.8727E-01, 0.7862E-01, 0.6639E-01,
     * 0.5388E-01, 0.4542E-01, 0.3776E-01, 0.3177E-01, 0.2771E-01,
     * 0.2399E-01, 0.2183E-01, 0.2161E-01, 0.2033E-01, 0.1909E-01,
     * 0.1917E-01, 0.1939E-01, 0.2009E-01, 0.2156E-01, 0.2164E-01,
     * 0.2229E-01, 0.2475E-01, 0.2657E-01, 0.2792E-01, 0.3036E-01,
     * 0.3320E-01, 0.3623E-01, 0.3949E-01, 0.4289E-01, 0.4617E-01,
     * 0.5076E-01, 0.5606E-01, 0.6098E-01, 0.6700E-01, 0.7474E-01,
     * 0.8249E-01, 0.8622E-01, 0.9038E-01, 0.1005E+00, 0.1125E+00,
     * 0.1253E+00, 0.1388E+00, 0.1561E+00, 0.1755E+00, 0.1963E+00,
     * 0.2214E+00, 0.2521E+00, 0.2848E+00, 0.3217E+00, 0.3663E+00,
     * 0.4196E+00, 0.4784E+00, 0.5467E+00, 0.6280E+00, 0.7239E+00,
     * 0.8331E+00, 0.9599E+00, 0.1113E+01, 0.1295E+01, 0.1508E+01,
     * 0.1754E+01, 0.2053E+01, 0.2412E+01, 0.2845E+01, 0.3351E+01,
     * 0.3963E+01, 0.4726E+01, 0.5662E+01, 0.6828E+01, 0.8299E+01,
     * 0.1023E+02, 0.1289E+02, 0.1674E+02, 0.2259E+02, 0.3241E+02,
     * 0.5058E+02, 0.8807E+02, 0.1147E+03 /
        DATA ((UHR(i,j),j=1,83),i=17,17)/
     *-0.2823E+00,-0.2452E+00,-0.1304E+00,-0.2797E-01, 0.3310E-01,
     * 0.6589E-01, 0.8013E-01, 0.7979E-01, 0.7176E-01, 0.6056E-01,
     * 0.5007E-01, 0.4322E-01, 0.3693E-01, 0.3125E-01, 0.2626E-01,
     * 0.2268E-01, 0.2242E-01, 0.2178E-01, 0.1981E-01, 0.1903E-01,
     * 0.1882E-01, 0.1913E-01, 0.2066E-01, 0.2198E-01, 0.2199E-01,
     * 0.2280E-01, 0.2518E-01, 0.2712E-01, 0.2865E-01, 0.3087E-01,
     * 0.3344E-01, 0.3626E-01, 0.3996E-01, 0.4317E-01, 0.4626E-01,
     * 0.5076E-01, 0.5599E-01, 0.6105E-01, 0.6718E-01, 0.7457E-01,
     * 0.8209E-01, 0.8588E-01, 0.9003E-01, 0.1002E+00, 0.1122E+00,
     * 0.1243E+00, 0.1384E+00, 0.1556E+00, 0.1744E+00, 0.1953E+00,
     * 0.2211E+00, 0.2506E+00, 0.2833E+00, 0.3205E+00, 0.3654E+00,
     * 0.4183E+00, 0.4771E+00, 0.5455E+00, 0.6285E+00, 0.7237E+00,
     * 0.8331E+00, 0.9629E+00, 0.1119E+01, 0.1303E+01, 0.1517E+01,
     * 0.1768E+01, 0.2075E+01, 0.2443E+01, 0.2882E+01, 0.3400E+01,
     * 0.4037E+01, 0.4821E+01, 0.5783E+01, 0.6978E+01, 0.8481E+01,
     * 0.1045E+02, 0.1313E+02, 0.1693E+02, 0.2263E+02, 0.3196E+02,
     * 0.4869E+02, 0.8146E+02, 0.1025E+03 /
        DATA ((UHR(i,j),j=1,83),i=18,18)/
     *-0.2252E+00,-0.2012E+00,-0.1206E+00,-0.4027E-01, 0.1409E-01,
     * 0.4580E-01, 0.5784E-01, 0.5822E-01, 0.5374E-01, 0.4651E-01,
     * 0.4075E-01, 0.3561E-01, 0.3126E-01, 0.2733E-01, 0.2306E-01,
     * 0.2054E-01, 0.1991E-01, 0.1853E-01, 0.1776E-01, 0.1820E-01,
     * 0.1831E-01, 0.1893E-01, 0.2021E-01, 0.2124E-01, 0.2228E-01,
     * 0.2362E-01, 0.2499E-01, 0.2684E-01, 0.2928E-01, 0.3124E-01,
     * 0.3319E-01, 0.3620E-01, 0.3956E-01, 0.4284E-01, 0.4656E-01,
     * 0.5099E-01, 0.5587E-01, 0.6142E-01, 0.6764E-01, 0.7421E-01,
     * 0.8162E-01, 0.8595E-01, 0.9080E-01, 0.1008E+00, 0.1112E+00,
     * 0.1239E+00, 0.1392E+00, 0.1552E+00, 0.1734E+00, 0.1960E+00,
     * 0.2214E+00, 0.2491E+00, 0.2817E+00, 0.3210E+00, 0.3656E+00,
     * 0.4164E+00, 0.4760E+00, 0.5468E+00, 0.6288E+00, 0.7239E+00,
     * 0.8362E+00, 0.9702E+00, 0.1129E+01, 0.1315E+01, 0.1535E+01,
     * 0.1800E+01, 0.2119E+01, 0.2498E+01, 0.2955E+01, 0.3507E+01,
     * 0.4180E+01, 0.5000E+01, 0.6014E+01, 0.7266E+01, 0.8844E+01,
     * 0.1089E+02, 0.1359E+02, 0.1733E+02, 0.2274E+02, 0.3112E+02,
     * 0.4521E+02, 0.6977E+02, 0.8255E+02 /
        DATA ((UHR(i,j),j=1,83),i=19,19)/
     *-0.1310E+00,-0.1223E+00,-0.8941E-01,-0.4865E-01,-0.1497E-01,
     * 0.6717E-02, 0.1750E-01, 0.2105E-01, 0.2099E-01, 0.1948E-01,
     * 0.1779E-01, 0.1642E-01, 0.1511E-01, 0.1386E-01, 0.1282E-01,
     * 0.1222E-01, 0.1221E-01, 0.1227E-01, 0.1246E-01, 0.1295E-01,
     * 0.1350E-01, 0.1435E-01, 0.1545E-01, 0.1660E-01, 0.1776E-01,
     * 0.1899E-01, 0.2047E-01, 0.2222E-01, 0.2413E-01, 0.2606E-01,
     * 0.2818E-01, 0.3071E-01, 0.3364E-01, 0.3675E-01, 0.4013E-01,
     * 0.4405E-01, 0.4854E-01, 0.5350E-01, 0.5903E-01, 0.6528E-01,
     * 0.7238E-01, 0.7627E-01, 0.8041E-01, 0.8949E-01, 0.9980E-01,
     * 0.1116E+00, 0.1251E+00, 0.1404E+00, 0.1580E+00, 0.1783E+00,
     * 0.2018E+00, 0.2286E+00, 0.2597E+00, 0.2960E+00, 0.3381E+00,
     * 0.3871E+00, 0.4444E+00, 0.5117E+00, 0.5910E+00, 0.6842E+00,
     * 0.7944E+00, 0.9258E+00, 0.1082E+01, 0.1269E+01, 0.1492E+01,
     * 0.1762E+01, 0.2087E+01, 0.2481E+01, 0.2959E+01, 0.3543E+01,
     * 0.4259E+01, 0.5141E+01, 0.6236E+01, 0.7603E+01, 0.9331E+01,
     * 0.1155E+02, 0.1447E+02, 0.1843E+02, 0.2401E+02, 0.3234E+02,
     * 0.4558E+02, 0.6589E+02, 0.7490E+02 /
        DATA ((UHR(i,j),j=1,83),i=20,20)/
     *-0.2124E+00,-0.2030E+00,-0.1662E+00,-0.1175E+00,-0.7631E-01,
     *-0.4685E-01,-0.2746E-01,-0.1602E-01,-0.9286E-02,-0.5518E-02,
     *-0.3717E-02,-0.3145E-02,-0.2474E-02,-0.1032E-02, 0.7928E-03,
     * 0.2525E-02, 0.4049E-02, 0.5865E-02, 0.8004E-02, 0.1014E-01,
     * 0.1221E-01, 0.1418E-01, 0.1608E-01, 0.1824E-01, 0.2061E-01,
     * 0.2291E-01, 0.2532E-01, 0.2811E-01, 0.3125E-01, 0.3468E-01,
     * 0.3836E-01, 0.4230E-01, 0.4684E-01, 0.5219E-01, 0.5803E-01,
     * 0.6425E-01, 0.7121E-01, 0.7906E-01, 0.8776E-01, 0.9752E-01,
     * 0.1086E+00, 0.1146E+00, 0.1208E+00, 0.1344E+00, 0.1497E+00,
     * 0.1671E+00, 0.1868E+00, 0.2091E+00, 0.2344E+00, 0.2628E+00,
     * 0.2950E+00, 0.3321E+00, 0.3751E+00, 0.4240E+00, 0.4795E+00,
     * 0.5437E+00, 0.6179E+00, 0.7035E+00, 0.8024E+00, 0.9178E+00,
     * 0.1052E+01, 0.1208E+01, 0.1388E+01, 0.1600E+01, 0.1850E+01,
     * 0.2143E+01, 0.2485E+01, 0.2886E+01, 0.3361E+01, 0.3923E+01,
     * 0.4587E+01, 0.5373E+01, 0.6304E+01, 0.7422E+01, 0.8772E+01,
     * 0.1041E+02, 0.1242E+02, 0.1493E+02, 0.1815E+02, 0.2239E+02,
     * 0.2790E+02, 0.3310E+02, 0.3469E+02 /



      vi_m=4.99809027
      vi(3)=vi_m
      do 1 i=1,20
       asy(3,i)=asy_m(i)
       ex(3,i)=ex_m(i)
       sc(3,i)=sc_m(i)
      do 1 j=1,nquad
      ph(i,j)=phr(i,j)
      qh(i,j)=qhr(i,j)
      uh(i,j)=uhr(i,j)
    1 continue
      return
      end
