      subroutine  bbm

c - to vary the number of quadratures
      include "paramdef.inc"
      integer nquad
      common /num_quad/ nquad
      real ph,qh,uh
      common /sixs_aerbas/ ph(20,nqmax_p),qh(20,nqmax_p),uh(20,nqmax_p)
      real phr(20,nqdef_p),qhr(20,nqdef_p),uhr(20,nqdef_p)
c - to vary the number of quadratures
      real ex,sc,asy,vi
      common /sixs_coef/ ex(4,20),sc(4,20),asy(4,20),vi(4)
      real ex_m(20),sc_m(20),asy_m(20)
      integer i,j

c Biomass burning model
c Parameters and reflractive indices - AERONET measurements
c (see file BBM-params.dat)
c Extinction coefficients are calculated in km-1

c*************** MIE (asy) ******************
      data (asy_m(j),j=1,20)/
     a 0.709,0.689,0.684,0.671,0.659,0.651,0.639,0.623,0.605,0.586,
     a 0.570,0.560,0.534,0.500,0.455,0.493,0.515,0.573,0.619,0.698/
c*************** MIE (ext&sca) ******************
        data (ex_m(j),sc_m(j),j=1,20) /
     a 0.8254323E-01,0.7805500E-01,0.6873854E-01,0.6486657E-01,
     a 0.6574472E-01,0.6199898E-01,0.5858313E-01,0.5513438E-01,
     a 0.5299549E-01,0.4977275E-01,0.4958472E-01,0.4650205E-01,
     a 0.4491529E-01,0.4202277E-01,0.3959285E-01,0.3691657E-01,
     a 0.3440313E-01,0.3194462E-01,0.2972500E-01,0.2746937E-01,
     a 0.2632282E-01,0.2421588E-01,0.2437306E-01,0.2235581E-01,
     a 0.1990872E-01,0.1810272E-01,0.1504618E-01,0.1349245E-01,
     a 0.6794238E-02,0.5778257E-02,0.4662405E-02,0.3859948E-02,
     a 0.4203070E-02,0.3459487E-02,0.3449567E-02,0.2823499E-02,
     a 0.3032236E-02,0.2492706E-02,0.2203834E-02,0.1881847E-02 /
c************** MIE (phase fun ph) ***************
        DATA ((PHR(i,j),j=1,83),i= 1, 1)/
     *0.1683E+00,0.1674E+00,0.1655E+00,0.1613E+00,0.1557E+00,
     *0.1499E+00,0.1445E+00,0.1400E+00,0.1361E+00,0.1327E+00,
     *0.1299E+00,0.1276E+00,0.1257E+00,0.1239E+00,0.1222E+00,
     *0.1207E+00,0.1193E+00,0.1180E+00,0.1168E+00,0.1158E+00,
     *0.1149E+00,0.1143E+00,0.1140E+00,0.1140E+00,0.1143E+00,
     *0.1150E+00,0.1161E+00,0.1177E+00,0.1197E+00,0.1224E+00,
     *0.1256E+00,0.1295E+00,0.1340E+00,0.1392E+00,0.1453E+00,
     *0.1523E+00,0.1604E+00,0.1696E+00,0.1801E+00,0.1921E+00,
     *0.2057E+00,0.2132E+00,0.2212E+00,0.2388E+00,0.2588E+00,
     *0.2814E+00,0.3072E+00,0.3366E+00,0.3701E+00,0.4085E+00,
     *0.4524E+00,0.5027E+00,0.5606E+00,0.6270E+00,0.7033E+00,
     *0.7911E+00,0.8919E+00,0.1008E+01,0.1141E+01,0.1295E+01,
     *0.1471E+01,0.1672E+01,0.1903E+01,0.2166E+01,0.2465E+01,
     *0.2803E+01,0.3184E+01,0.3610E+01,0.4084E+01,0.4606E+01,
     *0.5175E+01,0.5789E+01,0.6442E+01,0.7125E+01,0.7826E+01,
     *0.8531E+01,0.9226E+01,0.9899E+01,0.1057E+02,0.1134E+02,
     *0.1287E+02,0.2031E+02,0.5392E+02 /
        DATA ((PHR(i,j),j=1,83),i= 2, 2)/
     *0.1692E+00,0.1683E+00,0.1670E+00,0.1642E+00,0.1600E+00,
     *0.1553E+00,0.1506E+00,0.1464E+00,0.1423E+00,0.1384E+00,
     *0.1349E+00,0.1318E+00,0.1291E+00,0.1267E+00,0.1247E+00,
     *0.1230E+00,0.1216E+00,0.1204E+00,0.1195E+00,0.1188E+00,
     *0.1183E+00,0.1182E+00,0.1184E+00,0.1189E+00,0.1198E+00,
     *0.1212E+00,0.1230E+00,0.1253E+00,0.1281E+00,0.1315E+00,
     *0.1355E+00,0.1403E+00,0.1458E+00,0.1523E+00,0.1596E+00,
     *0.1680E+00,0.1776E+00,0.1884E+00,0.2007E+00,0.2146E+00,
     *0.2303E+00,0.2390E+00,0.2482E+00,0.2684E+00,0.2914E+00,
     *0.3175E+00,0.3472E+00,0.3809E+00,0.4193E+00,0.4629E+00,
     *0.5126E+00,0.5690E+00,0.6333E+00,0.7064E+00,0.7897E+00,
     *0.8845E+00,0.9924E+00,0.1115E+01,0.1255E+01,0.1413E+01,
     *0.1592E+01,0.1794E+01,0.2022E+01,0.2278E+01,0.2564E+01,
     *0.2882E+01,0.3234E+01,0.3621E+01,0.4043E+01,0.4500E+01,
     *0.4988E+01,0.5505E+01,0.6045E+01,0.6599E+01,0.7160E+01,
     *0.7718E+01,0.8265E+01,0.8803E+01,0.9368E+01,0.1012E+02,
     *0.1185E+02,0.2001E+02,0.4940E+02 /
        DATA ((PHR(i,j),j=1,83),i= 3, 3)/
     *0.1705E+00,0.1696E+00,0.1684E+00,0.1659E+00,0.1619E+00,
     *0.1573E+00,0.1529E+00,0.1487E+00,0.1446E+00,0.1406E+00,
     *0.1370E+00,0.1338E+00,0.1308E+00,0.1283E+00,0.1263E+00,
     *0.1245E+00,0.1230E+00,0.1218E+00,0.1208E+00,0.1202E+00,
     *0.1198E+00,0.1197E+00,0.1200E+00,0.1206E+00,0.1216E+00,
     *0.1231E+00,0.1251E+00,0.1276E+00,0.1306E+00,0.1342E+00,
     *0.1384E+00,0.1434E+00,0.1492E+00,0.1558E+00,0.1635E+00,
     *0.1722E+00,0.1821E+00,0.1933E+00,0.2061E+00,0.2205E+00,
     *0.2368E+00,0.2457E+00,0.2552E+00,0.2761E+00,0.2998E+00,
     *0.3268E+00,0.3573E+00,0.3920E+00,0.4314E+00,0.4761E+00,
     *0.5269E+00,0.5847E+00,0.6503E+00,0.7249E+00,0.8096E+00,
     *0.9058E+00,0.1015E+01,0.1139E+01,0.1279E+01,0.1438E+01,
     *0.1617E+01,0.1819E+01,0.2045E+01,0.2298E+01,0.2580E+01,
     *0.2893E+01,0.3238E+01,0.3615E+01,0.4025E+01,0.4466E+01,
     *0.4937E+01,0.5433E+01,0.5949E+01,0.6477E+01,0.7010E+01,
     *0.7540E+01,0.8059E+01,0.8573E+01,0.9124E+01,0.9883E+01,
     *0.1167E+02,0.2002E+02,0.4863E+02 /
        DATA ((PHR(i,j),j=1,83),i= 4, 4)/
     *0.1751E+00,0.1741E+00,0.1731E+00,0.1710E+00,0.1676E+00,
     *0.1636E+00,0.1595E+00,0.1556E+00,0.1516E+00,0.1474E+00,
     *0.1435E+00,0.1399E+00,0.1367E+00,0.1338E+00,0.1315E+00,
     *0.1295E+00,0.1278E+00,0.1265E+00,0.1256E+00,0.1250E+00,
     *0.1247E+00,0.1248E+00,0.1253E+00,0.1262E+00,0.1275E+00,
     *0.1292E+00,0.1315E+00,0.1344E+00,0.1378E+00,0.1419E+00,
     *0.1466E+00,0.1521E+00,0.1585E+00,0.1658E+00,0.1741E+00,
     *0.1836E+00,0.1944E+00,0.2067E+00,0.2206E+00,0.2363E+00,
     *0.2540E+00,0.2637E+00,0.2741E+00,0.2967E+00,0.3223E+00,
     *0.3512E+00,0.3839E+00,0.4208E+00,0.4626E+00,0.5100E+00,
     *0.5636E+00,0.6243E+00,0.6930E+00,0.7707E+00,0.8585E+00,
     *0.9578E+00,0.1070E+01,0.1196E+01,0.1338E+01,0.1497E+01,
     *0.1675E+01,0.1874E+01,0.2095E+01,0.2341E+01,0.2612E+01,
     *0.2909E+01,0.3234E+01,0.3587E+01,0.3966E+01,0.4371E+01,
     *0.4798E+01,0.5244E+01,0.5705E+01,0.6174E+01,0.6644E+01,
     *0.7109E+01,0.7568E+01,0.8033E+01,0.8557E+01,0.9343E+01,
     *0.1129E+02,0.2014E+02,0.4703E+02 /
        DATA ((PHR(i,j),j=1,83),i= 5, 5)/
     *0.1805E+00,0.1795E+00,0.1788E+00,0.1771E+00,0.1739E+00,
     *0.1703E+00,0.1666E+00,0.1628E+00,0.1588E+00,0.1548E+00,
     *0.1508E+00,0.1468E+00,0.1432E+00,0.1402E+00,0.1377E+00,
     *0.1355E+00,0.1338E+00,0.1324E+00,0.1314E+00,0.1308E+00,
     *0.1306E+00,0.1307E+00,0.1313E+00,0.1323E+00,0.1338E+00,
     *0.1357E+00,0.1382E+00,0.1413E+00,0.1450E+00,0.1494E+00,
     *0.1545E+00,0.1605E+00,0.1673E+00,0.1751E+00,0.1840E+00,
     *0.1942E+00,0.2058E+00,0.2188E+00,0.2336E+00,0.2504E+00,
     *0.2694E+00,0.2797E+00,0.2907E+00,0.3148E+00,0.3419E+00,
     *0.3726E+00,0.4071E+00,0.4460E+00,0.4898E+00,0.5392E+00,
     *0.5949E+00,0.6577E+00,0.7286E+00,0.8084E+00,0.8981E+00,
     *0.9990E+00,0.1112E+01,0.1239E+01,0.1381E+01,0.1539E+01,
     *0.1716E+01,0.1911E+01,0.2127E+01,0.2365E+01,0.2626E+01,
     *0.2910E+01,0.3218E+01,0.3550E+01,0.3904E+01,0.4280E+01,
     *0.4674E+01,0.5082E+01,0.5501E+01,0.5924E+01,0.6349E+01,
     *0.6769E+01,0.7187E+01,0.7620E+01,0.8133E+01,0.8960E+01,
     *0.1108E+02,0.2037E+02,0.4604E+02 /
        DATA ((PHR(i,j),j=1,83),i= 6, 6)/
     *0.1851E+00,0.1841E+00,0.1834E+00,0.1818E+00,0.1789E+00,
     *0.1755E+00,0.1720E+00,0.1686E+00,0.1648E+00,0.1604E+00,
     *0.1561E+00,0.1523E+00,0.1487E+00,0.1455E+00,0.1427E+00,
     *0.1405E+00,0.1386E+00,0.1372E+00,0.1362E+00,0.1355E+00,
     *0.1353E+00,0.1354E+00,0.1360E+00,0.1371E+00,0.1386E+00,
     *0.1406E+00,0.1432E+00,0.1464E+00,0.1503E+00,0.1548E+00,
     *0.1601E+00,0.1663E+00,0.1735E+00,0.1817E+00,0.1910E+00,
     *0.2016E+00,0.2137E+00,0.2273E+00,0.2428E+00,0.2601E+00,
     *0.2797E+00,0.2905E+00,0.3018E+00,0.3269E+00,0.3549E+00,
     *0.3865E+00,0.4221E+00,0.4622E+00,0.5073E+00,0.5580E+00,
     *0.6151E+00,0.6792E+00,0.7512E+00,0.8320E+00,0.9227E+00,
     *0.1024E+01,0.1138E+01,0.1265E+01,0.1406E+01,0.1564E+01,
     *0.1738E+01,0.1931E+01,0.2143E+01,0.2376E+01,0.2629E+01,
     *0.2905E+01,0.3202E+01,0.3521E+01,0.3860E+01,0.4217E+01,
     *0.4590E+01,0.4976E+01,0.5370E+01,0.5768E+01,0.6165E+01,
     *0.6559E+01,0.6955E+01,0.7373E+01,0.7886E+01,0.8743E+01,
     *0.1097E+02,0.2056E+02,0.4552E+02 /
        DATA ((PHR(i,j),j=1,83),i= 7, 7)/
     *0.1939E+00,0.1928E+00,0.1920E+00,0.1907E+00,0.1882E+00,
     *0.1850E+00,0.1818E+00,0.1786E+00,0.1749E+00,0.1705E+00,
     *0.1661E+00,0.1620E+00,0.1582E+00,0.1547E+00,0.1518E+00,
     *0.1493E+00,0.1472E+00,0.1456E+00,0.1445E+00,0.1437E+00,
     *0.1433E+00,0.1435E+00,0.1440E+00,0.1451E+00,0.1466E+00,
     *0.1487E+00,0.1514E+00,0.1548E+00,0.1588E+00,0.1636E+00,
     *0.1692E+00,0.1758E+00,0.1833E+00,0.1920E+00,0.2019E+00,
     *0.2131E+00,0.2258E+00,0.2403E+00,0.2565E+00,0.2748E+00,
     *0.2954E+00,0.3066E+00,0.3186E+00,0.3448E+00,0.3741E+00,
     *0.4071E+00,0.4442E+00,0.4858E+00,0.5325E+00,0.5850E+00,
     *0.6437E+00,0.7095E+00,0.7830E+00,0.8652E+00,0.9570E+00,
     *0.1059E+01,0.1173E+01,0.1300E+01,0.1440E+01,0.1595E+01,
     *0.1766E+01,0.1954E+01,0.2159E+01,0.2384E+01,0.2627E+01,
     *0.2889E+01,0.3170E+01,0.3470E+01,0.3787E+01,0.4119E+01,
     *0.4464E+01,0.4819E+01,0.5180E+01,0.5543E+01,0.5906E+01,
     *0.6268E+01,0.6637E+01,0.7039E+01,0.7558E+01,0.8471E+01,
     *0.1089E+02,0.2095E+02,0.4501E+02 /
        DATA ((PHR(i,j),j=1,83),i= 8, 8)/
     *0.2078E+00,0.2067E+00,0.2061E+00,0.2049E+00,0.2025E+00,
     *0.1997E+00,0.1970E+00,0.1939E+00,0.1901E+00,0.1858E+00,
     *0.1812E+00,0.1766E+00,0.1724E+00,0.1687E+00,0.1653E+00,
     *0.1625E+00,0.1603E+00,0.1584E+00,0.1570E+00,0.1560E+00,
     *0.1555E+00,0.1555E+00,0.1559E+00,0.1569E+00,0.1585E+00,
     *0.1606E+00,0.1634E+00,0.1669E+00,0.1711E+00,0.1762E+00,
     *0.1822E+00,0.1891E+00,0.1971E+00,0.2063E+00,0.2168E+00,
     *0.2287E+00,0.2421E+00,0.2574E+00,0.2745E+00,0.2939E+00,
     *0.3157E+00,0.3275E+00,0.3401E+00,0.3675E+00,0.3984E+00,
     *0.4329E+00,0.4716E+00,0.5149E+00,0.5634E+00,0.6175E+00,
     *0.6779E+00,0.7452E+00,0.8202E+00,0.9037E+00,0.9962E+00,
     *0.1099E+01,0.1212E+01,0.1337E+01,0.1475E+01,0.1627E+01,
     *0.1793E+01,0.1974E+01,0.2170E+01,0.2383E+01,0.2613E+01,
     *0.2858E+01,0.3120E+01,0.3397E+01,0.3687E+01,0.3990E+01,
     *0.4302E+01,0.4622E+01,0.4946E+01,0.5271E+01,0.5597E+01,
     *0.5926E+01,0.6268E+01,0.6660E+01,0.7201E+01,0.8211E+01,
     *0.1090E+02,0.2158E+02,0.4463E+02 /
        DATA ((PHR(i,j),j=1,83),i= 9, 9)/
     *0.2255E+00,0.2242E+00,0.2234E+00,0.2225E+00,0.2205E+00,
     *0.2180E+00,0.2155E+00,0.2126E+00,0.2089E+00,0.2047E+00,
     *0.2000E+00,0.1950E+00,0.1903E+00,0.1863E+00,0.1827E+00,
     *0.1796E+00,0.1770E+00,0.1748E+00,0.1731E+00,0.1719E+00,
     *0.1713E+00,0.1711E+00,0.1714E+00,0.1723E+00,0.1738E+00,
     *0.1760E+00,0.1788E+00,0.1824E+00,0.1868E+00,0.1920E+00,
     *0.1982E+00,0.2054E+00,0.2138E+00,0.2234E+00,0.2343E+00,
     *0.2468E+00,0.2610E+00,0.2770E+00,0.2951E+00,0.3154E+00,
     *0.3384E+00,0.3508E+00,0.3640E+00,0.3927E+00,0.4248E+00,
     *0.4608E+00,0.5008E+00,0.5455E+00,0.5954E+00,0.6507E+00,
     *0.7122E+00,0.7806E+00,0.8564E+00,0.9403E+00,0.1033E+01,
     *0.1135E+01,0.1247E+01,0.1370E+01,0.1505E+01,0.1651E+01,
     *0.1811E+01,0.1984E+01,0.2171E+01,0.2371E+01,0.2585E+01,
     *0.2813E+01,0.3054E+01,0.3307E+01,0.3571E+01,0.3844E+01,
     *0.4125E+01,0.4410E+01,0.4699E+01,0.4989E+01,0.5283E+01,
     *0.5584E+01,0.5909E+01,0.6301E+01,0.6881E+01,0.8013E+01,
     *0.1103E+02,0.2244E+02,0.4453E+02 /
        DATA ((PHR(i,j),j=1,83),i=10,10)/
     *0.2466E+00,0.2449E+00,0.2437E+00,0.2430E+00,0.2414E+00,
     *0.2392E+00,0.2371E+00,0.2347E+00,0.2312E+00,0.2266E+00,
     *0.2215E+00,0.2165E+00,0.2115E+00,0.2070E+00,0.2032E+00,
     *0.1998E+00,0.1968E+00,0.1944E+00,0.1925E+00,0.1910E+00,
     *0.1901E+00,0.1897E+00,0.1899E+00,0.1906E+00,0.1920E+00,
     *0.1940E+00,0.1968E+00,0.2004E+00,0.2047E+00,0.2100E+00,
     *0.2162E+00,0.2236E+00,0.2323E+00,0.2422E+00,0.2535E+00,
     *0.2665E+00,0.2812E+00,0.2979E+00,0.3167E+00,0.3378E+00,
     *0.3615E+00,0.3745E+00,0.3881E+00,0.4178E+00,0.4510E+00,
     *0.4879E+00,0.5291E+00,0.5747E+00,0.6254E+00,0.6816E+00,
     *0.7438E+00,0.8125E+00,0.8882E+00,0.9715E+00,0.1063E+01,
     *0.1164E+01,0.1273E+01,0.1393E+01,0.1523E+01,0.1665E+01,
     *0.1817E+01,0.1981E+01,0.2157E+01,0.2345E+01,0.2545E+01,
     *0.2756E+01,0.2977E+01,0.3208E+01,0.3447E+01,0.3694E+01,
     *0.3946E+01,0.4201E+01,0.4461E+01,0.4723E+01,0.4990E+01,
     *0.5273E+01,0.5590E+01,0.5997E+01,0.6635E+01,0.7913E+01,
     *0.1130E+02,0.2350E+02,0.4472E+02 /
        DATA ((PHR(i,j),j=1,83),i=11,11)/
     *0.2671E+00,0.2653E+00,0.2641E+00,0.2633E+00,0.2617E+00,
     *0.2600E+00,0.2582E+00,0.2559E+00,0.2523E+00,0.2478E+00,
     *0.2426E+00,0.2368E+00,0.2314E+00,0.2267E+00,0.2225E+00,
     *0.2187E+00,0.2155E+00,0.2127E+00,0.2105E+00,0.2088E+00,
     *0.2076E+00,0.2070E+00,0.2069E+00,0.2074E+00,0.2085E+00,
     *0.2104E+00,0.2130E+00,0.2164E+00,0.2207E+00,0.2259E+00,
     *0.2323E+00,0.2397E+00,0.2484E+00,0.2584E+00,0.2699E+00,
     *0.2832E+00,0.2982E+00,0.3152E+00,0.3343E+00,0.3559E+00,
     *0.3803E+00,0.3934E+00,0.4074E+00,0.4375E+00,0.4713E+00,
     *0.5089E+00,0.5506E+00,0.5968E+00,0.6480E+00,0.7044E+00,
     *0.7665E+00,0.8351E+00,0.9104E+00,0.9930E+00,0.1083E+01,
     *0.1182E+01,0.1289E+01,0.1405E+01,0.1531E+01,0.1667E+01,
     *0.1813E+01,0.1970E+01,0.2137E+01,0.2314E+01,0.2502E+01,
     *0.2699E+01,0.2905E+01,0.3119E+01,0.3340E+01,0.3568E+01,
     *0.3800E+01,0.4036E+01,0.4274E+01,0.4517E+01,0.4771E+01,
     *0.5044E+01,0.5363E+01,0.5792E+01,0.6492E+01,0.7926E+01,
     *0.1167E+02,0.2455E+02,0.4508E+02 /
        DATA ((PHR(i,j),j=1,83),i=12,12)/
     *0.2816E+00,0.2796E+00,0.2780E+00,0.2772E+00,0.2756E+00,
     *0.2739E+00,0.2725E+00,0.2707E+00,0.2672E+00,0.2621E+00,
     *0.2563E+00,0.2507E+00,0.2453E+00,0.2402E+00,0.2356E+00,
     *0.2316E+00,0.2281E+00,0.2252E+00,0.2228E+00,0.2209E+00,
     *0.2195E+00,0.2186E+00,0.2184E+00,0.2187E+00,0.2197E+00,
     *0.2214E+00,0.2238E+00,0.2271E+00,0.2313E+00,0.2365E+00,
     *0.2427E+00,0.2501E+00,0.2588E+00,0.2689E+00,0.2806E+00,
     *0.2939E+00,0.3090E+00,0.3262E+00,0.3456E+00,0.3673E+00,
     *0.3916E+00,0.4049E+00,0.4189E+00,0.4495E+00,0.4835E+00,
     *0.5212E+00,0.5630E+00,0.6093E+00,0.6605E+00,0.7170E+00,
     *0.7792E+00,0.8474E+00,0.9221E+00,0.1004E+01,0.1093E+01,
     *0.1190E+01,0.1296E+01,0.1410E+01,0.1533E+01,0.1665E+01,
     *0.1807E+01,0.1959E+01,0.2121E+01,0.2292E+01,0.2472E+01,
     *0.2661E+01,0.2858E+01,0.3063E+01,0.3274E+01,0.3490E+01,
     *0.3710E+01,0.3935E+01,0.4163E+01,0.4397E+01,0.4642E+01,
     *0.4911E+01,0.5236E+01,0.5684E+01,0.6430E+01,0.7968E+01,
     *0.1193E+02,0.2524E+02,0.4537E+02 /
        DATA ((PHR(i,j),j=1,83),i=13,13)/
     *0.3231E+00,0.3207E+00,0.3184E+00,0.3176E+00,0.3163E+00,
     *0.3151E+00,0.3141E+00,0.3123E+00,0.3087E+00,0.3036E+00,
     *0.2975E+00,0.2906E+00,0.2841E+00,0.2783E+00,0.2730E+00,
     *0.2683E+00,0.2642E+00,0.2605E+00,0.2573E+00,0.2548E+00,
     *0.2528E+00,0.2514E+00,0.2506E+00,0.2503E+00,0.2508E+00,
     *0.2520E+00,0.2540E+00,0.2568E+00,0.2606E+00,0.2654E+00,
     *0.2714E+00,0.2786E+00,0.2870E+00,0.2969E+00,0.3084E+00,
     *0.3217E+00,0.3369E+00,0.3540E+00,0.3734E+00,0.3955E+00,
     *0.4202E+00,0.4335E+00,0.4476E+00,0.4782E+00,0.5122E+00,
     *0.5501E+00,0.5919E+00,0.6379E+00,0.6887E+00,0.7443E+00,
     *0.8051E+00,0.8718E+00,0.9446E+00,0.1024E+01,0.1109E+01,
     *0.1202E+01,0.1302E+01,0.1410E+01,0.1525E+01,0.1648E+01,
     *0.1780E+01,0.1919E+01,0.2066E+01,0.2221E+01,0.2383E+01,
     *0.2552E+01,0.2728E+01,0.2909E+01,0.3095E+01,0.3286E+01,
     *0.3482E+01,0.3682E+01,0.3888E+01,0.4104E+01,0.4341E+01,
     *0.4615E+01,0.4964E+01,0.5479E+01,0.6374E+01,0.8228E+01,
     *0.1288E+02,0.2742E+02,0.4654E+02 /
        DATA ((PHR(i,j),j=1,83),i=14,14)/
     *0.3870E+00,0.3837E+00,0.3798E+00,0.3785E+00,0.3776E+00,
     *0.3769E+00,0.3768E+00,0.3758E+00,0.3723E+00,0.3663E+00,
     *0.3589E+00,0.3507E+00,0.3427E+00,0.3354E+00,0.3290E+00,
     *0.3230E+00,0.3177E+00,0.3129E+00,0.3088E+00,0.3052E+00,
     *0.3023E+00,0.2998E+00,0.2980E+00,0.2968E+00,0.2963E+00,
     *0.2965E+00,0.2976E+00,0.2996E+00,0.3025E+00,0.3065E+00,
     *0.3115E+00,0.3178E+00,0.3256E+00,0.3348E+00,0.3455E+00,
     *0.3581E+00,0.3727E+00,0.3892E+00,0.4080E+00,0.4294E+00,
     *0.4534E+00,0.4664E+00,0.4801E+00,0.5098E+00,0.5428E+00,
     *0.5794E+00,0.6197E+00,0.6640E+00,0.7126E+00,0.7656E+00,
     *0.8233E+00,0.8862E+00,0.9545E+00,0.1028E+01,0.1108E+01,
     *0.1193E+01,0.1284E+01,0.1382E+01,0.1486E+01,0.1597E+01,
     *0.1714E+01,0.1837E+01,0.1966E+01,0.2101E+01,0.2242E+01,
     *0.2389E+01,0.2541E+01,0.2697E+01,0.2858E+01,0.3026E+01,
     *0.3198E+01,0.3378E+01,0.3570E+01,0.3781E+01,0.4027E+01,
     *0.4334E+01,0.4757E+01,0.5416E+01,0.6585E+01,0.8967E+01,
     *0.1466E+02,0.3092E+02,0.4862E+02 /
        DATA ((PHR(i,j),j=1,83),i=15,15)/
     *0.5767E+00,0.5696E+00,0.5558E+00,0.5478E+00,0.5453E+00,
     *0.5476E+00,0.5524E+00,0.5549E+00,0.5511E+00,0.5412E+00,
     *0.5276E+00,0.5126E+00,0.4978E+00,0.4835E+00,0.4703E+00,
     *0.4585E+00,0.4479E+00,0.4384E+00,0.4298E+00,0.4219E+00,
     *0.4148E+00,0.4084E+00,0.4027E+00,0.3977E+00,0.3934E+00,
     *0.3898E+00,0.3869E+00,0.3847E+00,0.3836E+00,0.3836E+00,
     *0.3847E+00,0.3868E+00,0.3901E+00,0.3948E+00,0.4010E+00,
     *0.4088E+00,0.4182E+00,0.4293E+00,0.4424E+00,0.4574E+00,
     *0.4746E+00,0.4841E+00,0.4941E+00,0.5163E+00,0.5410E+00,
     *0.5683E+00,0.5983E+00,0.6314E+00,0.6677E+00,0.7074E+00,
     *0.7504E+00,0.7968E+00,0.8470E+00,0.9011E+00,0.9592E+00,
     *0.1022E+01,0.1088E+01,0.1159E+01,0.1235E+01,0.1315E+01,
     *0.1401E+01,0.1493E+01,0.1591E+01,0.1695E+01,0.1805E+01,
     *0.1924E+01,0.2052E+01,0.2193E+01,0.2347E+01,0.2517E+01,
     *0.2711E+01,0.2939E+01,0.3213E+01,0.3558E+01,0.4011E+01,
     *0.4642E+01,0.5578E+01,0.7057E+01,0.9572E+01,0.1420E+02,
     *0.2351E+02,0.4319E+02,0.5584E+02 /
        DATA ((PHR(i,j),j=1,83),i=16,16)/
     *0.6058E+00,0.5965E+00,0.5759E+00,0.5625E+00,0.5581E+00,
     *0.5613E+00,0.5691E+00,0.5752E+00,0.5735E+00,0.5630E+00,
     *0.5468E+00,0.5280E+00,0.5088E+00,0.4906E+00,0.4739E+00,
     *0.4587E+00,0.4450E+00,0.4328E+00,0.4217E+00,0.4118E+00,
     *0.4028E+00,0.3947E+00,0.3874E+00,0.3809E+00,0.3751E+00,
     *0.3701E+00,0.3659E+00,0.3626E+00,0.3600E+00,0.3581E+00,
     *0.3571E+00,0.3573E+00,0.3588E+00,0.3613E+00,0.3650E+00,
     *0.3699E+00,0.3764E+00,0.3844E+00,0.3941E+00,0.4056E+00,
     *0.4188E+00,0.4262E+00,0.4340E+00,0.4511E+00,0.4703E+00,
     *0.4919E+00,0.5161E+00,0.5429E+00,0.5723E+00,0.6046E+00,
     *0.6402E+00,0.6793E+00,0.7218E+00,0.7679E+00,0.8182E+00,
     *0.8729E+00,0.9325E+00,0.9972E+00,0.1068E+01,0.1145E+01,
     *0.1229E+01,0.1321E+01,0.1421E+01,0.1532E+01,0.1655E+01,
     *0.1793E+01,0.1946E+01,0.2120E+01,0.2319E+01,0.2551E+01,
     *0.2826E+01,0.3157E+01,0.3570E+01,0.4099E+01,0.4801E+01,
     *0.5770E+01,0.7168E+01,0.9290E+01,0.1269E+02,0.1849E+02,
     *0.2901E+02,0.4746E+02,0.5654E+02 /
        DATA ((PHR(i,j),j=1,83),i=17,17)/
     *0.5984E+00,0.5884E+00,0.5652E+00,0.5490E+00,0.5435E+00,
     *0.5469E+00,0.5558E+00,0.5633E+00,0.5622E+00,0.5514E+00,
     *0.5345E+00,0.5153E+00,0.4955E+00,0.4763E+00,0.4585E+00,
     *0.4423E+00,0.4279E+00,0.4153E+00,0.4039E+00,0.3936E+00,
     *0.3843E+00,0.3760E+00,0.3685E+00,0.3618E+00,0.3559E+00,
     *0.3507E+00,0.3464E+00,0.3428E+00,0.3400E+00,0.3380E+00,
     *0.3369E+00,0.3368E+00,0.3380E+00,0.3401E+00,0.3434E+00,
     *0.3479E+00,0.3538E+00,0.3613E+00,0.3703E+00,0.3805E+00,
     *0.3924E+00,0.3992E+00,0.4066E+00,0.4229E+00,0.4410E+00,
     *0.4610E+00,0.4836E+00,0.5087E+00,0.5365E+00,0.5675E+00,
     *0.6019E+00,0.6393E+00,0.6796E+00,0.7239E+00,0.7732E+00,
     *0.8273E+00,0.8861E+00,0.9507E+00,0.1022E+01,0.1099E+01,
     *0.1185E+01,0.1280E+01,0.1385E+01,0.1503E+01,0.1634E+01,
     *0.1781E+01,0.1948E+01,0.2141E+01,0.2363E+01,0.2622E+01,
     *0.2930E+01,0.3306E+01,0.3776E+01,0.4376E+01,0.5166E+01,
     *0.6249E+01,0.7796E+01,0.1011E+02,0.1375E+02,0.1979E+02,
     *0.3037E+02,0.4765E+02,0.5552E+02 /
        DATA ((PHR(i,j),j=1,83),i=18,18)/
     *0.5521E+00,0.5412E+00,0.5133E+00,0.4918E+00,0.4834E+00,
     *0.4875E+00,0.4981E+00,0.5066E+00,0.5068E+00,0.4979E+00,
     *0.4819E+00,0.4619E+00,0.4408E+00,0.4205E+00,0.4017E+00,
     *0.3850E+00,0.3700E+00,0.3565E+00,0.3446E+00,0.3340E+00,
     *0.3247E+00,0.3165E+00,0.3092E+00,0.3028E+00,0.2972E+00,
     *0.2924E+00,0.2882E+00,0.2848E+00,0.2823E+00,0.2808E+00,
     *0.2802E+00,0.2802E+00,0.2810E+00,0.2829E+00,0.2859E+00,
     *0.2900E+00,0.2952E+00,0.3016E+00,0.3094E+00,0.3188E+00,
     *0.3297E+00,0.3357E+00,0.3422E+00,0.3563E+00,0.3726E+00,
     *0.3911E+00,0.4116E+00,0.4347E+00,0.4604E+00,0.4889E+00,
     *0.5204E+00,0.5558E+00,0.5954E+00,0.6394E+00,0.6878E+00,
     *0.7415E+00,0.8014E+00,0.8682E+00,0.9427E+00,0.1026E+01,
     *0.1120E+01,0.1226E+01,0.1346E+01,0.1481E+01,0.1635E+01,
     *0.1812E+01,0.2017E+01,0.2254E+01,0.2532E+01,0.2862E+01,
     *0.3259E+01,0.3740E+01,0.4336E+01,0.5092E+01,0.6077E+01,
     *0.7396E+01,0.9222E+01,0.1185E+02,0.1580E+02,0.2200E+02,
     *0.3206E+02,0.4585E+02,0.5119E+02 /
        DATA ((PHR(i,j),j=1,83),i=19,19)/
     *0.4886E+00,0.4784E+00,0.4506E+00,0.4279E+00,0.4175E+00,
     *0.4200E+00,0.4304E+00,0.4406E+00,0.4431E+00,0.4362E+00,
     *0.4217E+00,0.4032E+00,0.3832E+00,0.3637E+00,0.3456E+00,
     *0.3292E+00,0.3145E+00,0.3014E+00,0.2899E+00,0.2798E+00,
     *0.2710E+00,0.2633E+00,0.2566E+00,0.2508E+00,0.2458E+00,
     *0.2417E+00,0.2384E+00,0.2359E+00,0.2341E+00,0.2328E+00,
     *0.2323E+00,0.2328E+00,0.2342E+00,0.2365E+00,0.2397E+00,
     *0.2439E+00,0.2491E+00,0.2555E+00,0.2632E+00,0.2724E+00,
     *0.2830E+00,0.2889E+00,0.2950E+00,0.3086E+00,0.3241E+00,
     *0.3419E+00,0.3620E+00,0.3846E+00,0.4097E+00,0.4378E+00,
     *0.4692E+00,0.5047E+00,0.5445E+00,0.5889E+00,0.6385E+00,
     *0.6944E+00,0.7574E+00,0.8286E+00,0.9090E+00,0.1000E+01,
     *0.1104E+01,0.1221E+01,0.1354E+01,0.1507E+01,0.1685E+01,
     *0.1890E+01,0.2127E+01,0.2403E+01,0.2728E+01,0.3114E+01,
     *0.3576E+01,0.4137E+01,0.4828E+01,0.5695E+01,0.6806E+01,
     *0.8262E+01,0.1022E+02,0.1294E+02,0.1687E+02,0.2268E+02,
     *0.3153E+02,0.4198E+02,0.4560E+02 /
        DATA ((PHR(i,j),j=1,83),i=20,20)/
     *0.3196E+00,0.3131E+00,0.2913E+00,0.2692E+00,0.2566E+00,
     *0.2541E+00,0.2587E+00,0.2657E+00,0.2696E+00,0.2682E+00,
     *0.2616E+00,0.2514E+00,0.2391E+00,0.2264E+00,0.2142E+00,
     *0.2028E+00,0.1924E+00,0.1830E+00,0.1748E+00,0.1677E+00,
     *0.1617E+00,0.1567E+00,0.1525E+00,0.1493E+00,0.1468E+00,
     *0.1451E+00,0.1440E+00,0.1437E+00,0.1440E+00,0.1450E+00,
     *0.1467E+00,0.1491E+00,0.1523E+00,0.1563E+00,0.1612E+00,
     *0.1670E+00,0.1736E+00,0.1813E+00,0.1901E+00,0.2004E+00,
     *0.2122E+00,0.2185E+00,0.2253E+00,0.2400E+00,0.2568E+00,
     *0.2760E+00,0.2977E+00,0.3221E+00,0.3497E+00,0.3807E+00,
     *0.4157E+00,0.4556E+00,0.5011E+00,0.5527E+00,0.6111E+00,
     *0.6777E+00,0.7537E+00,0.8407E+00,0.9406E+00,0.1055E+01,
     *0.1187E+01,0.1338E+01,0.1513E+01,0.1715E+01,0.1949E+01,
     *0.2220E+01,0.2536E+01,0.2902E+01,0.3330E+01,0.3834E+01,
     *0.4426E+01,0.5122E+01,0.5950E+01,0.6939E+01,0.8129E+01,
     *0.9575E+01,0.1134E+02,0.1353E+02,0.1628E+02,0.1969E+02,
     *0.2341E+02,0.2626E+02,0.2704E+02 /
c************** MIE (phase fun qh) ***************
        DATA ((QHR(i,j),j=1,83),i= 1, 1)/
     *-0.8147E-22, 0.5946E-03, 0.3607E-02, 0.7821E-02, 0.1280E-01,
     * 0.1851E-01, 0.2445E-01, 0.2975E-01, 0.3412E-01, 0.3760E-01,
     * 0.3991E-01, 0.4081E-01, 0.4049E-01, 0.3916E-01, 0.3692E-01,
     * 0.3406E-01, 0.3081E-01, 0.2727E-01, 0.2361E-01, 0.1993E-01,
     * 0.1636E-01, 0.1291E-01, 0.9661E-02, 0.6585E-02, 0.3730E-02,
     * 0.1045E-02,-0.1424E-02,-0.3753E-02,-0.5895E-02,-0.7905E-02,
     *-0.9782E-02,-0.1153E-01,-0.1324E-01,-0.1486E-01,-0.1649E-01,
     *-0.1812E-01,-0.1973E-01,-0.2142E-01,-0.2317E-01,-0.2491E-01,
     *-0.2672E-01,-0.2768E-01,-0.2862E-01,-0.3060E-01,-0.3261E-01,
     *-0.3468E-01,-0.3687E-01,-0.3921E-01,-0.4172E-01,-0.4438E-01,
     *-0.4723E-01,-0.5028E-01,-0.5349E-01,-0.5685E-01,-0.6038E-01,
     *-0.6401E-01,-0.6770E-01,-0.7138E-01,-0.7509E-01,-0.7871E-01,
     *-0.8211E-01,-0.8523E-01,-0.8791E-01,-0.9009E-01,-0.9154E-01,
     *-0.9222E-01,-0.9185E-01,-0.9049E-01,-0.8802E-01,-0.8418E-01,
     *-0.7929E-01,-0.7309E-01,-0.6580E-01,-0.5780E-01,-0.4918E-01,
     *-0.4018E-01,-0.3185E-01,-0.2399E-01,-0.1621E-01,-0.1136E-01,
     *-0.7363E-02, 0.2718E-02, 0.1537E-19 /
        DATA ((QHR(i,j),j=1,83),i= 2, 2)/
     *-0.3118E-21, 0.4345E-03, 0.2544E-02, 0.5349E-02, 0.8687E-02,
     * 0.1250E-01, 0.1638E-01, 0.2011E-01, 0.2351E-01, 0.2636E-01,
     * 0.2824E-01, 0.2929E-01, 0.2957E-01, 0.2883E-01, 0.2726E-01,
     * 0.2517E-01, 0.2259E-01, 0.1966E-01, 0.1649E-01, 0.1317E-01,
     * 0.9745E-02, 0.6321E-02, 0.2919E-02,-0.4226E-03,-0.3710E-02,
     *-0.6925E-02,-0.1008E-01,-0.1315E-01,-0.1618E-01,-0.1911E-01,
     *-0.2205E-01,-0.2493E-01,-0.2782E-01,-0.3071E-01,-0.3358E-01,
     *-0.3650E-01,-0.3945E-01,-0.4242E-01,-0.4549E-01,-0.4867E-01,
     *-0.5193E-01,-0.5365E-01,-0.5536E-01,-0.5900E-01,-0.6284E-01,
     *-0.6686E-01,-0.7111E-01,-0.7559E-01,-0.8030E-01,-0.8522E-01,
     *-0.9036E-01,-0.9562E-01,-0.1010E+00,-0.1065E+00,-0.1121E+00,
     *-0.1176E+00,-0.1231E+00,-0.1285E+00,-0.1336E+00,-0.1382E+00,
     *-0.1423E+00,-0.1458E+00,-0.1484E+00,-0.1500E+00,-0.1505E+00,
     *-0.1496E+00,-0.1473E+00,-0.1433E+00,-0.1377E+00,-0.1303E+00,
     *-0.1215E+00,-0.1110E+00,-0.9908E-01,-0.8654E-01,-0.7293E-01,
     *-0.5959E-01,-0.4695E-01,-0.3430E-01,-0.2357E-01,-0.1358E-01,
     *-0.2723E-02, 0.3655E-02, 0.3156E-19 /
        DATA ((QHR(i,j),j=1,83),i= 3, 3)/
     * 0.1009E-22, 0.3044E-03, 0.2098E-02, 0.4729E-02, 0.8006E-02,
     * 0.1143E-01, 0.1476E-01, 0.1823E-01, 0.2153E-01, 0.2410E-01,
     * 0.2588E-01, 0.2696E-01, 0.2721E-01, 0.2650E-01, 0.2509E-01,
     * 0.2308E-01, 0.2055E-01, 0.1768E-01, 0.1456E-01, 0.1126E-01,
     * 0.7818E-02, 0.4340E-02, 0.8244E-03,-0.2641E-02,-0.6093E-02,
     *-0.9479E-02,-0.1283E-01,-0.1609E-01,-0.1933E-01,-0.2250E-01,
     *-0.2566E-01,-0.2880E-01,-0.3192E-01,-0.3508E-01,-0.3822E-01,
     *-0.4142E-01,-0.4473E-01,-0.4806E-01,-0.5149E-01,-0.5509E-01,
     *-0.5882E-01,-0.6073E-01,-0.6269E-01,-0.6675E-01,-0.7103E-01,
     *-0.7555E-01,-0.8027E-01,-0.8518E-01,-0.9029E-01,-0.9565E-01,
     *-0.1012E+00,-0.1069E+00,-0.1127E+00,-0.1186E+00,-0.1245E+00,
     *-0.1304E+00,-0.1362E+00,-0.1418E+00,-0.1471E+00,-0.1518E+00,
     *-0.1559E+00,-0.1593E+00,-0.1617E+00,-0.1630E+00,-0.1630E+00,
     *-0.1616E+00,-0.1587E+00,-0.1540E+00,-0.1475E+00,-0.1393E+00,
     *-0.1294E+00,-0.1179E+00,-0.1053E+00,-0.9168E-01,-0.7731E-01,
     *-0.6325E-01,-0.4939E-01,-0.3620E-01,-0.2499E-01,-0.1245E-01,
     * 0.1652E-03, 0.6597E-02, 0.3584E-19 /
        DATA ((QHR(i,j),j=1,83),i= 4, 4)/
     * 0.5571E-22, 0.3220E-03, 0.1983E-02, 0.4020E-02, 0.6318E-02,
     * 0.8880E-02, 0.1148E-01, 0.1409E-01, 0.1661E-01, 0.1878E-01,
     * 0.2020E-01, 0.2102E-01, 0.2125E-01, 0.2055E-01, 0.1909E-01,
     * 0.1715E-01, 0.1470E-01, 0.1186E-01, 0.8715E-02, 0.5332E-02,
     * 0.1756E-02,-0.1907E-02,-0.5641E-02,-0.9394E-02,-0.1318E-01,
     *-0.1697E-01,-0.2077E-01,-0.2453E-01,-0.2830E-01,-0.3202E-01,
     *-0.3577E-01,-0.3952E-01,-0.4332E-01,-0.4720E-01,-0.5113E-01,
     *-0.5521E-01,-0.5943E-01,-0.6375E-01,-0.6827E-01,-0.7298E-01,
     *-0.7782E-01,-0.8034E-01,-0.8286E-01,-0.8811E-01,-0.9354E-01,
     *-0.9913E-01,-0.1049E+00,-0.1109E+00,-0.1170E+00,-0.1234E+00,
     *-0.1299E+00,-0.1366E+00,-0.1432E+00,-0.1500E+00,-0.1566E+00,
     *-0.1632E+00,-0.1694E+00,-0.1753E+00,-0.1807E+00,-0.1853E+00,
     *-0.1891E+00,-0.1919E+00,-0.1936E+00,-0.1938E+00,-0.1926E+00,
     *-0.1896E+00,-0.1849E+00,-0.1783E+00,-0.1697E+00,-0.1593E+00,
     *-0.1473E+00,-0.1334E+00,-0.1183E+00,-0.1027E+00,-0.8599E-01,
     *-0.6991E-01,-0.5469E-01,-0.3963E-01,-0.2695E-01,-0.1460E-01,
     *-0.1422E-02, 0.4893E-02, 0.2603E-19 /
        DATA ((QHR(i,j),j=1,83),i= 5, 5)/
     * 0.2773E-21, 0.7046E-04, 0.1388E-02, 0.3189E-02, 0.5208E-02,
     * 0.7015E-02, 0.8798E-02, 0.1093E-01, 0.1294E-01, 0.1446E-01,
     * 0.1564E-01, 0.1628E-01, 0.1602E-01, 0.1516E-01, 0.1378E-01,
     * 0.1173E-01, 0.9185E-02, 0.6271E-02, 0.3047E-02,-0.4254E-03,
     *-0.4089E-02,-0.7920E-02,-0.1189E-01,-0.1592E-01,-0.2003E-01,
     *-0.2415E-01,-0.2832E-01,-0.3251E-01,-0.3674E-01,-0.4105E-01,
     *-0.4540E-01,-0.4985E-01,-0.5435E-01,-0.5896E-01,-0.6369E-01,
     *-0.6853E-01,-0.7357E-01,-0.7879E-01,-0.8415E-01,-0.8976E-01,
     *-0.9560E-01,-0.9853E-01,-0.1016E+00,-0.1077E+00,-0.1141E+00,
     *-0.1207E+00,-0.1274E+00,-0.1343E+00,-0.1413E+00,-0.1485E+00,
     *-0.1557E+00,-0.1629E+00,-0.1702E+00,-0.1774E+00,-0.1844E+00,
     *-0.1910E+00,-0.1973E+00,-0.2031E+00,-0.2082E+00,-0.2125E+00,
     *-0.2157E+00,-0.2177E+00,-0.2184E+00,-0.2176E+00,-0.2150E+00,
     *-0.2107E+00,-0.2044E+00,-0.1961E+00,-0.1858E+00,-0.1737E+00,
     *-0.1595E+00,-0.1442E+00,-0.1277E+00,-0.1100E+00,-0.9253E-01,
     *-0.7509E-01,-0.5763E-01,-0.4234E-01,-0.2868E-01,-0.1415E-01,
     *-0.1035E-02, 0.5729E-02, 0.1868E-20 /
        DATA ((QHR(i,j),j=1,83),i= 6, 6)/
     * 0.2431E-21, 0.2465E-03, 0.1908E-02, 0.3314E-02, 0.4430E-02,
     * 0.5859E-02, 0.7582E-02, 0.9083E-02, 0.1045E-01, 0.1186E-01,
     * 0.1278E-01, 0.1308E-01, 0.1288E-01, 0.1194E-01, 0.1026E-01,
     * 0.8159E-02, 0.5607E-02, 0.2638E-02,-0.6830E-03,-0.4284E-02,
     *-0.8098E-02,-0.1207E-01,-0.1616E-01,-0.2037E-01,-0.2466E-01,
     *-0.2907E-01,-0.3354E-01,-0.3811E-01,-0.4275E-01,-0.4745E-01,
     *-0.5227E-01,-0.5715E-01,-0.6219E-01,-0.6734E-01,-0.7263E-01,
     *-0.7811E-01,-0.8370E-01,-0.8947E-01,-0.9546E-01,-0.1016E+00,
     *-0.1079E+00,-0.1112E+00,-0.1144E+00,-0.1212E+00,-0.1282E+00,
     *-0.1353E+00,-0.1425E+00,-0.1500E+00,-0.1576E+00,-0.1653E+00,
     *-0.1730E+00,-0.1807E+00,-0.1882E+00,-0.1955E+00,-0.2027E+00,
     *-0.2094E+00,-0.2156E+00,-0.2211E+00,-0.2259E+00,-0.2296E+00,
     *-0.2323E+00,-0.2337E+00,-0.2336E+00,-0.2319E+00,-0.2283E+00,
     *-0.2229E+00,-0.2155E+00,-0.2061E+00,-0.1948E+00,-0.1813E+00,
     *-0.1665E+00,-0.1500E+00,-0.1321E+00,-0.1140E+00,-0.9509E-01,
     *-0.7652E-01,-0.5964E-01,-0.4320E-01,-0.2818E-01,-0.1719E-01,
     *-0.6913E-02, 0.3746E-02, 0.1868E-19 /
        DATA ((QHR(i,j),j=1,83),i= 7, 7)/
     * 0.3840E-22, 0.2406E-03, 0.1633E-02, 0.2793E-02, 0.3662E-02,
     * 0.4611E-02, 0.5610E-02, 0.6591E-02, 0.7589E-02, 0.8546E-02,
     * 0.8953E-02, 0.8937E-02, 0.8554E-02, 0.7367E-02, 0.5483E-02,
     * 0.3214E-02, 0.4783E-03,-0.2668E-02,-0.6167E-02,-0.9972E-02,
     *-0.1405E-01,-0.1831E-01,-0.2274E-01,-0.2733E-01,-0.3207E-01,
     *-0.3696E-01,-0.4198E-01,-0.4713E-01,-0.5241E-01,-0.5777E-01,
     *-0.6330E-01,-0.6893E-01,-0.7474E-01,-0.8069E-01,-0.8678E-01,
     *-0.9307E-01,-0.9951E-01,-0.1061E+00,-0.1129E+00,-0.1199E+00,
     *-0.1270E+00,-0.1307E+00,-0.1344E+00,-0.1419E+00,-0.1497E+00,
     *-0.1575E+00,-0.1656E+00,-0.1737E+00,-0.1820E+00,-0.1902E+00,
     *-0.1985E+00,-0.2066E+00,-0.2144E+00,-0.2220E+00,-0.2292E+00,
     *-0.2358E+00,-0.2417E+00,-0.2469E+00,-0.2510E+00,-0.2540E+00,
     *-0.2557E+00,-0.2560E+00,-0.2546E+00,-0.2514E+00,-0.2464E+00,
     *-0.2394E+00,-0.2304E+00,-0.2193E+00,-0.2063E+00,-0.1913E+00,
     *-0.1750E+00,-0.1569E+00,-0.1378E+00,-0.1185E+00,-0.9848E-01,
     *-0.7936E-01,-0.6174E-01,-0.4421E-01,-0.2929E-01,-0.1589E-01,
     *-0.1659E-02, 0.5216E-02, 0.3065E-19 /
        DATA ((QHR(i,j),j=1,83),i= 8, 8)/
     *-0.7752E-22, 0.1308E-03, 0.1361E-02, 0.2501E-02, 0.2873E-02,
     * 0.3129E-02, 0.3561E-02, 0.4080E-02, 0.4391E-02, 0.4637E-02,
     * 0.4841E-02, 0.4425E-02, 0.3274E-02, 0.1732E-02,-0.3230E-03,
     *-0.2992E-02,-0.6093E-02,-0.9624E-02,-0.1351E-01,-0.1771E-01,
     *-0.2218E-01,-0.2695E-01,-0.3194E-01,-0.3720E-01,-0.4261E-01,
     *-0.4822E-01,-0.5397E-01,-0.5992E-01,-0.6600E-01,-0.7230E-01,
     *-0.7871E-01,-0.8529E-01,-0.9204E-01,-0.9895E-01,-0.1061E+00,
     *-0.1133E+00,-0.1207E+00,-0.1284E+00,-0.1362E+00,-0.1442E+00,
     *-0.1523E+00,-0.1565E+00,-0.1607E+00,-0.1692E+00,-0.1778E+00,
     *-0.1866E+00,-0.1955E+00,-0.2043E+00,-0.2132E+00,-0.2220E+00,
     *-0.2305E+00,-0.2389E+00,-0.2470E+00,-0.2545E+00,-0.2615E+00,
     *-0.2678E+00,-0.2732E+00,-0.2776E+00,-0.2808E+00,-0.2828E+00,
     *-0.2831E+00,-0.2819E+00,-0.2789E+00,-0.2740E+00,-0.2670E+00,
     *-0.2581E+00,-0.2469E+00,-0.2337E+00,-0.2188E+00,-0.2020E+00,
     *-0.1835E+00,-0.1641E+00,-0.1438E+00,-0.1228E+00,-0.1025E+00,
     *-0.8210E-01,-0.6267E-01,-0.4585E-01,-0.2919E-01,-0.1669E-01,
     *-0.7899E-02, 0.2972E-02, 0.2956E-19 /
        DATA ((QHR(i,j),j=1,83),i= 9, 9)/
     *-0.4595E-21,-0.5562E-04, 0.8731E-03, 0.1769E-02, 0.2273E-02,
     * 0.2001E-02, 0.1454E-02, 0.1377E-02, 0.1316E-02, 0.8342E-03,
     * 0.2139E-03,-0.7326E-03,-0.2437E-02,-0.4614E-02,-0.7176E-02,
     *-0.1038E-01,-0.1407E-01,-0.1815E-01,-0.2259E-01,-0.2738E-01,
     *-0.3250E-01,-0.3794E-01,-0.4368E-01,-0.4966E-01,-0.5588E-01,
     *-0.6229E-01,-0.6892E-01,-0.7572E-01,-0.8272E-01,-0.8994E-01,
     *-0.9734E-01,-0.1050E+00,-0.1127E+00,-0.1207E+00,-0.1289E+00,
     *-0.1372E+00,-0.1458E+00,-0.1545E+00,-0.1634E+00,-0.1725E+00,
     *-0.1818E+00,-0.1865E+00,-0.1912E+00,-0.2006E+00,-0.2101E+00,
     *-0.2196E+00,-0.2291E+00,-0.2385E+00,-0.2477E+00,-0.2567E+00,
     *-0.2654E+00,-0.2736E+00,-0.2814E+00,-0.2886E+00,-0.2950E+00,
     *-0.3005E+00,-0.3050E+00,-0.3083E+00,-0.3102E+00,-0.3107E+00,
     *-0.3095E+00,-0.3064E+00,-0.3015E+00,-0.2946E+00,-0.2856E+00,
     *-0.2746E+00,-0.2616E+00,-0.2464E+00,-0.2294E+00,-0.2109E+00,
     *-0.1905E+00,-0.1696E+00,-0.1483E+00,-0.1261E+00,-0.1049E+00,
     *-0.8429E-01,-0.6387E-01,-0.4619E-01,-0.3053E-01,-0.1253E-01,
     * 0.3800E-02, 0.9025E-02, 0.4461E-20 /
        DATA ((QHR(i,j),j=1,83),i=10,10)/
     * 0.5904E-22, 0.1192E-03, 0.1141E-02, 0.1779E-02, 0.1776E-02,
     * 0.1026E-02,-0.1717E-03,-0.1086E-02,-0.1850E-02,-0.2917E-02,
     *-0.4419E-02,-0.6148E-02,-0.8229E-02,-0.1107E-01,-0.1448E-01,
     *-0.1832E-01,-0.2267E-01,-0.2742E-01,-0.3257E-01,-0.3809E-01,
     *-0.4399E-01,-0.5018E-01,-0.5669E-01,-0.6344E-01,-0.7049E-01,
     *-0.7780E-01,-0.8537E-01,-0.9313E-01,-0.1012E+00,-0.1094E+00,
     *-0.1178E+00,-0.1265E+00,-0.1354E+00,-0.1445E+00,-0.1538E+00,
     *-0.1632E+00,-0.1729E+00,-0.1827E+00,-0.1927E+00,-0.2028E+00,
     *-0.2130E+00,-0.2181E+00,-0.2232E+00,-0.2335E+00,-0.2436E+00,
     *-0.2537E+00,-0.2637E+00,-0.2733E+00,-0.2827E+00,-0.2917E+00,
     *-0.3003E+00,-0.3082E+00,-0.3153E+00,-0.3218E+00,-0.3272E+00,
     *-0.3315E+00,-0.3347E+00,-0.3365E+00,-0.3367E+00,-0.3352E+00,
     *-0.3321E+00,-0.3271E+00,-0.3201E+00,-0.3110E+00,-0.3000E+00,
     *-0.2867E+00,-0.2718E+00,-0.2549E+00,-0.2361E+00,-0.2160E+00,
     *-0.1948E+00,-0.1725E+00,-0.1501E+00,-0.1277E+00,-0.1051E+00,
     *-0.8435E-01,-0.6467E-01,-0.4561E-01,-0.2987E-01,-0.1121E-01,
     * 0.8263E-02, 0.1151E-01,-0.7992E-22 /
        DATA ((QHR(i,j),j=1,83),i=11,11)/
     *-0.1272E-21,-0.5941E-04, 0.9194E-03, 0.1652E-02, 0.1544E-02,
     * 0.3092E-03,-0.1378E-02,-0.2623E-02,-0.3932E-02,-0.5724E-02,
     *-0.7617E-02,-0.9848E-02,-0.1289E-01,-0.1635E-01,-0.2016E-01,
     *-0.2464E-01,-0.2962E-01,-0.3499E-01,-0.4076E-01,-0.4689E-01,
     *-0.5339E-01,-0.6028E-01,-0.6753E-01,-0.7508E-01,-0.8294E-01,
     *-0.9104E-01,-0.9942E-01,-0.1080E+00,-0.1169E+00,-0.1261E+00,
     *-0.1354E+00,-0.1451E+00,-0.1549E+00,-0.1649E+00,-0.1750E+00,
     *-0.1853E+00,-0.1958E+00,-0.2065E+00,-0.2171E+00,-0.2280E+00,
     *-0.2388E+00,-0.2442E+00,-0.2496E+00,-0.2602E+00,-0.2708E+00,
     *-0.2813E+00,-0.2915E+00,-0.3013E+00,-0.3106E+00,-0.3194E+00,
     *-0.3276E+00,-0.3350E+00,-0.3416E+00,-0.3473E+00,-0.3518E+00,
     *-0.3550E+00,-0.3569E+00,-0.3573E+00,-0.3560E+00,-0.3531E+00,
     *-0.3483E+00,-0.3414E+00,-0.3327E+00,-0.3220E+00,-0.3092E+00,
     *-0.2945E+00,-0.2780E+00,-0.2595E+00,-0.2395E+00,-0.2185E+00,
     *-0.1958E+00,-0.1732E+00,-0.1505E+00,-0.1272E+00,-0.1053E+00,
     *-0.8424E-01,-0.6322E-01,-0.4538E-01,-0.2927E-01,-0.1030E-01,
     * 0.6477E-02, 0.1014E-01, 0.6269E-19 /
        DATA ((QHR(i,j),j=1,83),i=12,12)/
     * 0.5169E-21, 0.2354E-03, 0.1988E-02, 0.2646E-02, 0.1517E-02,
     *-0.3247E-04,-0.1483E-02,-0.3376E-02,-0.5510E-02,-0.7429E-02,
     *-0.9547E-02,-0.1226E-01,-0.1545E-01,-0.1921E-01,-0.2365E-01,
     *-0.2852E-01,-0.3383E-01,-0.3961E-01,-0.4585E-01,-0.5249E-01,
     *-0.5949E-01,-0.6683E-01,-0.7448E-01,-0.8249E-01,-0.9079E-01,
     *-0.9942E-01,-0.1083E+00,-0.1176E+00,-0.1270E+00,-0.1368E+00,
     *-0.1467E+00,-0.1568E+00,-0.1672E+00,-0.1778E+00,-0.1885E+00,
     *-0.1994E+00,-0.2104E+00,-0.2215E+00,-0.2327E+00,-0.2438E+00,
     *-0.2548E+00,-0.2604E+00,-0.2659E+00,-0.2769E+00,-0.2877E+00,
     *-0.2981E+00,-0.3083E+00,-0.3181E+00,-0.3274E+00,-0.3360E+00,
     *-0.3440E+00,-0.3512E+00,-0.3573E+00,-0.3624E+00,-0.3663E+00,
     *-0.3689E+00,-0.3700E+00,-0.3694E+00,-0.3672E+00,-0.3632E+00,
     *-0.3573E+00,-0.3496E+00,-0.3397E+00,-0.3278E+00,-0.3140E+00,
     *-0.2983E+00,-0.2804E+00,-0.2613E+00,-0.2409E+00,-0.2190E+00,
     *-0.1967E+00,-0.1735E+00,-0.1498E+00,-0.1269E+00,-0.1043E+00,
     *-0.8209E-01,-0.6269E-01,-0.4434E-01,-0.2571E-01,-0.1453E-01,
     *-0.6850E-02, 0.6172E-02,-0.1118E-19 /
        DATA ((QHR(i,j),j=1,83),i=13,13)/
     *-0.6041E-22,-0.6454E-05, 0.1224E-02, 0.2081E-02, 0.1735E-02,
     *-0.2100E-03,-0.2898E-02,-0.5197E-02,-0.7650E-02,-0.1075E-01,
     *-0.1402E-01,-0.1765E-01,-0.2212E-01,-0.2705E-01,-0.3236E-01,
     *-0.3837E-01,-0.4492E-01,-0.5189E-01,-0.5929E-01,-0.6710E-01,
     *-0.7532E-01,-0.8398E-01,-0.9306E-01,-0.1025E+00,-0.1122E+00,
     *-0.1223E+00,-0.1326E+00,-0.1432E+00,-0.1540E+00,-0.1651E+00,
     *-0.1765E+00,-0.1881E+00,-0.1998E+00,-0.2116E+00,-0.2236E+00,
     *-0.2356E+00,-0.2477E+00,-0.2598E+00,-0.2718E+00,-0.2839E+00,
     *-0.2958E+00,-0.3016E+00,-0.3073E+00,-0.3186E+00,-0.3295E+00,
     *-0.3401E+00,-0.3501E+00,-0.3594E+00,-0.3680E+00,-0.3758E+00,
     *-0.3826E+00,-0.3883E+00,-0.3931E+00,-0.3966E+00,-0.3985E+00,
     *-0.3989E+00,-0.3978E+00,-0.3951E+00,-0.3905E+00,-0.3841E+00,
     *-0.3757E+00,-0.3652E+00,-0.3529E+00,-0.3387E+00,-0.3226E+00,
     *-0.3048E+00,-0.2856E+00,-0.2646E+00,-0.2424E+00,-0.2195E+00,
     *-0.1954E+00,-0.1718E+00,-0.1486E+00,-0.1250E+00,-0.1030E+00,
     *-0.8201E-01,-0.6086E-01,-0.4285E-01,-0.2673E-01,-0.6035E-02,
     * 0.1241E-01, 0.1335E-01,-0.1961E-19 /
        DATA ((QHR(i,j),j=1,83),i=14,14)/
     * 0.8122E-21, 0.2142E-03, 0.1986E-02, 0.3241E-02, 0.2991E-02,
     * 0.6496E-03,-0.2916E-02,-0.6280E-02,-0.9845E-02,-0.1423E-01,
     *-0.1907E-01,-0.2422E-01,-0.3002E-01,-0.3654E-01,-0.4356E-01,
     *-0.5120E-01,-0.5944E-01,-0.6812E-01,-0.7724E-01,-0.8682E-01,
     *-0.9686E-01,-0.1073E+00,-0.1182E+00,-0.1293E+00,-0.1409E+00,
     *-0.1527E+00,-0.1649E+00,-0.1772E+00,-0.1898E+00,-0.2026E+00,
     *-0.2156E+00,-0.2288E+00,-0.2420E+00,-0.2553E+00,-0.2685E+00,
     *-0.2817E+00,-0.2949E+00,-0.3079E+00,-0.3206E+00,-0.3331E+00,
     *-0.3453E+00,-0.3512E+00,-0.3570E+00,-0.3680E+00,-0.3785E+00,
     *-0.3884E+00,-0.3974E+00,-0.4054E+00,-0.4125E+00,-0.4185E+00,
     *-0.4233E+00,-0.4267E+00,-0.4288E+00,-0.4294E+00,-0.4284E+00,
     *-0.4257E+00,-0.4213E+00,-0.4153E+00,-0.4072E+00,-0.3973E+00,
     *-0.3857E+00,-0.3721E+00,-0.3568E+00,-0.3399E+00,-0.3214E+00,
     *-0.3013E+00,-0.2805E+00,-0.2583E+00,-0.2349E+00,-0.2114E+00,
     *-0.1874E+00,-0.1638E+00,-0.1411E+00,-0.1184E+00,-0.9632E-01,
     *-0.7641E-01,-0.5653E-01,-0.3796E-01,-0.2227E-01, 0.9910E-03,
     * 0.2337E-01, 0.1932E-01,-0.4703E-19 /
        DATA ((QHR(i,j),j=1,83),i=15,15)/
     *-0.5817E-22, 0.1590E-02, 0.8542E-02, 0.1513E-01, 0.1713E-01,
     * 0.1588E-01, 0.1285E-01, 0.7918E-02, 0.1257E-02,-0.6339E-02,
     *-0.1460E-01,-0.2374E-01,-0.3360E-01,-0.4386E-01,-0.5467E-01,
     *-0.6603E-01,-0.7775E-01,-0.8984E-01,-0.1023E+00,-0.1150E+00,
     *-0.1281E+00,-0.1415E+00,-0.1551E+00,-0.1689E+00,-0.1828E+00,
     *-0.1969E+00,-0.2110E+00,-0.2253E+00,-0.2397E+00,-0.2540E+00,
     *-0.2681E+00,-0.2819E+00,-0.2954E+00,-0.3087E+00,-0.3217E+00,
     *-0.3341E+00,-0.3459E+00,-0.3572E+00,-0.3677E+00,-0.3774E+00,
     *-0.3862E+00,-0.3903E+00,-0.3941E+00,-0.4010E+00,-0.4069E+00,
     *-0.4116E+00,-0.4151E+00,-0.4173E+00,-0.4181E+00,-0.4173E+00,
     *-0.4152E+00,-0.4119E+00,-0.4070E+00,-0.4004E+00,-0.3924E+00,
     *-0.3831E+00,-0.3721E+00,-0.3595E+00,-0.3460E+00,-0.3313E+00,
     *-0.3152E+00,-0.2982E+00,-0.2804E+00,-0.2616E+00,-0.2422E+00,
     *-0.2225E+00,-0.2020E+00,-0.1821E+00,-0.1631E+00,-0.1440E+00,
     *-0.1252E+00,-0.1069E+00,-0.8852E-01,-0.7094E-01,-0.5451E-01,
     *-0.3645E-01,-0.2061E-01,-0.6627E-02, 0.1133E-01, 0.1676E-01,
     * 0.9972E-02, 0.9494E-02,-0.9754E-20 /
        DATA ((QHR(i,j),j=1,83),i=16,16)/
     *-0.8368E-21, 0.2451E-02, 0.1217E-01, 0.2345E-01, 0.3160E-01,
     * 0.3488E-01, 0.3414E-01, 0.3068E-01, 0.2450E-01, 0.1602E-01,
     * 0.6106E-02,-0.4311E-02,-0.1489E-01,-0.2598E-01,-0.3733E-01,
     *-0.4870E-01,-0.6023E-01,-0.7193E-01,-0.8376E-01,-0.9570E-01,
     *-0.1077E+00,-0.1197E+00,-0.1318E+00,-0.1438E+00,-0.1560E+00,
     *-0.1683E+00,-0.1804E+00,-0.1922E+00,-0.2038E+00,-0.2152E+00,
     *-0.2265E+00,-0.2375E+00,-0.2482E+00,-0.2584E+00,-0.2679E+00,
     *-0.2770E+00,-0.2856E+00,-0.2934E+00,-0.3005E+00,-0.3068E+00,
     *-0.3124E+00,-0.3148E+00,-0.3171E+00,-0.3206E+00,-0.3230E+00,
     *-0.3243E+00,-0.3246E+00,-0.3237E+00,-0.3218E+00,-0.3189E+00,
     *-0.3147E+00,-0.3092E+00,-0.3024E+00,-0.2946E+00,-0.2857E+00,
     *-0.2758E+00,-0.2651E+00,-0.2534E+00,-0.2406E+00,-0.2269E+00,
     *-0.2130E+00,-0.1985E+00,-0.1835E+00,-0.1682E+00,-0.1530E+00,
     *-0.1376E+00,-0.1230E+00,-0.1083E+00,-0.9318E-01,-0.7926E-01,
     *-0.6647E-01,-0.5371E-01,-0.4195E-01,-0.3037E-01,-0.1726E-01,
     *-0.6639E-02, 0.4547E-02, 0.1789E-01, 0.2700E-01, 0.4220E-01,
     * 0.5411E-01, 0.2476E-01,-0.1620E-18 /
        DATA ((QHR(i,j),j=1,83),i=17,17)/
     * 0.3184E-21, 0.3036E-02, 0.1478E-01, 0.2822E-01, 0.3771E-01,
     * 0.4233E-01, 0.4290E-01, 0.3975E-01, 0.3343E-01, 0.2506E-01,
     * 0.1513E-01, 0.4611E-02,-0.5905E-02,-0.1695E-01,-0.2829E-01,
     *-0.3936E-01,-0.5042E-01,-0.6161E-01,-0.7293E-01,-0.8427E-01,
     *-0.9552E-01,-0.1066E+00,-0.1176E+00,-0.1286E+00,-0.1396E+00,
     *-0.1506E+00,-0.1615E+00,-0.1723E+00,-0.1828E+00,-0.1930E+00,
     *-0.2030E+00,-0.2127E+00,-0.2220E+00,-0.2308E+00,-0.2393E+00,
     *-0.2473E+00,-0.2547E+00,-0.2613E+00,-0.2671E+00,-0.2721E+00,
     *-0.2764E+00,-0.2783E+00,-0.2801E+00,-0.2830E+00,-0.2845E+00,
     *-0.2848E+00,-0.2842E+00,-0.2829E+00,-0.2807E+00,-0.2775E+00,
     *-0.2732E+00,-0.2676E+00,-0.2606E+00,-0.2527E+00,-0.2444E+00,
     *-0.2351E+00,-0.2249E+00,-0.2138E+00,-0.2017E+00,-0.1889E+00,
     *-0.1762E+00,-0.1633E+00,-0.1496E+00,-0.1354E+00,-0.1215E+00,
     *-0.1076E+00,-0.9400E-01,-0.8107E-01,-0.6851E-01,-0.5633E-01,
     *-0.4594E-01,-0.3472E-01,-0.2335E-01,-0.1346E-01,-0.1714E-02,
     * 0.8967E-02, 0.1804E-01, 0.3055E-01, 0.3960E-01, 0.4239E-01,
     * 0.4046E-01, 0.1701E-01,-0.8898E-19 /
        DATA ((QHR(i,j),j=1,83),i=18,18)/
     *-0.2087E-21, 0.3408E-02, 0.1699E-01, 0.3431E-01, 0.4812E-01,
     * 0.5671E-01, 0.6062E-01, 0.6023E-01, 0.5559E-01, 0.4753E-01,
     * 0.3769E-01, 0.2687E-01, 0.1572E-01, 0.5064E-02,-0.5211E-02,
     *-0.1539E-01,-0.2524E-01,-0.3472E-01,-0.4388E-01,-0.5283E-01,
     *-0.6171E-01,-0.7056E-01,-0.7935E-01,-0.8798E-01,-0.9634E-01,
     *-0.1044E+00,-0.1124E+00,-0.1202E+00,-0.1279E+00,-0.1354E+00,
     *-0.1425E+00,-0.1491E+00,-0.1554E+00,-0.1613E+00,-0.1669E+00,
     *-0.1719E+00,-0.1764E+00,-0.1805E+00,-0.1841E+00,-0.1871E+00,
     *-0.1893E+00,-0.1901E+00,-0.1907E+00,-0.1915E+00,-0.1917E+00,
     *-0.1915E+00,-0.1903E+00,-0.1882E+00,-0.1851E+00,-0.1812E+00,
     *-0.1766E+00,-0.1716E+00,-0.1661E+00,-0.1597E+00,-0.1524E+00,
     *-0.1444E+00,-0.1358E+00,-0.1266E+00,-0.1175E+00,-0.1082E+00,
     *-0.9801E-01,-0.8756E-01,-0.7742E-01,-0.6735E-01,-0.5708E-01,
     *-0.4707E-01,-0.3691E-01,-0.2738E-01,-0.1892E-01,-0.1086E-01,
     *-0.2282E-02, 0.5347E-02, 0.1293E-01, 0.2113E-01, 0.2784E-01,
     * 0.3647E-01, 0.4476E-01, 0.4847E-01, 0.5261E-01, 0.4889E-01,
     * 0.3218E-01, 0.9915E-02,-0.4202E-19 /
        DATA ((QHR(i,j),j=1,83),i=19,19)/
     *-0.6358E-21, 0.3636E-02, 0.1758E-01, 0.3632E-01, 0.5343E-01,
     * 0.6552E-01, 0.7210E-01, 0.7368E-01, 0.7029E-01, 0.6307E-01,
     * 0.5370E-01, 0.4334E-01, 0.3290E-01, 0.2278E-01, 0.1310E-01,
     * 0.3942E-02,-0.4736E-02,-0.1301E-01,-0.2087E-01,-0.2836E-01,
     *-0.3556E-01,-0.4250E-01,-0.4924E-01,-0.5578E-01,-0.6216E-01,
     *-0.6839E-01,-0.7430E-01,-0.7982E-01,-0.8505E-01,-0.9008E-01,
     *-0.9496E-01,-0.9971E-01,-0.1042E+00,-0.1083E+00,-0.1119E+00,
     *-0.1151E+00,-0.1180E+00,-0.1205E+00,-0.1226E+00,-0.1242E+00,
     *-0.1254E+00,-0.1258E+00,-0.1261E+00,-0.1261E+00,-0.1256E+00,
     *-0.1246E+00,-0.1230E+00,-0.1208E+00,-0.1182E+00,-0.1150E+00,
     *-0.1112E+00,-0.1068E+00,-0.1017E+00,-0.9625E-01,-0.9017E-01,
     *-0.8368E-01,-0.7706E-01,-0.7029E-01,-0.6295E-01,-0.5528E-01,
     *-0.4748E-01,-0.3938E-01,-0.3115E-01,-0.2323E-01,-0.1557E-01,
     *-0.8146E-02,-0.1446E-02, 0.5530E-02, 0.1275E-01, 0.1925E-01,
     * 0.2510E-01, 0.3026E-01, 0.3444E-01, 0.3918E-01, 0.4471E-01,
     * 0.4838E-01, 0.5222E-01, 0.5531E-01, 0.5415E-01, 0.5576E-01,
     * 0.5041E-01, 0.1669E-01, 0.3465E-20 /
        DATA ((QHR(i,j),j=1,83),i=20,20)/
     *-0.3486E-21, 0.3063E-02, 0.1500E-01, 0.3242E-01, 0.5059E-01,
     * 0.6610E-01, 0.7719E-01, 0.8298E-01, 0.8364E-01, 0.8023E-01,
     * 0.7407E-01, 0.6634E-01, 0.5814E-01, 0.5015E-01, 0.4263E-01,
     * 0.3570E-01, 0.2941E-01, 0.2374E-01, 0.1866E-01, 0.1405E-01,
     * 0.9811E-02, 0.5898E-02, 0.2301E-02,-0.9949E-03,-0.4003E-02,
     *-0.6763E-02,-0.9293E-02,-0.1160E-01,-0.1372E-01,-0.1571E-01,
     *-0.1757E-01,-0.1933E-01,-0.2098E-01,-0.2245E-01,-0.2371E-01,
     *-0.2484E-01,-0.2586E-01,-0.2679E-01,-0.2761E-01,-0.2828E-01,
     *-0.2875E-01,-0.2888E-01,-0.2893E-01,-0.2891E-01,-0.2886E-01,
     *-0.2874E-01,-0.2838E-01,-0.2775E-01,-0.2689E-01,-0.2574E-01,
     *-0.2438E-01,-0.2294E-01,-0.2136E-01,-0.1946E-01,-0.1716E-01,
     *-0.1456E-01,-0.1179E-01,-0.8944E-02,-0.6030E-02,-0.2850E-02,
     * 0.8254E-03, 0.4851E-02, 0.8910E-02, 0.1301E-01, 0.1724E-01,
     * 0.2144E-01, 0.2570E-01, 0.3033E-01, 0.3518E-01, 0.3978E-01,
     * 0.4412E-01, 0.4825E-01, 0.5177E-01, 0.5460E-01, 0.5699E-01,
     * 0.5823E-01, 0.5715E-01, 0.5342E-01, 0.4631E-01, 0.3401E-01,
     * 0.1763E-01, 0.3855E-02,-0.5923E-19 /
c************** MIE (phase fun uh) ***************
        DATA ((UHR(i,j),j=1,83),i= 1, 1)/
     *-0.1683E+00,-0.1666E+00,-0.1609E+00,-0.1545E+00,-0.1475E+00,
     *-0.1394E+00,-0.1299E+00,-0.1192E+00,-0.1076E+00,-0.9540E-01,
     *-0.8296E-01,-0.7076E-01,-0.5893E-01,-0.4759E-01,-0.3696E-01,
     *-0.2719E-01,-0.1822E-01,-0.1004E-01,-0.2599E-02, 0.4191E-02,
     * 0.1039E-01, 0.1609E-01, 0.2137E-01, 0.2633E-01, 0.3106E-01,
     * 0.3567E-01, 0.4023E-01, 0.4484E-01, 0.4953E-01, 0.5441E-01,
     * 0.5956E-01, 0.6502E-01, 0.7091E-01, 0.7728E-01, 0.8429E-01,
     * 0.9207E-01, 0.1007E+00, 0.1103E+00, 0.1212E+00, 0.1333E+00,
     * 0.1470E+00, 0.1545E+00, 0.1624E+00, 0.1798E+00, 0.1994E+00,
     * 0.2216E+00, 0.2470E+00, 0.2758E+00, 0.3088E+00, 0.3467E+00,
     * 0.3902E+00, 0.4401E+00, 0.4976E+00, 0.5638E+00, 0.6399E+00,
     * 0.7277E+00, 0.8287E+00, 0.9452E+00, 0.1079E+01, 0.1234E+01,
     * 0.1411E+01, 0.1614E+01, 0.1847E+01, 0.2113E+01, 0.2414E+01,
     * 0.2756E+01, 0.3141E+01, 0.3571E+01, 0.4049E+01, 0.4575E+01,
     * 0.5149E+01, 0.5768E+01, 0.6424E+01, 0.7111E+01, 0.7816E+01,
     * 0.8524E+01, 0.9220E+01, 0.9895E+01, 0.1056E+02, 0.1134E+02,
     * 0.1287E+02, 0.2031E+02, 0.5392E+02 /
        DATA ((UHR(i,j),j=1,83),i= 2, 2)/
     *-0.1692E+00,-0.1675E+00,-0.1617E+00,-0.1561E+00,-0.1509E+00,
     *-0.1451E+00,-0.1383E+00,-0.1303E+00,-0.1215E+00,-0.1119E+00,
     *-0.1019E+00,-0.9168E-01,-0.8136E-01,-0.7113E-01,-0.6131E-01,
     *-0.5187E-01,-0.4284E-01,-0.3436E-01,-0.2636E-01,-0.1881E-01,
     *-0.1167E-01,-0.4909E-02, 0.1533E-02, 0.7717E-02, 0.1373E-01,
     * 0.1963E-01, 0.2550E-01, 0.3138E-01, 0.3742E-01, 0.4363E-01,
     * 0.5018E-01, 0.5710E-01, 0.6449E-01, 0.7247E-01, 0.8112E-01,
     * 0.9063E-01, 0.1011E+00, 0.1126E+00, 0.1254E+00, 0.1398E+00,
     * 0.1558E+00, 0.1646E+00, 0.1739E+00, 0.1944E+00, 0.2176E+00,
     * 0.2438E+00, 0.2737E+00, 0.3075E+00, 0.3461E+00, 0.3899E+00,
     * 0.4399E+00, 0.4967E+00, 0.5615E+00, 0.6352E+00, 0.7194E+00,
     * 0.8153E+00, 0.9245E+00, 0.1049E+01, 0.1190E+01, 0.1351E+01,
     * 0.1532E+01, 0.1737E+01, 0.1968E+01, 0.2228E+01, 0.2518E+01,
     * 0.2840E+01, 0.3196E+01, 0.3587E+01, 0.4014E+01, 0.4475E+01,
     * 0.4967E+01, 0.5488E+01, 0.6031E+01, 0.6589E+01, 0.7152E+01,
     * 0.7712E+01, 0.8260E+01, 0.8799E+01, 0.9365E+01, 0.1012E+02,
     * 0.1185E+02, 0.2001E+02, 0.4940E+02 /
        DATA ((UHR(i,j),j=1,83),i= 3, 3)/
     *-0.1705E+00,-0.1687E+00,-0.1628E+00,-0.1573E+00,-0.1524E+00,
     *-0.1469E+00,-0.1406E+00,-0.1332E+00,-0.1248E+00,-0.1159E+00,
     *-0.1064E+00,-0.9649E-01,-0.8643E-01,-0.7656E-01,-0.6697E-01,
     *-0.5761E-01,-0.4865E-01,-0.4014E-01,-0.3205E-01,-0.2439E-01,
     *-0.1710E-01,-0.1016E-01,-0.3480E-02, 0.2951E-02, 0.9236E-02,
     * 0.1540E-01, 0.2154E-01, 0.2771E-01, 0.3404E-01, 0.4057E-01,
     * 0.4741E-01, 0.5465E-01, 0.6238E-01, 0.7075E-01, 0.7981E-01,
     * 0.8974E-01, 0.1007E+00, 0.1127E+00, 0.1261E+00, 0.1412E+00,
     * 0.1579E+00, 0.1671E+00, 0.1768E+00, 0.1980E+00, 0.2221E+00,
     * 0.2494E+00, 0.2802E+00, 0.3152E+00, 0.3550E+00, 0.4001E+00,
     * 0.4514E+00, 0.5098E+00, 0.5763E+00, 0.6517E+00, 0.7376E+00,
     * 0.8352E+00, 0.9461E+00, 0.1072E+01, 0.1214E+01, 0.1376E+01,
     * 0.1557E+01, 0.1762E+01, 0.1992E+01, 0.2249E+01, 0.2535E+01,
     * 0.2852E+01, 0.3200E+01, 0.3582E+01, 0.3996E+01, 0.4442E+01,
     * 0.4916E+01, 0.5416E+01, 0.5936E+01, 0.6467E+01, 0.7003E+01,
     * 0.7534E+01, 0.8054E+01, 0.8569E+01, 0.9120E+01, 0.9879E+01,
     * 0.1166E+02, 0.2002E+02, 0.4863E+02 /
        DATA ((UHR(i,j),j=1,83),i= 4, 4)/
     *-0.1751E+00,-0.1732E+00,-0.1670E+00,-0.1615E+00,-0.1570E+00,
     *-0.1524E+00,-0.1472E+00,-0.1409E+00,-0.1338E+00,-0.1258E+00,
     *-0.1174E+00,-0.1086E+00,-0.9941E-01,-0.9014E-01,-0.8106E-01,
     *-0.7211E-01,-0.6334E-01,-0.5492E-01,-0.4679E-01,-0.3893E-01,
     *-0.3135E-01,-0.2403E-01,-0.1693E-01,-0.9997E-02,-0.3159E-02,
     * 0.3634E-02, 0.1045E-01, 0.1733E-01, 0.2443E-01, 0.3174E-01,
     * 0.3944E-01, 0.4756E-01, 0.5622E-01, 0.6557E-01, 0.7570E-01,
     * 0.8684E-01, 0.9909E-01, 0.1126E+00, 0.1277E+00, 0.1445E+00,
     * 0.1632E+00, 0.1733E+00, 0.1841E+00, 0.2076E+00, 0.2340E+00,
     * 0.2637E+00, 0.2972E+00, 0.3350E+00, 0.3777E+00, 0.4261E+00,
     * 0.4808E+00, 0.5428E+00, 0.6130E+00, 0.6924E+00, 0.7821E+00,
     * 0.8834E+00, 0.9977E+00, 0.1126E+01, 0.1271E+01, 0.1433E+01,
     * 0.1615E+01, 0.1817E+01, 0.2043E+01, 0.2292E+01, 0.2568E+01,
     * 0.2870E+01, 0.3199E+01, 0.3556E+01, 0.3939E+01, 0.4348E+01,
     * 0.4780E+01, 0.5230E+01, 0.5693E+01, 0.6165E+01, 0.6636E+01,
     * 0.7103E+01, 0.7563E+01, 0.8029E+01, 0.8553E+01, 0.9339E+01,
     * 0.1129E+02, 0.2013E+02, 0.4703E+02 /
        DATA ((UHR(i,j),j=1,83),i= 5, 5)/
     *-0.1805E+00,-0.1785E+00,-0.1720E+00,-0.1662E+00,-0.1618E+00,
     *-0.1579E+00,-0.1535E+00,-0.1481E+00,-0.1417E+00,-0.1349E+00,
     *-0.1274E+00,-0.1191E+00,-0.1106E+00,-0.1021E+00,-0.9344E-01,
     *-0.8482E-01,-0.7640E-01,-0.6808E-01,-0.5996E-01,-0.5207E-01,
     *-0.4438E-01,-0.3685E-01,-0.2944E-01,-0.2211E-01,-0.1483E-01,
     *-0.7576E-02,-0.2282E-03, 0.7266E-02, 0.1500E-01, 0.2306E-01,
     * 0.3148E-01, 0.4044E-01, 0.5002E-01, 0.6036E-01, 0.7158E-01,
     * 0.8377E-01, 0.9721E-01, 0.1121E+00, 0.1285E+00, 0.1467E+00,
     * 0.1671E+00, 0.1781E+00, 0.1898E+00, 0.2152E+00, 0.2437E+00,
     * 0.2756E+00, 0.3115E+00, 0.3518E+00, 0.3972E+00, 0.4482E+00,
     * 0.5057E+00, 0.5705E+00, 0.6434E+00, 0.7255E+00, 0.8178E+00,
     * 0.9214E+00, 0.1038E+01, 0.1168E+01, 0.1313E+01, 0.1475E+01,
     * 0.1655E+01, 0.1855E+01, 0.2075E+01, 0.2318E+01, 0.2583E+01,
     * 0.2872E+01, 0.3185E+01, 0.3521E+01, 0.3879E+01, 0.4259E+01,
     * 0.4657E+01, 0.5068E+01, 0.5490E+01, 0.5916E+01, 0.6342E+01,
     * 0.6763E+01, 0.7181E+01, 0.7615E+01, 0.8129E+01, 0.8956E+01,
     * 0.1107E+02, 0.2036E+02, 0.4604E+02 /
        DATA ((UHR(i,j),j=1,83),i= 6, 6)/
     *-0.1851E+00,-0.1831E+00,-0.1763E+00,-0.1704E+00,-0.1661E+00,
     *-0.1625E+00,-0.1585E+00,-0.1536E+00,-0.1479E+00,-0.1413E+00,
     *-0.1341E+00,-0.1265E+00,-0.1186E+00,-0.1102E+00,-0.1019E+00,
     *-0.9357E-01,-0.8525E-01,-0.7711E-01,-0.6908E-01,-0.6115E-01,
     *-0.5335E-01,-0.4566E-01,-0.3810E-01,-0.3058E-01,-0.2305E-01,
     *-0.1545E-01,-0.7721E-02, 0.1950E-03, 0.8363E-02, 0.1688E-01,
     * 0.2589E-01, 0.3542E-01, 0.4561E-01, 0.5655E-01, 0.6843E-01,
     * 0.8143E-01, 0.9566E-01, 0.1113E+00, 0.1287E+00, 0.1479E+00,
     * 0.1693E+00, 0.1809E+00, 0.1932E+00, 0.2198E+00, 0.2496E+00,
     * 0.2830E+00, 0.3203E+00, 0.3622E+00, 0.4093E+00, 0.4621E+00,
     * 0.5214E+00, 0.5879E+00, 0.6625E+00, 0.7461E+00, 0.8398E+00,
     * 0.9446E+00, 0.1062E+01, 0.1192E+01, 0.1338E+01, 0.1499E+01,
     * 0.1678E+01, 0.1875E+01, 0.2091E+01, 0.2329E+01, 0.2587E+01,
     * 0.2867E+01, 0.3169E+01, 0.3493E+01, 0.3836E+01, 0.4197E+01,
     * 0.4574E+01, 0.4962E+01, 0.5359E+01, 0.5759E+01, 0.6157E+01,
     * 0.6553E+01, 0.6949E+01, 0.7368E+01, 0.7881E+01, 0.8738E+01,
     * 0.1097E+02, 0.2056E+02, 0.4552E+02 /
        DATA ((UHR(i,j),j=1,83),i= 7, 7)/
     *-0.1939E+00,-0.1918E+00,-0.1844E+00,-0.1782E+00,-0.1740E+00,
     *-0.1707E+00,-0.1672E+00,-0.1628E+00,-0.1577E+00,-0.1518E+00,
     *-0.1453E+00,-0.1384E+00,-0.1309E+00,-0.1230E+00,-0.1152E+00,
     *-0.1072E+00,-0.9906E-01,-0.9106E-01,-0.8309E-01,-0.7515E-01,
     *-0.6723E-01,-0.5937E-01,-0.5153E-01,-0.4368E-01,-0.3574E-01,
     *-0.2767E-01,-0.1942E-01,-0.1095E-01,-0.2114E-02, 0.7110E-02,
     * 0.1689E-01, 0.2727E-01, 0.3836E-01, 0.5030E-01, 0.6322E-01,
     * 0.7734E-01, 0.9277E-01, 0.1097E+00, 0.1284E+00, 0.1491E+00,
     * 0.1720E+00, 0.1845E+00, 0.1975E+00, 0.2260E+00, 0.2578E+00,
     * 0.2932E+00, 0.3328E+00, 0.3769E+00, 0.4263E+00, 0.4816E+00,
     * 0.5433E+00, 0.6121E+00, 0.6890E+00, 0.7746E+00, 0.8701E+00,
     * 0.9763E+00, 0.1094E+01, 0.1225E+01, 0.1370E+01, 0.1529E+01,
     * 0.1705E+01, 0.1898E+01, 0.2108E+01, 0.2338E+01, 0.2586E+01,
     * 0.2853E+01, 0.3139E+01, 0.3443E+01, 0.3764E+01, 0.4100E+01,
     * 0.4448E+01, 0.4806E+01, 0.5169E+01, 0.5535E+01, 0.5898E+01,
     * 0.6261E+01, 0.6631E+01, 0.7033E+01, 0.7553E+01, 0.8466E+01,
     * 0.1088E+02, 0.2095E+02, 0.4501E+02 /
        DATA ((UHR(i,j),j=1,83),i= 8, 8)/
     *-0.2078E+00,-0.2055E+00,-0.1975E+00,-0.1903E+00,-0.1858E+00,
     *-0.1828E+00,-0.1800E+00,-0.1764E+00,-0.1720E+00,-0.1669E+00,
     *-0.1610E+00,-0.1545E+00,-0.1477E+00,-0.1405E+00,-0.1329E+00,
     *-0.1252E+00,-0.1175E+00,-0.1096E+00,-0.1017E+00,-0.9372E-01,
     *-0.8572E-01,-0.7766E-01,-0.6952E-01,-0.6124E-01,-0.5284E-01,
     *-0.4421E-01,-0.3533E-01,-0.2609E-01,-0.1648E-01,-0.6367E-02,
     * 0.4304E-02, 0.1569E-01, 0.2791E-01, 0.4108E-01, 0.5538E-01,
     * 0.7092E-01, 0.8791E-01, 0.1066E+00, 0.1271E+00, 0.1496E+00,
     * 0.1746E+00, 0.1881E+00, 0.2023E+00, 0.2330E+00, 0.2670E+00,
     * 0.3049E+00, 0.3471E+00, 0.3939E+00, 0.4461E+00, 0.5040E+00,
     * 0.5683E+00, 0.6398E+00, 0.7190E+00, 0.8069E+00, 0.9040E+00,
     * 0.1011E+01, 0.1130E+01, 0.1260E+01, 0.1403E+01, 0.1560E+01,
     * 0.1731E+01, 0.1917E+01, 0.2120E+01, 0.2338E+01, 0.2572E+01,
     * 0.2823E+01, 0.3089E+01, 0.3370E+01, 0.3665E+01, 0.3971E+01,
     * 0.4287E+01, 0.4610E+01, 0.4935E+01, 0.5263E+01, 0.5590E+01,
     * 0.5919E+01, 0.6262E+01, 0.6653E+01, 0.7195E+01, 0.8206E+01,
     * 0.1089E+02, 0.2157E+02, 0.4463E+02 /
        DATA ((UHR(i,j),j=1,83),i= 9, 9)/
     *-0.2255E+00,-0.2229E+00,-0.2138E+00,-0.2058E+00,-0.2011E+00,
     *-0.1982E+00,-0.1958E+00,-0.1927E+00,-0.1888E+00,-0.1846E+00,
     *-0.1795E+00,-0.1735E+00,-0.1671E+00,-0.1605E+00,-0.1535E+00,
     *-0.1462E+00,-0.1387E+00,-0.1310E+00,-0.1232E+00,-0.1153E+00,
     *-0.1072E+00,-0.9901E-01,-0.9058E-01,-0.8192E-01,-0.7302E-01,
     *-0.6387E-01,-0.5434E-01,-0.4439E-01,-0.3392E-01,-0.2284E-01,
     *-0.1112E-01, 0.1434E-02, 0.1493E-01, 0.2953E-01, 0.4533E-01,
     * 0.6244E-01, 0.8117E-01, 0.1017E+00, 0.1241E+00, 0.1489E+00,
     * 0.1761E+00, 0.1907E+00, 0.2061E+00, 0.2392E+00, 0.2758E+00,
     * 0.3163E+00, 0.3610E+00, 0.4104E+00, 0.4651E+00, 0.5254E+00,
     * 0.5920E+00, 0.6657E+00, 0.7469E+00, 0.8362E+00, 0.9344E+00,
     * 0.1042E+01, 0.1160E+01, 0.1289E+01, 0.1430E+01, 0.1583E+01,
     * 0.1748E+01, 0.1927E+01, 0.2119E+01, 0.2325E+01, 0.2545E+01,
     * 0.2779E+01, 0.3024E+01, 0.3281E+01, 0.3549E+01, 0.3826E+01,
     * 0.4110E+01, 0.4398E+01, 0.4689E+01, 0.4981E+01, 0.5275E+01,
     * 0.5577E+01, 0.5901E+01, 0.6294E+01, 0.6874E+01, 0.8007E+01,
     * 0.1103E+02, 0.2244E+02, 0.4453E+02 /
        DATA ((UHR(i,j),j=1,83),i=10,10)/
     *-0.2466E+00,-0.2436E+00,-0.2333E+00,-0.2244E+00,-0.2192E+00,
     *-0.2163E+00,-0.2141E+00,-0.2115E+00,-0.2082E+00,-0.2043E+00,
     *-0.1998E+00,-0.1946E+00,-0.1887E+00,-0.1825E+00,-0.1760E+00,
     *-0.1691E+00,-0.1618E+00,-0.1544E+00,-0.1467E+00,-0.1388E+00,
     *-0.1307E+00,-0.1223E+00,-0.1136E+00,-0.1046E+00,-0.9524E-01,
     *-0.8549E-01,-0.7529E-01,-0.6458E-01,-0.5320E-01,-0.4114E-01,
     *-0.2824E-01,-0.1442E-01, 0.3993E-03, 0.1642E-01, 0.3373E-01,
     * 0.5256E-01, 0.7304E-01, 0.9537E-01, 0.1199E+00, 0.1468E+00,
     * 0.1762E+00, 0.1919E+00, 0.2084E+00, 0.2439E+00, 0.2829E+00,
     * 0.3258E+00, 0.3729E+00, 0.4247E+00, 0.4815E+00, 0.5440E+00,
     * 0.6125E+00, 0.6877E+00, 0.7701E+00, 0.8601E+00, 0.9584E+00,
     * 0.1066E+01, 0.1182E+01, 0.1309E+01, 0.1446E+01, 0.1594E+01,
     * 0.1753E+01, 0.1924E+01, 0.2106E+01, 0.2300E+01, 0.2505E+01,
     * 0.2721E+01, 0.2947E+01, 0.3182E+01, 0.3426E+01, 0.3676E+01,
     * 0.3931E+01, 0.4189E+01, 0.4450E+01, 0.4713E+01, 0.4982E+01,
     * 0.5264E+01, 0.5581E+01, 0.5989E+01, 0.6627E+01, 0.7906E+01,
     * 0.1130E+02, 0.2350E+02, 0.4472E+02 /
        DATA ((UHR(i,j),j=1,83),i=11,11)/
     *-0.2671E+00,-0.2639E+00,-0.2524E+00,-0.2420E+00,-0.2360E+00,
     *-0.2330E+00,-0.2312E+00,-0.2290E+00,-0.2261E+00,-0.2228E+00,
     *-0.2188E+00,-0.2136E+00,-0.2081E+00,-0.2023E+00,-0.1960E+00,
     *-0.1893E+00,-0.1823E+00,-0.1750E+00,-0.1673E+00,-0.1594E+00,
     *-0.1512E+00,-0.1426E+00,-0.1337E+00,-0.1243E+00,-0.1145E+00,
     *-0.1043E+00,-0.9346E-01,-0.8205E-01,-0.6991E-01,-0.5697E-01,
     *-0.4322E-01,-0.2843E-01,-0.1248E-01, 0.4781E-02, 0.2342E-01,
     * 0.4355E-01, 0.6549E-01, 0.8940E-01, 0.1154E+00, 0.1439E+00,
     * 0.1750E+00, 0.1916E+00, 0.2091E+00, 0.2463E+00, 0.2871E+00,
     * 0.3318E+00, 0.3807E+00, 0.4342E+00, 0.4928E+00, 0.5566E+00,
     * 0.6263E+00, 0.7024E+00, 0.7854E+00, 0.8755E+00, 0.9734E+00,
     * 0.1080E+01, 0.1194E+01, 0.1318E+01, 0.1452E+01, 0.1595E+01,
     * 0.1748E+01, 0.1912E+01, 0.2085E+01, 0.2268E+01, 0.2462E+01,
     * 0.2665E+01, 0.2875E+01, 0.3094E+01, 0.3319E+01, 0.3550E+01,
     * 0.3785E+01, 0.4023E+01, 0.4263E+01, 0.4507E+01, 0.4761E+01,
     * 0.5034E+01, 0.5354E+01, 0.5782E+01, 0.6483E+01, 0.7919E+01,
     * 0.1166E+02, 0.2455E+02, 0.4508E+02 /
        DATA ((UHR(i,j),j=1,83),i=12,12)/
     *-0.2816E+00,-0.2782E+00,-0.2661E+00,-0.2548E+00,-0.2481E+00,
     *-0.2450E+00,-0.2432E+00,-0.2411E+00,-0.2386E+00,-0.2351E+00,
     *-0.2310E+00,-0.2265E+00,-0.2214E+00,-0.2155E+00,-0.2092E+00,
     *-0.2026E+00,-0.1956E+00,-0.1884E+00,-0.1808E+00,-0.1728E+00,
     *-0.1644E+00,-0.1557E+00,-0.1466E+00,-0.1371E+00,-0.1270E+00,
     *-0.1164E+00,-0.1052E+00,-0.9330E-01,-0.8071E-01,-0.6727E-01,
     *-0.5284E-01,-0.3740E-01,-0.2079E-01,-0.2916E-02, 0.1647E-01,
     * 0.3753E-01, 0.6036E-01, 0.8519E-01, 0.1122E+00, 0.1416E+00,
     * 0.1737E+00, 0.1909E+00, 0.2089E+00, 0.2472E+00, 0.2889E+00,
     * 0.3346E+00, 0.3844E+00, 0.4388E+00, 0.4981E+00, 0.5628E+00,
     * 0.6333E+00, 0.7096E+00, 0.7926E+00, 0.8827E+00, 0.9802E+00,
     * 0.1085E+01, 0.1199E+01, 0.1321E+01, 0.1452E+01, 0.1592E+01,
     * 0.1741E+01, 0.1900E+01, 0.2068E+01, 0.2246E+01, 0.2432E+01,
     * 0.2626E+01, 0.2828E+01, 0.3038E+01, 0.3252E+01, 0.3472E+01,
     * 0.3695E+01, 0.3921E+01, 0.4151E+01, 0.4386E+01, 0.4631E+01,
     * 0.4900E+01, 0.5225E+01, 0.5673E+01, 0.6420E+01, 0.7960E+01,
     * 0.1193E+02, 0.2524E+02, 0.4537E+02 /
        DATA ((UHR(i,j),j=1,83),i=13,13)/
     *-0.3231E+00,-0.3191E+00,-0.3044E+00,-0.2904E+00,-0.2822E+00,
     *-0.2784E+00,-0.2767E+00,-0.2749E+00,-0.2725E+00,-0.2699E+00,
     *-0.2664E+00,-0.2619E+00,-0.2568E+00,-0.2515E+00,-0.2455E+00,
     *-0.2391E+00,-0.2323E+00,-0.2249E+00,-0.2171E+00,-0.2090E+00,
     *-0.2004E+00,-0.1913E+00,-0.1816E+00,-0.1714E+00,-0.1606E+00,
     *-0.1491E+00,-0.1370E+00,-0.1240E+00,-0.1102E+00,-0.9530E-01,
     *-0.7947E-01,-0.6242E-01,-0.4403E-01,-0.2415E-01,-0.2749E-02,
     * 0.2029E-01, 0.4528E-01, 0.7237E-01, 0.1017E+00, 0.1336E+00,
     * 0.1682E+00, 0.1864E+00, 0.2056E+00, 0.2462E+00, 0.2904E+00,
     * 0.3383E+00, 0.3902E+00, 0.4465E+00, 0.5074E+00, 0.5731E+00,
     * 0.6440E+00, 0.7208E+00, 0.8036E+00, 0.8925E+00, 0.9879E+00,
     * 0.1090E+01, 0.1200E+01, 0.1316E+01, 0.1440E+01, 0.1572E+01,
     * 0.1711E+01, 0.1858E+01, 0.2012E+01, 0.2174E+01, 0.2342E+01,
     * 0.2517E+01, 0.2698E+01, 0.2883E+01, 0.3073E+01, 0.3267E+01,
     * 0.3465E+01, 0.3667E+01, 0.3874E+01, 0.4091E+01, 0.4328E+01,
     * 0.4601E+01, 0.4951E+01, 0.5466E+01, 0.6362E+01, 0.8219E+01,
     * 0.1287E+02, 0.2742E+02, 0.4654E+02 /
        DATA ((UHR(i,j),j=1,83),i=14,14)/
     *-0.3870E+00,-0.3820E+00,-0.3635E+00,-0.3450E+00,-0.3336E+00,
     *-0.3280E+00,-0.3257E+00,-0.3238E+00,-0.3216E+00,-0.3193E+00,
     *-0.3162E+00,-0.3121E+00,-0.3073E+00,-0.3021E+00,-0.2965E+00,
     *-0.2900E+00,-0.2831E+00,-0.2756E+00,-0.2676E+00,-0.2591E+00,
     *-0.2500E+00,-0.2403E+00,-0.2298E+00,-0.2187E+00,-0.2068E+00,
     *-0.1941E+00,-0.1806E+00,-0.1662E+00,-0.1507E+00,-0.1340E+00,
     *-0.1162E+00,-0.9703E-01,-0.7642E-01,-0.5423E-01,-0.3043E-01,
     *-0.4862E-02, 0.2265E-01, 0.5229E-01, 0.8431E-01, 0.1189E+00,
     * 0.1559E+00, 0.1754E+00, 0.1957E+00, 0.2387E+00, 0.2851E+00,
     * 0.3348E+00, 0.3882E+00, 0.4456E+00, 0.5071E+00, 0.5729E+00,
     * 0.6432E+00, 0.7186E+00, 0.7990E+00, 0.8845E+00, 0.9754E+00,
     * 0.1072E+01, 0.1174E+01, 0.1282E+01, 0.1396E+01, 0.1516E+01,
     * 0.1642E+01, 0.1773E+01, 0.1910E+01, 0.2052E+01, 0.2200E+01,
     * 0.2352E+01, 0.2509E+01, 0.2669E+01, 0.2835E+01, 0.3005E+01,
     * 0.3179E+01, 0.3361E+01, 0.3554E+01, 0.3765E+01, 0.4010E+01,
     * 0.4316E+01, 0.4739E+01, 0.5399E+01, 0.6569E+01, 0.8955E+01,
     * 0.1466E+02, 0.3092E+02, 0.4862E+02 /
        DATA ((UHR(i,j),j=1,83),i=15,15)/
     *-0.5767E+00,-0.5675E+00,-0.5318E+00,-0.4900E+00,-0.4589E+00,
     *-0.4414E+00,-0.4325E+00,-0.4271E+00,-0.4230E+00,-0.4193E+00,
     *-0.4158E+00,-0.4119E+00,-0.4072E+00,-0.4016E+00,-0.3952E+00,
     *-0.3882E+00,-0.3806E+00,-0.3723E+00,-0.3632E+00,-0.3534E+00,
     *-0.3428E+00,-0.3313E+00,-0.3190E+00,-0.3058E+00,-0.2917E+00,
     *-0.2766E+00,-0.2605E+00,-0.2431E+00,-0.2248E+00,-0.2052E+00,
     *-0.1844E+00,-0.1624E+00,-0.1390E+00,-0.1141E+00,-0.8766E-01,
     *-0.5953E-01,-0.2973E-01, 0.1805E-02, 0.3501E-01, 0.7009E-01,
     * 0.1074E+00, 0.1270E+00, 0.1470E+00, 0.1886E+00, 0.2322E+00,
     * 0.2785E+00, 0.3272E+00, 0.3784E+00, 0.4322E+00, 0.4890E+00,
     * 0.5486E+00, 0.6108E+00, 0.6761E+00, 0.7449E+00, 0.8168E+00,
     * 0.8919E+00, 0.9705E+00, 0.1053E+01, 0.1140E+01, 0.1230E+01,
     * 0.1324E+01, 0.1424E+01, 0.1529E+01, 0.1639E+01, 0.1755E+01,
     * 0.1878E+01, 0.2010E+01, 0.2154E+01, 0.2310E+01, 0.2482E+01,
     * 0.2677E+01, 0.2904E+01, 0.3178E+01, 0.3521E+01, 0.3972E+01,
     * 0.4601E+01, 0.5536E+01, 0.7019E+01, 0.9541E+01, 0.1418E+02,
     * 0.2350E+02, 0.4319E+02, 0.5584E+02 /
        DATA ((UHR(i,j),j=1,83),i=16,16)/
     *-0.6058E+00,-0.5946E+00,-0.5508E+00,-0.4965E+00,-0.4520E+00,
     *-0.4228E+00,-0.4053E+00,-0.3942E+00,-0.3865E+00,-0.3809E+00,
     *-0.3762E+00,-0.3717E+00,-0.3671E+00,-0.3620E+00,-0.3564E+00,
     *-0.3500E+00,-0.3428E+00,-0.3350E+00,-0.3266E+00,-0.3174E+00,
     *-0.3075E+00,-0.2969E+00,-0.2855E+00,-0.2733E+00,-0.2602E+00,
     *-0.2463E+00,-0.2315E+00,-0.2159E+00,-0.1993E+00,-0.1816E+00,
     *-0.1629E+00,-0.1430E+00,-0.1220E+00,-0.9988E-01,-0.7664E-01,
     *-0.5214E-01,-0.2643E-01, 0.7463E-03, 0.2965E-01, 0.6005E-01,
     * 0.9169E-01, 0.1081E+00, 0.1249E+00, 0.1600E+00, 0.1971E+00,
     * 0.2359E+00, 0.2766E+00, 0.3194E+00, 0.3645E+00, 0.4119E+00,
     * 0.4617E+00, 0.5146E+00, 0.5701E+00, 0.6283E+00, 0.6899E+00,
     * 0.7556E+00, 0.8252E+00, 0.8988E+00, 0.9776E+00, 0.1063E+01,
     * 0.1153E+01, 0.1251E+01, 0.1357E+01, 0.1472E+01, 0.1599E+01,
     * 0.1740E+01, 0.1895E+01, 0.2071E+01, 0.2271E+01, 0.2504E+01,
     * 0.2778E+01, 0.3109E+01, 0.3521E+01, 0.4046E+01, 0.4745E+01,
     * 0.5712E+01, 0.7112E+01, 0.9242E+01, 0.1266E+02, 0.1847E+02,
     * 0.2900E+02, 0.4746E+02, 0.5654E+02 /
        DATA ((UHR(i,j),j=1,83),i=17,17)/
     *-0.5984E+00,-0.5867E+00,-0.5407E+00,-0.4824E+00,-0.4333E+00,
     *-0.4002E+00,-0.3797E+00,-0.3663E+00,-0.3571E+00,-0.3504E+00,
     *-0.3452E+00,-0.3410E+00,-0.3365E+00,-0.3314E+00,-0.3259E+00,
     *-0.3197E+00,-0.3130E+00,-0.3059E+00,-0.2981E+00,-0.2895E+00,
     *-0.2802E+00,-0.2702E+00,-0.2596E+00,-0.2483E+00,-0.2361E+00,
     *-0.2230E+00,-0.2091E+00,-0.1945E+00,-0.1790E+00,-0.1626E+00,
     *-0.1451E+00,-0.1265E+00,-0.1071E+00,-0.8671E-01,-0.6516E-01,
     *-0.4238E-01,-0.1840E-01, 0.6810E-02, 0.3332E-01, 0.6119E-01,
     * 0.9053E-01, 0.1058E+00, 0.1215E+00, 0.1541E+00, 0.1884E+00,
     * 0.2243E+00, 0.2621E+00, 0.3020E+00, 0.3441E+00, 0.3888E+00,
     * 0.4361E+00, 0.4857E+00, 0.5378E+00, 0.5931E+00, 0.6526E+00,
     * 0.7162E+00, 0.7841E+00, 0.8567E+00, 0.9346E+00, 0.1019E+01,
     * 0.1111E+01, 0.1211E+01, 0.1320E+01, 0.1442E+01, 0.1576E+01,
     * 0.1725E+01, 0.1895E+01, 0.2089E+01, 0.2311E+01, 0.2571E+01,
     * 0.2878E+01, 0.3253E+01, 0.3722E+01, 0.4319E+01, 0.5105E+01,
     * 0.6187E+01, 0.7737E+01, 0.1006E+02, 0.1371E+02, 0.1976E+02,
     * 0.3036E+02, 0.4765E+02, 0.5552E+02 /
        DATA ((UHR(i,j),j=1,83),i=18,18)/
     *-0.5521E+00,-0.5399E+00,-0.4910E+00,-0.4261E+00,-0.3694E+00,
     *-0.3292E+00,-0.3030E+00,-0.2853E+00,-0.2727E+00,-0.2638E+00,
     *-0.2573E+00,-0.2520E+00,-0.2473E+00,-0.2428E+00,-0.2380E+00,
     *-0.2332E+00,-0.2280E+00,-0.2221E+00,-0.2158E+00,-0.2090E+00,
     *-0.2017E+00,-0.1938E+00,-0.1853E+00,-0.1761E+00,-0.1665E+00,
     *-0.1563E+00,-0.1453E+00,-0.1336E+00,-0.1211E+00,-0.1079E+00,
     *-0.9412E-01,-0.7967E-01,-0.6432E-01,-0.4798E-01,-0.3074E-01,
     *-0.1255E-01, 0.6715E-02, 0.2704E-01, 0.4837E-01, 0.7090E-01,
     * 0.9491E-01, 0.1074E+00, 0.1203E+00, 0.1470E+00, 0.1751E+00,
     * 0.2051E+00, 0.2371E+00, 0.2710E+00, 0.3070E+00, 0.3454E+00,
     * 0.3865E+00, 0.4307E+00, 0.4786E+00, 0.5304E+00, 0.5861E+00,
     * 0.6462E+00, 0.7119E+00, 0.7842E+00, 0.8637E+00, 0.9510E+00,
     * 0.1049E+01, 0.1158E+01, 0.1280E+01, 0.1418E+01, 0.1574E+01,
     * 0.1752E+01, 0.1957E+01, 0.2194E+01, 0.2473E+01, 0.2803E+01,
     * 0.3198E+01, 0.3678E+01, 0.4272E+01, 0.5025E+01, 0.6008E+01,
     * 0.7326E+01, 0.9156E+01, 0.1179E+02, 0.1576E+02, 0.2198E+02,
     * 0.3205E+02, 0.4585E+02, 0.5119E+02 /
        DATA ((UHR(i,j),j=1,83),i=19,19)/
     *-0.4886E+00,-0.4774E+00,-0.4325E+00,-0.3705E+00,-0.3132E+00,
     *-0.2692E+00,-0.2385E+00,-0.2168E+00,-0.2012E+00,-0.1902E+00,
     *-0.1821E+00,-0.1759E+00,-0.1711E+00,-0.1671E+00,-0.1633E+00,
     *-0.1593E+00,-0.1550E+00,-0.1504E+00,-0.1454E+00,-0.1402E+00,
     *-0.1346E+00,-0.1285E+00,-0.1219E+00,-0.1149E+00,-0.1073E+00,
     *-0.9929E-01,-0.9078E-01,-0.8176E-01,-0.7214E-01,-0.6190E-01,
     *-0.5100E-01,-0.3936E-01,-0.2691E-01,-0.1377E-01, 0.6039E-04,
     * 0.1462E-01, 0.2999E-01, 0.4641E-01, 0.6409E-01, 0.8289E-01,
     * 0.1026E+00, 0.1129E+00, 0.1235E+00, 0.1461E+00, 0.1705E+00,
     * 0.1965E+00, 0.2244E+00, 0.2545E+00, 0.2869E+00, 0.3219E+00,
     * 0.3598E+00, 0.4014E+00, 0.4468E+00, 0.4963E+00, 0.5505E+00,
     * 0.6109E+00, 0.6778E+00, 0.7523E+00, 0.8358E+00, 0.9299E+00,
     * 0.1035E+01, 0.1154E+01, 0.1289E+01, 0.1443E+01, 0.1621E+01,
     * 0.1827E+01, 0.2064E+01, 0.2340E+01, 0.2665E+01, 0.3050E+01,
     * 0.3512E+01, 0.4072E+01, 0.4761E+01, 0.5626E+01, 0.6735E+01,
     * 0.8192E+01, 0.1016E+02, 0.1289E+02, 0.1684E+02, 0.2266E+02,
     * 0.3152E+02, 0.4198E+02, 0.4560E+02 /
        DATA ((UHR(i,j),j=1,83),i=20,20)/
     *-0.3196E+00,-0.3128E+00,-0.2855E+00,-0.2438E+00,-0.1991E+00,
     *-0.1599E+00,-0.1282E+00,-0.1026E+00,-0.8219E-01,-0.6633E-01,
     *-0.5402E-01,-0.4447E-01,-0.3721E-01,-0.3163E-01,-0.2718E-01,
     *-0.2343E-01,-0.2005E-01,-0.1687E-01,-0.1383E-01,-0.1089E-01,
     *-0.7955E-02,-0.4932E-02,-0.1737E-02, 0.1654E-02, 0.5222E-02,
     * 0.9004E-02, 0.1308E-01, 0.1754E-01, 0.2240E-01, 0.2764E-01,
     * 0.3327E-01, 0.3941E-01, 0.4619E-01, 0.5358E-01, 0.6158E-01,
     * 0.7025E-01, 0.7974E-01, 0.9017E-01, 0.1017E+00, 0.1144E+00,
     * 0.1283E+00, 0.1357E+00, 0.1436E+00, 0.1605E+00, 0.1793E+00,
     * 0.2003E+00, 0.2236E+00, 0.2496E+00, 0.2786E+00, 0.3110E+00,
     * 0.3472E+00, 0.3883E+00, 0.4348E+00, 0.4871E+00, 0.5462E+00,
     * 0.6134E+00, 0.6898E+00, 0.7771E+00, 0.8773E+00, 0.9922E+00,
     * 0.1124E+01, 0.1275E+01, 0.1450E+01, 0.1652E+01, 0.1886E+01,
     * 0.2157E+01, 0.2473E+01, 0.2839E+01, 0.3268E+01, 0.3773E+01,
     * 0.4366E+01, 0.5063E+01, 0.5892E+01, 0.6882E+01, 0.8075E+01,
     * 0.9525E+01, 0.1130E+02, 0.1350E+02, 0.1626E+02, 0.1969E+02,
     * 0.2340E+02, 0.2626E+02, 0.2704E+02 /


      do 1 i=1,20
       asy(1,i)=asy_m(i)
       ex(1,i)=ex_m(i)
       sc(1,i)=sc_m(i)
      do 1 j=1,nquad
      ph(i,j)=phr(i,j)
      qh(i,j)=qhr(i,j)
      uh(i,j)=uhr(i,j)
    1 continue
      return
      end
